//Updated March 8th 2020

// ----------------------------------------------------------------------------
// ---------------------------------------------- Index (ctrl+F to find these):
// ----------------------------------------------------------------------------

// ---------------------------------------------- Section 0: Credits

// ---------------------------------------------- Section 1: const int declarations
// ---------------------------------------------- Section 1B: Relist of above ->Misc[] attributes for ease of checking

// ---------------------------------------------- Section 2: Global int and bool declarations

// ---------------------------------------------- Section 3: Global scope functions

// ---------------------------------------------- Section 4: Global script 
// Global script has it's own index of chapters

// ---------------------------------------------- Section 5: Item scripts

// ---------------------------------------------- Section 6: FFC scripts



// ---------------------------------------------- Section 0: Credits



// --- Quest creator:
// Mitsukara

// --- Major improvements / design assistance / lots of scripts
// Dimi

// --- Rando design advice:
// Moosh
// HeroOfFire
// Russ

// --- Beta testers:
// Dimi
// Moosh
// HeroOfFire
// GreatGlass
// Russ
// Zaxarone
// Shane
// Avaro

// --- Scripts by:
// Dimi: The final boss, various scripts related to the final boss, Dynamic Weather mode, NewWavy modes, Cursed Pictobox and Recursed Pictobox Z3 Scrolling modes, ENV_DARK Mode, Randomizer mode
// Moosh: "4 Way Curse" function from Brock Lesnar.qst, helpful functions and scripts to help make Randomizer mode a thing.
// LinkTheMaster: FFC Shooter script (used by Dimi)
// Venrob: "All Caps" function, some help with how to format scripts
// ZoriaRPG: Classic.zh, Magic Compass and Magic Map items, general advice
// Avaro: No actual scripts used but gave a cool idea for the method to script a one-time upgrade shop, the "OnceOnlyShop" FFC script
// All other scripts by Mitsukara

// --- Music:
// Infidelity: LegendOfLink.nsf from Legend of Link NES romhack
// Bigjoe: 5thmusic.nsf from Zelda Classic 5th quest
// IsabelleChiming: z1remade.nsf and z2remade.nsf
// Klopp422 & Klopp422's brother: zeldansf-1.nsf
// PhD RtC: SMB Remix (SMB PhD RTC.nsf), SML Remix (SML PhD RTC.nsf)
// --- Additional music by:
// Koji "Konchan" Kondo: "The Legend of Zelda", "Super Mario Bros", "A Link to the Past", "BS The Legend of Zelda"
// Akito "Tsukasan" Nakatsuka: "Zelda II: The Adventure of Link"
// Yuzo Koshiro: "Legacy of the Wizard", "Ys" I-II
// Mieko Ishikawa: "Legacy of the Wizard", "Ys" I-III
// Hideya Nagata: "Ys" II-III
// Osamu Kasai: "Ys" II-III
// Masaaki Harada: "Ys" II-III
// Shinji Nakayama: "Ys" II-III
// Hideno Maezawa: "Knightmare II: The Maze of Galious"
// Shinya Sakamoto: "Knightmare II: The Maze of Galious"
// Atsushi Fujio: "Knightmare II: The Maze of Galious"
// Kiyohirio Sada: "Knightmare II: The Maze of Galious"
// Kinuya Yamashita: "Knightmare II: The Maze of Galious"
// Hideki Kanazashi: "Adventures of Lolo" 1 - 3
// Michiharu Hasuya: "Solomon's Key"
// Hiro "Hip" Tanaka: Super Mario Land
// Koichi Sugiyama: "Dragon Quest" I-IV
// Satoe Terashima: "Castlevania," "Castlevania II: Simon's Quest"
// Kinuyo Yamashita: "Castlevania"
// Kenichi Matsubara: "Castlevania II: Simon's Quest"
// Kouji Murata: "Castlevania II: Simon's Quest"

// --- Some graphics from:
// ExplodingRabbit: Zelda player sprites from Super Mario Crossover
// P-Tux: Darknut Naga sprites (also thanks for "BS Grave" combo ideas)
// Moosh: Kell and Riggs costumes (characters by Russ from "Depths of Malice")
// Aevin: Holm costume (from Hitodama, Yuurei, Yuurand, et al)
// Shane: Moosh and Yoshi costumes
// Mani Kanina: Eevee and "Self Insert" costumes
// Zaxarone: Gardea costume

// --- Special thanks:
// MeleeWizard: Helping me get back into ZC through Let's Play videos
// Russ
// Moosh
// Dimi
// HeroOfFire 

// --- Zelda Classic creator:
// Phantom Menace
// --- Zelda Classic developers:
// WarLord
// DarkNation
// DarkDragon
// Gleeok
// jman2050
// Joe123
// Koopa
// _L_
// PKMNFRK
// Saffith
// Sean
// Takuya
// Venrob
// Wolfman2000
// ZoriaRPG

// --- Original Legend of Zelda by Nintendo


// ---------------------------------------------- Section 1: const int declarations

// --- Miscellaneous
const int CT_SIDECLIMB = 143;		// Sideview ladder climbing combos. Currently uses CT_SCRIPT2.
const int CR_LINKSTUN = 8;		// Counter ID for Link being stunned. Currently using CR_SCRIPT2.
const int CR_CLOCK = 14;		// Counter ID for Link having picked up a clock. Currently using CR_SCRIPT8.
const int SFX_PLAYERFALL = 66;		// Sound effect for the player falling in sideview
const int SFX_CRUMBLE = 85;		// Sound effect used by ZII Dropblocks FFC script
const int MISC_NPCSHOOT = 4;		// NPC->Misc[] index used as a timer for creating weapons on NPCs which do not normally have weapon-firing capabilities, such as NPCT_KEESE, etc
const int LEEVER_TILE = 96;		// Tile used to identify a Leever enemy when it is submerged.
const int DMAP_FIRST_DUNGEON = 3;	// First of the NES dungeon dmaps. Used to prevent Bow-wow from wandering into screen edges and getting destroyed, and also by the Environment bitmap drawing modes to know when to draw dungeon edge borders.
const int DMAP_LAST_DUNGEON = 11;	// Last of the NES dungeon dmaps. Used for the same purposes as above, but ends the range of maps that applies to.
const int DMAP_FAKE_LAST = 25;		// Fake last NES dungeon dmaps; Used for the same purposes as above, but is an extra in the range of maps that applies to.
const int DMAP_CAVES = 1;		// First non-overworld dmap; checked by Environment Weather Rain mode to know to draw only on the overworld.
const int DMAP_FINALBATTLE = 54;	// Dmap used for the final battle, checked by the Mode Menu to display the extra line of warning text about how the mode menu affects the battle.
const int DMAP_FISHING = 2;		// Dmap used for fishing on the overworld. Checked to affect how Z3 scrolling cooperates with ENV_SKEW to draw Link.
const int DMAP_FISHING_D = 24;		// Dmap used for fishing in Level D. Checked to affect how Z3 scrolling cooperates with ENV_SKEW to draw Link.
const int DMAP_PASSAGEWAYS1 = 12;	// Dmap used for dungeon passageways in Level A-1. Starts a set of dmaps checked to affect how Z3 scrolling draws Link.
const int DMAP_PASSAGEWAYS9 = 20;	// Dmap used for dungeon passageways in Level D-9. Ends a set of dmaps checked to affect how Z3 scrolling draws Link.
const int DMAP_SHAFT = 57;		// Dmap used for "the shaft" area of level D-9. Checked to affect how Z3 scrolling draws Link.
const int REMEMBER_HP = 1;		// RememberStuff[] array index for storing Link's Max HP.
const int REMEMBER_BOWWOWOFF = 2;	// RememberStuff[] array index for whether BowWow (Gleeok) is on or off.
const int REMEMBER_RAIN = 8;		// RememberStuff[] array index for whether to play Rain in screen 80 caves.
const int REMEMBER_TITLE = 9;		// RememberStuff[] array index for what title to display in screen 80 caves.
const int REMEMBER_GLEEOK_X = 13;		// RememberStuff[] array index for gleeok's last X position (used for drawing necks in environment modes).
const int REMEMBER_GLEEOK_Y = 14;		// RememberStuff[] array index for gleeok's last X position (used for drawing necks in environment modes).
const int REMEMBER_GLEEOK_ID = 15;		// RememberStuff[] array index for gleeok's last ID (used for drawing necks in environment modes).
const int REMEMBER_GLEEOK_CSET = 16;		// RememberStuff[] array index for gleeok's last ID (used for drawing necks in environment modes).
const int REMEMBER_SCROLLING = 17;		// Z3-scrolling smooth scrolling
const int REMEMBER_SCROLLDIR = 18;		// Z3-scrolling smooth scrolling
const int REMEMBER_SCROLL_X = 19;		// Z3-scrolling smooth scrolling
const int REMEMBER_SCROLL_Y = 20;		// Z3-scrolling smooth scrolling
const int REMEMBER_LINKPROMPT = 21;		// Environment mode cutscene fix
const int REMEMBER_ENEMYNAMEWAIT = 22;		// Global version of enemy stuff.
const int REMEMBER_DIGDELAY = 23;		// Global version of enemy stuff.
const int REMEMBER_BOWWOW_EATDELAY = 24;	// Global version of enemy stuff.
const int REMEMBER_WHISPWAIT = 25;		// Global version of enemy stuff.
const int REMEMBER_BEINGHURT = 26;		// Global version of enemy stuff.
const int REMEMBER_ROOMDATA2 = 27;		// Stores the latest Screen->RoomData unless the player is on Screen >= 128.
const int REMEMBER_ROOMTYPE2 = 28;		// Stores the latest Screen->RoomType unless the player is on Screen >= 128.
const int REMEMBER_SCREEN = 29;			// Stores the last overworld screen the player was on.
const int REMEMBER_XORSHIFT_X = 30;		// Internal Rando stuff
const int REMEMBER_XORSHIFT_Y = 31;		// Internal Rando stuff
const int REMEMBER_ISRANDO = 32;		// Whether game is randomized
const int REMEMBER_GANN_ARROW = 33;		// Whether Link got the item from ganon in rando
const int REMEMBER_BRANG = 34;			// Whether the rando seed generated magic or regular boomerang
const int REMEMBER_SEED1 = 35;			// Part 1 of the Seed generated
const int REMEMBER_SEED2 = 36;			// Part 2 of the Seed generated
const int REMEMBER_SEED3 = 37;			// Part 1 of the Seed generated
const int REMEMBER_SEED4 = 38;			// Part 2 of the Seed generated
const int REMEMBER_EX3_SPOILERLOG = 41;		// Whether the player has set the randomizer's spoiler log to be displayed with the EX3 button.
const int REMEMBER_RANDO_OPTIONS = 320;		// Start of Rando options. Don't use indices above this for non-rando things.
const int REMEMBER_RANDO_SHOPSAVE = 300;	// Start of the "got item from shop" indices.
const int REMEMBER_RANDOSTART = 336;		// The start of the indices that store the rando items. Originally used SetComboData, but that doesn't carry over between loads.
						// 	Assume everything past this range is used by rando.

// --- Half heart passive subscreen stuff
const int TILE_HUD_HEARTOVERLAY = 20784;// A row of four tiles used on the passive subscreen on top of the life meter.
const int TILE_HUD_NOHALVES = 20764;	// A row of four semi-blank tiles to copy over the above when Link doesn't have a half-heart container.
const int TILE_HUD_HALFHEART = 20540;	// A row of four tiles where the fourth heart ends in a black half-piece to cover up half of the last heart container.
// NOTE: The next 12 rows on the tile page after TILE_HUD_HALFHEART will be used for subsequent half-hearts.

// --- Itemsets used to set enemy size
const int IS_BIGENEMY = 24;		// npc->ItemSet checked for setting an enemy to 2x2 size from the enemy editor.
const int IS_FOURTALL = 25;		// npc->ItemSet checked for setting an enemy to 1x4 size from the enemy editor.
const int IS_THREETALL = 26;		// npc->ItemSet checked for setting an enemy to 1x3 size from the enemy editor.
const int IS_TWOTALL = 27;		// npc->ItemSet checked for setting an enemy to 1x2 size from the enemy editor.
const int IS_FOURWIDE = 28;		// npc->ItemSet checked for setting an enemy to 4x1 size from the enemy editor.

// --- Windy Screen effects
const int SP_WINDY = 115;		// Weapon sprite for windy screens
const int SFX_WINDY = 59;		// Sound effect to play for windy (currently uses Whistle Whirlwind slot)

// --- Growing Manhandala FFC script
const int HEAD_DOWN_A = 1;		// Used by "Growing Mandhandla" FFC script in the array "ManOffset[]".
const int HEAD_DOWN_B = 2;		// Used by "Growing Mandhandla" FFC script in the array "ManOffset[]".
const int HEAD_DOWN_C = 3;		// Used by "Growing Mandhandla" FFC script in the array "ManOffset[]".
const int HEAD_LEFT_A = 4;		// Used by "Growing Mandhandla" FFC script in the array "ManOffset[]".
const int HEAD_LEFT_B = 5;		// Used by "Growing Mandhandla" FFC script in the array "ManOffset[]".
const int HEAD_LEFT_C = 6;		// Used by "Growing Mandhandla" FFC script in the array "ManOffset[]".
const int HEAD_RIGHT_A = 7; 		// Used by "Growing Mandhandla" FFC script in the array "ManOffset[]".
const int HEAD_RIGHT_B = 8;		// Used by "Growing Mandhandla" FFC script in the array "ManOffset[]".
const int HEAD_RIGHT_C = 9;		// Used by "Growing Mandhandla" FFC script in the array "ManOffset[]".

// --- Cane of Somaria item
const int I_SOMARIACANE1 = 150;		// Cane of Somaria 1 item ID
const int I_SOMARIACANE2 = 151;		// Cane of Somaria 2 item ID
const int I_SOMARIACANE3 = 152;		// Cane of Somaria 3 item ID
const int I_SOMARIABOOK = 32;		// Book of Somaria item ID (makes beams when destroying block). Currently uses I_BOOK.
const int LW_SOMARIA = 35;		// Somaria Block LWeapon type. Currently using LW_SCRIPT5.
const int SP_SOMARIABLOCK = 97;		// Block of Somaria sprite.
const int SP_SOMARIABEAM = 105;		// Cane of Somaria beam weapon sprite (vertical).
const int SP_SOMARIABEAMSIDE = 136;	// Cane of Somaria beam weapon sprite (horizontal).
const int SFX_SOMARIA = 63;		// Cane of Somaria block being placed / removed.

// --- Medicine item
const int I_BLUEMEDICINE = 172;		// Medicine Item ID
const int I_REDMEDICINE = 173;		// Medicine 2 Item ID
const int I_MEDICINECLOCK = 239;	// Clock created at Link's position when medicine automatically goes into effect

// --- Hiding Shellmet item
const int CR_SHELLMET = 12;		// Counter ID for Hiding Shelmet display. Currently using CR_SCRIPT6.
const int I_SHELLMET = 175;		// Hiding Shellmet Item ID
const int SHELLMET_TILE = 19798;	// Hiding Shellmet tile to draw.

// --- Guardian Acorns item
const int CR_ACORNS = 7;		// Counter ID for guardian acorns. Currently using CR_SCRIPT1.
const int I_GUARDIANACORN = 174;	// Guardian Acorn Item ID
const int I_ACORNBLUE = 17;		// Blue ring item ID given by Guardian acorn. Currnetly using I_RING1.
const int I_ACORNRED = 18;		// Red ring item ID given by Guardian acorn. Currently using I_RING2.
const int I_MAGICACORN = 198;		// A "magic acorn" or red ring item that makes the acorn counter always full.

// --- Handy Glove item
const int CT_HANDYBLOCK = 144;		// Handy glove block combo type (break with sword). Currently uses CT_SCRIPT3.
const int I_HANDYGLOVE = 169;		// Handy glove item ID

// --- Lantern item
const int I_LANTERN = 171;		// Lantern Item ID
const int LANTERN_TILE = 20055;		// 5x5 tile block drawn around Link when the lantern is on.

// --- Alternate bait ID
const int I_BAIT2 = 209;		// Vanilla item editor item, used because the defualt bait has a higher timer than the original

// --- Bola item
const int LW_BOLA = 33;			// Bola LWeapon type. Currently using LW_SCRIPT3.
const int MISC_BOLA = 1;		// LWeapon->Misc[] used for a Bola movement timer, on LW_BOLA weapons only.

// --- Bola (enemy weapon version)
const int EW_BOLA = 31;			// Enemy bola EWeapon type. Currently using EW_SCRIPT1.
const int IS_BOLA = 13;			// npc->ItemSet used for switching an enemy's weapon type to EW_BOLA.
const int EWBOLA_ORIGINAL_TILE = 19880;	// First tile of the enemy bola animation.
const int SP_EWBOLA = 123;		// Enemy bola weapon sprite. Must start with EWBOLA_ORIGINAL_TILE.
const int MISC_EWBOLA = 1;		// EWeapon->Misc[] used for a Bola movement timer, on EW_BOLA weapons only.

// --- Stationary enemy bombs
const int EW_STATIONARYBOMB = 32;	// Eweapon type used for enemies laying bombs on the ground (Sluggula bombs). Currently using EW_SCRIPT2.
const int IS_STATIONARYBOMB = 14;	// npc->ItemSet used for switching an enemy's weapon type to EW_STATIONARYBOMB.
const int SP_EWSTATIONARYBOMB = 124;	// Enemy stationary bomb weapon sprite.
const int MISC_STATIONARYFUSE = 1;	// EWeapon->Misc[] used for the stationary bomb's detonation timer, on EW_STATIONARYBOMB weapons only.

// --- Mace (enemy weapon)
const int EW_MACE = 33;			// Enemy mace EWeapon type (bouncing Doomknocker maces). Currently using EW_SCRIPT3.
const int IS_MACE = 15;			// npc->ItemSet used for switching an enemy's weapon type to EW_MACE.
const int MISC_EWMACE = 1;		// EWeapon->Misc[] used for a Morning Star timeout, on EW_MACE weapons only.
const int SP_MACE = 126;		// Enemy mace weapon sprite.

// --- Somaria Block (enemy weapon version)
const int EW_SOMARIA = 34;		// Enemy somaria block EWeapon type. Currently using EW_SCRIPT4.
const int MISC_EWSOMARIA = 1;		// EWeapon->Misc[] used to wait to blow up the block, on EW_SOMARIA weapons only.
const int SP_EWSOMARIA = 127;		// Sprite to use for Enemy Somaria blocks.
const int IS_SOMARIA = 16;		// npc->ItemSet used for switching an enemy's weapon type to EW_SOMARIA.

// --- "Turn floor into spikes" enemy weapon
const int EW_SPIKES = 35;		// Enemy weapon that turns floor into spikes. Currently using EW_SCRIPT5.
const int COMBO_SPIKES = 5337;		// Spikes combo to turn floor into.
const int IS_SPIKES = 17;		// npc->ItemSet used for switching an enemy's weapon type to EW_SPIKES.

// --- "Turn floor into conveyor" enemy weapon
const int EW_CONVEYOR = 36;		// Enemy weapon that turns floor into conveyors. Currently using EW_SCRIPT6.
const int COMBO_CONVEYOR = 5300;	// Spikes combo to turn floor into. The following three combos are also used randomly.
const int IS_CONVEYOR = 18;		// npc->ItemSet used for switching an enemy's weapon type to EW_SPIKES.

// --- Armos item
const int I_ARMOS = 188;		// Armos item ID
const int LW_ARMOS = 38;		// Armos LWeapon type. Currently uses LW_SCRIPT8.
const int SP_ARMOS = 117;		// Armos weapon sprite (moving).
const int SP_ARMOSWAKE = 116;		// Armos weapon sprite (mid-activation).
const int SP_ARMOSSLEEP = 122;		// Armos weapon sprite (deactivated).
// ArmosStatus[] array indexes
const int FRIEND_TIMER = 1;		// Armos movement timer
const int FRIEND_IFRAMES = 2;		// Armos invincibility frames after getting hit
const int FRIEND_STARTX = 3;		// Armos Wake-up X position
const int FRIEND_STARTY = 4;		// Armos Wake-up Y position
const int FRIEND_LINK_STARTX = 5;	// Link's X position when Armos wakes up
const int FRIEND_LINK_STARTY = 6;	// Link's Y position when Armos wakes up
const int FRIEND_GOX = 7;		// Armos X to go to
const int FRIEND_GOY = 8;		// Armos Y to go to
const int FRIEND_HP = 9;		// Armos HP
const int FRIEND_SNOOZE = 10;		// Checked when Armos is deactivated
// --- RememberArmos[] incidices:
const int REMEMBER_ARMOS_MAP = 1;
const int REMEMBER_ARMOS_SCREEN = 2;
const int REMEMBER_ARMOS_X = 3;
const int REMEMBER_ARMOS_Y = 4;

// --- Big Armos obstacles
const int NPC_BIGARMOS = 236;		// NPC ID for Big Armos to be spawned by "Big Armos" FFC script
const int BIGARMOS_TILE = 10282;	// Tile usde to draw Big Armos when waking up, in the "Big Armos" FFC Script

// --- Beetle Keese item
const int I_BEETLE = 153;		// Beetle 1 Item ID
const int I_STRONGBEETLE = 154;		// Beetle 2 Item ID
const int LW_BEETLE = 31;		// Beetle LWeapon type. Currently using LW_SCRIPT1.
const int SP_BEETLE = 89;		// Beetle 1 Weapon sprite
const int SP_STRONGBEETLE = 90;		// Beetle 2 Weapon sprite
const int SP_BEETLECARRY = 91;		// Beetle 1 carrying an object sprite
const int SP_STRONGCARRY = 92;		// Beetle 2 carrying an object sprite
const int SP_BEETLEPOOF = 93;		// Beetle destroyed sprite
const int SFX_BEETLE = 4;		// Sound effect played by deploying the beetle. Currently using SFX_BRANG.
//const int SFX_BEETLE = 62;		// Actual beetle sound, included in the quest but not used.
const int BEETLE_RANGE = 48;		// Range limit of Beetle 1. LaZPoC range was 64.

// --- Rope item
const int I_ROPE1 = 213;		// Rope 1 (Short Ladder) Item ID. This is unused in the quest, but functional, allowing climbing through solids only if they are water combos or ladder combos.
const int I_ROPE2 = 214;		// Rope 2 (Long Ladder) Item ID. This is unused in the quest, and similar to I_ROPE1 but with the same extending power as I_ROPE4.
const int I_ROPE3 = 176;		// Rope 3 (Short Snake) Item ID. This is the first Rope item used in the quest.
const int I_ROPE4 = 177;		// Rope 4 (Long Snake) Item ID. This is the second Rope item used in the quest.
const int SFX_ROPE = 73;		// Sound effect for the Rope item.
const int LW_ROPE = 32;			// Rope LWeapon type. Currently using LW_SCRIPT2.
const int CF_ROPE = 102;		// Combo flag to allow the rope to climb over something with ComboF or ComboI. Currently using CF_SCRIPT5.
// Note: The Rope sprites are set in the arguments of the item script which deploys the rope.

// --- Ladder item
// By Dimi
const int LW_LADDER = 34;		// Ladder LWeapon type. Currently using LW_SCRIPT4.
const int I_LADDER9 = 227;		// Used for Ladder sideview shenanigans scripted by Dimi.
const int SP_LADDERVERTICAL = 174;	// Sprite for Ladder.
const int TILE_LADDER = 22920;		// Tile for Ladder

// --- Enemy "firing" LWeapons (usde by Good Octorok item)
const int MISC_NPCLWEAPON = 2;		// NPC->Misc[] attribute to use for firing an lweapon instead of a weapon; used for Octorok item
const int MISC_NPCLWEAPONSPRITE = 3;	// NPC->Misc[] attribute to use for lweapon sprites; used for Octorok item
const int MISC_NPCLWEAPONTIMER = 4;	// NPC->Misc[] attribute to use for waiting for firing an lweapon.
const int MISC_TEMPNOCOLLIDELW = 2;	// LWeapon->Misc[] attribute to use for temporary deactivation of collision detection.

// --- FFC Script MoldormBehavior & FFC SCript CrazyPatra
const int MISC_NPCTURNWAIT = 5;		// NPC->Misc[] index used as a timer for turning (by NPC_GUMA1 & NPC_GUMA2, NPC_MOBY1 & NPC_MOBY2 (to spawn at top of screen), NPC_DEELER1 & NPC_DEELER2 (also to spawn at top of screen), FFC Script MoldormBehavior, and FFC Script CrazyPatra)
const int MISC_SEGMENTLAG = 9;		// NPC->Misc[] index used by CrazyPatra FFC for segment lag.

// --- Cane of Somaria item IDs
const int I_CANE1 = 150;		// Level 1 Cane of Somaria
const int I_CANE2 = 151;		// Level 2 Cane of Somaria
const int I_CANE3 = 152;		// Level 3 Cane of Somaria

// --- Octorok item IDs (Octorock)
const int I_OCTOROK1 = 162;		// Level 1 Friendly Octorok
const int I_OCTOROK2 = 163;		// Level 2 Friendly Octorok

// --- Bola item IDs
const int I_BOLA1 = 159;		// Level 1 Bolas
const int I_BOLA2 = 160;		// Level 2 Bolas

// --- Somaria Peril Beam item ID
const int I_SOMARIAPERIL = 237;		// LEvel 3 Cane of Somaria

// --- Cane of Somaria raft combo stuff
const int COMBO_SOMARIADOCK = 5428;
const int I_SOMARIARAFT = 210;
const int TILE_SOMARIARAFT = 19964;

// --- Cane of Byrna (Patra) item IDs
const int I_CBYRNA2 = 164;		// Level 2 Cane of Byrna
const int I_CBYRNA3 = 215;		// Level 3 Cane of Byrna (Alternates with Level 2 usage via script)
const int TILE_PATRA = 192;		// Patra tile to draw in rooms with byrna attachment points where you can detach on top of water

// --- Partner mode and LTTP Superbomb
const int I_PARTNER = 205;		// Item ID for LTTP Superbomb
const int PARTNER_COMBO = 5652;		// Partner combo to draw (3 rows of 4 combos)
const int I_LTTPSBOMB = 203;		// Item ID for LTTP Superbomb
const int LTTPSBOMB_TILE = 19812;	// Superbomb Tile to draw (row of two)
const int SFX_LTTPSBOMB = 80;		// Sound effect for detonation.
const int FA_WALKING = 4;		// Follower action for walking. Offsets follower's drawn combo graphic. Not used by Superbomb.
const int FA_ATTACKING = 8;		// Follower action for shooting. Offsets follower's drawn combo graphic. Not used by Superbomb.
const int SFX_SWITCHHOOK = 81;		// Sound effect played when swapping places with partner.
const int SP_BLINKARROW = 130;		// Blinking arrow used when swapping places with partner.
const int SP_PARTNERSIDEBEAM = 134;	// Sideways swordbeam sprite for partner to use.
const int PARTNER_WEAPON = 2;		// Weapon for partner to fire (currently LW_BEAM)

//indicies for Partner[];
const int FOLLOW_X = 1;			// Follower's X
const int FOLLOW_Y = 2;			// Follower's Y
const int FOLLOW_TIMER = 3;		// Superbomb's invisible timer
const int FOLLOW_DISPLAY = 4;		// Superbomb's visible timer
const int FOLLOW_STATE = 5;		// Follower's status (whether to follow Link or not)
const int FOLLOW_SCREEN = 6;		// Follower checks screen
const int FOLLOW_MAP = 7;		// Follower checks map
const int FOLLOW_DIR = 8;		// Follower's direction
const int FOLLOW_ACTION = 9;		// Follower's action
const int FOLLOW_ATIMER = 10;		// Follower's action timeout
const int FOLLOW_SHOOT = 11;		// Follower's shot delay
const int STORE_FOLLOW_X = 12;		// Stores follower's X when swapping positions with Link
const int STORE_FOLLOW_Y = 13;		// Stores follower's Y when swapping positions with Link
const int STORE_COSTUME = 14;		//Stores CR_COSTUME when swapping positions with Link

// --- Shovel item
const int I_SHOVEL1 = 155;		// Shovel item ID.
const int I_SHOVEL2 = 156;		// Level 2 shovel (creates LW_LEEVER).
const int LW_LEEVER = 36;		// LWeapon type for Magic Bean leevers. Currently using LW_SCRIPT6.
const int SP_LEEVER = 112;		// Leever weapon sprite.
const int SHOVEL_TILE = 19821;		// Shovel digging animation starting tile.
const int SP_SHOVELDIRT = 101;		// Shovel dirt sparkle weapon sprite
const int SFX_SHOVEL = 71;		// Sound effect for shovel when digging successfully.
const int SHOVEL_POTHOLE = 5636;	// Combo for the shovel to leave behind after digging.
const int MISC_SHOVELFIND = 1;		// LWeapon->Misc[] used for randomly finding items with the shovel, on shovel dirt sparkle lweapons only.
const int CF_SHOVELSECRET = 9;		// Flag for digging up a secret combo (RoomData). Currenly uses CF_ARMOSSECRET.
const int CF_SHOVELITEM = 13;		// Flag for digging up a secret item (RoomData). Currenly uses CF_DIVEITEM.
const int CT_DIGDIRT = 142;		// Combo type for diggable dirt. Currently uses CT_SCRIPT1.
const int MSG_BOWWOW = 50;		// Message for Bow-Wow to display when on a buried secret.

const int SAND_POTHOLE = 5640;		// Alternate shovel pothole to display on sandy tiles.
const int SAND_COMBO_START = 5367;	// Sandy combos which use SAND_POTHOLE start here.
const int SAND_COMBO_END = 5395;	// Sandy combos which use SAND_POTHOLE end here.

// --- Unscriped pickup items
// Used for shovel spawns, minigames, and fishing.
const int I_RUPOOR = 185;		// Rupoor item ID (used by shovel on very rare occasions). Non-scriped rupee that reduces Link's rupees by 1, although a line of the global script (search for "underflow") prevents this from underflowing the rupee counter (collecting -1 at 0 rupees goes to 65535.)
const int I_HEARTTWO = 186;		// Blue Heart Item ID. Non-sripted heart that gives two hearts.
const int I_NEGAHEART = 193;		// Negative heart item ID. Non scripted heart that reduces Link's health by a heart.
const int I_CATCHGAME = 211;		// Rupee worth 0; used in guy rooms to initiate the Catch minigame.
const int I_RUPOORTEN = 235;		// Rupoor item ID (used by shovel on very rare occasions). Non-scriped rupee that reduces Link's rupees by 10, although a line of the global script (search for "underflow") prevents this from underflowing the rupee counter (collecting -1 at 0 rupees goes to 65535.)
const int I_NEGAFAIRY = 236;		// Negative heart item ID. Non scripted heart that reduces Link's health by a heart.

// --- Pegasus boots item
const int I_PEGASUS = 157;		// Pegasus Boots 1 Item ID
const int I_SUPERPEGASUS = 158;		// Pegasus Boots 2 Item ID 
const int SP_PEGASUSDUST = 102;		// Pegasus Boots Dust sprite
const int SP_PEGASUSBREAK = 104;	// Pegaus Boots breaking an obstacle sprite
const int CT_PEGASUSOBSTACLE = 9;	// A combo type which the Pegasus Boots can break, replacing with Screen->Undercombo. Currently uses CT_PUSHHEAVY.
const int SFX_PEGASUS = 68;		// Pegaus Boots dash sound effect
const int SFX_PEGABONK = 9;		// Pegasus Boots bonk sound effect (current is shutter door)
const int SFX_SHATTERING = 70;		// Pegasus boots break something sound effect. Also used by Handy Glove.
const int SFX_PEGAITEM = 69;		// Sound to play when Pegasus boots spawn an item.
const int CF_PEGASTOP = 98;		// Flag for preventing dashing with the Pegasus boots. Currently uses CF_SCRIPT1. Also stops the hiding shell from being drawn.
const int CF_PEGASUSSECRET = 9;		// Flag for breaking a Pegasus Obstacle to reveal a secret combo (RoomData). Currenly uses CF_ARMOSSECRET.
const int CF_PEGASUSITEM = 13;		// Flag for boot-bonking to spawn a secret item (RoomData). Currenly uses CF_DIVEITEM.
const int REMEMBER_BONKS = 10;		// RememberStuff[] index for listing the total number of Pegasus Bonks (up to 65535).
const int COMBO_HORSE = 5724;		// First in a set of of combos used to draw horse over player when alternate item graphics mode is on. 
						// +0 == horse standing (up, 1x2 tile)
						// +1 == horse standing (down, 1x2 tile)
						// +2 == horse standing (left, 2x2 tile)
						// +3 == horse standing (right, 2x2 tile)
						// +4 == horse walking (up, 1x2 tile)
						// +5 == horse walking (down, 1x2 tile)
						// +6 == unused
						// +7 == unused
						// +8 == horse walking (left, left half, 1x2)
						// +9 == horse walking (left, right half, 1x2)
						// +10 == horse walking (right, left half, 1x2)
						// +11 == horse walking (right, right half, 1x2

// --- Pegasus boots lanmola trail item
const int SP_LANMOLATAIL = 103;		// Lanmola tail damage sprite for Pegasus Boots Dust
const int SP_LANMOLAHEAD = 129;		// Lanmola head damage sprite for Pegasus Boots stabbing
const int LW_LANMOLA = 37;		// LWeapon type for Pegasus Boots Lanmola tail. Currently using LW_SCRIPT7.
const int MISC_LWTIMEOUT = 3;		// Lweapon->Misc[] attribute to remove an lweapon when time is elapsed.

// --- Candle burns combos flag
const int CF_BURNCOMBO = 100;		// Combo flag that causes things burned by Link's fires to become the screen undercombo. Currently uses CF_SCRIPT3.

// --- Fishing Rod item
const int I_FISHINGROD = 161;		// Fishing rod Item ID
const int FISHINGROD_TILE = 19901;	// Fishing rod animation starting tile.
const int COMBO_RAFT = 5948;		// Combo for Sideview Raft
const int TILE_RAFT = 22924;		// Combo for Sideview Raft

// --- Boots items
//const int I_BOOTS = 55;		Vanilla STD_CONSTANTS boots identifier, used in this global. This item's Power is changed based on a scripted effect of slowly using up rupees to prevent spike damage.
const int I_BOOTSTWO = 170;		// Level 2 boot item. These are vanilla "infinite" boots, but are checked to prevent the script from draining rupees on spikes.

// --- Tablet Fragment items
const int I_FRAGMENT = 224;		// Tablet Fragment pickup item ID.
const int I_FRAGMENT_SUBSCREEN = 225;	// Tablet Fragment item ID displayed on the subscreen.

// --- Auto Life Refill mode
//const int I_HEARTRING1 = 112;		Vanilla STD_CONSTANTS heart ring 1 identifier, used by the mode menu for Auto Life Refill.
const int AUTOLIFE_TILE = 19855;	// Tile used by the mode menu for Auto Life Refilll mode.

// --- Full Starting Hearts mode
const int I_STARTHEARTS = 194;		// Full Starting Hearts mode item ID
const int STARTHEARTS_TILE = 19858;	// Tile used by the mode menu for Full Starting Hearts mode.

// --- Magic weapon sprites, for using correct directions when spawned
const int SP_MAGICUP = 16;
const int SP_MAGICDOWN = 158;
const int SP_MAGICLEFT = 159;
const int SP_MAGICRIGHT = 160;

// --- Tougher Monsters mode
const int I_TOUGHMONSTERS = 183;	// Tough Monsters mode item ID
const int MISC_TOUGHENEMY = 1;		// npc->Misc[] attribute used to set the tough enemy status once to each npc.
const int TOUGHER_TILE = 19857;		// Tile used by the mode menu for Tougher Monsters mode.
const int I_WEAKMONSTERS = 240;		// Easy Monsters mode item ID
const int WEAKER_TILE = 19925;		// Tile used by the mode menu for Tougher Monsters mode.

// --- See Enemy HP mode
const int I_HEROCHARM = 212;		// See Enemy HP mode item ID (Hero's Charm)
const int MISC_HP_REDUCE = 10;		// NPC->Misc[] index used by the "See Enemy HP" mode, as set by the SetEnemyHP FFC, to display only the HP remaining before the SetEnemyHP will reduce them to 0. This exists only to deal with Patras and their dumb hardcoded Inner Eye HP, for Patra (Byrna) to be able to die in three hits instead of the hardcoded 12.
const int HEROCHARM_TILE = 19914;	// Tile used by the mode menu for See Enemy HP mode
const int MISC_RECENTHP = 11;		// NPC->Misc[] index used by the "See Enemy HP" mode, to check if their HP has changed.
const int MISC_SHOWHPTIMER = 12;	// NPC->Misc[] index used by the "See Enemy HP" mode, to act as a timer for displaying their HP after changing.

// --- Custom NPC IDs
const int NPC_MOBY1 = 283;		// Zelda II Moby bird (level 1).
const int NPC_MOBY2 = 284;		// Zelda II Moby bird (level 2).
const int NPC_MOBY3 = 367;		// Zelda II Moby bird (goes further offscreen).

const int NPC_DEELER1 = 291;		// Zelda II Deeler spider (level 1).
const int NPC_DEELER2 = 292;		// Zelda II Deeler spider (level 2).
const int NPC_DEELER2A = 293;		// Zelda II Deeler spider after being knocked down / hopping (level 2).

const int NPC_GIRUBOKKU = 215;		// Zelda II Girubokku enemy.

const int NPC_GIBO1 = 294;		// LTTP Gibo enemy (blobby cloud that follows crew; sometimes facetitiously called "Patrick". Level 1).
const int NPC_GIBO2 = 295;		// LTTP Gibo enemy (Level 2).
const int MISC_GIBOX = 7;		// NPC->Misc[] index used to track the X position of a Gibo's cloud.
const int MISC_GIBOY = 8;		// NPC->Misc[] index used to track the Y position of a Gibo's cloud.

const int NPC_CLOCKPUN1 = 299;		// Clock enemy that stuns the player.
const int NPC_CLOCKPUN2 = 300;		// Clock enemy that stuns the player for a longer time.

const int NPC_WHISTLE = 181;		// Whistle Master enemy. Creates LW_WHISTLE when dying.

const int NPC_GUMA1 = 229;		// Zelda II Guma enemy (level 1); hops when it's standing on the grid.
const int NPC_GUMA2 = 230;		// Zelda II Guma enemy (level 2); hops when it's standing on the grid.

const int NPC_ROPEDESTROYER = 336;	// Destroys LW_ROPE lweapons.

const int NPC_TUNKRAD1 = 191;		// Tunkrad L1 enemy. (Unscripted enemy editor enemy)

const int NPC_URCHIN1 = 238;		// Urchin L1 enemy. (Unscripted enemy editor enemy)

const int NPC_ZORAWALK1 = 339;		// Walking Zora L1 enemy. (unscripted enemy editor enemy)
const int NPC_ZORAWALK2 = 235;		// Walking Zora L2 enemy. (unscripted enemy editor enemy)

const int NPC_SLUGGULA1 = 199;		// Sluggula L1 enemy. (Unscripted enemy editor enemy, aside from item drop set)

const int NPC_WIZZ_SOMARIA = 318;	// Wizzrobe (Somaria) enemy. (Unscripted enemy editor enemy, aside from item drop set)

const int NPC_LIKELIKESHIELDS = 247;	// shielded Like Like enemy; turns to face Link upon collision.

const int NPC_FRIENDLYOCTO = 187;	// Friendly octorok NPC. Doesn't have it's color changed by Tougher Monsters mode.

const int NPC_MOLDORM_GROW_HEAD1 = 319;	// Growing moldorm head (red). Behavior is an FFC script, but this NPC is excluded from HP reduction by Weaker Monsters mode.
const int NPC_MOLDORM_GROW_TAIL1 = 320;	// Growing moldorm tail (red). Behavior is an FFC script, but this NPC is excluded from HP reduction by Weaker Monsters mode.
const int NPC_MOLDORM_GROW_HEAD2 = 189;	// Growing moldorm head (blue). Behavior is an FFC script, but this NPC is excluded from HP reduction by Weaker Monsters mode.
const int NPC_MOLDORM_GROW_TAIL2 = 188;	// Growing moldorm tail (blue). Behavior is an FFC script, but this NPC is excluded from HP reduction by Weaker Monsters mode.

const int NPC_LANMOLA_GROW_HEAD1 = 371;	// Growing lanmola head (red). Behavior is an FFC script, but this NPC is excluded from HP reduction by Weaker Monsters mode.
const int NPC_LANMOLA_GROW_TAIL1 = 372;	// Growing lanmola tail (red). Behavior is an FFC script, but this NPC is excluded from HP reduction by Weaker Monsters mode.
const int NPC_LANMOLA_GROW_HEAD2 = 361;	// Growing lanmola head (blue). Behavior is an FFC script, but this NPC is excluded from HP reduction by Weaker Monsters mode.
const int NPC_LANMOLA_GROW_TAIL2 = 362;	// Growing lanmola tail (blue). Behavior is an FFC script, but this NPC is excluded from HP reduction by Weaker Monsters mode.

const int NPC_MANHANDLA_GROW_CORE = 203; // Growing Manhandla core. Behavior is an FFC script, but this NPC is excluded from HP reduction by Weaker Monsters mode.
const int NPC_MANHANDLA_GROW_HEAD = 204; // Growing Manhandla head. Behavior is an FFC script, but this NPC is excluded from HP reduction by Weaker Monsters mode.

const int NPC_DARKNUT_FOURMATION = 334;	// 4x1 Darknut
const int FOURMATION_ORIGTILE = 6640;	// 4x1 Darknut original tile, to use two rows of tiles.
const int NPC_DARKNUT_FOURSPLIT = 335;	// NPC created when 4x1 Darknut is defeated. (Regular split behavior was too janky)

const int NPC_BUBBLE_WHISP_A = 341;	// Bubble which teleports Link to NPC_BUBBLE_WHISP_B if he has I_WHISPRING1.
const int NPC_BUBBLE_WHISP_B = 342;	// Bubble which teleports Link to NPC_BUBBLE_WHISP_A if he has I_WHISPRING1.
const int CF_NOWHISP = 101;		// Combo flag that prevents Whisp teleportation. Currently using CF_SCRIPT4.

const int NPC_YOMOMEDUSA1 = 343;	// LTTP Yomo Medusa (four-way shooter; reacts to link weapons).
const int NPC_YOMOMEDUSA2 = 344;	// LTTP/Lolo-inspired Yomo Medusa (level 2; reacts to line of sight).

const int NPC_LASEREYE_UP = 348;	// LTTP Laser Eye enemy approximation (facing up)
const int NPC_LASEREYE_DOWN = 345;	// LTTP Laser Eye enemy approximation (facing down)
const int NPC_LASEREYE_LEFT = 349;	// LTTP Laser Eye enemy approximation (facing left)
const int NPC_LASEREYE_RIGHT = 350;	// LTTP Laser Eye enemy approximation (facing right)
const int NPC_LASEREYE_RAND = 351;	// LTTP Laser Eye enemy approximation (facing randomly)

const int NPC_PATRA_REVERSE_EYE = 313;	// Invincible small Patra eye enemy; this identifier is only used to prevent showing the HP of this enemy in "See Enemy HP" mode

const int NPC_WIZZMASTER = 354;		// Wizzrobe that behaves like a wallmaster. Set's it's collision detection to false when colliding with the player.

const int NPC_FIREBOULDER = 370;	// A boulder NPC which has cset 9 after being hit.

const int NPC_MIRRORGANNON = 346;	// Mirror Gannon enemy ID, used by Tougher Monsters to determine HP adjustment.

// --- No Heart Drops mode
const int I_NOHEARTS = 182;		// No Heart Drops mode item ID
const int NOHEART_TILE = 19858;		// Tile used by the mode menu for No Hearts mode.

// --- 8 Way Walk mode (see Moosh's function "FourWayCurse")
const int I_PROGRESSIVEGEAR = 181;	// Item to negate Moosh's 4 way movement curse script (8 way movement mode item)
const int GEAR_TILE = 19856;		// Tile used by the Mode Menu for 8 way walk mode.

// --- Zapper ducks mode
const int I_ZAPPER = 184;		// Duck Zapper Item ID
const int COMBO_DUCK1 = 5638;		// Duck combos to draw at mouse pointer; uses a 2x2 block of combos with COMBO_DUCK1 in the top left. 
const int COMBO_DUCK2 = 5644;		// Duck combos to draw at top of screen for second zapper mode; uses a 4x2 block of combos with COMBO_DUCK2 in the top left. 
const int COMBO_BULLET = 5637;		// Bullet combo to draw at the bullet the TopDuck drops
const int DUCK_TILE = 19854;		// Tile used by the Mode Menu for Zapper mode. Ooh-woo-ooh.
const int SFX_DUCK = 67;		// Duck sound effect.
const int SFX_DUCKSHOT = 78;		// TopDuck dropping bullet sound effect.
const int SFX_DUCKHIT = 79;		// Sound effect that plays when the bullet is shot by the zapper.
// --- Two ducks mode
const int I_ZAPPERTWO = 201;		// Duck Zapper 2 (TopDuck) Item ID
const int I_RUPEETWO = 202;		// Rupee worth 2 rupees, which is spawned if the Zapper shoots the Bullets
// indices for array int TopDuck[7]
const int DUCKSHOT_DIR = 1;		// Direction used by top duck to go left or right.
const int DUCKSHOT_X = 2;		// X location used for top duck.
const int DUCKSHOT_STEP = 3;		// Timer used for the top duck's movement speed.
const int DUCKSHOT_FIRE = 4;		// Timer used for the top duck to drop a clay pigeon.
const int DUCKSHOT_TARGET = 5;		// Y location used for clay pigeon to fall to.
const int DUCKSHOT_BULLET = 6;		// Top duck dropping a clay pigeon.

// --- Bow Wow item
const int I_BOWWOW = 190;		// Bow-Wow Item ID
const int I_BOWWOWBALL = 221;		// Bow-Wow Fireball Item ID
const int I_BOWWOWDETECTOR = 191;	// Shows meat at Bow-Wow's GOX and GOY. Not really intended as a gameplay item but it was a debug feature I decided to leave in the cheats menu.
const int LW_BOWWOW = 39;		// Bow-Wow LWeapon type. Currently Using LW_SCRIPT9.
const int SP_BOWWOWUP = 118;		// Weapon sprite for Bow-Wow (facing up)
const int SP_BOWWOWDOWN = 119;		// Weapon sprite for Bow-Wow (facing down)
const int SP_BOWWOWLEFT = 120;		// Weapon sprite for Bow-Wow (facing left)
const int SP_BOWWOWRIGHT = 121;		// Weapon sprite for Bow-Wow (facing right)
const int BOWWOWCHAIN_TILE = 19941;	// BowWow Chain tile
const int SFX_BOWWOW = 74;		// Bow-Wow barking sound effect.
const int SFX_FDSGLEEOK = 86;		// Gleeok Famicom sound effect, used by defaut Bow-Wow instead of the bark. Played instead if Link has I_ITEMSGFX.
const int CF_BOWWOW = 99;		// Flag to make combos edible by Bow-Wow (will leave undercombos behind). Currently uses CF_SCRIPT2.
const int CF_BOWWOWSECRET = 9;		// When placed on a combo with the above inherent flag, BowWow will reveal a combo based on the screen's roomdata. Currently using CF_ARMOSSECRET.
//BowWowStatus[] array incies:
const int BOWWOW_TIMER = 1;		//Bow-Wow movement timer.
const int BOWWOW_EAT = 2;		//Bow-Wow random eating.
const int BOWWOW_GOX = 3;		//Bow-Wow tries to go to X.
const int BOWWOW_GOY = 4;		//Bow-Wow tries to go to Y.
const int BOWWOW_BOUNCE = 5;		//Bow-Wow bouncing animation offset.
const int BOWWOW_EATDELAY = 6;		//Delay on eating non-targeted enemies
const int TILE_BOWWOW_TARGET = 19792;	//Drawn by the "Bow Wow Targeting Detector" (unused item / debug feature) for where Bow-wow is trying to go.
const int SP_BLINKARROWLONG = 176;	// Blinking arrow used when BowWow senses buried secrets.

// --- Link Costume mode
const int CR_COSTUME = 9;		// Game->Counter[] used for costumes. Currently using CR_SCRIPT3.
const int LINKCOSTUME_TILE = 19839;	// Tile used by the Mode Menu for Link Costume mode.
const int I_LINKCOSTUME = 197;		// Link Costume Item ID
const int PLAYER_TILES = 31720;		// Starting tile for Zelda's player tiles. Used to copytile over for the Costumes.
const int COSTUMECOPY_TILE = 32240;	// Starting tile for Costume tiles to copy over Zelda.
const int COSTUMEVICTORY_TILES = 32480;	// Starting tile for Costume end-of-game tiles to copy over Zelda.
const int PLAYERVICTORY_TILES = 28;	// Starting tile for ZC's hard-coded victory tiles for the ending.
const int COMBO_POSE = 5674;		// Combo for the player's posing animation, to display when changing costumes.
const int COMBO_PPOSE = 5675;		// Combo for the partner's posing animation, to display when changing costumes.
const int REMEMBER_HURTNOISE = 11;	// RememberStuff[] index used to determine which hurt noise is played when the costume is selected. Default is 76.
// Hurt sound effects (determined by costume)
const int SFX_LINKHURT = 75;		// Sound effect for "Link" / male / other costumes to get hurt
const int SFX_ZELDAHURT = 76;		// Sound effect for Zelda / female costumes to get hurt
const int SFX_MARIOHURT = 77;		// Sound effect for Mario characters to get hurt
const int SFX_YOSHIHURT = 88;		// Sound effect for Yoshi to get hurt
const int SFX_RIGGSHURT = 89;		// Sound effect for Riggs to get hurt
const int SFX_LOTWHURT = 90;		// Sound effect for Legacy of the Wizard Characters and Holm to get hurt
const int SFX_DWHURT = 91;		// Sound effect for Dragon Warrior/Dragon Quest heroes to get hurt
const int SFX_DWEHIT = 92;		// Sound effect for the Dragonlord to get hurt
const int SFX_LOLOHURT = 93;		// Sound effect for Lolo or Lala to get hurt
const int SFX_GARDEAHURT = 94;		// Sound effect for Gardea to get hurt
const int SFX_MOOF = 95;		// Sound effect for Moosh to get hurt
const int SFX_SQUEAK = 96;		// Sound effect for Dimivee to get hurt
const int SFX_KEENHURT = 97;		// Sound effect for Commander Keen to get hurt
const int SFX_DESIOHURT = 255;		// Sound effect for Desio to get hurt (silent)

// Game->Counter[CR_COSTUME] values
const int COSTUME_ZELDA = 		0;	// Uses Zelda hurt noise.
const int COSTUME_LINK = 		1;	// Uses Link hurt noise.
const int COSTUME_MARIN_A = 		2;	// Uses Zelda hurt noise.
const int COSTUME_MARIN_B = 		3;	// Uses Zelda hurt noise.
const int COSTUME_DIN = 		4;	// Uses Zelda hurt noise.
const int COSTUME_NAYRU = 		5;	// Uses Zelda hurt noise.
const int COSTUME_NAYRU_VERAN = 	6;	// Uses Zelda hurt noise.
const int COSTUME_FARORE = 		7;	// Uses Zelda hurt noise.
const int COSTUME_IMPA = 		8;	// Uses Zelda hurt noise.
const int COSTUME_IMPA_YOUNG = 		9;	// Uses Zelda hurt noise.
const int COSTUME_HARKINIAN = 		10;	// Uses Link hurt noise.
const int COSTUME_HARKINIAN_CDI = 	11;	// Uses Link hurt noise.
const int COSTUME_DUKE_ONKLED = 	12;	// Uses Link hurt noise.
const int COSTUME_SUBROSIAN = 		13;	// Uses Zelda hurt noise.
const int COSTUME_ROSA = 		14;	// Uses Zelda hurt noise.
const int COSTUME_DARUNIA = 		15;	// Uses Link hurt noise.
const int COSTUME_LANA = 		16;	// Uses Zelda hurt noise.
const int COSTUME_ABEI = 		17;	// Uses Link hurt noise.
const int COSTUME_AMA = 		18;	// Uses Zelda hurt noise.
const int COSTUME_MERCHANT = 		19;	// Uses Link hurt noise.
const int COSTUME_DARKNUT = 		20;	// Uses monster hurt noise.
const int COSTUME_WIZZROBE = 		21;	// Uses monster hurt noise.
const int COSTUME_GORIYA = 		22;	// Uses monster hurt noise.
const int COSTUME_ZORA = 		23;	// Uses monster hurt noise.
const int COSTUME_OCTOROK = 		24;	// Uses monster hurt noise.
const int COSTUME_MOBLIN = 		25;	// Uses monster hurt noise.
const int COSTUME_VIRE = 		26;	// Uses monster hurt noise.
const int COSTUME_LYNEL = 		27;	// Uses monster hurt noise.
const int COSTUME_ZOL = 		28;	// Uses monster hurt noise.
const int COSTUME_POLSVOICE = 		29;	// Uses monster hurt noise.
const int COSTUME_TEKTITE = 		30;	// Uses monster hurt noise.
const int COSTUME_LIKELIKE = 		31;	// Uses monster hurt noise.
const int COSTUME_WALLMASTER = 		32;	// Uses monster hurt noise.
const int COSTUME_STALFOS = 		33;	// Uses monster hurt noise.
const int COSTUME_GIBDOS = 		34;	// Uses monster hurt noise.
const int COSTUME_GIBO = 		35;	// Uses monster hurt noise.
const int COSTUME_SLUGGULA = 		36;	// Uses monster hurt noise.
const int COSTUME_BARI = 		37;	// Uses monster hurt noise.
const int COSTUME_AQUAMENTUS = 		38;	// Uses boss hurt noise.
const int COSTUME_DODONGO = 		39;	// Uses boss hurt noise.
const int COSTUME_MANHANDLA_A = 	40;	// Uses boss hurt noise.
const int COSTUME_MANHANDLA_B = 	41;	// Uses boss hurt noise.
const int PCOSTUME_BIG_MANHANDLA = 42;			// COSTUME_MANHANDLA_B + 1. Partner costume value for the full size Manhandla costume; if CR_PCOSTUME is this,  MANHANDLA_MIDDLE_TILE will be drawn for the follower instead of a regular costume.
const int MANHANDLA_MIDDLE_TILE = 45227;		// See line above
const int COSTUME_GLEEOK = 		42;	// Uses boss hurt noise.
const int COSTUME_DIGDOGGER = 		43;	// Uses boss hurt noise.
const int COSTUME_GOHMA = 		44;	// Uses boss hurt noise.
const int COSTUME_PATRA = 		45;	// Uses boss hurt noise.
const int COSTUME_FAIRY = 		46;	// Uses boss hurt noise.
const int COSTUME_GANNON = 		47;	// Uses boss hurt noise.
const int COSTUME_LINK_SHADOW = 	48;	// Uses boss hurt noise.
const int COSTUME_ZELDA_SHADOW = 	49;	// Uses boss hurt noise.
const int COSTUME_LINK_BUNNY = 		50;	// Uses Link hurt noise.
const int COSTUME_LINK_CHEERLEADER = 	51;	// Uses Link hurt noise.
const int COSTUME_UNCOOL = 		52;	// Uses boss hurt noise.
const int COSTUME_MARIO_A = 		53;	// Uses Mario hurt noise.
const int COSTUME_MARIO_B = 		54;	// Uses Mario hurt noise.
const int COSTUME_LUIGI_A = 		55;	// Uses Mario hurt noise.
const int COSTUME_LUIGI_B = 		56;	// Uses Mario hurt noise.
const int COSTUME_PEACH_A = 		57;	// Uses Mario hurt noise.
const int COSTUME_PEACH_B = 		58;	// Uses Mario hurt noise.
const int COSTUME_DAISY_A = 		59;	// Uses Mario hurt noise.
const int COSTUME_DAISY_B = 		60;	// Uses Mario hurt noise.
const int COSTUME_HAMMER_BROS = 	61;	// Uses Mario hurt noise.
const int COSTUME_GOOMBA = 		62;	// Uses Mario hurt noise.
const int COSTUME_WARIO = 		63;	// Uses Mario hurt noise.
const int COSTUME_WALUIGI_A = 		64;	// Uses Mario hurt noise.
const int COSTUME_WALUIGI_B = 		65;	// Uses Mario hurt noise.
const int COSTUME_BOMBERMAN = 		66;	// Uses Link hurt noise.
const int COSTUME_BLACK_BOMBER = 	67;	// Uses Link hurt noise.
const int COSTUME_DQ1_HERO = 		68;	// Uses DW hurt noise.
const int COSTUME_DRAGONLORD = 		69;	// Uses DW enemy hit noise.
const int COSTUME_DQ2_MIDDENHALL = 	70;	// Uses DW hurt noise.
const int COSTUME_DQ2_CANNOCK = 	71;	// Uses DW hurt noise.
const int COSTUME_DQ2_MOONBROOKE = 	72;	// Uses DW hurt noise.
const int COSTUME_DQ2_MOONBROOKE_B = 	73;	// Uses DW hurt noise.
const int COSTUME_XEMN = 		74;	// Uses LOTW hurt noise.
const int COSTUME_MEYNA = 		75;	// Uses LOTW hurt noise.
const int COSTUME_LYLL = 		76;	// Uses LOTW hurt noise.
const int COSTUME_ROAS = 		77;	// Uses LOTW hurt noise.
const int COSTUME_POCHI = 		78;	// Uses LOTW hurt noise.
const int COSTUME_LOLO = 		79;	// Uses Lolo hurt noise.
const int COSTUME_LALA = 		80;	// Uses Lolo hurt noise.
const int COSTUME_SIMON = 		81;	// Uses Link hurt noise.
const int COSTUME_QUOTE = 		82;	// Uses Link hurt noise.
const int COSTUME_CURLY_BRACE = 	83;	// Uses Zelda hurt noise.
const int COSTUME_DANA = 		84;	// Uses Link hurt noise.
const int COSTUME_POPOLON = 		85;	// Uses Link hurt noise.
const int COSTUME_APHRODITE = 		86;	// Uses Zelda hurt noise.
const int COSTUME_NARU = 		87;	// Uses Zelda hurt noise.
const int COSTUME_UMINO = 		88;	// Uses Link hurt noise.
const int COSTUME_MONIKA = 		89;	// Uses Zelda hurt noise. Checked by an FFC in the final room for a special message.
const int COSTUME_SAYORI = 		90;	// Uses Zelda hurt noise.
const int COSTUME_YURI = 		91;	// Uses Zelda hurt noise.
const int COSTUME_NATSUKI = 		92;	// Uses Zelda hurt noise.
const int COSTUME_KEEN = 		93;	// Uses Link hurt noise.  
const int COSTUME_PICARD = 		94;	// Uses Link hurt noise. 
const int COSTUME_LUKE = 		95;	// Uses Link hurt noise. 
const int COSTUME_LEIA = 		96;	// Uses Zelda hurt noise.
const int COSTUME_HAN = 		97;	// Uses Link hurt noise.
const int COSTUME_THRAWN = 		98;	// Uses Link hurt noise. 
const int COSTUME_GRAAL = 		99;	// Uses Link hurt noise.
const int COSTUME_MOOSH = 		100;	// Uses Link hurt noise.
const int COSTUME_KELL = 		101;	// Uses Link hurt noise.
const int COSTUME_RIGGS = 		102;	// Uses Riggs hurt noise.
const int COSTUME_HOLM = 		103;	// Uses LOTW hurt noise.
const int COSTUME_DESIO = 		104;	// Uses no hurt noise.
const int COSTUME_DESIO_UP = 		105;	// Uses no hurt noise. 
const int COSTUME_ELI = 		106;	// Uses Riggs hurt noise.  
const int COSTUME_EEVEE = 		107;	// Uses Zelda hurt noise.
const int COSTUME_EEVEE_NES = 		108;	// Uses Zelda hurt noise.
const int COSTUME_DIMIVEE = 		109;	// Uses Zelda hurt noise.
const int COSTUME_YOSHI = 		110;	// Uses Yoshi hurt noise.
const int COSTUME_YOSHOT = 		111;	// Uses Yoshi hurt noise.
const int COSTUME_MANI_KANINA = 	112;	// Uses Zelda hurt noise.
const int COSTUME_GARDEA = 		113;	// Uses Gardea hurt noise.
const int COSTUME_ARCANA_A = 		114;	// Uses Zelda hurt noise.
const int COSTUME_ARCANA_B = 		115;	// Uses Zelda hurt noise.
const int COSTUME_BARGO =		116;	// Uses Link hurt noise.
const int COSTUME_BIGJOE = 		117;	// Uses Link hurt noise.
const int COSTUME_HYLIA_A = 		118;	// Uses Zelda hurt noise.
const int COSTUME_HYLIA_B = 		119;	// Uses Zelda hurt noise.
const int COSTUME_ZELOS = 		120;	// Uses Link hurt noise.
const int COSTUME_ZELOS_NES = 		121;	// Uses Link hurt noise.
const int COSTUME_BLACKMAGE = 		122;	// Uses Link hurt noise. Also checked by an FFC in the final room for a special MeleeWizard message.
const int COSTUME_KNUCKLES = 		123;	// Uses Zelda hurt noise.
const int COSTUME_AMY = 		124;	// Uses Link hurt noise. 
const int COSTUME_INVISIBLE = 		125;	// Uses Zelda hurt noise. Also defines the last costume to scroll through.

// --- Partner Costume mode
const int CR_PCOSTUME = 10;		// Game->Counter[] used for costumes. Currently using CR_SCRIPT4.
const int PARTNERCOSTUME_TILE = 19918;	// Tile used by the Mode Menu for Link Costume mode.
const int PARTNER_TILES = 31980;	// Starting tile for patner's tiles. Used to copytile over for the partner Costume.

// --- World Redecorate mode
const int GRASSMODE_TILE = 19878;	// Tile used by the mode menu for World Redecorate mode
const int I_WORLDGFX = 200;		// World Redecorate item ID
const int OVERWORLD_TILE = 17940;	// Where a certain set of overworld combo tiles is found
const int GRASSCOPY_TILE = 18460;	// Copytiles over the above tiles with grass tile versions
const int NOGRASSCOPY_TILE = 18200;	// Copies back over OVERWORLD_TILE with non-grass tiles

// --- Alternate Item Graphics mode
const int ITEMGFX_TILE = 19791;		// Tile used by the mode menu for Alternate Item Graphics mode
const int I_ITEMSGFX = 222;		// Alternate Item Graphics item ID
const int ITEMS_TILE = 19760;		// Where a certain set of item tiles is found
const int ITEMSCOPY_TILE = 29380;	// Copytiles over the above tiles with alternate versions
const int NOITEMSCOPY_TILE = 29640;	// Copies back over ITEMS_TILE with the default item tiles

// --- Shield mode
const int SHIELD1_TILE = 19879;		// Tile used by the Mode Menu for the Shield.

// --- Double Defense mode
const int DOUBLEDEF_TILE = 19926;	// Tile drawn for Double Defense mode.
const int I_PERILRING2 = 238;		// Item used for Double Defense mode (a level 2 peril ring that's always on).

// --- Random Extra Enemies mode
const int EXTRAENEMY_TILE = 19859;	// Tile used by the Mode Menu for Random Extra Monsters mode.
const int I_EXTRAENEMY = 216;		// Item ID for Extra Enemies mode.
const int SFX_ENEMYAPPEAR = 84;		// Sound to play when extra enemies are spawned.
const int COMBO_DWATER = 5173;		// Combo for dungeon water, to spawn if making an extra Zora.

// --- Weather / Environment modes
const int ENV_SKEW = 1;			// "Mode 7" skewed bitmap drawing mode.
const int ENV_180 = 2;			// Upside-down bitmap drawing mode.
const int ENV_SPIN = 3;			// Spinning bitmap drawing mode.
const int ENV_SPINSTOP = 4;		// Same as ENV_SPIN, but stops spinnning when selected.
const int ENV_TINY = 5;			// Half-scale bitmap drawing mode.
const int ENV_BLOCKY = 6;		// "Atari 2600" blocky drawing mode.
const int ENV_DYNAMIC = 7;		// Dynamic weather mode
const int ENV_SCANLINES = 8;		// Scanline overlay mode.
const int ENV_BRIGHT = 9;		// Bright overlay mode.
const int ENV_DARK = 10;		// Dark overlay mode.
const int ENV_SPRINKLE = 11;		// Sprinkling mist overlay mode.
const int ENV_RAIN1 = 12;		// Transparent rain overlay mode.
const int ENV_RAIN2 = 13;		// Opaque rain overlay mode.
const int ENV_SNOW = 14;		// Snow overlay mode.
const int ENV_FOG = 15;			// Fog overlay mode.
const int ENV_SAKURA = 16;		// Sakura overlay mode.
const int ENV_BREEZY = 17;		// Wind lines
const int ENV_HEATWAVY = 18;		// Heat wave screen->wavy mode.
const int ENV_WAVY1 = 19;		// Somewhat wavy screen->wavy mode.
const int ENV_WAVY2 = 20;		// Very wavy screen->wavy mode.
const int ENV_NEWWAVY1 = 21;		// New wavy function, slow version. Made by Dimi.
const int ENV_NEWWAVY2 = 22;		// New wavy function, fast (AKA content aware mode). Made by Dimi.
const int ENV_DARKROOM = 23;		// Fancy transparent darkness, with circles of light sources which gradually pulse in size. Made by Dimi.
const int ENV_NAUSEA = 24;		// Combination of ENV_SPIN and ENV_WAVY2. Made by Mitsukara (so blame me).
const int ENV_TRUENAUSEA = 25;		// Combination of ENV_SPIN and ENV_NEWWAVY2. Made by Dimi.

// --- Dynamic Weather effects
const int DYNAMIC_SCANLINES = 7;	// Scanline overlay mode.
const int DYNAMIC_BRIGHT = 8;		// Bright overlay mode.
const int DYNAMIC_DARK = 9;		// Dark overlay mode.
const int DYNAMIC_SPRINKLE = 10;	// Sprinkling mist overlay mode.
const int DYNAMIC_RAIN1 = 11;		// Transparent rain overlay mode.
const int DYNAMIC_RAIN2 = 12;		// Opaque rain overlay mode.
const int DYNAMIC_SNOW = 13;		// Snow overlay mode.
const int DYNAMIC_FOG = 14;		// Fog overlay mode.
const int DYNAMIC_SAKURA = 15;		// Sakura overlay mode.
const int DYNAMIC_HEATWAVY = 16;	// Heat wave screen->wavy mode.
const int DYNAMIC_WAVY1 = 17;		// Somewhat wavy screen->wavy mode.
const int DYNAMIC_WAVY2 = 18;		// Very wavy screen->wavy mode.
const int DYNAMIC_BREEZY = 21;		// Wind lines
const int DYNAMIC_DARKROOM = 23;	// Light Circle Dark Room

// --- Weather / Environment-related miscellaneous stuff

const int I_WEATHER = 242;			// Mode item for weather
const int WEATHER_TILE = 19931;			// Mode icon for weather
const int SFX_RAIN = 82;			// Rain noise used on map 0 screens below 128, by "Rain" environment modes
const int SFX_RAIN_INSIDE = 83;			// Rain noise used on other maps, and cave screens, by "Rain" environment modes
const int WEATHER_MAP = 4;			// Map where overlay screens can be found, for DrawScreen effects
const int WEATHER_SAKURA = 123;			// Sakura overlay screen
const int WEATHER_RAIN = 124;			// Transparent rain overlay screen
const int WEATHER_RAIN_OPAQUE = 121;		// Opaque rain overlay screen
const int WEATHER_MIST = 125;			// Mist overlay screen
const int WEATHER_SNOW = 126;			// Snow overlay screen
const int WEATHER_FOG = 127;			// Fog overlay screen
const int WEATHER_DARK = 117;			// Dark overlay screen
const int WEATHER_NIGHT = 106;			// Dark overlay screen
const int WEATHER_LIGHT = 118;			// Bright overlay screen
const int WEATHER_SCANLINES = 114;		// Scanlines overlay screen
//const int WEATHER_SCANLINES2 = 113;		// Alternate scanlines overlay screen (unused)
const int WEATHER_ROCK = 112;			// Rock wall screen, for screen edges on "mode 7" mode
const int WEATHER_WATER = 111;			// Water screen, for screen edges on "mode 7" mode
const int WEATHER_DUNGEON = 110;		// Dungeon brick screen, for screen edges on "mode 7" mode
const int CR_WEATHER = 11;			// Game->Counter[] used for weather. Currently using CR_SCRIPT5.
const int COMBO_DUNGEONWALL = 260;		// Upper left corner of dungeon walls to identify that room is a dungeon for edge overlay on drawn screens
const int WEATHER_DUNGEONWALL = 109;		// NES Dungeon border overlay screen
const int WEATHER_BREEZE = 104;			// Bright overlay screen
const int TILE_BLACK = 10451;			// Black tile used by ENV_BLOCKY
const int TILE_SOLID_DARK = 10441;		// Dark color tile used by ENV_BLOCKY
const int TILE_SOLID_LIGHT = 10442;		// Light color tile used by ENV_BLOCKY
const int TILE_SOLID_WATER = 10443;		// Water color tile used by ENV_BLOCKY
const int TILE_QUARTERSOLID = 10449;		// Small block tile used by ENV_BLOCKY
const int TILE_QUARTERSOLID_REVERSE = 10450;	// Tile with a small black center used by ENV_BLOCKY
const int TILE_BLOCKYRUPY = 10452;		// Rupy passive subscreen sprite for ENV_BLOCKY
const int TILE_BLOCKYKEY = 10453;		// Key sprite for ENV_BLOCKY
const int TILE_BLOCKYKEY2 = 10468;		// Magic/Boss Key sprite for ENV_BLOCKY
const int TILE_BLOCKYHEART = 10454;		// Heart passive subscreen sprite for ENV_BLOCKY
const int TILE_BLOCKYCHEST = 10491;		// Treasure chest sprite for other items in ENV_BLOCKY
const int ORIGTILE_RUPY = 18098;		// Original tile of Rupee 1, checked by ENV_BLOCKY
const int ORIGTILE_RUPYOTHER = 21532;		// Original tile of most Rupees, checked by ENV_BLOCKY
const int ORIGTILE_HEART = 21166;		// Original tile of most Heart items, checked by ENV_BLOCKY
const int ORIGTILE_HEARTCONTAINER = 21115;	// Original tile of Heart Containers, checked by ENV_BLOCKY
const int ORIGTILE_HALFHEART = 21085;		// Original tile of Heart Containers, checked by ENV_BLOCKY
const int ORIGTILE_MAGICKEY = 23121;		// Original tile of Magic Key and Big Key items, checked by ENV_BLOCKY
const int TILE_ROCK = 118;			// Tile (plus the next tile) to draw rocks as in drawn bitmap environment modes (except for ENV_BLOCKY)
const int TILE_INDY = 10492;			// Tile used for LW_ARMOS by ENV_BLOCKY
const int COMBO_GRUNDLE = 5684;			// Adventure dragon enemy combo, used by ENV_BLOCKY for non-guy NPCs
const int COMBO_GRUNDLESMALL = 5685;		// Adventure dragon enemy combo, used by ENV_BLOCKY for non-guy NPCs with smaller hitboxes
const int COMBO_ADVBAT = 5686;			// Adventure bat combo, used by ENV_BLOCKY for items
const int COMBO_COMBATTANKSPIN = 5718;		// Spinning tank from Combat, used by ENV_BLOCKY if Link has a costume and is hurt/stunned/drowned
const int TILE_COMBATTANK = 10509;		// Tiles of tank from Combat, used by ENV_BLOCKY if Link has a costume. Row of 4 tiles.
const int TILE_ADVSWORD = 10516;		// Adventure sword tile (row of 4 tiles), used by ENV_BLOCKY
const int TILE_ADVBRIDGE = 10513;		// Adventure bridge tile, used by ENV_BLOCKY
const int TILE_ADVGATE = 10472;			// Blocky shutter tile, used by ENV_BLOCKY
const int TILE_ADVGRAIL = 10467;		// Adventure grail tile, used by ENV_BLOCKY
const int TILE_BLOCKYSTAIRS = 10489;		// Blocky staircase graphic, used by ENV_BLOCKY
const int TILE_BLOCKYSHUTTER = 10471;		// Adventure gate tile, used by ENV_BLOCKY
const int TILE_BLOCKYHOLE = 10490;		// Black square on ground color square, used by ENV_BLOCKY
// --- BitmapOffset[] array indices
const int ENV_X_OFFSET = 1;			// Offsets the environment bitmap drawing by this X.
const int ENV_Y_OFFSET = 2;			// Offsets the environment bitmap drawing by this Y.
// Other environment bitmap stuff
const int TILE_GLEEOK = 222;			// Gleeok body to draw for special environment bitmap visual modes
const int TILE_GLEEOKNECK = 145;		// Gleeok neck to know where to draw the body at
const int TILE_AQUAMENTUS = 226;		// Aquamentus to draw for special environment bitmap visual modes
const int TILE_GOHMALEGS = 6920;		// Gohma legs to draw for special environment bitmap visual modes
const int COMBO_BOMBBLAST = 5944;		// Bomb blast to draw for special environment bitmap visual modes
const int REMEMBER_WEATHERCOUNTER = 39;		// RememberStuff[] index used to toggle the weather by the lens of truth
const int REMEMBER_PICTOBOX = 40;		// RememberStuff[] index used to toggle the pictobox by the lens of truth..

const int REMEMBER_DARKTIMER = 12;	// RememberStuff[] index used to transition smoothly in dynamic mode to dark areas

// --- Mode Menu
const int SFX_MODEON = 65;		// Sound effect for turning on a special mode
const int SFX_MODEOFF = 18;		// Sound effect for turning off a special mode. Currently uses SFX_MSG.
const int ARROW_R_TILE = 19915;		// Arrow used to specify current mode menu setting
const int COMBO_SCREENFREEZE1 = 5520;	// A combo of type "Screen Freeze (Except FFCs)", which FFC 30 will set if it has no script while the mode menu is open
const int COMBO_SCREENFREEZE2 = 5521;	// A combo of type "Screen Freeze (FFCs Only)", which FFC 31 will set if it has no script while the mode menu is open
const int MISC_NPCSPAWN = 6;		// NPC->Misc[] index used as a timer to prevent the enemy from being drawn too soon in special "Environment" / Weather mode settings
const int MODE_DRAWLAYER = 7;		// Layer to draw Mode Menu at.
const int TILE_MENUPANE = 237;		// Subscreen menu vine graphic used on passive and active subscreens, which is copied over.
const int TILE_MENUCOPY = 16300;	// Starting tile for graphics to copy over TILE_MENUPANE in 2x2 squares.
const int CR_PANECOLOR = 13;		// Game->Counter[] for what menu vine graphics to use. Currently using CR_SCRIPT7.
const int MODEMENU_SPACE = 8;		// Space between each line of the Mode Menu.
const int MODEMENU_SPEED = 8;		// How many pixels the mode menu moves per frame when opening or closing. Multiples of 2 are recommended to make sure it moves an even distance.
const int MODEMENU_HEIGHT = 160;	// How many pixels tall the mode menu background is; also determines how far offscreen it has to scroll.

// --- Cursed Pictobox
const int I_CURSEDPICTOBOX = 241;	// Fake Z3 scrolling mode
const int PICTOBOX_TILE = 19924;	// Tile drawn for Cursed Pictobox
const int I_RECURSEDPICTOBOX = 243;	// Fake Z3 scrolling mode
const int REPICTOBOX_TILE = 19911;	// Tile drawn for ReCursed Pictobox

// RememberScreen[] indices for Mode Menu save feature, OnSaveQuit script, and FFC Script ContinueScreen
const int REMEMBER_SAVEDMAP = 3;	// Array index for continuing from a certain dmap, used by FFC script ContinueScreen.
const int REMEMBER_SAVEDSCREEN = 4;	// Array index for continuing from a certain dmap screen, used by FFC script ContinueScreen.
const int REMEMBER_SAVEDX = 5;		// Array index for continuing from a certain X, used by FFC script ContinueScreen.
const int REMEMBER_SAVEDY = 6;		// Array index for continuing from a certain Y, used by FFC script ContinueScreen.

// RememberStuff[] index for Debug Console trace hints
const int REMEMBER_TRACEHINTS = 7;	// Array index for remembering which Trace hints have been previously displayed.

//Array indices for ModeMenu[]
const int MODEMENU_ON = 1;		// Checked to see if the mode menu is active.
const int SELECT_MODE = 2;		// Selects which mode setting to adjust.
const int SELECT_MUSICFILE = 3;		// Selects which music filename is playing.
const int SELECT_MUSICTRACK = 4;	// Selects which music track is playing.
const int UNDO_MUSICFILE = 5;		// By pressing B on the mode menu, SELECT_MUSICFILE is reverted to this.
const int UNDO_MUSICTRACK = 6;		// By pressing B on the mode menu, SELECT_MUSICTRACK is reverted to this.
const int CHANGE_DMAPS = 7;		// Tracks when Link changes dmaps, to remember the Undo settings.
const int COSTUME_SHOWNAME = 8;		// Timer to display costume name after changing.
const int SELECT_WEATHER = 9;		// Selects which weather to display.
const int WEATHER_NOISE = 10;		// Weather noise timer.
const int EXTRA_ENEMIES = 11;		// ModeMenu[] index which acts as a timer to spawn extra NPCs at random.
const int MODEMENU_Y = 12;		// ModeMenu[] index which determines the Y that the ModeMenu is drawn at.
const int MODEMENU_SHUTOFF = 13;	// Closes the mode menu with an animation.
const int MODEMENU_SAVING = 14;		// Timer to displays the "saving" message while saving.

// values for ModeMenu[SELECT_MODE]:
//NOTE: Adjusting these numbers will actually move the mode menu option's order, for easy alteration of the menu.
const int SETTING_MUSICFILE = 0;	
const int SETTING_MUSICTRACK = 1;
const int SETTING_8WAYWALK = 2;
const int SETTING_SHIELD = 3;
const int SETTING_DOUBLEDEF = 4;
const int SETTING_HEROCHARM = 5;
const int SETTING_FULLHEART = 6;
const int SETTING_WEAKMONSTERS = 7;
const int SETTING_TOUGHMONSTERS = 8;
const int SETTING_NOHEART = 9;
const int SETTING_EXTRA = 10;
const int SETTING_ZAPPERDUCKS = 11;
const int SETTING_PARTNER = 12;
const int SETTING_COSTUME = 13;
const int SETTING_WORLD = 14;
const int SETTING_ENVIRONMENT = 15;
const int SETTING_PICTOBOX = 16;
const int SETTING_ITEMGFX = 17;
const int SETTING_PANEGFX = 18;			
const int SETTING_SAVE = 19;		// Checked as the last setting on the menu that can be selected.

// --- Indices for int RememberRooms[]
const int REMEMBER_ROOMDATA = 1;	// Stores the latest Screen->RoomData unless the player is on Screen >= 128.
const int REMEMBER_ROOMTYPE = 2;	// Stores the latest Screen->RoomType unless the player is on Screen >= 128.
const int REMEMBER_PRICE1 = 3;		// Displays the first price based on the roomdata.
const int REMEMBER_PRICE2 = 4;		// Displays the second price based on the roomdata.
const int REMEMBER_PRICE3 = 5;		// Displays the third price based on the roomdata.
const int REMEMBER_DARK = 6;		// Used to turn off the lantern dark rooms with the candle.


// ---------------------------------------------- Section 1B: Relist of above ->Misc[] attributes for ease of checking

//Screen->Flags[9]&0x0040 		"Screen->Screen Data->Sflags 2->General Use 5 (Scripts)" checkbox. Used by scripted Dark screens for lantern.
//Screen->Flags[9]&0x0020 		"Screen->Screen Data->Sflags 2->General Use 4 (Scripts)" checkbox. Used by windy screens.
//Screen->Flags[9]&0x0010 		"Screen->Screen Data->Sflags 2->General Use 3 (Scripts)" checkbox. Used for exceptions when ENV_SKEW draws the southern dungeon wall on the bitmap environment modes.  This exception only counts if it is the only flag checked in a room because I (Mitsukara) wasn't sure how else to check for the exclusion of this screen flag, but that's okay for how it was used because there's only about four rooms that use this.

// NPC->Misc[]
//const int MISC_TOUGHENEMY = 1;	// npc->Misc[] attribute used to set the tough enemy status once to each npc.
//const int MISC_NPCLWEAPON = 2;	// NPC->Misc[] attribute to use for firing an lweapon instead of a weapon; used for Octorok item
//const int MISC_NPCLWEAPONSPRITE = 3;	// NPC->Misc[] attribute to use for lweapon sprites; used for Octorok item
//const int MISC_NPCSHOOT = 4;		// NPC->Misc[] index used as a timer for creating weapons at NPCs which do not have built-in weapon-firing capabilities
//const int MISC_NPCTURNWAIT = 5;	// NPC->Misc[] index used as a timer for turning (by NPC_GUMA1 & NPC_GUMA2, NPC_MOBY1 & NPC_MOBY2 (to spawn at top of screen), NPC_DEELER1 & NPC_DEELER2 (also to spawn at top of screen), FFC Script MoldormBehavior, and FFC Script CrazyPatra)
//const int MISC_NPCSPAWN = 6;		// NPC->Misc[] index used as a timer to prevent the enemy from being drawn too soon in special "Environment" / Weather mode settings
//const int MISC_GIBOX = 7;		// NPC->Misc[] index used to track the X position of a Gibo's cloud.
//const int MISC_GIBOY = 8;		// NPC->Misc[] index used to track the Y position of a Gibo's cloud.
//const int MISC_SEGMENTLAG = 9;	// NPC->Misc[] index used by CrazyPatra FFC for segment lag.
//const int MISC_HP_REDUCE = 10;	// NPC->Misc[] index used by the "See Enemy HP" mode, as set by the SetEnemyHP FFC, to display only the HP remaining before the SetEnemyHP will reduce them to 0. This exists only to deal with Patras and their dumb hardcoded Inner Eye HP, for Patra (Byrna) to be able to die in three hits instead of the hardcoded 12.
//const int MISC_RECENTHP = 11;		// NPC->Misc[] index used by the "See Enemy HP" mode, to check if their HP has changed.
//const int MISC_SHOWHPTIMER = 12;	// NPC->Misc[] index used by the "See Enemy HP" mode, to act as a timer for displaying their HP after changing.

// LWeapon->Misc[]
//const int MISC_BOLA = 1;		// LWeapon->Misc[] used for a Bola movement timer, on LW_BOLA weapons only.
//const int MISC_SHOVELFIND = 1;	// LWeapon->Misc[] used for randomly finding items with the shovel, on shovel dirt sparkle lweapons only.
//const int MISC_TEMPNOCOLLIDELW = 2;	// LWeapon->Misc[] attribute to use for temporary deactivation of collision detection.
//const int MISC_LWTIMEOUT = 3;		// Lweapon->Misc[] attribute to remove an lweapon when time is elapsed.
//const int MISC_NPCLWEAPONTIMER = 4;	// NPC->Misc[] attribute to use for waiting for firing an lweapon.

// EWeapon->Misc[]
//const int MISC_EWBOLA = 1;		// EWeapon->Misc[] used for a Bola movement timer, on EW_BOLA weapons only.
//const int MISC_STATIONARYFUSE = 1;	// EWeapon->Misc[] used for the stationary bomb's detonation timer, on EW_STATIONARYBOMB weapons only.
//const int MISC_EWSOMARIA = 1;		// EWeapon->Misc[] used to wait to blow up the block, on EW_SOMARIA weapons only.
//const int MISC_DONTUSE15 = 15;	//Don't use Misc15; ghost uses that. -Dimi

// ---------------------------------------------- Section 2: Global int and bool declarations
bool DoDraw = true;			// Global-scope bool used to prevent drawing at inappropriate times (if false)
bool PlayingMIDIs;			// Checked by Mode Menu to see if music is on MIDI or Enhanced
bool ByrnaAttached;			// Used by ByrnaAttachPoint FFC to set whether Link is attached to one of the FFCs or not. (Is always set to false at the init of that FFC, and not used anywhere else.)
int RememberStuff[512];			// Array for anything that needs to be added as a global int in updates.
	// Indices of RememberStuff[]:
	// const int REMEMBER_HP = 1;		Used to remember Link's MaxHP, to save the half-hearts if the player uses the Cheat menu (which would override them by rounding them off when it sets the heart containers).
	// const int REMEMBER_BOWWOWOFF = 2;	Array index for whether BowWow (Gleeok) is on or off.
	// const int REMEMBER_SAVEDMAP = 3;	Array index for continuing from a certain dmap, used by FFC script ContinueScreen.
	// const int REMEMBER_SAVEDSCREEN = 4;	Array index for continuing from a certain dmap screen, used by FFC script ContinueScreen.
	// const int REMEMBER_SAVEDX = 5;	Array index for continuing from a certain X, used by FFC script ContinueScreen.
	// const int REMEMBER_SAVEDY = 6;	Array index for continuing from a certain Y, used by FFC script ContinueScreen.
	// const int REMEMBER_TRACEHINTS = 7;	Array index for remembering which Trace hints have been previously displayed.
	// const int REMEMBER_RAIN = 8;		Array index for dynamic environment mode for continuing rain when in screen 80 caves
	// const int REMEMBER_TITLE = 9;	Array index for area name mode to display the title when in screen 80 caves
	// const int REMEMBER_BONKS = 10;	Array index for listing the total number of Pegasus Bonks (up to 65535).
	// const int REMEMBER_HURTNOISE = 11;	Array index used to determine which hurt noise is played when the costume is selected. Default is SFX_ZELDAHURT.
	// const int REMEMBER_DARKTIMER = 12;	Array index used to transition to darkness
	// const int REMEMBER_GLEEOK_X = 13;		// RememberStuff[] array index for gleeok's last X position (used for drawing necks in environment modes).
	// const int REMEMBER_GLEEOK_Y = 14;		// RememberStuff[] array index for gleeok's last X position (used for drawing necks in environment modes).
	// const int REMEMBER_GLEEOK_ID = 15;		// RememberStuff[] array index for gleeok's last ID (used for drawing necks in environment modes).
	// const int REMEMBER_GLEEOK_CSET = 16;		// RememberStuff[] array index for gleeok's last ID (used for drawing necks in environment modes).
	// const int REMEMBER_SCROLLING = 17;		// Z3-scrolling smooth scrolling
	// const int REMEMBER_SCROLLDIR = 18;		// Z3-scrolling smooth scrolling
	// const int REMEMBER_SCROLL_X = 19;		// Z3-scrolling smooth scrolling
	// const int REMEMBER_SCROLL_Y = 20;		// Z3-scrolling smooth scrolling
	// const int REMEMBER_LINKPROMPT = 21;		// Environment mode cutscene fix
	//const int REMEMBER_ENEMYNAMEWAIT = 22;	// Global version of enemy stuff.
	//const int REMEMBER_DIGDELAY = 23;		// Global version of enemy stuff.
	//const int REMEMBER_BOWWOW_EATDELAY = 24;	// Global version of enemy stuff.
	//const int REMEMBER_WHISPWAIT = 25;		// Global version of enemy stuff.
	//const int REMEMBER_BEINGHURT = 26;		// Global version of enemy stuff.
	//const int REMEMBER_ROOMDATA2 = 27;		// Stores the latest Screen->RoomData unless the player is on Screen >= 128.
	//const int REMEMBER_ROOMTYPE2 = 28;		// Stores the latest Screen->RoomType unless the player is on Screen >= 128.
	//const int REMEMBER_SCREEN = 29;		// Stores the last overworld screen the player was on.
	//const int REMEMBER_XORSHIFT_X = 30;		// Rando Seed internal stuff
	//const int REMEMBER_XORSHIFT_Y = 31;		// Rando Seed internal stuff
	//const int REMEMBER_ISRANDO = 32;		// Whether game is randomized or not
	//const int REMEMBER_GANN_ARROW = 33;		// Whether Link got the item from ganon in rando
	//const int REMEMBER_BRANG = 34;		// Whether the rando seed generated magic or regular boomerang
	//const int REMEMBER_SEED1 = 35;		// Part 1 of the Seed generated
	//const int REMEMBER_SEED2 = 36;		// Part 2 of the Seed generated
	//const int REMEMBER_SEED3 = 37;		// Part 1 of the Seed generated
	//const int REMEMBER_SEED4 = 38;		// Part 2 of the Seed generated
	//const int REMEMBER_WEATHERCOUNTER = 39;	// Used to toggle the weather by the lens of truth.
	//const int REMEMBER_PICTOBOX = 40;		// Used to toggle the pictobox by the lens of truth.
	//const int REMEMBER_EX3_SPOILERLOG = 41;	// Whether the player has set the randomizer's spoiler log to be displayed with the EX3 button.
	//const int REMEMBER_RANDO_OPTIONS = 320;		// Start of Rando options. Don't use indices above this for non-rando things.
	//const int REMEMBER_RANDO_SHOPSAVE = 300;	// Start of the "got item from shop" indices.
	//const int REMEMBER_RANDOSTART = 336;		// The start of the indices that store the rando items. Originally used SetComboData, but that doesn't carry over between loads.
							// Everything above 336 is used by the Rando.


int Partner[512];			// Partner aray. Used by Partner mode and LTTP Superbomb item.	
// NOTE: Partner[1]-Partner[14] are set to 0 at global script init, in the "First Actions" section below.
	// Indices for Partner[]:
	//FOLLOW_X = 1;		Follower's X
	//FOLLOW_Y = 2;		Follower's Y
	//FOLLOW_TIMER = 3;	Superbomb's invisible timer
	//FOLLOW_DISPLAY = 4;	Superbomb's visible timer
	//FOLLOW_STATE = 5;	Follower's status (whether to follow Link or not)
	//FOLLOW_SCREEN = 6;	Follower checks screen
	//FOLLOW_MAP = 7;	Follower checks map
	//FOLLOW_DIR = 8;	Follower's direction
	//FOLLOW_ACTION = 9;	Follower's action
	//FOLLOW_ATIMER = 10;	Follower's action timeout
	//FOLLOW_SHOOT = 11;	Follower's shot delay
	//STORE_FOLLOW_X = 12;	Stores follower's X when swapping positions with Link
	//STORE_FOLLOW_Y = 13;	Stores follower's Y when swapping positions with Link
	//STORE_COSTUME = 14;	Stores CR_COSTUME when swapping positions with Link

int TabletFragments[512];		// When a Tablet Fragment item is picked up, the current dmap's number is saved in this array to check that Link has it for that dmap.



// ---------------------------------------------- Section 3: Global scope functions

// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// PushLink() function (start)
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
void PushLink(int PushLinkDir)
{
	if (PushLinkDir == DIR_UP && CanWalk(Link->X,Link->Y,DIR_UP,1,false)) --Link->Y;
	if (PushLinkDir == DIR_DOWN && CanWalk(Link->X,Link->Y,DIR_DOWN,1,false)) ++Link->Y;
	if (PushLinkDir == DIR_LEFT && CanWalk(Link->X,Link->Y,DIR_LEFT,1,false)) --Link->X;
	if (PushLinkDir == DIR_RIGHT && CanWalk(Link->X,Link->Y,DIR_RIGHT,1,false)) ++Link->X;
}
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// PushLink() function (end)
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------

// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// PegasusShrapnel() function (start)
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
void PegasusShrapnel()
{
	Game->PlaySound(SFX_SHATTERING);
	lweapon PegaShrapnel = CreateLWeaponAt(LW_SPARKLE,Link->X,Link->Y);
	PegaShrapnel->UseSprite(SP_PEGASUSBREAK);
	PegaShrapnel->Dir = DIR_LEFTUP;
	PegaShrapnel->Step = 100;
	PegaShrapnel = CreateLWeaponAt(LW_SPARKLE,Link->X,Link->Y);
	PegaShrapnel->UseSprite(SP_PEGASUSBREAK);
	PegaShrapnel->Flip = FLIP_HORIZONTAL;
	PegaShrapnel->Dir = DIR_RIGHTUP;
	PegaShrapnel->Step = 100;
	PegaShrapnel = CreateLWeaponAt(LW_SPARKLE,Link->X,Link->Y);
	PegaShrapnel->UseSprite(SP_PEGASUSBREAK);
	PegaShrapnel->Flip = FLIP_VERTICAL;
	PegaShrapnel->Dir = DIR_LEFTDOWN;
	PegaShrapnel->Step = 100;
	PegaShrapnel = CreateLWeaponAt(LW_SPARKLE,Link->X,Link->Y);
	PegaShrapnel->UseSprite(SP_PEGASUSBREAK);
	PegaShrapnel->Flip = FLIP_BOTH;
	PegaShrapnel->Dir = DIR_RIGHTDOWN;
	PegaShrapnel->Step = 100;
}
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// PegasusShrapnel() function (end)
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------

// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// PegasusBonk() function (start)
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
void PegasusBonk()
{
	if (Link->Dir == DIR_UP && Screen->ComboT[ComboAt(Link->X+7,Link->Y-1)] != CT_WATER || Link->Dir == DIR_DOWN && Screen->ComboT[ComboAt(Link->X+7,Link->Y+17)] != CT_WATER || Link->Dir == DIR_LEFT && Screen->ComboT[ComboAt(Link->X-1,Link->Y+8)] != CT_WATER || Link->Dir == DIR_RIGHT && Screen->ComboT[ComboAt(Link->X+17,Link->Y+8)] != CT_WATER)
	{
		if (IsSideview())
		{
			if (Link->Jump == 0 && Link->Dir != DIR_DOWN && Link->Dir != DIR_UP) Link->Jump = 1.5;
		}
		else
		{
			Link->Z = 1;
			if (Link->Dir == DIR_UP) Link->Jump = 3;
			else Link->Jump = 2.5;
		}
		if (Screen->Quake <= 0) Screen->Quake = 8;
		lweapon FirstSomariaBlock = LoadLWeaponOf(LW_SOMARIA);
		if (!FirstSomariaBlock->isValid() || FirstSomariaBlock->X > Link->X + 20 || FirstSomariaBlock->X < Link->X - 20 || FirstSomariaBlock->Y > Link->Y + 20 || FirstSomariaBlock->Y < Link->Y - 20) Game->PlaySound(SFX_PEGABONK);
		if (Link->Dir == DIR_UP)
		{
			if (Screen->Door[DOOR_UP] == D_BOMB || Screen->Door[DOOR_UP] == D_WALKTHRU)
			{
				if (Link->Y < 50)
				{
					if (Link->X > 112)
					{
						if (Link->X < 128)
						{
							lweapon BreakDoor = CreateLWeaponAt(LW_BOMBBLAST,Link->X,Link->Y);
							BreakDoor->DrawYOffset = 255;
							BreakDoor->HitYOffset = 255;
							Game->PlaySound(SFX_SECRET);
							if (Screen->Door[DOOR_UP] == D_WALKTHRU) Screen->Door[DOOR_UP] = D_BOMBED;
						}
					}
				}
			} 
			if (Screen->ComboF[ComboAt(Link->X+7,Link->Y-1)] == CF_PEGASUSITEM)
			{
				if (!Screen->State[ST_SPECIALITEM])
				{
					Screen->ComboF[ComboAt(Link->X+7,Link->Y-1)] = CF_NONE;
					item BootGet = CreateItemAt(Screen->RoomData,ComboX(ComboAt(Link->X+7,Link->Y-1)),ComboY(ComboAt(Link->X+7,Link->Y-1)-16));
					BootGet->Pickup = IP_ST_SPECIALITEM + IP_HOLDUP;
					BootGet->Jump = 1;
					Game->PlaySound(SFX_PEGAITEM);
				}
			}
		}
		if (Link->Dir == DIR_DOWN)
		{
			if (Screen->Door[DOOR_DOWN] == D_BOMB || Screen->Door[DOOR_DOWN] == D_WALKTHRU)
			{
				if (Link->Y > 126)
				{
					if (Link->X > 112)
					{
						if (Link->X < 128)
						{
							lweapon BreakDoor = CreateLWeaponAt(LW_BOMBBLAST,Link->X,Link->Y);
							Game->PlaySound(SFX_SECRET);
							if (Screen->Door[DOOR_DOWN] == D_WALKTHRU) Screen->Door[DOOR_DOWN] = D_BOMBED;
						}
					}
				}
			}
			if (Screen->ComboF[ComboAt(Link->X+7,Link->Y+17)] == CF_PEGASUSITEM)
			{
				if (!Screen->State[ST_SPECIALITEM])
				{
					Screen->ComboF[ComboAt(Link->X+7,Link->Y+17)] = CF_NONE;
					item BootGet = CreateItemAt(Screen->RoomData,ComboX(ComboAt(Link->X+7,Link->Y+17)),ComboY(ComboAt(Link->X+7,Link->Y+17)+16));
					BootGet->Z = 16;
					BootGet->Pickup = IP_ST_SPECIALITEM + IP_HOLDUP;
					Game->PlaySound(SFX_PEGAITEM);
				}
			}
		}
		if (Link->Dir == DIR_LEFT)
		{
			if (Screen->Door[DOOR_LEFT] == D_BOMB || Screen->Door[DOOR_LEFT] == D_WALKTHRU)
			{
				if (Link->X < 35)
				{
					if (Link->Y > 72)
					{
						if (Link->Y < 88)
						{
							lweapon BreakDoor = CreateLWeaponAt(LW_BOMBBLAST,Link->X,Link->Y);
							Game->PlaySound(SFX_SECRET);
							if (Screen->Door[DOOR_LEFT] == D_WALKTHRU) Screen->Door[DOOR_LEFT] = D_BOMBED;
						}
					}
				}
			}
			if (Screen->ComboF[ComboAt(Link->X-1,Link->Y+8)] == CF_PEGASUSITEM)
			{
				if (!Screen->State[ST_SPECIALITEM])
				{
					Screen->ComboF[ComboAt(Link->X-1,Link->Y+8)] = CF_NONE;
					item BootGet = CreateItemAt(Screen->RoomData,ComboX(ComboAt(Link->X-1,Link->Y+8))-16,ComboY(ComboAt(Link->X-1,Link->Y+8)));
					BootGet->Jump = 1;
					BootGet->Pickup = IP_ST_SPECIALITEM + IP_HOLDUP;
					Game->PlaySound(SFX_PEGAITEM);
				}
			}
		}
		if (Link->Dir == DIR_RIGHT)
		{
			if (Screen->Door[DOOR_RIGHT] == D_BOMB || Screen->Door[DOOR_RIGHT] == D_WALKTHRU)
			{
				if (Link->X > 205)
				{
					if (Link->Y > 72)
					{
						if (Link->Y < 88)
						{
							lweapon BreakDoor = CreateLWeaponAt(LW_BOMBBLAST,Link->X,Link->Y);
							Game->PlaySound(SFX_SECRET);
							if (Screen->Door[DOOR_RIGHT] == D_WALKTHRU) Screen->Door[DOOR_RIGHT] = D_BOMBED;
						}
					}
				}
			}
			if (Screen->ComboF[ComboAt(Link->X+17,Link->Y+8)] == CF_PEGASUSITEM)
			{
				if (!Screen->State[ST_SPECIALITEM])
				{
					Screen->ComboF[ComboAt(Link->X+17,Link->Y+8)] = CF_NONE;
					item BootGet = CreateItemAt(Screen->RoomData,ComboX(ComboAt(Link->X+17,Link->Y+8))+16,ComboY(ComboAt(Link->X+17,Link->Y+8)));
					BootGet->Jump = 1;
					BootGet->Pickup = IP_ST_SPECIALITEM + IP_HOLDUP;
					Game->PlaySound(SFX_PEGAITEM);
				}
			}
		}
	}
}
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// PegasusBonk() function (end)
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------


// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// FourWayCurse() and SetInputDir() functions (start)
// By Moosh, from BrockLesnar.qst
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
void SetInputDir(int Dir)
{
	if(Link->Dir==DIR_UP) Link->InputUp = true;
	else if(Link->Dir==DIR_DOWN) Link->InputDown = true;
	else if(Link->Dir==DIR_LEFT) Link->InputLeft = true;
	else if(Link->Dir==DIR_RIGHT) Link->InputRight = true;
}

void FourWayCurse(int FWC)
{
	// NOTE: This function was written by Moosh, but I made some alterations.
	// Make sure to call FourWayCurse() as late as possible in the global script (but before WaitDraw(), so that it doesn't stop input checks from working.

	bool u; // up
	bool d; // down
	bool l; // left
	bool r; // right
	if(!Link->Item[I_PROGRESSIVEGEAR])
	{
		if (Link->Action < LA_ATTACKING || Link->Action == LA_SWIMMING)
		{
			if (Screen->ComboS[ComboAt(Link->X+7,Link->Y+8)] != 1111b)
			{
				if (Link->InputLeft && Link->InputRight || Link->InputLeft && Link->InputUp || Link->InputLeft && Link->InputDown || Link->InputRight && Link->InputUp || Link->InputRight && Link->InputDown)
				{
					if (Link->Action <= LA_WALKING)
					{
						Link->InputLeft = false;
						Link->InputRight = false;
					}
				}
				else if (Link->InputUp && Link->InputDown)
				{
					if (Link->Action <= LA_WALKING)
					{
						Link->InputUp = false;
						Link->InputDown = false;
					}
				}
				else
				{
					u = Link->InputUp;
					d = Link->InputDown;
					l = Link->InputLeft;
					r = Link->InputRight;
					if(Link->PressUp)
					{
						FWC = 1;
					}
					else if(Link->PressDown)
					{
						FWC = 2;
					}
					else if(Link->PressLeft)
					{
						FWC = 3;
					}
					else if(Link->PressRight)
					{
						FWC = 4;
					}
					int ButtonsPressed;
					if(u) ++ButtonsPressed;
					if(d) ++ButtonsPressed;
					if(l) ++ButtonsPressed;
					if(r) ++ButtonsPressed;
					Link->InputUp = false;
					Link->InputDown = false;
					Link->InputLeft = false;
					Link->InputRight = false;
					if(ButtonsPressed>1)
					{
						u = false;
						if(FWC==1) u = true;
						d = false;
						if(FWC==2) d = true;
						l = false;
						if(FWC==3) l = true;
						r = false;
						if(FWC==4) r = true;
						Link->InputUp = false;
						Link->InputDown = false;
						Link->InputLeft = false;
						Link->InputRight = false;
					}
					if(u)
					{
						if(Link->X%8==0)
						{
							Link->InputUp = true;
						}
						else if(Link->X%8==1||Link->X%8==7)
						{
							Link->X = Round((Link->X)/8)*8;
							Link->InputUp = true;
						}
						else if(Link->Dir==DIR_DOWN)
						{
							Link->X = Round((Link->X)/8)*8;
							Link->InputUp = true;
						}
						else
						{
							SetInputDir(Link->Dir);
						}
					}
					else if(d)
					{
						if(Link->X%8==0)
						{
							Link->InputDown = true;
						}
						else if(Link->X%8==1||Link->X%8==7)
						{
							Link->X = Round((Link->X)/8)*8;
							Link->InputDown = true;
						}
						else if(Link->Dir==DIR_UP)
						{
							Link->X = Round((Link->X)/8)*8;
							Link->InputDown = true;
						}
						else
						{
							SetInputDir(Link->Dir);
						}
					}
					else if(l)
					{
						if(Link->Y%8==0)
						{
							Link->InputLeft = true;
						}
						else if(Link->Y%8==1||Link->Y%8==7)
						{
							Link->Y = Round((Link->Y)/8)*8;
							Link->InputLeft = true;
						}
						else if(Link->Dir==DIR_RIGHT)
						{
							Link->Y = Round((Link->Y)/8)*8;
							Link->InputLeft = true;
						}
						else
						{
							SetInputDir(Link->Dir);
						}
					}
					else if(r)
					{
						if(Link->Y%8==0)
						{
							Link->InputRight = true;
						}
						else if(Link->Y%8==1||Link->Y%8==7)
						{
							Link->Y = Round((Link->Y)/8)*8;
							Link->InputRight = true;
						}
						else if(Link->Dir==DIR_LEFT)
						{
							Link->Y = Round((Link->Y)/8)*8;
							Link->InputRight = true;
						}
						else
						{
							SetInputDir(Link->Dir);
						}
					}
				}
			}
		}
	}
}
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// FourWayCurse() and SetInputDir() functions (end)
// By Moosh, from BrockLesnar.qst
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------

// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// LowerToUpper_Str() all-caps function (start)
// By Venrob
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
void LowerToUpper_Str(int buf)
{
    for(int q = 0; buf[q]; ++q)
    {
        buf[q] = LowerToUpper(buf[q]);
    }
}
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// LowerToUpper_Str() all-caps function (end)
// By Venrob
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------

// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// SetHurtNoise function (start)
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// Sets a unique hurt noise based on the player's costume.

void SetHurtNoise()
{
	// Fairy
	if (Game->Counter[CR_COSTUME] == COSTUME_FAIRY) RememberStuff[REMEMBER_HURTNOISE] = SFX_PEGAITEM;

	// Gardea
	else if (Game->Counter[CR_COSTUME] == COSTUME_GARDEA) RememberStuff[REMEMBER_HURTNOISE] = SFX_GARDEAHURT;

	// Commander Keen
	else if (Game->Counter[CR_COSTUME] == COSTUME_KEEN) RememberStuff[REMEMBER_HURTNOISE] = SFX_KEENHURT;

	// Moosh
	else if (Game->Counter[CR_COSTUME] == COSTUME_MOOSH) RememberStuff[REMEMBER_HURTNOISE] = SFX_MOOF;

	// Dimivee
	else if (Game->Counter[CR_COSTUME] == COSTUME_DIMIVEE) RememberStuff[REMEMBER_HURTNOISE] = SFX_SQUEAK;

	// Yoshi hurt noise
	else if (Game->Counter[CR_COSTUME] == COSTUME_YOSHI || Game->Counter[CR_COSTUME] == COSTUME_YOSHOT) RememberStuff[REMEMBER_HURTNOISE] = SFX_YOSHIHURT;

	// Lolo and Lala hurt noise
	else if (Game->Counter[CR_COSTUME] == COSTUME_LOLO || Game->Counter[CR_COSTUME] == COSTUME_LALA) RememberStuff[REMEMBER_HURTNOISE] = SFX_LOLOHURT;

	// Desio
	else if (Game->Counter[CR_COSTUME] == COSTUME_DESIO || Game->Counter[CR_COSTUME] == COSTUME_DESIO_UP) RememberStuff[REMEMBER_HURTNOISE] = SFX_DESIOHURT;

	// Riggs hurt noise
	else if (Game->Counter[CR_COSTUME] == COSTUME_RIGGS || Game->Counter[CR_COSTUME] == COSTUME_ELI) RememberStuff[REMEMBER_HURTNOISE] = SFX_RIGGSHURT;

	// LOTW Hurt noise
	else if (
		Game->Counter[CR_COSTUME] == COSTUME_HOLM 
		|| Game->Counter[CR_COSTUME] >= COSTUME_XEMN && Game->Counter[CR_COSTUME] <= COSTUME_POCHI
	) RememberStuff[REMEMBER_HURTNOISE] = SFX_LOTWHURT;

	// Dragonlord Hurt noise
	else if (Game->Counter[CR_COSTUME] == COSTUME_DRAGONLORD) RememberStuff[REMEMBER_HURTNOISE] = SFX_DWEHIT;

	// Dragon Warrior / Dragon Quest hurt noise
	else if (Game->Counter[CR_COSTUME] >= COSTUME_DQ1_HERO && Game->Counter[CR_COSTUME] <= COSTUME_DQ2_MOONBROOKE_B) RememberStuff[REMEMBER_HURTNOISE] = SFX_DWHURT;

	// Boss hurt noise
	else if (
		Game->Counter[CR_COSTUME] == COSTUME_UNCOOL
		|| Game->Counter[CR_COSTUME] >= COSTUME_AQUAMENTUS && Game->Counter[CR_COSTUME] <= COSTUME_ZELDA_SHADOW
	) RememberStuff[REMEMBER_HURTNOISE] = SFX_GASP;

	// Mario hurt noise
	else if (Game->Counter[CR_COSTUME] >= COSTUME_MARIO_A && Game->Counter[CR_COSTUME] <= COSTUME_WALUIGI_B) RememberStuff[REMEMBER_HURTNOISE] = SFX_MARIOHURT;

	// Monster hurt noise
	else if (
		Game->Counter[CR_COSTUME] >= COSTUME_DARKNUT && Game->Counter[CR_COSTUME] <= COSTUME_BARI
		|| Game->Counter[CR_COSTUME] == COSTUME_DARUNIA
	) RememberStuff[REMEMBER_HURTNOISE] = SFX_EHIT;

	// Link hurt noise
	else if (
		Game->Counter[CR_COSTUME] == COSTUME_LINK
		|| Game->Counter[CR_COSTUME] >= COSTUME_HARKINIAN && Game->Counter[CR_COSTUME] <= COSTUME_DUKE_ONKLED
		|| Game->Counter[CR_COSTUME] == COSTUME_ABEI
		|| Game->Counter[CR_COSTUME] == COSTUME_MERCHANT
		|| Game->Counter[CR_COSTUME] == COSTUME_LINK_BUNNY 
		|| Game->Counter[CR_COSTUME] == COSTUME_LINK_CHEERLEADER
		|| Game->Counter[CR_COSTUME] >= COSTUME_BOMBERMAN && Game->Counter[CR_COSTUME] <= COSTUME_BLACK_BOMBER
		|| Game->Counter[CR_COSTUME] == COSTUME_SIMON
		|| Game->Counter[CR_COSTUME] == COSTUME_DANA
		|| Game->Counter[CR_COSTUME] == COSTUME_POPOLON
		|| Game->Counter[CR_COSTUME] == COSTUME_UMINO
		|| Game->Counter[CR_COSTUME] == COSTUME_PICARD
		|| Game->Counter[CR_COSTUME] == COSTUME_LUKE
		|| Game->Counter[CR_COSTUME] >= COSTUME_HAN && Game->Counter[CR_COSTUME] <= COSTUME_KELL
		|| Game->Counter[CR_COSTUME] == COSTUME_BARGO
		|| Game->Counter[CR_COSTUME] == COSTUME_BIGJOE
		|| Game->Counter[CR_COSTUME] >= COSTUME_ZELOS && Game->Counter[CR_COSTUME] <= COSTUME_KNUCKLES
	) RememberStuff[REMEMBER_HURTNOISE] = SFX_LINKHURT;

	// Zelda hurt noise
		else RememberStuff[REMEMBER_HURTNOISE] = SFX_ZELDAHURT;
		//else if (
		//	Game->Counter[CR_COSTUME] == COSTUME_ZELDA
		//	|| Game->Counter[CR_COSTUME] >= COSTUME_MARIN_A && Game->Counter[CR_COSTUME] <= COSTUME_IMPA_YOUNG
		//	|| Game->Counter[CR_COSTUME] >= COSTUME_SUBROSIAN && Game->Counter[CR_COSTUME] <= COSTUME_ROSA 
		//	|| Game->Counter[CR_COSTUME] == COSTUME_LANA 
		//	|| Game->Counter[CR_COSTUME] == COSTUME_AMA 
		//	|| Game->Counter[CR_COSTUME] == COSTUME_APHRODITE
		//	|| Game->Counter[CR_COSTUME] >= COSTUME_NARU && Game->Counter[CR_COSTUME] <= COSTUME_NATSUKI
		//	|| Game->Counter[CR_COSTUME] >= COSTUME_EEVEE
		//) RememberStuff[REMEMBER_HURTNOISE] = SFX_ZELDAHURT;
	// end of Hurt Noise setting section
}
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// SetHurtNoise function (end)
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------

// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// Functions at global scope (end)
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------









// ---------------------------------------------- Section 4: Global script 
global script Plan6Global{
	void run()
	{


// --------------------------------------------------------
// --------------------------------------- Index of Global:
// --------------------------------------------------------

// --------------------------------------- Chapter 1: int, bool, lweapon, eweapon, npc, item declarations

// --------------------------------------- Chapter 2: First actions (before While)

// --------------------------------------- Chapter 3: While loop begins

// --------------------------------------- Chapter 4: Prevent rupoor underflow

// --------------------------------------- Chapter 5: Link (Zelda) is stunned + clock counter

// --------------------------------------- Chapter 6: Item: Hiding Shellmet

// --------------------------------------- Chapter 7: Mode menu

// --------------------------------------- Chapter 8: Link drowns, but only in Sideview  Link drowns, but only in Sideview 

// --------------------------------------- Chapter 9: Sideview Ladder combos

// --------------------------------------- Chapter 10: Spike-walking boots drain rupees slowly

// --------------------------------------- Chapter 11: Item: Medicine

// --------------------------------------- Chapter 12: Item: Guardian Acorn

// --------------------------------------- Chapter 13: Item: Duck Zapper

// --------------------------------------- Chapter 14: Item: Bow-Wow

// --------------------------------------- Chapter 15: Every-frame Item checks / for loop of Items

// --------------------------------------- Chapter 16: Every-frame EWeapon checks / for loop of EWeapons

// --------------------------------------- Chapter 17: Every-frame NPC checks / for loop of NPCs

// --------------------------------------- Chapter 18: Every-frame LWeapon checks / for loop of Lweapons

// --------------------------------------- Chapter 19: Item: Armos

// --------------------------------------- Chapter 20: Item: Pegasus Boots 

// --------------------------------------- Chapter 21: Item: Cane of Somaria and Item: Handy Glove

// --------------------------------------- Chapter 22: Somaria pushblocks

// --------------------------------------- Chapter 23: Item: Shovel

// --------------------------------------- Chapter 24: Item: Rope

// --------------------------------------- Chapter 25: Link (Zelda) falls like a rock in sideview

// --------------------------------------- Chapter 26: Item: Beetle

// --------------------------------------- Chapter 27: Change color of first Byrna beam

// --------------------------------------- Chapter 28: Partner Follower & LTTP Superbomb

// --------------------------------------- Chapter 29: Windy Screens

// --------------------------------------- Chapter 30: Call FourWayCurse

// --------------------------------------- Chapter 31: Item: Lantern

// --------------------------------------- Chapter 31.5: Dimi's MirrorLink Stuff and other assorted jank you can try at home!

// --------------------------------------- Chapter 32: Waitdraw()




// --------------------------------------- Chapter 1: int, bool, lweapon, eweapon, npc, item declarations

		int EverySix;		// Counts down from 6 to check certain things every six frames, to increase operating efficiency.
		int EverySixty;		// Counts down from 60 to check certain things every sixty frames, to increase operating efficiency.

		int WindyTimer;		// Timer for windy screens.

		int StoodStill;		// A timer for how long Link (Zelda) has stood still, to don the shellmet.
		bool ShellmetOn;	// Checks when Link (Zelda) is wearing the shellmet.

		//bool BeingHurt;		// Checks when Link (Zelda) is hit for the Guardian Acorn counter.
		RememberStuff[REMEMBER_BEINGHURT] = 0;

		//int RememberStuff[REMEMBER_WHISPWAIT];		// Cooldown delay after teleporting between NPC_BUBBLE_WHISP_A and NPC_BUBBLE_WHISP_B.
		RememberStuff[REMEMBER_WHISPWAIT] = 0;

		bool IsDark;		// Set to true once Link (Zelda) enters a custom-dark room so it doesn't "light up" while scrolling away.

		bool LeftRight;		// Checks whether Link (Zelda) has more recently pressed left or right.

		bool JustDroppedPartner;// Checkers whether the player hast just seperated with the partner, to prevent immediately picking them back up before walking away.

		int RememberRooms[6];	// Stores the latest Screen->RoomData and Screen->RoomType unless the player is on Screen >= 128.
			// --- Indices:
			//const int REMEMBER_ROOMDATA = 1;
			//const int REMEMBER_ROOMTYPE = 2;
			//const int REMEMBER_PRICE1 = 3;
			//const int REMEMBER_PRICE2 = 4;
			//const int REMEMBER_PRICE3 = 5;
			//const int REMEMBER_DARK = 6;

		bool HoldingMouse;	// Used to make mouse effects once-per-click (in lieu of "PressMouseB" existing).
		int DuckDelay;		// Delay on the duck.

		lweapon SomariaBlock;	// LWeapon identifier for Cane of Somaria blocks.

		lweapon FirstByrna;	// Lweapon identifier for the first Cane of Byrna beam onscreen.

		lweapon GloveWeapon;	// LWeapon identifier for extra kinds of things that can break handy glove blocks.

		bool MagnetHold;	// True if holding the magnet button, affects magnet inventory switch.
		lweapon MagnetBeam;	// Lweapon identifier for the magnet
		int MagnetDir;		// Direction tracker for magnet strafing

		bool PegasusDash;	// True if dashing.
		int PegasusTimer;	// Timer used for dashing with pegasus boots.
		int PegasusDir;		// Tracks Link->Dir when charging with boots.
		lweapon BootStab;	// Lweapon identifier for stabbing with the Pegasus Boots with LW_LANMOLA.
		int PegasusFailSafeTimer;	//Timer to stop pegasus knockback in sideview if it goes on for too long.
	
		int SpikeBootsTimer;	// Timer for vanilla spike-resistant boots to use up rupees slowly.

		bool DeadBeetle;	// Bool that checks if Beetle is destroyed.
		bool BeetleCarrying;	// Bool that sets the Beetle into "carrying an object" mode.
		lweapon Beetle;		// Lweapon identifier for the Beetle.
		lweapon BeetleLW;	// LWeapon being carried by the Beetle.
		eweapon BeetleEW;	// EWeapon being carried by the Beetle.
		item BeetleItem;	// Item being carried by the Beetle.

		lweapon RopeWeapon;	// LWeapon identifier for the rope.
		lweapon LadderWeapon;	// LWeapon identifier for the ladder (sideview).

		lweapon ArmosFriend;	// LWeapon identifier for the Armos.
		int ArmosStatus[11];	// Armos item movement array.
		//FRIEND_TIMER = 1;
		//FRIEND_IFRAMES = 2;
		//FRIEND_STARTX = 3;
		//FRIEND_STARTY = 4;
		//FRIEND_LINK_STARTX = 5;
		//FRIEND_LINK_STARTY = 6;
		//FRIEND_GOX = 7;
		//FRIEND_GOY = 8;
		//FRIEND_HP = 9;
		//FRIEND_SNOOZE = 10;
		ArmosStatus[FRIEND_HP] = 2;
		int RememberArmos[5];
		//REMEMBER_ARMOS_MAP = 1;
		//REMEMBER_ARMOS_SCREEN = 2;
		//REMEMBER_ARMOS_X = 3;
		//REMEMBER_ARMOS_Y = 4;

		int TopDuck[7];
		//DUCKSHOT_DIR = 1;
		//DUCKSHOT_X = 2;
		//DUCKSHOT_STEP = 3;
		//DUCKSHOT_FIRE = 4;
		//DUCKSHOT_TARGET = 5;
		//DUCKSHOT_BULLET = 6;
		TopDuck[DUCKSHOT_X] = Rand(33,243);

		lweapon BowWow;		// LWeapon identifier for BowWow.
		int BowWowStatus[7];
		//BOWWOW_TIMER		Bow-Wow movement timer.
		//BOWWOW_EAT		Bow-Wow random eating.
		//BOWWOW_GOX		Bow-Wow tries to go to X.
		//BOWWOW_GOY		Bow-Wow tries to go to Y.
		//BOWWOW_BOUNCE		Bow-Wow bouncing animation offset.
		//BOWWOW_EATDELAY	Delay on eating non-targeted enemies
		npc BowWowTarget;	// NPC for Bow-wow to attempt to eat.
		bool BowWowSecret;	// True if Bow-Wow has displayed the secret message at his current location.

		//int RememberStuff[REMEMBER_DIGDELAY];		// Shovel timer.
		RememberStuff[REMEMBER_DIGDELAY] = 0;	
		lweapon DirtThrow;	// LWeapon identifier for shovel dirt; also used to figure out dug-up items.

		lweapon randoLW;	// A general-purpose LWeapon that is used to check all LWeapons in loops.
		eweapon randoEW;	// A general-purpose EWeapon that is used to check all EWeapons in loops.
		npc randoNPC;		// A general-purpose NPC that is used to check all NPCs in loops.
		ffc randoFFC;		// A general-purpose FFC that is used to check all FFCs in loops.
		item randoitem;		// A general-purpose item that is used to check all items in loops.
		itemdata randoitemdata;	// A general-purpose itemdata that is used to check all itemdata in loops.
		int ForTimer;		// Used in "for" statements that count a varying number of things, such as NumLWeapons.
		int ForTimerTwo;	// As ForTimer, but used for a second loop inside a first loop (rare).

		itemdata SpikeBoots = Game->LoadItemData(I_BOOTS); // The vanilla boots item, with a scripted rupee cost.
		int SideviewYCheckModify;	// Is 9 if Sideview, 0 if not.

		bool FallSound;		// Bool to only play SFX_PLAYERFALL once per fall.

		//int FWC[3];		// Array for Moosh's "4 way curse" walking script.

		bool GettingHurt;	// Bool to only play hurt noises once per hit.

		Game->MCounter[CR_LINKSTUN] = 65535;
		if (Game->MCounter[CR_ACORNS] == 0) Game->MCounter[CR_ACORNS] = 16;

		int ModeMenu[15];				// Used to turn on / off the mode settings menu, and for various setting effects.
		ModeMenu[MODEMENU_Y] = -MODEMENU_HEIGHT -56;	// Start position of the Mode Menu to be drawn at

		// Strings for Mode settings
		int MODE_MUSICFILE[22]="MUSIC FILE";
		int MODE_MUSICMIDI[5]="MIDI";
		int MODE_MUSICTRACK[22]="MUSIC TRACK (B-UNDO)";
		int MODE_EASYWALK[19]="8 WAY WALK & SLASH";
		int MODE_SHIELD[7] = "SHIELD";
		int MODE_DOUBLEDEF[15] = "DOUBLE DEFENSE";
		int MODE_HEROCHARM[25]="SEE HP,NAMES,& AREA#";
		//int MODE_HEROCHARM[24]="SEE ENEMY HP + NAMES";
		int MODE_HEARTFILL[18]="CONTINUE WITH:";
		int MODE_Z1HEARTS[24]="3 HEARTS";
		int MODE_STARTHEARTS[24]="FULL HEARTS";
		int MODE_HEARTRING[24]="FULL+AUTOFILL";
		int MODE_NOHEARTS[15]="NO HEART DROPS";
		int MODE_TOUGHMONSTERS[17]="TOUGHER MONSTERS";
		int MODE_WEAKMONSTERS[17]="WEAKER MONSTERS";
		int MODE_ZAPPER[22]="ZAPPER DUCKS";
		int MODE_EXTRA[22]="SPAWN MORE MONSTERS";
		int MODE_LINK[13]="COSTUME";
		int MODE_WORLDGFX[17]="WORLD REDECORATE";
		int MODE_PARTNER[15]="SUMMON PARTNER";
		int MODE_WEATHER[12]="ENVIRONMENT";
		int MODE_ITEMSGFX[24]="CONFUSING ITEM GFX";
		int MODE_CYCLE[6]="CYCLE";
		//int TEXT_EX2[4]="EX2"; Unused text
		int TEXT_EX4[4]="EX4";
		int MODE_ON[4]="ON";
		int MODE_OFF[4]="OFF";
		int MODE_SLOW[5]="SLOW";
		int MODE_FAST[5]="FAST";
		int MUSICNAME_BUFFER[256];
		int MUSICNAME_COMPARE[256];
		int MUSICNAME_UNDOBUFFER[256];
		int MUSICNAME_BLANK[1];
		int MODE_LABEL[6]="MODE-";
		int ENEMYNAME_BUFFER[256];
		int STR_SCREEN[8] = "AREA#";
		//int RememberStuff[REMEMBER_ENEMYNAMEWAIT];
		RememberStuff[REMEMBER_ENEMYNAMEWAIT] = 0;
		int MODE_MENUPANE[17] = "SUBSCREEN BORDER";
		int MODE_PICTOBOX[13] = "Z3 SCROLLING";
		int MODE_SAVE1[10] = "SAVE HERE";
		int MODE_SAVE2[20] = "SAVE HERE (PRESS A)";
		int MODE_SAVE3[30] = "GAME SAVED & SAVED PLACE SET.";
		int MODE_SAVE4[10] = "SAVING...";
		//int MODE_EX1[3] = "EX1 ITEM:"
		//int ENVIRONMENT_WARNING[33] = 	"Sprites may display abnormally";
		int ENVIRONMENT_FLICKER[33] = 		"MAY CAUSE SLIGHT FLICKERING.";
		int ENVIRONMENT_DYNAMICMESSAGE[33] = 	"SPECIAL WEATHER FOR EACH AREA!";
		int HeUsesIt[26] = "LOOK OUT! HE USES IT TOO!";
		int BitmapOffset[3];

		bool ShowHeldItem;		// used by special drawn weather / environment modes to check if Link is holding up an item
		item FakeItem;			// used by special drawn weather / environment modes to draw Link's held item
		bool HasSaved;



// ---------------------------------------  Chapter 2: First actions (before While)

// Load current undo track upon startup
		ModeMenu[UNDO_MUSICTRACK] = Game->GetDMapMusicTrack(Game->GetCurDMap());
		Game->GetDMapMusicFilename(Game->GetCurDMap(), MUSICNAME_UNDOBUFFER);


// Item: Link Costume mode effect is re-set upon continue
		if (Link->Item[I_LINKCOSTUME])
		{
			CopyTileRow(COSTUMECOPY_TILE + (Game->Counter[CR_COSTUME] * 260),PLAYER_TILES,200);
			CopyTileRow(COSTUMEVICTORY_TILES + (Game->Counter[CR_COSTUME] * 260),PLAYERVICTORY_TILES,9);
		}

// Item: Partner costume effect is re-set upon continue
		if (Link->Item[I_PARTNER]) CopyTileRow(COSTUMECOPY_TILE + ((Game->Counter[CR_PCOSTUME]-1) * 260),PARTNER_TILES,200);

// Item: Grass Graphics (Alternate Colors) mode effect is re-set upon continue
		if (Link->Item[I_WORLDGFX]) CopyTileRow(GRASSCOPY_TILE,OVERWORLD_TILE,260);

// Item: ItemGFX (Alternate Item Graphics) mode effect is re-set upon continue
		if (Link->Item[I_ITEMSGFX]) CopyTileRow(ITEMSCOPY_TILE,ITEMS_TILE,260);

// Subscreen border graphics mode is re-set upon continue
		if (Game->Counter[CR_PANECOLOR] > 0)
		{
			if (Game->Counter[CR_PANECOLOR] < 10)
			{
				CopyTileRow(TILE_MENUCOPY+(Game->Counter[CR_PANECOLOR]*2),TILE_MENUPANE,2);
				CopyTileRow(TILE_MENUCOPY+20+(Game->Counter[CR_PANECOLOR]*2),TILE_MENUPANE+20,2);
			}
			else
			{
				CopyTileRow(TILE_MENUCOPY+20+(Game->Counter[CR_PANECOLOR]*2),TILE_MENUPANE,2);
				CopyTileRow(TILE_MENUCOPY+40+(Game->Counter[CR_PANECOLOR]*2),TILE_MENUPANE+20,2);
			}
		}

// Half-heart maximums display on passive subscreen
		if (Link->MaxHP == 56) CopyTileRow(TILE_HUD_HALFHEART,TILE_HUD_HEARTOVERLAY,4);
		else if (Link->MaxHP == 72) CopyTileRow(TILE_HUD_HALFHEART+20,TILE_HUD_HEARTOVERLAY,4);
		else if (Link->MaxHP == 88) CopyTileRow(TILE_HUD_HALFHEART+40,TILE_HUD_HEARTOVERLAY,4);
		else if (Link->MaxHP == 104) CopyTileRow(TILE_HUD_HALFHEART+60,TILE_HUD_HEARTOVERLAY,4);
		else if (Link->MaxHP == 120) CopyTileRow(TILE_HUD_HALFHEART+80,TILE_HUD_HEARTOVERLAY,4);
		else if (Link->MaxHP == 136) CopyTileRow(TILE_HUD_HALFHEART+100,TILE_HUD_HEARTOVERLAY,4);
		else if (Link->MaxHP == 152) CopyTileRow(TILE_HUD_HALFHEART+120,TILE_HUD_HEARTOVERLAY,4);
		else if (Link->MaxHP == 168) CopyTileRow(TILE_HUD_HALFHEART+140,TILE_HUD_HEARTOVERLAY,4);
		else if (Link->MaxHP == 184) CopyTileRow(TILE_HUD_HALFHEART+160,TILE_HUD_HEARTOVERLAY,4);
		else if (Link->MaxHP == 200) CopyTileRow(TILE_HUD_HALFHEART+180,TILE_HUD_HEARTOVERLAY,4);
		else if (Link->MaxHP == 216) CopyTileRow(TILE_HUD_HALFHEART+200,TILE_HUD_HEARTOVERLAY,4);
		else if (Link->MaxHP == 232) CopyTileRow(TILE_HUD_HALFHEART+220,TILE_HUD_HEARTOVERLAY,4);
		else if (Link->MaxHP == 248) CopyTileRow(TILE_HUD_HALFHEART+240,TILE_HUD_HEARTOVERLAY,4);

// Full Starting Hearts mode effect
		if (Link->Item[I_STARTHEARTS]) Link->HP = Link->MaxHP;

// Full Starting MP (dummied out because no MP, but included for posterity)
		//Link->MP = Link->MaxMP;

// No stun upon continue
		Game->Counter[CR_LINKSTUN] = 0;

// Blank all Partner[] indices when global resets
// These can be removed if you want the game to save these values for the partner, like if you want to be able to leave them on a screen somewhere while saving and quitting; but for simplicity's sake I've got them all resetting to 0 here.
		Partner[FOLLOW_X] = 0;
		Partner[FOLLOW_Y] = 0;
		Partner[FOLLOW_TIMER] = 0;
		Partner[FOLLOW_DISPLAY] = 0;
		Partner[FOLLOW_STATE] = 0;
		Partner[FOLLOW_SCREEN] = 0;
		Partner[FOLLOW_MAP] = 0;
		Partner[FOLLOW_DIR] = 0;
		Partner[FOLLOW_ACTION] = 0;
		Partner[FOLLOW_ATIMER] = 0;
		Partner[FOLLOW_SHOOT] = 0;	
		Partner[STORE_FOLLOW_X] = 0;
		Partner[STORE_FOLLOW_Y] = 0;
		Partner[STORE_COSTUME] = 0;

// Default hurt noise
		if (RememberStuff[REMEMBER_HURTNOISE] == 0) RememberStuff[REMEMBER_HURTNOISE] = SFX_ZELDAHURT;

		DoDraw = true;

//Debug feature; dummied out:
//Game->Cheat = 4;

	//Reset darkness Dynamic Environment timer
	RememberStuff[REMEMBER_DARKTIMER] = 0;
	RememberStuff[REMEMBER_LINKPROMPT] = 0;

// If player dies/F6s out of Rando's spoiler log, reset spoiler log open state. (see ffc script "SpoilerLogAnywhere" in "Mitsukara6thrando.zs" for details.)
if (RememberStuff[REMEMBER_EX3_SPOILERLOG] == 2) RememberStuff[REMEMBER_EX3_SPOILERLOG] = 1;


// --------------------------------------- Chapter 3: While loop begins

		while(true)
		{
			Waitframe();

// --------------------------------------- Chapter 4: Every six frames stuff / Every sixty frames stuff

			if (IsRandomizer() && Game->GetCurDMap() == 0)
			{
				if (Game->GetCurScreen() == 126 || Game->GetCurScreen() == 107 || Game->GetCurScreen() == 50) 
				{
					Screen->SetTileWarp(0, 0x4F, DMAP_CAVES, 5);
				}
				if ((RememberStuff[REMEMBER_RANDO_OPTIONS+0] || Game->GetCurScreen() == 75) && (Screen->RoomType == RT_SHOP && 
				(Screen->RoomData == 7 || Screen->RoomData == 11 || Screen->RoomData == 12 || Screen->RoomData == 13 || Screen->RoomData == 14)))
				{
					if (Screen->GetTileWarpType(0) == 0)
					{
						Screen->SetTileWarp(0, 0x4F, DMAP_CAVES, 5);
					}
				}
				if (RememberStuff[REMEMBER_RANDO_OPTIONS+11] && (Screen->RoomType == RT_POTIONSHOP || Game->GetCurScreen() == 101 || Game->GetCurScreen() == 119)) Screen->SetTileWarp(0, 0x4F, DMAP_CAVES, 5);
				if (RememberStuff[REMEMBER_RANDO_OPTIONS+10] &&
				(Game->GetCurScreen() == 66 || Game->GetCurScreen() == 19 || Game->GetCurScreen() == 105 || Game->GetCurScreen() == 87
				|| Game->GetCurScreen() == 91 || Game->GetCurScreen() == 39 || Game->GetCurScreen() == 84 || Game->GetCurScreen() == 124))
				{
					Screen->SetTileWarp(0, 0x4F, DMAP_CAVES, 5);
				}
			}

			if (EverySix == 0)
			{
				EverySix = 6;

			// --- Remember Room information for shops (to display prices in drawn environment modes)
			// See also: Weather
				if (Game->GetCurScreen() < 128)
				{
					if (RememberRooms[REMEMBER_ROOMDATA] != Screen->RoomData) RememberRooms[REMEMBER_ROOMDATA] = Screen->RoomData;
					if (RememberRooms[REMEMBER_ROOMTYPE] != Screen->RoomType) RememberRooms[REMEMBER_ROOMTYPE] = Screen->RoomType;
				}
				if (Game->GetCurDMap() != DMAP_CAVES && Game->GetCurScreen() < 128)
				{
					RememberStuff[REMEMBER_ROOMDATA2] = RememberRooms[REMEMBER_ROOMDATA];
					RememberStuff[REMEMBER_ROOMTYPE2] = RememberRooms[REMEMBER_ROOMTYPE];
					RememberStuff[REMEMBER_SCREEN] = Game->GetCurScreen();
				}

			// --- Half-heart container stuff
				if (RememberStuff[REMEMBER_HP] != Link->MaxHP)
				{
					// Remembers heart container halves when using cheats (because ZC's cheat menu rounds them down to even numbers):
					if (RememberStuff[REMEMBER_HP] < Link->MaxHP) RememberStuff[REMEMBER_HP] = Link->MaxHP;
					else if (Link->MaxHP == RememberStuff[REMEMBER_HP] - 8) Link->MaxHP = RememberStuff[REMEMBER_HP];

					// Displays the half-heart maximum unit on the passive subscreen:
					if (Link->MaxHP == 56) CopyTileRow(TILE_HUD_HALFHEART,TILE_HUD_HEARTOVERLAY,4);
					else if (Link->MaxHP == 72) CopyTileRow(TILE_HUD_HALFHEART+20,TILE_HUD_HEARTOVERLAY,4);
					else if (Link->MaxHP == 88) CopyTileRow(TILE_HUD_HALFHEART+40,TILE_HUD_HEARTOVERLAY,4);
					else if (Link->MaxHP == 104) CopyTileRow(TILE_HUD_HALFHEART+60,TILE_HUD_HEARTOVERLAY,4);
					else if (Link->MaxHP == 120) CopyTileRow(TILE_HUD_HALFHEART+80,TILE_HUD_HEARTOVERLAY,4);
					else if (Link->MaxHP == 136) CopyTileRow(TILE_HUD_HALFHEART+100,TILE_HUD_HEARTOVERLAY,4);
					else if (Link->MaxHP == 152) CopyTileRow(TILE_HUD_HALFHEART+120,TILE_HUD_HEARTOVERLAY,4);
					else if (Link->MaxHP == 168) CopyTileRow(TILE_HUD_HALFHEART+140,TILE_HUD_HEARTOVERLAY,4);
					else if (Link->MaxHP == 184) CopyTileRow(TILE_HUD_HALFHEART+160,TILE_HUD_HEARTOVERLAY,4);
					else if (Link->MaxHP == 200) CopyTileRow(TILE_HUD_HALFHEART+180,TILE_HUD_HEARTOVERLAY,4);
					else if (Link->MaxHP == 216) CopyTileRow(TILE_HUD_HALFHEART+200,TILE_HUD_HEARTOVERLAY,4);
					else if (Link->MaxHP == 232) CopyTileRow(TILE_HUD_HALFHEART+220,TILE_HUD_HEARTOVERLAY,4);
					else if (Link->MaxHP == 248) CopyTileRow(TILE_HUD_HALFHEART+240,TILE_HUD_HEARTOVERLAY,4);
					else CopyTileRow(TILE_HUD_NOHALVES,TILE_HUD_HEARTOVERLAY,4);
				}

			// --- Z1-esque minimum hearts behavior
				if (Link->MaxHP < 48)
				{
					Link->MaxHP = 48;
					Link->HP = 1;
					// Technically it would be 0 in Z1, but you die in ZC when that happens. I could do some convoluted thing to prevent Link from dying at 0 or to make it look like 0, but whatever, this is close enough.
				}


			// --- Prevent rupoor underflow:
				if (Game->Counter[CR_RUPEES] > 65500) Game->Counter[CR_RUPEES] = 0;
			}
			else --EverySix;


			if (EverySixty == 0)
			{
				 EverySixty = 60;
				// --- Tablet Fragment inventory item
				if (!Link->Item[I_FRAGMENT_SUBSCREEN])
				{
					if (TabletFragments[Game->GetCurDMap()] == 1) Link->Item[I_FRAGMENT_SUBSCREEN] = true;
				}
				else
				{
					if (TabletFragments[Game->GetCurDMap()] == 0) Link->Item[I_FRAGMENT_SUBSCREEN] = false;
				}
			}
			else --EverySixty;

// --------------------------------------- Chapter 5: Link (Zelda) is stunned + clock counter
			if (Game->Counter[CR_LINKSTUN] > 0)
			{
				--Game->Counter[CR_LINKSTUN];
				if (Game->Counter[CR_LINKSTUN] > 40)
				{
					NoAction();
					Screen->FastTile(3,Link->X+Link->DrawXOffset,(Link->Y+Link->DrawYOffset)-Link->Z,Link->Tile,Choose(7,8),128);
				}
			}
			// Clock counter
			if (Game->Counter[CR_CLOCK] > 0)
			{
				--Game->Counter[CR_CLOCK];
				if (Link->Action == LA_SCROLLING) Game->Counter[CR_CLOCK] = 0;
			}
			
// --------------------------------------- Chapter 6: Item: Hiding Shellmet (Start)
			if (Link->Item[I_SHELLMET])
			{
				if (DoDraw)
				{
					if (ModeMenu[MODEMENU_ON] == 0)
					{
						Game->Counter[CR_SHELLMET] = StoodStill / 15;

						if (Link->Action > LA_NONE || Game->DCounter[CR_LIFE] != 0 || Link->InputDown || Link->InputUp || NumLWeaponsOf(LW_CANEOFBYRNA) > 0)
						// Note: The reason this checks inputup and input down is for when Link climbs a scripted sideview ladder combo.
						{
							if (StoodStill > 0) --StoodStill;
							if (StoodStill > 3 && Link->Action < LA_ATTACKING) StoodStill = StoodStill - 2;
							//if (StoodStill > 105) StoodStill = StoodStill - 2;
							if (ShellmetOn)
							{
								Link->CollDetection = 1;
								ShellmetOn = false;
							}
						}
						else if (StoodStill < 120)
						{
							if (RememberStuff[REMEMBER_DIGDELAY] == 0)
							{
								if (Game->Counter[CR_LINKSTUN] <= 40) ++StoodStill;
							}
						}	
						if (StoodStill >= 120)
						{
							if (DoDraw)
							{
								if (Screen->ComboF[ComboAt(Link->X+7,Link->Y+8)] != CF_PEGASTOP && Screen->ComboI[ComboAt(Link->X+7,Link->Y+8)] != CF_PEGASTOP)
								{
									if (Game->GetCurDMap() > 0 || Game->GetCurScreen() < 128) Screen->FastTile(4, Link->X, (Link->Y - Link->Z) + (Link->DrawYOffset) - 4, SHELLMET_TILE,6,128);
								}
							}
							if (!ShellmetOn)
							{
								ShellmetOn = true;
								Link->CollDetection = 0;
							}
						}
					}
				}
			}
			else if (Game->Counter[CR_SHELLMET] > 0) Game->Counter[CR_SHELLMET] = 0;

// --------------------------------------- Chapter 6: Item: Hiding Shellmet (End)



// --------------------------------------- Chapter 7: Mode menu (start)
			if (ModeMenu[CHANGE_DMAPS] != Game->GetCurDMap())
			{
				ModeMenu[CHANGE_DMAPS] = Game->GetCurDMap();
				ModeMenu[UNDO_MUSICTRACK] = Game->GetDMapMusicTrack(Game->GetCurDMap());
				Game->GetDMapMusicFilename(Game->GetCurDMap(), MUSICNAME_UNDOBUFFER);
			}


			if (Link->PressStart)
			{
				ModeMenu[MODEMENU_ON] = 0;
				ModeMenu[COSTUME_SHOWNAME] = 0;
				ffc ModeFreezer1 = Screen->LoadFFC(30);
				if (ModeFreezer1->Data == COMBO_SCREENFREEZE1) ModeFreezer1->Data = 0;
				ffc ModeFreezer2 = Screen->LoadFFC(31);
				if (ModeFreezer2->Data == COMBO_SCREENFREEZE2) ModeFreezer2->Data = 0;
				ModeMenu[MODEMENU_Y] = -MODEMENU_HEIGHT -56;
				ModeMenu[MODEMENU_SHUTOFF] = 0;
				HasSaved = false;
			}

			if (Link->PressMap)
			{
				if (ModeMenu[MODEMENU_ON] == 0)
				{
					ffc ModeFreezer1 = Screen->LoadFFC(30);
					if (ModeFreezer1->Script == 0) ModeFreezer1->Data = COMBO_SCREENFREEZE1;
					ffc ModeFreezer2 = Screen->LoadFFC(31);
					if (ModeFreezer2->Script == 0) ModeFreezer2->Data = COMBO_SCREENFREEZE2;
					ModeMenu[1] = 1;
					Game->GetDMapMusicFilename(Game->GetCurDMap(), MUSICNAME_BUFFER);
					if (PlayingMIDIs)
					{
						ModeMenu[SELECT_MUSICTRACK] = Game->DMapMIDI[Game->GetCurDMap()];
					}
					else
					{
						ModeMenu[SELECT_MUSICTRACK] = Game->GetDMapMusicTrack(Game->GetCurDMap());
						ModeMenu[SELECT_MUSICFILE] = Game->GetCurDMap();
					}
				}
				else
				{
					if (ModeMenu[MODEMENU_SHUTOFF] == 0) ModeMenu[MODEMENU_SHUTOFF] = 1;
				}
			}
			if (ModeMenu[MODEMENU_ON] == 1)
			{
				if (ModeMenu[MODEMENU_SHUTOFF] != 0)
				{
					if (ModeMenu[MODEMENU_Y] > -MODEMENU_HEIGHT -56)
					{
						ModeMenu[MODEMENU_Y] = ModeMenu[MODEMENU_Y]-MODEMENU_SPEED;
						NoAction();
					}
					else
					{
						ffc ModeFreezer1 = Screen->LoadFFC(30);
						if (ModeFreezer1->Data == COMBO_SCREENFREEZE1) ModeFreezer1->Data = 0;
						ffc ModeFreezer2 = Screen->LoadFFC(31);
						if (ModeFreezer2->Data == COMBO_SCREENFREEZE2) ModeFreezer2->Data = 0;
						ModeMenu[MODEMENU_ON] = 0;
						ModeMenu[COSTUME_SHOWNAME] = 0;
						ModeMenu[MODEMENU_Y] = -MODEMENU_HEIGHT -56;
						ModeMenu[MODEMENU_SHUTOFF] = 0;
						HasSaved = false;
					}
				}
				else if (ModeMenu[MODEMENU_Y] < -56)
				{
					ModeMenu[MODEMENU_Y] = ModeMenu[MODEMENU_Y]+MODEMENU_SPEED;
					NoAction();
				}

				Screen->Rectangle(	
					MODE_DRAWLAYER,				//layer
					0,					//start X
					ModeMenu[MODEMENU_Y],			//start y
					256,					//end x
					ModeMenu[MODEMENU_Y]+MODEMENU_HEIGHT,	//end y
					0,1,0,0,0,true,128);
				Screen->FastTile(
					MODE_DRAWLAYER,
					0,
					ModeMenu[MODEMENU_Y] + MODEMENU_SPACE * ModeMenu[SELECT_MODE],
					ARROW_R_TILE,
					0,
					128);

			//--- Switches the settings
				if (Link->PressDown)
				{
					if (ModeMenu[SELECT_MODE] < SETTING_SAVE) ++ModeMenu[SELECT_MODE];
					else ModeMenu[SELECT_MODE] = 0;
					ModeMenu[COSTUME_SHOWNAME] = 0;
				}
				if (Link->PressUp)
				{ 
					if (ModeMenu[SELECT_MODE] > 0) --ModeMenu[SELECT_MODE];
					else ModeMenu[SELECT_MODE] = SETTING_SAVE;
					ModeMenu[COSTUME_SHOWNAME] = 0;
				}

			//--- Music File setting

				Screen->DrawString(MODE_DRAWLAYER, 9, ModeMenu[MODEMENU_Y]+1, FONT_Z1, 2, 0, TF_NORMAL, MODE_MUSICFILE, OP_OPAQUE);
				if (PlayingMIDIs) Screen->DrawString(MODE_DRAWLAYER, 241, ModeMenu[MODEMENU_Y]+1, FONT_Z1, 2, -1, TF_RIGHT, MODE_MUSICMIDI, OP_OPAQUE);
				else Screen->DrawString(MODE_DRAWLAYER, 245, ModeMenu[MODEMENU_Y]+1, FONT_Z1, 2, 0, TF_RIGHT, MUSICNAME_BUFFER, OP_OPAQUE);

				// --- Undo last choice on current dmap
				if (Link->PressB)
				{
					PlayingMIDIs = false;
					ModeMenu[SELECT_MUSICTRACK] = ModeMenu[UNDO_MUSICTRACK];
					ModeMenu[SELECT_MUSICFILE] = ModeMenu[UNDO_MUSICFILE];
					Game->PlayEnhancedMusic(MUSICNAME_UNDOBUFFER,ModeMenu[UNDO_MUSICTRACK]);
					Game->SetDMapEnhancedMusic(Game->GetCurDMap(),MUSICNAME_UNDOBUFFER,ModeMenu[UNDO_MUSICTRACK]);
					Game->GetDMapMusicFilename(Game->GetCurDMap(), MUSICNAME_BUFFER);
				}



				if (ModeMenu[SELECT_MODE] == SETTING_MUSICFILE)
				{
					Screen->DrawString(
						MODE_DRAWLAYER, 
						8, 
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_MUSICFILE), 
						FONT_Z1, 
						1, 
						-1, 
						TF_NORMAL, 
						MODE_MUSICFILE, 
						OP_OPAQUE);
					if (PlayingMIDIs) Screen->DrawString(
						MODE_DRAWLAYER, 
						240, 
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_MUSICFILE), 
						FONT_Z1, 
						1, 
						-1, 
						TF_RIGHT, 
						MODE_MUSICMIDI, 
						OP_OPAQUE);
					else Screen->DrawString(
						MODE_DRAWLAYER, 
						244, 
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_MUSICFILE), 
						FONT_Z1, 
						1, 
						-1, 
						TF_RIGHT, 
						MUSICNAME_BUFFER, 
						OP_OPAQUE);
	
					if (Link->PressA)
					{
						ModeMenu[SELECT_MUSICFILE] = Rand(20,48);
						if (ModeMenu[SELECT_MUSICFILE] > 38 && ModeMenu[SELECT_MUSICFILE] < 44) ModeMenu[SELECT_MUSICFILE] = Choose(ModeMenu[SELECT_MUSICFILE],Rand(20,38)); 
						if (ModeMenu[SELECT_MUSICFILE] >= 46) ModeMenu[SELECT_MUSICFILE] = 0;
						else if (ModeMenu[SELECT_MUSICFILE] == 45) ModeMenu[SELECT_MUSICFILE] = 100;
						else if (ModeMenu[SELECT_MUSICFILE] == 44) ModeMenu[SELECT_MUSICFILE] = 99;
						int FlippingACoin = Rand(1,2);
						if (FlippingACoin == 1) Link->PressLeft = true;
						else Link->PressRight = true; 
					}

					if (Link->PressRight)
					{
						if (PlayingMIDIs) PlayingMIDIs = false;
						for(ForTimer = ModeMenu[SELECT_MUSICFILE]; ForTimer < 511; ++ForTimer)
						{
							Game->GetDMapMusicFilename(ForTimer, MUSICNAME_COMPARE);
							if(strcmp(MUSICNAME_COMPARE,MUSICNAME_BUFFER) && MUSICNAME_COMPARE > 0 && strcmp(MUSICNAME_COMPARE,MUSICNAME_BLANK))
							{
								Game->GetDMapMusicFilename(ForTimer, MUSICNAME_BUFFER);
								ModeMenu[SELECT_MUSICFILE] = ForTimer;
								if (!Link->PressA) ModeMenu[SELECT_MUSICTRACK] = 1;
								else ModeMenu[SELECT_MUSICTRACK] = Choose(Rand(20),Rand(32));
								Game->PlayEnhancedMusic(MUSICNAME_COMPARE,ModeMenu[SELECT_MUSICTRACK]);
								Game->SetDMapEnhancedMusic(Game->GetCurDMap(),MUSICNAME_COMPARE,ModeMenu[SELECT_MUSICTRACK]);
								break;
							}
						}
					}
					if (Link->PressLeft)
					{
						if (ModeMenu[SELECT_MUSICFILE] <= 2)
						{
							PlayingMIDIs = true;
							Game->GetDMapMusicFilename(Game->GetCurDMap(), MUSICNAME_BUFFER);
							Game->SetDMapEnhancedMusic(Game->GetCurDMap(),1,0);

							if (!Link->PressA)
							{
								Game->PlayMIDI(Game->DMapMIDI[Game->GetCurDMap()]);
								ModeMenu[SELECT_MUSICTRACK] = Game->DMapMIDI[Game->GetCurDMap()];
							}
							else
							{
								ModeMenu[SELECT_MUSICTRACK] = Rand(52);
								Game->DMapMIDI[Game->GetCurDMap()] =  ModeMenu[SELECT_MUSICTRACK];
							}
							Game->PlayMIDI(Game->DMapMIDI[Game->GetCurDMap()]);
						}
						else
						{
							if (PlayingMIDIs) PlayingMIDIs = false;
							for(ForTimer = ModeMenu[SELECT_MUSICFILE]; ForTimer > 0; --ForTimer)
							{
								Game->GetDMapMusicFilename(ForTimer, MUSICNAME_COMPARE);
								if (strcmp(MUSICNAME_COMPARE,MUSICNAME_BUFFER))
								{
									if(MUSICNAME_COMPARE[0] && MUSICNAME_COMPARE[0] != ' ')
									{
										
										Game->GetDMapMusicFilename(ForTimer, MUSICNAME_BUFFER);
										ModeMenu[SELECT_MUSICFILE] = ForTimer;
										if (!Link->PressA) ModeMenu[SELECT_MUSICTRACK] = 1;
										else ModeMenu[SELECT_MUSICTRACK] = Choose(Rand(20),Rand(32));
										Game->PlayEnhancedMusic(MUSICNAME_BUFFER,ModeMenu[SELECT_MUSICTRACK]);
										Game->SetDMapEnhancedMusic(Game->GetCurDMap(),MUSICNAME_BUFFER,ModeMenu[SELECT_MUSICTRACK]);
										break;
									}
								}
							}
						}
					}
				}

			//--- Music Track setting
				Screen->DrawString(
					MODE_DRAWLAYER, 
					9, 
					ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_MUSICTRACK) + 1,
					FONT_Z1, 
					2, 
					0, 
					TF_NORMAL, 
					MODE_MUSICTRACK, 
					OP_OPAQUE);
				Screen->DrawInteger(
					MODE_DRAWLAYER,								//int layer, 
					209,									//int x, 
					ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_MUSICTRACK) + 1,	//int y, 
					FONT_Z1,								//int font, 
					2,									//int color, 
					0,									//int background_color, 
					-1,									//int width, 
					-1,									//int height, 
					ModeMenu[SELECT_MUSICTRACK],						//int number, 
					0, 									//int number_decimal_places, 
					128);									 //int opacity

				if (ModeMenu[SELECT_MUSICTRACK] >= 200) ModeMenu[SELECT_MUSICTRACK] = 0;

				if (ModeMenu[SELECT_MODE] == SETTING_MUSICTRACK)
				{

					if (Link->PressA)
					{
						if (PlayingMIDIs) ModeMenu[SELECT_MUSICTRACK] = Rand(82);
						else ModeMenu[SELECT_MUSICTRACK] = Choose(Rand(20),Rand(32));
						int FlippingACoin = Rand(1,2);
						if (FlippingACoin == 1) Link->PressLeft = true;
						else Link->PressRight = true; 
					}

					Screen->DrawString(MODE_DRAWLAYER, 8, ModeMenu[MODEMENU_Y]+MODEMENU_SPACE, FONT_Z1, 1, -1, TF_NORMAL, MODE_MUSICTRACK, OP_OPAQUE);
					Screen->DrawInteger(
						MODE_DRAWLAYER,				//int layer, 
						208,					//int x, 
						ModeMenu[MODEMENU_Y]+MODEMENU_SPACE,	//int y, 
						FONT_Z1,				//int font, 
						1,					//int color, 
						-1,					//int background_color, 
						-1,					//int width, 
						-1,					//int height, 
						ModeMenu[SELECT_MUSICTRACK],		//int number, 
						0, 					//int number_decimal_places, 
						128);					 //int opacity
					if (Link->PressRight)
					{
						++ModeMenu[SELECT_MUSICTRACK];
						if (PlayingMIDIs)
						{
							Game->PlayMIDI(ModeMenu[SELECT_MUSICTRACK]);
							Game->DMapMIDI[Game->GetCurDMap()] =  ModeMenu[SELECT_MUSICTRACK];
						}
						else
						{
							Game->PlayEnhancedMusic(MUSICNAME_BUFFER,ModeMenu[SELECT_MUSICTRACK]);
							Game->SetDMapEnhancedMusic(Game->GetCurDMap(),MUSICNAME_BUFFER,ModeMenu[SELECT_MUSICTRACK]);
						}
					}
					if (Link->PressLeft)
					{	
						if (PlayingMIDIs && ModeMenu[SELECT_MUSICTRACK] > 0 || ModeMenu[SELECT_MUSICTRACK] > 1)
						{
							--ModeMenu[SELECT_MUSICTRACK];
							if (PlayingMIDIs)
							{
								Game->PlayMIDI(ModeMenu[SELECT_MUSICTRACK]);
								Game->DMapMIDI[Game->GetCurDMap()] =  ModeMenu[SELECT_MUSICTRACK];
							}
							else
							{
								Game->PlayEnhancedMusic(MUSICNAME_BUFFER,ModeMenu[SELECT_MUSICTRACK]);
								Game->SetDMapEnhancedMusic(Game->GetCurDMap(),MUSICNAME_BUFFER,ModeMenu[SELECT_MUSICTRACK]);
							}
						}
						else if (PlayingMIDIs)
						{
							ModeMenu[SELECT_MUSICTRACK] = 83;
							if (PlayingMIDIs)
							{
								Game->PlayMIDI(ModeMenu[SELECT_MUSICTRACK]);
								Game->DMapMIDI[Game->GetCurDMap()] =  ModeMenu[SELECT_MUSICTRACK];
							}
						}
					}
				}

	//--- 8 Way Walk setting
	// See "FourWayCurse()" function above

				Screen->DrawString(
					MODE_DRAWLAYER, 
					9, 
					ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_8WAYWALK) + 1, 
					FONT_Z1, 
					8, 
					0, 
					TF_NORMAL, 
					MODE_EASYWALK, 
					OP_OPAQUE);
				if (Link->Item[I_PROGRESSIVEGEAR])
				{
					Screen->DrawString(
						MODE_DRAWLAYER, 
						209, 
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_8WAYWALK) + 1, 
						FONT_Z1, 
						8, 
						0, 
						TF_NORMAL, 
						MODE_ON, 
						OP_OPAQUE);	
					Screen->FastTile(
						MODE_DRAWLAYER,
						236,
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_8WAYWALK),
						GEAR_TILE,
						0,
						128);
				}
				else Screen->DrawString(
					MODE_DRAWLAYER, 
					209, 
					ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_8WAYWALK) + 1, 
					FONT_Z1, 
					8, 
					0, 
					TF_NORMAL, 
					MODE_OFF, 
					OP_OPAQUE);

				if (ModeMenu[SELECT_MODE] == SETTING_8WAYWALK)
				{
					Screen->DrawString(
						MODE_DRAWLAYER, 
						8, 
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_8WAYWALK) + 1, 
						FONT_Z1, 
						1, 
						-1, 
						TF_NORMAL, 
						MODE_EASYWALK, 
						OP_OPAQUE);
					if (Link->Item[I_PROGRESSIVEGEAR])
					{
						Screen->DrawString(
							MODE_DRAWLAYER, 
							208, 
							ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_8WAYWALK), 
							FONT_Z1, 
							1, 
							-1, 
							TF_NORMAL, 
							MODE_ON, 
							OP_OPAQUE);	
					}
					else Screen->DrawString(
						MODE_DRAWLAYER, 
						208, 
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_8WAYWALK), 
						FONT_Z1, 
						1, 
						-1, 
						TF_NORMAL, 
						MODE_OFF, 
						OP_OPAQUE);

					if (Link->PressA)
					{
						int FlippingACoin = Rand(2);
						if (FlippingACoin == 1)
						{
							Game->PlaySound(SFX_MODEON);
							Link->PressRight = true;
						}
						else Game->PlaySound(SFX_MODEOFF);
					}

					if (Link->PressRight || Link->PressLeft)
					{
						if (Link->Item[I_PROGRESSIVEGEAR])
						{
							Link->Item[I_PROGRESSIVEGEAR] = false;
							Game->Generic[GEN_CANSLASH] = 0;
							Game->PlaySound(SFX_MODEOFF);
						}
						else
						{
							Link->Item[I_PROGRESSIVEGEAR] = true;
							Game->Generic[GEN_CANSLASH] = 1;
							Game->PlaySound(SFX_MODEON);
						}
					}
				}

	//--- Shield setting
	//Effect is default Shield 1 item (93).

				Screen->DrawString(
					MODE_DRAWLAYER, 
					9, 
					ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_SHIELD) + 1, 
					FONT_Z1, 
					8, 
					0, 
					TF_NORMAL, 
					MODE_SHIELD, 
					OP_OPAQUE);
				if (Link->Item[I_SHIELD1])
				{
					Screen->DrawString(
						MODE_DRAWLAYER, 
						209, 
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_SHIELD) + 1, 
						FONT_Z1, 
						8, 
						0, 
						TF_NORMAL, 
						MODE_ON, 
						OP_OPAQUE);
					Screen->FastTile(
						MODE_DRAWLAYER,
						236,
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_SHIELD),
						SHIELD1_TILE,
						6,
						128);
				}
				else Screen->DrawString(
					MODE_DRAWLAYER, 
					209, 
					ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_SHIELD) + 1, 
					FONT_Z1, 
					8, 
					0, 
					TF_NORMAL, 
					MODE_OFF, 
					OP_OPAQUE);

				if (ModeMenu[SELECT_MODE] == SETTING_SHIELD) 
				{
					Screen->DrawString(
						MODE_DRAWLAYER, 
						8, 
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_SHIELD),
						FONT_Z1, 
						1, 
						-1, 
						TF_NORMAL, 
						MODE_SHIELD, 
						OP_OPAQUE);
					if (Link->Item[I_SHIELD1])
					{
						Screen->DrawString(
							MODE_DRAWLAYER, 
							208, 
							ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_SHIELD), 
							FONT_Z1, 
							1, 
							-1, 
							TF_NORMAL, 
							MODE_ON, 
							OP_OPAQUE);	
					}	
					else Screen->DrawString(
						MODE_DRAWLAYER, 
						208, 
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_SHIELD),
						FONT_Z1, 
						1, 
						-1, 
						TF_NORMAL, 
						MODE_OFF, 
						OP_OPAQUE);	

					if (Link->PressA)
					{
						int FlippingACoin = Rand(2);
						if (FlippingACoin == 1)
						{
							Game->PlaySound(SFX_MODEON);
							Link->PressRight = true;
						}
						else Game->PlaySound(SFX_MODEOFF);
					}

					if (Link->PressRight || Link->PressLeft)
					{
						if (Link->Item[I_SHIELD1])
						{
							Link->Item[I_SHIELD1] = false;
							Game->PlaySound(SFX_MODEOFF);
						}
						else
						{
							Link->Item[I_SHIELD1] = true;
							Game->PlaySound(SFX_MODEON);
						}
					}
				}

	//--- Double Defense setting
	//Effect is Peril Ring 2 item.

				Screen->DrawString(
					MODE_DRAWLAYER, 
					9, 
					ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_DOUBLEDEF) + 1, 
					FONT_Z1, 
					8, 
					0, 
					TF_NORMAL, 
					MODE_DOUBLEDEF, 
					OP_OPAQUE);
				if (Link->Item[I_PERILRING2])
				{
					Screen->DrawString(
						MODE_DRAWLAYER, 
						209, 
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_DOUBLEDEF) + 1, 
						FONT_Z1, 
						8, 
						0, 
						TF_NORMAL, 
						MODE_ON, 
						OP_OPAQUE);
					Screen->FastTile(
						MODE_DRAWLAYER,
						236,
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_DOUBLEDEF),
						DOUBLEDEF_TILE,
						0,
						128);
				}
				else Screen->DrawString(
					MODE_DRAWLAYER, 
					209, 
					ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_DOUBLEDEF) + 1, 
					FONT_Z1, 
					8, 
					0, 
					TF_NORMAL, 
					MODE_OFF, 
					OP_OPAQUE);

				if (ModeMenu[SELECT_MODE] == SETTING_DOUBLEDEF) 
				{
					Screen->DrawString(
						MODE_DRAWLAYER, 
						8, 
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_DOUBLEDEF),
						FONT_Z1, 
						1, 
						-1, 
						TF_NORMAL, 
						MODE_DOUBLEDEF, 
						OP_OPAQUE);
					if (Link->Item[I_PERILRING2])
					{
						Screen->DrawString(
							MODE_DRAWLAYER, 
							208, 
							ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_DOUBLEDEF), 
							FONT_Z1, 
							1, 
							-1, 
							TF_NORMAL, 
							MODE_ON, 
							OP_OPAQUE);	
					}	
					else Screen->DrawString(
						MODE_DRAWLAYER, 
						208, 
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_DOUBLEDEF),
						FONT_Z1, 
						1, 
						-1, 
						TF_NORMAL, 
						MODE_OFF, 
						OP_OPAQUE);	

					if (Link->PressA)
					{
						int FlippingACoin = Rand(2);
						if (FlippingACoin == 1)
						{
							Game->PlaySound(SFX_MODEON);
							Link->PressRight = true;
						}
						else Game->PlaySound(SFX_MODEOFF);
					}

					if (Link->PressRight || Link->PressLeft)
					{
						if (Link->Item[I_PERILRING2])
						{
							Link->Item[I_PERILRING2] = false;
							Game->PlaySound(SFX_MODEOFF);
						}
						else
						{
							Link->Item[I_PERILRING2] = true;
							Game->PlaySound(SFX_MODEON);
						}
					}
				}

	//--- See Enemy HP (Hero's Charm) setting

				Screen->DrawString(
					MODE_DRAWLAYER, 
					9, 
					ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_HEROCHARM) + 1, 
					FONT_Z1, 
					8, 
					0, 
					TF_NORMAL, 
					MODE_HEROCHARM, 
					OP_OPAQUE);
				if (Link->Item[I_HEROCHARM])
				{
					Screen->DrawString(
						MODE_DRAWLAYER, 
						209, 
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_HEROCHARM) + 1, 
						FONT_Z1, 
						8, 
						0, 
						TF_NORMAL, 
						MODE_ON, 
						OP_OPAQUE);
					Screen->FastTile(
						MODE_DRAWLAYER,
						236,
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_HEROCHARM),
						HEROCHARM_TILE,
						0,
						128);
				}
				else Screen->DrawString(
					MODE_DRAWLAYER, 
					209, 
					ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_HEROCHARM) + 1, 
					FONT_Z1, 
					8, 
					0, 
					TF_NORMAL, 
					MODE_OFF, 
					OP_OPAQUE);

				if (ModeMenu[SELECT_MODE] == SETTING_HEROCHARM) 
				{
					Screen->DrawString(
						MODE_DRAWLAYER, 
						8, 
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_HEROCHARM), 
						FONT_Z1, 
						1, 
						-1, 
						TF_NORMAL, 
						MODE_HEROCHARM, 
						OP_OPAQUE);
					if (Link->Item[I_HEROCHARM])
					{
						Screen->DrawString(
							MODE_DRAWLAYER, 
							208, 
							ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_HEROCHARM), 
							FONT_Z1, 
							1, 
							-1, 
							TF_NORMAL, 
							MODE_ON, 
							OP_OPAQUE);	
					}	
					else Screen->DrawString(
						MODE_DRAWLAYER, 
						208, 
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_HEROCHARM), 
						FONT_Z1, 
						1, 
						-1, 
						TF_NORMAL, 
						MODE_OFF, 
						OP_OPAQUE);	

					if (Link->PressA)
					{
						int FlippingACoin = Rand(2);
						if (FlippingACoin == 1)
						{
							Game->PlaySound(SFX_MODEON);
							Link->PressRight = true;
						}
						else Game->PlaySound(SFX_MODEOFF);
					}

					if (Link->PressRight || Link->PressLeft)
					{
						if (Link->Item[I_HEROCHARM])
						{
							Link->Item[I_HEROCHARM] = false;
							Game->PlaySound(SFX_MODEOFF);
						}
						else
						{
							Link->Item[I_HEROCHARM] = true;
							Game->PlaySound(SFX_MODEON);
						}
					}
				}

	//--- Full Starting Hearts setting
	//See "Full Starting Hearts effect" above, before While.

				Screen->DrawString(
					MODE_DRAWLAYER, 
					9, 
					ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_FULLHEART) + 1, 
					FONT_Z1, 
					8, 
					0, 
					TF_NORMAL, 
					MODE_HEARTFILL, 
					OP_OPAQUE);

				if (Link->Item[I_HEARTRING1])	//Default Heart Ring item (112)
				{
					Screen->DrawString(
						MODE_DRAWLAYER, 
						233, 
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_FULLHEART) + 1, 
						FONT_Z1, 
						8, 
						0, 
						TF_RIGHT, 
						MODE_HEARTRING, 
						OP_OPAQUE);
					Screen->FastTile(
						MODE_DRAWLAYER,
						236,
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_FULLHEART),
						AUTOLIFE_TILE,
						0,
						128);
				}
				else if (Link->Item[I_STARTHEARTS])
				{
					Screen->DrawString(
						MODE_DRAWLAYER, 
						233, 
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_FULLHEART) + 1, 
						FONT_Z1, 
						8, 
						0, 
						TF_RIGHT, 
						MODE_STARTHEARTS, 
						OP_OPAQUE);
					Screen->FastTile(
						MODE_DRAWLAYER,
						236,
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_FULLHEART),
						STARTHEARTS_TILE,
						1,
						128);
				}
				else Screen->DrawString(
					MODE_DRAWLAYER, 
					233, 
					ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_FULLHEART) + 1, 
					FONT_Z1, 
					8, 
					0, 
					TF_RIGHT, 
					MODE_Z1HEARTS, 
					OP_OPAQUE);

				if (ModeMenu[SELECT_MODE] == SETTING_FULLHEART) 
				{
					Screen->DrawString(
						MODE_DRAWLAYER, 
						8, 
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_FULLHEART), 
						FONT_Z1, 
						1, 
						-1, 
						TF_NORMAL, 
						MODE_HEARTFILL, 
						OP_OPAQUE);

					if (Link->Item[I_HEARTRING1]) 		Screen->DrawString(
											MODE_DRAWLAYER, 
											232, 
											ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_FULLHEART), 
											FONT_Z1, 
											1, 
											-1, 
											TF_RIGHT, 
											MODE_HEARTRING, 
											OP_OPAQUE);
					else if (Link->Item[I_STARTHEARTS]) 	Screen->DrawString(
											MODE_DRAWLAYER, 
											232, 
											ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_FULLHEART), 
											FONT_Z1, 
											1, 
											-1, 
											TF_RIGHT, 
											MODE_STARTHEARTS, 
											OP_OPAQUE);
					else 					Screen->DrawString(
											MODE_DRAWLAYER, 
											232, 
											ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_FULLHEART), 
											FONT_Z1, 
											1, 
											-1, 
											TF_RIGHT, 
											MODE_Z1HEARTS, 
											OP_OPAQUE);

					if (Link->PressA)
					{
						int FlippingACoin = Rand(3);
						if (FlippingACoin == 1)
						{
							Game->PlaySound(SFX_MODEON);
							Link->Item[I_STARTHEARTS] = true;
							Link->Item[I_HEARTRING1] = false;
						}
						else if (FlippingACoin == 2)
						{
							Game->PlaySound(SFX_MODEON);
							Link->Item[I_STARTHEARTS] = true;
							Link->Item[I_HEARTRING1] = true;
						}
						else
						{
							Game->PlaySound(SFX_MODEOFF);
							Link->Item[I_STARTHEARTS] = false;
							Link->Item[I_HEARTRING1] = false;
						}
					}

					if (Link->PressLeft)
					{
						Game->PlaySound(SFX_MODEOFF);
						if (Link->Item[I_HEARTRING1]) Link->Item[I_HEARTRING1] = false;
						else if (Link->Item[I_STARTHEARTS]) Link->Item[I_STARTHEARTS] = false;
					}
					else if (Link->PressRight)
					{
						Game->PlaySound(SFX_MODEON);
						if (!Link->Item[I_STARTHEARTS]) Link->Item[I_STARTHEARTS] = true;
						else Link->Item[I_HEARTRING1] = true;
					}
				}

	//---Weaker Monsters setting
	//see "Tougher / Weaker Monsters effect" below

				Screen->DrawString(
					MODE_DRAWLAYER, 
					9, 
					ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_WEAKMONSTERS) + 1, 
					FONT_Z1, 
					8, 
					0, 
					TF_NORMAL, MODE_WEAKMONSTERS, 
					OP_OPAQUE);
				if (Link->Item[I_WEAKMONSTERS])
				{
					Screen->DrawString(
						MODE_DRAWLAYER, 
						209, 
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_WEAKMONSTERS) + 1, 
						FONT_Z1, 
						8, 
						0, 
						TF_NORMAL,
						MODE_ON, 
						OP_OPAQUE);
					Screen->FastTile(
						MODE_DRAWLAYER,
						236,
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_WEAKMONSTERS),
						WEAKER_TILE,
						0,
						128);
				}
				else Screen->DrawString(
					MODE_DRAWLAYER, 
					209, 
					ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_WEAKMONSTERS) + 1, 
					FONT_Z1, 
					8, 
					0, 
					TF_NORMAL, 
					MODE_OFF, 
					OP_OPAQUE);		

				if (ModeMenu[SELECT_MODE] == SETTING_WEAKMONSTERS)
				{
					Screen->DrawString(
						MODE_DRAWLAYER, 
						8, 
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_WEAKMONSTERS), 
						FONT_Z1, 
						1, 
						-1, 
						TF_NORMAL, 
						MODE_WEAKMONSTERS, 
						OP_OPAQUE);
					if (Link->Item[I_WEAKMONSTERS])
					{
						Screen->DrawString(
							MODE_DRAWLAYER, 
							208, 
							ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_WEAKMONSTERS), 
							FONT_Z1, 
							1, 
							-1, 
							TF_NORMAL, 
							MODE_ON, 
							OP_OPAQUE);	
					}
					else Screen->DrawString(
						MODE_DRAWLAYER, 
						208, 
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_WEAKMONSTERS), 
						FONT_Z1, 
						1, 
						-1, 
						TF_NORMAL, 
						MODE_OFF, 
						OP_OPAQUE);

					if (Link->PressA)
					{
						int FlippingACoin = Rand(2);
						if (FlippingACoin == 1)
						{
							Game->PlaySound(SFX_MODEON);
							Link->PressRight = true;
						}
						else Game->PlaySound(SFX_MODEOFF);
					}

					if (Link->PressRight || Link->PressLeft)
					{
						if (Link->Item[I_WEAKMONSTERS])
						{
							Link->Item[I_WEAKMONSTERS] = false;
							Game->PlaySound(SFX_MODEOFF);
						}
						else
						{
							Link->Item[I_WEAKMONSTERS] = true;
							Link->Item[I_TOUGHMONSTERS] = false;
							Game->PlaySound(SFX_MODEON);
						}
					}		
				}

	//---Tougher Monsters setting
	//see "Tougher / Weaker Monsters effect" below

				Screen->DrawString(
					MODE_DRAWLAYER, 
					9, 
					ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_TOUGHMONSTERS) + 1, 
					FONT_Z1, 
					3, 
					0, 
					TF_NORMAL, MODE_TOUGHMONSTERS, 
					OP_OPAQUE);
				if (Link->Item[I_TOUGHMONSTERS])
				{
					Screen->DrawString(
						MODE_DRAWLAYER, 
						209, 
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_TOUGHMONSTERS) + 1, 
						FONT_Z1, 
						3, 
						0, 
						TF_NORMAL,
						MODE_ON, 
						OP_OPAQUE);
					Screen->FastTile(
						MODE_DRAWLAYER,
						236,
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_TOUGHMONSTERS),
						TOUGHER_TILE,
						0,
						128);
				}
				else Screen->DrawString(
					MODE_DRAWLAYER, 
					209, 
					ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_TOUGHMONSTERS) + 1, 
					FONT_Z1, 
					3, 
					0, 
					TF_NORMAL, 
					MODE_OFF, 
					OP_OPAQUE);		

				if (ModeMenu[SELECT_MODE] == SETTING_TOUGHMONSTERS)
				{
					Screen->DrawString(
						MODE_DRAWLAYER, 
						8, 
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_TOUGHMONSTERS), 
						FONT_Z1, 
						1, 
						-1, 
						TF_NORMAL, 
						MODE_TOUGHMONSTERS, 
						OP_OPAQUE);
					if (Link->Item[I_TOUGHMONSTERS])
					{
						Screen->DrawString(
							MODE_DRAWLAYER, 
							208, 
							ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_TOUGHMONSTERS), 
							FONT_Z1, 
							1, 
							-1, 
							TF_NORMAL, 
							MODE_ON, 
							OP_OPAQUE);	
					}
					else Screen->DrawString(
						MODE_DRAWLAYER, 
						208, 
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_TOUGHMONSTERS), 
						FONT_Z1, 
						1, 
						-1, 
						TF_NORMAL, 
						MODE_OFF, 
						OP_OPAQUE);

					if (Link->PressA)
					{
						int FlippingACoin = Rand(2);
						if (FlippingACoin == 1)
						{
							Game->PlaySound(SFX_MODEON);
							Link->PressRight = true;
						}
						else Game->PlaySound(SFX_MODEOFF);
					}

					if (Link->PressRight || Link->PressLeft)
					{
						if (Link->Item[I_TOUGHMONSTERS])
						{
							Link->Item[I_TOUGHMONSTERS] = false;
							Game->PlaySound(SFX_MODEOFF);
						}
						else
						{
							Link->Item[I_TOUGHMONSTERS] = true;
							Link->Item[I_WEAKMONSTERS] = false;
							Game->PlaySound(SFX_MODEON);
						}
					}		
				}

	//--- No Heart Drops setting
	//See "No Heart Drops effect" below

				 Screen->DrawString(
					MODE_DRAWLAYER, 
					9, 
					ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_NOHEART) + 1, 
					FONT_Z1, 
					3, 
					0, 
					TF_NORMAL, 
					MODE_NOHEARTS, 
					OP_OPAQUE);
				if (Link->Item[I_NOHEARTS])
				{
					Screen->DrawString(
						MODE_DRAWLAYER, 
						209, 
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_NOHEART) + 1, 
						FONT_Z1, 
						3, 
						0, 
						TF_NORMAL, 
						MODE_ON, 
						OP_OPAQUE);
					Screen->FastTile(
						MODE_DRAWLAYER,
						236,
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_NOHEART),
						NOHEART_TILE,
						0,
						128);	
				}
				else Screen->DrawString(
					MODE_DRAWLAYER, 
					209, 
					ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_NOHEART) + 1, 
					FONT_Z1, 
					3, 
					0, 
					TF_NORMAL, 
					MODE_OFF, 
					OP_OPAQUE);		

				if (ModeMenu[SELECT_MODE] == SETTING_NOHEART) 
				{
					Screen->DrawString(
						MODE_DRAWLAYER, 
						8, 
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_NOHEART), 
						FONT_Z1, 
						1, 
						-1, 
						TF_NORMAL, 
						MODE_NOHEARTS, 
						OP_OPAQUE);
					if (Link->Item[I_NOHEARTS])
					{
						Screen->DrawString(
							MODE_DRAWLAYER, 
							208, 
							ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_NOHEART), 
							FONT_Z1, 
							1, 
							-1, 
							TF_NORMAL, 
							MODE_ON, 
							OP_OPAQUE);
					}
					else Screen->DrawString(
						MODE_DRAWLAYER, 
						208, 
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_NOHEART), 
						FONT_Z1, 
						1, 
						-1, 
						TF_NORMAL, 
						MODE_OFF, 
						OP_OPAQUE);

					if (Link->PressA)
					{
						int FlippingACoin = Rand(2);
						if (FlippingACoin == 1)
						{
							Game->PlaySound(SFX_MODEON);
							Link->PressRight = true;
						}
						else Game->PlaySound(SFX_MODEOFF);
					}

					if (Link->PressRight || Link->PressLeft)
					{
						if (Link->Item[I_NOHEARTS])
						{
							Link->Item[I_NOHEARTS] = false;
							Game->PlaySound(SFX_MODEOFF);
						}
						else
						{
							Link->Item[I_NOHEARTS] = true;
							Game->PlaySound(SFX_MODEON);
						}
					}		
				}

	//--- Random Extra Monsters setting setting

				Screen->DrawString(
					MODE_DRAWLAYER, 
					9, 
					ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_EXTRA) + 1, 
					FONT_Z1, 
					3, 
					0, 
					TF_NORMAL, 
					MODE_EXTRA, 
					OP_OPAQUE);
				if (Link->Item[I_EXTRAENEMY])
				{
					Screen->DrawString(
						MODE_DRAWLAYER, 
						209, 
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_EXTRA) + 1, 
						FONT_Z1, 
						3, 
						0, 
						TF_NORMAL, 
						MODE_ON, 
						OP_OPAQUE);
					Screen->FastTile(
						MODE_DRAWLAYER,
						236,
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_EXTRA),
						EXTRAENEMY_TILE,
						0,
						128);
				}
				else Screen->DrawString(
					MODE_DRAWLAYER, 
					209, 
					ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_EXTRA) + 1, 
					FONT_Z1, 
					3, 
					0, 
					TF_NORMAL, 
					MODE_OFF, 
					OP_OPAQUE);		

				if (ModeMenu[SELECT_MODE] == SETTING_EXTRA)
				{
					Screen->DrawString(
						MODE_DRAWLAYER, 
						8, 
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_EXTRA), 
						FONT_Z1, 
						1, 
						-1, 
						TF_NORMAL, 
						MODE_EXTRA, 
						OP_OPAQUE);
					if (Link->Item[I_EXTRAENEMY])
					{
						Screen->DrawString(
							MODE_DRAWLAYER, 
							208, 
							ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_EXTRA), 
							FONT_Z1, 
							1, 
							-1, 
							TF_NORMAL, 
							MODE_ON, 
							OP_OPAQUE);
					}
					else Screen->DrawString(
						MODE_DRAWLAYER, 
						208, 
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_EXTRA), 
						FONT_Z1, 
						1, 
						-1, 
						TF_NORMAL, 
						MODE_OFF, 
						OP_OPAQUE);	

					if (Link->PressA)
					{
						int FlippingACoin = Rand(2);
						if (FlippingACoin == 1)
						{
							Game->PlaySound(SFX_MODEON);
							Link->PressRight = true;
						}
						else Game->PlaySound(SFX_MODEOFF);
					}

					if (Link->PressRight || Link->PressLeft)
					{
						if (Link->Item[I_EXTRAENEMY])
						{
							Link->Item[I_EXTRAENEMY] = false;
							Game->PlaySound(SFX_MODEOFF);
						}
						else
						{
							Link->Item[I_EXTRAENEMY] = true;
							Game->PlaySound(SFX_MODEON);
						}
					}	
				}

	//---Zapper setting
	//see "Item: Duck Zapper" below


				Screen->DrawString(
					MODE_DRAWLAYER, 
					9, 
					ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_ZAPPERDUCKS) + 1, 
					FONT_Z1, 
					12, 
					0, 
					TF_NORMAL, 
					MODE_ZAPPER, 
					OP_OPAQUE);

				if (Link->Item[I_ZAPPERTWO])
				{
				 	Screen->DrawInteger(
						MODE_DRAWLAYER,								//int layer, 
						209,									//int x, 
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_ZAPPERDUCKS) + 1,	//int y, 
						FONT_Z1,								//int font, 
						12,									//int color, 
						-1,									//int background_color, 
						-1,									//int width, 
						-1,									//int height, 
						2,									//int number, 
						0, 									//int number_decimal_places, 
						128);									 //int opacity
					Screen->FastTile(
						MODE_DRAWLAYER,
						236,
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_ZAPPERDUCKS),
						DUCK_TILE,
						1,
						128);
				}
				else if (Link->Item[I_ZAPPER])
				{
				 	Screen->DrawInteger(
						MODE_DRAWLAYER,								//int layer, 
						209,									//int x, 
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_ZAPPERDUCKS) + 1,	//int y, 
						FONT_Z1,								//int font, 
						12,									//int color, 
						-1,									//int background_color, 
						-1,									//int width, 
						-1,									//int height, 
						1,									//int number, 
						0, 									//int number_decimal_places, 
						128);									 //int opacity
					Screen->FastTile(
						MODE_DRAWLAYER,
						236,
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_ZAPPERDUCKS),
						DUCK_TILE,
						0,
						128);
				}
				else
				{
				 	Screen->DrawInteger(
						MODE_DRAWLAYER,								//int layer, 
						209,									//int x, 
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_ZAPPERDUCKS) + 1,	//int y, 
						FONT_Z1,								//int font, 
						12,									//int color, 
						-1,									//int background_color, 
						-1,									//int width, 
						-1,									//int height, 
						0,									//int number, 
						0, 									//int number_decimal_places, 
						128);									 //int opacity
				}

				if (ModeMenu[SELECT_MODE] == SETTING_ZAPPERDUCKS)
				{
					Screen->DrawString(
						MODE_DRAWLAYER, 
						8, 
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_ZAPPERDUCKS), 
						FONT_Z1, 
						1, 
						-1, 
						TF_NORMAL, 
						MODE_ZAPPER, 
						OP_OPAQUE);

					if (Link->Item[I_ZAPPERTWO])
					{
					 	Screen->DrawInteger(
							MODE_DRAWLAYER,							//int layer, 
							208,								//int x, 
							ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_ZAPPERDUCKS),	//int y, 
							FONT_Z1,							//int font, 
							1,								//int color, 
							-1,								//int background_color, 
							-1,								//int width, 
							-1,								//int height, 
							2,								//int number, 
							0, 								//int number_decimal_places, 
							128);								 //int opacity
					}
					else if (Link->Item[I_ZAPPER])
					{
					 	Screen->DrawInteger(
							MODE_DRAWLAYER,							//int layer, 
							208,								//int x, 
							ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_ZAPPERDUCKS),	//int y, 
							FONT_Z1,							//int font, 
							1,								//int color, 
							-1,								//int background_color, 
							-1,								//int width, 
							-1,								//int height, 
							1,								//int number, 
							0, 								//int number_decimal_places, 
							128);								//int opacity
					}
					else
					{
					 	Screen->DrawInteger(
							MODE_DRAWLAYER,							//int layer, 
							208,								//int x, 
							ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_ZAPPERDUCKS),	//int y, 
							FONT_Z1,							//int font, 
							1,								//int color, 
							-1,								//int background_color, 
							-1,								//int width, 
							-1,								//int height, 
							0,								//int number, 
							0, 								//int number_decimal_places, 
							128);								//int opacity
					}

					if (Link->PressA)
					{
						int FlippingACoin = Rand(1,3);
						if (FlippingACoin == 1)
						{
							Link->Item[I_ZAPPER] = false;
							Link->Item[I_ZAPPERTWO] = false;
							Game->PlaySound(SFX_MODEOFF);
						}
						else if (FlippingACoin == 2)
						{
							Link->Item[I_ZAPPER] = true;
							Link->Item[I_ZAPPERTWO] = false;
							Game->PlaySound(SFX_MODEON);
						}

						else if (FlippingACoin == 3)
						{
							Link->Item[I_ZAPPER] = true;
							Link->Item[I_ZAPPERTWO] = true;
							Game->PlaySound(SFX_MODEON);
						}
					}

					if (Link->PressRight)
					{
						if (Link->Item[I_ZAPPER])
						{
							Link->Item[I_ZAPPERTWO] = true;
							Game->PlaySound(SFX_MODEON);
						}
						else
						{
							Link->Item[I_ZAPPER] = true;
							Game->PlaySound(SFX_MODEON);
						}
					}	
					if (Link->PressLeft)
					{
						if (Link->Item[I_ZAPPERTWO])
						{
							Link->Item[I_ZAPPERTWO] = false;
							Game->PlaySound(SFX_MODEOFF);
						}
						else
						{
							Link->Item[I_ZAPPER] = false;
							Game->PlaySound(SFX_MODEOFF);
						}
					}
				}

	//---Summon Partner setting
	//see also "Item: Partner Costume" above, before While

				Screen->DrawString(
					MODE_DRAWLAYER, 
					9, 
					ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_PARTNER) + 1, 
					FONT_Z1, 
					12, 
					0, 
					TF_NORMAL,
					MODE_PARTNER, 
					OP_OPAQUE);

				if (Link->Item[I_PARTNER])
				{ 
					Screen->DrawInteger(
						MODE_DRAWLAYER,							//int layer, 
						209,								//int x, 
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_PARTNER) + 1,	//int y, 
						FONT_Z1,							//int font, 
						12,								//int color, 
						-1,								//int background_color, 
						-1,								//int width, 
						-1,								//int height, 
						Game->Counter[CR_PCOSTUME]-1,					//int number, 
						0, 								//int number_decimal_places, 
						128);								//int opacity
					Screen->FastTile(
						MODE_DRAWLAYER,
						236,
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_PARTNER),
						PARTNERCOSTUME_TILE,
						6,
						128);
				}
				else Screen->DrawString(
					MODE_DRAWLAYER, 
					209, 
					ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_PARTNER) + 1, 
					FONT_Z1, 
					12, 
					0, 
					TF_NORMAL, 
					MODE_OFF, 
					OP_OPAQUE);

				if (ModeMenu[SELECT_MODE] == SETTING_PARTNER)
				{
					Screen->DrawString(
						MODE_DRAWLAYER, 
						8, 
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_PARTNER), 
						FONT_Z1, 
						1, 
						-1, 
						TF_NORMAL, 
						MODE_PARTNER, 
						OP_OPAQUE);
					if (Link->Item[I_PARTNER]) 
					{
						Screen->DrawInteger(
							MODE_DRAWLAYER,							//int layer, 
							208,								//int x, 
							ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_PARTNER),	//int y, 
							FONT_Z1,							//int font, 
							1,								//int color, 
							-1,								//int background_color, 
							-1,								//int width, 
							-1,								//int height, 
							Game->Counter[CR_PCOSTUME]-1,					//int number, 
							0, 								//int number_decimal_places, 
							128);								//int opacity
					}
					else Screen->DrawString(
						MODE_DRAWLAYER, 
						208, 
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_PARTNER), 
						FONT_Z1, 
						1, 
						-1, 
						TF_NORMAL, 
						MODE_OFF, 
						OP_OPAQUE);
					if (Link->PressA)
					{
						int FlippingACoin = Rand(2);
						if (FlippingACoin == 1)
						{
							Game->PlaySound(SFX_MODEON);
							Link->PressRight = true;
						}
						else
						{
							Game->PlaySound(SFX_MODEOFF);
							Link->PressLeft = true;
						}
						Game->Counter[CR_PCOSTUME] = Rand(0,90);
						ModeMenu[COSTUME_SHOWNAME] = 256;
					}

					if (Link->PressRight)
					{
						Game->PlaySound(SFX_MODEON);
						if (Game->Counter[CR_PCOSTUME] < COSTUME_INVISIBLE) ++Game->Counter[CR_PCOSTUME]; 
						else Game->Counter[CR_PCOSTUME] = 0;
					}
					else if (Link->PressLeft)
					{
						Game->PlaySound(SFX_MODEOFF);
						if (Game->Counter[CR_PCOSTUME] > 0) --Game->Counter[CR_PCOSTUME];
						else Game->Counter[CR_PCOSTUME] = COSTUME_INVISIBLE;
					}

					if (Link->PressRight || Link->PressLeft)
					{
						if (Game->Counter[CR_PCOSTUME] == 0 && Link->Item[I_PARTNER])
						{
							Link->Item[I_PARTNER] = false;
							Partner[FOLLOW_STATE] = 0;
						}
						else if (Game->Counter[CR_PCOSTUME] > 0 && !Link->Item[I_PARTNER])
						{ 
							Link->Item[I_PARTNER] = true;
							if (Link->Dir == DIR_UP && CanWalk(Link->X,Link->Y+8,DIR_DOWN,1,false))
							{
								Partner[FOLLOW_X] = Link->X;
								Partner[FOLLOW_Y] = Link->Y+16;
							}
							if (Link->Dir == DIR_DOWN && CanWalk(Link->X,Link->Y-8,DIR_UP,1,false))
							{
								Partner[FOLLOW_X] = Link->X;
								Partner[FOLLOW_Y] = Link->Y-16;
							}
							if (Link->Dir == DIR_LEFT && CanWalk(Link->X+8,Link->Y,DIR_RIGHT,1,false))
							{
								Partner[FOLLOW_X] = Link->X + 16;
								Partner[FOLLOW_Y] = Link->Y;
							}
							if (Link->Dir == DIR_RIGHT && CanWalk(Link->X-8,Link->Y,DIR_LEFT,1,false))
							{
								Partner[FOLLOW_X] = Link->X - 16;
								Partner[FOLLOW_Y] = Link->Y;
							}
							Partner[FOLLOW_STATE] = 0;
						}
						CopyTileRow(COSTUMECOPY_TILE + ((Game->Counter[CR_PCOSTUME]-1) * 260),PARTNER_TILES,200);
						ModeMenu[COSTUME_SHOWNAME] = 256;
					}
					if (ModeMenu[COSTUME_SHOWNAME] > 0)
					{
						if (Link->Item[I_PARTNER])
						{
							//Screen->SetRenderTarget(RT_SCREEN);
							Screen->DrawTile(
								6,
								0,			//start X
								152,			//start y
								PARTNER_TILES,		//tile ID
								16,			//tile width
								1,			//tile width
								7,			//tile cset
								-1,-1,-1,-1,0,FLIP_NONE,1,128);
							Screen->FastCombo(MODE_DRAWLAYER,240,152,COMBO_PPOSE,6,128);
							//Screen->SetRenderTarget(RT_BITMAP2);
						}
					}	
				}

	//---Costume setting
	//see also "Item: Link Costume" above, before While

				Screen->DrawString(
					MODE_DRAWLAYER, 
					9, 
					ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_COSTUME) + 1, 
					FONT_Z1, 
					6, 
					0, 
					TF_NORMAL, 
					MODE_LINK, 
					OP_OPAQUE);

				if (Link->Item[I_LINKCOSTUME]) Screen->FastTile(
					MODE_DRAWLAYER,
					236,
					ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_COSTUME),
					LINKCOSTUME_TILE,
					6,
					128);

				 Screen->DrawInteger(
					MODE_DRAWLAYER,							//int layer, 
					209,								//int x, 
					ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_COSTUME) + 1,	//int y, 
					FONT_Z1,							//int font, 
					6,								//int color, 
					-1,								//int background_color, 
					-1,								//int width, 
					-1,								//int height, 
					Game->Counter[CR_COSTUME],					//int number, 
					0, 								//int number_decimal_places, 
					128);					 			//int opacity

				if (ModeMenu[SELECT_MODE] == SETTING_COSTUME)
				{
					Screen->DrawString(
						MODE_DRAWLAYER, 
						8, 
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_COSTUME), 
						FONT_Z1, 
						1, 
						-1, 
						TF_NORMAL, 
						MODE_LINK, 
						OP_OPAQUE);
					Screen->DrawInteger(
						MODE_DRAWLAYER,							//int layer, 
						208,								//int x, 
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_COSTUME),	//int y, 
						FONT_Z1,							//int font, 
						1,								//int color, 
						-1,								//int background_color, 
						-1,								//int width, 
						-1,								//int height, 
						Game->Counter[CR_COSTUME],					//int number, 
						0, 								//int number_decimal_places, 
						128);								//int opacity

					if (Link->PressA)
					{
						int FlippingACoin = Rand(2);
						if (FlippingACoin == 1)
						{
							Game->PlaySound(SFX_MODEON);
							Link->PressRight = true;
						}
						else
						{
							Game->PlaySound(SFX_MODEOFF);
							Link->PressLeft = true;
						}
						Game->Counter[CR_COSTUME] = Rand(0,COSTUME_INVISIBLE);
						ModeMenu[COSTUME_SHOWNAME] = 256;
					}

					if (Link->PressRight)
					{
						Game->PlaySound(SFX_MODEON);
						if (Game->Counter[CR_COSTUME] < COSTUME_INVISIBLE) ++Game->Counter[CR_COSTUME]; 
						else Game->Counter[CR_COSTUME] = 0;
						if (Game->Counter[CR_COSTUME] == COSTUME_GANNON) Game->PlaySound(SFX_GANON);
					}
					else if (Link->PressLeft)
					{
						Game->PlaySound(SFX_MODEOFF);
						if (Game->Counter[CR_COSTUME] > 0) --Game->Counter[CR_COSTUME];
						else Game->Counter[CR_COSTUME] = COSTUME_INVISIBLE;
						if (Game->Counter[CR_COSTUME] == COSTUME_GANNON) Game->PlaySound(SFX_GANON);
					}

					if (Link->PressRight || Link->PressLeft)
					{
						if (Game->Counter[CR_COSTUME] == 0 && Link->Item[I_LINKCOSTUME]) Link->Item[I_LINKCOSTUME] = false;
						else if (Game->Counter[CR_COSTUME] > 0 && !Link->Item[I_LINKCOSTUME]) Link->Item[I_LINKCOSTUME] = true;						
						CopyTileRow(COSTUMECOPY_TILE + (Game->Counter[CR_COSTUME] * 260),PLAYER_TILES,200);
						CopyTileRow(COSTUMEVICTORY_TILES + (Game->Counter[CR_COSTUME] * 260),PLAYERVICTORY_TILES,9);
						ModeMenu[COSTUME_SHOWNAME] = 256;
						SetHurtNoise();
					}
					if (ModeMenu[COSTUME_SHOWNAME] > 0)
					{
						//Screen->SetRenderTarget(RT_SCREEN);
						Screen->DrawTile(
							6,
							0,			//start X
							152,			//start y
							PLAYER_TILES,		//tile ID
							16,			//tile width
							1,			//tile width
							8,			//tile cset
							-1,-1,-1,-1,0,FLIP_NONE,1,128);
						Screen->FastCombo(MODE_DRAWLAYER,240,152,COMBO_POSE,6,128);
						//Screen->SetRenderTarget(RT_BITMAP2);
					}		
				}
				if (ModeMenu[COSTUME_SHOWNAME] > 0) --ModeMenu[COSTUME_SHOWNAME];

	//---World Redecorate (Alternate Colors / "Grass Graphics") setting
	//see also "Item: Grass" above, before While

				Screen->DrawString(
					MODE_DRAWLAYER, 
					9, 
					ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_WORLD) + 1, 
					FONT_Z1, 
					6, 
					0, 
					TF_NORMAL, 
					MODE_WORLDGFX, 
					OP_OPAQUE);
				if (Link->Item[I_WORLDGFX])
				{
					Screen->DrawString(
						MODE_DRAWLAYER, 
						209, 
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_WORLD) + 1, 
						FONT_Z1, 
						6, 
						0, 
						TF_NORMAL, 
						MODE_ON, 
						OP_OPAQUE);
					Screen->FastTile(
						MODE_DRAWLAYER,
						236,
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_WORLD),
						GRASSMODE_TILE,
						0,
						128);
				}
				else Screen->DrawString(
					MODE_DRAWLAYER, 
					209, 
					ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_WORLD) + 1, 
					FONT_Z1, 
					6, 
					0, 
					TF_NORMAL,
					MODE_OFF, 
					OP_OPAQUE);		

				if (ModeMenu[SELECT_MODE] == SETTING_WORLD)
				{
					Screen->DrawString(
						MODE_DRAWLAYER, 
						8, 
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_WORLD), 
						FONT_Z1, 
						1, 
						-1, 
						TF_NORMAL, 
						MODE_WORLDGFX, 
						OP_OPAQUE);
					if (Link->Item[I_WORLDGFX])
					{
						Screen->DrawString(
							MODE_DRAWLAYER, 
							208, 
							ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_WORLD), 
							FONT_Z1, 
							1, 
							-1, 
							TF_NORMAL, 
							MODE_ON, 
							OP_OPAQUE);
					}
					else Screen->DrawString(
						MODE_DRAWLAYER, 
						208, 
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_WORLD) + 1, 
						FONT_Z1, 
						1, 
						-1, 
						TF_NORMAL, 
						MODE_OFF, 
						OP_OPAQUE);	

					if (Link->PressA)
					{
						int FlippingACoin = Rand(2);
						if (FlippingACoin == 1)
						{
							Game->PlaySound(SFX_MODEON);
							Link->PressRight = true;
						}
						else Game->PlaySound(SFX_MODEOFF);
					}

					if (Link->PressRight || Link->PressLeft)
					{
						if (Link->Item[I_WORLDGFX])
						{
							Link->Item[I_WORLDGFX] = false;
							Game->PlaySound(SFX_MODEOFF);
							CopyTileRow(NOGRASSCOPY_TILE,OVERWORLD_TILE,260);
						}
						else
						{
							Link->Item[I_WORLDGFX] = true;
							Game->PlaySound(SFX_MODEON);
							CopyTileRow(GRASSCOPY_TILE,OVERWORLD_TILE,260);
						}
					}	
				}

	//---Weather setting (Environment setting)
	//See also: "Weather", below

				Screen->DrawString(
					MODE_DRAWLAYER, 
					9, 
					ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_ENVIRONMENT) + 1, 
					FONT_Z1, 
					6, 
					0, 
					TF_NORMAL, 
					MODE_WEATHER, 
					OP_OPAQUE);
				Screen->DrawInteger(
					MODE_DRAWLAYER,								//int layer, 
					209,									//int x, 
					ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_ENVIRONMENT) + 1,	//int y, 
					FONT_Z1,								//int font, 
					6,									//int color, 
					-1,									//int background_color, 
					-1,									//int width, 
					-1,									//int height, 
					Game->Counter[CR_WEATHER],						//int number, 
					0, 									//int number_decimal_places, 
					128);									//int opacity
					
					if (Game->Counter[CR_WEATHER] > 0)
					{
						Screen->FastTile(
							MODE_DRAWLAYER,
							236,
							ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_ENVIRONMENT),
							WEATHER_TILE,
							0,
							128);
					}

				if (ModeMenu[SELECT_MODE] == SETTING_ENVIRONMENT)
				{
					Screen->DrawString(
						MODE_DRAWLAYER, 
						8, 
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_ENVIRONMENT), 
						FONT_Z1, 
						1, 
						-1, 
						TF_NORMAL, 
						MODE_WEATHER,
						OP_OPAQUE);
					Screen->DrawInteger(
						MODE_DRAWLAYER,							//int layer, 
						208,								//int x, 
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_ENVIRONMENT),	//int y, 
						FONT_Z1,							//int font, 
						1,								//int color, 
						-1,								//int background_color, 
						-1,								//int width, 
						-1,								//int height, 
						Game->Counter[CR_WEATHER],					//int number, 
						0, 								//int number_decimal_places, 
						128);								//int opacity

					if (Link->PressA)
					{
						Game->Counter[CR_WEATHER] = Rand(0,ENV_TRUENAUSEA);
						Game->PlaySound(Choose(SFX_MODEON,SFX_MODEOFF));
					}

					if (Link->PressRight)
					{
						Game->PlaySound(SFX_MODEON);
						if (Game->Counter[CR_WEATHER] < ENV_TRUENAUSEA) ++Game->Counter[CR_WEATHER];
						else Game->Counter[CR_WEATHER] = 0;
					}
					else if (Link->PressLeft)
					{
						Game->PlaySound(SFX_MODEOFF);
						if (Game->Counter[CR_WEATHER] > 0) --Game->Counter[CR_WEATHER];
						else Game->Counter[CR_WEATHER] = ENV_TRUENAUSEA;
					}
					if (Link->Item[I_WEATHER] && Game->Counter[CR_WEATHER] <= 0) Link->Item[I_WEATHER] = false;
					if (!Link->Item[I_WEATHER] && Game->Counter[CR_WEATHER] > 0) Link->Item[I_WEATHER] = true;
					//if (Game->Counter[CR_WEATHER] > 0 && Game->Counter[CR_WEATHER] <= ENV_BLOCKY || Game->Counter[CR_WEATHER] >= ENV_NEWWAVY1)
					//{
						//Screen->Rectangle(
						//	MODE_DRAWLAYER,	//layer
						//	0,		//start X
						//	160,		//start y
						//	256,		//end x
						//	176,		//end y
						//	15,1,0,0,0,true,128);
						//Screen->DrawString(MODE_DRAWLAYER, 8, 160, FONT_Z1, 1, -1, TF_NORMAL, ENVIRONMENT_WARNING, OP_OPAQUE);
					//}
					else if (Game->Counter[CR_WEATHER] == ENV_DYNAMIC)
					{
						Screen->Rectangle(
							MODE_DRAWLAYER,	//layer
							0,		//start X
							160,		//start y
							256,		//end x
							176,		//end y
							15,1,0,0,0,true,128);
						Screen->DrawString(MODE_DRAWLAYER, 8, 160, FONT_Z1, Choose(107,108), -1, TF_NORMAL, ENVIRONMENT_DYNAMICMESSAGE, OP_OPAQUE);
					} 
				}
				
		//---Z3 Scrolling setting

				Screen->DrawString(
					MODE_DRAWLAYER, 
					9, 
					ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_PICTOBOX) + 1, 
					FONT_Z1, 
					6, 
					0, 
					TF_NORMAL, 
					MODE_PICTOBOX, 
					OP_OPAQUE);
				if (Link->Item[I_RECURSEDPICTOBOX])
				{
					Screen->DrawString(
						MODE_DRAWLAYER, 
						201, 
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_PICTOBOX) + 1, 
						FONT_Z1, 
						6, 
						0, 
						TF_NORMAL, 
						MODE_FAST, 
						OP_OPAQUE);
					Screen->FastTile(
						MODE_DRAWLAYER,
						236,
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_PICTOBOX),
						REPICTOBOX_TILE,
						8,
						128);
				}
				else if (Link->Item[I_CURSEDPICTOBOX])
				{
					Screen->DrawString(
						MODE_DRAWLAYER, 
						201, 
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_PICTOBOX) + 1, 
						FONT_Z1, 
						6, 
						0, 
						TF_NORMAL, 
						MODE_SLOW, 
						OP_OPAQUE);
					Screen->FastTile(
						MODE_DRAWLAYER,
						236,
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_PICTOBOX),
						PICTOBOX_TILE,
						8,
						128);
				}
				else Screen->DrawString(
					MODE_DRAWLAYER, 
					209, 
					ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_PICTOBOX) + 1, 
					FONT_Z1, 
					6, 
					0, 
					TF_NORMAL, 
					MODE_OFF, 
					OP_OPAQUE);

				if (ModeMenu[SELECT_MODE] == SETTING_PICTOBOX) 
				{
					Screen->DrawString(
						MODE_DRAWLAYER, 
						9, 
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_PICTOBOX),
						FONT_Z1, 
						1, 
						-1, 
						TF_NORMAL, 
						MODE_PICTOBOX, 
						OP_OPAQUE);
					if (Link->Item[I_RECURSEDPICTOBOX])
					{
						Screen->DrawString(
							MODE_DRAWLAYER, 
							200, 
							ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_PICTOBOX), 
							FONT_Z1, 
							1, 
							-1, 
							TF_NORMAL, 
							MODE_FAST, 
							OP_OPAQUE);
						Screen->Rectangle(
							MODE_DRAWLAYER,	//layer
							0,		//start X
							160,		//start y
							256,		//end x
							176,		//end y
							15,1,0,0,0,true,128);
						Screen->DrawString(MODE_DRAWLAYER, 8, 160, FONT_Z1, 1, -1, TF_NORMAL, ENVIRONMENT_FLICKER, OP_OPAQUE);
					}
					else if (Link->Item[I_CURSEDPICTOBOX])
					{
						Screen->DrawString(
							MODE_DRAWLAYER, 
							200, 
							ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_PICTOBOX), 
							FONT_Z1, 
							1, 
							-1, 
							TF_NORMAL, 
							MODE_SLOW, 
							OP_OPAQUE);	
					}	
					else Screen->DrawString(
						MODE_DRAWLAYER, 
						208, 
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_PICTOBOX),
						FONT_Z1, 
						1, 
						-1, 
						TF_NORMAL, 
						MODE_OFF, 
						OP_OPAQUE);	

					if (Link->PressA)
					{
						int FlippingACoin = Rand(3);
						if (FlippingACoin == 1)
						{
							Link->PressRight = true;
						}
						else if (FlippingACoin == 2)
						{
							Link->PressLeft = true;
						}
					}

					if (Link->PressRight)
					{
						if (Link->Item[I_CURSEDPICTOBOX] && Link->Item[I_RECURSEDPICTOBOX])
						{
							Link->Item[I_CURSEDPICTOBOX] = false;
							Link->Item[I_RECURSEDPICTOBOX] = false;
							Game->PlaySound(SFX_MODEOFF);
						}
						else if (Link->Item[I_CURSEDPICTOBOX] && !Link->Item[I_RECURSEDPICTOBOX])
						{
							Link->Item[I_RECURSEDPICTOBOX] = true;
							Game->PlaySound(SFX_MODEON);
						}
						else if (!Link->Item[I_CURSEDPICTOBOX])
						{
							Link->Item[I_CURSEDPICTOBOX] = true;
							Game->PlaySound(SFX_MODEON);
						}
					}
					else if (Link->PressLeft)
					{
						if (Link->Item[I_RECURSEDPICTOBOX])
						{
							Link->Item[I_RECURSEDPICTOBOX] = false;
							Game->PlaySound(SFX_MODEOFF);
						}
						else if (Link->Item[I_CURSEDPICTOBOX])
						{
							Link->Item[I_CURSEDPICTOBOX] = false;
							Game->PlaySound(SFX_MODEOFF);
						}
						else
						{
							Link->Item[I_CURSEDPICTOBOX] = true;
							Link->Item[I_RECURSEDPICTOBOX] = true;
							Game->PlaySound(SFX_MODEON);
						}
					}
				}

	//---Alternate Item Graphics setting
	//see also "Item: ItemGFX" above, before While

				Screen->DrawString(
					MODE_DRAWLAYER,
					9, 
					ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_ITEMGFX) + 1, 
					FONT_Z1, 
					6, 
					0, 
					TF_NORMAL, 
					MODE_ITEMSGFX, 
					OP_OPAQUE);
				if (Link->Item[I_ITEMSGFX])
				{
					Screen->DrawString(
						MODE_DRAWLAYER, 
						209, 
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_ITEMGFX) + 1, 
						FONT_Z1, 
						6, 
						0, 
						TF_NORMAL, 
						MODE_ON, 
						OP_OPAQUE);
					Screen->FastTile(
						MODE_DRAWLAYER,
						236,
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_ITEMGFX),
						ITEMGFX_TILE,
						7,
						128);
				}
				else Screen->DrawString(
					MODE_DRAWLAYER, 
					209, 
					ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_ITEMGFX) + 1, 
					FONT_Z1, 
					6, 
					0, 
					TF_NORMAL, 
					MODE_OFF, 
					OP_OPAQUE);		

				if (ModeMenu[SELECT_MODE] == SETTING_ITEMGFX)
				{
					Screen->DrawString(
						MODE_DRAWLAYER, 
						8, 
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_ITEMGFX), 
						FONT_Z1, 
						1, 
						-1, 
						TF_NORMAL, 
						MODE_ITEMSGFX, 
						OP_OPAQUE);
					if (Link->Item[I_ITEMSGFX])
					{
						Screen->DrawString(
							MODE_DRAWLAYER, 
							208, 
							ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_ITEMGFX), 
							FONT_Z1, 
							1, 
							-1, 
							TF_NORMAL, 
							MODE_ON, 
							OP_OPAQUE);
					}
					else Screen->DrawString(
						MODE_DRAWLAYER, 
						208, 
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_ITEMGFX), 
						FONT_Z1, 
						1, 
						-1, 
						TF_NORMAL, 
						MODE_OFF, 
						OP_OPAQUE);	

					if (Link->PressA)
					{
						int FlippingACoin = Rand(2);
						if (FlippingACoin == 1)
						{
							Game->PlaySound(SFX_MODEON);
							Link->PressRight = true;
						}
						else Game->PlaySound(SFX_MODEOFF);
					}

					if (Link->PressRight || Link->PressLeft)
					{
						if (Link->Item[I_ITEMSGFX])
						{
							Link->Item[I_ITEMSGFX] = false;
							Game->PlaySound(SFX_MODEOFF);
							CopyTileRow(NOITEMSCOPY_TILE,ITEMS_TILE,260);
						}
						else
						{
							Link->Item[I_ITEMSGFX] = true;
							Game->PlaySound(SFX_MODEON);
							CopyTileRow(ITEMSCOPY_TILE,ITEMS_TILE,260);
						}
					}	
				}

	//---Subscreen Border setting
	//see also "Subscreen border graphics" above, before While

				Screen->DrawString(
					MODE_DRAWLAYER, 
					9, 
					ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_PANEGFX) + 1, 
					FONT_Z1, 
					6, 
					0, 
					TF_NORMAL, 
					MODE_MENUPANE, 
					OP_OPAQUE);
				Screen->DrawInteger(
					MODE_DRAWLAYER,							//int layer, 
					209,								//int x, 
					ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_PANEGFX) + 1,	//int y, 
					FONT_Z1,							//int font, 
					6,								//int color, 
					0,								//int background_color, 
					-1,								//int width, 
					-1,								//int height, 
					Game->Counter[CR_PANECOLOR],					//int number, 
					0, 								//int number_decimal_places, 
					128);								//int opacity

				if (ModeMenu[SELECT_MODE] == SETTING_PANEGFX)
				{
					Screen->DrawString(
						MODE_DRAWLAYER, 
						8, 
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_PANEGFX), 
						FONT_Z1, 
						1, 
						-1, 
						TF_NORMAL, 
						MODE_MENUPANE, 
						OP_OPAQUE);
					Screen->DrawInteger(
						MODE_DRAWLAYER,							//int layer, 
						208,								//int x, 
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_PANEGFX) + 1,	//int y, 
						FONT_Z1,							//int font, 
						1,								//int color, 
						-1,								//int background_color, 
						-1,								//int width, 
						-1,								//int height, 
						Game->Counter[CR_PANECOLOR],					//int number, 
						0, 								//int number_decimal_places, 
						128);					 			//int opacity
					Screen->Rectangle(
						MODE_DRAWLAYER,							//layer
						224,								//start X
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_PANEGFX),	//start y
						256,								//end x
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_PANEGFX) + 32,	//end y
						15,1,0,0,0,true,128);
					Screen->DrawTile(
						MODE_DRAWLAYER,
						224,								//start X
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_PANEGFX),	//start y
						TILE_MENUPANE,							//tile ID
						2,								//tile width
						2,								//tile height
						0,								//tile cset
						-1,-1,-1,-1,0,FLIP_NONE,1,OP_OPAQUE);

					if (Link->PressA)
					{
						Game->Counter[CR_PANECOLOR] = Rand(0,16);
						Game->PlaySound(Choose(SFX_MODEON,SFX_MODEOFF));
						if (Game->Counter[CR_PANECOLOR] < 10)
						{
							CopyTileRow(TILE_MENUCOPY+(Game->Counter[CR_PANECOLOR]*2),TILE_MENUPANE,2);
							CopyTileRow(TILE_MENUCOPY+20+(Game->Counter[CR_PANECOLOR]*2),TILE_MENUPANE+20,2);
						}
						else
						{
							CopyTileRow(TILE_MENUCOPY+20+(Game->Counter[CR_PANECOLOR]*2),TILE_MENUPANE,2);
							CopyTileRow(TILE_MENUCOPY+40+(Game->Counter[CR_PANECOLOR]*2),TILE_MENUPANE+20,2);
						}
					}
					if (Link->PressLeft)
					{
						if (Game->Counter[CR_PANECOLOR] > 0) --Game->Counter[CR_PANECOLOR];
						else Game->Counter[CR_PANECOLOR] = 16;
						Game->PlaySound(SFX_MODEOFF);
						if (Game->Counter[CR_PANECOLOR] < 10)
						{
							CopyTileRow(TILE_MENUCOPY+(Game->Counter[CR_PANECOLOR]*2),TILE_MENUPANE,2);
							CopyTileRow(TILE_MENUCOPY+20+(Game->Counter[CR_PANECOLOR]*2),TILE_MENUPANE+20,2);
						}
						else
						{
							CopyTileRow(TILE_MENUCOPY+20+(Game->Counter[CR_PANECOLOR]*2),TILE_MENUPANE,2);
							CopyTileRow(TILE_MENUCOPY+40+(Game->Counter[CR_PANECOLOR]*2),TILE_MENUPANE+20,2);
						}
					}
					if (Link->PressRight)
					{
						if (Game->Counter[CR_PANECOLOR] < 16) ++Game->Counter[CR_PANECOLOR];
						else Game->Counter[CR_PANECOLOR] = 0;
						Game->PlaySound(SFX_MODEON);
						if (Game->Counter[CR_PANECOLOR] < 10)
						{
							CopyTileRow(TILE_MENUCOPY+(Game->Counter[CR_PANECOLOR]*2),TILE_MENUPANE,2);
							CopyTileRow(TILE_MENUCOPY+20+(Game->Counter[CR_PANECOLOR]*2),TILE_MENUPANE+20,2);
						}
						else
						{
							CopyTileRow(TILE_MENUCOPY+20+(Game->Counter[CR_PANECOLOR]*2),TILE_MENUPANE,2);
							CopyTileRow(TILE_MENUCOPY+40+(Game->Counter[CR_PANECOLOR]*2),TILE_MENUPANE+20,2);
						}
					}						
				}

	//--- Save setting

				if (HasSaved)
				{					
					if (ModeMenu[SELECT_MODE] == SETTING_SAVE)
					{
						Screen->DrawString(
							MODE_DRAWLAYER, 
							9, 
							ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_SAVE) + 1, 
							FONT_Z1, 
							2, 
							0, 
							TF_NORMAL, 
							MODE_SAVE3, 
							OP_OPAQUE);
						Screen->DrawString(
							MODE_DRAWLAYER, 
							8, 
							ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_SAVE), 
							FONT_Z1, 
							1, 
							-1, 
							TF_NORMAL, 
							MODE_SAVE3, 
							OP_OPAQUE);
					}
					else HasSaved = false;
				}
				else
				{
					if (ModeMenu[SELECT_MODE] == SETTING_SAVE && Game->GetCurScreen() < 128)
					{
						if (ModeMenu[MODEMENU_SAVING] > 0)
						{
							Screen->DrawString(
								MODE_DRAWLAYER, 
								9, 
								ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_SAVE) + 1, 
								FONT_Z1, 
								2, 
								0, 
								TF_NORMAL, 
								MODE_SAVE4, 
								OP_OPAQUE);
							Screen->DrawString(
								MODE_DRAWLAYER, 
								8, 
								ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_SAVE), 
								FONT_Z1, 
								1, 
								-1, 
								TF_NORMAL, 
								MODE_SAVE4, 
								OP_OPAQUE);
							if (ModeMenu[MODEMENU_SAVING] < 2) ++ModeMenu[MODEMENU_SAVING];
							else
							{
								RememberStuff[REMEMBER_SAVEDX] = Link->X;
								RememberStuff[REMEMBER_SAVEDY] = Link->Y;
								RememberStuff[REMEMBER_SAVEDMAP] = Game->GetCurDMap();
								RememberStuff[REMEMBER_SAVEDSCREEN] = Game->GetCurDMapScreen();
								Game->Save();
								HasSaved = true;
								Game->PlaySound(SFX_SCALE);
								ModeMenu[MODEMENU_SAVING] = 0;
							}
						}
						else
						{
							if (Link->PressA) ModeMenu[MODEMENU_SAVING] = 1;
							else
							{
								Screen->DrawString(
									MODE_DRAWLAYER, 
									9, 
									ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_SAVE) + 1, 
									FONT_Z1, 
									2, 
									0, 
									TF_NORMAL, 
									MODE_SAVE2, 
									OP_OPAQUE);
								Screen->DrawString(
									MODE_DRAWLAYER, 
									8, 
									ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_SAVE), 
									FONT_Z1, 
									1, 
									-1, 
									TF_NORMAL, 
									MODE_SAVE2, 
									OP_OPAQUE);
							}
						}
					}
					else Screen->DrawString(
						MODE_DRAWLAYER, 
						9, 
						ModeMenu[MODEMENU_Y] + (MODEMENU_SPACE * SETTING_SAVE) + 1, 
						FONT_Z1, 
						2, 
						0, 
						TF_NORMAL, 
						MODE_SAVE1, 
						OP_OPAQUE);
				}
	// --- end of modes

	// --- Final boss warning message:
				if (Game->GetCurDMap() == DMAP_FINALBATTLE)
				{
					Screen->Rectangle(7, 0, 144, 256, 176 ,0,1,0,0,0,true,128);
					if (EverySixty < 10 || EverySixty > 30 && EverySixty < 40)
					Screen->DrawString(
						7,
						128,
						152, 
						FONT_Z1, 
						17, 
						0, 
						TF_CENTERED, 
						HeUsesIt, 
						OP_OPAQUE);
					else Screen->DrawString(
						7,
						128,
						152, 
						FONT_Z1, 
						1, 
						0, 
						TF_CENTERED, 
						HeUsesIt, 
						OP_OPAQUE);
				}

				NoAction();
			}


	// --- Link costume grunts
		if (Link->Action == LA_GOTHURTLAND || Link->Action == LA_DROWNING)
		{
			if (!GettingHurt)
			{
				if (Game->Counter[CR_WEATHER] == ENV_BLOCKY)
				{
					Game->PlaySound(SFX_DWHURT);
					GettingHurt = true;
				}
				else if (Link->Item[I_LINKCOSTUME])
				{
					Game->PlaySound(RememberStuff[REMEMBER_HURTNOISE]);
					GettingHurt = true;
				}
				else
				{
					// Zelda (no costume)
					Game->PlaySound(SFX_ZELDAHURT);
					GettingHurt = true;
				}
			}
		}
		else if (GettingHurt) GettingHurt = false;


	// --- Extra enemies mode effect
		if (ModeMenu[MODEMENU_ON] == 0)
		{
			if (Link->Item[I_EXTRAENEMY] && NumNPCsOf(377) <= 0)
			{
				Screen->DrawInteger(
				7,								//int layer, 
				104,								//int x, 
				-56,								//int y, 
				FONT_Z1,							//int font, 
				1,								//int color, 
				-1,								//int background_color, 
				-1,								//int width, 
				-1,								//int height, 
				ModeMenu[EXTRA_ENEMIES]/10,					//int number, 
				0, 								//int number_decimal_places, 
				128);								//int opacity
		
				if (ModeMenu[EXTRA_ENEMIES] == 0)
				{
					ModeMenu[EXTRA_ENEMIES] = Rand(128,1024);

					npc BestBuddy = CreateNPCAt(
						Choose
						(
							//Choose(
							//	NPC_ABEI, 
							//	NPC_AMA,
							//	NPC_MERCHANT,
							//	NPC_ENEMYFIRE,
							//	Choose(
							//		NPC_GEL,
							//		NPC_KEESE1,
							//		NPC_GEL,
							//		NPC_KEESE1,
							//		NPC_GEL,
							//		NPC_GANON)),
							Choose
							(
								Choose
								(
									NPC_DARKNUT1,
									NPC_DARKNUT1,
									NPC_DARKNUT2, 
									NPC_TUNKRAD1
								),
								Choose
								(
									NPC_WIZZROBE1,
									NPC_WIZZROBE1,
									NPC_WIZZROBE1,
									NPC_WIZZROBE2
								),
								Choose
								(
									NPC_TUNKRAD1,
									NPC_GORIYA1,
									NPC_GORIYA1
								),
								Choose
								(
									NPC_ZOL,
									NPC_VIRE
								),
								Choose
								(
									NPC_DIGKID1,
									NPC_AQUAMENTUSR,
									NPC_AQUAMENTUSL,
									NPC_MANHANDLA,
									NPC_LANMOLA1,
									Choose
									(
										NPC_GLEEOK1,
										NPC_GLEEOK2,
										NPC_ZORAWALK1,
										NPC_ZORAWALK1
									)
								)
							),
							Choose
							(
								Choose
								(
									NPC_STALFOS1, 
									NPC_STALFOS1, 
									NPC_GIBDO
								),
								NPC_ROPE1, 
								NPC_ENEMYFIRE, 
								NPC_MOLDORM, 
								NPC_TEKTITE1, 
								NPC_LYNEL1
							),
							Choose
							(
								NPC_LEEVER1,
								NPC_LIKELIKE,
								NPC_OCTOROCK1S,
								NPC_ZORAWALK2,
								NPC_GELTRIB, 
								Choose
								(
									NPC_KEESE1,
									NPC_KEESE2,
									NPC_KEESETRIB
								)
							),
							Choose
							(
								NPC_MOBY1,
								NPC_DEELER1,
								NPC_GIBO1,
								NPC_SLUGGULA1,
								NPC_GUMA1,
								Choose
								(
									NPC_OCTOROCK2S,
									NPC_WIZZ_SOMARIA,
									NPC_WIZZ_SOMARIA,
									NPC_WIZZ_SOMARIA,
									NPC_URCHIN1,
									NPC_GEL
								)
							)
						),
					32+(Rand(0,11)*16),
					32+(Rand(0,6)*16));

					if (BestBuddy->isValid())
					{
						{
							Game->PlaySound(SFX_ENEMYAPPEAR);
							if (BestBuddy->Type == NPCT_GLEEOK)
							{
								BestBuddy->Weapon = 0;
								if (BestBuddy->Y > 80) BestBuddy->Y = 80;
								if (BestBuddy->X > 228) BestBuddy->X = 200;
							}
							BestBuddy->Stun = 255;
							if (LinkCollision(BestBuddy))
							{
								if (Link->X > 48) BestBuddy->X = 32;
								else BestBuddy->X = 192; 
							}
							if (!IsSideview() && BestBuddy->Type == NPCT_WALK) BestBuddy->Z = 255;
						}
					}
				}
				else if (EverySix == 1) --ModeMenu[EXTRA_ENEMIES];
			}
		}
		if (ModeMenu[EXTRA_ENEMIES] > 0)
		{
			if (!Link->Item[I_EXTRAENEMY]) ModeMenu[EXTRA_ENEMIES] = 0;
		}
	

	// --- Enemy Name Display (Hero Charm / See Enemy HP Mode)
		if (RememberStuff[REMEMBER_ENEMYNAMEWAIT] > 0)
		{
			if (ModeMenu[MODEMENU_ON] == 0)
			{
				//Unused text shadow: Screen->DrawString(7, 9, -7, FONT_Z1, 17, -1, TF_NORMAL, ENEMYNAME_BUFFER, OP_OPAQUE);
				Screen->DrawString(7, 8, -8, FONT_Z1, 1, -1, TF_NORMAL, ENEMYNAME_BUFFER, OP_OPAQUE);
			}
			--RememberStuff[REMEMBER_ENEMYNAMEWAIT];
		}

	// --- Screen number and Link HP display (extra features of Hero Charm / See Enemy HP Mode)
		if (Link->Item[I_HEROCHARM])
		{
			if (Game->Counter[CR_WEATHER] != ENV_BLOCKY)
			{
				if (ModeMenu[MODEMENU_ON] == 0)
				{
					if (DoDraw)
					{
						if (RememberStuff[REMEMBER_ENEMYNAMEWAIT] == 0)
						{
							Screen->DrawString(
							7,					//int layer, 
							16, 					//int x,
							-8,					//int y, 
							FONT_Z1,				//int font,
							1,					//int color,
							-1,					//int background color, 
							TF_NORMAL, 				//int typeface,
							STR_SCREEN, 				//int string,
							OP_OPAQUE);				//int opacity

							Screen->DrawInteger(
							7,					//int layer, 
							56,					//int x, 
							-8,					//int y, 
							FONT_Z1,				//int font, 
							1,					//int color, 
							-1,					//int background_color, 
							-1,					//int width, 	
							-1,					//int height, 
							Game->GetCurScreen(),			//int number, 
							0, 					//int number_decimal_places, 
							128);					//int opacity
						}
	
						Screen->DrawInteger(
						7,					//int layer, 
						176,					//int x, 
						-32,					//int y, 
						FONT_Z1,				//int font, 
						17,					//int color, 
						-1,					//int background_color, 
						-1,					//int width, 	
						-1,					//int height, 
						Link->HP,				//int number, 
						0, 					//int number_decimal_places, 
						128);					//int opacity
					}
				}
				// Dynamic area title stuff:
				int str[] = "EnvironmentHelper";
				int ffcfind = FindFFCRunning(Game->GetFFCScript(str));
				if (ffcfind > 0)
				{
					ffc Helper = Screen->LoadFFC(ffcfind);
					if (Helper->InitD[2] > 0 && Game->GetCurScreen() < 128)
					{
						int str[255];
						GetMessage(Helper->InitD[2], str);
						if (DoDraw && ModeMenu[MODEMENU_ON] == 0)
						{
							Screen->DrawString(
								7,					//int layer, 
								16, 					//int x,
								-48,					//int y, 
								FONT_Z1,				//int font,
								1,					//int color,
								-1,					//int background color, 
								TF_NORMAL, 				//int typeface,
								str, 				//int string,
								OP_OPAQUE);				//int opacity
						}
						RememberStuff[REMEMBER_TITLE] = Helper->InitD[2];
					}
					else if (Game->GetCurScreen() >= 128 || Game->GetCurDMap() == DMAP_CAVES)
					{
						if (RememberStuff[REMEMBER_TITLE] > 0)
						{
							int str[255];
							if (DoDraw && ModeMenu[MODEMENU_ON] == 0)
							{
								GetMessage(RememberStuff[REMEMBER_TITLE], str);
								Screen->DrawString(
									7,					//int layer, 
									16, 					//int x,
									-48,					//int y, 
									FONT_Z1,				//int font,
									1,					//int color,
									-1,					//int background color, 
									TF_NORMAL, 				//int typeface,
									str, 				//int string,
									OP_OPAQUE);				//int opacity
							}
						}
					}
					else RememberStuff[REMEMBER_TITLE] = 0;
				}
				else if (Game->GetCurScreen() >= 128)
				{
					if (RememberStuff[REMEMBER_TITLE] > 0)
					{
						int str[255];
						GetMessage(RememberStuff[REMEMBER_TITLE], str);
						Screen->DrawString(
							7,					//int layer, 
							16, 					//int x,
							-48,					//int y, 
							FONT_Z1,				//int font,
							1,					//int color,
							-1,					//int background color, 
							TF_NORMAL, 				//int typeface,
							str, 				//int string,
							OP_OPAQUE);				//int opacity
					}
				}
				else RememberStuff[REMEMBER_TITLE] = 0;
			}
		}

		if ((Link->Item[I_RECURSEDPICTOBOX] || RememberStuff[REMEMBER_SCROLLING] > 0) && Game->GetCurDMap() <= 0) FakeNoScroll1();

	// --- Weather effects (Environment)
		if (Game->Counter[CR_WEATHER] > 0 || Link->Item[I_CURSEDPICTOBOX])
		{
			bool DoDarkDraw = false;
		
			// --- Sakura
			if (Game->Counter[CR_WEATHER] == ENV_SAKURA) Screen->DrawScreen(5,WEATHER_MAP,WEATHER_SAKURA,0,0,0);
			
			// --- Rain
			if (Game->Counter[CR_WEATHER] == ENV_RAIN1 || Game->Counter[CR_WEATHER] == ENV_RAIN2)
			{
				if (Game->GetCurDMap() < DMAP_CAVES && Game->GetCurScreen() < 128)
				{
					if (Game->Counter[CR_WEATHER] == ENV_RAIN1) Screen->DrawScreen(5,WEATHER_MAP,WEATHER_RAIN,0,0,0);
					else Screen->DrawScreen(5,WEATHER_MAP,WEATHER_RAIN_OPAQUE,0,0,0);
					if (ModeMenu[WEATHER_NOISE] == 0)
					{
						Game->PlaySound(SFX_RAIN);
						ModeMenu[WEATHER_NOISE] = Rand(8,40);
					}	
					else --ModeMenu[WEATHER_NOISE];
					if (ModeMenu[WEATHER_NOISE] > 40) ModeMenu[WEATHER_NOISE] = 0;
				}
				else
				{
					if (ModeMenu[WEATHER_NOISE] == 0)
					{
						Game->PlaySound(SFX_RAIN_INSIDE);
						ModeMenu[WEATHER_NOISE] = Rand(8,40);
					}	
					else --ModeMenu[WEATHER_NOISE];
					if (ModeMenu[WEATHER_NOISE] > 40) ModeMenu[WEATHER_NOISE] = 0;
				}
			}

			// --- Mist
			else if (Game->Counter[CR_WEATHER] == ENV_SPRINKLE) Screen->DrawScreen(5,WEATHER_MAP,WEATHER_MIST,0,0,0);				

			// --- Snow
			else if (Game->Counter[CR_WEATHER] == ENV_SNOW) Screen->DrawScreen(5,WEATHER_MAP,WEATHER_SNOW,0,0,0);

			// --- Fog
			else if (Game->Counter[CR_WEATHER] == ENV_FOG) Screen->DrawScreen(5,WEATHER_MAP,WEATHER_FOG,0,0,0);
			
			// --- Breezy
			else if (Game->Counter[CR_WEATHER] == ENV_BREEZY) Screen->DrawScreen(5,WEATHER_MAP,WEATHER_BREEZE,0,0,0);

			// --- Light
			else if (Game->Counter[CR_WEATHER] == ENV_BRIGHT)
			{
				 Screen->DrawScreen(7,WEATHER_MAP,WEATHER_LIGHT,0,0,0);
				 Screen->DrawScreen(7,WEATHER_MAP,WEATHER_LIGHT,0,-176,0);
			}

			// --- Dark
			else if (Game->Counter[CR_WEATHER] == ENV_DARK)
			{
				 Screen->DrawScreen(7,WEATHER_MAP,WEATHER_DARK,0,0,0);
				 Screen->DrawScreen(7,WEATHER_MAP,WEATHER_DARK,0,-176,0);
			}

			// --- Scanlines
			else if (Game->Counter[CR_WEATHER] == ENV_SCANLINES)
			{
				Screen->DrawScreen(7,WEATHER_MAP,WEATHER_SCANLINES,0,0,0);
				Screen->DrawScreen(7,WEATHER_MAP,WEATHER_SCANLINES,0,-176,0);
			}
			
			// --- Dynamic Weather:
			else if (Game->Counter[CR_WEATHER] == ENV_DYNAMIC)
			{
				int str[] = "EnvironmentHelper";
				int ffcfind = FindFFCRunning(Game->GetFFCScript(str));
				if (ffcfind > 0)
				{
					ffc Helper = Screen->LoadFFC(ffcfind);
					if (RememberStuff[REMEMBER_DARKTIMER] > 0 && Game->GetCurDMap() < DMAP_CAVES && Game->GetCurScreen() < 128) --RememberStuff[REMEMBER_DARKTIMER];
					if (Helper->InitD[0] > 0)
					{
						RememberStuff[REMEMBER_RAIN] = 0;
						int weather = Helper->InitD[0];
						int wavy = 0;
						// --- Rain
						if (weather == DYNAMIC_RAIN1 || weather == DYNAMIC_RAIN2)
						{
							if (Game->GetCurDMap() < DMAP_CAVES && Game->GetCurScreen() < 128)
							{
								if (Game->Counter[CR_WEATHER] == DYNAMIC_RAIN1) Screen->DrawScreen(5,WEATHER_MAP,WEATHER_RAIN,0,0,0);
								else Screen->DrawScreen(5,WEATHER_MAP,WEATHER_RAIN_OPAQUE,0,0,0);
								if (ModeMenu[WEATHER_NOISE] == 0)
								{
									Game->PlaySound(SFX_RAIN);
									ModeMenu[WEATHER_NOISE] = Rand(8,40);
								}	
								else --ModeMenu[WEATHER_NOISE];
								if (ModeMenu[WEATHER_NOISE] > 40) ModeMenu[WEATHER_NOISE] = 0;
							}
							else
							{
								if (ModeMenu[WEATHER_NOISE] == 0)
								{
									Game->PlaySound(SFX_RAIN_INSIDE);
									ModeMenu[WEATHER_NOISE] = Rand(8,40);
								}	
								else --ModeMenu[WEATHER_NOISE];
								if (ModeMenu[WEATHER_NOISE] > 40) ModeMenu[WEATHER_NOISE] = 0;
							}
							RememberStuff[REMEMBER_RAIN] = 1;
						}

						// --- Dynamic Mist
						else if (weather == DYNAMIC_SPRINKLE) Screen->DrawScreen(5,WEATHER_MAP,WEATHER_MIST,0,0,0);				

						// --- Dynamic Snow
						else if (weather == DYNAMIC_SNOW) Screen->DrawScreen(5,WEATHER_MAP,WEATHER_SNOW,0,0,0);

						// --- Dynamic Fog
						else if (weather == DYNAMIC_FOG) Screen->DrawScreen(5,WEATHER_MAP,WEATHER_FOG,0,0,0);

						// --- Dynamic Sakura
						else if (weather == DYNAMIC_SAKURA) Screen->DrawScreen(5,WEATHER_MAP,WEATHER_SAKURA,0,0,0);
						
						// --- Dynamic Breezy
						else if (weather == DYNAMIC_BREEZY) Screen->DrawScreen(5,WEATHER_MAP,WEATHER_BREEZE,0,0,0);

						// --- Dynamic Light
						else if (weather == DYNAMIC_BRIGHT)
						{
							 Screen->DrawScreen(7,WEATHER_MAP,WEATHER_LIGHT,0,0,0);
							 Screen->DrawScreen(7,WEATHER_MAP,WEATHER_LIGHT,0,-176,0);
						}


						// --- Dynamic Scanlines
						else if (weather== DYNAMIC_SCANLINES)
						{
							Screen->DrawScreen(7,WEATHER_MAP,WEATHER_SCANLINES,0,0,0);
							Screen->DrawScreen(7,WEATHER_MAP,WEATHER_SCANLINES,0,-176,0);
						}
						
						// --- Dynamic Light Circle Darkroom
						else if (weather == DYNAMIC_DARKROOM)
						{
							DoDarkDraw = true;
						}
						
						// Dynamic wavy screen 
						else if (weather == DYNAMIC_WAVY2) wavy = 24;

						// Dynamic slightly wavy screen
						else if (weather == DYNAMIC_WAVY1) wavy = 8;

						// Dynamic Heat Ripples
						else if (weather== DYNAMIC_HEATWAVY) wavy = 1;
						
						// --- Dynamic Dark
						else if (weather == DYNAMIC_DARK)
						{
							if (RememberStuff[REMEMBER_DARKTIMER] < 60) RememberStuff[REMEMBER_DARKTIMER]+=2;
							 //Screen->DrawScreen(7,WEATHER_MAP,WEATHER_DARK,0,-176,0);
						}
						
						if (Helper->InitD[1] > 0)
						{
							weather = Helper->InitD[1];
							// --- Rain
							if (weather == DYNAMIC_RAIN1 || weather == DYNAMIC_RAIN2)
							{
								if (Game->GetCurDMap() < DMAP_CAVES && Game->GetCurScreen() < 128)
								{
									if (Game->Counter[CR_WEATHER] == DYNAMIC_RAIN1) Screen->DrawScreen(5,WEATHER_MAP,WEATHER_RAIN,0,0,0);
									else Screen->DrawScreen(5,WEATHER_MAP,WEATHER_RAIN_OPAQUE,0,0,0);
									if (ModeMenu[WEATHER_NOISE] == 0)
									{
										Game->PlaySound(SFX_RAIN);
										ModeMenu[WEATHER_NOISE] = Rand(8,40);
									}	
									else --ModeMenu[WEATHER_NOISE];
									if (ModeMenu[WEATHER_NOISE] > 40) ModeMenu[WEATHER_NOISE] = 0;
								}
								else
								{
									if (ModeMenu[WEATHER_NOISE] == 0)
									{
										Game->PlaySound(SFX_RAIN_INSIDE);
										ModeMenu[WEATHER_NOISE] = Rand(8,40);
									}	
									else --ModeMenu[WEATHER_NOISE];
									if (ModeMenu[WEATHER_NOISE] > 40) ModeMenu[WEATHER_NOISE] = 0;
								}
								RememberStuff[REMEMBER_RAIN] = 1;
							}

							// --- Dynamic Mist
							else if (weather == DYNAMIC_SPRINKLE) Screen->DrawScreen(5,WEATHER_MAP,WEATHER_MIST,0,0,0);				

							// --- Dynamic Snow
							else if (weather == DYNAMIC_SNOW) Screen->DrawScreen(5,WEATHER_MAP,WEATHER_SNOW,0,0,0);

							// --- Dynamic Fog
							else if (weather == DYNAMIC_FOG) Screen->DrawScreen(5,WEATHER_MAP,WEATHER_FOG,0,0,0);

							// --- Dynamic Sakura
							else if (weather == DYNAMIC_SAKURA) Screen->DrawScreen(5,WEATHER_MAP,WEATHER_SAKURA,0,0,0);
							
							// --- Dynamic Breezy
							else if (weather == DYNAMIC_BREEZY) Screen->DrawScreen(5,WEATHER_MAP,WEATHER_BREEZE,0,0,0);

							// --- Dynamic Light
							else if (weather == DYNAMIC_BRIGHT)
							{
								 Screen->DrawScreen(7,WEATHER_MAP,WEATHER_LIGHT,0,0,0);
								 Screen->DrawScreen(7,WEATHER_MAP,WEATHER_LIGHT,0,-176,0);
							}

							// --- Dynamic Dark
							else if (weather == DYNAMIC_DARK)
							{
								if (RememberStuff[REMEMBER_DARKTIMER] < 60) RememberStuff[REMEMBER_DARKTIMER]+=2;
								 //Screen->DrawScreen(7,WEATHER_MAP,WEATHER_DARK,0,-176,0);
							}

							// --- Dynamic Scanlines
							else if (weather== DYNAMIC_SCANLINES)
							{
								Screen->DrawScreen(7,WEATHER_MAP,WEATHER_SCANLINES,0,0,0);
								Screen->DrawScreen(7,WEATHER_MAP,WEATHER_SCANLINES,0,-176,0);
							}
							
							// --- Dynamic Light Circle Darkroom
							else if (weather == DYNAMIC_DARKROOM)
							{
								DoDarkDraw = true;
							}
							
							// Dynamic very wavy screen
							else if (weather == DYNAMIC_WAVY2) wavy += 24;

							// Dynamic slightly wavy screen
							else if (weather == DYNAMIC_WAVY1) wavy += 8;

							// Dynamic heat Ripples
							else if (weather== DYNAMIC_HEATWAVY) wavy += 1;
						}
						if (wavy > 0) Screen->Wavy = wavy;
					}
					else if (Game->GetCurScreen() >= 128)
					{
						if (RememberStuff[REMEMBER_RAIN] > 0)
						{
							if (ModeMenu[WEATHER_NOISE] == 0)
							{
								Game->PlaySound(SFX_RAIN_INSIDE);
								ModeMenu[WEATHER_NOISE] = Rand(8,40);
							}	
							else --ModeMenu[WEATHER_NOISE];
							if (ModeMenu[WEATHER_NOISE] > 40) ModeMenu[WEATHER_NOISE] = 0;
						}
					}
					else RememberStuff[REMEMBER_RAIN] = 0;
					
					if (Game->GetCurDMap() < DMAP_CAVES && Game->GetCurScreen() < 128)
					{
						if (RememberStuff[REMEMBER_DARKTIMER] >= 60) Screen->DrawScreen(2,WEATHER_MAP,WEATHER_NIGHT,0,0,0);
						else if (RememberStuff[REMEMBER_DARKTIMER] >= 40) 
						{
							Screen->DrawScreen(2,WEATHER_MAP,100,0,0,0);
							Screen->DrawScreen(2,WEATHER_MAP,97,0,0,0);
						}
						else if (RememberStuff[REMEMBER_DARKTIMER] >= 20) Screen->DrawScreen(2,WEATHER_MAP,97,0,0,0);
					}
				}
				else if (Game->GetCurScreen() >= 128)
				{
					if (RememberStuff[REMEMBER_RAIN] > 0)
					{
						if (ModeMenu[WEATHER_NOISE] == 0)
						{
							Game->PlaySound(SFX_RAIN_INSIDE);
							ModeMenu[WEATHER_NOISE] = Rand(8,40);
						}	
						else --ModeMenu[WEATHER_NOISE];
						if (ModeMenu[WEATHER_NOISE] > 40) ModeMenu[WEATHER_NOISE] = 0;
					}
				}
				else RememberStuff[REMEMBER_RAIN] = 0;
			}
			// -------------------------------------------------------------------------
			// --- Drawn bitmap screens: Includes Z3 scrolling, Skewed screen, Upside Down screen, Rotating Screen, "Atari 2600" style blocky screen, and NewWavy effects
			// -------------------------------------------------------------------------
			if ((Game->Counter[CR_WEATHER] <= ENV_BLOCKY || Game->Counter[CR_WEATHER] >= ENV_NEWWAVY1) || Link->Item[I_CURSEDPICTOBOX] || DoDarkDraw)
			{
				//Draw a black rectangle behind everything else that's about to be drawn:
				if (Game->Counter[CR_WEATHER] != ENV_DARKROOM)
				{				
					Screen->Rectangle(
						5,	//layer
						0,	//start X
						-8,	//start y
						256,	//end x
						176,	//end y
						15,1,0,0,0,true,128);
					//Extra black rectangle behind everything else because layer 5 and up vanish when the subscreen is opened, but layer 2 doesn't
					Screen->Rectangle(
						3,	//layer
						0,	//start X
						0,	//start y
						256,	//end x
						176,	//end y
						15,1,0,0,0,true,128);
					Screen->Rectangle(
						2,	//layer
						0,	//start X
						0,	//start y
						256,	//end x
						176,	//end y
						15,1,0,0,0,true,128);
				}

				Screen->SetRenderTarget(RT_BITMAP0);

				//Draw a black rectangle to "erase" the bitmap each frame:
				Screen->Rectangle(			
					2,	//layer
					0,	//start X
					0,	//start y
					511,	//end x
					511,	//end y
					15,1,0,0,0,true,128);
				
				// Draw current screen:

				if (Game->Counter[CR_WEATHER] == ENV_BLOCKY) 
				{
					for(ForTimer = 175; ForTimer > -1; --ForTimer)
					{
						if (Screen->ComboT[ForTimer] == CT_WATER)
							Screen->FastTile(
							2,
							128+ComboX(ForTimer),
							ComboY(ForTimer),
							TILE_SOLID_WATER,
							0,
							128);
						else if (Screen->ComboT[ForTimer] == CT_LOCKBLOCK)
							Screen->FastTile(
							2,
							128+ComboX(ForTimer),
							ComboY(ForTimer),
							TILE_ADVGATE,
							Screen->ComboC[ForTimer],
							128);
						else if (Screen->ComboT[ForTimer] == CT_BOSSLOCKBLOCK)
							Screen->FastTile(
							3,
							128+ComboX(ForTimer),
							ComboY(ForTimer),
							TILE_ADVGATE,
							Screen->ComboC[ForTimer],
							128);
						else if (Screen->ComboT[ForTimer] == CT_LEFTSTATUE || Screen->ComboT[ForTimer] == CT_RIGHTSTATUE) 
							Screen->FastTile(
							2,
							128+ComboX(ForTimer),
							ComboY(ForTimer),
							TILE_SOLID_WATER,
							Screen->ComboC[ForTimer],
							128);
						else if (Screen->ComboT[ForTimer] == CT_CAVE || Screen->ComboT[ForTimer] == CT_SCRIPT5 || Screen->ComboD[ForTimer] < 4) 
							Screen->FastTile(
							2,
							128+ComboX(ForTimer),
							ComboY(ForTimer),
							TILE_BLACK,
							Screen->ComboC[ForTimer],
							128);
						else if (Screen->ComboT[ForTimer] == CT_STAIR)
							Screen->FastTile(
							2,
							128+ComboX(ForTimer),
							ComboY(ForTimer),
							TILE_BLOCKYSTAIRS,
							Screen->ComboC[ForTimer],
							128);
						else if (Screen->ComboS[ForTimer] != 0) 
							Screen->FastTile(
							2,
							128+ComboX(ForTimer),
							ComboY(ForTimer),
							TILE_SOLID_DARK,
							Screen->ComboC[ForTimer],
							128);
						else 
							Screen->FastTile(
							2,
							128+ComboX(ForTimer),
							ComboY(ForTimer),
							TILE_SOLID_LIGHT,
							Screen->ComboC[ForTimer],
							128);
						if (Screen->ComboD[ForTimer] == SHOVEL_POTHOLE || Screen->ComboD[ForTimer] == SAND_POTHOLE)
							Screen->FastTile(
							2,
							128+ComboX(ForTimer),
							ComboY(ForTimer),
							TILE_BLOCKYHOLE,
							Screen->ComboC[ForTimer],
							128);
						if (Screen->ComboT[ForTimer] >= CT_DAMAGE1 && Screen->ComboT[ForTimer] <= CT_DAMAGE4 || Screen->ComboT[ForTimer] >= CT_DAMAGE5 && Screen->ComboT[ForTimer] <= CT_DAMAGE7)
							Screen->FastTile(
							2,
							128+ComboX(ForTimer),
							ComboY(ForTimer),
							TILE_QUARTERSOLID,
							Rand(11),
							128);
						if (Game->GetCurScreen() > 127)
						{
							if (Screen->ComboT[ForTimer] == CT_STAIR) 
							Screen->FastTile(
							2,
							128+ComboX(ForTimer),
							ComboY(ForTimer),
							TILE_SOLID_LIGHT,
							0,
							128);
						}
					}
					// Special behavior for Dungeons:
					if (Game->GetCurDMap() >= DMAP_FIRST_DUNGEON && Game->GetCurDMap() <= DMAP_LAST_DUNGEON || Game->GetCurDMap() >= DMAP_FAKE_LAST)
					{
						// Dungeon doors (Up)
						if (Screen->Door[DOOR_UP] == D_LOCKED)
							Screen->FastTile(
							2,
							128+120,
							16,
							TILE_ADVGATE,
							2,
							128);
						else if (Screen->Door[DOOR_UP] == D_BOSSLOCKED)
							Screen->FastTile(
							2,
							128+120,
							16,
							TILE_ADVGATE,
							3,
							128);
						else if (Screen->Door[DOOR_UP] == D_SHUTTER || Screen->Door[DOOR_UP] == D_1WAYSHUTTER)
							Screen->FastTile(
							2,
							128+120,
							16,
							TILE_BLOCKYSHUTTER,
							2,
							128);
						else if (Screen->Door[DOOR_UP] == D_OPEN || Screen->Door[DOOR_UP] == D_OPENSHUTTER || Screen->Door[DOOR_UP] == D_BOSSUNLOCKED || Screen->Door[DOOR_UP] == D_UNLOCKED || Screen->Door[DOOR_UP] == D_BOMBED)
							Screen->FastTile(
							2,
							128+120,
							16,
							TILE_BLACK,
							2,
							128);

						// Dungeon doors (Down)
						if (Screen->Door[DOOR_DOWN] == D_LOCKED)
							Screen->FastTile(
							2,
							128+120,
							144,
							TILE_ADVGATE,
							2,
							128);
						else if (Screen->Door[DOOR_DOWN] == D_BOSSLOCKED)
							Screen->FastTile(
							2,
							128+120,
							144,
							TILE_ADVGATE,
							3,
							128);
						else if (Screen->Door[DOOR_DOWN] == D_SHUTTER || Screen->Door[DOOR_DOWN] == D_1WAYSHUTTER)
							Screen->FastTile(
							2,
							128+120,
							144,
							TILE_BLOCKYSHUTTER,
							2,
							128);
						else if (Screen->Door[DOOR_DOWN] == D_OPEN || Screen->Door[DOOR_DOWN] == D_OPENSHUTTER || Screen->Door[DOOR_DOWN] == D_BOSSUNLOCKED || Screen->Door[DOOR_DOWN] == D_UNLOCKED || Screen->Door[DOOR_DOWN] == D_BOMBED)
							Screen->FastTile(
							2,
							128+120,
							144,
							TILE_BLACK,
							2,
							128);

						// Dungeon doors (Left)
						if (Screen->Door[DOOR_LEFT] == D_LOCKED)
							Screen->FastTile(
							2,
							128+16,
							80,
							TILE_ADVGATE,
							2,
							128);
						else if (Screen->Door[DOOR_LEFT] == D_BOSSLOCKED)
							Screen->FastTile(
							2,
							128+16,
							80,
							TILE_ADVGATE,
							3,
							128);
						else if (Screen->Door[DOOR_LEFT] == D_SHUTTER || Screen->Door[DOOR_LEFT] == D_1WAYSHUTTER)
							Screen->FastTile(
							2,
							128+16,
							80,
							TILE_BLOCKYSHUTTER,
							2,
							128);
						else if (Screen->Door[DOOR_LEFT] == D_OPEN || Screen->Door[DOOR_LEFT] == D_OPENSHUTTER || Screen->Door[DOOR_LEFT] == D_BOSSUNLOCKED || Screen->Door[DOOR_LEFT] == D_UNLOCKED || Screen->Door[DOOR_LEFT] == D_BOMBED)
							Screen->FastTile(
							2,
							128+16,
							80,
							TILE_BLACK,
							2,
							128);

						// Dungeon doors (Right)
						if (Screen->Door[DOOR_RIGHT] == D_LOCKED)
							Screen->FastTile(
							2,
							128+224,
							80,
							TILE_ADVGATE,
							2,
							128);
						if (Screen->Door[DOOR_RIGHT] == D_BOSSLOCKED)
							Screen->FastTile(
							2,
							128+224,
							80,
							TILE_ADVGATE,
							3,
							128);
						else if (Screen->Door[DOOR_RIGHT] == D_SHUTTER || Screen->Door[DOOR_RIGHT] == D_1WAYSHUTTER)
							Screen->FastTile(
							2,
							128+224,
							80,
							TILE_BLOCKYSHUTTER,
							2,
							128);
						else if (Screen->Door[DOOR_RIGHT] == D_OPEN || Screen->Door[DOOR_RIGHT] == D_OPENSHUTTER || Screen->Door[DOOR_RIGHT] == D_BOSSUNLOCKED || Screen->Door[DOOR_RIGHT] == D_UNLOCKED || Screen->Door[DOOR_RIGHT] == D_BOMBED)
							Screen->FastTile(
							2,
							128+224,
							80,
							TILE_BLACK,
							2,
							128);						
					}
				}
				else
				{
					for(ForTimer = 175; ForTimer > -1; --ForTimer)
					Screen->FastCombo(
							2,
							128+ComboX(ForTimer),
							ComboY(ForTimer),
							Screen->ComboD[ForTimer],
							Screen->ComboC[ForTimer],
							128);
				}

				// only the overworld draws the next screens over, and only on Skewed mode:
				if (Game->GetCurDMap() < DMAP_CAVES)
				{
					if (!Link->Item[I_CURSEDPICTOBOX])
					{
						if (Game->Counter[CR_WEATHER] == ENV_SKEW || Game->Counter[CR_WEATHER] == ENV_NEWWAVY1 || Game->Counter[CR_WEATHER] == ENV_NEWWAVY2)
						{
							if (Game->GetCurScreen() < 128)
							{
								if (Game->GetCurScreen() == 32) Screen->DrawScreen(2,Game->GetCurMap(),Game->GetCurScreen()+15,-128,0,0);  // This line is a special exception for this quest's graveyard sideways wraparound secret.
								// Draw ocean on edges of dmap 0
								else if (Game->GetCurScreen() != 0 && Game->GetCurScreen() != 16 && Game->GetCurScreen() != 48 && Game->GetCurScreen() != 64 && Game->GetCurScreen() != 80 && Game->GetCurScreen() != 96 && Game->GetCurScreen() != 112) Screen->DrawScreen(2,Game->GetCurMap(),Game->GetCurScreen()-1,-128,0,0);
								else Screen->DrawScreen(2,WEATHER_MAP,WEATHER_WATER,-128,0,0);	
		
								if (Game->GetCurScreen() == 47) Screen->DrawScreen(2,Game->GetCurMap(),Game->GetCurScreen()-15,384,0,0); // This line is also a special exception for the same graveyard sideways wraparound secret.
		
								else if (Game->GetCurScreen() != 15 && Game->GetCurScreen() != 31 && Game->GetCurScreen() != 63 && Game->GetCurScreen() != 79 && Game->GetCurScreen() != 95 && Game->GetCurScreen() != 111 && Game->GetCurScreen() != 127) Screen->DrawScreen(2,Game->GetCurMap(),Game->GetCurScreen()+1,384,0,0);
								else Screen->DrawScreen(2,WEATHER_MAP,WEATHER_WATER,384,0,0);
							}
							else
							{
								// Draw cave walls in cave screens
								Screen->DrawScreen(2,WEATHER_MAP,WEATHER_ROCK,-128,0,0);
								Screen->DrawScreen(2,WEATHER_MAP,WEATHER_ROCK,384,0,0);
							}
						}
					}
				}

				// Draw dungeon walls:
				else if (Game->GetCurDMap() >= DMAP_FIRST_DUNGEON && Game->GetCurDMap() <= DMAP_LAST_DUNGEON || Game->GetCurDMap() == DMAP_FAKE_LAST || Game->GetCurDMap() == 54 || Game->GetCurDMap() == 55)
				{
					if (!Link->Item[I_CURSEDPICTOBOX])
					{
						if (Game->GetCurDMap() <= 11 || Game->GetCurDMap() == 54 || Game->GetCurDMap() == 55)
						{
							Screen->DrawScreen(2,WEATHER_MAP,WEATHER_DUNGEON,-128,0,0);
							Screen->DrawScreen(2,WEATHER_MAP,WEATHER_DUNGEON,384,0,0);
						}
					}
				}
				
				if (Game->Counter[CR_WEATHER] != ENV_BLOCKY)
				{
					if (Screen->ComboD[0] == COMBO_DUNGEONWALL) 
					{
						if (Game->Counter[CR_WEATHER] == ENV_SKEW && Screen->Flags[9] != 0x0010)
						{
							if (Screen->Door[DOOR_DOWN] != D_WALL && Screen->Door[DOOR_DOWN] != D_BOMB) Screen->Rectangle(			
							2,	//layer
							128+112,//start X
							160,	//start y
							128+144,//end x
							176,	//end y
							15,1,0,0,0,true,128);

							if (Screen->Door[DOOR_DOWN] == D_OPEN || Screen->Door[DOOR_DOWN] == D_OPENSHUTTER || Screen->Door[DOOR_DOWN] == D_BOSSUNLOCKED || Screen->Door[DOOR_DOWN] == D_UNLOCKED)
							{
								Screen->DrawTile(
								2,128+112,160,
								15422,2,1,2,
								-1,-1,0,0,0,0,true,128);
							}
						}
					}
				// Draw moving pushblock:
					if (Screen->MovingBlockX >= 0) Screen->FastCombo (2, 128+Screen->MovingBlockX, Screen->MovingBlockY, Screen->MovingBlockCombo, Screen->MovingBlockCSet, OP_OPAQUE);
				}
				

				// Draw FFCs:
				for(ForTimer = 32; ForTimer > 0; --ForTimer)
				{
					randoFFC = Screen->LoadFFC(ForTimer);
					if(randoFFC->Data > 4)
					{
						if (!randoFFC->Flags[FFCF_LENSVIS] && !randoFFC->Flags[FFCF_CHANGER])
						{
							if (Game->Counter[CR_WEATHER] == ENV_BLOCKY) Screen->FastTile(2,128+randoFFC->X,randoFFC->Y,TILE_QUARTERSOLID,randoFFC->CSet,128);
							else Screen->FastCombo(2,128+randoFFC->X,randoFFC->Y,randoFFC->Data,randoFFC->CSet,128);
						}
					}
					if (randoFFC->Script == SCRIPT_WALLCRUSH)
					{
						// Draws the crushing walls from FFC script "WallCrush"
						Screen->Rectangle(
							3,			//layer
							-128+randoFFC->X,	//start X
							0,			//start y
							randoFFC->X+127,	//end x
							176,			//end y
							0,1,0,0,0,true,128);	
						Screen->Rectangle(
							3,			//layer
							384-randoFFC->X,	//start X
							0,			//start y
							384,			//end x
							176,			//end y
							0,1,0,0,0,true,128);	
						if (Game->Counter[CR_WEATHER] == ENV_SKEW)
						{
							Screen->DrawScreen(3,MAP_WALLS,88,-128+randoFFC->X,0,0);
							Screen->DrawScreen(3,MAP_WALLS,87,384-randoFFC->X,0,0);
						}
						else if (Game->Counter[CR_WEATHER] != ENV_BLOCKY)
						{
							Screen->DrawScreen(3,MAP_WALLS,SCREEN_LEFTWALL,-128+randoFFC->X,0,0);
							Screen->DrawScreen(3,MAP_WALLS,SCREEN_RIGHTWALL,384-randoFFC->X,0,0);
						}
					}
				}

				// Draw shop prices:
				// NOTE: Yes, these price displays are hardcoded. I wasn't really sure saving const_ints for these would save anyone any time, sorry. I would've just looked up the shop prices through ZC to know what to display, but 2.53 lacks a means of doing so AFAIK.
				// To change them, you have to manually edit the numbers below to match your shops.
				if (Game->GetCurScreen() >= 128 || Game->GetCurMap() > 1)
				{
					if (RememberRooms[REMEMBER_ROOMTYPE] == RT_SHOP || RememberRooms[REMEMBER_ROOMTYPE] == RT_POTIONSHOP && Link->Item[I_LETTERUSED])
					{
						if (Screen->NumItems() > 0)
						{
							if (RememberRooms[REMEMBER_ROOMDATA] == 0)
							{
								RememberRooms[REMEMBER_PRICE1] = 160;
								RememberRooms[REMEMBER_PRICE2] = 100;
								RememberRooms[REMEMBER_PRICE3] = 60;
							}
							else if (RememberRooms[REMEMBER_ROOMDATA] == 1)
							{
								RememberRooms[REMEMBER_PRICE1] = 130;
								RememberRooms[REMEMBER_PRICE2] = 20;
								RememberRooms[REMEMBER_PRICE3] = 80;
							}
							else if (RememberRooms[REMEMBER_ROOMDATA] == 2)
							{
								RememberRooms[REMEMBER_PRICE1] = 90;
								RememberRooms[REMEMBER_PRICE2] = 100;
								RememberRooms[REMEMBER_PRICE3] = 10;
							}
							else if (RememberRooms[REMEMBER_ROOMDATA] == 3)
							{
								RememberRooms[REMEMBER_PRICE1] = 80;
								RememberRooms[REMEMBER_PRICE2] = 250;
								RememberRooms[REMEMBER_PRICE3] = 60;
							}
							else if (RememberRooms[REMEMBER_ROOMDATA] == 4)
							{
								RememberRooms[REMEMBER_PRICE1] = 40;
								RememberRooms[REMEMBER_PRICE2] = 68;
								RememberRooms[REMEMBER_PRICE3] = 0;
							}
							else if (RememberRooms[REMEMBER_ROOMDATA] == 6)
							{
								RememberRooms[REMEMBER_PRICE1] = 0;
								RememberRooms[REMEMBER_PRICE2] = 250;
								RememberRooms[REMEMBER_PRICE3] = 0;
							}
							else if (RememberRooms[REMEMBER_ROOMDATA] == 7)
							{
								RememberRooms[REMEMBER_PRICE1] = 20;
								RememberRooms[REMEMBER_PRICE2] = 50;
								RememberRooms[REMEMBER_PRICE3] = 100;
							}
							else if (RememberRooms[REMEMBER_ROOMDATA] == 8)
							{
								RememberRooms[REMEMBER_PRICE1] = 0;
								RememberRooms[REMEMBER_PRICE2] = 160;
								RememberRooms[REMEMBER_PRICE3] = 0;
							}
							else if (RememberRooms[REMEMBER_ROOMDATA] == 10)
							{
								RememberRooms[REMEMBER_PRICE1] = 20;
								RememberRooms[REMEMBER_PRICE2] = 40;
								RememberRooms[REMEMBER_PRICE3] = 30;
							}
							else if (RememberRooms[REMEMBER_ROOMDATA] == 11)
							{
								RememberRooms[REMEMBER_PRICE1] = 40;
								RememberRooms[REMEMBER_PRICE2] = 100;
								RememberRooms[REMEMBER_PRICE3] = 16;
							}
							else if (RememberRooms[REMEMBER_ROOMDATA] == 12)
							{
								RememberRooms[REMEMBER_PRICE1] = 90;
								RememberRooms[REMEMBER_PRICE2] = 16;
								RememberRooms[REMEMBER_PRICE3] = 60;
							}
							else if (RememberRooms[REMEMBER_ROOMDATA] == 13)
							{
								RememberRooms[REMEMBER_PRICE1] = 60;
								RememberRooms[REMEMBER_PRICE2] = 16;
								RememberRooms[REMEMBER_PRICE3] = 80;
							}
							else if (RememberRooms[REMEMBER_ROOMDATA] == 14)
							{
								RememberRooms[REMEMBER_PRICE1] = 160;
								RememberRooms[REMEMBER_PRICE2] = 16;
								RememberRooms[REMEMBER_PRICE3] = 40;
							}
							else if (RememberRooms[REMEMBER_ROOMDATA] == 15)
							{
								RememberRooms[REMEMBER_PRICE1] = 40;
								RememberRooms[REMEMBER_PRICE2] = 68;
								RememberRooms[REMEMBER_PRICE3] = 0;
							}
							else if (RememberRooms[REMEMBER_ROOMDATA] == 16)
							{
								RememberRooms[REMEMBER_PRICE1] = 100;
								RememberRooms[REMEMBER_PRICE2] = 10;
								RememberRooms[REMEMBER_PRICE3] = 16;
							}
							else
							{
								RememberRooms[REMEMBER_PRICE1] = 0;
								RememberRooms[REMEMBER_PRICE2] = 0;
								RememberRooms[REMEMBER_PRICE3] = 0;
							}
							Screen->DrawCharacter(
							2,					//int layer, 
							128+64,					//int x, 
							112,					//int y, 
							FONT_Z1,				//int font, 
							1,					//int color, 
							-1,					//int background_color, 
							-1,					//int width, 	
							-1,					//int height, 
							88,					//int glyph, 
							128);					//int opacity

							if (RememberRooms[REMEMBER_PRICE1] > 0 && RememberRooms[REMEMBER_PRICE2] > 0 && RememberRooms[REMEMBER_PRICE3] == 0)
							{
								Screen->DrawInteger(
								2,					//int layer, 
								128+88,					//int x, 
								112,					//int y, 
								FONT_Z1,				//int font, 
								1,					//int color, 
								-1,					//int background_color, 
								-1,					//int width, 	
								-1,					//int height, 
								RememberRooms[REMEMBER_PRICE1],		//int number, 
								0, 					//int number_decimal_places, 
								128);					//int opacity
		
								Screen->DrawInteger(
								2,					//int layer, 
								128+152,				//int x, 
								112,					//int y, 
								FONT_Z1,				//int font, 
								1,					//int color, 
								-1,					//int background_color, 
								-1,					//int width, 
								-1,					//int height, 
								RememberRooms[REMEMBER_PRICE2],		//int number, 
								0, 					//int number_decimal_places, 
								128);					//int opacity
							}
							else
							{
								if (RememberRooms[REMEMBER_PRICE1] > 0) Screen->DrawInteger(
								2,					//int layer, 
								128+80,					//int x, 
								112,					//int y, 
								FONT_Z1,				//int font, 
								1,					//int color, 
								-1,					//int background_color, 
								-1,					//int width, 	
								-1,					//int height, 
								RememberRooms[REMEMBER_PRICE1],		//int number, 
								0, 					//int number_decimal_places, 
								128);					//int opacity
		
								if (RememberRooms[REMEMBER_PRICE2] > 0) Screen->DrawInteger(
								2,					//int layer, 
								128+116,				//int x, 
								112,					//int y, 
								FONT_Z1,				//int font, 
								1,					//int color, 
								-1,					//int background_color, 
								-1,					//int width, 
								-1,					//int height, 
								RememberRooms[REMEMBER_PRICE2],		//int number, 
								0, 					//int number_decimal_places, 
								128);					//int opacity
	
								if (RememberRooms[REMEMBER_PRICE3] > 0) Screen->DrawInteger(
								2,					//int layer, 
								128+152,				//int x, 	
								112,					//int y, 
									FONT_Z1,				//int font, 
								1,					//int color, 
								-1,					//int background_color, 
								-1,					//int width, 
								-1,					//int height, 
								RememberRooms[REMEMBER_PRICE3],		//int number, 
								0, 					//int number_decimal_places, 
								128);					//int opacity
							}
						}
					}
				}

				// Draw Bow-Wow's chain:
				if (Game->Counter[CR_WEATHER] != ENV_BLOCKY)
				{
					if (BowWow->isValid())
					{
						if (Link->X > 2 && Link->X < 238 && Link->Y > 2 && Link->Y < 158 && Link->HP > 0)
						{
							Screen->FastTile(
								2, 
								128+Link->X+((BowWow->X - Link->X) / 2), 
								Link->Y+((BowWow->Y - Link->Y) / 2) - (Link->Z/2)+BowWow->DrawYOffset/1.5, 
								BOWWOWCHAIN_TILE, BowWow->CSet, 128);
							Screen->FastTile(
								2, 
								128+Link->X+((BowWow->X - Link->X) / 3.75), 
								Link->Y+((BowWow->Y - Link->Y) / 3.75) - Link->Z +BowWow->DrawYOffset/2, 
								BOWWOWCHAIN_TILE, BowWow->CSet, 128);
							Screen->FastTile(
								2, 
								128+Link->X+((BowWow->X - Link->X) / 1.35), 
								Link->Y+((BowWow->Y - Link->Y) / 1.35) - (Link->Z/3)+BowWow->DrawYOffset, 
								BOWWOWCHAIN_TILE, BowWow->CSet, 128);
						}
					}
				}

				// Draw LWeapons:
				for(ForTimer = Screen->NumLWeapons(); ForTimer > 0; --ForTimer)
				{
					randoLW = Screen->LoadLWeapon(ForTimer);
					if(!randoLW->isValid()) continue;
					{
						if (Game->Counter[CR_WEATHER] == ENV_BLOCKY)
						{
							if (randoLW->ID == LW_BOMBBLAST || randoLW->ID == LW_SBOMBBLAST)
							{
								Screen->Rectangle(
									2,	//layer
									128+randoLW->X-16,	//start X
									randoLW->Y-16,		//start y
									128+randoLW->X+32,	//end x
									randoLW->Y+32,		//end y
									Rand(176),1,0,0,0,true,128);
							}
							//else if (randoLW->HitHeight > 16 || randoLW->HitWidth > 16) 
							//	Screen->Rectangle(
							//	2,								//layer
							//	128+randoLW->X,							//start X
							//	randoLW->Y,							//start y
							//	128+randoLW->X + randoLW->HitWidth,				//end x
							//	randoLW->Y + randoLW->HitHeight,				//end y
							//	97,1,0,0,0,true,128);
 							else if (randoLW->ID == LW_SOMARIA)
							{
								if (randoLW->CSet == 6)
								{
									Screen->FastTile(
									2,
									128+randoLW->X+randoLW->DrawXOffset,	//start X
									randoLW->Y+randoLW->DrawYOffset,	
									TILE_SOLID_DARK,
									2,
									128);
								}
								else
								{
									Screen->FastTile(
									2,
									128+randoLW->X+randoLW->DrawXOffset,	//start X
									randoLW->Y+randoLW->DrawYOffset,	
									TILE_SOLID_DARK,
									randoLW->CSet,
									128);
								}
							}
							else if (randoLW->ID == LW_SWORD || randoLW->ID == LW_WAND)
							{
								if (randoLW->Dir == DIR_UP)
									Screen->FastTile(
									2,
									128+randoLW->X+randoLW->DrawXOffset,	//start X
									randoLW->Y+randoLW->DrawYOffset,	
									TILE_ADVSWORD,
									randoLW->CSet,
									128);
								else if (randoLW->Dir == DIR_DOWN)
									Screen->FastTile(
									2,
									128+randoLW->X+randoLW->DrawXOffset,	//start X
									randoLW->Y+randoLW->DrawYOffset,	
									TILE_ADVSWORD+1,
									randoLW->CSet,
									128);
								else if (randoLW->Dir == DIR_LEFT)
									Screen->FastTile(
									2,
									128+randoLW->X+randoLW->DrawXOffset,	//start X
									randoLW->Y+randoLW->DrawYOffset,	
									TILE_ADVSWORD+2,
									randoLW->CSet,
									128);
								else if (randoLW->Dir == DIR_RIGHT)
									Screen->FastTile(
									2,
									128+randoLW->X+randoLW->DrawXOffset,	//start X
									randoLW->Y+randoLW->DrawYOffset,	
									TILE_ADVSWORD+3,
									randoLW->CSet,
									128);
							}
							else if (randoLW->ID == LW_BEAM)
							{
								if (randoLW->Dir == DIR_UP)
									Screen->FastTile(
									2,
									128+randoLW->X+randoLW->DrawXOffset,	//start X
									randoLW->Y+randoLW->DrawYOffset,	
									TILE_ADVSWORD,
									Choose(6,7,8,9),
									128);
								else if (randoLW->Dir == DIR_DOWN)
									Screen->FastTile(
									2,
									128+randoLW->X+randoLW->DrawXOffset,	//start X
									randoLW->Y+randoLW->DrawYOffset,	
									TILE_ADVSWORD+1,
									Choose(6,7,8,9),
									128);
								else if (randoLW->Dir == DIR_LEFT)
									Screen->FastTile(
									2,
									128+randoLW->X+randoLW->DrawXOffset,	//start X
									randoLW->Y+randoLW->DrawYOffset,	
									TILE_ADVSWORD+2,
									Choose(6,7,8,9),
									128);
								else if (randoLW->Dir == DIR_RIGHT)
									Screen->FastTile(
									2,
									128+randoLW->X+randoLW->DrawXOffset,	//start X
									randoLW->Y+randoLW->DrawYOffset,	
									TILE_ADVSWORD+3,
									Choose(6,7,8,9),
									128);
							}
							else if (randoLW->ID == LW_BEETLE) Screen->FastCombo(
								2,
								128+randoLW->X,
								randoLW->Y+randoLW->DrawYOffset,
								COMBO_ADVBAT,
								randoLW->CSet,
								128);
 							else if (randoLW->ID == LW_ARMOS)
								Screen->FastTile(
								2,
								128+randoLW->X+randoLW->DrawXOffset,	//start X
								randoLW->Y+randoLW->DrawYOffset,	
								TILE_INDY,
								randoLW->CSet,
								128);
 							else if (randoLW->ID == LW_ROPE)
							{
								if (randoLW->HitWidth < 24 && randoLW->HitHeight < 24)
								{
									Screen->FastTile(
									2,
									128+randoLW->X+randoLW->DrawXOffset,	//start X
									randoLW->Y+randoLW->DrawYOffset,	
									TILE_ADVBRIDGE,
									10,
									128);
								}
								else if (randoLW->HitHeight >= 24)
								{
									Screen->DrawTile(
									2,
									128+randoLW->X+randoLW->DrawXOffset,	//start X
									randoLW->Y+randoLW->DrawYOffset,	//start y
									TILE_ADVBRIDGE,				//tile ID
									1,					//tile width
									1,					//tile width
									10,					//tile cset
									16,
									32,
									-1,-1,0,randoLW->Flip,1,128);
								}
								else
								{
									Screen->DrawTile(
									2,
									128+randoLW->X+randoLW->DrawXOffset,	//start X
									randoLW->Y+randoLW->DrawYOffset,	//start y
									TILE_ADVBRIDGE,				//tile ID
									1,					//tile width
									1,					//tile width
									10,					//tile cset
									32,
									16,
									-1,-1,0,randoLW->Flip,1,128);
								}
							}
							else Screen->FastTile(
								2,
								128+randoLW->X+randoLW->DrawXOffset,	//start X
								randoLW->Y+randoLW->DrawYOffset,	
								TILE_QUARTERSOLID,
								randoLW->CSet,
								128);
						}
						else
						{
							if (randoLW->ID == LW_BOMBBLAST)
							{
								Screen->DrawCombo(
								2,
								128+randoLW->X+randoLW->DrawXOffset-16,	//start X
								randoLW->Y+randoLW->DrawYOffset-16,	//start y
								5944 + (randoLW->Tile % 3),		//tile ID
								3,					//tile width
								3,					//tile width
								randoLW->CSet,				//tile cset
								-1,-1,-1,-1,0,0,randoLW->Flip,true,128);
							}
							else if (randoLW->ID == LW_SBOMBBLAST)
							{
								Screen->DrawTile(
								2,
								128+randoLW->X+randoLW->DrawXOffset-16,	//start X
								randoLW->Y+randoLW->DrawYOffset-16,	//start y
								randoLW->Tile,				//tile ID
								randoLW->TileWidth,			//tile width
								randoLW->TileHeight,			//tile width
								randoLW->CSet,				//tile cset
								48,48,-1,-1,0,randoLW->Flip,1,128);
							}
							if (randoLW->Tile > 0 && randoLW->DeadState != WDS_BEAMSHARDS) Screen->DrawTile(
								2,
								128+randoLW->X+randoLW->DrawXOffset,	//start X
								randoLW->Y+randoLW->DrawYOffset,	//start y
								randoLW->Tile,				//tile ID
								randoLW->TileWidth,			//tile width
								randoLW->TileHeight,			//tile width
								randoLW->CSet,				//tile cset
								-1,-1,-1,-1,0,randoLW->Flip,1,128);
						}
					}
				}
				
				if (Game->Counter[CR_WEATHER] != ENV_BLOCKY)
				{
					if (Screen->ComboD[0] == COMBO_DUNGEONWALL && RememberStuff[REMEMBER_LINKPROMPT] > 0) 
					{
						if (Game->Counter[CR_WEATHER] != ENV_SKEW)
						{
							if (Screen->Flags[9]&0x0040) Screen->DrawScreen(2,WEATHER_MAP,89,128,0,0);
							else Screen->DrawScreen(2,WEATHER_MAP,WEATHER_DUNGEONWALL,128,0,0);
							
							if (Screen->Door[DOOR_UP] == D_LOCKED || Screen->Door[DOOR_UP] == D_BOSSLOCKED || Screen->Door[DOOR_UP] == D_SHUTTER || Screen->Door[DOOR_UP] == D_1WAYSHUTTER || Screen->Door[DOOR_UP] == D_OPEN || Screen->Door[DOOR_UP] == D_OPENSHUTTER || Screen->Door[DOOR_UP] == D_BOSSUNLOCKED || Screen->Door[DOOR_UP] == D_UNLOCKED)
							{
								Screen->DrawTile(2,128+112,0,
								15506,2,1,2,
								-1,-1,0,0,0,0,true,128);
							}
							if (Screen->Door[DOOR_DOWN] == D_LOCKED || Screen->Door[DOOR_DOWN] == D_BOSSLOCKED || Screen->Door[DOOR_DOWN] == D_SHUTTER || Screen->Door[DOOR_DOWN] == D_1WAYSHUTTER || Screen->Door[DOOR_DOWN] == D_OPEN || Screen->Door[DOOR_DOWN] == D_OPENSHUTTER || Screen->Door[DOOR_DOWN] == D_BOSSUNLOCKED || Screen->Door[DOOR_DOWN] == D_UNLOCKED)
							{
								Screen->DrawTile(2,128+112,160,
								15462,2,1,2,
								-1,-1,0,0,0,0,true,128);
							}
							Screen->FastCombo(2, 128+0, 64, Screen->ComboD[64], 2, OP_OPAQUE);
							Screen->FastCombo(2, 128+0, 80, Screen->ComboD[80], 2, OP_OPAQUE);
							Screen->FastCombo(2, 128+0, 96, Screen->ComboD[96], 2, OP_OPAQUE);
							Screen->FastCombo(2, 128+240, 64, Screen->ComboD[79], 2, OP_OPAQUE);
							Screen->FastCombo(2, 128+240, 80, Screen->ComboD[95], 2, OP_OPAQUE);
							Screen->FastCombo(2, 128+240, 96, Screen->ComboD[111], 2, OP_OPAQUE);
						}
						else 
						{
							Screen->DrawScreen(2,WEATHER_MAP,103,128,0,0);

							// Dungeon doors (Down)
							if (Screen->Door[DOOR_DOWN] == D_LOCKED)
							{
								Screen->DrawTile(2,128+112,144,
								15506,2,1,2,
								-1,-1,0,0,0,0,true,128);
								
								Screen->DrawTile(2,128+112,160,
								15406,2,1,2,
								-1,-1,0,0,0,0,true,128);
							}
							else if (Screen->Door[DOOR_DOWN] == D_BOSSLOCKED)
							{
								Screen->DrawTile(2,128+112,144,
								15506,2,1,2,
								-1,-1,0,0,0,0,true,128);
								
								Screen->DrawTile(2,128+112,160,
								15410,2,1,2,
								-1,-1,0,0,0,0,true,128);
							}
							else if (Screen->Door[DOOR_DOWN] == D_SHUTTER || Screen->Door[DOOR_DOWN] == D_1WAYSHUTTER)
							{
								Screen->DrawTile(2,128+112,144,
								15506,2,1,2,
								-1,-1,0,0,0,0,true,128);
								
								Screen->DrawTile(2,128+112,160,
								15404,2,1,2,
								-1,-1,0,0,0,0,true,128);
							}
							else if (Screen->Door[DOOR_DOWN] == D_OPEN || Screen->Door[DOOR_DOWN] == D_OPENSHUTTER || Screen->Door[DOOR_DOWN] == D_BOSSUNLOCKED || Screen->Door[DOOR_DOWN] == D_UNLOCKED)
							{
								Screen->DrawTile(2,128+112,144,
								15506,2,1,2,
								-1,-1,0,0,0,0,true,128);
							}
							else if (Screen->Door[DOOR_DOWN] == D_BOMBED)
							{
								Screen->DrawTile(2,128+112,160,
								15412,2,1,2,
								-1,-1,0,0,0,0,true,128);
							}
							else
							{
								Screen->DrawTile(2,128+112,160,
								15387,2,1,2,
								-1,-1,0,0,0,0,true,128);
							}
							if (Screen->Door[DOOR_UP] == D_LOCKED || Screen->Door[DOOR_UP] == D_BOSSLOCKED || Screen->Door[DOOR_UP] == D_SHUTTER || Screen->Door[DOOR_UP] == D_1WAYSHUTTER || Screen->Door[DOOR_UP] == D_OPEN || Screen->Door[DOOR_UP] == D_OPENSHUTTER || Screen->Door[DOOR_UP] == D_BOSSUNLOCKED || Screen->Door[DOOR_UP] == D_UNLOCKED)
							{
								Screen->DrawTile(2,128+112,0,
								15506,2,1,2,
								-1,-1,0,0,0,0,true,128);
							}
							Screen->FastCombo(2, 128+0, 64, Screen->ComboD[64], 2, OP_OPAQUE);
							Screen->FastCombo(2, 128+0, 80, Screen->ComboD[80], 2, OP_OPAQUE);
							Screen->FastCombo(2, 128+0, 96, Screen->ComboD[96], 2, OP_OPAQUE);
							Screen->FastCombo(2, 128+240, 64, Screen->ComboD[79], 2, OP_OPAQUE);
							Screen->FastCombo(2, 128+240, 80, Screen->ComboD[95], 2, OP_OPAQUE);
							Screen->FastCombo(2, 128+240, 96, Screen->ComboD[111], 2, OP_OPAQUE);
							Screen->DrawScreen(2,WEATHER_MAP,101,128,0,0);
						}
					}
				}
				
				if (Link->LadderX > 0) Screen->FastTile(2, 128+Link->LadderX, Link->LadderY, TILE_LADDER, 6, OP_OPAQUE);
				if (Link->Action == LA_RAFTING)
				{
					if (Link->Item[I_SOMARIARAFT]) Screen->FastTile(2, 128+Link->X, Link->Y + 3, TILE_SOMARIARAFT, 8, OP_OPAQUE);
					else Screen->FastTile(2, 128+Link->X, Link->Y + 3, TILE_RAFT, 6, OP_OPAQUE);
				}	

				if (RememberStuff[REMEMBER_LINKPROMPT] > 0)
				{
					Screen->Rectangle(2, 0, 0, 128+RememberStuff[REMEMBER_LINKPROMPT], 176 ,15,1,0,0,0,true,128);
					Screen->Rectangle(2, 128+255-RememberStuff[REMEMBER_LINKPROMPT], 0, 511, 176 ,15,1,0,0,0,true,128);
				}

				// Draw Partner:
				if (Game->GetCurScreen() == Partner[FOLLOW_SCREEN] && Game->GetCurMap() == Partner[FOLLOW_MAP] || Partner[FOLLOW_STATE] == 0)
				{
					if (DoDraw)
					{
						if (Link->Action != LA_HOLD1LAND && Link->Action != LA_HOLD2LAND && Link->Action != LA_HOLD1WATER && Link->Action != LA_HOLD2WATER || Link->HeldItem != I_LTTPSBOMB)
						{
							if (Game->Counter[CR_WEATHER] == ENV_BLOCKY)
							{
								if (Link->Item[I_LTTPSBOMB]) Screen->FastTile(2,128+Partner[FOLLOW_X],Partner[FOLLOW_Y],TILE_QUARTERSOLID,8,128);
								else if (Link->Item[I_PARTNER])
								{
									if (Game->Counter[CR_PCOSTUME] < 13) Screen->FastTile(2,128+Partner[FOLLOW_X],Partner[FOLLOW_Y],TILE_INDY,Game->Counter[CR_PCOSTUME]-1,128);
									else if (Game->Counter[CR_PCOSTUME] < 25) Screen->FastCombo(2,128+Partner[FOLLOW_X],Partner[FOLLOW_Y],COMBO_GRUNDLESMALL,Game->Counter[CR_PCOSTUME]-13,128);
									else if (Game->Counter[CR_PCOSTUME] < 37) Screen->FastCombo(2,128+Partner[FOLLOW_X],Partner[FOLLOW_Y],COMBO_ADVBAT,Game->Counter[CR_PCOSTUME]-25,128);
									else if (Game->Counter[CR_PCOSTUME] < 49) Screen->FastTile(2,128+Partner[FOLLOW_X],Partner[FOLLOW_Y],TILE_BLOCKYHEART,Game->Counter[CR_PCOSTUME]-37,128);
									else if (Game->Counter[CR_PCOSTUME] < 61) Screen->FastTile(2,128+Partner[FOLLOW_X],Partner[FOLLOW_Y],TILE_BLOCKYKEY,Game->Counter[CR_PCOSTUME]-49,128);
									else if (Game->Counter[CR_PCOSTUME] < 73) Screen->FastTile(2,128+Partner[FOLLOW_X],Partner[FOLLOW_Y],TILE_BLOCKYRUPY,Game->Counter[CR_PCOSTUME]-61,128);
									else if (Game->Counter[CR_PCOSTUME] < 85) Screen->FastTile(2,128+Partner[FOLLOW_X],Partner[FOLLOW_Y],TILE_SOLID_DARK,Game->Counter[CR_PCOSTUME]-73,128);
									else if (Game->Counter[CR_PCOSTUME] < 97) Screen->FastTile(2,128+Partner[FOLLOW_X],Partner[FOLLOW_Y],TILE_SOLID_LIGHT,Game->Counter[CR_PCOSTUME]-85,128);
									else if (Game->Counter[CR_PCOSTUME] < 109) Screen->FastTile(2,128+Partner[FOLLOW_X],Partner[FOLLOW_Y],TILE_SOLID_WATER,Game->Counter[CR_PCOSTUME]-97,128);
								}
							}
							else
							{
								if (Link->Item[I_LTTPSBOMB])
								{
									if(Partner[FOLLOW_STATE] == 0) Screen->FastTile(2,128+Partner[FOLLOW_X],Partner[FOLLOW_Y],LTTPSBOMB_TILE,8,128);
									else Screen->FastTile(2,128+Partner[FOLLOW_X],Partner[FOLLOW_Y],LTTPSBOMB_TILE,Choose(6,7,8,9),128);
								}
								else
								{
									if (Link->Item[I_PARTNER])
									{
										if (Game->Counter[CR_PCOSTUME] == PCOSTUME_BIG_MANHANDLA) Screen->FastTile(2,128+Partner[FOLLOW_X],Partner[FOLLOW_Y],MANHANDLA_MIDDLE_TILE,6,128);
										else
										{
											if (Partner[FOLLOW_DIR] == DIR_UP) Screen->FastCombo(2,128+Partner[FOLLOW_X],Partner[FOLLOW_Y],PARTNER_COMBO+Partner[FOLLOW_ACTION],6,128);
											else if (Partner[FOLLOW_DIR] == DIR_DOWN) Screen->FastCombo(2,128+Partner[FOLLOW_X],Partner[FOLLOW_Y],PARTNER_COMBO+Partner[FOLLOW_ACTION]+1,6,128);
											else if (Partner[FOLLOW_DIR] == DIR_LEFT) Screen->FastCombo(2,128+Partner[FOLLOW_X],Partner[FOLLOW_Y],PARTNER_COMBO+Partner[FOLLOW_ACTION]+2,6,128);
											else if (Partner[FOLLOW_DIR] == DIR_RIGHT) Screen->FastCombo(2,128+Partner[FOLLOW_X],Partner[FOLLOW_Y],PARTNER_COMBO+Partner[FOLLOW_ACTION]+3,6,128);
										}
									}
								}
							}
						}
					}
				}
	
				// Draw Link:
				if (!Link->Item[I_CURSEDPICTOBOX] || Game->Counter[CR_WEATHER] != ENV_SKEW || Game->GetCurDMap() == DMAP_FISHING || Game->GetCurDMap() == DMAP_FISHING_D)
				{
					if (Link->Action != LA_SCROLLING || Game->GetCurDMap() < DMAP_CAVES)
					{
						if (Game->Counter[CR_WEATHER] == ENV_BLOCKY)
						{
							if (Game->Counter[CR_COSTUME] != COSTUME_INVISIBLE)
							{
								if (Game->Counter[CR_COSTUME] % 2 == 0)
								{
									if (Game->Counter[CR_LINKSTUN] > 0 || Link->Action == LA_GOTHURTLAND || Link->Action == LA_DROWNING) Screen->FastTile(2,128+Link->X+Link->DrawXOffset,Link->Y+Link->DrawYOffset-Link->Z,TILE_SOLID_DARK,Choose(6,7,8,9),128);
									else
									{
										if (Game->Counter[CR_COSTUME] == 0) Screen->FastTile(2,128+Link->X+Link->DrawXOffset,Link->Y+Link->DrawYOffset-Link->Z,TILE_SOLID_DARK,6,128);
										else Screen->FastTile(2,128+Link->X+Link->DrawXOffset,Link->Y+Link->DrawYOffset-Link->Z,TILE_SOLID_DARK,Game->Counter[CR_COSTUME]%16,128);
									}
								}
								else
								{
									if (Game->Counter[CR_COSTUME] == 1)
									{
										if (Game->Counter[CR_LINKSTUN] > 0 || Link->Action == LA_GOTHURTLAND || Link->Action == LA_DROWNING) Screen->FastCombo(2,128+Link->X+Link->DrawXOffset,Link->Y+Link->DrawYOffset-Link->Z,COMBO_COMBATTANKSPIN,6,128);
										else
										{
											if (Link->Dir == DIR_UP) Screen->FastTile(2,128+Link->X+Link->DrawXOffset,Link->Y+Link->DrawYOffset-Link->Z,TILE_COMBATTANK,6,128);
											else if (Link->Dir == DIR_DOWN) Screen->FastTile(2,128+Link->X+Link->DrawXOffset,Link->Y+Link->DrawYOffset-Link->Z,TILE_COMBATTANK+1,6,128);
											else if (Link->Dir == DIR_LEFT) Screen->FastTile(2,128+Link->X+Link->DrawXOffset,Link->Y+Link->DrawYOffset-Link->Z,TILE_COMBATTANK+2,6,128);
											else if (Link->Dir == DIR_RIGHT) Screen->FastTile(2,128+Link->X+Link->DrawXOffset,Link->Y+Link->DrawYOffset-Link->Z,TILE_COMBATTANK+3,6,128);
										}
									}
									else
									{
										if (Game->Counter[CR_LINKSTUN] > 0 || Link->Action == LA_GOTHURTLAND || Link->Action == LA_DROWNING) Screen->FastCombo(2,128+Link->X+Link->DrawXOffset,Link->Y+Link->DrawYOffset-Link->Z,COMBO_COMBATTANKSPIN,Game->Counter[CR_COSTUME]%12,128);
										else
										{
											if (Link->Dir == DIR_UP) Screen->FastTile(2,128+Link->X+Link->DrawXOffset,Link->Y+Link->DrawYOffset-Link->Z,TILE_COMBATTANK,Game->Counter[CR_COSTUME]%12,128);
											else if (Link->Dir == DIR_DOWN) Screen->FastTile(2,128+Link->X+Link->DrawXOffset,Link->Y+Link->DrawYOffset-Link->Z,TILE_COMBATTANK+1,Game->Counter[CR_COSTUME]%12,128);
											else if (Link->Dir == DIR_LEFT) Screen->FastTile(2,128+Link->X+Link->DrawXOffset,Link->Y+Link->DrawYOffset-Link->Z,TILE_COMBATTANK+2,Game->Counter[CR_COSTUME]%12,128);
											else if (Link->Dir == DIR_RIGHT) Screen->FastTile(2,128+Link->X+Link->DrawXOffset,Link->Y+Link->DrawYOffset-Link->Z,TILE_COMBATTANK+3,Game->Counter[CR_COSTUME]%12,128);
										}
									}
								}
							}
						}
						else
						{
							if (Game->Counter[CR_LINKSTUN] > 0 || Link->Action == LA_GOTHURTLAND || Link->Action == LA_DROWNING) Screen->FastTile(2,128+Link->X+Link->DrawXOffset,Link->Y+Link->DrawYOffset-Link->Z,Link->Tile,Choose(6,7,8,9),128);
							else Screen->FastTile(2,128+Link->X+Link->DrawXOffset,Link->Y+Link->DrawYOffset-Link->Z,Link->Tile,6,128);
						}
					}
				}

				// Draw hiding Shellmet
				if (Link->Item[I_SHELLMET])
				{
					if (DoDraw)
					{
						if (StoodStill >= 120)
						{
							if (Game->Counter[CR_WEATHER] != ENV_BLOCKY) Screen->FastTile(2, 128+Link->X, Link->Y - Link->Z - Link->DrawYOffset - 3, SHELLMET_TILE,6,128);
						}
					}
				}

				// Draw Horse in Confusing Item GFX mode
				if (Link->Item[I_ITEMSGFX] && Game->Counter[CR_WEATHER] != ENV_BLOCKY && DoDraw)
				{
					if (!Link->Item[I_CURSEDPICTOBOX] || Game->Counter[CR_WEATHER] != ENV_SKEW)
					{
						if (GetEquipmentB() == I_PEGASUS || GetEquipmentA() == I_PEGASUS || PegasusTimer != 0)
						{
							if (Link->Dir == DIR_UP)
							{
								if (Link->Action == LA_WALKING)
								{
									 Screen->DrawCombo(
									3,
									128+Link->X,
									Link->Y-16-Link->Z,
									COMBO_HORSE+4,
									1,
									2,
									6,
									-1,
									-1,
									0,
									0,
									0,
									FLIP_NONE,
									FLIP_NONE,
									true,
									128);
								}
		
								else
								{
									Screen->DrawCombo(
									3,
									128+Link->X,
									Link->Y-16-Link->Z,
									COMBO_HORSE,
									1,
									2,
									6,
									-1,
									-1,
									0,
									0,
									0,
									FLIP_NONE,
									FLIP_NONE,
									true,
									128);
								}
							}
							else if (Link->Dir == DIR_DOWN)
							{
								if (Link->Action == LA_WALKING)
								{
									Screen->DrawCombo(
									3,
									128+Link->X,
									Link->Y-16-Link->Z,
									COMBO_HORSE+5,
									1,
									2,
									6,
									-1,
									-1,
									0,
									0,
									0,
									FLIP_NONE,
									FLIP_NONE,
									true,
									128);	
								}
		
								else
								{
									Screen->DrawCombo(
									3,
									128+Link->X,
									Link->Y-16-Link->Z,
									COMBO_HORSE+1,
									1,
									2,
									6,
									-1,
									-1,
									0,
									0,
									0,
									FLIP_NONE,
									FLIP_NONE,
									true,
									128);
								}
							}
							else if (Link->Dir == DIR_LEFT)
							{
								if (Link->Action == LA_WALKING)
								{
									{
										Screen->DrawCombo(
										3,
										118+Link->X,
										Link->Y-16-Link->Z,
										COMBO_HORSE+8,
										1,
										2,
										6,
										-1,
										-1,
										0,
										0,
										0,
										FLIP_NONE,
										FLIP_NONE,
										true,
										128);
			
										Screen->DrawCombo(
										3,
										134+Link->X,
										Link->Y-16-Link->Z,
										COMBO_HORSE+9,
										1,
										2,
										6,
										-1,
										-1,
										0,
										0,
										0,
										FLIP_NONE,
										FLIP_NONE,
										true,
										128);
									}
								}
		
								else
								{
									Screen->DrawCombo(
									3,
									119+Link->X,
									Link->Y-16-Link->Z,
									COMBO_HORSE+2,
									2,
									2,
									6,
									-1,
									-1,
									0,
									0,
									0,
									FLIP_NONE,
									FLIP_NONE,
									true,
									128);
								}
							}
							else if (Link->Dir == DIR_RIGHT)
							{
		
								if (Link->Action == LA_WALKING)
								{
									Screen->DrawCombo(
									3,
									122+Link->X,
									Link->Y-16-Link->Z,
									COMBO_HORSE+10,
									1,
									2,
									6,
									-1,
									-1,
									0,
									0,
									0,
									FLIP_NONE,
									FLIP_NONE,
									true,
									128);
		
									Screen->DrawCombo(
									3,
									138+Link->X,
									Link->Y-16-Link->Z,
									COMBO_HORSE+11,
									1,
									2,
									6,
									-1,
									-1,
									0,
									0,
									0,
									FLIP_NONE,
									FLIP_NONE,
									true,
									128);
								}
								else
								{
									Screen->DrawCombo(
									3,
									121+Link->X,
									Link->Y-16-Link->Z,
									COMBO_HORSE+3,
									2,
									2,
									6,
									-1,
									-1,
									0,
									0,
									0,
									FLIP_NONE,
									FLIP_NONE,
									true,
									128);
								}
							}
						}
					}
				}	
			
				// Causes Link's held items to be drawn:
				if (Game->Counter[CR_WEATHER] != ENV_BLOCKY)
				{
					if (Link->Action == LA_HOLD1LAND || Link->Action == LA_HOLD2LAND || Link->Action == LA_HOLD1WATER || Link->Action == LA_HOLD2WATER)
					{
						if (!ShowHeldItem)
						{
							FakeItem = CreateItemAt(Link->HeldItem,Link->X,Link->Y-16);  
							FakeItem->Pickup = IP_DUMMY;
							ShowHeldItem = true;
						}
					}
					else if (ShowHeldItem)
					{
						Remove(FakeItem);
						ShowHeldItem = false;
					}
				}


				// Draw NPCs:
				
				if (RememberStuff[REMEMBER_GLEEOK_ID] >= 0) 
				{
					Screen->DrawTile(
					2,
					128+RememberStuff[REMEMBER_GLEEOK_X]-8,				//start X
					RememberStuff[REMEMBER_GLEEOK_Y]-24,					//start y
					TILE_GLEEOK,					//tile ID
					2,						//tile width
					2,						//tile width
					RememberStuff[REMEMBER_GLEEOK_CSET],					//tile cset
					-1,-1,-1,-1,0,0,1,128);
				}
				RememberStuff[REMEMBER_GLEEOK_ID] = -1;
				for(ForTimer = Screen->NumNPCs(); ForTimer > 0; --ForTimer)
				{
					randoNPC = Screen->LoadNPC(ForTimer);
					if(!randoNPC->isValid()) continue;
					{
						if (randoNPC->Tile > 0) 
						{
							if (randoNPC->X > -(15*randoNPC->TileWidth) && randoNPC->X < 256)
							{
								if (randoNPC->ID == NPC_GIBO1 || randoNPC->ID == NPC_GIBO2)
								{
								// Draws the Big Gibo in the special environment modes (this section is only relevant to NPC_GIBO enemies):
									if (Game->Counter[CR_WEATHER] == ENV_BLOCKY) Screen->FastTile(2,128+randoNPC->Misc[MISC_GIBOX],randoNPC->Misc[MISC_GIBOY],TILE_SOLID_DARK,randoNPC->CSet,128);
									else if (randoNPC->X > randoNPC->Misc[MISC_GIBOX]-1)
									{			

										if (randoNPC->Rate < 24) Screen->DrawTile(
										2,
										128+randoNPC->Misc[MISC_GIBOX]-8,	//start X
										randoNPC->Misc[MISC_GIBOY]-8,		//start y
										randoNPC->OriginalTile + 20,		//tile ID
										2,					//tile width
										2,					//tile width
										randoNPC->CSet,				//tile cset
										-1,-1,-1,-1,0,FLIP_NONE,1,128);

										else Screen->DrawTile(
										2,
										128+randoNPC->Misc[MISC_GIBOX]-8,	//start X
										randoNPC->Misc[MISC_GIBOY]-8,		//start y
										randoNPC->OriginalTile + 22,		//tile ID
										2,					//tile width
										2,					//tile width
										randoNPC->CSet,				//tile cset
										-1,-1,-1,-1,0,FLIP_NONE,1,128);
									}
									else
									{
										if (randoNPC->Rate < 24) Screen->DrawTile(
										2,
										128+randoNPC->Misc[MISC_GIBOX]-8,	//start X
										randoNPC->Misc[MISC_GIBOY]-8,		//start y
										randoNPC->OriginalTile + 60,		//tile ID
										2,					//tile width
										2,					//tile width
										randoNPC->CSet,				//tile cset
										-1,-1,-1,-1,0,FLIP_NONE,1,128);
		
										else Screen->DrawTile(
										2,
										128+randoNPC->Misc[MISC_GIBOX]-8,	//start X
										randoNPC->Misc[MISC_GIBOY]-8,		//start y
										randoNPC->OriginalTile + 62,		//tile ID
										2,					//tile width
										2,					//tile width
										randoNPC->CSet,				//tile cset
										-1,-1,-1,-1,0,FLIP_NONE,1,128);
									}
								}
								// end of the Gibo mode 7 drawing section for bitmaps
	
								if (Game->Counter[CR_WEATHER] == ENV_BLOCKY)
								{
									// Dummied out square enemies
									//if (randoNPC->HitWidth > 16 || randoNPC->HitHeight > 16)
									//{
										//if (randoNPC->Type != NPCT_GUY) Screen->Rectangle(
										//	2,								//layer
										//	128+randoNPC->X + randoNPC->HitXOffset,				//start X
										//	randoNPC->Y + randoNPC->HitYOffset,				//start y
										//	128+randoNPC->X + randoNPC->HitWidth + randoNPC->HitXOffset,	//end x
										//	randoNPC->Y + randoNPC->HitHeight + randoNPC->HitYOffset,	//end y
										//	17,1,0,0,0,true,128);
										//else Screen->FastTile(
										//	2,
										//	128+randoNPC->X,
										//	randoNPC->Y-randoNPC->Z,
										//	TILE_SOLID_DARK,
										//	randoNPC->CSet,
										//	128);
									//} 
									//else Screen->FastTile(
									//	2,
									//	128+randoNPC->X+randoNPC->DrawXOffset,
									//	randoNPC->Y-randoNPC->Z+randoNPC->DrawYOffset,
									//	TILE_SOLID_DARK,
									//	randoNPC->CSet,
									//	128);
									if (randoNPC->Type == NPCT_GUY) Screen->FastTile(
										2,
										128+randoNPC->X+randoNPC->DrawXOffset,
										randoNPC->Y-randoNPC->Z+randoNPC->DrawYOffset,
										TILE_SOLID_DARK,
										randoNPC->CSet,
										128);
									else if (randoNPC->Type == NPCT_KEESE) Screen->FastCombo(
										2,
										128+randoNPC->X+randoNPC->DrawXOffset,
										randoNPC->Y-randoNPC->Z+randoNPC->DrawYOffset,
										COMBO_ADVBAT,
										randoNPC->CSet,
										128);
									else
									{
										if (randoNPC->HitHeight < 17 && randoNPC->HitWidth < 17) Screen->FastCombo(
											2,
											128+randoNPC->X+randoNPC->DrawXOffset,
											randoNPC->Y-randoNPC->Z+randoNPC->DrawYOffset,
											COMBO_GRUNDLESMALL,
											randoNPC->CSet,
											128);
										else if (randoNPC->Type == NPCT_DODONGO && randoNPC->Dir != DIR_UP && randoNPC->Dir != DIR_DOWN)
											Screen->DrawCombo(
											2,
											112+randoNPC->X+randoNPC->DrawXOffset,
											randoNPC->Y-randoNPC->Z+randoNPC->DrawYOffset,
											COMBO_GRUNDLE,
											1,
											2,
											randoNPC->CSet,
											randoNPC->HitWidth,
											randoNPC->HitHeight,
											0,
											0,
											0,
											FLIP_NONE,
											FLIP_NONE,
											true,
											128);
										else Screen->DrawCombo(
											2,
											128+randoNPC->X+randoNPC->DrawXOffset,
											randoNPC->Y-randoNPC->Z+randoNPC->DrawYOffset,
											COMBO_GRUNDLE,
											1,
											2,
											randoNPC->CSet,
											randoNPC->HitWidth,
											randoNPC->HitHeight,
											0,
											0,
											0,
											FLIP_NONE,
											FLIP_NONE,
											true,
											128);

									}
								}
								else
								{	
									if (randoNPC->Misc[MISC_NPCSPAWN] >= 24)
									{
										if (randoNPC->Type == NPCT_GLEEOK)
										{
											if (randoNPC->Tile == TILE_GLEEOKNECK)
											{
												if (RememberStuff[REMEMBER_GLEEOK_ID] < 0) RememberStuff[REMEMBER_GLEEOK_ID] = ForTimer;
												else 
												{
													Screen->DrawTile(
													2,
													128+RememberStuff[REMEMBER_GLEEOK_X]-8,				//start X
													RememberStuff[REMEMBER_GLEEOK_Y]-24,					//start y
													TILE_GLEEOK,					//tile ID
													2,						//tile width
													2,						//tile width
													RememberStuff[REMEMBER_GLEEOK_CSET],					//tile cset
													-1,-1,-1,-1,0,0,1,128);
												}
												
												RememberStuff[REMEMBER_GLEEOK_X] = randoNPC->X;
												RememberStuff[REMEMBER_GLEEOK_Y] = randoNPC->Y;
												RememberStuff[REMEMBER_GLEEOK_CSET] = randoNPC->CSet;
												
											}
											else
											{
												int angle = Angle(RememberStuff[REMEMBER_GLEEOK_X], RememberStuff[REMEMBER_GLEEOK_Y], randoNPC->X, randoNPC->Y);
												int dist = Distance(RememberStuff[REMEMBER_GLEEOK_X], RememberStuff[REMEMBER_GLEEOK_Y], randoNPC->X, randoNPC->Y);
												for (int i = 0; i < 4; ++i)
												{
													int randx = Rand(-1, 1);
													int randy = Rand(-1, 1);
													Screen->DrawTile(
													2,
													128+RememberStuff[REMEMBER_GLEEOK_X]+VectorX((dist/4)*i, angle)+randx - ((RememberStuff[REMEMBER_GLEEOK_X]+randx+VectorX((dist/4)*i, angle))%2),					//start X
													RememberStuff[REMEMBER_GLEEOK_Y]+VectorY((dist/4)*i, angle)+randy - ((RememberStuff[REMEMBER_GLEEOK_Y]+randy+VectorY((dist/4)*i, angle))%2),					//start y
													TILE_GLEEOKNECK,					//tile ID
													1,						//tile width
													1,						//tile width
													randoNPC->CSet,					//tile cset
													-1,-1,-1,-1,0,0,1,128);
												}
												Screen->DrawTile(
												2,
												128+randoNPC->X,				//start X
												randoNPC->Y,					//start y
												randoNPC->Tile,					//tile ID
												1,						//tile width
												1,						//tile width
												randoNPC->CSet,					//tile cset
												-1,-1,-1,-1,0,0,1,128);
											}
										}
										else if (randoNPC->Type == NPCT_AQUAMENTUS)
										{
											if (EverySixty < 21)
											{
												if (randoNPC->X > 119) Screen->DrawTile(
													2,
													128+randoNPC->X,				//start X
													randoNPC->Y,					//start y
													TILE_AQUAMENTUS+2,				//tile ID
													2,						//tile width
													2,						//tile width
													randoNPC->CSet,					//tile cset
													-1,-1,-1,-1,0,0,1,128);
	
												else Screen->DrawTile(
													2,
													128+randoNPC->X-16,				//start X
													randoNPC->Y,					//start y
													TILE_AQUAMENTUS+2,				//tile ID
													2,						//tile width
													2,						//tile width
													randoNPC->CSet,					//tile cset
													-1,-1,-1,-1,0,FLIP_HORIZONTAL,1,128);
											}
											else
											{
												if (randoNPC->X > 119) Screen->DrawTile(
													2,
													128+randoNPC->X,				//start X
													randoNPC->Y,					//start y
													TILE_AQUAMENTUS,				//tile ID
													2,						//tile width
													2,						//tile width
													randoNPC->CSet,					//tile cset
													-1,-1,-1,-1,0,0,1,128);
	
												else Screen->DrawTile(
													2,
													128+randoNPC->X-16,				//start X
													randoNPC->Y,					//start y
													TILE_AQUAMENTUS,				//tile ID
													2,						//tile width
													2,						//tile width
													randoNPC->CSet,					//tile cset
													-1,-1,-1,-1,0,FLIP_HORIZONTAL,1,128);
											}
										}
										else if (randoNPC->ID == NPC_FIRE)
										{
											Screen->DrawTile(
											2,
											128+randoNPC->X+randoNPC->DrawXOffset,		//start X
											randoNPC->Y-randoNPC->Z+randoNPC->DrawYOffset,	//start y
											randoNPC->Tile,					//tile ID
											randoNPC->TileWidth,				//tile width
											randoNPC->TileHeight,				//tile width
											randoNPC->CSet,					//tile cset
											-1,-1,-1,-1,0,Choose(FLIP_NONE,FLIP_HORIZONTAL),1,128);
										}
										else if (randoNPC->ID == NPC_ROCK) Screen->FastTile(2,128+randoNPC->X,randoNPC->Y,TILE_ROCK+(Choose(0,1)),randoNPC->CSet,128);
										else if (randoNPC->Type == NPCT_GOHMA)
										{
											Screen->FastTile(
											2,
											128+randoNPC->X+randoNPC->DrawXOffset,		//start X
											randoNPC->Y-randoNPC->Z+randoNPC->DrawYOffset,	//start y
											randoNPC->Tile,					//tile ID
											randoNPC->CSet,					//CSet
											128);					//Opacity
											if (randoNPC->HP > 0)
											{
												if (EverySixty < 31)
												{
													Screen->FastTile(
													2,
													128+randoNPC->X+randoNPC->DrawXOffset-16,	//start X
													randoNPC->Y-randoNPC->Z+randoNPC->DrawYOffset,	//start y
													TILE_GOHMALEGS,					//tile ID
													randoNPC->CSet,					//CSet
													128);
													Screen->FastTile(
													2,
													128+randoNPC->X+randoNPC->DrawXOffset+16,	//start X
													randoNPC->Y-randoNPC->Z+randoNPC->DrawYOffset,	//start y
													TILE_GOHMALEGS+2,				//tile ID
													randoNPC->CSet,					//CSet
													128);
												}
												else
												{
													Screen->FastTile(
													2,
													128+randoNPC->X+randoNPC->DrawXOffset-16,	//start X
													randoNPC->Y-randoNPC->Z+randoNPC->DrawYOffset,	//start y
													TILE_GOHMALEGS+3,					//tile ID
													randoNPC->CSet,					//CSet
													128);
													Screen->FastTile(
													2,
													128+randoNPC->X+randoNPC->DrawXOffset+16,	//start X
													randoNPC->Y-randoNPC->Z+randoNPC->DrawYOffset,	//start y
													TILE_GOHMALEGS+5,				//tile ID
													randoNPC->CSet,					//CSet
													128);
												}
											}
										}
										else if (randoNPC->Type == NPCT_GANON)
										{
											Screen->DrawTile(
											2,
											128+randoNPC->X+randoNPC->DrawXOffset,		//start X
											randoNPC->Y-randoNPC->Z+randoNPC->DrawYOffset,	//start y
											randoNPC->Tile,					//tile ID
											2,						//tile width
											2,						//tile width
											randoNPC->CSet,					//tile cset
											-1,-1,-1,-1,0,0,1,128);
										}
										else if (randoNPC->ID == 203)
										{
											Screen->DrawTile(
											2,
											128+randoNPC->X+randoNPC->DrawXOffset,		//start X
											randoNPC->Y-randoNPC->Z,			//start y
											randoNPC->Tile,					//tile ID
											1,						//tile width
											1,						//tile width
											randoNPC->CSet,					//tile cset
											-1,-1,-1,-1,0,0,1,128);
										}
										else if (randoNPC->TileWidth != 1 || randoNPC->HitWidth < 17 || randoNPC->Type == NPCT_GUY)
										Screen->DrawTile(
										2,
										128+randoNPC->X+randoNPC->DrawXOffset,		//start X
										randoNPC->Y-randoNPC->Z+randoNPC->DrawYOffset-randoNPC->DrawZOffset,	//start y
										randoNPC->Tile,					//tile ID
										randoNPC->TileWidth,				//tile width
										randoNPC->TileHeight,				//tile width
										randoNPC->CSet,					//tile cset
										-1,-1,-1,-1,0,0,1,128);

										else if (randoNPC->HitWidth > 16 && randoNPC->HitHeight <17)
										{
											if (randoNPC->Type == NPCT_DODONGO)
											{																				Screen->DrawTile(
												2,
												128+randoNPC->X+randoNPC->DrawXOffset-16,	//start X
												randoNPC->Y-randoNPC->Z+randoNPC->DrawYOffset,	//start y
												randoNPC->Tile,					//tile ID
												2,						//tile width
												randoNPC->TileHeight,				//tile width
												randoNPC->CSet,					//tile cset
												-1,-1,-1,-1,0,0,1,128);										
											}
											else
											Screen->DrawTile(
											2,
											128+randoNPC->X+randoNPC->DrawXOffset,		//start X
											randoNPC->Y-randoNPC->Z+randoNPC->DrawYOffset,	//start y
											randoNPC->Tile,					//tile ID
											2,						//tile width
											randoNPC->TileHeight,				//tile width
											randoNPC->CSet,					//tile cset
											-1,-1,-1,-1,0,0,1,128);
										}
	
										else if (randoNPC->HitWidth < 17 && randoNPC->HitHeight > 16)
										Screen->DrawTile(
										2,
										128+randoNPC->X+randoNPC->DrawXOffset,		//start X
										randoNPC->Y-randoNPC->Z+randoNPC->DrawYOffset,	//start y
										randoNPC->Tile,					//tile ID
										randoNPC->TileWidth,				//tile width
										2,						//tile width
										randoNPC->CSet,					//tile cset
										-1,-1,-1,-1,0,0,1,128);
	
										else
										Screen->DrawTile(
										2,
										128+randoNPC->X+randoNPC->DrawXOffset,		//start X
										randoNPC->Y-randoNPC->Z+randoNPC->DrawYOffset-randoNPC->DrawZOffset,	//start y
										randoNPC->Tile,					//tile ID
										2,						//tile width
										2,						//tile width
										randoNPC->CSet,					//tile cset
										-1,-1,-1,-1,0,0,1,128);
									}
									else
									{
										if (ModeMenu[MODEMENU_ON] == 0)
										{
											if (randoNPC->Misc[MISC_NPCSPAWN] == 0)
											{
												lweapon DrawSpawnSparkle = CreateLWeaponAt(LW_SPARKLE,randoNPC->X,randoNPC->Y);
												if (DrawSpawnSparkle->isValid())
												{
													if (DrawSpawnSparkle->ID == LW_SPARKLE) DrawSpawnSparkle->UseSprite(SP_SPAWN);
												}
											}
										}
										++randoNPC->Misc[MISC_NPCSPAWN];
									}
								}
								// --- Draw NPC HP for See enemy HP effect (Hero's Charm)
								if (Link->Item[I_HEROCHARM])
								{
									if (randoNPC->Type != NPCT_GUY)
									{
										if (randoNPC->ID != NPC_PATRA_REVERSE_EYE && randoNPC->ID != NPC_MOLDORM_GROW_TAIL1 && randoNPC->ID != NPC_MOLDORM_GROW_TAIL2 && randoNPC->ID != NPC_LANMOLA_GROW_TAIL1 && randoNPC->ID != NPC_LANMOLA_GROW_TAIL2)
										{
											if (randoNPC->HP-randoNPC->Misc[MISC_HP_REDUCE] >= 0)
											{
												if (randoNPC->HP < 900 || randoNPC->Type != NPCT_GLEEOK)
												{
													if (Game->Counter[CR_WEATHER] != ENV_BLOCKY)
													{
														if (randoNPC->Misc[MISC_SHOWHPTIMER] > 0)
														{
															-- randoNPC->Misc[MISC_SHOWHPTIMER];

															//shadow:
															Screen->DrawInteger(
															2,								//int layer, 
															128+randoNPC->X+1,						//int x, 
															randoNPC->Y-8 - randoNPC->Z + randoNPC->DrawYOffset,		//int y, 
															FONT_Z1,							//int font, 
															17,								//int color, 
															-1,								//int background_color, 
															-1,								//int width, 
															-1,								//int height, 
															randoNPC->HP -randoNPC->Misc[MISC_HP_REDUCE],			//int number, 
															0, 								//int number_decimal_places, 
															128);								//int opacity
															//White numbeR:
															Screen->DrawInteger(
															2,								//int layer, 
															128+randoNPC->X,						//int x, 
															randoNPC->Y-9 - randoNPC->Z + randoNPC->DrawYOffset,		//int y, 
															FONT_Z1,							//int font, 
															1,								//int color, 
															-1,								//int background_color, 
															-1,								//int width, 
															-1,								//int height, 
															randoNPC->HP -randoNPC->Misc[MISC_HP_REDUCE],			//int number, 
															0, 								//int number_decimal_places, 
															128);								//int opacity
														}
													}
													else
													{
														Screen->DrawInteger(
														2,								//int layer, 
														128+randoNPC->X+1,						//int x, 
														//randoNPC->Y+1 - randoNPC->Z + randoNPC->DrawYOffset,		//int y, 
														randoNPC->Y-16 - randoNPC->Z + randoNPC->DrawYOffset,		//int y, 
														FONT_Z3SMALL,							//int font, 
														1,								//int color, 
														-1,								//int background_color, 
														16,								//int width, 
														16,								//int height, 
														randoNPC->HP -randoNPC->Misc[MISC_HP_REDUCE],			//int number, 
														0, 								//int number_decimal_places, 
														128);								//int opacity
													}
												}
											}
										}	
									}
								}
							}
						}
					}
				}
				

				// Draw EWeapons:
				for(ForTimer = Screen->NumEWeapons(); ForTimer > 0; --ForTimer)
				{
					randoEW = Screen->LoadEWeapon(ForTimer);
					if(!randoEW->isValid()) continue;
					{
						if (Game->Counter[CR_WEATHER] == ENV_BLOCKY)
						{
							if (randoEW->ID == EW_BOMBBLAST || randoEW->ID == EW_SBOMBBLAST)
							{
								Screen->Rectangle(
									2,	//layer
									128+randoEW->X-16,	//start X
									randoEW->Y-16,		//start y
									128+randoEW->X+32,	//end x
									randoEW->Y+32,		//end y
									Rand(176),1,0,0,0,true,128);
							}
							else Screen->FastTile(
								2,
								128+randoEW->X+randoEW->DrawXOffset,
								randoEW->Y,	
								TILE_QUARTERSOLID,
								randoEW->CSet,
								128);
						}
						else
						{
							if (randoEW->ID == EW_BOMBBLAST)
							{
								Screen->DrawCombo(
								2,
								128+randoEW->X+randoEW->DrawXOffset-16,	//start X
								randoEW->Y+randoEW->DrawYOffset-16,	//start y
								5944 + (randoEW->Tile % 3),		//tile ID
								3,					//tile width
								3,					//tile width
								randoEW->CSet,				//tile cset
								-1,-1,-1,-1,0,0,randoEW->Flip,true,128);
							}
							else if (randoEW->ID == EW_SBOMBBLAST)
							{
								Screen->DrawTile(
								2,
								128+randoEW->X+randoEW->DrawXOffset-16,	//start X
								randoEW->Y+randoEW->DrawYOffset-16,	//start y
								randoEW->Tile,				//tile ID
								randoEW->TileWidth,			//tile width
								randoEW->TileHeight,			//tile width
								randoEW->CSet,				//tile cset
								48,48,-1,-1,0,randoEW->Flip,1,128);
							}
							else if (randoEW->Tile > 0) 
							{
								if (randoEW->ID != EW_BRANG)
								{
									if (randoEW->Flip < 4)
									{
										Screen->DrawTile(
										2,
										128+randoEW->X+randoEW->DrawXOffset,	//start X
										randoEW->Y+randoEW->DrawYOffset-randoEW->Z,	//start y
										randoEW->Tile,				//tile ID
										randoEW->TileWidth,			//tile width
										randoEW->TileHeight,			//tile width
										randoEW->CSet,				//tile cset
										-1,-1,-1,-1,0,randoEW->Flip,1,128);
									}
									if (randoEW->Flip == 4)
									{
										Screen->DrawTile(
										2,
										128+randoEW->X+randoEW->DrawXOffset,	//start X
										randoEW->Y+randoEW->DrawYOffset-randoEW->Z,	//start y
										randoEW->Tile,				//tile ID
										randoEW->TileWidth,			//tile width
										randoEW->TileHeight,			//tile width
										randoEW->CSet,				//tile cset
										-1,-1,128+randoEW->X+randoEW->DrawXOffset,
										randoEW->Y+randoEW->DrawYOffset,90,0,1,128);
									}
									if (randoEW->Flip == 5)
									{
										Screen->DrawTile(
										2,
										128+randoEW->X+randoEW->DrawXOffset,	//start X
										randoEW->Y+randoEW->DrawYOffset-randoEW->Z,	//start y
										randoEW->Tile,				//tile ID
										randoEW->TileWidth,			//tile width
										randoEW->TileHeight,			//tile width
										randoEW->CSet,				//tile cset
										-1,-1,128+randoEW->X+randoEW->DrawXOffset,
										randoEW->Y+randoEW->DrawYOffset,90,1,1,128);
									}
									if (randoEW->Flip == 6)
									{
										Screen->DrawTile(
										2,
										128+randoEW->X+randoEW->DrawXOffset,	//start X
										randoEW->Y+randoEW->DrawYOffset-randoEW->Z,	//start y
										randoEW->Tile,				//tile ID
										randoEW->TileWidth,			//tile width
										randoEW->TileHeight,			//tile width
										randoEW->CSet,				//tile cset
										-1,-1,128+randoEW->X+randoEW->DrawXOffset,
										randoEW->Y+randoEW->DrawYOffset,-90,0,1,128);
									}
									if (randoEW->Flip == 7)
									{
										Screen->DrawTile(
										2,
										128+randoEW->X+randoEW->DrawXOffset,	//start X
										randoEW->Y+randoEW->DrawYOffset-randoEW->Z,	//start y
										randoEW->Tile,				//tile ID
										randoEW->TileWidth,			//tile width
										randoEW->TileHeight,			//tile width
										randoEW->CSet,				//tile cset
										-1,-1,128+randoEW->X+randoEW->DrawXOffset,
										randoEW->Y+randoEW->DrawYOffset,-90,1,1,128);
									}
								}
								else
								{
									Screen->DrawTile(
										2,
										128+randoEW->X+randoEW->DrawXOffset,	//start X
										randoEW->Y-randoEW->Z,			//start y
										randoEW->Tile,				//tile ID
										randoEW->TileWidth,			//tile width
										randoEW->TileHeight,			//tile width
										Choose(6, 7, 8, 9),				//tile cset
										-1,-1,-1,-1,0,randoEW->Flip,1,128);
								}
							}
						}
					}
				}
				

				// Draw Items:
				for(ForTimer = Screen->NumItems(); ForTimer > 0; --ForTimer)
				{
					randoitem = Screen->LoadItem(ForTimer);
					if(!randoitem->isValid()) continue;
					{
						if (Game->Counter[CR_WEATHER] == ENV_BLOCKY)
						{
							if (randoitem->ID == I_KEY) Screen->FastTile(2,128+randoitem->X,randoitem->Y-randoitem->Z,TILE_BLOCKYKEY,randoitem->CSet,128);
							else if (randoitem->OriginalTile == ORIGTILE_RUPY) Screen->FastTile(2,128+randoitem->X,randoitem->Y-randoitem->Z,TILE_BLOCKYRUPY,randoitem->CSet,128);
							else if (randoitem->OriginalTile == ORIGTILE_RUPYOTHER) Screen->FastTile(2,128+randoitem->X,randoitem->Y-randoitem->Z,TILE_BLOCKYRUPY,randoitem->CSet,128);
							else if (randoitem->OriginalTile == ORIGTILE_HEART) Screen->FastTile(2,128+randoitem->X,randoitem->Y-randoitem->Z,TILE_BLOCKYHEART,randoitem->CSet,128);
							else if (randoitem->OriginalTile == ORIGTILE_MAGICKEY) Screen->FastTile(2,128+randoitem->X,randoitem->Y-randoitem->Z,TILE_BLOCKYKEY2,randoitem->CSet,128);
							else if (randoitem->ID == I_TRIFORCE) Screen->FastTile(2,128+randoitem->X,randoitem->Y-randoitem->Z,TILE_ADVGRAIL,Rand(11),128);
							else if (randoitem->OriginalTile == ORIGTILE_HEARTCONTAINER || randoitem->OriginalTile == ORIGTILE_HALFHEART) Screen->FastTile(2,128+randoitem->X,randoitem->Y-randoitem->Z,TILE_BLOCKYHEART,Choose(6,7,8,9),128);
							else Screen->FastTile(2,128+randoitem->X,randoitem->Y-randoitem->Z,TILE_BLOCKYCHEST,randoitem->CSet,128);
							//else Screen->FastTile(2,128+randoitem->X,randoitem->Y-randoitem->Z,TILE_QUARTERSOLID,randoitem->CSet,128);
						}
						else Screen->FastTile(2,128+randoitem->X,randoitem->Y-randoitem->Z+randoitem->DrawYOffset,randoitem->Tile,randoitem->CSet,128);
					}
				}
				
				// NES Dungeon walls overlap Link and partner:
				if (Game->Counter[CR_WEATHER] != ENV_BLOCKY)
				{
					if (Screen->ComboD[0] == COMBO_DUNGEONWALL && RememberStuff[REMEMBER_LINKPROMPT] <=0) 
					{
						if (Game->Counter[CR_WEATHER] != ENV_SKEW)
						{
							if (Screen->Flags[9]&0x0040) Screen->DrawScreen(2,WEATHER_MAP,89,128,0,0);
							else Screen->DrawScreen(2,WEATHER_MAP,WEATHER_DUNGEONWALL,128,0,0);
							
							if (Screen->Door[DOOR_UP] == D_LOCKED || Screen->Door[DOOR_UP] == D_BOSSLOCKED || Screen->Door[DOOR_UP] == D_SHUTTER || Screen->Door[DOOR_UP] == D_1WAYSHUTTER || Screen->Door[DOOR_UP] == D_OPEN || Screen->Door[DOOR_UP] == D_OPENSHUTTER || Screen->Door[DOOR_UP] == D_BOSSUNLOCKED || Screen->Door[DOOR_UP] == D_UNLOCKED)
							{
								Screen->DrawTile(2,128+112,0,
								15506,2,1,2,
								-1,-1,0,0,0,0,true,128);
							}
							if (Screen->Door[DOOR_DOWN] == D_LOCKED || Screen->Door[DOOR_DOWN] == D_BOSSLOCKED || Screen->Door[DOOR_DOWN] == D_SHUTTER || Screen->Door[DOOR_DOWN] == D_1WAYSHUTTER || Screen->Door[DOOR_DOWN] == D_OPEN || Screen->Door[DOOR_DOWN] == D_OPENSHUTTER || Screen->Door[DOOR_DOWN] == D_BOSSUNLOCKED || Screen->Door[DOOR_DOWN] == D_UNLOCKED)
							{
								Screen->DrawTile(2,128+112,160,
								15462,2,1,2,
								-1,-1,0,0,0,0,true,128);
							}
							Screen->FastCombo(2, 128+0, 64, Screen->ComboD[64], 2, OP_OPAQUE);
							Screen->FastCombo(2, 128+0, 80, Screen->ComboD[80], 2, OP_OPAQUE);
							Screen->FastCombo(2, 128+0, 96, Screen->ComboD[96], 2, OP_OPAQUE);
							Screen->FastCombo(2, 128+240, 64, Screen->ComboD[79], 2, OP_OPAQUE);
							Screen->FastCombo(2, 128+240, 80, Screen->ComboD[95], 2, OP_OPAQUE);
							Screen->FastCombo(2, 128+240, 96, Screen->ComboD[111], 2, OP_OPAQUE);
						}
						else if (Screen->Flags[9] != 0x0010)
						{
							Screen->DrawScreen(2,WEATHER_MAP,103,128,0,0);

							// Dungeon doors (Down)
							if (Screen->Door[DOOR_DOWN] == D_LOCKED)
							{
								Screen->DrawTile(2,128+112,144,
								15506,2,1,2,
								-1,-1,0,0,0,0,true,128);
								
								Screen->DrawTile(2,128+112,160,
								15406,2,1,2,
								-1,-1,0,0,0,0,true,128);
							}
							else if (Screen->Door[DOOR_DOWN] == D_BOSSLOCKED)
							{
								Screen->DrawTile(2,128+112,144,
								15506,2,1,2,
								-1,-1,0,0,0,0,true,128);
								
								Screen->DrawTile(2,128+112,160,
								15410,2,1,2,
								-1,-1,0,0,0,0,true,128);
							}
							else if (Screen->Door[DOOR_DOWN] == D_SHUTTER || Screen->Door[DOOR_DOWN] == D_1WAYSHUTTER)
							{
								Screen->DrawTile(2,128+112,144,
								15506,2,1,2,
								-1,-1,0,0,0,0,true,128);
								
								Screen->DrawTile(2,128+112,160,
								15404,2,1,2,
								-1,-1,0,0,0,0,true,128);
							}
							else if (Screen->Door[DOOR_DOWN] == D_OPEN || Screen->Door[DOOR_DOWN] == D_OPENSHUTTER || Screen->Door[DOOR_DOWN] == D_BOSSUNLOCKED || Screen->Door[DOOR_DOWN] == D_UNLOCKED)
							{
								Screen->DrawTile(2,128+112,144,
								15506,2,1,2,
								-1,-1,0,0,0,0,true,128);
							}
							else if (Screen->Door[DOOR_DOWN] == D_BOMBED)
							{
								Screen->DrawTile(2,128+112,160,
								15412,2,1,2,
								-1,-1,0,0,0,0,true,128);
							}
							else
							{
								Screen->DrawTile(2,128+112,160,
								15387,2,1,2,
								-1,-1,0,0,0,0,true,128);
							}
							if (Screen->Door[DOOR_UP] == D_LOCKED || Screen->Door[DOOR_UP] == D_BOSSLOCKED || Screen->Door[DOOR_UP] == D_SHUTTER || Screen->Door[DOOR_UP] == D_1WAYSHUTTER || Screen->Door[DOOR_UP] == D_OPEN || Screen->Door[DOOR_UP] == D_OPENSHUTTER || Screen->Door[DOOR_UP] == D_BOSSUNLOCKED || Screen->Door[DOOR_UP] == D_UNLOCKED)
							{
								Screen->DrawTile(2,128+112,0,
								15506,2,1,2,
								-1,-1,0,0,0,0,true,128);
							}
							Screen->FastCombo(2, 128+0, 64, Screen->ComboD[64], 2, OP_OPAQUE);
							Screen->FastCombo(2, 128+0, 80, Screen->ComboD[80], 2, OP_OPAQUE);
							Screen->FastCombo(2, 128+0, 96, Screen->ComboD[96], 2, OP_OPAQUE);
							Screen->FastCombo(2, 128+240, 64, Screen->ComboD[79], 2, OP_OPAQUE);
							Screen->FastCombo(2, 128+240, 80, Screen->ComboD[95], 2, OP_OPAQUE);
							Screen->FastCombo(2, 128+240, 96, Screen->ComboD[111], 2, OP_OPAQUE);
							Screen->DrawScreen(2,WEATHER_MAP,101,128,0,0);
						}
					}
				}

				Screen->SetRenderTarget(RT_BITMAP2);
				Screen->DrawBitmap(
						5, 	// int layer,
						0,	// int bitmap_id, 
						0,	// int source_x,
						0,	// int source_y,
						511,	// int source_w,
						176,	// int source_h,
						0,	// int dest_x,
						0,	// int dest_y,
						511,	// int dest_w,
						176,	// int dest_h,
						0,	// float rotation,
						true	// bool mask
						);
				Screen->SetRenderTarget(RT_BITMAP0);
				Screen->Rectangle(			
					5,	//layer
					0,	//start X
					0,	//start y
					511,	//end x
					511,	//end y
					15,1,0,0,0,true,128);
					
				int XOff = 0;
				int YOff = 0;
				
				if (Link->Item[I_CURSEDPICTOBOX])
				{
					XOff = 120 - Link->X-Link->DrawXOffset;
					YOff = 80 - Link->Y-Link->DrawYOffset;
					if (Game->GetCurDMap() == 2 || Game->GetCurDMap() >= 21 && Game->GetCurDMap() <= 24)
					{
						int str[] = "Fishing";
						int ffcfind = FindFFCRunning(Game->GetFFCScript(str));
						if (ffcfind > 0)
						{
							ffc Helper = Screen->LoadFFC(ffcfind);
							XOff = 120 - Helper->X;
							YOff = 80 - Helper->Y;
						}
					}
				}
					
				Screen->DrawBitmap(
						5, 	// int layer,
						2,	// int bitmap_id, 
						0,	// int source_x,
						0,	// int source_y,
						511,	// int source_w,
						176,	// int source_h,
						0 + XOff,	// int dest_x,
						256 + YOff,	// int dest_y,
						511,	// int dest_w,
						176,	// int dest_h,
						0,	// float rotation,
						true	// bool mask
						);

					// Prevent Atari 2600 mode from working with Pictobox
					if (Game->Counter[CR_WEATHER] == ENV_BLOCKY)
					{
						if (Game->GetCurDMap() == 0 && Game->GetCurScreen() < 128)
						{
							if (Link->Action == LA_ATTACKING || Link->Action == LA_GOTHURTLAND || Link->Action == LA_HOLD2LAND || Link->Action == LA_HOLD1LAND)
							{
								if (EverySixty < 15)
								{	
									//Green
									Screen->Rectangle(5, -128+XOff, 80+YOff, 511+XOff, 255+YOff, 8,1,0,0,0,true,128);
									Screen->Rectangle(5, -128+XOff, 432+YOff, 511+XOff, 607+YOff, 8,1,0,0,0,true,128);
									Screen->Rectangle(5, -128+XOff, 80+YOff, 127+XOff, 511+YOff, 8,1,0,0,0,true,128);
									Screen->Rectangle(5, 384+XOff, 80+YOff, 511+XOff, 511+YOff, 8,1,0,0,0,true,128);
								}
								else if (EverySixty >= 15 && EverySixty < 30)
								{
									//Blue
									Screen->Rectangle(5, -128+XOff, 80+YOff, 511+XOff, 255+YOff, 3,1,0,0,0,true,128);
									Screen->Rectangle(5, -128+XOff, 432+YOff, 511+XOff, 607+YOff, 3,1,0,0,0,true,128);
									Screen->Rectangle(5, -128+XOff, 80+YOff, 127+XOff, 511+YOff, 3,1,0,0,0,true,128);
									Screen->Rectangle(5, 384+XOff, 80+YOff, 511+XOff, 511+YOff, 3,1,0,0,0,true,128);
								}
								else if (EverySixty >= 30 && EverySixty < 45)
								{
									//Purple
									Screen->Rectangle(5, -128+XOff, 80+YOff, 511+XOff, 255+YOff, 165,1,0,0,0,true,128);
									Screen->Rectangle(5, -128+XOff, 432+YOff, 511+XOff, 607+YOff, 165,1,0,0,0,true,128);
									Screen->Rectangle(5, -128+XOff, 80+YOff, 127+XOff, 511+YOff, 165,1,0,0,0,true,128);
									Screen->Rectangle(5, 384+XOff, 80+YOff, 511+XOff, 511+YOff, 165,1,0,0,0,true,128);
								}
								else if (EverySixty >= 45)
								{
									//Red
									Screen->Rectangle(5, -128+XOff, 80+YOff, 511+XOff, 255+YOff, 12,1,0,0,0,true,128);
									Screen->Rectangle(5, -128+XOff, 432+YOff, 511+XOff, 607+YOff, 12,1,0,0,0,true,128);
									Screen->Rectangle(5, -128+XOff, 80+YOff, 127+XOff, 511+YOff, 12,1,0,0,0,true,128);
									Screen->Rectangle(5, 384+XOff, 80+YOff, 511+XOff, 511+YOff, 12,1,0,0,0,true,128);
								}
							}
							else
							{
								Screen->Rectangle(5, -128+XOff, 80+YOff, 511+XOff, 255+YOff, 2,1,0,0,0,true,128);
								Screen->Rectangle(5, -128+XOff, 432+YOff, 511+XOff, 607+YOff, 2,1,0,0,0,true,128);
								Screen->Rectangle(5, -128+XOff, 80+YOff, 127+XOff, 511+YOff, 2,1,0,0,0,true,128);
								Screen->Rectangle(5, 384+XOff, 80+YOff, 511+XOff, 511+YOff, 2,1,0,0,0,true,128);
							}
						}
						else if (Link->Action == LA_ATTACKING || Link->Action == LA_GOTHURTLAND || Link->Action == LA_HOLD2LAND || Link->Action == LA_HOLD1LAND)
						{
							if (EverySixty < 15)
							{	
								//Green
								Screen->Rectangle(5, -128+XOff, 80+YOff, 511+XOff, 255+YOff, 7,1,0,0,0,true,128);
								Screen->Rectangle(5, -128+XOff, 432+YOff, 511+XOff, 607+YOff, 7,1,0,0,0,true,128);
								Screen->Rectangle(5, -128+XOff, 80+YOff, 127+XOff, 511+YOff, 7,1,0,0,0,true,128);
								Screen->Rectangle(5, 384+XOff, 80+YOff, 511+XOff, 511+YOff, 7,1,0,0,0,true,128);
							}
							else if (EverySixty >= 15 && EverySixty < 30)
							{
								//Blue
								Screen->Rectangle(5, -128+XOff, 80+YOff, 511+XOff, 255+YOff, 9,1,0,0,0,true,128);
								Screen->Rectangle(5, -128+XOff, 432+YOff, 511+XOff, 607+YOff, 9,1,0,0,0,true,128);
								Screen->Rectangle(5, -128+XOff, 80+YOff, 127+XOff, 511+YOff, 9,1,0,0,0,true,128);
								Screen->Rectangle(5, 384+XOff, 80+YOff, 511+XOff, 511+YOff, 9,1,0,0,0,true,128);
							}
							else if (EverySixty >= 30 && EverySixty < 45)
							{
								//Gray
								Screen->Rectangle(5, -128+XOff, 80+YOff, 511+XOff, 255+YOff, 2,1,0,0,0,true,128);
								Screen->Rectangle(5, -128+XOff, 432+YOff, 511+XOff, 607+YOff, 2,1,0,0,0,true,128);
								Screen->Rectangle(5, -128+XOff, 80+YOff, 127+XOff, 511+YOff, 2,1,0,0,0,true,128);
								Screen->Rectangle(5, 384+XOff, 80+YOff, 511+XOff, 511+YOff, 2,1,0,0,0,true,128);
							}
							else if (EverySixty >= 45)
							{
								//Red
								Screen->Rectangle(5, -128+XOff, 80+YOff, 511+XOff, 255+YOff, 11,1,0,0,0,true,128);
								Screen->Rectangle(5, -128+XOff, 432+YOff, 511+XOff, 607+YOff, 11,1,0,0,0,true,128);
								Screen->Rectangle(5, -128+XOff, 80+YOff, 127+XOff, 511+YOff, 11,1,0,0,0,true,128);
								Screen->Rectangle(5, 384+XOff, 80+YOff, 511+XOff, 511+YOff, 11,1,0,0,0,true,128);
							}
						}
					}
					else
					{	
						if (Game->GetCurDMap() < DMAP_CAVES && Game->GetCurScreen() < 128)
						{
							if (Game->GetCurScreen() < 128)
							{
								if (Game->GetCurScreen() > 15)
								{
									Screen->DrawScreen(5,Game->GetCurMap(),Game->GetCurScreen()-16,128+XOff,80+YOff,0);
									if (Game->GetCurScreen() % 16 != 0) Screen->DrawScreen(5,Game->GetCurMap(),Game->GetCurScreen()-17,-128+XOff,80+YOff,0);
									else Screen->DrawScreen(5,WEATHER_MAP,WEATHER_WATER,-128+XOff,80+YOff,0);
									if (Game->GetCurScreen() % 16 != 15) Screen->DrawScreen(5,Game->GetCurMap(),Game->GetCurScreen()-15,384+XOff,80+YOff,0);
									else Screen->DrawScreen(5,WEATHER_MAP,WEATHER_WATER,384+XOff,80+YOff,0);
								}
								else
								{
									Screen->DrawScreen(5,WEATHER_MAP,WEATHER_WATER,128+XOff,80+YOff,0);
									Screen->DrawScreen(5,WEATHER_MAP,WEATHER_WATER,-128+XOff,80+YOff,0);
									Screen->DrawScreen(5,WEATHER_MAP,WEATHER_WATER,384+XOff,80+YOff,0);
								}
								if (Game->GetCurScreen() < 112)
								{
									Screen->DrawScreen(5,Game->GetCurMap(),Game->GetCurScreen()+16,128+XOff,432 + YOff,0);
									if (Game->GetCurScreen() % 16 != 0) Screen->DrawScreen(5,Game->GetCurMap(),Game->GetCurScreen()+15,-128+XOff,432 + YOff,0);
									else Screen->DrawScreen(5,WEATHER_MAP,WEATHER_WATER,-128+XOff,432+YOff,0);
									if (Game->GetCurScreen() % 16 != 15) Screen->DrawScreen(5,Game->GetCurMap(),Game->GetCurScreen()+17,384+XOff,432 + YOff,0);
									else Screen->DrawScreen(5,WEATHER_MAP,WEATHER_WATER,384+XOff,432+YOff,0);
								}
								else
								{
									Screen->DrawScreen(5,WEATHER_MAP,WEATHER_WATER,128+XOff,432 + YOff,0);
									Screen->DrawScreen(5,WEATHER_MAP,WEATHER_WATER,-128+XOff,432 + YOff,0);
									Screen->DrawScreen(5,WEATHER_MAP,WEATHER_WATER,384+XOff,432 + YOff,0);
								}
								if (Game->GetCurScreen() % 16 != 0) Screen->DrawScreen(5,Game->GetCurMap(),Game->GetCurScreen()-1,-128+XOff,256+YOff,0);
								else Screen->DrawScreen(5,WEATHER_MAP,WEATHER_WATER,-128+XOff,256+YOff,0);
								if (Game->GetCurScreen() % 16 != 15) Screen->DrawScreen(5,Game->GetCurMap(),Game->GetCurScreen()+1,384+XOff,256+YOff,0);
								else Screen->DrawScreen(5,WEATHER_MAP,WEATHER_WATER,384+XOff,256+YOff,0);
							}
							else
							{
								Screen->DrawScreen(5,WEATHER_MAP,WEATHER_ROCK,128+XOff,80+YOff,0);
								Screen->DrawScreen(5,WEATHER_MAP,WEATHER_ROCK,-128+XOff,80+YOff,0);
								Screen->DrawScreen(5,WEATHER_MAP,WEATHER_ROCK,384+XOff,80+YOff,0);
								Screen->DrawScreen(5,WEATHER_MAP,WEATHER_ROCK,128+XOff,432 + YOff,0);
								Screen->DrawScreen(5,WEATHER_MAP,WEATHER_ROCK,-128+XOff,432 + YOff,0);
								Screen->DrawScreen(5,WEATHER_MAP,WEATHER_ROCK,384+XOff,432 + YOff,0);
								Screen->DrawScreen(5,WEATHER_MAP,WEATHER_ROCK,-128+XOff,256+YOff,0);
								Screen->DrawScreen(5,WEATHER_MAP,WEATHER_ROCK,384+XOff,256+YOff,0);
							}
						}
						else if (Game->GetCurDMap() == DMAP_CAVES || Game->GetCurDMap() <= DMAP_CAVES && Game->GetCurScreen() >= 128)
						{
							int str[] = "EnvironmentHelper";
							int ffcfind = FindFFCRunning(Game->GetFFCScript(str));
							if (ffcfind > 0)
							{
								ffc Helper = Screen->LoadFFC(ffcfind);
								if ((Helper->InitD[3] & 100000b) != 0)
								{
									Screen->DrawScreen(5,WEATHER_MAP,WEATHER_ROCK,128+XOff,80+YOff,0);
									Screen->FastTile(5, 248+XOff, 240+YOff, 15596, 8, OP_OPAQUE);
								}
								else if ((Helper->InitD[3] & 00001b) != 0) Screen->DrawScreen(5,Game->GetCurMap(),Game->GetCurScreen()-16,128+XOff,80+YOff,0);
								else Screen->DrawScreen(5,WEATHER_MAP,WEATHER_ROCK,128+XOff,80+YOff,0);
								if ((Helper->InitD[3] & 10000b) != 0)
								{
									Screen->DrawScreen(5,WEATHER_MAP,WEATHER_ROCK,128+XOff,432 + YOff,0);
									if ((Helper->InitD[3] & 00010b) != 0) Screen->FastTile(5, 240+XOff, 432+YOff, 15595, 8, OP_OPAQUE);
									else Screen->FastTile(5, 248+XOff, 432+YOff, 15595, 8, OP_OPAQUE);
								}
								else if ((Helper->InitD[3] & 00010b) != 0) Screen->DrawScreen(5,Game->GetCurMap(),Game->GetCurScreen()+16,128+XOff,432 + YOff,0);
								else Screen->DrawScreen(5,WEATHER_MAP,WEATHER_ROCK,128+XOff,432 + YOff,0);
								if ((Helper->InitD[3] & 00100b) != 0) Screen->DrawScreen(5,Game->GetCurMap(),Game->GetCurScreen()-1,-128+XOff,256+YOff,0);
								else Screen->DrawScreen(5,WEATHER_MAP,WEATHER_ROCK,-128+XOff,256+YOff,0);
								if ((Helper->InitD[3] & 01000b) != 0) Screen->DrawScreen(5,Game->GetCurMap(),Game->GetCurScreen()+1,384+XOff,256+YOff,0);
								else Screen->DrawScreen(5,WEATHER_MAP,WEATHER_ROCK,384+XOff,256+YOff,0);
							}
							else
							{
								Screen->DrawScreen(5,WEATHER_MAP,WEATHER_ROCK,128+XOff,80+YOff,0);
								Screen->DrawScreen(5,WEATHER_MAP,WEATHER_ROCK,128+XOff,432 + YOff,0);
								Screen->DrawScreen(5,WEATHER_MAP,WEATHER_ROCK,-128+XOff,256+YOff,0);
								Screen->DrawScreen(5,WEATHER_MAP,WEATHER_ROCK,384+XOff,256+YOff,0);
							}
							
							
							Screen->DrawScreen(5,WEATHER_MAP,WEATHER_ROCK,-128+XOff,80+YOff,0);
							Screen->DrawScreen(5,WEATHER_MAP,WEATHER_ROCK,384+XOff,80+YOff,0);
							Screen->DrawScreen(5,WEATHER_MAP,WEATHER_ROCK,-128+XOff,432 + YOff,0);
							Screen->DrawScreen(5,WEATHER_MAP,WEATHER_ROCK,384+XOff,432 + YOff,0);
						}
						else if (Game->GetCurDMap() >= DMAP_FIRST_DUNGEON && Game->GetCurDMap() <= DMAP_LAST_DUNGEON || Game->GetCurDMap() == DMAP_FAKE_LAST || Game->GetCurDMap() == 54 || Game->GetCurDMap() == 55)
						{
							if (Game->GetCurScreen() < 128)
							{
								if (Game->GetCurDMap() <= 11 || Game->GetCurDMap() == 54 || Game->GetCurDMap() == 55)
								{
									Screen->DrawScreen(5,WEATHER_MAP,WEATHER_DUNGEON,128+XOff,80+YOff,0);
									Screen->DrawScreen(5,WEATHER_MAP,WEATHER_DUNGEON,-128+XOff,80+YOff,0);
									Screen->DrawScreen(5,WEATHER_MAP,WEATHER_DUNGEON,384+XOff,80+YOff,0);
									Screen->DrawScreen(5,WEATHER_MAP,WEATHER_DUNGEON,128+XOff,432 + YOff,0);
									Screen->DrawScreen(5,WEATHER_MAP,WEATHER_DUNGEON,-128+XOff,432 + YOff,0);
									Screen->DrawScreen(5,WEATHER_MAP,WEATHER_DUNGEON,384+XOff,432 + YOff,0);
									Screen->DrawScreen(5,WEATHER_MAP,WEATHER_DUNGEON,-128+XOff,256+YOff,0);
									Screen->DrawScreen(5,WEATHER_MAP,WEATHER_DUNGEON,384+XOff,256+YOff,0);
								}
							}
							else
							{
								Screen->DrawScreen(5,6,103,128+XOff,80+YOff,0);
								Screen->DrawScreen(5,6,119,128+XOff,432 + YOff,0);
								Screen->DrawScreen(5,6,119,-128+XOff,256+YOff,0);
								Screen->DrawScreen(5,6,119,384+XOff,256+YOff,0);
								
								
								Screen->DrawScreen(5,6,103,-128+XOff,80+YOff,0);
								Screen->DrawScreen(5,6,103,384+XOff,80+YOff,0);
								Screen->DrawScreen(5,6,119,-128+XOff,432 + YOff,0);
								Screen->DrawScreen(5,6,119,384+XOff,432 + YOff,0);
							}
						}
						else if (Game->GetCurDMap() == 2 || Game->GetCurDMap() >= 21 && Game->GetCurDMap() <= 24)
						{
							Screen->DrawScreen(5,WEATHER_MAP,93,128+XOff,80+YOff,0);
							Screen->DrawScreen(5,WEATHER_MAP,93,-128+XOff,80+YOff,0);
							Screen->DrawScreen(5,WEATHER_MAP,93,384+XOff,80+YOff,0);
							if (Game->GetCurDMap() == 2)
							{
								Screen->DrawScreen(5,WEATHER_MAP,91,128+XOff,432 + YOff,0);
								Screen->DrawScreen(5,WEATHER_MAP,92,-128+XOff,432 + YOff,0);
								Screen->DrawScreen(5,WEATHER_MAP,92,384+XOff,432 + YOff,0);
							}
							else
							{
								Screen->DrawScreen(5,WEATHER_MAP,90,128+XOff,432 + YOff,0);
								Screen->DrawScreen(5,WEATHER_MAP,90,-128+XOff,432 + YOff,0);
								Screen->DrawScreen(5,WEATHER_MAP,90,384+XOff,432 + YOff,0);
							}
							if (Game->GetCurDMap() == 2)
							{
								if (Game->GetCurScreen() != 13 && Game->GetCurScreen() != 14 && Game->GetCurScreen() != 15 && Game->GetCurScreen() != 59) Screen->DrawScreen(5,WEATHER_MAP,94,-128+XOff,256+YOff,0);
								else Screen->DrawScreen(5,WEATHER_MAP,95,-128+XOff,256+YOff,0);
								Screen->DrawScreen(5,WEATHER_MAP,95,384+XOff,256+YOff,0);
							}
							else
							{
								Screen->DrawScreen(5,6,46,-128+XOff,256+YOff,0);
								Screen->DrawScreen(5,6,46,384+XOff,256+YOff,0);
							}
						}
						else if (Game->GetCurDMap() >= 12 && Game->GetCurDMap() <= 20 || Game->GetCurDMap() == 57)
						{
						
							int str[] = "EnvironmentHelper";
							int ffcfind = FindFFCRunning(Game->GetFFCScript(str));
							if (ffcfind > 0)
							{
								ffc Helper = Screen->LoadFFC(ffcfind);
								
								if ((Helper->InitD[3] & 0001b) != 0) 
								{
									if (Game->GetCurDMap() == 57 && Screen->GetSideWarpScreen(0) > 0) Screen->DrawScreen(5,Game->GetCurMap(),Screen->GetSideWarpScreen(0)+8,128+XOff,80+YOff,0);
									else Screen->DrawScreen(5,Game->GetCurMap(),Game->GetCurScreen()-16,128+XOff,80+YOff,0);
									
									Screen->DrawScreen(5,6,119,-128+XOff,80+YOff,0);
									Screen->DrawScreen(5,6,119,384+XOff,80+YOff,0);
								}
								else 
								{
									Screen->DrawScreen(5,6,103,128+XOff,80+YOff,0);
									Screen->DrawScreen(5,6,103,-128+XOff,80+YOff,0);
									Screen->DrawScreen(5,6,103,384+XOff,80+YOff,0);
								}
								if ((Helper->InitD[3] & 0010b) != 0) 
								{
									if (Game->GetCurDMap() == 57 && (Screen->GetSideWarpScreen(1) > 0 || Game->GetCurScreen() == 105)) Screen->DrawScreen(5,Game->GetCurMap(),Screen->GetSideWarpScreen(1)+8,128+XOff,432 + YOff,0);
									else Screen->DrawScreen(5,Game->GetCurMap(),Game->GetCurScreen()+16,128+XOff,432 + YOff,0);
								}
								else Screen->DrawScreen(5,6,119,128+XOff,432 + YOff,0);
								if ((Helper->InitD[3] & 0100b) != 0) 
								{
									if (Game->GetCurScreen() == 111) Screen->DrawScreen(5,6,12,-128+XOff,256+YOff,0);
									else Screen->DrawScreen(5,Game->GetCurMap(),Game->GetCurScreen()-1,-128+XOff,256+YOff,0);
								}
								else Screen->DrawScreen(5,6,119,-128+XOff,256+YOff,0);
								if ((Helper->InitD[3] & 1000b) != 0) 
								{
									if (Game->GetCurScreen() == 12 && Game->GetCurDMap() == 57) Screen->DrawScreen(5,5,111,384+XOff,256+YOff,0);
									else Screen->DrawScreen(5,Game->GetCurMap(),Game->GetCurScreen()+1,384+XOff,256+YOff,0);
								}
								else Screen->DrawScreen(5,6,119,384+XOff,256+YOff,0);
							}
							else
							{
								Screen->DrawScreen(5,6,103,-128+XOff,80+YOff,0);
								Screen->DrawScreen(5,6,103,384+XOff,80+YOff,0);
								Screen->DrawScreen(5,6,103,128+XOff,80+YOff,0);
								Screen->DrawScreen(5,6,119,128+XOff,432 + YOff,0);
								Screen->DrawScreen(5,6,119,-128+XOff,256+YOff,0);
								Screen->DrawScreen(5,6,119,384+XOff,256+YOff,0);
							}
							
						
							Screen->DrawScreen(5,6,119,-128+XOff,432 + YOff,0);
							Screen->DrawScreen(5,6,119,384+XOff,432 + YOff,0);
						}
						// Draws partner during scrolling:
						if (Link->Action == LA_SCROLLING || RememberStuff[REMEMBER_SCROLLING] > 0)
						{
							if (Game->GetCurScreen() == Partner[FOLLOW_SCREEN] && Game->GetCurMap() == Partner[FOLLOW_MAP] || Partner[FOLLOW_STATE] == 0)
							{
								if (DoDraw)
								{
									if (Link->Action != LA_HOLD1LAND && Link->Action != LA_HOLD2LAND && Link->Action != LA_HOLD1WATER && Link->Action != LA_HOLD2WATER || Link->HeldItem != I_LTTPSBOMB)
									{
										if (Game->Counter[CR_WEATHER] == ENV_BLOCKY)
										{
											if (Link->Item[I_LTTPSBOMB]) Screen->FastTile(5,128+Partner[FOLLOW_X]+XOff,256+Partner[FOLLOW_Y]+YOff,TILE_QUARTERSOLID,8,128);
											else if (Link->Item[I_PARTNER]) Screen->FastTile(5,128+Partner[FOLLOW_X]+XOff,256+Partner[FOLLOW_Y]+YOff,TILE_SOLID_DARK,6,128);
										}
										else if (!Link->Item[I_CURSEDPICTOBOX] || Link->Action != LA_SCROLLING || Game->GetCurDMap() < DMAP_FIRST_DUNGEON)
										{
											if (Link->Item[I_LTTPSBOMB])
											{
												if(Partner[FOLLOW_STATE] == 0) Screen->FastTile(5,128+Partner[FOLLOW_X]+XOff,256+Partner[FOLLOW_Y]+YOff,LTTPSBOMB_TILE,8,128);
												else Screen->FastTile(5,128+Partner[FOLLOW_X]+XOff,256+Partner[FOLLOW_Y]+YOff,LTTPSBOMB_TILE,Choose(6,7,8,9),128);
											}
											else
											{
												if (Link->Item[I_PARTNER])
												{
													if (Game->Counter[CR_PCOSTUME] == PCOSTUME_BIG_MANHANDLA) Screen->FastTile(5,128+Partner[FOLLOW_X]+XOff,256+Partner[FOLLOW_Y]+YOff,MANHANDLA_MIDDLE_TILE,6,128);
													else
													{
														if (Partner[FOLLOW_DIR] == DIR_UP) Screen->FastCombo(5,128+Partner[FOLLOW_X]+XOff,256+Partner[FOLLOW_Y]+YOff,PARTNER_COMBO+Partner[FOLLOW_ACTION],6,128);
														else if (Partner[FOLLOW_DIR] == DIR_DOWN) Screen->FastCombo(5,128+Partner[FOLLOW_X]+XOff,256+Partner[FOLLOW_Y]+YOff,PARTNER_COMBO+Partner[FOLLOW_ACTION]+1,6,128);
														else if (Partner[FOLLOW_DIR] == DIR_LEFT) Screen->FastCombo(5,128+Partner[FOLLOW_X]+XOff,256+Partner[FOLLOW_Y]+YOff,PARTNER_COMBO+Partner[FOLLOW_ACTION]+2,6,128);
														else if (Partner[FOLLOW_DIR] == DIR_RIGHT) Screen->FastCombo(5,128+Partner[FOLLOW_X]+XOff,256+Partner[FOLLOW_Y]+YOff,PARTNER_COMBO+Partner[FOLLOW_ACTION]+3,6,128);
													}
												}
											}
										}
									}
								}
							}
				
							// Draw Link:
							if (!Link->Item[I_CURSEDPICTOBOX] || Game->Counter[CR_WEATHER] != ENV_SKEW || Game->GetCurDMap() == DMAP_FISHING || Game->GetCurDMap() == DMAP_FISHING_D)
							{
								if (Link->Action != LA_SCROLLING || Game->GetCurDMap() < DMAP_CAVES || (Game->GetCurDMap() >= DMAP_PASSAGEWAYS1 && Game->GetCurDMap() <= DMAP_PASSAGEWAYS9) || Game->GetCurDMap() == DMAP_SHAFT || Game->GetCurDMap() == DMAP_FISHING || Game->GetCurDMap() == DMAP_FISHING_D)
								{
									if (Game->Counter[CR_WEATHER] == ENV_BLOCKY)
									{
										if (Game->Counter[CR_LINKSTUN] > 0 || Link->Action == LA_GOTHURTLAND || Link->Action == LA_DROWNING) Screen->FastTile(5,128+Link->X+Link->DrawXOffset+XOff,256+Link->Y+Link->DrawYOffset-Link->Z+YOff,TILE_SOLID_DARK,Choose(6,7,8,9),128);
										else Screen->FastTile(5,128+Link->X+Link->DrawXOffset+XOff,256+Link->Y+Link->DrawYOffset-Link->Z+YOff,TILE_SOLID_DARK,6,128);
									}
									else
									{
										if (Game->Counter[CR_LINKSTUN] > 0 || Link->Action == LA_GOTHURTLAND || Link->Action == LA_DROWNING) Screen->FastTile(5,128+Link->X+Link->DrawXOffset+XOff,256+Link->Y+Link->DrawYOffset-Link->Z+YOff,Link->Tile,Choose(6,7,8,9),128);
										else Screen->FastTile(5,128+Link->X+Link->DrawXOffset+XOff,256+Link->Y+Link->DrawYOffset-Link->Z+YOff,Link->Tile,6,128);
									}
								}
							}
						}
						
						for(ForTimer = Screen->NumNPCs(); ForTimer > 0; --ForTimer)
						{
							randoNPC = Screen->LoadNPC(ForTimer);
							if(!randoNPC->isValid()) continue;
							{
								if (randoNPC->Tile > 0) 
								{
									if (randoNPC->X > -(15*randoNPC->TileWidth) && randoNPC->X < 256 && randoNPC->Y < 0)
									{
			
										if (Game->Counter[CR_WEATHER] == ENV_BLOCKY)
										{
											if (randoNPC->Type != NPCT_GUY && randoNPC->Type != NPCT_KEESE)
											{
												if (randoNPC->HitHeight < 17 && randoNPC->HitWidth < 17) Screen->FastCombo(
													2,
													128+randoNPC->X+randoNPC->DrawXOffset+XOff,
													256+randoNPC->Y-randoNPC->Z+randoNPC->DrawYOffset+YOff,
													COMBO_GRUNDLESMALL,
													randoNPC->CSet,
													128);
												
											}
										}
										else
										{	
											if (randoNPC->Misc[MISC_NPCSPAWN] >= 24)
											{
												if (randoNPC->TileWidth != 1 || randoNPC->HitWidth < 17 || randoNPC->Type == NPCT_GUY)
												Screen->DrawTile(
												5,
												128+randoNPC->X+randoNPC->DrawXOffset+XOff,		//start X
												256+randoNPC->Y-randoNPC->Z+randoNPC->DrawYOffset+YOff,	//start y
												randoNPC->Tile,					//tile ID
												randoNPC->TileWidth,				//tile width
												randoNPC->TileHeight,				//tile width
												randoNPC->CSet,					//tile cset
												-1,-1,-1,-1,0,0,1,128);
												else if (randoNPC->ID == NPC_FIRE)
												{
													Screen->DrawTile(
													5,
													128+randoNPC->X+randoNPC->DrawXOffset+XOff,		//start X
													256+randoNPC->Y-randoNPC->Z+randoNPC->DrawYOffset+YOff,	//start y
													randoNPC->Tile,					//tile ID
													randoNPC->TileWidth,				//tile width
													randoNPC->TileHeight,				//tile width
													randoNPC->CSet,					//tile cset
													-1,-1,-1,-1,0,Choose(FLIP_NONE,FLIP_HORIZONTAL),1,128);
												}
												else if (randoNPC->ID == NPC_ROCK) Screen->FastCombo(5,128+randoNPC->X+XOff,256+randoNPC->Y+YOff,TILE_ROCK+(Choose(0,1)),randoNPC->CSet,128);

			
												else if (randoNPC->Type != NPCT_GUY && randoNPC->HitWidth < 17 && randoNPC->HitHeight < 17)
												{
													Screen->DrawTile(
													5,
													128+randoNPC->X+randoNPC->DrawXOffset+XOff,		//start X
													256+randoNPC->Y-randoNPC->Z+randoNPC->DrawYOffset+YOff,	//start y
													randoNPC->Tile,					//tile ID
													2,						//tile width
													2,						//tile width
													randoNPC->CSet,					//tile cset
													-1,-1,-1,-1,0,0,1,128);
												}
											}
										}
									}
								}
							}
						}
					}
					
					if (RememberStuff[REMEMBER_LINKPROMPT] > 0)
					{
						Screen->Rectangle(5, 0, 0, 128+XOff+RememberStuff[REMEMBER_LINKPROMPT], 256+YOff ,15,1,0,0,0,true,128);
						Screen->Rectangle(5, 128+XOff+255-RememberStuff[REMEMBER_LINKPROMPT], 0+YOff, 511, 256+YOff ,15,1,0,0,0,true,128);
						Screen->Rectangle(5, 0, 0, 128+XOff, 511 ,15,1,0,0,0,true,128);
						Screen->Rectangle(5, 128+XOff+255, 0, 511, 511 ,15,1,0,0,0,true,128);
					}
					
					
				if (DoDraw)
				{
					// Draw darkness:
					if (Screen->Flags[9]&0x0040) 	//"Screen->Screen Data->Sflags 2->General Use 5 (Scripts)" checkbox.
					{
						if (!IsDark)
						{
							if (NumLWeaponsOf(LW_FIRE) == 0) IsDark = true;
						}
					}
					else if (IsDark && Link->Action != LA_SCROLLING) IsDark = false;
					if (IsDark)
					{
						if (Link->PressB)
						{
							if (GetEquipmentB() == I_CANDLE1 || GetEquipmentB() == I_CANDLE2) IsDark = false;
						}
						else if (Link->PressA)
						{
							if (GetEquipmentA() == I_CANDLE1 || GetEquipmentA() == I_CANDLE2) IsDark = false;
						}
		
						if (Link->Action == LA_SCROLLING || !Link->Item[I_LANTERN]) 
						{
							Screen->Rectangle(
							5,	//layer
							0,	//start X
							0,	//start y
							511,	//end x
							511,	//end y
							0,1,0,0,0,true,128);

							// Draw Link in the dark:
							if (!Link->Item[I_CURSEDPICTOBOX] || Game->Counter[CR_WEATHER] != ENV_SKEW)
							{
								if (Game->Counter[CR_WEATHER] == ENV_BLOCKY) Screen->FastTile(5,128+Link->X+XOff,256+Link->Y-Link->Z+YOff,TILE_SOLID_DARK,6,128);
								else Screen->FastTile(5,128+Link->X+XOff,256+Link->Y-Link->Z+YOff,Link->Tile,6,128);
							}
						}
						

	
						if (Link->Action != LA_SCROLLING && Link->Item[I_LANTERN])
						{
							if (Game->Counter[CR_WEATHER] != ENV_DARKROOM && !DoDarkDraw)
							{
								Screen->Rectangle(
								5,		//layer
								0,		//start X
								0,		//start y
								511,		//end x
								256+YOff+Link->Y-32,	//end y
								0,1,0,0,0,true,128);

								Screen->Rectangle(
								5,		//layer
								0,		//start X
								256+YOff+Link->Y+48,	//start y
								511,		//end x
								511,		//end y
								0,1,0,0,0,true,128);	
								Screen->Rectangle(
								5,		//layer
								0,		//start X
								0,		//start y
								128+(Link->X-32)+XOff,	//end x
								511,		//end y
								0,1,0,0,0,true,128);	
								Screen->Rectangle(
								5,		//layer
								128+(Link->X+48)+XOff,	//start X
								0,		//start y
								511,		//end x
								511,		//end y
								0,1,0,0,0,true,128);
									
								if (Game->Counter[CR_WEATHER] != ENV_BLOCKY) Screen->DrawTile(
								5,
								128+Link->X-32+XOff,	//start X
								256+YOff+Link->Y-32,	//start y
								LANTERN_TILE,	//tile ID
								5,		//tile width
								5,		//tile width
								0,		//tile cset
								-1,-1,-1,-1,0,0,1,128);	
							}
							else
							{
								Screen->Rectangle(
								5,		//layer
								0,		//start X
								0,		//start y
								511,		//end x
								256+YOff+Link->Y-28-VectorX(3.9, ModeMenu[WEATHER_NOISE]),	//end y
								0,1,0,0,0,true,128);

								Screen->Rectangle(
								5,		//layer
								0,		//start X
								256+YOff+Link->Y+44+VectorX(3.9, ModeMenu[WEATHER_NOISE]),	//start y
								511,		//end x
								511,		//end y
								0,1,0,0,0,true,128);	
								Screen->Rectangle(
								5,		//layer
								0,		//start X
								0,		//start y
								128+(Link->X-28)+XOff-VectorX(3.9, ModeMenu[WEATHER_NOISE]),	//end x
								511,		//end y
								0,1,0,0,0,true,128);	
								Screen->Rectangle(
								5,		//layer
								128+(Link->X+44)+XOff+VectorX(3.9, ModeMenu[WEATHER_NOISE]),	//start X
								0,		//start y
								511,		//end x
								511,		//end y
								0,1,0,0,0,true,128);
									
								if (Game->Counter[CR_WEATHER] != ENV_BLOCKY) Screen->DrawTile(
								5,
								128+Link->X-28+XOff-VectorX(3.9, ModeMenu[WEATHER_NOISE]),	//start X
								256+YOff+Link->Y-28-VectorX(3.9, ModeMenu[WEATHER_NOISE]),	//start y
								LANTERN_TILE,	//tile ID
								5,		//tile width
								5,		//tile width
								0,		//tile cset
								73+VectorX(7.8, ModeMenu[WEATHER_NOISE]),73+VectorX(7.8, ModeMenu[WEATHER_NOISE]),-1,-1,0,0,1,128);	
							}
						}
						
						for(ForTimer = Screen->NumItems(); ForTimer > 0; --ForTimer)
						{
							item RandoItem = Screen->LoadItem(ForTimer);
							if(!RandoItem->isValid()) continue;
							{
								Screen->FastTile(5,RandoItem->X+128+XOff,RandoItem->Y+256+YOff,RandoItem->Tile,RandoItem->CSet,128);
							}
						}
					}
				}

	
				Screen->SetRenderTarget(RT_SCREEN);

				// Draw an upside down screen:
				if ((Game->Counter[CR_WEATHER] == 0 || Game->Counter[CR_WEATHER] >= 7 && Game->Counter[CR_WEATHER] <= 20) && !DoDarkDraw) Screen->DrawBitmap(
					5, 	// int layer,
					0,	// int bitmap_id, 
					128,	// int source_x,
					256,	// int source_y,
					256,	// int source_w,
					176,	// int source_h,
					0,	// int dest_x,
					0,	// int dest_y,
					256,	// int dest_w,
					176,	// int dest_h,
					0,	// float rotation,
					true	// bool mask
					);
				else if (Game->Counter[CR_WEATHER] == 2) Screen->DrawBitmap(
					5, 	// int layer,
					0,	// int bitmap_id, 
					128,	// int source_x,
					256,	// int source_y,
					256,	// int source_w,
					176,	// int source_h,
					0,	// int dest_x,
					0,	// int dest_y,
					256,	// int dest_w,
					176,	// int dest_h,
					180,	// float rotation,
					true	// bool mask
					);
					
				// Draw the screen at a skewed tilt / "Mode 7"
				// This one draws everything in one squished plane.
				else if (Game->Counter[CR_WEATHER] == ENV_SKEW)
				{
					int SkewPolish = 0;
					if (Screen->ComboD[0] == COMBO_DUNGEONWALL && RememberStuff[REMEMBER_LINKPROMPT] <= 0 && !IsDark) Screen->SetRenderTarget(RT_BITMAP1);
					if (!Link->Item[I_CURSEDPICTOBOX]) for(ForTimer = 170; ForTimer > 0; --ForTimer)
					{
						if (Game->GetCurDMap() < DMAP_CAVES || Link->Item[I_CURSEDPICTOBOX])
						{
							if (ForTimer % 4 == 0 && ForTimer < 70) ++SkewPolish;
							else if (ForTimer % 3 == 0 && ForTimer < 35) ++SkewPolish;
							if (ForTimer % 4 == 0 && ForTimer > 135) --SkewPolish;
						}
						Screen->DrawBitmap(
						5, 				// int layer,
						0,				// int bitmap_id, 
						0,				// int source_x,
						256+ForTimer-SkewPolish,	// int source_y,
						511,				// int source_w,
						1+(ForTimer/28),		// int source_h,
						-16-(ForTimer),			// int dest_x,
						(-1)+ForTimer-(ForTimer/28),	// int dest_y,
						288+(ForTimer*2),		// int dest_w,
						1+(ForTimer/28),		// int dest_h,
						0,				// float rotation,
						true				// bool mask
						);
					}	
					else for(ForTimer = 170; ForTimer > 0; --ForTimer)
					{
						if (Game->GetCurDMap() < DMAP_CAVES || Link->Item[I_CURSEDPICTOBOX])
						{
							if (ForTimer % 4 == 0 && ForTimer < 70) ++SkewPolish;
							else if (ForTimer % 3 == 0 && ForTimer < 35) ++SkewPolish;
							if (ForTimer % 4 == 0 && ForTimer > 135) --SkewPolish;
						}
						Screen->DrawBitmap(
						5, 				// int layer,
						0,				// int bitmap_id, 
						0,				// int source_x,
						256-16+ForTimer-SkewPolish,	// int source_y,
						511,				// int source_w,
						1+(ForTimer/28),		// int source_h,
						-16-(ForTimer),			// int dest_x,
						(-1)+ForTimer-(ForTimer/28),	// int dest_y,
						288+(ForTimer*2),		// int dest_w,
						1+(ForTimer/28),		// int dest_h,
						0,				// float rotation,
						true				// bool mask
						);
					}
					if (Screen->ComboD[0] == COMBO_DUNGEONWALL && RememberStuff[REMEMBER_LINKPROMPT] <= 0 && !IsDark)
					{
						Screen->SetRenderTarget(RT_SCREEN);
						Screen->DrawBitmap(
							5, 				// int layer,
							1,				// int bitmap_id, 
							0,				// int source_x,
							0,				// int source_y,
							256,				// int source_w,
							176,				// int source_h,
							0,				// int dest_x,
							0,				// int dest_y,
							256,				// int dest_w,
							176,				// int dest_h,
							0,				// float rotation,
							true				// bool mask
							);
					}

					// Draws Link centered for Cursed Pictobox (in skewed mode):
					if (Link->Item[I_CURSEDPICTOBOX] && Game->GetCurDMap() != DMAP_FISHING && Game->GetCurDMap() != DMAP_FISHING_D)
					{
						if (Link->Action != LA_SCROLLING || Game->GetCurDMap() < DMAP_CAVES || (Game->GetCurDMap() >= DMAP_PASSAGEWAYS1 && Game->GetCurDMap() <= DMAP_PASSAGEWAYS9) || Game->GetCurDMap() == DMAP_SHAFT)
						{
							if (Game->Counter[CR_WEATHER] == ENV_BLOCKY)
							{
								if (Game->Counter[CR_LINKSTUN] > 0 || Link->Action == LA_GOTHURTLAND || Link->Action == LA_DROWNING) Screen->FastTile(5,121,82-Link->Z,TILE_SOLID_DARK,Choose(6,7,8,9),128);
								else Screen->FastTile(5,121,82-Link->Z,TILE_SOLID_DARK,6,128);
							}
							else
							{
								if (Game->Counter[CR_LINKSTUN] > 0 || Link->Action == LA_GOTHURTLAND || Link->Action == LA_DROWNING) Screen->FastTile(5,121,82-Link->Z,Link->Tile,Choose(6,7,8,9),128);
								else Screen->FastTile(5,121,82-Link->Z,Link->Tile,6,128);
							}
	
							// Draws the horse for the Cursed Pictobox (in skewed mode):
							if (Link->Item[I_ITEMSGFX])
							{
								if (GetEquipmentB() == I_PEGASUS || GetEquipmentA() == I_PEGASUS || PegasusTimer != 0)
								{
									if (Link->Dir == DIR_UP)
									{
										if (Link->Action == LA_WALKING)
										{
											Screen->DrawCombo(
											5,
											121,
											74-Link->Z,
											COMBO_HORSE+4,
											1,
											2,
											6,
											-1,
											-1,
											0,
											0,
											0,
											FLIP_NONE,
											FLIP_NONE,
											true,	
											128);	
										}	
										else
										{
											Screen->DrawCombo(
											5,
											121,
											74-Link->Z,
											COMBO_HORSE,
											1,
											2,
											6,
											-1,
											-1,
											0,
											0,
											0,
											FLIP_NONE,
											FLIP_NONE,
											true,
											128);
										}
									}
									else if (Link->Dir == DIR_DOWN)
									{
										if (Link->Action == LA_WALKING)
										{
											Screen->DrawCombo(
											5,
											121,
											74-Link->Z,
											COMBO_HORSE+5,
											1,
											2,
											6,
											-1,
											-1,
											0,
											0,
											0,
											FLIP_NONE,
											FLIP_NONE,
											true,
											128);
										}
										else
										{
											Screen->DrawCombo(
											5,
											121,
											74-Link->Z,
											COMBO_HORSE+1,
											1,
											2,
											6,
											-1,
											-1,
											0,
											0,
											0,
											FLIP_NONE,
											FLIP_NONE,
											true,
											128);
										}
									}
									else if (Link->Dir == DIR_LEFT)
									{
										if (Link->Action == LA_WALKING)
										{
											{
												Screen->DrawCombo(
												5,
												111,
												74-Link->Z,
												COMBO_HORSE+8,
												1,
												2,
												6,
												-1,
												-1,
												0,
												0,
												0,
												FLIP_NONE,
												FLIP_NONE,
												true,
												128);
					
												Screen->DrawCombo(
												5,
												127,
												74-Link->Z,
												COMBO_HORSE+9,
												1,
												2,
												6,
												-1,
												-1,
												0,
												0,
												0,
												FLIP_NONE,
												FLIP_NONE,
												true,
												128);
											}
										}
		
										else
										{
											Screen->DrawCombo(
											5,
											112,
											74-Link->Z,
											COMBO_HORSE+2,
											2,
											2,
											6,
											-1,
											-1,
											0,
											0,
											0,
											FLIP_NONE,
											FLIP_NONE,
											true,
											128);
										}
									}
									else if (Link->Dir == DIR_RIGHT)
									{
			
										if (Link->Action == LA_WALKING)
										{
											Screen->DrawCombo(
											5,
											115,
											74-Link->Z,
											COMBO_HORSE+10,
											1,
											2,
											6,
											-1,
											-1,
											0,
											0,
											0,
											FLIP_NONE,
											FLIP_NONE,
											true,
											128);
		
											Screen->DrawCombo(
											5,
											131,
											74-Link->Z,
											COMBO_HORSE+11,
											1,
											2,
											6,
											-1,
											-1,
											0,
											0,
											0,
											FLIP_NONE,
											FLIP_NONE,
											true,
											128);
										}
										else
										{
											Screen->DrawCombo(
											5,
											114,
											74-Link->Z,
											COMBO_HORSE+3,
											2,
											2,
											6,
											-1,
											-1,
											0,
											0,
											0,
											FLIP_NONE,
											FLIP_NONE,
											true,
											128);
										}
									}
								}
							}
						}
					}
	
					if (Screen->ComboD[0] == COMBO_DUNGEONWALL && RememberStuff[REMEMBER_LINKPROMPT] <= 0 && !IsDark)
					{
						Screen->SetRenderTarget(RT_BITMAP1);
						Screen->Rectangle(
						5,	//layer
						16+XOff,	//start X
						19+YOff,	//start y
						240+XOff,	//end x
						144+YOff,	//end y
						0,1,0,0,0,true,128); 
						Screen->Rectangle(
						5,	//layer
						0+XOff,	//start X
						163+YOff,	//start y
						256+XOff,	//end x
						176+YOff,	//end y
						0,1,0,0,0,true,128); 
						Screen->SetRenderTarget(RT_SCREEN);
						Screen->DrawBitmap(
							5, 				// int layer,
							1,				// int bitmap_id, 
							0,				// int source_x,
							0,				// int source_y,
							256,				// int source_w,
							176,				// int source_h,
							0,				// int dest_x,
							0,				// int dest_y,
							256,				// int dest_w,
							176,				// int dest_h,
							0,				// float rotation,
							true				// bool mask
							);
					}
				}

				else if (Game->Counter[CR_WEATHER] == ENV_BLOCKY)
				{
				// Draw a blocky "Atari 2600" screen:
					Screen->Rectangle(
						5,	//layer
						0,	//start X
						0,	//start y
						256,	//end x
						176,	//end y
						15,1,0,0,0,true,128); 
					Screen->DrawBitmap(
						5, 	// int layer,
						0,	// int bitmap_id, 
						128,	// int source_x,
						256,	// int source_y,
						256,	// int source_w,
						176,	// int source_h,
						0,	// int dest_x,
						0,	// int dest_y,
						256,	// int dest_w,
						176,	// int dest_h,
						0,	// float rotation,
						true	// bool mask
						);
		
					//Blocky mode HUD
					if (ModeMenu[MODEMENU_ON] == 0)
					{
						Screen->Rectangle(			
							7,	//layer
							0,	//start X
							-56,	//start y
							256,	//end x
							0,	//end y
							15,1,0,0,0,true,128);
	
						Screen->DrawInteger(
							7,					//int layer, 
							8,					//int x, 
							-24,					//int y, 
							FONT_Z3SMALL,				//int font, 
							2,					//int color, 
							-1,					//int background_color, 
							24,					//int width, 
							24,					//int height, 
							Game->GetCurScreen(),			//int number, 
							0, 					//int number_decimal_places, 
							128);					 //int opacity
	
						Screen->FastTile(7,64,-24,TILE_BLOCKYRUPY,1,128);
						Screen->DrawInteger(
							7,					//int layer, 
							80,					//int x, 
							-24,					//int y, 
							FONT_Z3SMALL,				//int font, 
							1,					//int color, 
							-1,					//int background_color, 
							24,					//int width, 
							24,					//int height, 
							Game->Counter[CR_RUPEES],		//int number, 
							0, 					//int number_decimal_places, 
							128);					 //int opacity
	
						Screen->FastTile(7,112,-24,TILE_BLOCKYKEY,1,128);
						Screen->DrawInteger(
							7,					//int layer, 
							128,					//int x, 
							-24,					//int y, 
							FONT_Z3SMALL,				//int font, 
							1,					//int color, 
							-1,					//int background_color, 
							24,					//int width, 
							24,					//int height, 
							Game->Counter[CR_KEYS],			//int number, 
							0, 					//int number_decimal_places, 
							128);					 //int opacity
	
						Screen->FastTile(7,192,-24,TILE_BLOCKYHEART,1,128);
						Screen->DrawInteger(
							7,					//int layer, 
							208,					//int x, 
							-24,					//int y, 
							FONT_Z3SMALL,				//int font, 
							1,					//int color, 
							-1,					//int background_color, 
							24,					//int width, 
							24,					//int height, 
							Game->Counter[CR_LIFE]/8,		//int number, 
							0, 					//int number_decimal_places, 
							128);					 //int opacity
					}
				}

				// Draw a half-size screen
				else if (Game->Counter[CR_WEATHER] == ENV_TINY)
				{
					Screen->Rectangle(
						5,	//layer
						0,	//start X
						0,	//start y
						256,	//end x
						256,	//end y
						15,1,0,0,0,true,128); 
					Screen->DrawBitmap(
						5, 	// int layer,
						0,	// int bitmap_id, 
						128,	// int source_x,
						256,	// int source_y,
						256,	// int source_w,
						176,	// int source_h,
						64,	// int dest_x,
						44,	// int dest_y,
						128,	// int dest_w,
						88,	// int dest_h,
						0,	// float rotation,
						true	// bool mask
						);
				}
				
				else if (Game->Counter[CR_WEATHER] == ENV_NEWWAVY1 || Game->Counter[CR_WEATHER] == ENV_NEWWAVY2 || Game->Counter[CR_WEATHER] == ENV_TRUENAUSEA)
				{
					int variance = 8;
					if (Game->Counter[CR_WEATHER] == ENV_NEWWAVY1) variance = 4;
					Screen->Rectangle(
						5,	//layer
						0,	//start X
						0,	//start y
						256,	//end x
						176,	//end y
						15,1,0,0,0,true,128); 
					Screen->SetRenderTarget(RT_BITMAP1);
					for(ForTimer = 0; ForTimer < 256 + (variance*2); ++ForTimer)
					{
						Screen->DrawBitmap(
						5, 							// int layer,
						0,							// int bitmap_id, 
						128-variance+ForTimer,						// int source_x,
						256-variance,							// int source_y,
						1,							// int source_w,
						176+(variance*2),							// int source_h,
						ForTimer,						// int dest_x,
						-variance + VectorY(variance, ModeMenu[WEATHER_NOISE] + ForTimer*4),	// int dest_y,
						1,							// int dest_w,
						176 + (variance*2),							// int dest_h,
						0,							// float rotation,
						true							// bool mask
						);
					}
					if (Game->Counter[CR_WEATHER] == ENV_TRUENAUSEA) Screen->SetRenderTarget(RT_BITMAP0);
					else Screen->SetRenderTarget(RT_SCREEN);
					for(ForTimer = 176; ForTimer > 0; --ForTimer)
					{
						Screen->DrawBitmap(
						5, 							// int layer,
						1,							// int bitmap_id, 
						0,							// int source_x,
						ForTimer,						// int source_y,
						256 + (variance*2),					// int source_w,
						1,							// int source_h,
						-variance + VectorX(variance, ModeMenu[WEATHER_NOISE] + ForTimer*4),	// int dest_x,
						ForTimer,						// int dest_y,
						256 + (variance*2),					// int dest_w,
						1,							// int dest_h,
						0,							// float rotation,
						true							// bool mask
						);
					}
					if (Game->Counter[CR_WEATHER] == ENV_TRUENAUSEA) 
					{
						Screen->SetRenderTarget(RT_SCREEN);
						Screen->DrawBitmap(
							5, 	// int layer,
							0,	// int bitmap_id, 
							0,	// int source_x,
							0,	// int source_y,
							256,	// int source_w,
							176,	// int source_h,
							0,	// int dest_x,
							0,	// int dest_y,
							256,	// int dest_w,
							176,	// int dest_h,
							(-(ModeMenu[WEATHER_NOISE]/8))%360,	// float rotation,
							true	// bool mask
							);
						Screen->DrawBitmap(
							5, 	// int layer,
							0,	// int bitmap_id, 
							0,	// int source_x,
							0,	// int source_y,
							256,	// int source_w,
							176,	// int source_h,
							0,	// int dest_x,
							0,	// int dest_y,
							256,	// int dest_w,
							176,	// int dest_h,
							ModeMenu[WEATHER_NOISE]/8,	// float rotation,
							true	// bool mask
							);
					}
					
					if (Game->Counter[CR_WEATHER] == ENV_NEWWAVY1) ++ModeMenu[WEATHER_NOISE];
					else 
					{
						if (Link->Action != LA_WALKING || !CanWalk(Link->X, Link->Y, Link->Dir, 1, false) || !Link->Item[I_CURSEDPICTOBOX]) ModeMenu[WEATHER_NOISE]+=4; 
						else if (Link->Dir == DIR_RIGHT || Link->Dir == DIR_DOWN) ModeMenu[WEATHER_NOISE]-=2; 
						else ModeMenu[WEATHER_NOISE]+=2; 
					}
					if (Game->Counter[CR_WEATHER] == ENV_TRUENAUSEA) ModeMenu[WEATHER_NOISE] %= 2880;	
					else ModeMenu[WEATHER_NOISE] %= 360;			
				}
				
				else if (Game->Counter[CR_WEATHER] == ENV_DARKROOM || DoDarkDraw)
				{
					Screen->Rectangle(
						5,	//layer
						0,	//start X
						0,	//start y
						256,	//end x
						176,	//end y
						15,1,0,0,0,true,128); 
					//Screen->DrawScreen(2,Game->GetCurMap(),Game->GetCurScreen(),0,0,0);
					Screen->DrawBitmap(
						5, 	// int layer,
						0,	// int bitmap_id, 
						128,	// int source_x,
						256,	// int source_y,
						256,	// int source_w,
						176,	// int source_h,
						0,	// int dest_x,
						0,	// int dest_y,
						256,	// int dest_w,
						176,	// int dest_h,
						0,	// float rotation,
						true	// bool mask
						);
					Screen->SetRenderTarget(RT_BITMAP1);
					Screen->DrawBitmap(
						5, 	// int layer,
						0,	// int bitmap_id, 
						128,	// int source_x,
						256,	// int source_y,
						256,	// int source_w,
						176,	// int source_h,
						0,	// int dest_x,
						0,	// int dest_y,
						256,	// int dest_w,
						176,	// int dest_h,
						0,	// float rotation,
						true	// bool mask
						);
					Screen->DrawScreen(5,WEATHER_MAP,WEATHER_NIGHT,0,0,0);
					if (Link->Item[I_LANTERN]) Screen->Circle(5, Link->X + 7 + XOff, Link->Y + 7 + YOff, 32 + VectorX(3.9, ModeMenu[WEATHER_NOISE]), 0, 1, 0, 0, 0, true, OP_OPAQUE);
					else Screen->Circle(5, Link->X + 7 + XOff, Link->Y + 7 + YOff, 24 + VectorX(3.9, ModeMenu[WEATHER_NOISE]), 0, 1, 0, 0, 0, true, OP_OPAQUE);
					for (ForTimer = 0; ForTimer < 176; ForTimer++)
					{
						if (Link->Item[I_WORLDGFX])
						{
							if (Screen->ComboD[ForTimer] == 384 || Screen->ComboD[ForTimer] == 322 || Screen->ComboD[ForTimer] == 324) Screen->Circle(5, ComboX(ForTimer) + 3 + XOff, ComboY(ForTimer) + 3 + YOff, 18 + VectorX(3.9, ModeMenu[WEATHER_NOISE]), 0, 1, 0, 0, 0, true, OP_OPAQUE);
							if (Screen->ComboD[ForTimer] == 387 || Screen->ComboD[ForTimer] == 303 || Screen->ComboD[ForTimer] == 316) Screen->Circle(5, ComboX(ForTimer) + 11 + XOff, ComboY(ForTimer) + 3 + YOff, 18 + VectorX(3.9, ModeMenu[WEATHER_NOISE]), 0, 1, 0, 0, 0, true, OP_OPAQUE);
							if (Screen->ComboD[ForTimer] == 388 || Screen->ComboD[ForTimer] == 306 || Screen->ComboD[ForTimer] == 321) Screen->Circle(5, ComboX(ForTimer) + 3 + XOff, ComboY(ForTimer) + 11 + YOff, 18 + VectorX(3.9, ModeMenu[WEATHER_NOISE]), 0, 1, 0, 0, 0, true, OP_OPAQUE);
							if (Screen->ComboD[ForTimer] == 391 || Screen->ComboD[ForTimer] == 319 || Screen->ComboD[ForTimer] == 329) Screen->Circle(5, ComboX(ForTimer) + 11 + XOff, ComboY(ForTimer) + 11 + YOff, 18 + VectorX(3.9, ModeMenu[WEATHER_NOISE]), 0, 1, 0, 0, 0, true, OP_OPAQUE);
						}
						if (Game->GetCurDMap() == 3 || Game->GetCurDMap() == 6 || Game->GetCurDMap() == 7 || Game->GetCurDMap() == 9 || Game->GetCurDMap() == 10)
						{
							if (Screen->ComboC[ForTimer] == 3 && (Screen->ComboD[ForTimer] == 5411 || Screen->ComboD[ForTimer] == 5173 || Screen->ComboD[ForTimer] == 5600 || Screen->ComboD[ForTimer] == 5596 || Screen->ComboD[ForTimer] == 5536 || Screen->ComboD[ForTimer] == 5540)) Screen->Circle(5, ComboX(ForTimer) + 7 + XOff, ComboY(ForTimer) + 7 + YOff, 24 + VectorX(3.9, ModeMenu[WEATHER_NOISE]), 0, 1, 0, 0, 0, true, OP_OPAQUE);
						}
						if (Game->GetCurDMap() >= 12 && Game->GetCurDMap() <= 20)
						{
							if (Screen->ComboC[ForTimer] == 4 && (Screen->ComboD[ForTimer] == 5281 || Screen->ComboD[ForTimer] == 5285)) Screen->Circle(5, ComboX(ForTimer) + 7 + XOff, ComboY(ForTimer) + 7 + YOff, 24 + VectorX(3.9, ModeMenu[WEATHER_NOISE]), 0, 1, 0, 0, 0, true, OP_OPAQUE);
						}
						if (Game->GetCurDMap() == DMAP_CAVES && !Screen->ComboS[ForTimer] && (ForTimer < 16 || ForTimer > 156 || ForTimer % 16 == 0 || ForTimer % 16 == 15)) Screen->Circle(5, ComboX(ForTimer) + 7 + XOff, ComboY(ForTimer) + 7 + YOff, 12 + VectorX(3.9, ModeMenu[WEATHER_NOISE]), 0, 1, 0, 0, 0, true, OP_OPAQUE);
					}
					for (ForTimer = 1; ForTimer <= Screen->NumNPCs() || ForTimer <= Screen->NumLWeapons() || ForTimer <= Screen->NumEWeapons(); ForTimer++)
					{
						if (ForTimer <= Screen->NumNPCs())
						{
							randoNPC = Screen->LoadNPC(ForTimer);
							if (randoNPC->ID == 85 || randoNPC->ID == 309) Screen->Circle(5, randoNPC->X + 7 + XOff, randoNPC->Y + 7 + YOff, 24 + VectorX(3.9, ModeMenu[WEATHER_NOISE]), 0, 1, 0, 0, 0, true, OP_OPAQUE);
						}
						if (ForTimer <= Screen->NumLWeapons())
						{
							randoLW = Screen->LoadLWeapon(ForTimer);
							if (randoLW->ID == LW_FIRE) Screen->Circle(5, randoLW->X + 7 + XOff, randoLW->Y + 7 + YOff, 24 + VectorX(3.9, ModeMenu[WEATHER_NOISE]), 0, 1, 0, 0, 0, true, OP_OPAQUE);
							if (randoLW->ID == LW_MAGIC) Screen->Circle(5, randoLW->X + 7 + XOff, randoLW->Y + 7 + YOff, 12 + VectorX(3.9, ModeMenu[WEATHER_NOISE]), 0, 1, 0, 0, 0, true, OP_OPAQUE);
						}
						if (ForTimer <= Screen->NumEWeapons())
						{
							randoEW = Screen->LoadEWeapon(ForTimer);
							if (randoEW->ID == EW_FIRE || randoEW->ID == EW_FIRE2) Screen->Circle(5, randoEW->X + 7 + XOff, randoEW->Y + 7 + YOff, 24 + VectorX(3.9, ModeMenu[WEATHER_NOISE]), 0, 1, 0, 0, 0, true, OP_OPAQUE);
							if (randoEW->ID == EW_MAGIC) Screen->Circle(5, randoEW->X + 7 + XOff, randoEW->Y + 7 + YOff, 12 + VectorX(3.9, ModeMenu[WEATHER_NOISE]), 0, 1, 0, 0, 0, true, OP_OPAQUE);
						}
					}
					Screen->SetRenderTarget(RT_BITMAP2);
					Screen->DrawBitmap(
						5, 	// int layer,
						1,	// int bitmap_id, 
						0,	// int source_x,
						0,	// int source_y,
						256,	// int source_w,
						176,	// int source_h,
						0,	// int dest_x,
						0,	// int dest_y,
						256,	// int dest_w,
						176,	// int dest_h,
						0,	// float rotation,
						true	// bool mask
						);
					Screen->DrawScreen(5,WEATHER_MAP,WEATHER_NIGHT,0,0,0);
					if (Link->Item[I_LANTERN]) Screen->Circle(5, Link->X + 7 + XOff, Link->Y + 7 + YOff, 34 + VectorX(3.9, ModeMenu[WEATHER_NOISE]), 0, 1, 0, 0, 0, true, OP_OPAQUE);
					else Screen->Circle(5, Link->X + 7 + XOff, Link->Y + 7 + YOff, 26 + VectorX(3.9, ModeMenu[WEATHER_NOISE]), 0, 1, 0, 0, 0, true, OP_OPAQUE);
					for (ForTimer = 0; ForTimer < 176; ForTimer++)
					{
						if (Link->Item[I_WORLDGFX])
						{
							if (Screen->ComboD[ForTimer] == 384 || Screen->ComboD[ForTimer] == 322 || Screen->ComboD[ForTimer] == 324) Screen->Circle(5, ComboX(ForTimer) + 3 + XOff, ComboY(ForTimer) + 3 + YOff, 20 + VectorX(3.9, ModeMenu[WEATHER_NOISE]), 0, 1, 0, 0, 0, true, OP_OPAQUE);
							if (Screen->ComboD[ForTimer] == 387 || Screen->ComboD[ForTimer] == 303 || Screen->ComboD[ForTimer] == 316) Screen->Circle(5, ComboX(ForTimer) + 11 + XOff, ComboY(ForTimer) + 3 + YOff, 20 + VectorX(3.9, ModeMenu[WEATHER_NOISE]), 0, 1, 0, 0, 0, true, OP_OPAQUE);
							if (Screen->ComboD[ForTimer] == 388 || Screen->ComboD[ForTimer] == 306 || Screen->ComboD[ForTimer] == 321) Screen->Circle(5, ComboX(ForTimer) + 3 + XOff, ComboY(ForTimer) + 11 + YOff, 20 + VectorX(3.9, ModeMenu[WEATHER_NOISE]), 0, 1, 0, 0, 0, true, OP_OPAQUE);
							if (Screen->ComboD[ForTimer] == 391 || Screen->ComboD[ForTimer] == 319 || Screen->ComboD[ForTimer] == 329) Screen->Circle(5, ComboX(ForTimer) + 11 + XOff, ComboY(ForTimer) + 11 + YOff, 20 + VectorX(3.9, ModeMenu[WEATHER_NOISE]), 0, 1, 0, 0, 0, true, OP_OPAQUE);
						}
						if (Game->GetCurDMap() == 3 || Game->GetCurDMap() == 6 || Game->GetCurDMap() == 7 || Game->GetCurDMap() == 9 || Game->GetCurDMap() == 10)
						{
							if (Screen->ComboC[ForTimer] == 3 && (Screen->ComboD[ForTimer] == 5411 || Screen->ComboD[ForTimer] == 5173 || Screen->ComboD[ForTimer] == 5600 || Screen->ComboD[ForTimer] == 5596 || Screen->ComboD[ForTimer] == 5536 || Screen->ComboD[ForTimer] == 5540)) Screen->Circle(5, ComboX(ForTimer) + 7 + XOff, ComboY(ForTimer) + 7 + YOff, 26 + VectorX(3.9, ModeMenu[WEATHER_NOISE]), 0, 1, 0, 0, 0, true, OP_OPAQUE);
						}
						if (Game->GetCurDMap() >= 12 && Game->GetCurDMap() <= 20)
						{
							if (Screen->ComboC[ForTimer] == 4 && (Screen->ComboD[ForTimer] == 5281 || Screen->ComboD[ForTimer] == 5285)) Screen->Circle(5, ComboX(ForTimer) + 7 + XOff, ComboY(ForTimer) + 7 + YOff, 26 + VectorX(3.9, ModeMenu[WEATHER_NOISE]), 0, 1, 0, 0, 0, true, OP_OPAQUE);
						}
						if (Game->GetCurDMap() == DMAP_CAVES && !Screen->ComboS[ForTimer] && (ForTimer < 16 || ForTimer > 156 || ForTimer % 16 == 0 || ForTimer % 16 == 15)) Screen->Circle(5, ComboX(ForTimer) + 7 + XOff, ComboY(ForTimer) + 7 + YOff, 14 + VectorX(3.9, ModeMenu[WEATHER_NOISE]), 0, 1, 0, 0, 0, true, OP_OPAQUE);
					}
					for (ForTimer = 1; ForTimer <= Screen->NumNPCs() || ForTimer <= Screen->NumLWeapons() || ForTimer <= Screen->NumEWeapons(); ForTimer++)
					{
						if (ForTimer <= Screen->NumNPCs())
						{
							randoNPC = Screen->LoadNPC(ForTimer);
							if (randoNPC->ID == 85 || randoNPC->ID == 309) Screen->Circle(5, randoNPC->X + 7 + XOff, randoNPC->Y + 7 + YOff, 26 + VectorX(3.9, ModeMenu[WEATHER_NOISE]), 0, 1, 0, 0, 0, true, OP_OPAQUE);
							else if (randoNPC->ID == 45 || randoNPC->ID == 303 || randoNPC->ID == 201 || randoNPC->ID == 46 || 
							randoNPC->ID == 302 || randoNPC->ID == 202 || randoNPC->ID == 136 || randoNPC->ID == 352 || 
							randoNPC->ID == 250 || randoNPC->ID == 251 || randoNPC->ID == 197 || randoNPC->ID == 245 || 
							randoNPC->ID == 246 || randoNPC->ID == 376 || randoNPC->ID == 87 || randoNPC->ID == 49 || 
							randoNPC->ID == 50 || randoNPC->ID == 381 || randoNPC->ID == 335 || randoNPC->ID == 92 || 
							randoNPC->ID == 382 || randoNPC->ID == 227 || randoNPC->ID == 228 || randoNPC->ID == 231 || 
							randoNPC->ID == 232 || randoNPC->ID == 35 || randoNPC->ID == 36 || randoNPC->ID == 198 || 
							randoNPC->ID == 30 || randoNPC->ID == 31 || randoNPC->ID == 254 || randoNPC->ID == 255 || 
							randoNPC->ID == 28 || randoNPC->ID == 29 || randoNPC->ID == 41 || randoNPC->ID == 79 || 
							randoNPC->ID == 120 || randoNPC->ID == 354 || randoNPC->Type == NPCT_WIZZROBE) Screen->Circle(5, randoNPC->X + 7 + XOff, randoNPC->Y + 7 + YOff, 18 + VectorX(3.9, ModeMenu[WEATHER_NOISE]), 0, 1, 0, 0, 0, true, OP_OPAQUE);
						}
						if (ForTimer <= Screen->NumLWeapons())
						{
							randoLW = Screen->LoadLWeapon(ForTimer);
							if (randoLW->ID == LW_FIRE) Screen->Circle(5, randoLW->X + 7 + XOff, randoLW->Y + 7 + YOff, 26 + VectorX(3.9, ModeMenu[WEATHER_NOISE]), 0, 1, 0, 0, 0, true, OP_OPAQUE);
							if (randoLW->ID == LW_MAGIC) Screen->Circle(5, randoLW->X + 7 + XOff, randoLW->Y + 7 + YOff, 14 + VectorX(3.9, ModeMenu[WEATHER_NOISE]), 0, 1, 0, 0, 0, true, OP_OPAQUE);
						}
						if (ForTimer <= Screen->NumEWeapons())
						{
							randoEW = Screen->LoadEWeapon(ForTimer);
							if (randoEW->ID == EW_FIRE || randoEW->ID == EW_FIRE2) Screen->Circle(5, randoEW->X + 7 + XOff, randoEW->Y + 7 + YOff, 26 + VectorX(3.9, ModeMenu[WEATHER_NOISE]), 0, 1, 0, 0, 0, true, OP_OPAQUE);
							if (randoEW->ID == EW_MAGIC || randoEW->ID == EW_FIREBALL) Screen->Circle(5, randoEW->X + 7 + XOff, randoEW->Y + 7 + YOff, 14 + VectorX(3.9, ModeMenu[WEATHER_NOISE]), 0, 1, 0, 0, 0, true, OP_OPAQUE);
						}
					}
					Screen->SetRenderTarget(RT_SCREEN);
					ModeMenu[WEATHER_NOISE] += 4;
					ModeMenu[WEATHER_NOISE] %= 360;
					Screen->DrawBitmap(
						5, 	// int layer,
						1,	// int bitmap_id, 
						0,	// int source_x,
						0,	// int source_y,
						256,	// int source_w,
						176,	// int source_h,
						0,	// int dest_x,
						0,	// int dest_y,
						256,	// int dest_w,
						176,	// int dest_h,
						0,	// float rotation,
						true	// bool mask
						);
					Screen->DrawBitmap(
						5, 	// int layer,
						2,	// int bitmap_id, 
						0,	// int source_x,
						0,	// int source_y,
						256,	// int source_w,
						176,	// int source_h,
						0,	// int dest_x,
						0,	// int dest_y,
						256,	// int dest_w,
						176,	// int dest_h,
						0,	// float rotation,
						true	// bool mask
						);
				}

				else
				{
				// Draw a rotating screen:
					Screen->Rectangle(
						5,	//layer
						0,	//start X
						0,	//start y
						256,	//end x
						176,	//end y
						15,1,0,0,0,true,128); 
					Screen->DrawBitmap(
						5, 	// int layer,
						0,	// int bitmap_id, 
						128,	// int source_x,
						256,	// int source_y,
						256,	// int source_w,
						176,	// int source_h,
						0,	// int dest_x,
						0,	// int dest_y,
						256,	// int dest_w,
						176,	// int dest_h,
						ModeMenu[WEATHER_NOISE]/4,	// float rotation,
						true	// bool mask
						);
					Screen->Rectangle(
						5,	//layer
						0,	//start X
						-56,	//start y
						256,	//end x
						0,	//end y
						15,1,0,0,0,true,128); 

					// Rotation timer
					if (Game->Counter[CR_WEATHER] != ENV_SPINSTOP)
					{
						if (ModeMenu[WEATHER_NOISE] < 1440) ++ModeMenu[WEATHER_NOISE];
						else ModeMenu[WEATHER_NOISE] = 1;
					}
				}
				if (Game->Counter[CR_WEATHER] == ENV_NAUSEA || Game->Counter[CR_WEATHER] == ENV_TRUENAUSEA) Screen->Wavy = 32;
			// End of drawn bitmap environments stuff
			}			

			// Slightly wavy screen:
			if (Game->Counter[CR_WEATHER] == ENV_WAVY1) Screen->Wavy = 8;

			// Very wavy screen:
			else if (Game->Counter[CR_WEATHER] == ENV_WAVY2) Screen->Wavy = 24;

			// --- Heat Ripples:
			else if (Game->Counter[CR_WEATHER] == ENV_HEATWAVY) Screen->Wavy = 1;
		}

		// Using the Lens of Truth disables weather / environment effects:
		if (Link->InputB)
		{
			if (GetEquipmentB() == I_LENS)
			{
				if (Game->Counter[CR_WEATHER] != 0)
				{
					RememberStuff[REMEMBER_WEATHERCOUNTER] = Game->Counter[CR_WEATHER];
					Game->Counter[CR_WEATHER] = 0;
				}
				if (Link->Item[I_CURSEDPICTOBOX])
				{
					RememberStuff[REMEMBER_PICTOBOX] = 1;
					Link->Item[I_CURSEDPICTOBOX] = false;
				}
			}
		}
		else
		{
			if (RememberStuff[REMEMBER_WEATHERCOUNTER] != 0)
			{
				Game->Counter[CR_WEATHER] = RememberStuff[REMEMBER_WEATHERCOUNTER];
				RememberStuff[REMEMBER_WEATHERCOUNTER] = 0;
			}
			if (RememberStuff[REMEMBER_PICTOBOX] == 1)
			{
				RememberStuff[REMEMBER_PICTOBOX] = 0;
				Link->Item[I_CURSEDPICTOBOX] = true;
			}
		}

// --------------------------------------- Chapter 7: Mode menu (end)

// --------------------------------------- Chapter 8: Link drowns, but only in Sideview 
// (Note: The "Link drowns in walkable water" quest rule is off)
			if (IsSideview())
			{
				if (Screen->ComboT[ComboAt(Link->X+7,Link->Y+12)] == CT_WATER)
				{
					if (!Link->Item[I_FLIPPERS])
					{
						if (Link->Action != LA_DROWNING)
						{
							lweapon Sploosh = CreateLWeaponAt(LW_SPARKLE,Link->X,Link->Y);
							Sploosh->UseSprite(SP_MISC_DEATH);
							Link->Action = LA_DROWNING;
							Game->PlaySound(SFX_OUCH);						
						}
					}
				}
			}

// --------------------------------------- Chapter 9: Sideview Ladder combos (start)

			if (Screen->ComboT[ComboAt(Link->X+4,Link->Y+8)] == CT_SIDECLIMB || Screen->ComboT[ComboAt(Link->X+4,Link->Y+16)] == CT_SIDECLIMB || Screen->ComboT[ComboAt(Link->X+12,Link->Y+8)] == CT_SIDECLIMB || Screen->ComboT[ComboAt(Link->X+12,Link->Y+16)] == CT_SIDECLIMB)
			{
				Link->Jump = 0;
				if (Link->Action < 2)
				{
					if (Link->InputUp)
					{
						if (Screen->ComboT[ComboAt(Link->X+4,Link->Y+8)] == CT_SIDECLIMB || Screen->ComboT[ComboAt(Link->X+4,Link->Y+15)] == CT_SIDECLIMB || Screen->ComboT[ComboAt(Link->X+12,Link->Y+8)] == CT_SIDECLIMB || Screen->ComboT[ComboAt(Link->X+12,Link->Y+15)] == CT_SIDECLIMB)
						{
							PushLink(DIR_UP);
							if (Link->Y <2) --Link->Y; 
						}
					}
					else if (Link->InputDown) 
						{
							PushLink(DIR_DOWN);
							if (Link->Y > 158) ++Link->Y;
						}
				}
			}

// --------------------------------------- Chapter 9: Sideview Ladder combos (end)

// --------------------------------------- Chapter 10: Spike-walking boots drain rupees slowly (start)

			if (!Link->Item[I_BOOTSTWO])
			{
				if (Link->Z == 0)
				{
					if (Game->Counter[CR_RUPEES] > 0)
					{
						if (SpikeBoots->Power == 0) SpikeBoots->Power = 7;
						if (IsSideview()) SideviewYCheckModify = 9;
						else if (SideviewYCheckModify > 0) SideviewYCheckModify = 0;
						if (Screen->ComboT[ComboAt(Link->X+7,Link->Y+8+SideviewYCheckModify)] >= CT_DAMAGE1 && Screen->ComboT[ComboAt(Link->X+7,Link->Y+8+SideviewYCheckModify)] <= CT_DAMAGE4 || Screen->ComboT[ComboAt(Link->X+7,Link->Y+8+SideviewYCheckModify)] >= CT_DAMAGE5 && Screen->ComboT[ComboAt(Link->X+7,Link->Y+8+SideviewYCheckModify)] <= CT_DAMAGE7)
						{	
							if (SpikeBootsTimer == 0)
							{
								StoodStill = 0;
								--Game->DCounter[CR_RUPEES];
								SpikeBootsTimer = 32;
							}
							else --SpikeBootsTimer;
						}
						else if (SpikeBootsTimer > 0) SpikeBootsTimer = 0;
					}
					else if (SpikeBoots->Power == 7) SpikeBoots->Power = 0;
				}
			}

// --------------------------------------- Chapter 10: Spike-walking boots drain rupees slowly (end)

// --------------------------------------- Chapter 11: Item: Medicine (Start)
			if (Link->HP == 0)
			{
				if (Link->Item[I_REDMEDICINE])
				{
					Game->PlaySound(25);
					Link->HP = 1;
					Game->DCounter[CR_LIFE] = Link->MaxHP;
					Link->Item[I_REDMEDICINE] = false;
					item MakeClock = CreateItemAt(I_MEDICINECLOCK,Link->X,Link->Y);
					MakeClock->Z = Link->Z;
					MakeClock->HitWidth = 32;
					MakeClock->HitHeight = 32;
					MakeClock->HitXOffset = -8;
					MakeClock->HitYOffset = -8;
				}
				else if (Link->Item[I_BLUEMEDICINE])
				{
					Game->PlaySound(25);
					Link->HP = 1;
					Game->DCounter[CR_LIFE] = Link->MaxHP;
					Link->Item[I_BLUEMEDICINE] = false;
					item MakeClock = CreateItemAt(I_MEDICINECLOCK,Link->X,Link->Y);
					MakeClock->Z = Link->Z;
					MakeClock->HitWidth = 32;
					MakeClock->HitHeight = 32;
					MakeClock->HitXOffset = -8;
					MakeClock->HitYOffset = -8;
				}
			}
// --------------------------------------- Chapter 11: Item: Medicine (End)

// --------------------------------------- Item: Patra slow-fall (start)
			if (IsSideview())
			{
				if (NumLWeaponsOf(LW_CANEOFBYRNA) > 0)
				{
					if (Link->Jump < 0)
					{
						if (PegasusTimer == 0) //Note that this does work with the pegasus boots, but I've opted not to here because that allows you to dash-fall super duper far.
						{
							if (Screen->Flags[9]&0x0020 && Link->Action != LA_SCROLLING) 
							{
								if (EverySix%2) Link->Jump = 0; 
								else Link->Jump = -0.80;
							}
							else if (Link->InputLeft || Link->InputRight)
							{
								//if (EverySix == 1) Link->Jump = 0;
								Link->Jump = 0-(EverySix*0.16);
							}
							else if (EverySix%2) Link->Jump = 0; 
							else Link->Jump = -1;
							//Screen->FastTile(3,Link->X,Link->Y-8,TILE_PATRA+Choose(0,1),7,128);
						}
					}
				}
			}			

// --------------------------------------- Item: Patra 2 slow-fall (end)

// --------------------------------------- Chapter 12: Item: Guardian Acorn (Start)
			if (Game->Counter[CR_ACORNS] > 0)
			{
				if (!Link->Item[I_ACORNBLUE]) Link->Item[I_ACORNBLUE] = true;
				if (Game->Counter[CR_ACORNS] > 24)
				{
					if (!Link->Item[I_ACORNRED]) Link->Item[I_ACORNRED] = true;
				}
				else if (Link->Item[I_ACORNRED]) Link->Item[I_ACORNRED] = false;
			}
			if (Game->Counter[CR_ACORNS] == 0)
			{
				if (Link->Item[I_ACORNRED]) Link->Item[I_ACORNRED] = false;
				if (Link->Item[I_ACORNBLUE]) Link->Item[I_ACORNBLUE] = false;
				if (Link->Item[I_MAGICACORN])
				{
					Game->Counter[CR_ACORNS] = Game->MCounter[CR_ACORNS];
					if (!Link->Item[I_ACORNBLUE]) Link->Item[I_ACORNBLUE] = true;
					if (!Link->Item[I_ACORNRED]) Link->Item[I_ACORNRED] = true;
					if (!Link->Item[I_GUARDIANACORN]) Link->Item[I_GUARDIANACORN] = true;
				}
			}
			if (!RememberStuff[REMEMBER_BEINGHURT])
			{
				if (Link->Action == LA_GOTHURTLAND)
				{
					RememberStuff[REMEMBER_BEINGHURT] = 1;
					if (Game->Counter[CR_ACORNS] > 0) --Game->Counter[CR_ACORNS];
					if (Game->Counter[CR_ACORNS] == 0) Link->Item[I_GUARDIANACORN] = false;
				}
			}
			else
			{
				if (Link->Action != LA_GOTHURTLAND) RememberStuff[REMEMBER_BEINGHURT] = 0;
			}
			if (Game->MCounter[CR_ACORNS] == 96)
			{
				Game->MCounter[CR_ACORNS] = 99;
				Game->Counter[CR_ACORNS] = 99;
			}

// --------------------------------------- Chapter 12: Item: Guardian Acorn (End)

// --------------------------------------- Chapter 13: Item: Duck Zapper (start)

			// --- Two ducks mode:
			if (Link->Item[I_ZAPPERTWO])
			{

				// Duck drops bullets
				if (TopDuck[DUCKSHOT_BULLET] == 0)
				{
					if (TopDuck[DUCKSHOT_FIRE] == 0) TopDuck[DUCKSHOT_FIRE] = Rand(64,511);
					else 
					{
						if (!ModeMenu[MODEMENU_ON] && Link->Action != LA_SCROLLING)
						{
							--TopDuck[DUCKSHOT_FIRE];
							if (TopDuck[DUCKSHOT_FIRE] == 1)
							{
								TopDuck[DUCKSHOT_TARGET] = Rand(32,144);
								TopDuck[DUCKSHOT_BULLET] = 1;	
								Game->PlaySound(SFX_DUCKSHOT);
								TopDuck[DUCKSHOT_FIRE] = 0;
							}
						}
					}
				}
				else
				{
					Screen->FastCombo(7,TopDuck[DUCKSHOT_X]+8,TopDuck[DUCKSHOT_BULLET] - 16,COMBO_BULLET,0,128);
					if (TopDuck[DUCKSHOT_BULLET] < TopDuck[DUCKSHOT_TARGET] + 16) ++TopDuck[DUCKSHOT_BULLET];
					else
					{
	 					lweapon PewPew = CreateLWeaponAt(LW_BOMBBLAST,TopDuck[DUCKSHOT_X]+8,TopDuck[DUCKSHOT_TARGET]);
						PewPew->Damage = 4;
 						eweapon BlamBlam = CreateEWeaponAt(EW_BOMBBLAST,TopDuck[DUCKSHOT_X]+8,TopDuck[DUCKSHOT_TARGET]);
						BlamBlam->Damage = 8;
						TopDuck[DUCKSHOT_BULLET] = 0;
					}
				}


				// Duck moves across top of the screen
				if (TopDuck[DUCKSHOT_DIR] == DIR_LEFT)
				{
					if (TopDuck[DUCKSHOT_X] == 0) TopDuck[DUCKSHOT_DIR] = DIR_RIGHT;
					else if (TopDuck[DUCKSHOT_STEP] == 0) 
					{
						if (TopDuck[DUCKSHOT_BULLET] == 0 && Link->Action != LA_SCROLLING)
						{
							TopDuck[DUCKSHOT_STEP] = 2;
							--TopDuck[DUCKSHOT_X];
						}
					}
					else --TopDuck[DUCKSHOT_STEP];

					Screen->FastCombo(7,TopDuck[DUCKSHOT_X],-32,COMBO_DUCK2,6,128);
					Screen->FastCombo(7,TopDuck[DUCKSHOT_X]+16,-32,COMBO_DUCK2+1,6,128);
					Screen->FastCombo(7,TopDuck[DUCKSHOT_X],-16,COMBO_DUCK2+4,6,128);
					Screen->FastCombo(7,TopDuck[DUCKSHOT_X]+16,-16,COMBO_DUCK2+5,6,128);	

				}
				else if (TopDuck[DUCKSHOT_DIR] == DIR_RIGHT)
				{
					if (TopDuck[DUCKSHOT_X] == 224) TopDuck[DUCKSHOT_DIR] = DIR_LEFT;
					else if (TopDuck[DUCKSHOT_STEP] == 0) 
					{
						if (TopDuck[DUCKSHOT_BULLET] == 0 && Link->Action != LA_SCROLLING)
						{
							TopDuck[DUCKSHOT_STEP] = 2;
							++TopDuck[DUCKSHOT_X];
						}
					}
					else --TopDuck[DUCKSHOT_STEP];

					Screen->FastCombo(7,TopDuck[DUCKSHOT_X],-32,COMBO_DUCK2+2,6,128);
					Screen->FastCombo(7,TopDuck[DUCKSHOT_X]+16,-32,COMBO_DUCK2+3,6,128);
					Screen->FastCombo(7,TopDuck[DUCKSHOT_X],-16,COMBO_DUCK2+6,6,128);
					Screen->FastCombo(7,TopDuck[DUCKSHOT_X]+16,-16,COMBO_DUCK2+7,6,128);
				}
				else TopDuck[DUCKSHOT_DIR] = Choose(DIR_LEFT,DIR_RIGHT);
				
			}


			// -- First duck (cursor Duck):
			if (Link->Item[I_ZAPPER] && DoDraw)
			{
				Screen->FastCombo(7,Link->InputMouseX,Link->InputMouseY,COMBO_DUCK1,6,128);
				Screen->FastCombo(7,Link->InputMouseX+16,Link->InputMouseY,COMBO_DUCK1+1,6,128);
				Screen->FastCombo(7,Link->InputMouseX,Link->InputMouseY+16,COMBO_DUCK1+4,6,128);
				Screen->FastCombo(7,Link->InputMouseX+16,Link->InputMouseY+16,COMBO_DUCK1+5,6,128);		

				if (Link->InputMouseB)
				{
					if (!HoldingMouse)
					{
						if (Game->Counter[CR_RUPEES] > 0)
						{
							--Game->Counter[CR_RUPEES];
							DuckDelay = 32;
						}
						HoldingMouse = true;
						Game->PlaySound(SFX_DUCK);
					}
				}
				else if (HoldingMouse && DuckDelay == 0) HoldingMouse = false;
				if (DuckDelay > 0) --DuckDelay;
				if (DuckDelay > 24)
				{
						Screen->Rectangle(
						7,	//layer
						0,	//start X
						-56,	//start y
						256,	//end x
						176,	//end y
						0,1,0,0,0,true,128);
						Screen->Rectangle(
						7,	//layer
						Link->InputMouseX-8,	//start X
						Link->InputMouseY-8,	//start y
						Link->InputMouseX+24,	//end x
						Link->InputMouseY+24,	//end y
						1,1,0,0,0,true,128);
				}
				if (DuckDelay == 24)
				{
 					lweapon PewPew = CreateLWeaponAt(LW_BOMBBLAST,Link->InputMouseX,Link->InputMouseY);
					PewPew->Damage = 4;
 					eweapon BlamBlam = CreateEWeaponAt(EW_BOMBBLAST,Link->InputMouseX,Link->InputMouseY);
					BlamBlam->Damage = 8;
					if (TopDuck[DUCKSHOT_BULLET] > 0)
					{
						if (TopDuck[DUCKSHOT_BULLET] >= Link->InputMouseY && TopDuck[DUCKSHOT_BULLET] <= Link->InputMouseY+32 && TopDuck[DUCKSHOT_X] >= Link->InputMouseX-24 && TopDuck[DUCKSHOT_X] <= Link->InputMouseX + 8)
						{
							TopDuck[DUCKSHOT_TARGET] = TopDuck[DUCKSHOT_BULLET] - 16;
							Game->PlaySound(SFX_DUCKHIT);
							item DuckPrize = CreateItemAt(I_RUPEETWO,Link->X,Link->Y);
							if (IsSideview()) DuckPrize->Y = 0;
							else DuckPrize->Z = Link->Y+32; 
						}
					}
				}
				if (Game->ClickToFreezeEnabled) Game->ClickToFreezeEnabled = false;
			}
			else if (!Game->ClickToFreezeEnabled) Game->ClickToFreezeEnabled = true;

// --------------------------------------- Chapter 13: Item: Duck Zapper (end)

// --------------------------------------- Chapter 14: Item: Bow-Wow (Start)
// Note: Bow-Wow cannot eat npcs of type NPCT_AQUAMENTUS or higher (see STD_CONSTANTS), unless they are NPCT_OTHER or NPCT_OTEHRFLOAT.
// Bow-wow also cannot eat enemies with the Superbomb defense "Block" or Superbomb defense "Ignore".
//
// If the enemy has the Superbomb defense "Ignore if <1", Bow-Wow will eat it reliably after targeting it, regardless of enemy type and without a chance of failure.

			if (!BowWow->isValid())
			{
				if (Link->Item[I_BOWWOW])
				{
					if (RememberStuff[REMEMBER_BOWWOWOFF] == 0)
					{
						if (Link->X > 8 && Link->X < 232 && Link->Y > 8 && Link->Y < 152)
						{
							BowWow = CreateLWeaponAt(LW_BOWWOW,Link->X,Link->Y);
							BowWow->CollDetection = 0;
							BowWow->Dir = Link->Dir;
						}
					}
				}
			}
			else
			{
				if (!Link->Item[I_BOWWOW] || RememberStuff[REMEMBER_BOWWOWOFF] == 1)
				{
					lweapon BowWowPoof = CreateLWeaponAt(LW_SPARKLE,BowWow->X,BowWow->Y);
					BowWowPoof->UseSprite(SP_MISC_DEATH); 
					Remove(BowWow);
				}
				else BowWow->DeadState = WDS_ALIVE;
				if (BowWow->Dir == DIR_UP) BowWow->UseSprite(SP_BOWWOWUP);
				else if (BowWow->Dir == DIR_DOWN) BowWow->UseSprite(SP_BOWWOWDOWN);
				else if (BowWow->Dir == DIR_LEFT) BowWow->UseSprite(SP_BOWWOWLEFT);
				else if (BowWow->Dir == DIR_RIGHT) BowWow->UseSprite(SP_BOWWOWRIGHT);
				if (NumLWeaponsOf(LW_REFFIREBALL) != 0) BowWow->CSet = 8;

				if (Link->Item[I_BOWWOWDETECTOR]) Screen->FastTile(6,BowWowStatus[BOWWOW_GOX],BowWowStatus[BOWWOW_GOY],TILE_BOWWOW_TARGET,Choose(7,8),128);

			// Bow-wow range limit
				if (Link->Y > BowWow->Y + 40 || Link->Y < BowWow->Y - 40 || Link->X > BowWow->X + 40 || Link->X < BowWow->X - 40)
				{
					if (BowWowStatus[BOWWOW_TIMER] < 512)
					{
						BowWowStatus[BOWWOW_GOX] = Link->X;
						BowWowStatus[BOWWOW_GOY] = Link->Y;
						BowWowStatus[BOWWOW_TIMER] = 16;
					}
					if (Link->Y > BowWow->Y + 40) BowWow->Y = Link->Y - 40;
					if (Link->Y < BowWow->Y - 40) BowWow->Y = Link->Y + 40;
					if (Link->X > BowWow->X + 40) BowWow->X = Link->X - 40;
					if (Link->X < BowWow->X - 40) BowWow->X = Link->X + 40;
				}

			// Bow-wow changes direction
				if (BowWowStatus[BOWWOW_TIMER] == 0)
				{
					BowWowStatus[BOWWOW_GOX] = Rand(Link->X-40,Link->X+40);
					BowWowStatus[BOWWOW_GOY] = Rand(Link->Y-40,Link->Y+40);
					BowWowStatus[BOWWOW_TIMER] = Rand(80,255);
				}
				else
				{
					--BowWowStatus[BOWWOW_TIMER];

			// Bow-wow moves
					if (ModeMenu[MODEMENU_ON] == 0)
					{					
						if (BowWowStatus[BOWWOW_TIMER] < 512)
						{
							if (BowWow->X > BowWowStatus[BOWWOW_GOX])
							{
								if (Game->GetCurDMap() >= DMAP_FIRST_DUNGEON && Game->GetCurDMap() <= DMAP_LAST_DUNGEON || Game->GetCurDMap() == DMAP_FAKE_LAST || Game->GetCurDMap() == 54 || Game->GetCurDMap() == 55)
								{
									if (BowWow->X > 32 && BowWow->X > Link->X-39) --BowWow->X;
								}
								else if (BowWow->X > 8 && BowWow->X > Link->X-39) --BowWow->X;
								BowWow->Dir = DIR_LEFT;
							}
							else if (BowWow->X < BowWowStatus[BOWWOW_GOX])
							{
								if (Game->GetCurDMap() >= DMAP_FIRST_DUNGEON && Game->GetCurDMap() <= DMAP_LAST_DUNGEON || Game->GetCurDMap() == DMAP_FAKE_LAST || Game->GetCurDMap() == 54 || Game->GetCurDMap() == 55)
								{
									if (BowWow->X < 208 && BowWow->X < Link->X+39) ++BowWow->X;
								}
								else if (BowWow->X < 232 && BowWow->X < Link->X+39) ++BowWow->X;
								BowWow->Dir = DIR_RIGHT;
							}
							if (BowWow->Y > BowWowStatus[BOWWOW_GOY])
							{
								if (Game->GetCurDMap() >= DMAP_FIRST_DUNGEON && Game->GetCurDMap() <= DMAP_LAST_DUNGEON || Game->GetCurDMap() == DMAP_FAKE_LAST || Game->GetCurDMap() == 54 || Game->GetCurDMap() == 55)
								{
										if (BowWow->Y > 32 && BowWow->Y > Link->Y-39) --BowWow->Y;
								}
								else if (BowWow->Y > 8 && BowWow->Y > Link->Y-39) --BowWow->Y;
								BowWow->Dir = DIR_UP;
							}
							else if (BowWow->Y < BowWowStatus[BOWWOW_GOY])
							{
								if (Game->GetCurDMap() >= DMAP_FIRST_DUNGEON && Game->GetCurDMap() <= DMAP_LAST_DUNGEON || Game->GetCurDMap() == DMAP_FAKE_LAST || Game->GetCurDMap() == 54 || Game->GetCurDMap() == 55)
								{
									if (BowWow->Y < 128 && BowWow->X < Link->X+39) ++BowWow->Y;
								}
								else if (BowWow->Y < 152 && BowWow->X < Link->X+39) ++BowWow->Y;
								BowWow->Dir = DIR_DOWN;
							}
						}

			// Sic Bow-Wow
						if (Link->PressA)
						{
							BowWowStatus[BOWWOW_TIMER] == Rand(128,511);
							if (Link->Dir == DIR_UP)
							{
								BowWowStatus[BOWWOW_GOX] = Link->X;
								BowWowStatus[BOWWOW_GOY] = Link->Y - 40;
							}
							else if (Link->Dir == DIR_DOWN)
							{
								BowWowStatus[BOWWOW_GOX] = Link->X;
								BowWowStatus[BOWWOW_GOY] = Link->Y + 40;
							}
							else if (Link->Dir == DIR_LEFT)
							{
								BowWowStatus[BOWWOW_GOX] = Link->X-40;
								BowWowStatus[BOWWOW_GOY] = Link->Y;
							}
							else if (Link->Dir == DIR_RIGHT)
							{
								BowWowStatus[BOWWOW_GOX] = Link->X+40;
								BowWowStatus[BOWWOW_GOY] = Link->Y;
							}
						}
	
			// Bow-Wow falls
						if (IsSideview())
						{
							if (BowWowStatus[BOWWOW_GOY] < Link->Y - 20) BowWowStatus[BOWWOW_GOY] = Link->Y - 20; 
							if (BowWow->Y == BowWowStatus[BOWWOW_GOY] && BowWowStatus[BOWWOW_GOY] < Link->Y)
							{
								if (CanWalk(BowWow->X,BowWow->Y,DIR_DOWN,1,false))
								{
									BowWowStatus[BOWWOW_GOY] = Link->Y;
									if (BowWowStatus[BOWWOW_TIMER] < 50) BowWowStatus[BOWWOW_TIMER] = 50;
								}
							}
						}

			// Bow-wow bounces
						else
						{
							if (BowWowStatus[BOWWOW_BOUNCE] > 0)
							{
								--BowWowStatus[BOWWOW_BOUNCE];
								--BowWow->DrawYOffset;
								--BowWow->HitYOffset;
							}
							else if (BowWow->DrawYOffset < 0)
							{
								++BowWow->DrawYOffset;
								++BowWow->HitYOffset;							
							}
							else BowWowStatus[BOWWOW_BOUNCE] = Choose(0,0,0,0,0,Choose(0,0,Rand(8,16)));
						}
					}
				}

			// Bow-wow's chain
				if (BowWow->DeadState == WDS_ALIVE)
				{
					if (Game->Counter[CR_WEATHER] == 0 || Game->Counter[CR_WEATHER] > ENV_BLOCKY && Game->Counter[CR_WEATHER] < ENV_WAVY1)
					{
						if (Link->HP > 0)
						{
							if (Link->X > 2 && Link->X < 238 && Link->Y > 2 && Link->Y < 158 && Link->HP > 0)
							{
								Screen->FastTile(
								1, 
								Link->X+((BowWow->X - Link->X) / 2), 
								Link->Y+((BowWow->Y - Link->Y) / 2) - (Link->Z/2)+BowWow->DrawYOffset/1.5, 
								BOWWOWCHAIN_TILE, BowWow->CSet, 128);
								Screen->FastTile(
								1, 
								Link->X+((BowWow->X - Link->X) / 3.75), 
								Link->Y+((BowWow->Y - Link->Y) / 3.75) - Link->Z +BowWow->DrawYOffset/2, 
								BOWWOWCHAIN_TILE, BowWow->CSet, 128);
								Screen->FastTile(
								1, 
								Link->X+((BowWow->X - Link->X) / 1.35), 
								Link->Y+((BowWow->Y - Link->Y) / 1.35) - (Link->Z/3)+BowWow->DrawYOffset, 
								BOWWOWCHAIN_TILE, BowWow->CSet, 128);
							}
						}
					}
				}

			// Bow-wow eats combos such as gopongo flowers
				if (Screen->ComboF[ComboAt(BowWow->X+7,BowWow->Y+8)] == CF_BOWWOW || Screen->ComboI[ComboAt(BowWow->X+7,BowWow->Y+8)] == CF_BOWWOW)
				{
					if (Screen->ComboF[ComboAt(BowWow->X+7,BowWow->Y+8)] == CF_BOWWOWSECRET) 
					{
						Screen->ComboD[ComboAt(BowWow->X+7,BowWow->Y+8)] = Screen->RoomData;
						Game->PlaySound(SFX_SECRET);
					}
					else Screen->ComboD[ComboAt(BowWow->X+7,BowWow->Y+8)] = Screen->UnderCombo;
					Screen->ComboF[ComboAt(BowWow->X+7,BowWow->Y+8)] = 0;
					Game->PlaySound(SFX_EDEAD);
				}

			// Bow-wow targets bait
				if (NumLWeaponsOf(LW_BAIT) > 0)
				{
					if (randoLW->isValid())
					{
						if (randoLW->ID != LW_BAIT) randoLW = LoadLWeaponOf(LW_BAIT);
						else	
						{
							BowWowStatus[BOWWOW_GOX] = randoLW->X;
							BowWowStatus[BOWWOW_GOY] = randoLW->Y;
						}
					}
					else 
					{
						randoLW = LoadLWeaponOf(LW_BAIT);
						BowWowStatus[BOWWOW_GOX] = randoLW->X;
						BowWowStatus[BOWWOW_GOY] = randoLW->Y;
					}
				}

			// Bow-wow targets enemies
				if (BowWowStatus[BOWWOW_EAT] == 0) BowWowStatus[BOWWOW_EAT] = Rand(200,800);
				else
				{
					--BowWowStatus[BOWWOW_EAT];
					if (BowWowStatus[BOWWOW_EAT] == 1)
					{
						if (Screen->NumNPCs() > 0)
						{
							if (BowWowStatus[BOWWOW_TIMER] < 512)
							{
								if (Screen->NumNPCs() > 1) BowWowTarget = Screen->LoadNPC(Rand(1,Screen->NumNPCs()));
								else BowWowTarget = Screen->LoadNPC(1);
								if (BowWowTarget->isValid())
								{
									if (BowWowTarget->X < Link->X + 40 && BowWowTarget->X > Link->X - 40 && BowWowTarget->Y < Link->Y + 40 && BowWowTarget->Y > Link->Y - 40)
									{
										BowWowStatus[BOWWOW_GOX] = BowWowTarget->X;
										BowWowStatus[BOWWOW_GOY] = BowWowTarget->Y;
										BowWowStatus[BOWWOW_TIMER] = 320;
										if (Link->Item[I_ITEMSGFX]) Game->PlaySound(SFX_BOWWOW);
										else Game->PlaySound(SFX_FDSGLEEOK);
										BowWowStatus[BOWWOW_EAT] = 0;
									}
									else BowWowStatus[BOWWOW_EAT] = 2;
								}
							}
							else BowWowStatus[BOWWOW_EAT] = 0;
						}
					}
				}

			// --- Bow-Wow displays a message on buried secrets; partially dummied feature, but works
				if (Screen->ComboT[ComboAt(BowWow->X+7,BowWow->Y+8)] == CT_DIGDIRT)	
				{
					if (!BowWowSecret)
					{
						if (Screen->ComboF[ComboAt(BowWow->X+7,BowWow->Y+8)] == CF_SHOVELITEM && !Screen->State[ST_SPECIALITEM] || Screen->ComboF[ComboAt(BowWow->X+7,BowWow->Y+8)] == CF_SHOVELSECRET)
						{
							//Screen->Message(MSG_BOWWOW);
							lweapon BowWowDig = CreateLWeaponAt(LW_SPARKLE,ComboX(ComboAt(BowWow->X+7,BowWow->Y+8)),ComboY(ComboAt(BowWow->X+7,BowWow->Y+8)));
							BowWowDig->UseSprite(SP_BLINKARROWLONG);
							BowWowDig->DrawYOffset = -12;
							lweapon BowWowDigTwo = CreateLWeaponAt(LW_SPARKLE,ComboX(ComboAt(BowWow->X+7,BowWow->Y+8)),ComboY(ComboAt(BowWow->X+7,BowWow->Y+8)));
							BowWowDigTwo->UseSprite(SP_BLINKARROW);
							BowWowDigTwo->DrawYOffset = -12;
							BowWowStatus[BOWWOW_TIMER] == 640;
							BowWowStatus[BOWWOW_GOX] = ComboX(ComboAt(BowWow->X+7,BowWow->Y+8));
							BowWowStatus[BOWWOW_GOY] = ComboY(ComboAt(BowWow->X+7,BowWow->Y+8));
							if (Link->Item[I_ITEMSGFX]) Game->PlaySound(SFX_BOWWOW);
							else Game->PlaySound(SFX_FDSGLEEOK);
							BowWowSecret = true;
						}
					}
				}
				else if (BowWowSecret) BowWowSecret = false;

			// --- Bow-Wow shoots fireballs with BowWow Fireball Item
				if (Link->PressA)
				{
					if (Link->Item[I_BOWWOWBALL])
					{
						if (NumLWeaponsOf(LW_REFFIREBALL) == 0)
						{
							lweapon Fetch = CreateLWeaponAt(LW_REFFIREBALL,BowWow->X,BowWow->Y);
							Fetch->Dir = Link->Dir;
							Fetch->Damage = 4;
							if (LinkCollision(Fetch)) Fetch->CollDetection = 0;
						}
					}
				}

			// Bow-wow eats enemies
			// Note: Bow-wow can only eat enemies with a Superbomb defense type of "None" (chance to eat) or "Ignore if <1" (certain to eat). So Bow-Wow won't eat "Ignore", "Block", "Block if <1", etc.
			// See also: "For Loop of NPCs" for additional Bow-wow eating
				if (BowWowTarget->isValid())
				{
					if (Collision(BowWow,BowWowTarget))
					{
						if (BowWowTarget->Defense[NPCD_SBOMB] == NPCDT_IGNORE1) BowWowTarget->HP = 0;
						else if (BowWowTarget->Defense[NPCD_SBOMB] == NPCDT_NONE)
						{
							if (BowWowTarget->Type < NPCT_MANHANDLA && BowWowTarget->Type != NPCT_GUY || BowWowTarget->Type >= NPCT_OTHERFLOAT) BowWowTarget->HP = Choose(BowWowTarget->HP,BowWowTarget->HP,BowWowTarget->HP,BowWowTarget->HP,BowWowTarget->HP,0);
						}
					}
				}
				if (RememberStuff[REMEMBER_BOWWOW_EATDELAY] > 0) --RememberStuff[REMEMBER_BOWWOW_EATDELAY]; 
			}
// --------------------------------------- Chapter 14: Item: Bow-Wow (End)



// --------------------------------------- Chapter 15: Every-frame Item checks / for loop of Items (start)

			for(ForTimer = Screen->NumItems(); ForTimer > 0; --ForTimer)
			{				
				item randoitem = Screen->LoadItem(ForTimer);
				if (!randoitem->isValid()) continue;
				{

					// --- Display Rupee amount number (by using the Rupee's "Power" setting)
					randoitemdata = Game->LoadItemData(randoitem->ID);
					if (randoitemdata->Family == IC_RUPEE)
					{
						if (randoitemdata->Power > 0)
						{

						//Draw "X"; dummied out
						//	Screen->DrawCharacter(
						//	2,					//int layer,
						//	randoitem->X+12,			//int x,
						//	randoitem->Y+8,				//int y,
						//	FONT_Z1,				//int font,
						//	1,					//int color,
						//	-1,					//int background_color,
						//	-1,					//int width,
						//	-1,					//int height,
						//	88,	//X				//int glyph,
						//	128);					//int opacity
							if (randoitem->CSet == 6) // Cset for Rupoors
							{
								if (randoitem->X < 225)
								{
									Screen->DrawInteger(
									2,					//int layer, 
									randoitem->X+12,			//int x, 
									randoitem->Y+8,				//int y, 
									FONT_Z1,				//int font, 
									1,					//int color, 
									-1,					//int background_color, 
									-1,					//int width, 
									-1,					//int height, 
									0-randoitemdata->Power,			//int number, 
									0, 					//int number_decimal_places, 
									128);					 //int opacity
								}
								else
								{
									Screen->DrawInteger(
									2,					//int layer, 
									randoitem->X,				//int x, 
									randoitem->Y+16,			//int y, 
									FONT_Z1,				//int font, 
									1,					//int color, 
									-1,					//int background_color, 
									-1,					//int width, 
									-1,					//int height, 
									0-randoitemdata->Power,			//int number, 
									0, 					//int number_decimal_places, 
									128);					 //int opacity
								}
							}
							else 
							{
								if (randoitem->X < 225)
								{
									Screen->DrawInteger(
									2,					//int layer, 
									randoitem->X+12,			//int x, 
									randoitem->Y+8,				//int y, 
									FONT_Z1,				//int font, 
									1,					//int color, 
									-1,					//int background_color, 
									-1,					//int width, 
									-1,					//int height, 
									randoitemdata->Power,			//int number, 
									0, 					//int number_decimal_places, 
									128);					 //int opacity
								}
								else
								{
									Screen->DrawInteger(
									2,					//int layer, 
									randoitem->X,				//int x, 
									randoitem->Y+16,			//int y, 
									FONT_Z1,				//int font, 
									1,					//int color, 
									-1,					//int background_color, 
									-1,					//int width, 
									-1,					//int height, 
									randoitemdata->Power,			//int number, 
									0, 					//int number_decimal_places, 
									128);					 //int opacity
								}
							}
							
						}
					}

		// Sword / Cane of Somaria (Sword Class) destroys negative hearts
					if (randoitem->ID == I_NEGAHEART)
					{
						if (NumNPCsOf(NPC_ABEI) == 0)
						{
							if (SomariaBlock->isValid())
							{
								{
									if (Collision(SomariaBlock,randoitem)) Remove(randoitem);
								}
							}
							if (NumLWeaponsOf(LW_SWORD) > 0)
							{
								lweapon FirstSword = LoadLWeaponOf(LW_SWORD);
								if (FirstSword->isValid())
								{
									if (Collision(FirstSword,randoitem)) Remove(randoitem);
								}
							}
						}
					}

		// --- No hearts Drop effect
					if (Link->Item[I_NOHEARTS])
					{
						if (randoitem->ID == I_HEART || randoitem->ID == I_HEARTTWO) Remove(randoitem);
					}

				}
			}


// --------------------------------------- Chapter 15: Every-frame Item checks / for loop of Items (end)



// --------------------------------------- Chapter 16: Every-frame EWeapon checks / for loop of EWeapons (start)
			for(ForTimer = Screen->NumEWeapons(); ForTimer > 0; --ForTimer)
			{
				randoEW = Screen->LoadEWeapon(ForTimer);
				if(!randoEW->isValid()) continue;
				{


		// -- Slower EW_BOMB
					if (randoEW->Step > 140)
					{
						if (randoEW->ID == EW_BOMB)
						{	
							randoEW->Step = 140;
							if (randoEW->Flip != FLIP_NONE) randoEW->Flip = FLIP_NONE; //optional aesthetic thing, I like them better facing up
						}
					}

		// --- EWeapons move on conveyor belts
					if (Screen->ComboT[ComboAt(randoEW->X+7,randoEW->Y+8)] == CT_CVUP && CanWalk(randoEW->X,randoEW->Y,DIR_UP,1,false)) --randoEW->Y;
					if (Screen->ComboT[ComboAt(randoEW->X+7,randoEW->Y+8)] == CT_CVDOWN && CanWalk(randoEW->X,randoEW->Y,DIR_DOWN,1,false)) ++randoEW->Y;
					if (Screen->ComboT[ComboAt(randoEW->X+7,randoEW->Y+8)] == CT_CVLEFT && CanWalk(randoEW->X,randoEW->Y,DIR_LEFT,1,false)) --randoEW->X;
					if (Screen->ComboT[ComboAt(randoEW->X+7,randoEW->Y+8)] == CT_CVRIGHT && CanWalk(randoEW->X,randoEW->Y,DIR_RIGHT,1,false)) ++randoEW->X;


		// --- EWeapons can be destroyed by Somaria Block
					if (SomariaBlock->isValid())
					{

						if (randoEW->X > SomariaBlock->X - 9 && randoEW->X < SomariaBlock->X + 9 && randoEW->Y > SomariaBlock->Y - 9 && randoEW->Y < SomariaBlock->Y+9)
						{
							if (randoEW->ID != EW_FIRETRAIL && randoEW->ID != EW_FIRE) 
							{
								if (randoEW->ID != EW_BOMBBLAST && randoEW->ID != EW_SBOMBBLAST && randoEW->ID != EW_FIRE2 && randoEW->ID != EW_FIREBALL2) Game->PlaySound(SFX_CLINK);
								if (randoEW->ID != EW_ROCK && randoEW->ID != EW_ARROW && randoEW->ID != EW_SOMARIA)
								{
									if (!Link->Item[I_CANE2] && !Link->Item[I_CANE3] || randoEW->ID != EW_FIREBALL && randoEW->ID != EW_MAGIC && randoEW->ID != EW_BEAM && randoEW->ID != EW_STATIONARYBOMB && randoEW->ID != EW_LINKWEAPONS)
									{
										lweapon SomariaGoesPoof = CreateLWeaponAt(LW_SPARKLE,SomariaBlock->X,SomariaBlock->Y);
										SomariaGoesPoof->UseSprite(SP_MISC_DEATH);
										Remove(SomariaBlock);
									}
								}
							}
							else Game->PlaySound(SFX_CLINK);
							if (randoEW->ID != EW_BOMBBLAST && randoEW->ID != EW_SBOMBBLAST && randoEW->ID != EW_FIRE2 && randoEW->ID != EW_FIREBALL2 && randoEW->ID != EW_LINKSHADOW && randoEW->ID != EW_LINKWEAPONS)
							{
								if (randoEW->ID == EW_BOMB)
								{
									eweapon Kabewm = CreateEWeaponAt(EW_BOMBBLAST,randoEW->X,randoEW->Y);
									Kabewm->Damage = randoEW->Damage;
								}
								if (randoEW->ID == EW_SBOMB)
								{
									eweapon KaBEWWWWM = CreateEWeaponAt(EW_SBOMBBLAST,randoEW->X,randoEW->Y);
									KaBEWWWWM->Damage = randoEW->Damage;
								}
								Remove(randoEW);
							}
						}
					}

		// --- EWeapons can be destroyed by Pegasus Boots Lanmola Head
					if (BootStab->isValid())
					{

						if (randoEW->X > BootStab->X - 9 && randoEW->X < BootStab->X + 9 && randoEW->Y > BootStab->Y - 9 && randoEW->Y < BootStab->Y+9)
						{
							if (randoEW->ID == EW_ARROW || randoEW->ID == EW_BRANG || randoEW->ID == EW_ROCK || randoEW->ID == EW_FIREBALL || randoEW->ID == EW_FIRETRAIL || randoEW->ID == EW_WIND)
							{
								Game->PlaySound(SFX_CLINK);
								Remove(randoEW);
							}
						}
					}

		// --- Eweapons can be destroyed by Duck Zapper
					if (DuckDelay == 24)
					{
						if (randoEW->ID != EW_BOMBBLAST && randoEW->ID != EW_SBOMBBLAST)
						{
							if (randoEW->Y >= Link->InputMouseY - 16 && randoEW->Y <= Link->InputMouseY+32 && randoEW->X >= Link->InputMouseX-16 && randoEW->X <= Link->InputMouseX + 32)
							{
								Remove(randoEW);
								Game->PlaySound(SFX_CLINK);
							}
						}
					}

					

		// --- Boomerangs stun Link (Zelda)
					if (randoEW->ID == EW_BRANG)
					{
						Screen->DrawTile(
							2,
							randoEW->X,		//start X
							randoEW->Y,		//start y
							randoEW->Tile,		//tile ID
							1,			//tile width
							1,			//tile width
							Choose(6,7,8,9),	//tile cset
							-1,-1,-1,-1,0,randoEW->Flip,1,128);
						if (randoEW->DrawYOffset < 255) randoEW->DrawYOffset = 255;
						{
							if (Link->CollDetection && Game->Counter[CR_LINKSTUN] == 0)
							{
								if (Link->X > randoEW->X - 8 && Link->X < randoEW->X + 8 && Link->Y > randoEW->Y - 8 && Link->Y < randoEW->Y + 8)
								{
									if (randoEW->Angular == true) Game->Counter[CR_LINKSTUN] = 192;
									else Game->Counter[CR_LINKSTUN] = 120;
									Game->PlaySound(SFX_BRANG);
								}
							}
						}
					}

		// --- EWeapon Bolas (Guma weapon)
					if (randoEW->ID == EW_BOLA)
					{
						if (randoEW->OriginalTile != EWBOLA_ORIGINAL_TILE) 
						{
							if (randoEW->X < Link->X-32) randoEW->Dir = DIR_RIGHT;
							else if (randoEW->X > Link->X+32) randoEW->Dir = DIR_LEFT;
							else randoEW->Dir = DIR_DOWN;
							randoEW->UseSprite(SP_EWBOLA);
						}
						if (randoEW->Misc[MISC_EWBOLA]<48) ++randoEW->Misc[MISC_EWBOLA];
						if (randoEW->Misc[MISC_EWBOLA] < 16)
						{
							if (randoEW->Y > 8) randoEW->Y = randoEW->Y - 2; 
							else randoEW->Z = randoEW->Z + 2;
						}
						if (randoEW->Misc[MISC_EWBOLA] > 15 && randoEW->Misc[MISC_EWBOLA] < 32)
						{
							if (randoEW->Y > 8) --randoEW->Y;
							else ++randoEW->Z;
						}
						if (randoEW->Misc[MISC_BOLA] > 36 && randoEW->Z > 0) randoEW->Z = randoEW->Z - 2;
						if (randoEW->Misc[MISC_BOLA] > 36 && randoEW->Misc[MISC_BOLA] < 48) randoEW->Y = randoEW->Y+2;
						if (randoEW->Misc[MISC_BOLA] > 47) randoEW->Y = randoEW->Y+3;
						if (randoEW->Dir == DIR_RIGHT) ++randoEW->X;
						if (randoEW->Dir == DIR_LEFT) --randoEW->X;
					}

		// --- EWeapon Maces (Doomknocker weapon)

					else if (randoEW->ID == EW_MACE)
					{
						if (randoEW->Misc[MISC_EWMACE] == 0)
						{
							randoEW->UseSprite(SP_MACE);
							randoEW->Misc[MISC_EWMACE] = 6;
							randoEW->Step = 150;
						}
						else if (randoEW->Misc[MISC_EWMACE] == 1) Remove(randoEW);


						if (randoEW->Dir == DIR_LEFT)
						{
							if (randoEW->X < 34)
							{
								if (randoEW->Angular == true) randoEW->Angular = false;
								randoEW->Dir = DIR_RIGHT;
								--randoEW->Misc[MISC_EWMACE];
							}
						}
						if (randoEW->Dir == DIR_RIGHT)
						{
							if (randoEW->X > 206)
							{
								if (randoEW->Angular == true) randoEW->Angular = false;
								randoEW->Dir = DIR_LEFT;
								--randoEW->Misc[MISC_EWMACE];
							}
						}
						if (randoEW->Dir == DIR_UP)
						{
							if (randoEW->Y < 34)
							{
								if (randoEW->Angular == true) randoEW->Angular = false;
								randoEW->Dir = DIR_DOWN;
								--randoEW->Misc[MISC_EWMACE];
							}
						}
						if (randoEW->Dir == DIR_DOWN)
						{
							if (randoEW->Y > 126)
							{
								if (randoEW->Angular == true) randoEW->Angular = false;
								randoEW->Dir = DIR_UP;
								--randoEW->Misc[MISC_EWMACE];
							}
						}
					}

		// --- EWeapon Stationary Bombs

					else if (randoEW->ID == EW_STATIONARYBOMB)
					{
						if (randoEW->CollDetection != 0)
						{
							randoEW->UseSprite(SP_EWSTATIONARYBOMB);
							randoEW->CollDetection = 0;
							randoEW->Misc[MISC_STATIONARYFUSE] = 120;
						}
						else{
							--randoEW->Misc[MISC_STATIONARYFUSE];

							// Stationary bombs which have been carried by the beetle turn into LW_BOMBs
							if (randoEW->Misc[MISC_STATIONARYFUSE] == 9998)
							{
								randoLW = CreateLWeaponAt(LW_BOMB,randoEW->X,randoEW->Y);
								//randoLW->CSet = randoEW->CSet;
								randoLW->Damage = 4;
								Remove(randoEW);
							}
						}
						if (randoEW->Misc[MISC_STATIONARYFUSE] == 1)
						{
							eweapon Kablooie = CreateEWeaponAt(EW_BOMBBLAST,randoEW->X,randoEW->Y);
							Kablooie->Damage = randoEW->Damage;
							Remove(randoEW);
						}

					}
		// --- EWeapon Somaria blocks
					
					else if (randoEW->ID == EW_SOMARIA)
					{
						if (randoEW->Misc[MISC_EWSOMARIA] == 0)
						{
							randoEW->Misc[MISC_EWSOMARIA] = Rand(96,255);
							randoEW->UseSprite(SP_EWSOMARIA);
							Game->PlaySound(SFX_SOMARIA);
						}
						else
						{
							--randoEW->Misc[MISC_EWSOMARIA];
							if (randoEW->Misc[MISC_EWSOMARIA] == 1)
							{
								lweapon ESomariaPoof = CreateLWeaponAt(LW_SPARKLE,randoEW->X,randoEW->Y);
								ESomariaPoof->UseSprite(SP_MISC_DEATH);
								if (NumEWeaponsOf(EW_BEAM) == 0)
								{
									Game->PlaySound(SFX_BEAM);
									eweapon SomariaSword = CreateEWeaponAt(EW_BEAM,randoEW->X,randoEW->Y);
									SomariaSword->Dir = DIR_UP;
									SomariaSword->UseSprite(SP_SOMARIABEAM);
									SomariaSword->Damage = randoEW->Damage;

									SomariaSword = CreateEWeaponAt(EW_BEAM,randoEW->X,randoEW->Y);
									SomariaSword->Dir = DIR_DOWN;
									SomariaSword->UseSprite(SP_SOMARIABEAM);
									SomariaSword->Flip = FLIP_VERTICAL;
									SomariaSword->Damage = randoEW->Damage;

									SomariaSword = CreateEWeaponAt(EW_BEAM,randoEW->X,randoEW->Y);
									SomariaSword->Dir = DIR_LEFT;
									SomariaSword->UseSprite(SP_SOMARIABEAMSIDE);
									SomariaSword->Flip = FLIP_HORIZONTAL;
									SomariaSword->Damage = randoEW->Damage;

									SomariaSword = CreateEWeaponAt(EW_BEAM,randoEW->X,randoEW->Y);
									SomariaSword->Dir = DIR_RIGHT;
									SomariaSword->UseSprite(SP_SOMARIABEAMSIDE);
									SomariaSword->Damage = randoEW->Damage;

								}
								Remove(randoEW);
							} 
						}
					}
		// --- Eweapon spike floor
					else if (randoEW->ID == EW_SPIKES)
					{
						if (Screen->ComboS[ComboAt(randoEW->X+7,randoEW->Y+8)] == 0)
						{
							if (Screen->ComboD[ComboAt(randoEW->X+7,randoEW->Y+8)] != COMBO_SPIKES)
							{
								if (Screen->ComboF[ComboAt(randoEW->X+7,randoEW->Y+8)] == 0 && Screen->ComboI[ComboAt(randoEW->X+7,randoEW->Y+8)] < CF_NOENEMY)
								{
									Screen->ComboD[ComboAt(randoEW->X+7,randoEW->Y+8)] = COMBO_SPIKES;
									Game->PlaySound(SFX_SHATTERING);
								}
							}
						}
						Remove(randoEW);
					}
		// --- Eweapon Conveyor floor
					else if (randoEW->ID == EW_CONVEYOR)
					{
						if (!IsSideview()) // It does work in Sideview if you remove this line, but I opted not to do it here because it was awkward with the falling mechanics this quest uses.
						{ //If re-enabling sideview, remove these brackets also.
							if (Screen->ComboS[ComboAt(randoEW->X+7,randoEW->Y+8)] == 0)
							{
								if (Screen->ComboF[ComboAt(randoEW->X+7,randoEW->Y+8)] == 0 && Screen->ComboI[ComboAt(randoEW->X+7,randoEW->Y+8)] < CF_NOENEMY)
								{
									if (Screen->ComboT[ComboAt(randoEW->X+7,randoEW->Y+8)] != CT_STAIR)
									{
									//NOTE: "Stairs [B]", "Stairs [C]", and "Stairs [D]" can still be overwritten, just not "Stairs [A}".
										Screen->ComboD[ComboAt(randoEW->X+7,randoEW->Y+8)] = COMBO_CONVEYOR+Choose(0,1,2,3);
										Game->PlaySound(SFX_WAND);
									}
								}
							}
						} //If re-enabling sideview, remove these brackets also.
						Remove(randoEW);
					}
		// --- Remove eweapons that are at YOffset of 299 (used by NPC_GIBO)
					if (randoEW->DrawYOffset == 299) Remove(randoEW);


		// --- end

				}
			}
// --------------------------------------- Chapter 16: Every-frame EWeapon checks / for loop of EWeapons (end)



// --------------------------------------- Chapter 17: Every-frame NPC checks / for loop of NPCs (start)
// This section originally handled most common custom NPC behaviors made by Mitsukara, 
// but a lot of it has been ported into the FFC script "EnemyLoopYesSeriouslyZCWhy" by Dimi to reduce strain on the Global's ZASM limit.

			// Loads an FFC to handle most of what the original loop did
			int sn[] = "EnemyLoopYesSeriouslyZCWhy";
			int sid = Game->GetFFCScript(sn);
			if (CountFFCsRunning(sid) <= 0)
			{
				ffc f;
				for ( int q = 1; q <= 32; ++q )
				{
					f = Screen->LoadFFC(q);
					if ( f->Script ) continue;
					if ( f->Data ) continue;
					if ( q )
					{
						f->Data = 1;
						f->Script = sid;
						break;
					}
				}
			}

			// Leftover portion of the original loop to handle things that wouldn't work well from an FFC
			for(ForTimer = Screen->NumNPCs(); ForTimer > 0; --ForTimer)
			{
				randoNPC = Screen->LoadNPC(ForTimer);
				if(!randoNPC->isValid()) continue;
				{
					if (Link->Item[I_HEROCHARM])
					{
						if (randoNPC->Misc[MISC_RECENTHP] != randoNPC->HP)
						{
							randoNPC->Misc[MISC_RECENTHP] = randoNPC->HP;
							randoNPC->Misc[MISC_SHOWHPTIMER] = 120;
						} 
						if (Game->Counter[CR_WEATHER] == 0 || Game->Counter[CR_WEATHER] > ENV_BLOCKY)
						{
							if (randoNPC->Type != NPCT_GUY && randoNPC->ID != NPC_PATRA_REVERSE_EYE && randoNPC->ID != NPC_MOLDORM_GROW_TAIL1 && randoNPC->ID != NPC_MOLDORM_GROW_TAIL2 && randoNPC->ID != NPC_LANMOLA_GROW_TAIL1 && randoNPC->ID != NPC_LANMOLA_GROW_TAIL2)
							{
								if (randoNPC->HP-randoNPC->Misc[MISC_HP_REDUCE] >= 0)
								{
									if (randoNPC->HP < 900 || randoNPC->Type != NPCT_GLEEOK)
									{
										if (randoNPC->Misc[MISC_SHOWHPTIMER] > 0)
										{
											if (randoNPC->ID != NPC_PATRA_REVERSE_EYE)
											{
												-- randoNPC->Misc[MISC_SHOWHPTIMER];

												//shadow:
												Screen->DrawInteger(
												1,								//int layer, 
												randoNPC->X+1,							//int x, 
												randoNPC->Y-8 - randoNPC->Z + randoNPC->DrawYOffset,		//int y, 
												FONT_Z1,							//int font, 
												17,								//int color, 
												-1,								//int background_color, 
												-1,								//int width, 
												-1,								//int height, 
												randoNPC->HP -randoNPC->Misc[MISC_HP_REDUCE],			//int number, 
												0, 								//int number_decimal_places, 
												128);								//int opacity

												//White number:
												Screen->DrawInteger(
												1,								//int layer, 
												randoNPC->X,							//int x, 
												randoNPC->Y-9 - randoNPC->Z + randoNPC->DrawYOffset,		//int y, 
												FONT_Z1,							//int font, 
												1,								//int color, 
												-1,								//int background_color, 
												-1,								//int width, 
												-1,								//int height, 
												randoNPC->HP -randoNPC->Misc[MISC_HP_REDUCE],			//int number, 
												0, 								//int number_decimal_places, 
												128);								//int opacity
											}
										}
									}
								}
							}
						}
						// Show enemy names when lweapons touch them
						// See also: "Enemy Name Display", above
						if (randoNPC->Misc[MISC_NPCLWEAPON] == 0)
						{
							for(ForTimerTwo = Screen->NumLWeapons(); ForTimerTwo > 0; --ForTimerTwo)
							{
								randoLW = Screen->LoadLWeapon(ForTimerTwo);
								if(!randoLW->isValid()) continue;
								{
									if (randoLW->ID != LW_SPARKLE)
									{
										if (Collision(randoLW,randoNPC))
										{
											RememberStuff[REMEMBER_ENEMYNAMEWAIT] = 255;
											randoNPC->GetName(ENEMYNAME_BUFFER);
											LowerToUpper_Str(ENEMYNAME_BUFFER);
										}
									}
								}
							}
						}
					}
				}
			}
			
// --------------------------------------- Chapter 17: Every-frame NPC checks / for loop of NPCs (end)



// --------------------------------------- Chapter 18: Every-frame LWeapon checks / for loop of Lweapons (start)
			for(ForTimer = Screen->NumLWeapons(); ForTimer > 0; --ForTimer)
			{
				randoLW = Screen->LoadLWeapon(ForTimer);
				if(!randoLW->isValid()) continue;
				{

		// --- "Block all" combos kill most script weapons, refrocks, and reflected fireballs
					if (Screen->ComboT[ComboAt(randoLW->X+7,randoLW->Y+8)] == CT_BLOCKALL)
					{
						if (randoLW->ID == LW_SOMARIA || randoLW->ID == LW_BEETLE || randoLW->ID == LW_BOLA || randoLW->ID == LW_ARMOS || randoLW->ID == LW_ROPE || randoLW->ID == LW_REFROCK || randoLW->ID == LW_REFFIREBALL)
						{
							//Game->PlaySound(SFX_CLINK);
							if (randoLW->Y > 32 && randoLW->X > 32)
							{
								lweapon GoPoof = CreateLWeaponAt(LW_SPARKLE,32,32);
								GoPoof->DrawXOffset = randoLW->X -32;
								GoPoof->DrawYOffset = randoLW->Y -32;
								GoPoof->UseSprite(SP_MISC_DEATH);
							}
							Remove(randoLW);
						}
					}

		// --- LWeapons move on conveyor belts
					if (randoLW->ID != LW_BOMBBLAST && randoLW->ID != LW_SBOMBBLAST)
					{
						if (Screen->ComboT[ComboAt(randoLW->X+7,randoLW->Y+8)] == CT_CVUP && CanWalk(randoLW->X,randoLW->Y,DIR_UP,1,false)) --randoLW->Y;
						if (Screen->ComboT[ComboAt(randoLW->X+7,randoLW->Y+8)] == CT_CVDOWN && CanWalk(randoLW->X,randoLW->Y,DIR_DOWN,1,false)) ++randoLW->Y;
						if (Screen->ComboT[ComboAt(randoLW->X+7,randoLW->Y+8)] == CT_CVLEFT && CanWalk(randoLW->X,randoLW->Y,DIR_LEFT,1,false)) --randoLW->X;
						if (Screen->ComboT[ComboAt(randoLW->X+7,randoLW->Y+8)] == CT_CVRIGHT && CanWalk(randoLW->X,randoLW->Y,DIR_RIGHT,1,false)) ++randoLW->X;
					}

		// --- Custom burn combo flag
					if (randoLW->ID == LW_FIRE)
					{
						if (Screen->ComboF[ComboAt(randoLW->X+7,randoLW->Y+8)] == CF_BURNCOMBO || Screen->ComboI[ComboAt(randoLW->X+7,randoLW->Y+8)] == CF_BURNCOMBO)
						{
							Screen->ComboD[ComboAt(randoLW->X+7,randoLW->Y+8)] = Screen->UnderCombo;
							Screen->ComboF[ComboAt(randoLW->X+7,randoLW->Y+8)] = 0;
						}
					}
		// --- Remove bait if you use the bait
					if (Link->PressB)
					{
						if (GetEquipmentB() == I_BAIT || GetEquipmentB() == I_BAIT2)
						{
							if (Link->Action <= LA_WALKING)
							{
								if (NumLWeaponsOf(LW_BAIT) > 0)
								{
									lweapon Meatz = LoadLWeaponOf(LW_BAIT);
									if (Meatz->isValid()) Remove(Meatz);
								}	
							}
						}
					}
					else if (Link->PressA)
					{
						if (GetEquipmentA() == I_BAIT || GetEquipmentA() == I_BAIT2)
						{
							if (Link->Action <= LA_WALKING)
							{
								if (NumLWeaponsOf(LW_BAIT) > 0)
								{
									lweapon Meatz = LoadLWeaponOf(LW_BAIT);
									if (Meatz->isValid()) Remove(Meatz);
								}	
							}
						}
					}

		// --- LW_REFROCK doesn't damage Link
					if (randoLW->ID == LW_REFROCK)
					{
						if (randoLW->Damage < 255)
						{
							if (randoLW->CollDetection == 0)
							{
								if (!LinkCollision(randoLW)) randoLW->CollDetection = 1;
							}
							else
							{
								if (LinkCollision(randoLW)) randoLW->CollDetection = 0;
							}
						}
			// --- LW_REFROCK is killed by statues
						if (Screen->ComboT[ComboAt(randoLW->X+7,randoLW->Y+8)] == CT_LEFTSTATUE || Screen->ComboT[ComboAt(randoLW->X+7,randoLW->Y+8)] == CT_RIGHTSTATUE) randoLW->DeadState = WDS_DEAD;
					}

		// --- LW_REFFIREBALL doesn't damage Link
					if (randoLW->ID == LW_REFFIREBALL)
					{
						if (randoLW->Damage < 5)
						{
							if (randoLW->CollDetection == 0)
							{
								if (!LinkCollision(randoLW)) randoLW->CollDetection = 1;
							}
							else
							{
								if (LinkCollision(randoLW)) randoLW->CollDetection = 0;
							}
						}
					}

		// --- LWeapons are drawn above subscreen
					if (Game->Counter[CR_WEATHER] == 0 && !Link->Item[I_CURSEDPICTOBOX])
					{
						if (ModeMenu[MODEMENU_ON] == 0)
						{
							if (randoLW->ID != LW_SWORD)
							{
								if (randoLW->ID != LW_HAMMER)
								{
									if (randoLW->ID != LW_WAND)
									{
										if (randoLW->ID != LW_BEAM)
										{
											if (((randoLW->Y - randoLW->Z)+randoLW->DrawYOffset + randoLW->DrawZOffset) < 0) 
											Screen->FastTile(
											7,
											randoLW->X + randoLW->DrawXOffset,
											(randoLW->Y - randoLW->Z)+randoLW->DrawYOffset + randoLW->DrawZOffset,
											randoLW->Tile,
											randoLW->CSet,
											128);
										}
									}
								}
							}
						}
					}

		// --- LWeapon->Misc[] attribute for temporary no collision detection
					if (randoLW->CollDetection == 0)
					{
						if (randoLW->Misc[MISC_TEMPNOCOLLIDELW] > 0)
						{
							--randoLW->Misc[MISC_TEMPNOCOLLIDELW];
							if (randoLW->Misc[MISC_TEMPNOCOLLIDELW] == 1)
							{
								randoLW->CollDetection = 1;
								randoLW->Misc[MISC_TEMPNOCOLLIDELW] = 0;
							}
						}

					}

		// --- LWeapon->Misc[] attribute for removal after timeout
					if (randoLW->Misc[MISC_LWTIMEOUT] > 0)
					{
						if (randoLW->Misc[MISC_LWTIMEOUT] > 1) --randoLW->Misc[MISC_LWTIMEOUT];
						else Remove(randoLW);
					}

		// --- Item: Bola movement. See also item script "ItemCreatesLWeapon".

					if (randoLW->ID == LW_BOLA)
					{
						if (randoLW->Misc[MISC_BOLA]<48) ++randoLW->Misc[MISC_BOLA];
						if (randoLW->Misc[MISC_BOLA] < 16)
						{
							if (randoLW->Y > 8) randoLW->Y = randoLW->Y - 2; 
							else randoLW->Z = randoLW->Z + 2;
						}
						if (randoLW->Misc[MISC_BOLA] > 15 && randoLW->Misc[MISC_BOLA] < 32)
						{
							if (randoLW->Y > 8) --randoLW->Y;
							else ++randoLW->Z;
						}
						if (randoLW->Misc[MISC_BOLA] > 36 && randoLW->Z > 0) randoLW->Z = randoLW->Z - 2;
						if (randoLW->Misc[MISC_BOLA] > 36 && randoLW->Misc[MISC_BOLA] < 48) randoLW->Y = randoLW->Y+2;
						if (randoLW->Misc[MISC_BOLA] > 47) randoLW->Y = randoLW->Y+3;
						if (randoLW->Dir == DIR_RIGHT) ++randoLW->X;
						if (randoLW->Dir == DIR_LEFT) --randoLW->X;
						if (randoLW->Y < 160) randoLW->DeadState = WDS_ALIVE;
					}
		// --- End
				}
			}

// --------------------------------------- Chapter 18: Every-frame LWeapon checks / for loop of Lweapons (end)



// --------------------------------------- Chapter 19: Item: Armos (start)
// See also item script "ItemCreatesLWeapon", and the "Can be pushed by Armos LWeapons" section of Somaria Pushblocks.

			if (ArmosFriend->isValid())
			{
		// --- Remember Armos location when leaving and returning to screen
				if (EverySix == 1)
				{
					if (RememberArmos[REMEMBER_ARMOS_SCREEN] != Game->GetCurScreen()) RememberArmos[REMEMBER_ARMOS_SCREEN] = Game->GetCurScreen();
					if (RememberArmos[REMEMBER_ARMOS_MAP] != Game->GetCurMap()) RememberArmos[REMEMBER_ARMOS_MAP] = Game->GetCurMap();
					if (RememberArmos[REMEMBER_ARMOS_X] != ArmosFriend->X) RememberArmos[REMEMBER_ARMOS_X] = ArmosFriend->X;
					if (RememberArmos[REMEMBER_ARMOS_Y] != ArmosFriend->Y) RememberArmos[REMEMBER_ARMOS_Y] = ArmosFriend->Y;
				}
		// --- Armos activation
				if (ArmosStatus[FRIEND_SNOOZE] == 0)
				{
					if (ArmosStatus[FRIEND_TIMER] == 0) ArmosStatus[FRIEND_TIMER] = 62;
					else if (ArmosStatus[FRIEND_TIMER] > 2) --ArmosStatus[FRIEND_TIMER];
					if (ArmosStatus[FRIEND_TIMER] == 2)
					{
						ArmosStatus[FRIEND_STARTX] = ArmosFriend->X;
						ArmosStatus[FRIEND_STARTY] = ArmosFriend->Y;
						ArmosStatus[FRIEND_LINK_STARTX] = Link->X;
						ArmosStatus[FRIEND_LINK_STARTY] = Link->Y;
						ArmosStatus[FRIEND_TIMER] = 1;
						ArmosFriend->UseSprite(SP_ARMOS);
					}

		// --- Armos moves
					else if (ArmosStatus[FRIEND_TIMER] == 1)
					{
						ArmosFriend->Dir = Link->Dir;
						ArmosStatus[FRIEND_GOX] = ArmosStatus[FRIEND_STARTX] - (ArmosStatus[FRIEND_LINK_STARTX] - Link->X);
						ArmosStatus[FRIEND_GOY] = ArmosStatus[FRIEND_STARTY] - (ArmosStatus[FRIEND_LINK_STARTY] - Link->Y);

						if (ArmosFriend->Y > ArmosStatus[FRIEND_GOY] && ArmosFriend->Y > 8)
						{
							//if (CanWalk(ArmosFriend->X,ArmosFriend->Y,DIR_UP,1,false)) 
							// Note: using CanWalk was more accurate, but I wanted the Armos to walk over half-solid combos for puzzle purposes.
							if (Screen->ComboS[ComboAt(ArmosFriend->X+7,ArmosFriend->Y-1)] != 1111b)
							{
								// Doesn't go up in sideview unless on a ladder
								if (!IsSideview() || Screen->ComboT[ComboAt(ArmosFriend->X+7,ArmosFriend->Y+8)] == CT_SIDECLIMB || Screen->ComboT[ComboAt(ArmosFriend->X+7,ArmosFriend->Y+16)] == CT_SIDECLIMB) --ArmosFriend->Y;
							}
						}
						if (ArmosFriend->Y < ArmosStatus[FRIEND_GOY] && ArmosFriend->Y < 152)
						{
							//if (CanWalk(ArmosFriend->X,ArmosFriend->Y,DIR_DOWN,1,false))
							if (Screen->ComboS[ComboAt(ArmosFriend->X+7,ArmosFriend->Y+17)] != 1111b)
							{
								 ++ArmosFriend->Y;
							}
						}
						if (ArmosFriend->X > ArmosStatus[FRIEND_GOX] && ArmosFriend->X > 8)
						{
							//if (CanWalk(ArmosFriend->X,ArmosFriend->Y,DIR_LEFT,1,false))
							if (Screen->ComboS[ComboAt(ArmosFriend->X-1,ArmosFriend->Y+8)] != 1111b)
							{
								 --ArmosFriend->X;
							}
						}
						if (ArmosFriend->X < ArmosStatus[FRIEND_GOX] && ArmosFriend->X < 232)
						{
							//if (CanWalk(ArmosFriend->X,ArmosFriend->Y,DIR_RIGHT,1,false))
							if (Screen->ComboS[ComboAt(ArmosFriend->X+17,ArmosFriend->Y+8)] != 1111b)
							{
								++ArmosFriend->X;
							}
						}

		// --- Armos deactivation
						if (Link->PressB && GetEquipmentB() == I_ARMOS || Link->PressA && GetEquipmentA() == I_ARMOS)
						{
							ArmosStatus[FRIEND_TIMER] = 0;
							ArmosStatus[FRIEND_SNOOZE] = 1;
							ArmosFriend->UseSprite(SP_ARMOSSLEEP);
							ArmosFriend->CSet = Screen->ComboC[ComboAt(ArmosFriend->X+7,ArmosFriend->Y+8)];
							Game->PlaySound(SFX_PLACE);
						}
					}

		// --- Armos falls in sideview...
					if (IsSideview())
					{
						if (CanWalk(ArmosFriend->X,ArmosFriend->Y,DIR_DOWN,1,false) || Screen->ComboS[ComboAt(ArmosFriend->X+7,ArmosFriend->Y+17)] != 1111b)
						{
		// ...unless the Armos is on a ladder
							if (Screen->ComboT[ComboAt(ArmosFriend->X+7,ArmosFriend->Y+8)] != CT_SIDECLIMB && Screen->ComboT[ComboAt(ArmosFriend->X+7,ArmosFriend->Y+17)] != CT_SIDECLIMB)
							{
								++ArmosFriend->Y;
								if (Screen->ComboS[ComboAt(ArmosFriend->X+7,ArmosFriend->Y+18)] == 0) ++ArmosFriend->Y;
							}
						}
		// Armos also falls off screen in Sideview
						if (ArmosFriend->Y >= 160)
						{
							ArmosFriend->Y = ArmosFriend->Y + 2;
							if (ArmosFriend->Y >= 176)
							{
								Remove(ArmosFriend);
								RememberArmos[REMEMBER_ARMOS_X] = ArmosFriend->X;
								RememberArmos[REMEMBER_ARMOS_Y] = ArmosFriend->Y;
								ArmosStatus[FRIEND_TIMER] = 0;
								ArmosStatus[FRIEND_SNOOZE] = 1;
							}
						}
					}
				}

		// --- Armos reactivation
				else if (Link->PressB && GetEquipmentB() == I_ARMOS || Link->PressA && GetEquipmentA() == I_ARMOS)
				{
					ArmosFriend->UseSprite(SP_ARMOSWAKE);
					ArmosStatus[FRIEND_TIMER] = 24;
					ArmosStatus[FRIEND_SNOOZE] = 0;
					Game->PlaySound(SFX_WAND);
						
				}
		// --- Armos HP
				if (ArmosFriend->DeadState != WDS_ALIVE)
				{
					{
						if (ArmosStatus[FRIEND_HP] > 0)
						{
							ArmosFriend->DeadState = WDS_ALIVE;
							ArmosFriend->CollDetection = 0;
							ArmosFriend->Misc[MISC_TEMPNOCOLLIDELW] = 60;
							ArmosStatus[FRIEND_IFRAMES] = 60;
							Game->PlaySound(SFX_MSG);
							--ArmosStatus[FRIEND_HP];
						}
						else if (NumLWeaponsOf(LW_SPARKLE) == 0)
						{
							lweapon ArmosBye = CreateLWeaponAt(LW_SPARKLE,ArmosFriend->X,ArmosFriend->Y);
							ArmosBye->UseSprite(SP_MISC_DEATH);
							RememberArmos[REMEMBER_ARMOS_MAP] = 0;
						}
					}
				}
				if (ArmosStatus[FRIEND_IFRAMES] > 0)
				{
					--ArmosStatus[FRIEND_IFRAMES];
					Screen->FastTile(3,
						ArmosFriend->X,
						ArmosFriend->Y + ArmosFriend->DrawYOffset, 
						ArmosFriend->Tile,
						Choose(7,8),128);
				}
			}

		// --- Look for a valid Armos
			else
			{
				if (NumLWeaponsOf(LW_ARMOS) > 0) ArmosFriend = LoadLWeaponOf(LW_ARMOS);
				if (EverySix == 1)
				{
					if (Game->GetCurScreen() == RememberArmos[REMEMBER_ARMOS_SCREEN])
					{
						if (Game->GetCurMap() == RememberArmos[REMEMBER_ARMOS_MAP])
						{
							ArmosFriend = CreateLWeaponAt(LW_ARMOS,RememberArmos[REMEMBER_ARMOS_X],RememberArmos[REMEMBER_ARMOS_Y]);
							ArmosFriend->Damage = 4;
							ArmosFriend->UseSprite(SP_ARMOSSLEEP);
							ArmosFriend->CSet = Screen->ComboC[ComboAt(ArmosFriend->X+7,ArmosFriend->Y+8)];
							ArmosStatus[FRIEND_TIMER] = 0;
							ArmosStatus[FRIEND_SNOOZE] = 1;
						}
					}
				}
			}


			if (ArmosStatus[FRIEND_TIMER] > 0 || ArmosStatus[FRIEND_SNOOZE] > 0)
			{
				if (NumLWeaponsOf(LW_ARMOS) == 0)
				{
					ArmosStatus[FRIEND_TIMER] = 0;
					ArmosStatus[FRIEND_HP] = 2;
					ArmosStatus[FRIEND_SNOOZE] = 0;
				}
			}
// --------------------------------------- Chapter 19: Item: Armos (end)


// --------------------------------------- Chapter 20: Item: Pegasus Boots (start)
	// ----- Horse graphics (Alternate Item Graphics mode)
			if (Link->Item[I_ITEMSGFX] && Game->Counter[CR_WEATHER] != ENV_BLOCKY && DoDraw && Link->Action != LA_SCROLLING)
			{
				if (GetEquipmentB() == I_PEGASUS || GetEquipmentA() == I_PEGASUS || PegasusTimer != 0)
				{
					if (Link->Dir == DIR_UP)
					{
						if (Link->Action == LA_WALKING)
						{
							 Screen->DrawCombo(
							3,
							Link->X,
							Link->Y-16-Link->Z,
							COMBO_HORSE+4,
							1,
							2,
							6,
							-1,
							-1,
							0,
							0,
							0,
							FLIP_NONE,
							FLIP_NONE,
							true,
							128);
							if (EverySix > 2) Link->DrawYOffset = -8;
							else Link->DrawYOffset = -7;
						}

						else
						{
							Screen->DrawCombo(
							3,
							Link->X,
							Link->Y-16-Link->Z,
							COMBO_HORSE,
							1,
							2,
							6,
							-1,
							-1,
							0,
							0,
							0,
							FLIP_NONE,
							FLIP_NONE,
							true,
							128);
							Link->DrawYOffset = -8;
						}
					}
					else if (Link->Dir == DIR_DOWN)
					{
						if (Link->Action == LA_WALKING)
						{
							Screen->DrawCombo(
							3,
							Link->X,
							Link->Y-16-Link->Z,
							COMBO_HORSE+5,
							1,
							2,
							6,
							-1,
							-1,
							0,
							0,
							0,
							FLIP_NONE,
							FLIP_NONE,
							true,
							128);

							if (EverySix > 2) Link->DrawYOffset = -8;
							else Link->DrawYOffset = -7;
						}

						else
						{
							Screen->DrawCombo(
							3,
							Link->X,
							Link->Y-16-Link->Z,
							COMBO_HORSE+1,
							1,
							2,
							6,
							-1,
							-1,
							0,
							0,
							0,
							FLIP_NONE,
							FLIP_NONE,
							true,
							128);
							Link->DrawYOffset = -8;
						}
					}
					else if (Link->Dir == DIR_LEFT)
					{
						if (Link->Action == LA_WALKING)
						{
							{
								Screen->DrawCombo(
								3,
								Link->X-10,
								Link->Y-16-Link->Z,
								COMBO_HORSE+8,
								1,
								2,
								6,
								-1,
								-1,
								0,
								0,
								0,
								FLIP_NONE,
								FLIP_NONE,
								true,
								128);
	
								Screen->DrawCombo(
								3,
								Link->X+6,
								Link->Y-16-Link->Z,
								COMBO_HORSE+9,
								1,
								2,
								6,
								-1,
								-1,
								0,
								0,
								0,
								FLIP_NONE,
								FLIP_NONE,
								true,
								128);
								//if (EverySix > 2) Link->DrawYOffset = -8;
								//else Link->DrawYOffset = -7;
								Link->DrawYOffset = -8;
							}
						}

						else
						{
							Screen->DrawCombo(
							3,
							Link->X-9,
							Link->Y-16-Link->Z,
							COMBO_HORSE+2,
							2,
							2,
							6,
							-1,
							-1,
							0,
							0,
							0,
							FLIP_NONE,
							FLIP_NONE,
							true,
							128);
							Link->DrawYOffset = -8;
						}
					}
					else if (Link->Dir == DIR_RIGHT)
					{

						if (Link->Action == LA_WALKING)
						{
							Screen->DrawCombo(
							3,
							Link->X-6,
							Link->Y-16-Link->Z,
							COMBO_HORSE+10,
							1,
							2,
							6,
							-1,
							-1,
							0,
							0,
							0,
							FLIP_NONE,
							FLIP_NONE,
							true,
							128);

							Screen->DrawCombo(
							3,
							Link->X+10,
							Link->Y-16-Link->Z,
							COMBO_HORSE+11,
							1,
							2,
							6,
							-1,
							-1,
							0,
							0,
							0,
							FLIP_NONE,
							FLIP_NONE,
							true,
							128);

							//if (EverySix > 2) Link->DrawYOffset = -8;
							//else Link->DrawYOffset = -7;
							Link->DrawYOffset = -8;
						}
						else
						{
							Screen->DrawCombo(
							3,
							Link->X-7,
							Link->Y-16-Link->Z,
							COMBO_HORSE+3,
							2,
							2,
							6,
							-1,
							-1,
							0,
							0,
							0,
							FLIP_NONE,
							FLIP_NONE,
							true,
							128);

							Link->DrawYOffset = -8;
						}
					}
				}
				else if (Link->DrawYOffset == -8 || Link->DrawYOffset == -7) Link->DrawYOffset = 0;
			}
			else if (Link->DrawYOffset == -8 || Link->DrawYOffset == -7) Link->DrawYOffset = 0;
	// ---- End of Horse graphics



	// ----- Super Pegasus Boots (Lanmola) direction-changing
			if (Link->Item[I_SUPERPEGASUS] && PegasusTimer > 0 && PegasusTimer < 100)
			{
				if (Link->PressUp && Link->Dir != DIR_DOWN)
				{
					Link->Dir = DIR_UP;
					PegasusDir = DIR_UP;
				}
				if (Link->PressDown && Link->Dir != DIR_UP)
				{
					Link->Dir = DIR_DOWN;
					PegasusDir = DIR_DOWN;
				}
				if (Link->PressLeft && Link->Dir != DIR_RIGHT)
				{
					Link->Dir = DIR_LEFT;
					PegasusDir = DIR_LEFT;
				}
				if (Link->PressRight && Link->Dir != DIR_LEFT)
				{
					Link->Dir = DIR_RIGHT;
					PegasusDir = DIR_RIGHT;
				}
			}

	// ----- Can't dash on CF_PEGASTOP flag / getting hurt stops dash
			if (Screen->ComboF[ComboAt(Link->X+7,Link->Y+8)] == CF_PEGASTOP || Screen->ComboI[ComboAt(Link->X+7,Link->Y+8)] == CF_PEGASTOP || Link->Action == LA_GOTHURTLAND)
			{
				PegasusTimer = 0;
				Link->PressEx1 = false;
				Link->InputEx1 = false;
				if (GetEquipmentB() == I_PEGASUS)
				{
					Link->PressB = false;
					Link->InputB = false;
				}
				if (GetEquipmentA() == I_PEGASUS)
				{
					Link->PressA = false;
					Link->InputA = false;
				}
			}

	// ----- Pegasus Boot delay before dashing
			if (Link->InputB && GetEquipmentB() == I_PEGASUS || Link->InputA && GetEquipmentA() == I_PEGASUS || Link->Item[I_PEGASUS] && Link->InputEx1)
			{
				if (Link->Jump == 0)
				{
					if (PegasusTimer < 20 && Screen->ComboS[ComboAt(Link->X+7,Link->Y+8)] == 0 && DoDraw && Link->Action != LA_SCROLLING && Screen->ComboF[ComboAt(Link->X+7,Link->Y+8)] != CF_PEGASTOP && Screen->ComboI[ComboAt(Link->X+7,Link->Y+8)] != CF_PEGASTOP)
					{
						++PegasusTimer;				
						if (!Link->Item[I_SUPERPEGASUS]) NoAction();					
						if (!(PegasusTimer%6))
						{
							if (Link->X < 235 && Link->X > 4 && Link->Y > 4 && Link->Y < 155)
							{
								Game->PlaySound(SFX_PEGASUS);
								lweapon BootDust = CreateLWeaponAt(LW_SPARKLE,Choose(Link->X-4,Link->X+4),Link->Y+12);
								if (BootDust->isValid()) BootDust->UseSprite(SP_PEGASUSDUST);
							}
						}
					}
				}
				if (PegasusTimer == 16)
				{
					PegasusDir = Link->Dir;
					PegasusTimer = 48;
				}
				if (!Link->Item[I_SUPERPEGASUS])
				{
					if (Link->PressUp && Link->Dir != DIR_UP || Link->PressDown && Link->Dir != DIR_DOWN || Link->PressLeft && Link->Dir != DIR_LEFT || Link->PressRight && Link->Dir != DIR_RIGHT) PegasusTimer = 0;
				}
			}
			else if (PegasusTimer < 40 && PegasusTimer > 0) PegasusTimer = 0;

	// ----- Pegasus Boots dashing
			if (PegasusTimer >= 48 && PegasusTimer != 100  && Link->Action != LA_SCROLLING && ModeMenu[MODEMENU_ON] == 0 && Screen->ComboF[ComboAt(Link->X+7,Link->Y+8)] != CF_PEGASTOP && Screen->ComboI[ComboAt(Link->X+7,Link->Y+8)] != CF_PEGASTOP)
			{
				if (!(PegasusTimer%6)) Game->PlaySound(SFX_PEGASUS);
				if (!(PegasusTimer%4))
				{
					if (Link->Item[I_SUPERPEGASUS])
					{
						lweapon BootDust = CreateLWeaponAt(LW_LANMOLA,Link->X,Link->Y+4);
						if (BootDust->isValid())
						{
							BootDust->Damage = 4;
							BootDust->UseSprite(SP_LANMOLATAIL);
							BootDust->Misc[MISC_LWTIMEOUT] = 48;
						}
					}
					else
					{
						lweapon BootDust = CreateLWeaponAt(LW_SPARKLE,Link->X,Link->Y+12);
						if (BootDust->isValid()) BootDust->UseSprite(SP_PEGASUSDUST);
					}
				}
				if (Link->Item[I_SUPERPEGASUS])
				{
					if (!BootStab->isValid())
					{
						BootStab = LoadLWeaponOf(LW_LANMOLA);
						if (BootStab->isValid())
						{
							BootStab->UseSprite(SP_LANMOLAHEAD);
							BootStab->Damage = 8;
						}
					}
					else
					{
						BootStab->Misc[MISC_LWTIMEOUT] = 48;
						BootStab->DeadState = WDS_ALIVE;
						if (Link->Dir == DIR_UP)
						{
							BootStab->X = Link->X;
							BootStab->Y = Link->Y - 8;
						}
						if (Link->Dir == DIR_DOWN)
						{
							BootStab->X = Link->X;
							BootStab->Y = Link->Y + 16;
						}
						if (Link->Dir == DIR_LEFT)
						{
							BootStab->X = Link->X-8;
							BootStab->Y = Link->Y+4;
						}
						if (Link->Dir == DIR_RIGHT)
						{
							BootStab->X = Link->X+8;
							BootStab->Y = Link->Y+4;
						}
					}
				}

				if (PegasusTimer == 54) PegasusTimer = 48;
				else ++PegasusTimer;
	// ----- Dash up
				if (PegasusDir == DIR_UP)
				{
					if (!IsSideview())
					{
						//if (Screen->ComboS[ComboAt(Link->X+7,Link->Y-1)] == 0 && Screen->ComboS[ComboAt(Link->X+8,Link->Y-1)] == 0)
						if (CanWalk(Link->X,Link->Y,DIR_UP,1,false) || Link->Y < 2)
						{
							if (Screen->ComboT[ComboAt(Link->X+7,Link->Y+8)] != CT_SLOWWALK) --Link->Y;
						}
						else{
							if (Screen->ComboT[ComboAt(Link->X+7,Link->Y-1)] == CT_PEGASUSOBSTACLE || Screen->ComboT[ComboAt(Link->X+8,Link->Y-1)] == CT_PEGASUSOBSTACLE)
							{
								if (Screen->ComboF[ComboAt(Link->X+8,Link->Y-1)] == CF_PEGASUSSECRET)
								{
									Screen->ComboD[ComboAt(Link->X+8,Link->Y-1)] = Screen->RoomData;
									Game->PlaySound(27);
									PegasusBonk();
									if (RememberStuff[REMEMBER_BONKS] < 65535) ++ RememberStuff[REMEMBER_BONKS];
									PegasusTimer = 100;
								} 
								else if (Screen->ComboT[ComboAt(Link->X+8,Link->Y-1)] == CT_PEGASUSOBSTACLE) 
								{
									Screen->ComboD[ComboAt(Link->X+8,Link->Y-1)] = Screen->UnderCombo;
									Screen->ComboF[ComboAt(Link->X+8,Link->Y-1)] = CF_NONE;
								}
								if (Screen->ComboF[ComboAt(Link->X+7,Link->Y-1)] == CF_PEGASUSSECRET)
								{
									Screen->ComboD[ComboAt(Link->X+7,Link->Y-1)] = Screen->RoomData;
									Game->PlaySound(27);
									PegasusBonk();
									if (RememberStuff[REMEMBER_BONKS] < 65535) ++ RememberStuff[REMEMBER_BONKS];
									PegasusTimer = 100;
								}
								else if (Screen->ComboT[ComboAt(Link->X+7,Link->Y-1)] == CT_PEGASUSOBSTACLE)
								{
									 Screen->ComboD[ComboAt(Link->X+7,Link->Y-1)] = Screen->UnderCombo;
									 Screen->ComboF[ComboAt(Link->X+7,Link->Y-1)] = CF_NONE;
								}
								PegasusShrapnel();								
							}
							else{
								PegasusBonk();
								if (RememberStuff[REMEMBER_BONKS] < 65535) ++ RememberStuff[REMEMBER_BONKS];
								PegasusTimer = 100;
							}
						}
					}
					Link->InputUp = true;
					if (Link->PressDown || !Link->Item[I_SUPERPEGASUS] && Link->PressLeft || !Link->Item[I_SUPERPEGASUS] && Link->PressRight) PegasusTimer = 0;
				}
	// ----- Dash down
				if (PegasusDir == DIR_DOWN)
				{
					if (CanWalk(Link->X,Link->Y,DIR_DOWN,1,false) || Link->Y > 158)
					//if (Screen->ComboS[ComboAt(Link->X+7,Link->Y+17)] == 0 && Screen->ComboS[ComboAt(Link->X+8,Link->Y+17)] == 0)
					{
						if (Screen->ComboT[ComboAt(Link->X+7,Link->Y+8)] != CT_SLOWWALK) ++Link->Y;
					}
					else{
						if (Screen->ComboT[ComboAt(Link->X+7,Link->Y+17)] == CT_PEGASUSOBSTACLE || Screen->ComboT[ComboAt(Link->X+8,Link->Y+17)] == CT_PEGASUSOBSTACLE)
						{
							if (Screen->ComboF[ComboAt(Link->X+7,Link->Y+17)] == CF_PEGASUSSECRET)
							{
								Screen->ComboD[ComboAt(Link->X+7,Link->Y+17)] = Screen->RoomData;
								Game->PlaySound(27);
								PegasusBonk();
								if (RememberStuff[REMEMBER_BONKS] < 65535) ++ RememberStuff[REMEMBER_BONKS];
								PegasusTimer = 100;
							}
							else if (Screen->ComboT[ComboAt(Link->X+7,Link->Y+17)] == CT_PEGASUSOBSTACLE)
							{
								Screen->ComboD[ComboAt(Link->X+7,Link->Y+17)] = Screen->UnderCombo;
								Screen->ComboF[ComboAt(Link->X+7,Link->Y+17)] = CF_NONE;
							}

							if (Screen->ComboF[ComboAt(Link->X+8,Link->Y+17)] == CF_PEGASUSSECRET)
							{
								Screen->ComboD[ComboAt(Link->X+8,Link->Y+17)] = Screen->RoomData;
								Game->PlaySound(27);
								PegasusBonk();
								if (RememberStuff[REMEMBER_BONKS] < 65535) ++ RememberStuff[REMEMBER_BONKS];
								PegasusTimer = 100;
							}
							else if (Screen->ComboT[ComboAt(Link->X+8,Link->Y+17)] == CT_PEGASUSOBSTACLE)
							{
								Screen->ComboD[ComboAt(Link->X+8,Link->Y+17)] = Screen->UnderCombo;
								Screen->ComboF[ComboAt(Link->X+8,Link->Y+17)] = CF_NONE;
							}

							PegasusShrapnel();
						}
						else{
							PegasusBonk();
							if (RememberStuff[REMEMBER_BONKS] < 65535) ++ RememberStuff[REMEMBER_BONKS];
							PegasusTimer = 100;
						}
					}
					Link->InputDown = true;
					if (Link->PressUp || !Link->Item[I_SUPERPEGASUS] && Link->PressLeft || !Link->Item[I_SUPERPEGASUS] && Link->PressRight) PegasusTimer = 0;
				}
	// ----- Dash left
				if (PegasusDir == DIR_LEFT)
				{
					//if (Screen->ComboS[ComboAt(Link->X-1,Link->Y+8)] == 0 && Screen->ComboS[ComboAt(Link->X-1, Link->Y+12)] == 0)
					if (CanWalk(Link->X,Link->Y,DIR_LEFT,1,false) || Link->X < 2)
					{
						if (Screen->ComboT[ComboAt(Link->X+7,Link->Y+8)] != CT_SLOWWALK) --Link->X;
					}
					else{
						if (Screen->ComboT[ComboAt(Link->X-1,Link->Y+8)] == CT_PEGASUSOBSTACLE || Screen->ComboT[ComboAt(Link->X-1, Link->Y+12)] == CT_PEGASUSOBSTACLE)
						{

							if (Screen->ComboF[ComboAt(Link->X-1,Link->Y+8)] == CF_PEGASUSSECRET)
							{
								Screen->ComboD[ComboAt(Link->X-1,Link->Y+8)] = Screen->RoomData;
								Game->PlaySound(27);
								PegasusBonk();
								if (RememberStuff[REMEMBER_BONKS] < 65535) ++ RememberStuff[REMEMBER_BONKS];
								PegasusTimer = 100;
							}
							else if (Screen->ComboT[ComboAt(Link->X-1,Link->Y+8)] == CT_PEGASUSOBSTACLE)
							{
								Screen->ComboD[ComboAt(Link->X-1,Link->Y+8)] = Screen->UnderCombo;
								Screen->ComboF[ComboAt(Link->X-1,Link->Y+8)] = CF_NONE;
							}

							if (Screen->ComboF[ComboAt(Link->X-1, Link->Y+12)] == CF_PEGASUSSECRET)
							{
								Screen->ComboD[ComboAt(Link->X-1, Link->Y+12)] = Screen->RoomData;
								Game->PlaySound(27);
								PegasusBonk();
								if (RememberStuff[REMEMBER_BONKS] < 65535) ++ RememberStuff[REMEMBER_BONKS];
								PegasusTimer = 100;
							}
							else if (Screen->ComboT[ComboAt(Link->X-1, Link->Y+12)] == CT_PEGASUSOBSTACLE)
							{
								Screen->ComboD[ComboAt(Link->X-1, Link->Y+12)] = Screen->UnderCombo;
								Screen->ComboF[ComboAt(Link->X-1, Link->Y+12)] = CF_NONE;
							}

							PegasusShrapnel();
						}
						else
						{
							PegasusBonk();
							if (RememberStuff[REMEMBER_BONKS] < 65535) ++ RememberStuff[REMEMBER_BONKS];
							PegasusTimer = 100;
						}
					}
					Link->InputLeft = true;
					if (Link->PressRight || !Link->Item[I_SUPERPEGASUS] && Link->PressUp || !Link->Item[I_SUPERPEGASUS] && Link->PressDown) PegasusTimer = 0;
				}
	// ----- Dash right
				if (PegasusDir == DIR_RIGHT)
				{
					//if (Screen->ComboS[ComboAt(Link->X+17,Link->Y+8)] == 0 && Screen->ComboS[ComboAt(Link->X+17, Link->Y+12)] == 0)
					if (CanWalk(Link->X,Link->Y,DIR_RIGHT,1,false) || Link->X > 238)
					{
						if (Screen->ComboT[ComboAt(Link->X+7,Link->Y+8)] != CT_SLOWWALK) ++Link->X;
					}
					else{
						if (Screen->ComboT[ComboAt(Link->X+17,Link->Y+8)] == CT_PEGASUSOBSTACLE || Screen->ComboT[ComboAt(Link->X+17, Link->Y+12)] == CT_PEGASUSOBSTACLE)
						{
							if (Screen->ComboF[ComboAt(Link->X+17,Link->Y+8)] == CF_PEGASUSSECRET)
							{ 
								Screen->ComboD[ComboAt(Link->X+17,Link->Y+8)] = Screen->RoomData;
								Game->PlaySound(27);
								PegasusBonk();
								if (RememberStuff[REMEMBER_BONKS] < 65535) ++ RememberStuff[REMEMBER_BONKS];
								PegasusTimer = 100;
							}
							else if (Screen->ComboT[ComboAt(Link->X+17,Link->Y+8)] == CT_PEGASUSOBSTACLE) 
							{
								Screen->ComboD[ComboAt(Link->X+17,Link->Y+8)] = Screen->UnderCombo;
								Screen->ComboF[ComboAt(Link->X+17,Link->Y+8)] = CF_NONE;
							}

							if (Screen->ComboF[ComboAt(Link->X+17, Link->Y+12)] == CF_PEGASUSSECRET)
							{ 
								Screen->ComboD[ComboAt(Link->X+17, Link->Y+12)] = Screen->RoomData;
								Game->PlaySound(27);
								PegasusBonk();
								if (RememberStuff[REMEMBER_BONKS] < 65535) ++ RememberStuff[REMEMBER_BONKS];
								PegasusTimer = 100;
							}
							else if (Screen->ComboT[ComboAt(Link->X+17, Link->Y+12)] == CT_PEGASUSOBSTACLE) 
							{
								Screen->ComboD[ComboAt(Link->X+17, Link->Y+12)] = Screen->UnderCombo;
								Screen->ComboF[ComboAt(Link->X+17, Link->Y+12)] = CF_NONE;
							}


							PegasusShrapnel();
						}
						else
						{
							PegasusBonk();
							if (RememberStuff[REMEMBER_BONKS] < 65535) ++ RememberStuff[REMEMBER_BONKS];
							PegasusTimer = 100;
						}
					}
					Link->InputRight = true;
					if (Link->PressLeft || !Link->Item[I_SUPERPEGASUS] && Link->PressUp || !Link->Item[I_SUPERPEGASUS] && Link->PressDown) PegasusTimer = 0;
				}
			}

	// ----- Pegasus bonk moves Link (Zelda)
			if (PegasusTimer == 100)
			{
				if (Link->Z > 0 || IsSideview())
				{
					if (ModeMenu[MODEMENU_ON] == 0)
					{
						NoAction();
						if (IsSideview())
						{
							if(Link->Dir == DIR_UP) PushLink(DIR_DOWN);
							else if(Link->Dir == DIR_DOWN) PushLink(DIR_UP);
							else if(Link->Dir == DIR_LEFT) PushLink(DIR_RIGHT);
							else if(Link->Dir == DIR_RIGHT) PushLink(DIR_LEFT);
							if (RopeWeapon->isValid())
							{
								if (LinkCollision(RopeWeapon)) PegasusTimer = 0;
							}
							if (Link->Action == LA_DROWNING || Link->Action == LA_GOTHURTLAND) PegasusTimer = 0;
							if (PegasusFailSafeTimer > 1) --PegasusFailSafeTimer;
							else
							{
								if (PegasusFailSafeTimer == 0) PegasusFailSafeTimer = 480;
								else
								{
									PegasusTimer = 0;
									PegasusFailSafeTimer = 0;
								}
							}
						}
						else
						{
							if(Link->Dir == DIR_UP) PushLink(DIR_DOWN);
							else if(Link->Dir == DIR_DOWN) PushLink(DIR_UP);
							else if(Link->Dir == DIR_LEFT) PushLink(DIR_RIGHT);
							else if(Link->Dir == DIR_RIGHT) PushLink(DIR_LEFT);
						}
					}
				}
				else PegasusTimer = 0;
				if (IsSideview())
				{
					if (Link->Jump == 0)
					{
						 if (Screen->ComboS[ComboAt(Link->X+7,Link->Y+17)] == 1111b || Screen->ComboT[ComboAt(Link->X+7,Link->Y+8)] == CT_SIDECLIMB || Screen->ComboS[ComboAt(Link->X+7,Link->Y-1)] != 0) PegasusTimer = 0; 
					}
				}
			}

			if (PegasusDir != Link->Dir) PegasusDir = Link->Dir;
// --------------------------------------- Chapter 20: Item: Pegasus Boots (end)


// --------------------------------------- Chapter 21: Item: Cane of Somaria and Item: Handy Glove (start)
// Both in one section because they share the LW_SWORD weapon.
// See also: Chapter 22: Somaria pushblocks 

			if (Link->Item[I_HANDYGLOVE])
			{
				if (NumLWeaponsOf(LW_ARROW) > 0)
				{
					if (!GloveWeapon->isValid()) GloveWeapon = LoadLWeaponOf(LW_ARROW);
					else
					{
						if (GloveWeapon->ID != LW_ARROW) GloveWeapon = LoadLWeaponOf(LW_ARROW);
						else if (Screen->ComboT[ComboAt(GloveWeapon->X+7,GloveWeapon->Y+8)] == CT_HANDYBLOCK)
						{
							Game->PlaySound(SFX_SHATTERING);
							lweapon BlockPoof = CreateLWeaponAt(LW_SPARKLE,ComboX(ComboAt(GloveWeapon->X+7,GloveWeapon->Y+8)),ComboY(ComboAt(GloveWeapon->X+7,GloveWeapon->Y+8)));
							BlockPoof->UseSprite(SP_SPAWN);
							Screen->ComboD[ComboAt(GloveWeapon->X+7,GloveWeapon->Y+8)] = Screen->UnderCombo;
							GloveWeapon->DeadState = WDS_ARROW;
						}
					}
				}
				else if (NumLWeaponsOf(LW_BOMBBLAST) > 0)
				{
					if (!GloveWeapon->isValid()) GloveWeapon = LoadLWeaponOf(LW_BOMBBLAST);
					else
					{
						if (GloveWeapon->ID != LW_BOMBBLAST) GloveWeapon = LoadLWeaponOf(LW_BOMBBLAST);
						else
						{
							if (Screen->ComboT[ComboAt(GloveWeapon->X+7,GloveWeapon->Y+8)] == CT_HANDYBLOCK)
							{
								Game->PlaySound(SFX_SHATTERING);
								Screen->ComboD[ComboAt(GloveWeapon->X+7,GloveWeapon->Y+8)] = Screen->UnderCombo;
							}
	
							if (Screen->ComboD[ComboAt(GloveWeapon->X+7,GloveWeapon->Y+8)] == COMBO_SOMARIADOCK)
							{
								{
									++Screen->ComboD[ComboAt(GloveWeapon->X+7,GloveWeapon->Y+8)];
									item SomariaRaft = CreateItemAt(I_SOMARIARAFT,
													ComboX(ComboAt(GloveWeapon->X+7,GloveWeapon->Y+8)),
													ComboY(ComboAt(GloveWeapon->X+7,GloveWeapon->Y+8)));
									SomariaRaft->HitHeight = 8;
									SomariaRaft->HitYOffset = 4;
									Remove(GloveWeapon);
								}
							}
						}
					}
				}
			}
			
			if (NumLWeaponsOf(LW_HAMMER) > 0)
			{
				if (!GloveWeapon->isValid()) GloveWeapon = LoadLWeaponOf(LW_HAMMER);
				else
				{
					if (GloveWeapon->ID != LW_HAMMER) GloveWeapon = LoadLWeaponOf(LW_HAMMER);
					else
					{
						if (Screen->ComboT[ComboAt(GloveWeapon->X+7,GloveWeapon->Y+8)] == CT_HANDYBLOCK)
						{
							Game->PlaySound(SFX_SHATTERING);
							lweapon BlockPoof = CreateLWeaponAt(LW_SPARKLE,ComboX(ComboAt(GloveWeapon->X+7,GloveWeapon->Y+8)),ComboY(ComboAt(GloveWeapon->X+7,GloveWeapon->Y+8)));
							BlockPoof->UseSprite(SP_SPAWN);
							Screen->ComboD[ComboAt(GloveWeapon->X+7,GloveWeapon->Y+8)] = Screen->UnderCombo;
						}
					}
				}
			}


			if (NumLWeaponsOf(LW_SWORD) > 0)
			{
				if (randoLW->ID != LW_SWORD) randoLW = LoadLWeaponOf(LW_SWORD);
	
				if (randoLW->ID == LW_SWORD)
				{
					if (Link->Item[I_HANDYGLOVE])
					{
						if (Screen->ComboT[ComboAt(randoLW->X+7,randoLW->Y+8)] == CT_HANDYBLOCK)
						{
							lweapon BlockPoof = CreateLWeaponAt(LW_SPARKLE,ComboX(ComboAt(randoLW->X+7,randoLW->Y+8)),ComboY(ComboAt(randoLW->X+7,randoLW->Y+8)));
							BlockPoof->UseSprite(SP_SPAWN);
							Game->PlaySound(SFX_SHATTERING);
							Screen->ComboD[ComboAt(randoLW->X+7,randoLW->Y+8)] = Screen->UnderCombo;
						}
					}
					if (Link->Item[19])
					{
						if (Screen->ComboT[ComboAt(randoLW->X+7,randoLW->Y+8)] == CT_PEGASUSOBSTACLE || Screen->ComboT[ComboAt(randoLW->X+7,randoLW->Y+8)] == CT_PEGASUSOBSTACLE)
						{
							if (Screen->ComboF[ComboAt(randoLW->X+7,randoLW->Y+8)] == CF_PEGASUSSECRET)
							{
								Screen->ComboD[ComboAt(randoLW->X+7,randoLW->Y+8)] = Screen->RoomData;
								Game->PlaySound(27);
							}
							else if (Screen->ComboT[ComboAt(randoLW->X+7,randoLW->Y+8)] == CT_PEGASUSOBSTACLE)
							{
								Screen->ComboD[ComboAt(randoLW->X+7,randoLW->Y+8)] = Screen->UnderCombo;
								Screen->ComboF[ComboAt(randoLW->X+7,randoLW->Y+8)] = CF_NONE;
							}

							PegasusShrapnel();
						}
					}
				}
			}

// --------------------------------------- Chapter 21: Item: Cane of Somaria and Item: Handy Glove (end)



// --------------------------------------- Chapter 22: Somaria pushblocks (start)
// Note: Somaia Blocks are created/destroyed by item script "SomariaCane".

			if (NumLWeaponsOf(LW_SOMARIA) > 0)
			{
				if(SomariaBlock->isValid())
				{


					if (SomariaBlock->Step > 0) SomariaBlock->DeadState = WDS_ALIVE;

			// Change color in "World Redecorate" mode
					if (SomariaBlock->CSet == 6)
					{
						if (Link->Item[I_WORLDGFX]) SomariaBlock->CSet = 5;
					}
			// The block falls
					if (IsSideview())
					{
						if (CanWalk(SomariaBlock->X,SomariaBlock->Y,DIR_DOWN,1,false) || SomariaBlock->Y > 158)
						{
							if (SomariaBlock->Y < Link->Y-18 || Link->X < SomariaBlock->X - 12 || Link->X > SomariaBlock->X + 12 || SomariaBlock->Y > Link->Y + 16)
							{
								if (!LinkCollision(SomariaBlock)) SomariaBlock->Y = SomariaBlock->Y + 2;
							}
						}

			// Standing on top of the block
						if (Link->Y < SomariaBlock->Y+8)
						{
							if (LinkCollision(SomariaBlock) && Link->Jump < 0) Link->Jump = 0;
						}
					}

			// Pushing the block
					if (Link->Z == 0)
					{
						if (LinkCollision(SomariaBlock))
						{

							if (Link->Y > SomariaBlock->Y+7 && Link->X > SomariaBlock->X -12 && Link->X < SomariaBlock->X + 12)
							{
								--SomariaBlock->Y;
								SomariaBlock->Dir = DIR_UP;
								if (PegasusTimer > 47 && PegasusTimer < 55)
								{
									SomariaBlock->Step = 255;
									Game->PlaySound(SFX_SOMARIA);
									//PegasusBonk();
									//PegasusTimer = 100;
								}
								PushLink(DIR_DOWN);
							}
							else if (Link->Y < SomariaBlock->Y+8 && Link->X > SomariaBlock->X -12 && Link->X < SomariaBlock->X + 12)
							{
								if (!IsSideview() || Link->InputDown || CanWalk(SomariaBlock->X,SomariaBlock->Y,DIR_DOWN,1,false))
								{
									++SomariaBlock->Y;
									SomariaBlock->Dir = DIR_DOWN;
									if (PegasusTimer > 47 && PegasusTimer < 55)
									{ 
										SomariaBlock->Step = 255;
										Game->PlaySound(SFX_SOMARIA);
										//PegasusBonk();
										//PegasusTimer = 100;
									}
									PushLink(DIR_UP);
								}
							}
							else if (Link->X > SomariaBlock->X+7 && Link->Y > SomariaBlock->Y -14 && Link->Y < SomariaBlock->Y + 12)
							{
								if (!IsSideview() || Link->Y > SomariaBlock->Y-12)
								{
									--SomariaBlock->X;
									SomariaBlock->Dir = DIR_LEFT;
									if (PegasusTimer > 47 && PegasusTimer < 55) 
									{
										SomariaBlock->Step = 255;
										Game->PlaySound(SFX_SOMARIA);
										//PegasusBonk();
										//PegasusTimer = 100;
									}
									PushLink(DIR_RIGHT);
								}
							}
							else if (Link->X < SomariaBlock->X+8 && Link->Y > SomariaBlock->Y -14 && Link->Y < SomariaBlock->Y + 12)
							{
								if (!IsSideview() || Link->Y > SomariaBlock->Y-12)
								{
									++SomariaBlock->X;
									SomariaBlock->Dir = DIR_RIGHT;
									if (PegasusTimer > 47 && PegasusTimer < 55)
									{
										SomariaBlock->Step = 255;
										Game->PlaySound(SFX_SOMARIA);
										//PegasusBonk();
										//PegasusTimer = 100;
									}
									PushLink(DIR_LEFT);
								}
							}
						}
					}
			// Can be pushed by Armos LWeapons
					if (NumLWeaponsOf(LW_ARMOS) > 0)
					{
						if (randoLW->ID != LW_ARMOS) randoLW = LoadLWeaponOf(LW_ARMOS);
						{
							if (randoLW->isValid())
							{
								if (Collision (randoLW,SomariaBlock))
								{
									if (randoLW->Y > SomariaBlock->Y - 8 && randoLW->Y < SomariaBlock->Y + 12)
									{
										if (randoLW->X < SomariaBlock->X+4) ++SomariaBlock->X;
										else if (randoLW->X > SomariaBlock->X+12) --SomariaBlock->X;
									}
									if (randoLW->X > SomariaBlock->X - 8 && randoLW->X < SomariaBlock->X + 12)
									{
										if (randoLW->Y < SomariaBlock->Y+4) ++SomariaBlock->Y;
										else if (randoLW->Y > SomariaBlock->Y+12) --SomariaBlock->Y;
									}
								}
							}
						}
					}
			// Somaria raft docks
					if (Screen->ComboD[ComboAt(SomariaBlock->X+7,SomariaBlock->Y+8)] == COMBO_SOMARIADOCK)
					{
						{
							++Screen->ComboD[ComboAt(SomariaBlock->X+7,SomariaBlock->Y+8)];
							item SomariaRaft = CreateItemAt(I_SOMARIARAFT,
											ComboX(ComboAt(SomariaBlock->X+7,SomariaBlock->Y+8)),
											ComboY(ComboAt(SomariaBlock->X+7,SomariaBlock->Y+8)));
							SomariaRaft->HitHeight = 8;
							SomariaRaft->HitYOffset = 4;
							Remove(SomariaBlock);
						}
					}

				}
				else SomariaBlock = LoadLWeaponOf(LW_SOMARIA);
			}


			// Additional Somaria raft dock behavior

			if (Link->Item[I_SOMARIARAFT])
			{
				if (Link->Action == LA_RAFTING)
				{
					if (Screen->ComboD[ComboAt(Link->X+7,Link->Y+8)] == COMBO_SOMARIADOCK) ++Screen->ComboD[ComboAt(Link->X+7,Link->Y+8)];
				}
				else if (Link->Action == LA_SCROLLING) Link->Item[I_SOMARIARAFT] = false;
			}

// --------------------------------------- Chapter 22: Somaria pushblocks (end)



// --------------------------------------- Chapter 23: Item: Shovel (start)
//
// Maybe this should be redone to launch an FFC script or use functions or something? But it's working as-is.



			if (RememberStuff[REMEMBER_DIGDELAY] == 0 && Link->Action < 3 && DoDraw)
			{
				if (GetEquipmentB() == I_SHOVEL1 && Link->PressB || GetEquipmentA() == I_SHOVEL1 && Link->PressA || GetEquipmentB() == I_SHOVEL2 && Link->PressB || GetEquipmentA() == I_SHOVEL2 && Link->PressA)
				{
					RememberStuff[REMEMBER_DIGDELAY] = 24;
					if (Link->Item[I_BOWWOW])
					{
						if (RememberStuff[REMEMBER_BOWWOWOFF] == 0) RememberStuff[REMEMBER_BOWWOWOFF] = 1;
						else RememberStuff[REMEMBER_BOWWOWOFF] = 0;
					}
				}
			}

			if (RememberStuff[REMEMBER_DIGDELAY] > 0)
			{
				//NoAction();
				if (PegasusTimer == 0) --RememberStuff[REMEMBER_DIGDELAY];
				else RememberStuff[REMEMBER_DIGDELAY] = 1;
			}

			if (RememberStuff[REMEMBER_DIGDELAY] > 12)
			{
				if (PegasusTimer == 0)
				{
					Link->Action = LA_NONE;
					Link->Action = LA_ATTACKING;
				}
				if (Link->Item[I_SHOVEL2])
				{
					if (Link->Dir == DIR_RIGHT) Screen->FastTile(1,Link->X+8,Link->Y+2,SHOVEL_TILE+2,8,128);
					if (Link->Dir == DIR_LEFT) Screen->FastTile(1,Link->X-8,Link->Y+2,SHOVEL_TILE,8,128);
					if (Link->Dir == DIR_UP) Screen->FastTile(1,Link->X+4,Link->Y-4,SHOVEL_TILE+2,8,128);
					if (Link->Dir == DIR_DOWN) Screen->FastTile(3,Link->X,Link->Y+4,SHOVEL_TILE,8,128);
				}
				else
				{
					if (Link->Dir == DIR_RIGHT) Screen->FastTile(1,Link->X+8,Link->Y+2,SHOVEL_TILE+2,7,128);
					if (Link->Dir == DIR_LEFT) Screen->FastTile(1,Link->X-8,Link->Y+2,SHOVEL_TILE,7,128);
					if (Link->Dir == DIR_UP) Screen->FastTile(1,Link->X+4,Link->Y-4,SHOVEL_TILE+2,7,128);
					if (Link->Dir == DIR_DOWN) Screen->FastTile(3,Link->X,Link->Y+4,SHOVEL_TILE,7,128);
				}
			}
			if (RememberStuff[REMEMBER_DIGDELAY] > 0 && RememberStuff[REMEMBER_DIGDELAY] < 13)
			{
				if (Link->Item[I_SHOVEL2])
				{
					if (Link->Dir == DIR_RIGHT) Screen->FastTile(3,Link->X-8,Link->Y-4,SHOVEL_TILE+3,8,128);
					if (Link->Dir == DIR_LEFT) Screen->FastTile(3,Link->X+8,Link->Y-4,SHOVEL_TILE+1,8,128);
					if (Link->Dir == DIR_UP) Screen->FastTile(3,Link->X-8,Link->Y,SHOVEL_TILE+3,8,128);
					if (Link->Dir == DIR_DOWN) Screen->FastTile(3,Link->X+8,Link->Y-2,SHOVEL_TILE+1,8,128);
				}
				else
				{
					if (Link->Dir == DIR_RIGHT) Screen->FastTile(3,Link->X-8,Link->Y-4,SHOVEL_TILE+3,7,128);
					if (Link->Dir == DIR_LEFT) Screen->FastTile(3,Link->X+8,Link->Y-4,SHOVEL_TILE+1,7,128);
					if (Link->Dir == DIR_UP) Screen->FastTile(3,Link->X-8,Link->Y,SHOVEL_TILE+3,7,128);
					if (Link->Dir == DIR_DOWN) Screen->FastTile(3,Link->X+8,Link->Y-2,SHOVEL_TILE+1,7,128);
				}
			}



			if (RememberStuff[REMEMBER_DIGDELAY] == 1)
				{
	// --- Facing Up
				if (Link->Dir == DIR_UP)
				{
					// --- Diggable dirt:
					if (Screen->ComboT[ComboAt(Link->X+7,Link->Y-1)] == CT_DIGDIRT)
					{
						DirtThrow = CreateLWeaponAt(LW_SPARKLE,Link->X,Link->Y-12);
						DirtThrow->X = ComboX(ComboAt(Link->X+7,Link->Y-1));
						DirtThrow->UseSprite(SP_SHOVELDIRT);
						Game->PlaySound(SFX_SHOVEL);

						// --- Dig hidden items:
						if (Screen->ComboF[ComboAt(Link->X+7,Link->Y-1)] == CF_SHOVELITEM && !Screen->State[ST_SPECIALITEM])
						{
							item DugTreasure = CreateItemAt(Screen->RoomData,DirtThrow->X,DirtThrow->Y);
							DugTreasure->Pickup = IP_ST_SPECIALITEM + IP_HOLDUP;
							DugTreasure->Z = 16;
							DugTreasure->Jump = 1.5;
						}

						// --- Dig hidden combos:
						if (Screen->ComboF[ComboAt(Link->X+7,Link->Y-1)] == CF_SHOVELSECRET)
						{
							Game->PlaySound(27);
							Screen->ComboD[ComboAt(Link->X+7,Link->Y-1)] = Screen->RoomData;
						}

						// --- Dig normal dirt:
						else
						{
							if (Screen->ComboS[ComboAt(Link->X+7,Link->Y-1)] != 0) ++Screen->ComboD[ComboAt(Link->X+7,Link->Y-1)];
							else
							{
								DirtThrow->Misc[MISC_SHOVELFIND] = Rand(16);
								if (!IsSideview())
								{
									if (Screen->ComboD[ComboAt(Link->X+7,Link->Y-1)] >= SAND_COMBO_START && Screen->ComboD[ComboAt(Link->X+7,Link->Y-1)] <= SAND_COMBO_END) Screen->ComboD[ComboAt(Link->X+7,Link->Y-1)] = SAND_POTHOLE;
									else Screen->ComboD[ComboAt(Link->X+7,Link->Y-1)] = SHOVEL_POTHOLE;
								}
								else Screen->ComboD[ComboAt(Link->X+7,Link->Y-1)] = Screen->UnderCombo;

								// --- Magical Bean Leevers
								if (Link->Item[I_SHOVEL2])
								{
									if (NumLWeaponsOf(LW_LEEVER) < 8)
									{
										randoLW = CreateLWeaponAt(LW_LEEVER,ComboX(ComboAt(Link->X+7,Link->Y-1)),ComboY(ComboAt(Link->X+7,Link->Y-1)));
										randoLW->UseSprite(SP_LEEVER);
										randoLW->CSet = Screen->ComboC[ComboAt(Link->X+7,Link->Y-1)];
										randoLW->Damage = 4;	
										randoLW = CreateLWeaponAt(LW_WHISTLE,0,0);
									}
								}	
							}
						}
					}

					// --- Can't dig:
					else if (PegasusTimer == 0) Game->PlaySound(SFX_CLINK);
				}

	// --- Facing Down
				if (Link->Dir == DIR_DOWN)
				{
					if (Screen->ComboT[ComboAt(Link->X+7,Link->Y+17)] == CT_DIGDIRT)
					{
						DirtThrow = CreateLWeaponAt(LW_SPARKLE,Link->X,Link->Y+16);
						DirtThrow->X = ComboX(ComboAt(Link->X+7,Link->Y+17));
						DirtThrow->UseSprite(SP_SHOVELDIRT);
						Game->PlaySound(SFX_SHOVEL);
						// --- Dig hidden items:
						if (Screen->ComboF[ComboAt(Link->X+7,Link->Y+17)] == CF_SHOVELITEM && !Screen->State[ST_SPECIALITEM])
						{
							item DugTreasure = CreateItemAt(Screen->RoomData,DirtThrow->X,DirtThrow->Y);
							DugTreasure->Pickup = IP_ST_SPECIALITEM + IP_HOLDUP;
							DugTreasure->Z = 16;
							DugTreasure->Jump = 1.5;
						}

						// --- Dig hidden combos:
						if (Screen->ComboF[ComboAt(Link->X+7,Link->Y+17)] == CF_SHOVELSECRET)
						{
							Game->PlaySound(27);
							Screen->ComboD[ComboAt(Link->X+7,Link->Y+17)] = Screen->RoomData;
						}

						// --- Dig normal dirt:
						else
						{
							if (Screen->ComboS[ComboAt(Link->X+7,Link->Y+17)] != 0) ++Screen->ComboD[ComboAt(Link->X+7,Link->Y+17)];
							else
							{
								DirtThrow->Misc[MISC_SHOVELFIND] = Rand(16);
								if (!IsSideview())
								{
									if (Screen->ComboD[ComboAt(Link->X+7,Link->Y+17)] >= SAND_COMBO_START && Screen->ComboD[ComboAt(Link->X+7,Link->Y+17)] <= SAND_COMBO_END) Screen->ComboD[ComboAt(Link->X+7,Link->Y+17)] = SAND_POTHOLE;
									else Screen->ComboD[ComboAt(Link->X+7,Link->Y+17)] = SHOVEL_POTHOLE;
								}
								else Screen->ComboD[ComboAt(Link->X+7,Link->Y+17)] = Screen->UnderCombo;

								// --- Magical Bean Leevers
								if (Link->Item[I_SHOVEL2])
								{
									if (NumLWeaponsOf(LW_LEEVER) < 8)
									{
										randoLW = CreateLWeaponAt(LW_LEEVER,ComboX(ComboAt(Link->X+7,Link->Y+17)),ComboY(ComboAt(Link->X+7,Link->Y+17)));
										randoLW->UseSprite(SP_LEEVER);
										randoLW->CSet = Screen->ComboC[ComboAt(Link->X+7,Link->Y+17)];
										randoLW->Damage = 4;	
										randoLW = CreateLWeaponAt(LW_WHISTLE,0,0);
									}
								}
							}
						}
					}

					// --- Can't dig:
					else if (PegasusTimer == 0) Game->PlaySound(SFX_CLINK);
				}

	// --- Facing Left
				if (Link->Dir == DIR_LEFT)
				{
					if (Screen->ComboT[ComboAt(Link->X-1,Link->Y+8)] == CT_DIGDIRT)
					{
						DirtThrow = CreateLWeaponAt(LW_SPARKLE,Link->X-16,Link->Y);
						DirtThrow->Y = ComboY(ComboAt(Link->X-1,Link->Y+8));
						DirtThrow->UseSprite(SP_SHOVELDIRT);
						Game->PlaySound(SFX_SHOVEL);

						// --- Dig hidden items:
						if (Screen->ComboF[ComboAt(Link->X-1,Link->Y+8)] == CF_SHOVELITEM && !Screen->State[ST_SPECIALITEM])
						{
							item DugTreasure = CreateItemAt(Screen->RoomData,DirtThrow->X,DirtThrow->Y);
							DugTreasure->Pickup = IP_ST_SPECIALITEM + IP_HOLDUP;
							DugTreasure->Z = 16;
							DugTreasure->Jump = 1.5;
						}

						// --- Dig hidden combos:
						if (Screen->ComboF[ComboAt(Link->X-1,Link->Y+8)] == CF_SHOVELSECRET)
						{
							Game->PlaySound(27);
							Screen->ComboD[ComboAt(Link->X-1,Link->Y+8)] = Screen->RoomData;
						}

						// --- Dig normal dirt:
						else
						{
							if (Screen->ComboS[ComboAt(Link->X-1,Link->Y+8)] != 0) ++Screen->ComboD[ComboAt(Link->X-1,Link->Y+8)];
							else
							{
								DirtThrow->Misc[MISC_SHOVELFIND] = Rand(16);
								if (!IsSideview())
								{
									if (Screen->ComboD[ComboAt(Link->X-1,Link->Y+8)] >= SAND_COMBO_START && Screen->ComboD[ComboAt(Link->X-1,Link->Y+8)] <= SAND_COMBO_END) Screen->ComboD[ComboAt(Link->X-1,Link->Y+8)] = SAND_POTHOLE;
									else Screen->ComboD[ComboAt(Link->X-1,Link->Y+8)] = SHOVEL_POTHOLE;
								}
								else Screen->ComboD[ComboAt(Link->X-1,Link->Y+8)] = Screen->UnderCombo;

								// --- Magical Bean Leevers
								if (Link->Item[I_SHOVEL2])
								{
									if (NumLWeaponsOf(LW_LEEVER) < 8)
									{
										randoLW = CreateLWeaponAt(LW_LEEVER,ComboX(ComboAt(Link->X-1,Link->Y+8)),ComboY(ComboAt(Link->X-1,Link->Y+8)));
										randoLW->UseSprite(SP_LEEVER);
										randoLW->CSet = Screen->ComboC[ComboAt(Link->X-1,Link->Y+8)];
										randoLW->Damage = 4;
										randoLW = CreateLWeaponAt(LW_WHISTLE,0,0);
									}
								}
							}
						}
					}

					// --- Can't dig:
					else if (PegasusTimer == 0) Game->PlaySound(SFX_CLINK);
				}
	// --- Facing Right
				if (Link->Dir == DIR_RIGHT)
				{
					if (Screen->ComboT[ComboAt(Link->X+17,Link->Y+8)] == CT_DIGDIRT)
					{
						DirtThrow = CreateLWeaponAt(LW_SPARKLE,Link->X+16,Link->Y);
						DirtThrow->Y = ComboY(ComboAt(Link->X+17,Link->Y+8));
						DirtThrow->UseSprite(SP_SHOVELDIRT);
						Game->PlaySound(SFX_SHOVEL);

						// --- Dig hidden items:
						if (Screen->ComboF[ComboAt(Link->X+17,Link->Y+8)] == CF_SHOVELITEM && !Screen->State[ST_SPECIALITEM])
						{
							item DugTreasure = CreateItemAt(Screen->RoomData,DirtThrow->X,DirtThrow->Y);
							DugTreasure->Pickup = IP_ST_SPECIALITEM + IP_HOLDUP;
							DugTreasure->Z = 16;
							DugTreasure->Jump = 1.5;
						}

						// --- Dig hidden combos:
						if (Screen->ComboF[ComboAt(Link->X+17,Link->Y+8)] == CF_SHOVELSECRET)
						{
							Game->PlaySound(27);
							Screen->ComboD[ComboAt(Link->X+17,Link->Y+8)] = Screen->RoomData;
						}
						// --- Dig normal dirt:
						else
						{
							if (Screen->ComboS[ComboAt(Link->X+17,Link->Y+8)] != 0) ++Screen->ComboD[ComboAt(Link->X+17,Link->Y+8)];
							else
							{
								DirtThrow->Misc[MISC_SHOVELFIND] = Rand(16);
								if (!IsSideview())
								{
									if (Screen->ComboD[ComboAt(Link->X+17,Link->Y+8)] >= SAND_COMBO_START && Screen->ComboD[ComboAt(Link->X+17,Link->Y+8)] <= SAND_COMBO_END) Screen->ComboD[ComboAt(Link->X+17,Link->Y+8)] = SAND_POTHOLE;
									else Screen->ComboD[ComboAt(Link->X+17,Link->Y+8)] = SHOVEL_POTHOLE;
								}
								else Screen->ComboD[ComboAt(Link->X+17,Link->Y+8)] = Screen->UnderCombo;

								// --- Magical Bean Leevers
								if (Link->Item[I_SHOVEL2])
								{	
									if (NumLWeaponsOf(LW_LEEVER) < 8)
									{
									randoLW = CreateLWeaponAt(LW_LEEVER,ComboX(ComboAt(Link->X+17,Link->Y+8)),ComboY(ComboAt(Link->X+17,Link->Y+8)));
									randoLW->UseSprite(SP_LEEVER);
									randoLW->CSet = Screen->ComboC[ComboAt(Link->X+17,Link->Y+8)];
									randoLW->Damage = 4;
									randoLW = CreateLWeaponAt(LW_WHISTLE,0,0);
									}
								}
							}
						}
					}

					// --- Can't dig:
					else if (PegasusTimer == 0) Game->PlaySound(SFX_CLINK);
				}

	// --- Shovel spawns random items
				if (DirtThrow->isValid() && !IsSideview())
				{
					if (DirtThrow->Misc[MISC_SHOVELFIND] >12)
					{
						item DigFound = CreateItemAt(Choose(I_RUPEE1,I_RUPEE1,I_RUPEE1,I_HEART,I_HEART),DirtThrow->X,DirtThrow->Y);
						DigFound->Pickup = IP_TIMEOUT;
						DigFound->Z = 16;
						DigFound->Jump = 1.5;
						DirtThrow->Misc[MISC_SHOVELFIND] = 0;
					}
					if (DirtThrow->Misc[MISC_SHOVELFIND] >= 11 && DirtThrow->Misc[MISC_SHOVELFIND] <= 12)
					{
						item DigFound = CreateItemAt(Choose(I_HEARTTWO,Choose(I_HEARTTWO,I_NEGAHEART,I_RUPEE1),Choose(I_HEARTTWO,I_NEGAHEART),Choose(I_RUPEE1,I_RUPEE5),Choose(I_RUPEE5,I_RUPEE10),Choose(I_NEGAHEART,I_HEART,I_HEARTTWO,I_FAIRY)),DirtThrow->X,DirtThrow->Y);
						DigFound->Pickup = IP_TIMEOUT;
						if (DigFound->ID != I_FAIRY)
						{
							DigFound->Z = 16;
							DigFound->Jump = 1.5;
						}
						else DigFound->Y = DigFound->Y - 16;
						if (DigFound->Y < 1) DigFound->Y = 8;
						DirtThrow->Misc[MISC_SHOVELFIND] = 0;
					}
					if (DirtThrow->Misc[MISC_SHOVELFIND] == 1)
					{
						DirtThrow->Misc[MISC_SHOVELFIND] = Choose (0,0,0,0,0,1);
						if (DirtThrow->Misc[MISC_SHOVELFIND] == 1)
						{
							item DigFound = CreateItemAt(Choose(I_RUPEE1,I_RUPOOR),DirtThrow->X,DirtThrow->Y);
							DigFound->Z = 16;
							DigFound->Jump = 1.5;
							DigFound->Pickup = IP_TIMEOUT;
						}
					}
				}
			}

// --------------------------------------- Chapter 23: Item: Shovel (end)



// --------------------------------------- Chapter 24: Item: Rope (start)
// An item to walk across solid combos, within certain limitations (similar to ladder).
// NOTE: Rope is created and removed via the Item script "RopeItem".

			if (NumLWeaponsOf(LW_ROPE) > 0 && DoDraw)
			{
				if (!RopeWeapon->isValid()) RopeWeapon = LoadLWeaponOf(LW_ROPE);
				else
				{
					// --- Locked doors kill Rope lweapons
					if (Screen->ComboT[ComboAt(RopeWeapon->X+7,RopeWeapon->Y+8)] == CT_LOCKBLOCK || Screen->ComboT[ComboAt(RopeWeapon->X+7,RopeWeapon->Y+8)] == CT_LOCKBLOCK2 || Screen->ComboT[ComboAt(RopeWeapon->X+7,RopeWeapon->Y+8)] == CT_BOSSLOCKBLOCK || Screen->ComboT[ComboAt(RopeWeapon->X+7,RopeWeapon->Y+8)] == CT_BOSSLOCKBLOCK2)
					{
						lweapon GoPoof = CreateLWeaponAt(LW_SPARKLE,RopeWeapon->X,RopeWeapon->Y);
						GoPoof->UseSprite(SP_MISC_DEATH);
						Remove(RopeWeapon);
					}

					// No collision with enemies

					// I_ROPE1 and I_ROPE2 only allow walking across "Water", "Ladder Only", or "Ladder + Hookshot" combos.
					// I_ROPE3 and I_ROPE4 allow walking across any solid combos.
					if (Link->Item[I_ROPE3] || Link->Item[I_ROPE4] || Screen->ComboT[ComboAt(RopeWeapon->X+7,RopeWeapon->Y+8)] == CT_WATER || Screen->ComboT[ComboAt(RopeWeapon->X+7,RopeWeapon->Y+8)] == CT_LADDERONLY || Screen->ComboT[ComboAt(RopeWeapon->X+7,RopeWeapon->Y+8)] == CT_LADDERHOOKSHOT || Screen->ComboF[ComboAt(RopeWeapon->X+7,RopeWeapon->Y+8)] == CF_ROPE || Screen->ComboI[ComboAt(RopeWeapon->X+7,RopeWeapon->Y+8)] == CF_ROPE)
					{
						if (RopeWeapon->Dir == DIR_LEFT || RopeWeapon->Dir == DIR_RIGHT)
						{
							if (RopeWeapon->X > 8 && RopeWeapon->X < 248)
							{
								if (RopeWeapon->TileWidth == 2 && RopeWeapon->X < 232 || RopeWeapon->TileWidth == 1)
								{
									if (LinkCollision(RopeWeapon))
									{
										if (RopeWeapon->TileWidth == 1)
										{
											// Combo solidity must be 0 on both sides in order to walk:
											if (Screen->ComboS[ComboAt(RopeWeapon->X-1,RopeWeapon->Y+7)] == 0 && Screen->ComboS[ComboAt(RopeWeapon->X+17,RopeWeapon->Y+8)] == 0)
											{
												// Rope does nothing if it's on top of a non-solid combo (I've forgotten if this step is actually neccessary):
												if (Screen->ComboS[ComboAt(RopeWeapon->X+7,RopeWeapon->Y+8)] != 0)
												{
													// Link must be a half-tile away or closer to start walking on the rope:
													if (Link->Y > RopeWeapon->Y - 9 && Link->Y < RopeWeapon->Y + 9)
													{
														if (Link->InputRight)
														{
															// Link's movement is only assisted if Link is attempting to walk onto a solid combo.
															if (Screen->ComboS[ComboAt(Link->X+17,Link->Y+8)] != 0 || Screen->ComboS[ComboAt(Link->X+12,Link->Y+8)] != 0) 
															{
																++Link->X;
																// Link is aligned with the rope:
																Link->Y = RopeWeapon->Y;
															}
														}
														if (Link->InputLeft)
														{
															if (Screen->ComboS[ComboAt(Link->X-1,Link->Y+8)] != 0 || Screen->ComboS[ComboAt(Link->X+4,Link->Y+8)] != 0) 
															{
																--Link->X;
																Link->Y = RopeWeapon->Y;
															}
														}
													}
												}
											}
											if (Screen->ComboS[ComboAt(RopeWeapon->X+7,RopeWeapon->Y-1)] == 0 && Screen->ComboS[ComboAt(RopeWeapon->X+7,RopeWeapon->Y+17)] == 0)
											{
												if (Screen->ComboS[ComboAt(RopeWeapon->X+7,RopeWeapon->Y+8)] != 0)
												{
													if (Link->X > RopeWeapon->X - 9 && Link->X < RopeWeapon->X + 9)
													{
														if (Link->InputDown)
														{
															if (Screen->ComboS[ComboAt(Link->X+7,Link->Y+17)] != 0 || Screen->ComboS[ComboAt(Link->X+7,Link->Y+4)] != 0) 
															{
																++Link->Y;
																Link->X = RopeWeapon->X;
															}
														}
														if (Link->InputUp)
														{
															if (Screen->ComboS[ComboAt(Link->X+7,Link->Y-1)] != 0 || Screen->ComboS[ComboAt(Link->X+7,Link->Y+12)] != 0)
															{
																--Link->Y;
																Link->X = RopeWeapon->X;
															}
														}
													}
												}
											}
										}
										if (RopeWeapon->TileWidth == 2)
										{
											if (Screen->ComboS[ComboAt(RopeWeapon->X-1,RopeWeapon->Y+8)] == 0 && Screen->ComboS[ComboAt(RopeWeapon->X+33,RopeWeapon->Y+8)] == 0)
											{
												if (Screen->ComboS[ComboAt(RopeWeapon->X+7,RopeWeapon->Y+8)] != 0 || Screen->ComboS[ComboAt(RopeWeapon->X+23,RopeWeapon->Y+8)] != 0)
												{
													if (Link->Y > RopeWeapon->Y - 9 && Link->Y < RopeWeapon->Y + 9)
													{
														if (Link->InputRight)
														{
															if (Screen->ComboS[ComboAt(Link->X+17,Link->Y+8)] != 0 || Screen->ComboS[ComboAt(Link->X+12,Link->Y+8)] != 0)
															{ 
																++Link->X;
																Link->Y = RopeWeapon->Y;
															}
														}
														if (Link->InputLeft)
														{
															if (Screen->ComboS[ComboAt(Link->X-1,Link->Y+8)] != 0 || Screen->ComboS[ComboAt(Link->X+4,Link->Y+8)] != 0)
															{
																--Link->X;
																Link->Y = RopeWeapon->Y;
															}
														}
													}
												}
											}
											if (Screen->ComboS[ComboAt(RopeWeapon->X+7,RopeWeapon->Y-1)] == 0 && Screen->ComboS[ComboAt(RopeWeapon->X+7,RopeWeapon->Y-1)] == 0)
											{
												if (Screen->ComboS[ComboAt(RopeWeapon->X+7,RopeWeapon->Y+8)] != 0 || Screen->ComboS[ComboAt(RopeWeapon->X+23,RopeWeapon->Y+8)] != 0)
												{
													if (Link->X > RopeWeapon->X - 9 && Link->X < RopeWeapon->X + 9)
													{
														if (Link->InputDown)
														{
															if (Screen->ComboS[ComboAt(Link->X+7,Link->Y+17)] != 0 || Screen->ComboS[ComboAt(Link->X+7,Link->Y+4)] != 0)
															{
																++Link->Y;
																Link->X = RopeWeapon->X;
															}
														}
														if (Link->InputUp)
														{
															if (Screen->ComboS[ComboAt(Link->X+7,Link->Y-1)] != 0 || Screen->ComboS[ComboAt(Link->X+7,Link->Y+12)] != 0) 
															{
																--Link->Y;
																Link->X = RopeWeapon->X;
															}
														}
													}
												}
											}
											if (Screen->ComboS[ComboAt(RopeWeapon->X+23,RopeWeapon->Y-1)] == 0 && Screen->ComboS[ComboAt(RopeWeapon->X+23,RopeWeapon->Y-1)] == 0)
											{
												if (Screen->ComboS[ComboAt(RopeWeapon->X+7,RopeWeapon->Y+8)] != 0 || Screen->ComboS[ComboAt(RopeWeapon->X+23,RopeWeapon->Y+8)] != 0)
												{
													if (Link->X > RopeWeapon->X + 9 && Link->X < RopeWeapon->X + 25)
													{
														if (Link->InputDown)
														{
															if (Screen->ComboS[ComboAt(Link->X+7,Link->Y+17)] != 0 || Screen->ComboS[ComboAt(Link->X+7,Link->Y+4)] != 0) 
															{
																++Link->Y;
																Link->X = RopeWeapon->X+16;
															}
														}
														if (Link->InputUp)
														{
															if (Screen->ComboS[ComboAt(Link->X+7,Link->Y-1)] != 0 || Screen->ComboS[ComboAt(Link->X+7,Link->Y+12)] != 0) 
															{
																--Link->Y;
																Link->X = RopeWeapon->X+16;
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}

						if (RopeWeapon->Dir == DIR_UP || RopeWeapon->Dir == DIR_DOWN)
						{
							if (RopeWeapon->Y > 8 && RopeWeapon->Y < 152)
							{
								if (RopeWeapon->TileHeight == 2 && RopeWeapon->Y < 136 || RopeWeapon->TileHeight == 1)
								{
									if (LinkCollision(RopeWeapon))
									{
										if (RopeWeapon->TileHeight == 1)
										{
											if (Screen->ComboS[ComboAt(RopeWeapon->X+7,RopeWeapon->Y-1)] == 0 && Screen->ComboS[ComboAt(RopeWeapon->X+7,RopeWeapon->Y+17)] == 0)
											{
												if (Screen->ComboS[ComboAt(RopeWeapon->X+7,RopeWeapon->Y+8)] != 0)
												{
													if (Link->X > RopeWeapon->X - 9 && Link->X < RopeWeapon->X + 9)
													{
														if (Link->InputDown)
														{
															if (Screen->ComboS[ComboAt(Link->X+7,Link->Y+17)] != 0 || Screen->ComboS[ComboAt(Link->X+7,Link->Y+4)] != 0)
															{
																++Link->Y;
																Link->X = RopeWeapon->X;
															}
														}

														if (Link->InputUp)
														{
															if (Screen->ComboS[ComboAt(Link->X+7,Link->Y-1)] != 0 || Screen->ComboS[ComboAt(Link->X+7,Link->Y+12)] != 0) 
															{
																--Link->Y;
																Link->X = RopeWeapon->X;
															}
														}
													}
												}
											}
											if (Screen->ComboS[ComboAt(RopeWeapon->X-1,RopeWeapon->Y+8)] == 0 && Screen->ComboS[ComboAt(RopeWeapon->X+17,RopeWeapon->Y+8)] == 0)
											{
												if (Screen->ComboS[ComboAt(RopeWeapon->X+7,RopeWeapon->Y+8)] != 0)
												{
													if (Link->Y > RopeWeapon->Y - 9 && Link->Y < RopeWeapon->Y + 9)
													{
														if (Link->InputRight)
														{
															if (Screen->ComboS[ComboAt(Link->X+17,Link->Y+8)] != 0 || Screen->ComboS[ComboAt(Link->X+12,Link->Y+8)] != 0)
															{
																++Link->X;
																Link->Y = RopeWeapon->Y;
															}
														}
														if (Link->InputLeft)
														{
															if (Screen->ComboS[ComboAt(Link->X-1,Link->Y+8)] != 0 || Screen->ComboS[ComboAt(Link->X+4,Link->Y+8)] != 0)
															{
																--Link->X;
																Link->Y = RopeWeapon->Y;
															}
														}
													}
												}
											}
										}
										if (RopeWeapon->TileHeight == 2)
										{
											if (Screen->ComboS[ComboAt(RopeWeapon->X+7,RopeWeapon->Y-1)] == 0 && Screen->ComboS[ComboAt(RopeWeapon->X+7,RopeWeapon->Y+33)] == 0)
											{
												if (Screen->ComboS[ComboAt(RopeWeapon->X+7,RopeWeapon->Y+8)] != 0 || Screen->ComboS[ComboAt(RopeWeapon->X+7,RopeWeapon->Y+24)] != 0)
												{
													if (Link->X > RopeWeapon->X - 9 && Link->X < RopeWeapon->X + 9)
													{
														if (Link->InputDown)
														{
															if (Screen->ComboS[ComboAt(Link->X+7,Link->Y+17)] != 0 || Screen->ComboS[ComboAt(Link->X+7,Link->Y+4)] != 0)
															{
																++Link->Y;
																Link->X = RopeWeapon->X;
															}
														}
														if (Link->InputUp)
														{
															if (Screen->ComboS[ComboAt(Link->X+7,Link->Y-1)] != 0 || Screen->ComboS[ComboAt(Link->X+7,Link->Y+12)] != 0) 
															{
																--Link->Y;
																Link->X = RopeWeapon->X;
															}
														}
													}
												}
											}
											if (Screen->ComboS[ComboAt(RopeWeapon->X-1,RopeWeapon->Y+8)] == 0 && Screen->ComboS[ComboAt(RopeWeapon->X+17,RopeWeapon->Y+8)] == 0)
											{
												if (Screen->ComboS[ComboAt(RopeWeapon->X+7,RopeWeapon->Y+8)] != 0 || Screen->ComboS[ComboAt(RopeWeapon->X+7,RopeWeapon->Y+24)] != 0)
												{
													if (Link->Y > RopeWeapon->Y-9 && Link->Y < RopeWeapon->Y + 9)
													{
														if (Link->InputRight)
														{
															if (Screen->ComboS[ComboAt(Link->X+17,Link->Y+8)] != 0 || Screen->ComboS[ComboAt(Link->X+12,Link->Y+8)] != 0) 
															{
																++Link->X;
																Link->Y = RopeWeapon->Y;
															}
														}
														if (Link->InputLeft)
														{
															if (Screen->ComboS[ComboAt(Link->X-1,Link->Y+8)] != 0 || Screen->ComboS[ComboAt(Link->X+4,Link->Y+8)] != 0) 
															{
																--Link->X;
																Link->Y = RopeWeapon->Y;
															}
														}
													}
												}
											}
											if (Screen->ComboS[ComboAt(RopeWeapon->X-1,RopeWeapon->Y+24)] == 0 && Screen->ComboS[ComboAt(RopeWeapon->X+17,RopeWeapon->Y+24)] == 0)
											{
												if (Screen->ComboS[ComboAt(RopeWeapon->X+7,RopeWeapon->Y+8)] != 0 || Screen->ComboS[ComboAt(RopeWeapon->X+7,RopeWeapon->Y+24)] != 0)
												{
													if (Link->Y > RopeWeapon->Y+9 && Link->Y < RopeWeapon->Y + 25)
													{
														if (Link->InputRight)
														{
															if (Screen->ComboS[ComboAt(Link->X+17,Link->Y+8)] != 0 || Screen->ComboS[ComboAt(Link->X+12,Link->Y+8)] != 0) 
															{
																++Link->X;
																Link->Y = RopeWeapon->Y+16;
															}
														}
														if (Link->InputLeft)
														{
															if (Screen->ComboS[ComboAt(Link->X-1,Link->Y+8)] != 0 || Screen->ComboS[ComboAt(Link->X+4,Link->Y+8)] != 0) 
															{
																--Link->X;
																Link->Y = RopeWeapon->Y+16;
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}

				if (IsSideview())
				{
					if (RopeWeapon->Y >= 160 - (16 * (RopeWeapon->TileHeight-1))) ++RopeWeapon->Y;
					if (RopeWeapon->TileHeight == 1 && RopeWeapon->TileWidth == 1)
					{
						if (CanWalk(RopeWeapon->X,RopeWeapon->Y,DIR_DOWN,1,true))
						{
							if (!SomariaBlock->isValid() || !Collision(SomariaBlock,RopeWeapon) || RopeWeapon->Y > SomariaBlock->Y) ++RopeWeapon->Y;
						}
					}
					else if (RopeWeapon->TileHeight == 2)
					{
						if (CanWalk(RopeWeapon->X,RopeWeapon->Y+16,DIR_DOWN,1,true))
						{
							if (!SomariaBlock->isValid() || !Collision(SomariaBlock,RopeWeapon) || RopeWeapon->Y+16 > SomariaBlock->Y) ++RopeWeapon->Y;
						}
					}
					else if (RopeWeapon->TileWidth == 2) 
					{
						if (CanWalk(RopeWeapon->X,RopeWeapon->Y,DIR_DOWN,1,true) && CanWalk(RopeWeapon->X+16,RopeWeapon->Y,DIR_DOWN,1,true))
						{
							if (!SomariaBlock->isValid() || !Collision(SomariaBlock,RopeWeapon) || RopeWeapon->Y+16 > SomariaBlock->Y) ++RopeWeapon->Y;
						}
					}
					if (Link->X > RopeWeapon->X-12 && Link->X < RopeWeapon->X+12+(16*(RopeWeapon->TileWidth-1)) && Link->Y > RopeWeapon->Y-16 && Link->Y < RopeWeapon->Y+16*RopeWeapon->TileHeight)
					if (LinkCollision(RopeWeapon))
					{
						Link->Jump = 0;
						if (!Link->InputB && !Link->InputA)
						{
							if (Link->InputUp && CanWalk(Link->X,Link->Y,DIR_UP,1,false) && Link->Y > RopeWeapon->Y-15) --Link->Y;
							else if (Link->InputDown && CanWalk(Link->X,Link->Y,DIR_DOWN,1,false)) ++Link->Y;
						}
					}
				}
				else
				//realign to grid after being moved by Beetle
				{
					if (NumLWeaponsOf(LW_BEETLE) == 0)
					{
						if (RopeWeapon->X != ComboX(ComboAt(RopeWeapon->X+7,RopeWeapon->Y+8))) RopeWeapon->X = ComboX(ComboAt(RopeWeapon->X+7,RopeWeapon->Y+8));
						if (RopeWeapon->Y != ComboY(ComboAt(RopeWeapon->X+7,RopeWeapon->Y+8))) RopeWeapon->Y = ComboY(ComboAt(RopeWeapon->X+7,RopeWeapon->Y+8));
					}
				}
			}

// --------------------------------------- Chapter 24: Item: Rope (end)



// --------------------------------------- Chapter 24.5: Item: Ladder (start)
// Script by Dimi, based on Item: Rope by Mitsukara (see above)
// A passive item that allows climbing up 1 tile in sideview

			if (NumLWeaponsOf(LW_LADDER) > 0 && DoDraw)
			{
				if (!LadderWeapon->isValid()) LadderWeapon = LoadLWeaponOf(LW_LADDER);
				else
				{

					// No collision with enemies

					if (IsSideview())
					{
						if (LadderWeapon->Y >= 160) ++LadderWeapon->Y;
						if (CanWalk(LadderWeapon->X,LadderWeapon->Y,DIR_DOWN,1,true))
						{
							if (!SomariaBlock->isValid() || !Collision(SomariaBlock,LadderWeapon) || LadderWeapon->Y > SomariaBlock->Y) ++LadderWeapon->Y;
						}
						if (Link->X > LadderWeapon->X-12 && Link->X < LadderWeapon->X+12 && Link->Y >= LadderWeapon->Y-18 && Link->Y < LadderWeapon->Y+16*LadderWeapon->TileHeight)
						{
							if (LinkCollision(LadderWeapon) || true)
							{
								Link->Jump = 0;
								if (!Link->InputB && !Link->InputA)
								{
									if (Link->InputUp && CanWalk(Link->X,Link->Y,DIR_UP,1,false) && Link->Y > LadderWeapon->Y-15) --Link->Y;
									else if (Link->InputDown && CanWalk(Link->X,Link->Y,DIR_DOWN,1,false)) ++Link->Y;
								}
							}
						}
						else if (!(Link->X > LadderWeapon->X-12 && Link->X < LadderWeapon->X+12))
						{
							Remove(LadderWeapon);
						}
					}
				}
			}
			else if (IsSideview() && Link->Item[I_LADDER9]) //If Link has the dummy ladder item and it's sideview. Sideview check comes first for short-circuiting purposes.
			{
				if (OnSidePlatform(Link->X, Link->Y) || (SomariaBlock->isValid() && Link->Y >= SomariaBlock->Y - 18 && Link->Y <= SomariaBlock->Y && Link->X >= SomariaBlock->X-14 && Link->X <= SomariaBlock->X+14))
				{
					if (Link->Dir == DIR_UP && Link->InputUp)
					{
						LadderWeapon = NextToLink(LW_LADDER,0);
						LadderWeapon->CollDetection = false;
						if (IsSideview()) LadderWeapon->Y += 16;
						
						LadderWeapon->Dir = DIR_UP;
						LadderWeapon->UseSprite(SP_LADDERVERTICAL);
						LadderWeapon->HitHeight = 18;
						LadderWeapon->HitYOffset = -2;
						LadderWeapon->DrawYOffset = 0;
						LadderWeapon->HitWidth = 16;
					}
				}
			}

// --------------------------------------- Chapter 24.5: Item: Ladder (end)



// --------------------------------------- Chapter 25: Link (Zelda) falls like a rock in sideview (start)
// Deliberately primitive, Lode runner-esque falling movement

			if (Link->Jump < 0)
			{
				if (IsSideview())
				{
					if (Screen->ComboT[ComboAt(Link->X+7,Link->Y+17)] != CT_SIDECLIMB && Screen->ComboT[ComboAt(Link->X+7,Link->Y+8)] != CT_SIDECLIMB)
					{
						if (PegasusTimer == 0)
						{
							if ((!RopeWeapon->isValid() || !LinkCollision(RopeWeapon)) && (!LadderWeapon->isValid() || !LinkCollision(LadderWeapon)))
							{
								if (!FallSound)
								{
									if (Screen->ComboS[ComboAt(Link->X+7,Link->Y+28)] == 0)
									{
										if  (!SomariaBlock->isValid() || Link->Y < SomariaBlock->Y - 18 || Link->Y > SomariaBlock->Y || Link->X < SomariaBlock->X-14 || Link->X > SomariaBlock->X+14)
										{
											if (NumLWeaponsOf(LW_CANEOFBYRNA) == 0) Game->PlaySound(SFX_PLAYERFALL);
											FallSound = true;
										}
									}
								}
								Link->InputLeft = false;
								Link->InputRight = false;
							}
						}
					}
				}
			}
			else if (FallSound) FallSound = false;

// --------------------------------------- Chapter 25: Link (Zelda) falls like a rock in sideview (end)



// --------------------------------------- Chapter 26: Item: Beetle (start)
			if (Link->InputB && GetEquipmentB() == I_BEETLE || Link->InputA && GetEquipmentA() == I_BEETLE || Link->InputB && GetEquipmentB() == I_STRONGBEETLE || Link->InputA && GetEquipmentA() == I_STRONGBEETLE)
			{
				if (!DeadBeetle && DoDraw)
				{
					if (Link->Action < 3)
					{
						Link->Action = LA_NONE;
						Link->Action = LA_ATTACKING;
					}
					if (!Beetle->isValid())
					{
						if (Link->PressB && GetEquipmentB() == I_BEETLE || Link->PressB && GetEquipmentB() == I_STRONGBEETLE || Link->PressA && GetEquipmentA() == I_BEETLE || Link->PressA && GetEquipmentA() == I_STRONGBEETLE)
						{
							Beetle = CreateLWeaponAt(LW_BEETLE,Link->X,Link->Y);
							Game->PlaySound(SFX_BEETLE);
							if (!Link->Item[I_STRONGBEETLE]) Beetle->UseSprite(SP_BEETLE);
							else Beetle->UseSprite(SP_STRONGBEETLE);
							Beetle->Dir = Link->Dir;

							// I dummied out the ->Flip commands when deciding the Beetle would be a Keese, but if you remove the comment lines (//) they will work:
			 				//if (Link->Dir == DIR_UP) Beetle->Flip = FLIP_VERTICAL;
			 				//if (Link->Dir == DIR_LEFT) Beetle->Flip = ROT_CW;
			 				//if (Link->Dir == DIR_RIGHT) Beetle->Flip = ROT_CCW;
						}
					}
	//------ Beetle steering
					if (Link->InputUp)
					{
						Beetle->Dir = DIR_UP;
			 			//if (!BeetleCarrying) Beetle->Flip = FLIP_VERTICAL;
					}
					if (Link->InputDown)
					{
						Beetle->Dir = DIR_DOWN;
						//if (!BeetleCarrying) Beetle->Flip = FLIP_NONE;
					}
					if (Link->InputLeft)
					{
						Beetle->Dir = DIR_LEFT;
						//if (!BeetleCarrying) Beetle->Flip = ROT_CW;
					}
					if (Link->InputRight)
					{
						Beetle->Dir = DIR_RIGHT;
						//if (!BeetleCarrying) Beetle->Flip = ROT_CCW;
					}
					if (Link->InputUp && Link->InputLeft) Beetle->Dir = DIR_LEFTUP;
					if (Link->InputDown && Link->InputLeft) Beetle->Dir = DIR_LEFTDOWN;
					if (Link->InputUp && Link->InputRight) Beetle->Dir = DIR_RIGHTUP;
					if (Link->InputDown && Link->InputRight) Beetle->Dir = DIR_RIGHTDOWN;

					if (Beetle->Dir == DIR_UP)
					{
						if (Beetle->Y > Link->Y-BEETLE_RANGE || Link->Item[I_STRONGBEETLE])
						{
							if (Game->GetCurDMap() >= DMAP_FIRST_DUNGEON && Game->GetCurDMap() <= DMAP_LAST_DUNGEON || Game->GetCurDMap() == DMAP_FAKE_LAST || Game->GetCurDMap() == 54 || Game->GetCurDMap() == 55)
							{
								if (Beetle->Y > 32) --Beetle->Y;
							}
							else if (Beetle->Y > 2) --Beetle->Y;
						}
					}
					else if (Beetle->Dir == DIR_LEFT)
					{
						if (Beetle->X > Link->X-BEETLE_RANGE || Link->Item[I_STRONGBEETLE])
						{
							if (Game->GetCurDMap() >= DMAP_FIRST_DUNGEON && Game->GetCurDMap() <= DMAP_LAST_DUNGEON || Game->GetCurDMap() == DMAP_FAKE_LAST || Game->GetCurDMap() == 54 || Game->GetCurDMap() == 55)
							{
								if (Beetle->X > 32) --Beetle->X;
							}
							else if (Beetle->X > 4) --Beetle->X;
						}
					}
					else if (Beetle->Dir == DIR_RIGHT)
					{
						if (Beetle->X < Link->X+BEETLE_RANGE || Link->Item[I_STRONGBEETLE]) 
						{
							if (Game->GetCurDMap() >= DMAP_FIRST_DUNGEON && Game->GetCurDMap() <= DMAP_LAST_DUNGEON || Game->GetCurDMap() == DMAP_FAKE_LAST || Game->GetCurDMap() == 54 || Game->GetCurDMap() == 55)
							{
								if (Beetle->X < 208) ++Beetle->X;
							}
							else if (Beetle->X < 236) ++Beetle->X;
						}
					}
					else if (Beetle->Dir == DIR_DOWN)
					{
						if (Beetle->Y < Link->Y+BEETLE_RANGE || Link->Item[I_STRONGBEETLE])
						{
							if (Game->GetCurDMap() >= DMAP_FIRST_DUNGEON && Game->GetCurDMap() <= DMAP_LAST_DUNGEON || Game->GetCurDMap() == DMAP_FAKE_LAST || Game->GetCurDMap() == 54 || Game->GetCurDMap() == 55)
							{
								if (Beetle->Y < 128) ++Beetle->Y;
							}
							else if (Beetle->Y < 158) ++Beetle->Y;
						}
					}
					else if (Beetle->Dir == DIR_LEFTUP)
					{
						if (Beetle->X > Link->X-BEETLE_RANGE || Link->Item[I_STRONGBEETLE])
						{
							if (Game->GetCurDMap() >= DMAP_FIRST_DUNGEON && Game->GetCurDMap() <= DMAP_LAST_DUNGEON || Game->GetCurDMap() == DMAP_FAKE_LAST || Game->GetCurDMap() == 54 || Game->GetCurDMap() == 55)
							{
								if (Beetle->X > 32) --Beetle->X;
							}
							else if (Beetle->X > 4) --Beetle->X;
						}
						if (Beetle->Y > Link->Y-BEETLE_RANGE || Link->Item[I_STRONGBEETLE])
						{
							if (Game->GetCurDMap() >= DMAP_FIRST_DUNGEON && Game->GetCurDMap() <= DMAP_LAST_DUNGEON || Game->GetCurDMap() == DMAP_FAKE_LAST || Game->GetCurDMap() == 54 || Game->GetCurDMap() == 55)
							{
								if (Beetle->Y > 32) --Beetle->Y;
							}
							else if (Beetle->Y > 2) --Beetle->Y;
						}
					}
					else if (Beetle->Dir == DIR_LEFTDOWN)
					{
						if (Beetle->X > Link->X-BEETLE_RANGE || Link->Item[I_STRONGBEETLE])
						{
							if (Game->GetCurDMap() >= DMAP_FIRST_DUNGEON && Game->GetCurDMap() <= DMAP_LAST_DUNGEON || Game->GetCurDMap() == DMAP_FAKE_LAST || Game->GetCurDMap() == 54 || Game->GetCurDMap() == 55)
							{
								if (Beetle->X > 32) --Beetle->X;
							}
							else if (Beetle->X > 4) --Beetle->X;
						}
						if (Beetle->Y < Link->Y+BEETLE_RANGE || Link->Item[I_STRONGBEETLE])
						{
							if (Game->GetCurDMap() >= DMAP_FIRST_DUNGEON && Game->GetCurDMap() <= DMAP_LAST_DUNGEON || Game->GetCurDMap() == DMAP_FAKE_LAST || Game->GetCurDMap() == 54 || Game->GetCurDMap() == 55)
							{
								if (Beetle->Y < 128) ++Beetle->Y;
							}
							else if (Beetle->Y < 158) ++Beetle->Y;
						}
					}
					if (Beetle->Dir == DIR_RIGHTUP && Beetle->X < 236 && Beetle->Y > 4)
					{
						if (Beetle->X < Link->X+BEETLE_RANGE || Link->Item[I_STRONGBEETLE])
						{
							if (Game->GetCurDMap() >= DMAP_FIRST_DUNGEON && Game->GetCurDMap() <= DMAP_LAST_DUNGEON || Game->GetCurDMap() == DMAP_FAKE_LAST || Game->GetCurDMap() == 54 || Game->GetCurDMap() == 55)
							{
								if (Beetle->X < 208) ++Beetle->X;
							}
							else if (Beetle->X < 236) ++Beetle->X;
						}
						if (Beetle->Y > Link->Y-BEETLE_RANGE || Link->Item[I_STRONGBEETLE])
						{
							if (Game->GetCurDMap() >= DMAP_FIRST_DUNGEON && Game->GetCurDMap() <= DMAP_LAST_DUNGEON || Game->GetCurDMap() == DMAP_FAKE_LAST || Game->GetCurDMap() == 54 || Game->GetCurDMap() == 55)
							{
								if (Beetle->Y > 32) --Beetle->Y;
							}
							else if (Beetle->Y > 4) --Beetle->Y;
						}
					}
					if (Beetle->Dir == DIR_RIGHTDOWN)
					{
						if (Beetle->X < Link->X+BEETLE_RANGE || Link->Item[I_STRONGBEETLE]) 
						{
							if (Game->GetCurDMap() >= DMAP_FIRST_DUNGEON && Game->GetCurDMap() <= DMAP_LAST_DUNGEON || Game->GetCurDMap() == DMAP_FAKE_LAST || Game->GetCurDMap() == 54 || Game->GetCurDMap() == 55)
							{
								if (Beetle->X < 208) ++Beetle->X;
							}
							else if (Beetle->X < 236) ++Beetle->X;
						}
						if (Beetle->Y < Link->Y+BEETLE_RANGE || Link->Item[I_STRONGBEETLE])
						{
							if (Game->GetCurDMap() >= DMAP_FIRST_DUNGEON && Game->GetCurDMap() <= DMAP_LAST_DUNGEON || Game->GetCurDMap() == DMAP_FAKE_LAST || Game->GetCurDMap() == 54 || Game->GetCurDMap() == 55)
							{
								if (Beetle->Y < 128) ++Beetle->Y;
							}
							else if (Beetle->Y < 158) ++Beetle->Y;
						}
					}

	//------ Beetle Carries LWeapons
					for(ForTimer = Screen->NumLWeapons(); ForTimer > 0; --ForTimer)
					{
						randoLW = Screen->LoadLWeapon(ForTimer);
						if(!randoLW->isValid()) continue;
						{
							if (randoLW->ID != LW_BOMBBLAST && randoLW->ID != LW_SBOMBBLAST && randoLW->ID != LW_SWORD && randoLW->ID != LW_SPARKLE)
							{
								if (Collision(Beetle,randoLW))
								{
									if (randoLW->ID != LW_BEETLE && randoLW->ID != LW_CANEOFBYRNA && !BeetleCarrying)
									{
										if (randoLW->ID != LW_ROPE || Screen->ComboS[ComboAt(Link->X+7,Link->Y+8)] != 1111b || !LinkCollision(randoLW))
										{
											BeetleCarrying = true;
											Beetle->Flip = FLIP_NONE;
											Beetle->DrawYOffset = -8;
											if (GetEquipmentB() == I_BEETLE || GetEquipmentA() == I_BEETLE) Beetle->UseSprite(SP_BEETLECARRY);
											if (GetEquipmentB() == I_STRONGBEETLE || GetEquipmentA() == I_STRONGBEETLE) Beetle->UseSprite(SP_STRONGCARRY);
											BeetleLW = randoLW;
										}
									}
								}
							}
						}
					}
					if (BeetleLW->ID != LW_BOMBBLAST && BeetleLW->ID != LW_SBOMBBLAST)
					{
						if (Collision(Beetle,BeetleLW))
						{
							BeetleLW->X = Beetle->X;
							BeetleLW->Dir = Beetle->Dir;
							if (!IsSideview() ||BeetleLW->ID != LW_SOMARIA || Link->Item[I_STRONGBEETLE]) 
							{
								BeetleLW->Y = Beetle->Y;
								Beetle->DrawYOffset = -8;
							}
						}
					}
	//------ Beetle Carries EWeapons
					for(ForTimer = Screen->NumEWeapons(); ForTimer > 0; --ForTimer)
					{
						randoEW = Screen->LoadEWeapon(ForTimer);
						if(!randoEW->isValid()) continue;
						{
							if (randoEW->ID != EW_BOMBBLAST && randoEW->ID != EW_SBOMBBLAST)
							{
								if (Collision(Beetle,randoEW))
								{
									if (!BeetleCarrying)
									{
										BeetleCarrying = true;
										Beetle->Flip = FLIP_NONE;
										Beetle->DrawYOffset = -8;
										if (GetEquipmentB() == I_BEETLE || GetEquipmentA() == I_BEETLE) Beetle->UseSprite(SP_BEETLECARRY);
										if (GetEquipmentB() == I_STRONGBEETLE || GetEquipmentA() == I_STRONGBEETLE) Beetle->UseSprite(SP_STRONGCARRY);
										if (randoEW->ID == EW_BOMB)
										{
											BeetleLW = CreateLWeaponAt(LW_BOMB,Beetle->X,Beetle->Y+6);
											BeetleLW->Damage = 6;
											//BeetleLW->CSet = randoEW->CSet;
											Remove(randoEW);
										}
										if (randoEW->ID == EW_SBOMB)
										{
											BeetleLW = CreateLWeaponAt(LW_SBOMB,Beetle->X,Beetle->Y+6);
											BeetleLW->Damage = 10;
											//BeetleLW->CSet = randoEW->CSet;
											Remove(randoEW);
										}
										BeetleEW = randoEW;
									}
								}
							}
						}
					}
					if (Collision(Beetle,BeetleEW))
					{
						BeetleEW->X = Beetle->X;
						BeetleEW->Dir = Beetle->Dir;
						BeetleEW->Y = Beetle->Y+6;

						// Stationary bombs will be turned into LW_BOMBs when their fuse reaches 9998
						if (BeetleEW->ID == EW_STATIONARYBOMB) BeetleEW->Misc[MISC_STATIONARYFUSE] = 10000;

					}

	//------ Beetle Carries Items
					for(ForTimer = Screen->NumItems(); ForTimer > 0; --ForTimer)
					{
						randoitem = Screen->LoadItem(ForTimer);
						if(!randoitem->isValid()) continue;
						{
							if (Collision(Beetle,randoitem))
							{
								if (!BeetleCarrying)
								{
									BeetleCarrying = true;
									Beetle->Flip = FLIP_NONE;
									if (GetEquipmentB() == I_BEETLE || GetEquipmentA() == I_BEETLE) Beetle->UseSprite(SP_BEETLECARRY);
									if (GetEquipmentB() == I_STRONGBEETLE || GetEquipmentA() == I_STRONGBEETLE) Beetle->UseSprite(SP_STRONGCARRY);
									BeetleItem = randoitem;
									Beetle->X = BeetleItem->X;
									Beetle->Y = BeetleItem->Y;
									Beetle->DrawYOffset = -8;
								}
							}
						}
					}
					if (Collision(Beetle,BeetleItem))
					{
						BeetleItem->X = Beetle->X;
						BeetleItem->Y = Beetle->Y+6;
						//if (!IsSideview()) BeetleItem->Z = 5; Unused feature, causes the item to not touch Link when moving near him and to bounce after being dropped
					}
	//------ Beetle realizes it's no longer carrying stuff
					if (BeetleCarrying)
					{
						if (!BeetleLW->isValid() && !BeetleEW->isValid() && !BeetleItem->isValid())
						{
							BeetleCarrying = false;
							Beetle->DrawYOffset = 0;
							if (!Link->Item[I_STRONGBEETLE]) Beetle->UseSprite(SP_BEETLE);
							else Beetle->UseSprite(SP_STRONGBEETLE);
						}
					}
					
	//------ Beetle triggers secrets on Strike (any weapon) flag
					if (Screen->ComboF[ComboAt(Beetle->X+7,Beetle->Y+8)] == CF_STRIKE)
					{
						Screen->TriggerSecrets();
						if (Screen->Flags[SF_SECRETS]&0x0004) Screen->State[ST_SECRET] = true;
						Game->PlaySound(27);
						Beetle->DeadState = WDS_DEAD;
					}
	//------ Beetle Can't pass left or right statue combos
					if (Screen->ComboT[ComboAt(Beetle->X+7,Beetle->Y+8)] == CT_LEFTSTATUE) Beetle->DeadState = WDS_DEAD;
					if (Screen->ComboT[ComboAt(Beetle->X+7,Beetle->Y+8)] == CT_RIGHTSTATUE) Beetle->DeadState = WDS_DEAD;
				}
			}
	//------ Beetle destroyed or deactivated
			else
			{
				if (Beetle->isValid()) Remove(Beetle);
				if (DeadBeetle) DeadBeetle = false;
				if (BeetleCarrying) BeetleCarrying = false;
			}

			if (Beetle->isValid() && Beetle->DeadState != WDS_ALIVE && !DeadBeetle)
			{
				DeadBeetle = true;
				lweapon BeetlePoof = CreateLWeaponAt(LW_SPARKLE,Beetle->X,Beetle->Y);
				BeetlePoof->UseSprite(SP_BEETLEPOOF);
			}

// --------------------------------------- Chapter 26: Item: Beetle (end)



// --------------------------------------- Chapter 27: Change color of first Byrna beam
			if (FirstByrna->isValid())
			{
				if (NumLWeaponsOf(LW_CANEOFBYRNA) > 1)
				{
					if (FirstByrna->CSet != 7) FirstByrna->CSet = 7;
				}
			}
			else
			{
				if (NumLWeaponsOf(LW_CANEOFBYRNA) > 0) FirstByrna = LoadLWeaponOf(LW_CANEOFBYRNA);
			}


// --------------------------------------- Chapter 28: Partner Follower & LTTP Superbomb (start)

			if (Link->Item[I_LTTPSBOMB] || Link->Item[I_PARTNER])
			{
				//if (Link->Action != LA_HOLD1LAND && Link->Action != LA_HOLD2LAND && Link->Action != LA_HOLD1WATER && Link->Action != LA_HOLD2WATER && Screen->ComboS[ComboAt(Link->X+7,Link->Y+8)] != 1111b)
				if (Link->Action != LA_HOLD1LAND && Link->Action != LA_HOLD2LAND && Link->Action != LA_HOLD1WATER && Link->Action != LA_HOLD2WATER || Link->HeldItem != I_LTTPSBOMB)
				{
					if (Partner[FOLLOW_ATIMER] > 0) --Partner[FOLLOW_ATIMER];
					else if (Partner[FOLLOW_ACTION] != 0) Partner[FOLLOW_ACTION] = 0;

					if (Link->PressA)
					{
						if (!Link->Item[I_LTTPSBOMB])
						{
							if (Partner[FOLLOW_ATIMER] == 0 || Partner[FOLLOW_ACTION] == FA_WALKING)
							{
								if (Partner[FOLLOW_STATE] == 0 || Game->GetCurScreen() == Partner[FOLLOW_SCREEN] && Game->GetCurMap() == Partner[FOLLOW_MAP])
								{
									Partner[FOLLOW_ACTION] = FA_ATTACKING;
									Partner[FOLLOW_ATIMER] = 40;
									Partner[FOLLOW_DIR] = Link->Dir;
									lweapon PartnerShot = CreateLWeaponAt(PARTNER_WEAPON,Partner[FOLLOW_X],Partner[FOLLOW_Y]);
									PartnerShot->Dir = Partner[FOLLOW_DIR];
									if (Link->Item[I_SWORD4]) PartnerShot->Damage = 16;
									else if (Link->Item[I_SWORD3] || Link->Item[I_CANE3]) PartnerShot->Damage = 8;
									else if (Link->Item[I_SWORD2] || Link->Item[I_CANE2]) PartnerShot->Damage = 4;
									else if (Link->Item[I_SWORD1] || Link->Item[I_CANE1]) PartnerShot->Damage = 2;
									if (Partner[FOLLOW_DIR] == DIR_DOWN) PartnerShot->Flip = FLIP_VERTICAL;
									else if (Partner[FOLLOW_DIR] == DIR_LEFT)
									{
										PartnerShot->UseSprite(SP_PARTNERSIDEBEAM); //was going to use PartnerShot->Flip = ROT_CW_FLIP; but rotated flips don't display in DrawTile().
										PartnerShot->Flip = FLIP_HORIZONTAL;
									}
									else if (Partner[FOLLOW_DIR] == DIR_RIGHT) PartnerShot->UseSprite(SP_PARTNERSIDEBEAM); //likewise, was going to use PartnerShot->Flip = ROT_CW;
									Game->PlaySound(SFX_BEAM);
								}
							}
						}
					}

					if (Partner[FOLLOW_STATE] == 0)
					{
						if (Link->Action == LA_RAFTING)
						{
							Partner[FOLLOW_X] = Link->X;
							Partner[FOLLOW_Y] = Link->Y;
						}

						if (Link->Item[I_LTTPSBOMB])
						{
							if (Link->PressB || Link->Action == LA_GOTHURTLAND || PegasusTimer != 0)
							{
								if (DoDraw)
								{
									JustDroppedPartner = true;
									Partner[FOLLOW_STATE] = 1;
									Partner[FOLLOW_TIMER] = 511;
									Game->PlaySound(SFX_PLACE);
									Partner[FOLLOW_SCREEN] = Game->GetCurScreen();
									Partner[FOLLOW_MAP] = Game->GetCurMap();
								}
							}	
						}
						else
						{
							if (!ModeMenu[MODEMENU_ON])
							{
								if (DoDraw)
								{
									if (Game->Counter[CR_WEATHER] != ENV_BLOCKY) 
									{
										Screen->DrawString(7, 128, -56, FONT_Z1, 1, 0, TF_NORMAL, TEXT_EX4, OP_OPAQUE);
									}
								}
							}
							if (Link->PressEx4)
							{
								if (DoDraw)
								{
									Partner[FOLLOW_X] = Link->X;
									Partner[FOLLOW_Y] = Link->Y;
									JustDroppedPartner = true;
									Partner[FOLLOW_STATE] = 1;
									Game->PlaySound(SFX_PLACE);
									Partner[FOLLOW_SCREEN] = Game->GetCurScreen();
									Partner[FOLLOW_MAP] = Game->GetCurMap();
								}
							}
						}

						if (Partner[FOLLOW_X] > Link->X + 32 || Partner[FOLLOW_X] < Link->X - 32 || Partner[FOLLOW_Y] > Link->Y + 32 || Partner[FOLLOW_Y] < Link->Y - 32 || Link->Action == LA_SCROLLING)
						{
							Partner[FOLLOW_X] = Link->X;
							Partner[FOLLOW_Y] = Link->Y;
						}
						else
						{
							if (Link->InputUp)
							{
								if (Partner[FOLLOW_ACTION] == 0) Partner[FOLLOW_ACTION] = FA_WALKING;
								else if (Partner[FOLLOW_ACTION] == FA_WALKING) Partner[FOLLOW_ATIMER] = 12;

								if (Partner[FOLLOW_X] > Link->X && CanWalk(Partner[FOLLOW_X],Partner[FOLLOW_Y],DIR_LEFT,1,false))
								{
									--Partner[FOLLOW_X];
									if (PegasusTimer >= 48) --Partner[FOLLOW_X]; 
									if (Link->Action < LA_ATTACKING) Partner[FOLLOW_DIR] = DIR_LEFT;
								}
								if (Partner[FOLLOW_X] < Link->X && CanWalk(Partner[FOLLOW_X],Partner[FOLLOW_Y],DIR_RIGHT,1,false)) 
								{
									++Partner[FOLLOW_X];
									if (PegasusTimer >= 48) ++Partner[FOLLOW_X];
									if (Link->Action < LA_ATTACKING) Partner[FOLLOW_DIR] = DIR_RIGHT;
								}
								if (Partner[FOLLOW_Y] > Link->Y+16 && CanWalk(Partner[FOLLOW_X],Partner[FOLLOW_Y],DIR_UP,1,false)) 
								{
									--Partner[FOLLOW_Y];
									if (PegasusTimer >= 48) --Partner[FOLLOW_Y];
									if (Link->Action < LA_ATTACKING) Partner[FOLLOW_DIR] = DIR_UP;
								}
								if (Partner[FOLLOW_Y] < Link->Y+16 && CanWalk(Partner[FOLLOW_X],Partner[FOLLOW_Y],DIR_DOWN,1,false)) 
								{
									++Partner[FOLLOW_Y];
									if (PegasusTimer >= 48) ++Partner[FOLLOW_Y];
									//if (Link->Action < LA_ATTACKING) Partner[FOLLOW_DIR] = DIR_DOWN;
								}
							}
							if (IsSideview())
							{
								if (Partner[FOLLOW_Y] < Link->Y - 20) ++Partner[FOLLOW_Y];
								else if (Partner[FOLLOW_Y] > Link->Y + 20) --Partner[FOLLOW_Y];								
								if (CanWalk(Link->X,Link->Y,DIR_DOWN,1,false))
								{
									if (Partner[FOLLOW_X] < Link->X - 20) ++Partner[FOLLOW_X];
									else if (Partner[FOLLOW_X] > Link->X + 20) --Partner[FOLLOW_X];
								}
								if (CanWalk(Partner[FOLLOW_X],Partner[FOLLOW_Y],DIR_DOWN,1,false))
								{
									if (Screen->ComboT[ComboAt(Partner[FOLLOW_X]+7,Partner[FOLLOW_Y]+8)] != CT_SIDECLIMB) ++Partner[FOLLOW_Y];
								}
								if (Partner[FOLLOW_STATE] == 0)
								{
									if (Screen->ComboS[ComboAt(Partner[FOLLOW_X]+7,Partner[FOLLOW_Y]+15)] != 0) --Partner[FOLLOW_Y];
								}
							}
							if (Link->InputDown)
							{
								if (Partner[FOLLOW_ACTION] == 0) Partner[FOLLOW_ACTION] = FA_WALKING;
								else if (Partner[FOLLOW_ACTION] == FA_WALKING) Partner[FOLLOW_ATIMER] = 12;

								if (Partner[FOLLOW_X] > Link->X && CanWalk(Partner[FOLLOW_X],Partner[FOLLOW_Y],DIR_LEFT,1,false)) 
								{
									--Partner[FOLLOW_X];
									if (PegasusTimer >= 48) --Partner[FOLLOW_X]; 
									if (Link->Action < LA_ATTACKING) Partner[FOLLOW_DIR] = DIR_LEFT;
								}
								if (Partner[FOLLOW_X] < Link->X && CanWalk(Partner[FOLLOW_X],Partner[FOLLOW_Y],DIR_RIGHT,1,false)) 
								{
									++Partner[FOLLOW_X];
									if (PegasusTimer >= 48) ++Partner[FOLLOW_X];
									if (Link->Action < LA_ATTACKING) Partner[FOLLOW_DIR] = DIR_RIGHT;
								}
								if (Partner[FOLLOW_Y] > Link->Y-16 && CanWalk(Partner[FOLLOW_X],Partner[FOLLOW_Y],DIR_UP,1,false)) 
								{
									if (!IsSideview() || Screen->ComboT[ComboAt(Link->X+7,Link->Y+8)] == CT_SIDECLIMB) --Partner[FOLLOW_Y];
									if (PegasusTimer >= 48) --Partner[FOLLOW_Y];
									//if (Link->Action < LA_ATTACKING) Partner[FOLLOW_DIR] = DIR_UP;
								}
								if (Partner[FOLLOW_Y] < Link->Y-16 && CanWalk(Partner[FOLLOW_X],Partner[FOLLOW_Y],DIR_DOWN,1,false)) 
								{
									++Partner[FOLLOW_Y];
									if (PegasusTimer >= 48) ++Partner[FOLLOW_Y];
									if (Link->Action < LA_ATTACKING) Partner[FOLLOW_DIR] = DIR_DOWN;
								}
							}
							if (Link->InputLeft)
							{
								if (Partner[FOLLOW_ACTION] == 0) Partner[FOLLOW_ACTION] = FA_WALKING;
								else if (Partner[FOLLOW_ACTION] == FA_WALKING) Partner[FOLLOW_ATIMER] = 12;

								if (Partner[FOLLOW_X] > Link->X+16 && CanWalk(Partner[FOLLOW_X],Partner[FOLLOW_Y],DIR_LEFT,1,false)) 
								{
									--Partner[FOLLOW_X];
									if (PegasusTimer >= 48) --Partner[FOLLOW_X]; 
									if (Link->Action < LA_ATTACKING) Partner[FOLLOW_DIR] = DIR_LEFT;
								}
								if (Partner[FOLLOW_X] < Link->X+16 && CanWalk(Partner[FOLLOW_X],Partner[FOLLOW_Y],DIR_RIGHT,1,false)) 
								{
									++Partner[FOLLOW_X];
									if (PegasusTimer >= 48) ++Partner[FOLLOW_X];
									//if (Link->Action < LA_ATTACKING) Partner[FOLLOW_DIR] = DIR_RIGHT;
								}
								if (Partner[FOLLOW_Y] > Link->Y && CanWalk(Partner[FOLLOW_X],Partner[FOLLOW_Y],DIR_UP,1,false)) 
								{
									--Partner[FOLLOW_Y];
									if (PegasusTimer >= 48) --Partner[FOLLOW_Y];
									if (Link->Action < LA_ATTACKING) Partner[FOLLOW_DIR] = DIR_UP;
								}
								if (Partner[FOLLOW_Y] < Link->Y && CanWalk(Partner[FOLLOW_X],Partner[FOLLOW_Y],DIR_DOWN,1,false)) 
								{
									++Partner[FOLLOW_Y];
									if (PegasusTimer >= 48) ++Partner[FOLLOW_Y];
									if (Link->Action < LA_ATTACKING) Partner[FOLLOW_DIR] = DIR_DOWN;
								}

							}
							if (Link->InputRight)
							{
								if (Partner[FOLLOW_ACTION] == 0) Partner[FOLLOW_ACTION] = FA_WALKING;
								else if (Partner[FOLLOW_ACTION] == FA_WALKING) Partner[FOLLOW_ATIMER] = 12;

								if (Partner[FOLLOW_X] > Link->X-16 && CanWalk(Partner[FOLLOW_X],Partner[FOLLOW_Y],DIR_LEFT,1,false)) 
								{
									--Partner[FOLLOW_X];
									if (PegasusTimer >= 48) --Partner[FOLLOW_X]; 
									//if (Link->Action < LA_ATTACKING) Partner[FOLLOW_DIR] = DIR_LEFT;
								}
								if (Partner[FOLLOW_X] < Link->X-16 && CanWalk(Partner[FOLLOW_X],Partner[FOLLOW_Y],DIR_RIGHT,1,false)) 
								{
									++Partner[FOLLOW_X];
									if (PegasusTimer >= 48) ++Partner[FOLLOW_X];
									if (Link->Action < LA_ATTACKING) Partner[FOLLOW_DIR] = DIR_RIGHT;
								}
								if (Partner[FOLLOW_Y] > Link->Y && CanWalk(Partner[FOLLOW_X],Partner[FOLLOW_Y],DIR_UP,1,false)) 
								{
									--Partner[FOLLOW_Y];
									if (PegasusTimer >= 48) --Partner[FOLLOW_Y];
									if (Link->Action < LA_ATTACKING) Partner[FOLLOW_DIR] = DIR_UP;
								}
								if (Partner[FOLLOW_Y] < Link->Y && CanWalk(Partner[FOLLOW_X],Partner[FOLLOW_Y],DIR_DOWN,1,false))
								{ 
									++Partner[FOLLOW_Y];
									if (PegasusTimer >= 48) ++Partner[FOLLOW_Y];
									if (Link->Action < LA_ATTACKING) Partner[FOLLOW_DIR] = DIR_DOWN;
								}
							}
							if (PegasusTimer >= 48) Partner[FOLLOW_DIR] = Link->Dir;

							if (Link->X > Partner[FOLLOW_X] + 16) ++Partner[FOLLOW_X];
							else if (Link->X < Partner[FOLLOW_X] - 16) --Partner[FOLLOW_X];
							if (Link->Y > Partner[FOLLOW_Y] + 16) ++Partner[FOLLOW_Y];
							else if (Link->Y < Partner[FOLLOW_Y] - 16) --Partner[FOLLOW_Y];

							if (Link->X > Partner[FOLLOW_X] + 24) 
							{
								++Partner[FOLLOW_X];
								Partner[FOLLOW_DIR] = Link->Dir;
							}
							else if (Link->X < Partner[FOLLOW_X] - 24) 
							{
								--Partner[FOLLOW_X];
								Partner[FOLLOW_DIR] = Link->Dir;
							}
							if (Link->Y > Partner[FOLLOW_Y] + 24) 
							{
								++Partner[FOLLOW_Y];
								Partner[FOLLOW_DIR] = Link->Dir;
							}
							else if (Link->Y < Partner[FOLLOW_Y] - 24) 
							{
								--Partner[FOLLOW_Y];
								Partner[FOLLOW_DIR] = Link->Dir;
							}

							if (Link->PressEx2)
							{
								if (!Link->Item[I_LTTPSBOMB])
								{
									Game->PlaySound(SFX_MODEOFF);
									Partner[STORE_COSTUME] = Game->Counter[CR_COSTUME];
									Game->Counter[CR_COSTUME] = Game->Counter[CR_PCOSTUME]-1;
									if (Game->Counter[CR_COSTUME] == 0 && Link->Item[I_LINKCOSTUME]) Link->Item[I_LINKCOSTUME] = false;
									else if (Game->Counter[CR_COSTUME] > 0 && !Link->Item[I_LINKCOSTUME]) Link->Item[I_LINKCOSTUME] = true;
									Game->Counter[CR_PCOSTUME] = Partner[STORE_COSTUME]+1;
									CopyTileRow(COSTUMECOPY_TILE + (Game->Counter[CR_COSTUME] * 260),PLAYER_TILES,200);
									CopyTileRow(COSTUMEVICTORY_TILES + (Game->Counter[CR_COSTUME] * 260),PLAYERVICTORY_TILES,9);
									CopyTileRow(COSTUMECOPY_TILE + ((Game->Counter[CR_PCOSTUME]-1) * 260),PARTNER_TILES,200);
									SetHurtNoise();
								}
							}
						}
						if (Link->Action != LA_SCROLLING)
						{
							if (DoDraw)
							{
								if (Link->Item[I_LTTPSBOMB]) Screen->FastTile(2,Partner[FOLLOW_X],Partner[FOLLOW_Y],LTTPSBOMB_TILE,8,128);
								else
								{
									if (Game->Counter[CR_PCOSTUME] == PCOSTUME_BIG_MANHANDLA) Screen->FastTile(2,Partner[FOLLOW_X],Partner[FOLLOW_Y],MANHANDLA_MIDDLE_TILE,6,128);
									else
									{
										if (Partner[FOLLOW_DIR] == DIR_UP) Screen->FastCombo(2,Partner[FOLLOW_X],Partner[FOLLOW_Y],PARTNER_COMBO+Partner[FOLLOW_ACTION],6,128);
										else if (Partner[FOLLOW_DIR] == DIR_DOWN) Screen->FastCombo(2,Partner[FOLLOW_X],Partner[FOLLOW_Y],PARTNER_COMBO+Partner[FOLLOW_ACTION]+1,6,128);
										else if (Partner[FOLLOW_DIR] == DIR_LEFT) Screen->FastCombo(2,Partner[FOLLOW_X],Partner[FOLLOW_Y],PARTNER_COMBO+Partner[FOLLOW_ACTION]+2,6,128);
										else if (Partner[FOLLOW_DIR] == DIR_RIGHT) Screen->FastCombo(2,Partner[FOLLOW_X],Partner[FOLLOW_Y],PARTNER_COMBO+Partner[FOLLOW_ACTION]+3,6,128);
									}
								}
							}
						}
					}
					else if (Partner[FOLLOW_STATE] == 1)
					{

						if (Game->GetCurScreen() == Partner[FOLLOW_SCREEN] && Game->GetCurMap() == Partner[FOLLOW_MAP] && Link->Action != LA_SCROLLING)
						{
							if (JustDroppedPartner)
							{
								if (Link->X < Partner[FOLLOW_X] - 10 || Link->X > Partner[FOLLOW_X] + 10 || Link->Y < Partner[FOLLOW_Y] - 10 || Link->Y > Partner[FOLLOW_Y] + 10) JustDroppedPartner = false;
							}
							else
							{
								if (Link->Item[I_PARTNER] || Link->Item[I_LTTPSBOMB])
								{
									if (Link->X > Partner[FOLLOW_X] - 10 && Link->X < Partner[FOLLOW_X] + 10 && Link->Y > Partner[FOLLOW_Y] - 10 && Link->Y < Partner[FOLLOW_Y] + 10)
									{
										Game->PlaySound(SFX_PEGAITEM);
										Partner[FOLLOW_STATE] = 0;						
									}
								}
							}
							if (Link->Item[I_LTTPSBOMB])
							{ 
								if (DoDraw)
								{
									Screen->FastTile(2,Partner[FOLLOW_X],Partner[FOLLOW_Y],LTTPSBOMB_TILE+1,8,128);
									if (Partner[FOLLOW_DISPLAY] > 0)
									{
										Screen->DrawInteger(
										2,					//int layer, 
										Partner[FOLLOW_X]+4,			//int x, 
										Partner[FOLLOW_Y]+5,			//int y, 
										FONT_Z1,				//int font, 
										1,					//int color, 
										-1,					//int background_color, 
										-1,					//int width, 
										-1,					//int height, 
										Partner[FOLLOW_DISPLAY],		//int number, 
										0, 					//int number_decimal_places, 
										128);					 //int opacity

										if (Partner[FOLLOW_DISPLAY] < 3)
										{
											if (Partner[FOLLOW_X] > Link->X - 12 && Partner[FOLLOW_X] < Link->X+12 && Partner[FOLLOW_Y] > Link->Y - 12 && Partner[FOLLOW_Y] < Link->Y+12)
											{
												Partner[FOLLOW_STATE] = 0;
												Partner[FOLLOW_TIMER] = 0;
												Game->PlaySound(SFX_PEGAITEM);
											}
										}
									}
								}

								if (Partner[FOLLOW_TIMER] > 384) Partner[FOLLOW_DISPLAY] = 3;
								else if (Partner[FOLLOW_TIMER] > 256) Partner[FOLLOW_DISPLAY] = 2;
								else if (Partner[FOLLOW_TIMER] > 128) Partner[FOLLOW_DISPLAY] = 1;
								else
								{
									Partner[FOLLOW_DISPLAY] = 0;
									if (DoDraw) Screen->FastTile(2,Partner[FOLLOW_X],Partner[FOLLOW_Y],LTTPSBOMB_TILE,Choose(6,7,8,9),128);
								}
								if (Partner[FOLLOW_TIMER] == 384 || Partner[FOLLOW_TIMER] == 256 || Partner[FOLLOW_TIMER] == 128) Game->PlaySound(SFX_MSG);
							
								if (Partner[FOLLOW_TIMER] > 0)
								{
									if (Link->Action != LA_SCROLLING) --Partner[FOLLOW_TIMER];
								}
								if (Partner[FOLLOW_TIMER] == 1)
								{
		
									if (Game->GetCurScreen() == Partner[FOLLOW_SCREEN] && Game->GetCurMap() == Partner[FOLLOW_MAP] && Link->Action != LA_SCROLLING)
									{
										lweapon Kablooie = CreateLWeaponAt(LW_SBOMBBLAST,Partner[FOLLOW_X],Partner[FOLLOW_Y]+16);
										Kablooie->Damage = 64;
										Kablooie = CreateLWeaponAt(LW_SBOMBBLAST,Partner[FOLLOW_X],Partner[FOLLOW_Y]+16);
										Kablooie->Damage = 64;
										Kablooie = CreateLWeaponAt(LW_SBOMBBLAST,Partner[FOLLOW_X]-16,Partner[FOLLOW_Y]);
										Kablooie->Damage = 64;
										Kablooie = CreateLWeaponAt(LW_SBOMBBLAST,Partner[FOLLOW_X]+16,Partner[FOLLOW_Y]);
										Kablooie->Damage = 64;

										eweapon Kablowie = CreateEWeaponAt(EW_SBOMBBLAST,Partner[FOLLOW_X],Partner[FOLLOW_Y]-16);
										Kablowie->Damage = 255;
										Kablowie = CreateEWeaponAt(EW_SBOMBBLAST,Partner[FOLLOW_X],Partner[FOLLOW_Y]+16);
										Kablowie->Damage = 255;
										Kablowie = CreateEWeaponAt(EW_SBOMBBLAST,Partner[FOLLOW_X]-16,Partner[FOLLOW_Y]);
										Kablowie->Damage = 255;
										Kablowie = CreateEWeaponAt(EW_SBOMBBLAST,Partner[FOLLOW_X]+16,Partner[FOLLOW_Y]);
										Kablowie->Damage = 255;
			
										Game->PlaySound(SFX_SHUTTER);
										Game->PlaySound(SFX_LTTPSBOMB);
										Screen->Quake = 32;
									}
									Partner[FOLLOW_STATE] = 0;
									Partner[FOLLOW_TIMER] = 0;
									Link->Item[I_LTTPSBOMB] = false;
								}
							}
							else if (DoDraw)
							{
								if (Game->Counter[CR_PCOSTUME] == PCOSTUME_BIG_MANHANDLA) Screen->FastTile(2,Partner[FOLLOW_X],Partner[FOLLOW_Y],MANHANDLA_MIDDLE_TILE,6,128);
								else
								{
									if (Partner[FOLLOW_DIR] == DIR_UP) Screen->FastCombo(2,Partner[FOLLOW_X],Partner[FOLLOW_Y],PARTNER_COMBO+Partner[FOLLOW_ACTION],6,128);
									else if (Partner[FOLLOW_DIR] == DIR_DOWN) Screen->FastCombo(2,Partner[FOLLOW_X],Partner[FOLLOW_Y],PARTNER_COMBO+Partner[FOLLOW_ACTION]+1,6,128);
									else if (Partner[FOLLOW_DIR] == DIR_LEFT) Screen->FastCombo(2,Partner[FOLLOW_X],Partner[FOLLOW_Y],PARTNER_COMBO+Partner[FOLLOW_ACTION]+2,6,128);
									else if (Partner[FOLLOW_DIR] == DIR_RIGHT) Screen->FastCombo(2,Partner[FOLLOW_X],Partner[FOLLOW_Y],PARTNER_COMBO+Partner[FOLLOW_ACTION]+3,6,128);
								}
								if (!ModeMenu[MODEMENU_ON]) 
								{
									if (DoDraw)
									{
										if (Game->Counter[CR_WEATHER] != ENV_BLOCKY)
										{
											Screen->DrawString(7, 128, -56, FONT_Z1, 1, 0, TF_NORMAL, TEXT_EX4, OP_OPAQUE);
											Screen->FastCombo(7,152,-56,PARTNER_COMBO+1,6,128);
										}
									}
								}
								if (Link->PressEx4 || Link->PressEx2)
								{
									if (Partner[FOLLOW_SCREEN] == Game->GetCurScreen() && Partner[FOLLOW_MAP] == Game->GetCurMap())
									{
										Partner[FOLLOW_DIR] = Link->Dir;
										Partner[STORE_FOLLOW_X] = Partner[FOLLOW_X];
										Partner[STORE_FOLLOW_Y] = Partner[FOLLOW_Y];
										Partner[FOLLOW_X] = Link->X;
										Partner[FOLLOW_Y] = Link->Y;
										Link->X = Partner[STORE_FOLLOW_X];
										Link->Y = Partner[STORE_FOLLOW_Y];
										Game->PlaySound(SFX_SWITCHHOOK);
										lweapon SwapPoof = CreateLWeaponAt(LW_SPARKLE,Link->X,Link->Y);
										SwapPoof->UseSprite(SP_BLINKARROW);
										SwapPoof->DrawYOffset = -16;
										Partner[STORE_COSTUME] = Game->Counter[CR_COSTUME];
										Game->Counter[CR_COSTUME] = Game->Counter[CR_PCOSTUME]-1;
										if (Game->Counter[CR_COSTUME] == 0 && Link->Item[I_LINKCOSTUME]) Link->Item[I_LINKCOSTUME] = false;
										else if (Game->Counter[CR_COSTUME] > 0 && !Link->Item[I_LINKCOSTUME]) Link->Item[I_LINKCOSTUME] = true;
										Game->Counter[CR_PCOSTUME] = Partner[STORE_COSTUME]+1;
										CopyTileRow(COSTUMECOPY_TILE + (Game->Counter[CR_COSTUME] * 260),PLAYER_TILES,200);
										CopyTileRow(COSTUMEVICTORY_TILES + (Game->Counter[CR_COSTUME] * 260),PLAYERVICTORY_TILES,9);
										CopyTileRow(COSTUMECOPY_TILE + ((Game->Counter[CR_PCOSTUME]-1) * 260),PARTNER_TILES,200);
										SetHurtNoise();
									}
								}
							}
						}	
						else if (!Link->Item[I_LTTPSBOMB])
						{
							if (DoDraw)
							{
								if (!ModeMenu[MODEMENU_ON])
								{
									if (Game->Counter[CR_WEATHER] != ENV_BLOCKY)
									{
										Screen->DrawString(7, 128, -56, FONT_Z1, 4, 0, TF_NORMAL, TEXT_EX4, OP_OPAQUE);
										Screen->FastCombo(7,152,-56,PARTNER_COMBO+1,6,128);
									}
								}
								if (Link->PressEx4)
								{
									Partner[FOLLOW_STATE] = 0;
									Partner[FOLLOW_X] = Link->X;
									Partner[FOLLOW_Y] = Link->Y;
									Game->PlaySound(SFX_PEGAITEM);
								}
							}
						}
					}
				}
			}

// --------------------------------------- Chapter 28: LTTP Superbomb (end)



// --------------------------------------- Chapter 29: Windy Screens (start)
// Maybe this should've been an FFC script?

			if (Screen->Flags[9]&0x0020 && Link->Action != LA_SCROLLING) 	//"Screen->Screen Data->Sflags 2->General Use 4 (Scripts)" checkbox.
			{
				if (WindyTimer == 0)
				{
					WindyTimer = 8;
					Game->PlaySound(SFX_WINDY);
				}
				else --WindyTimer;

	// --- Blowing Up
				if (Screen->RoomData == 1 || Screen->RoomData == 5)
				{
					if (NumLWeaponsOf(LW_SPARKLE) < 8) 
					{
						lweapon WindyWoosh = CreateLWeaponAt(LW_SPARKLE,(Rand(15)*16),152);
						WindyWoosh->UseSprite(SP_WINDY);
						if (Screen->RoomData == 1) WindyWoosh->Step = Rand(300,800);
						else
							{
								WindyWoosh->CSet = 8;
								WindyWoosh->Step = Rand(300,500);
							}
						WindyWoosh->Dir = DIR_UP;
					}
					if (!(WindyTimer%2))
					{
						if (SomariaBlock->isValid()) --SomariaBlock->Y;
						if (Screen->RoomData == 1 && Link->Item[I_BOOTS] && Link->Action == LA_WALKING || Screen->RoomData == 5 && !Link->Item[I_BOOTS] || Screen->RoomData == 5 && Link->Action == LA_NONE || Screen->RoomData == 5 && Link->InputUp)
						{
							PushLink(DIR_UP);
							if (!IsSideview())
							{
								Link->InputLeft = false;
								Link->InputRight = false;
							}
						}
					}
					if (Screen->RoomData == 1)
					{
						if (IsSideview() && Link->Y < 3 && NumLWeaponsOf(LW_CANEOFBYRNA) > 0) --Link->Y;
						if (!Link->Item[I_BOOTS] || Link->Action != LA_WALKING) PushLink(DIR_UP);
						if (!Link->Item[I_BOOTS] || Link->InputUp)
						{
							Link->InputDown = false;
							PushLink(DIR_UP);
						}
					}
				}


	// --- Blowing Down
				if (Screen->RoomData == 2 || Screen->RoomData == 6)
				{
					if (NumLWeaponsOf(LW_SPARKLE) < 8) 
					{
						lweapon WindyWoosh = CreateLWeaponAt(LW_SPARKLE,Rand(15)*16,8);
						WindyWoosh->UseSprite(SP_WINDY);
						if (Screen->RoomData == 2) WindyWoosh->Step = Rand(300,800);
						else
							{
								WindyWoosh->CSet = 8;
								WindyWoosh->Step = Rand(300,500);
							}
						WindyWoosh->Dir = DIR_DOWN;
					}
					if (!(WindyTimer%2))
					{
						if (SomariaBlock->isValid()) ++SomariaBlock->Y;
						if (Screen->RoomData == 2 && Link->Item[I_BOOTS] && Link->Action == LA_WALKING || Screen->RoomData == 6 && !Link->Item[I_BOOTS] || Screen->RoomData == 6 && Link->Action == LA_NONE || Screen->RoomData == 6 && Link->InputDown)
						{
							PushLink(DIR_DOWN);
							if (!IsSideview())
							{
								Link->InputLeft = false;
								Link->InputRight = false;
							}
						}
					}
					if (Screen->RoomData == 2)
					{
						if (!Link->Item[I_BOOTS] || Link->Action != LA_WALKING) PushLink(DIR_DOWN);
						if (!Link->Item[I_BOOTS] || Link->InputDown)
						{
							Link->InputUp = false;
							PushLink(DIR_DOWN);
						}
					}

				}

	// --- Blowing Left
				if (Screen->RoomData == 3 || Screen->RoomData == 7 || Screen->RoomData == 17)
				{
					if (NumLWeaponsOf(LW_SPARKLE) < 8) 
					{
						lweapon WindyWoosh = CreateLWeaponAt(LW_SPARKLE,236,Rand(10)*16);
						WindyWoosh->UseSprite(SP_WINDY);
						if (Screen->RoomData == 3) WindyWoosh->Step = Rand(300,800);
						else
							{
								WindyWoosh->CSet = 8;
								WindyWoosh->Step = Rand(300,500);
							}
						WindyWoosh->Dir = DIR_LEFT;
					}
					if (!(WindyTimer%2)) 
					{
						if (SomariaBlock->isValid()) --SomariaBlock->X;
						if (Screen->RoomData == 3 && Link->Item[I_BOOTS] && Link->Action == LA_WALKING || Screen->RoomData == 7 && !Link->Item[I_BOOTS] || Screen->RoomData == 7 && Link->Action == LA_NONE || Screen->RoomData == 7 && Link->InputLeft  || Screen->RoomData == 17 && !Link->Item[I_BOOTS] || Screen->RoomData == 17 && Link->Action == LA_NONE || Screen->RoomData == 17 && Link->InputLeft)
						{
							PushLink(DIR_LEFT);
							if (!IsSideview())
							{
								Link->InputUp = false;
								Link->InputDown = false;
							}
						}
					}
					if (Screen->RoomData == 3)
					{
						if (!Link->Item[I_BOOTS] || Link->Action != LA_WALKING) PushLink(DIR_LEFT);
						if (!Link->Item[I_BOOTS] || Link->InputLeft)
						{
							Link->InputRight = false;
							PushLink(DIR_LEFT);
						}
					}
				}

	// --- Blowing Right
				if (Screen->RoomData == 4 || Screen->RoomData == 8)
				{
					if (NumLWeaponsOf(LW_SPARKLE) < 8)
					{
						lweapon WindyWoosh = CreateLWeaponAt(LW_SPARKLE,4,Rand(10)*16);
						WindyWoosh->UseSprite(SP_WINDY);
						if (Screen->RoomData == 4) WindyWoosh->Step = Rand(300,800);
						else
							{
								WindyWoosh->CSet = 8;
								WindyWoosh->Step = Rand(300,500);
							}
						WindyWoosh->Dir = DIR_RIGHT;
					}
					if (!(WindyTimer%2))
					{
						if (SomariaBlock->isValid()) ++SomariaBlock->X;
						if (Screen->RoomData == 4 && Link->Item[I_BOOTS] && Link->Action == LA_WALKING || Screen->RoomData == 8 && !Link->Item[I_BOOTS] || Screen->RoomData == 8 && Link->Action == LA_NONE || Screen->RoomData == 8 && Link->InputRight)
						{
							PushLink(DIR_RIGHT);
							if (!IsSideview())
							{
								Link->InputUp = false;
								Link->InputDown = false;
							}
						}
					}
					if (Screen->RoomData == 4)
					{
						if (!Link->Item[I_BOOTS] || Link->Action != LA_WALKING) PushLink(DIR_RIGHT);
						if (!Link->Item[I_BOOTS] || Link->InputRight)
						{
							Link->InputLeft = false;
							PushLink(DIR_RIGHT);
						}
					}
				}

			}
// --------------------------------------- Chapter 29: Windy Screens (end)



// --------------------------------------- Chapter 30: Call FourWayCurse
			if (!IsSideview()) FourWayCurse(0);


// --------------------------------------- Chapter 31: Item: Lantern (start)
// Maybe this should be redone to launch an FFC script?

			if (DoDraw)
			{
				if ((Game->Counter[CR_WEATHER] == 0 || Game->Counter[CR_WEATHER] > ENV_BLOCKY && Game->Counter[CR_WEATHER] < ENV_WAVY1) && !Link->Item[I_CURSEDPICTOBOX])
				{			
					if (Screen->Flags[9]&0x0040) 	//"Screen->Screen Data->Sflags 2->General Use 5 (Scripts)" checkbox.
					{
						if (!IsDark)
						{
							if (NumLWeaponsOf(LW_FIRE) == 0) IsDark = true;
						}
					}
					else if (IsDark && Link->Action != LA_SCROLLING) IsDark = false;
					if (IsDark)
					{
						if (Link->PressB)
						{
							if (GetEquipmentB() == I_CANDLE1 || GetEquipmentB() == I_CANDLE2) IsDark = false;
						}
						else if (Link->PressA)
						{
							if (GetEquipmentA() == I_CANDLE1 || GetEquipmentA() == I_CANDLE2) IsDark = false;
						}
		
						if (Link->Action == LA_SCROLLING || !Link->Item[I_LANTERN]) 
						{
							Screen->Rectangle(
							5,	//layer
							0,	//start X
							0,	//start y
							256,	//end x
							176,	//end y
							0,1,0,0,0,true,128);

			// --- Extra draw beacuse subscreen interrupts high layered draws (was going to use layer 5 for the other darkness)
							Screen->Rectangle(
							2,	//layer
							0,	//start X
							0,	//start y
							256,	//end x
							176,	//end y
							0,1,0,0,0,true,128);

							if (Link->Action != LA_SCROLLING) 
							{
								if (Link->Item[I_CURSEDPICTOBOX]) Screen->DrawTile(
									5,
									Link->X + (120 - Link->X),	//start X
									Link->Y-Link->Z + (80 - Link->Y),//start y
									Link->Tile,	//tile ID
									1,		//tile width
									1,		//tile width
									6,		//tile cset
									-1,-1,-1,-1,0,Link->Flip,1,128);
								else Screen->DrawTile(
									5,
									Link->X,	//start X
									Link->Y-Link->Z,//start y
									Link->Tile,	//tile ID
									1,		//tile width
									1,		//tile width
									6,		//tile cset
									-1,-1,-1,-1,0,Link->Flip,1,128);
							}
						}
	
						if (Link->Action != LA_SCROLLING && Link->Item[I_LANTERN])
						{
							Screen->Rectangle(
							5,		//layer
							0,		//start X
							0,		//start y
							256,		//end x
							Link->Y-32,	//end y
							0,1,0,0,0,true,128);	
							Screen->Rectangle(
							5,		//layer
							0,		//start X
							Link->Y+48,	//start y
							256,		//end x
							176,		//end y
							0,1,0,0,0,true,128);	
							Screen->Rectangle(
							5,		//layer
							0,		//start X
							0,		//start y
							Link->X-32,	//end x
							176,		//end y
							0,1,0,0,0,true,128);	
							Screen->Rectangle(
							5,		//layer
							Link->X+48,	//start X
							0,		//start y
							256,		//end x
							176,		//end y
							0,1,0,0,0,true,128);	
							Screen->DrawTile(
							5,
							Link->X-32,	//start X
							Link->Y-32,	//start y
							LANTERN_TILE,	//tile ID
							5,		//tile width
							5,		//tile width
							0,		//tile cset
							-1,-1,-1,-1,0,0,1,128);

			// --- Extra draws because subscreen interrupts higher layered draws
			// Maybe there's a better way to do it though?

							Screen->Rectangle(
							2,		//layer
							0,		//start X
							0,		//start y
							256,		//end x
							Link->Y-32,	//end y
							0,1,0,0,0,true,128);	
							Screen->Rectangle(
							2,		//layer
							0,		//start X
							Link->Y+48,	//start y
							256,		//end x
							176,		//end y
							0,1,0,0,0,true,128);	
							Screen->Rectangle(
							2,		//layer
							0,		//start X
							0,		//start y
							Link->X-32,	//end x
							176,		//end y
							0,1,0,0,0,true,128);	
							Screen->Rectangle(
							2,		//layer
							Link->X+48,	//start X
							0,		//start y
							256,		//end x
							176,		//end y
							0,1,0,0,0,true,128);	
						}
					}
				}
			}
// --------------------------------------- Chapter 31: Item: Lantern (end)



// --------------------------------------- Chapter 31.5: Dimi's MirrorLink Stuff and other assorted jank you can try at home!
			UpdateEWeapons();
			if (CountFFCsRunning(62) > 0) StoodStill = 0;

			if (RememberStuff[REMEMBER_EX3_SPOILERLOG] == 1)
			{
				if (Link->PressEx3)
				{
					RememberStuff[REMEMBER_EX3_SPOILERLOG] = 2;
					int SpoilerScript[] = "SpoilerLogAnywhere";
					int sid = Game->GetFFCScript(SpoilerScript);
					ffc SpoilerShower;
					for ( int q = 1; q <= 32; ++q )
					{
						SpoilerShower = Screen->LoadFFC(q);
						if ( SpoilerShower->Script ) continue;
						if ( SpoilerShower->Data ) continue;
						if ( q )
						{
							SpoilerShower->Data = COMBO_SCREENFREEZE1;
							SpoilerShower->Script = Game->GetFFCScript(SpoilerScript);
							break;
						}
					}
				}
			}



// --------------------------------------- Chapter 32: Waitdraw()
			Waitdraw();
			
			if ((Link->Item[I_RECURSEDPICTOBOX] || RememberStuff[REMEMBER_SCROLLING] > 0) && Game->GetCurDMap() <= 0) FakeNoScroll2();


		}		
// -----------------------------------------------------------------------
// End of Global While() loop
// -----------------------------------------------------------------------
	}
}
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// Global script (End)
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------








// ---------------------------------------------- Section 5: Item Scripts

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// Cane of Somaria Item script (Start)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// NOTE: Actual push of the Somaria block is in the Global script, not this item script. See "Somaria pushblock" section of global.

item script SomariaCane
{
	void run(int Damage, int Color, int NoSpawnCombo, int AltSprite)
//D0 - Damage for blocks and beams to deal.
//D1 - Color of blocks.
//D2 - Will not spawn blocks on top of D2 combo type.
//D3 - Alternate sprite of blocks

	{
		lweapon SomariaBlock;
		lweapon SomariaGoesPoof;
		lweapon Sword;
		if (NumLWeaponsOf(LW_SOMARIA) == 0)
		{
			if (NoSpawnCombo == 0 || Link->Dir == DIR_UP && Screen->ComboT[ComboAt(Link->X+7,Link->Y - 4)] != NoSpawnCombo || Link->Dir == DIR_DOWN && Screen->ComboT[ComboAt(Link->X+7,Link->Y + 20)] != NoSpawnCombo || Link->Dir == DIR_LEFT && Screen->ComboT[ComboAt(Link->X-4,Link->Y+8)] != NoSpawnCombo || Link->Dir == DIR_RIGHT && Screen->ComboT[ComboAt(Link->X+20,Link->Y+8)] != NoSpawnCombo)
			{
				SomariaBlock = NextToLink(LW_SOMARIA,0);
				if (AltSprite == 0) SomariaBlock->UseSprite(SP_SOMARIABLOCK);
				else SomariaBlock->UseSprite(AltSprite);
				SomariaBlock->CSet = Color;
				SomariaBlock->Damage = Damage;	
				SomariaBlock->Dir = Link->Dir;
				SomariaBlock->DrawYOffset = 0;
				SomariaGoesPoof = CreateLWeaponAt(LW_SPARKLE,SomariaBlock->X,SomariaBlock->Y);
				SomariaGoesPoof->UseSprite(SP_SPAWN);
				Game->PlaySound(SFX_SOMARIA);
			}
		}
		else
		{
			SomariaBlock = LoadLWeaponOf(LW_SOMARIA);
			SomariaGoesPoof = CreateLWeaponAt(LW_SPARKLE,SomariaBlock->X,SomariaBlock->Y);
			SomariaGoesPoof->UseSprite(SP_MISC_DEATH);
			Game->PlaySound(SFX_SOMARIA);
			if (Link->HP >= Link->MaxHP-4 || (Link->Item[I_SOMARIAPERIL] && Link->HP <= 48))
			{
				//if (NumLWeaponsOf(LW_BEAM) == 0)
				//{
					lweapon SomariaBeam = CreateLWeaponAt(LW_BEAM,SomariaBlock->X,SomariaBlock->Y);
					SomariaBeam->UseSprite(SP_SOMARIABEAM);
					SomariaBeam->Damage = Damage;

					SomariaBeam = CreateLWeaponAt(LW_BEAM,SomariaBlock->X,SomariaBlock->Y);
					SomariaBeam->UseSprite(SP_SOMARIABEAM);
					SomariaBeam->Damage = Damage;
					SomariaBeam->Dir = DIR_DOWN;
					SomariaBeam->Flip = FLIP_VERTICAL;

					SomariaBeam = CreateLWeaponAt(LW_BEAM,SomariaBlock->X,SomariaBlock->Y);
					SomariaBeam->UseSprite(SP_SOMARIABEAMSIDE);
					SomariaBeam->Damage = Damage;
					SomariaBeam->Dir = DIR_LEFT;
					SomariaBeam->Flip = FLIP_HORIZONTAL;

					SomariaBeam = CreateLWeaponAt(LW_BEAM,SomariaBlock->X,SomariaBlock->Y);
					SomariaBeam->UseSprite(SP_SOMARIABEAMSIDE);
					SomariaBeam->Damage = Damage;
					SomariaBeam->Dir = DIR_RIGHT;

					Game->PlaySound(SFX_BEAM);
				//}
			}
			Remove(SomariaBlock);
		}
	}
}

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// Cane of Somaria Item script (End)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------



// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// Ally NPC / Octorok Item script (Start)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// NOTE: LWeapons are created by the global script


item script AllyNPC
{
	void run(int OctoSummon, int OctoColor, int OctoLWeapon, int OctoDamage, int OctoLWeaponSprite)
	{

	// D0: NPC to summon.
	// D1: CSet of NPC
	// D2: LWeapon for NPC to fire (if 0, no weapon)
	// D3: Damage of NPC's weapons

		npc GoodOcto = LoadNPCOf(OctoSummon);
		if (GoodOcto->isValid())
		{
			GoodOcto->HP = HP_SILENT;
			Game->PlaySound(SFX_MSG);
		}
		else
		{
			GoodOcto = CreateNPCAt(OctoSummon,ComboX(ComboAt(Link->X,Link->Y)),ComboY(ComboAt(Link->X,Link->Y)));
			GoodOcto->CSet = OctoColor;
			GoodOcto->WeaponDamage = OctoDamage;
			GoodOcto->CollDetection = 0;
			GoodOcto->Dir = Link->Dir;
			if (OctoLWeapon == 0) GoodOcto->Weapon = 0;
			else
			{
				GoodOcto->Misc[MISC_NPCLWEAPON] = OctoLWeapon;
				GoodOcto->Misc[MISC_NPCLWEAPONSPRITE] = OctoLWeaponSprite;
				GoodOcto->Misc[MISC_NPCLWEAPONTIMER] = Rand(128);
			}
			Game->PlaySound(SFX_SOMARIA);
		}
	}
}

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// Ally NPC / Octorok Item script (End)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------



// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// "Item Creates LWeapon" Item Script (Start)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// NOTE: Used to create/destroy Item: Bola and Item: Armos. Bola and Armos movement are controlled in the global.
// For Bola details, see also: "Item: Bola movement"
// For Armos details, see also: "Item: Armos movement". "Item: Armos", and "Can be pushed by Armos LWeapons"


item script ItemCreatesLWeapon
{
	void run(int LWeaponToMake, int LWeaponSprite, int LWeaponDamage, int LWeaponStep, int MaxNumber, int LWeaponSFX, int WhereToMake, int RupyCost)
	{

	// D0: LWeapon to create.
	// D1: LWeapon Sprite.
	// D2: LWeapon Damage.
	// D3: LWeapon Step speed.
	// D4: Maximum number of this LWeapon to make; 0 for infinite (spammable).
	// D5: SFX to play.
	// D6: If 0, is created one space in front of Link. If 1 or greater, is created on Link. If 2, Link also jumps when using the item.
	// D7: Item costs D7 rupies to use. (Yes I know it's spelled Rupee/Rupees outside of Zelda 1)


		if (RupyCost == 0 || Game->Counter[CR_RUPEES] >= RupyCost)
		{
			if (NumLWeaponsOf(LWeaponToMake) < MaxNumber || MaxNumber == 0)
			{
				if (RupyCost > 0) Game->DCounter[CR_RUPEES] = Game->DCounter[CR_RUPEES]- RupyCost;
				lweapon TossWeapon = NextToLink(LWeaponToMake,0);
				if (WhereToMake >= 1)
				{
					TossWeapon->X = Link->X; 
					TossWeapon->Y = Link->Y;
					if (WhereToMake == 2)
					{
						if (IsSideview()) Link->Jump = 1;
						else Link->Jump = 1.75;
					}
				}
				TossWeapon->UseSprite(LWeaponSprite);
				TossWeapon->Damage = LWeaponDamage;
				TossWeapon->Step = LWeaponStep;
				TossWeapon->Dir = Link->Dir;
				Link->Action = LA_ATTACKING;
				Game->PlaySound(LWeaponSFX);
			}
		}
	}
}
		
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// "Item Creates LWeapon" Item Script (End)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------



// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// Pickup Trigger Secrets (start)
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------

item script PickupTriggerSecrets
{
// D0 - If 0, secrets will be temporary. Otherwise, secrets will be permanent.

	void run(int IsTriggerPermanent)
	{
		Screen->TriggerSecrets();
		if (IsTriggerPermanent > 0) Screen->State[ST_SECRET] = true;
	}
}
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// Pickup Trigger Secrets (end)
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------



// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// Partner follow state reset (start)
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// Used for the pickup script on LTTP Superbombs (Partner Superbomb), to prevent the bomb from starting in a place the partner was left behind (so that the bomb will be following the player instead).

item script PartnerFollowReset
{
	void run()
	{
		Partner[FOLLOW_STATE] = 0;
	}
}
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// Partner follow state reset (end)
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------



// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// Stone Tablet Fragment pickup (start)
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------

item script FragmentPickup
{
	void run(int IsMagic, int SecondMap)
	{
//D0 - If 0, collecting this only collects the fragment for the current dmap. Otherwise, it will collect it for every dmap.
//D1 - If this is != 0, picking up this fragment will not only collect it for the current dmap, but also another dmap which is D1 number of dmaps later. (This is used for the secondary passageway dmaps each dungeon in this quest has.)

		Link->Item[I_FRAGMENT_SUBSCREEN] = true;
		if (IsMagic != 0)
		{
			for (int q = 511; q > 0; --q)
			{
				TabletFragments[q] = 1;
			}
		}
		else
		{
			TabletFragments[Game->GetCurDMap()] = 1;
			if (SecondMap != 0) TabletFragments[Game->GetCurDMap()+SecondMap] = 1;
		}
	}
}

// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// Stone Tablet Fragment pickup (end)
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------



// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// "Byrna startup sound" script (start)
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// Because I wanted the Cane of Byrna to make a noise, but not continuously.

item script ByrnaSound
{
	void run(int SoundToMake)
	{
		if (NumLWeaponsOf(LW_CANEOFBYRNA) == 0) Game->PlaySound(SoundToMake);
	}
}
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// "Byrna startup noise" script (end)
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------




// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// "Remove LWeapon" item script (start)
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------

item script RemoveLWeapon
{
	void run(int WhatWeapon)
	{
		if (NumLWeaponsOf(WhatWeapon) > 0)
		{
			lweapon RemoveWeapon = LoadLWeaponOf(WhatWeapon);
			if (RemoveWeapon->isValid()) Remove(RemoveWeapon);
		}
	}
}
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// "Remove LWeapon" item script (end)
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------



// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// Add Remove Item item script (start)
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------

item script AddRemoveItem
{
	void run(int AddItem, int RemoveItem, int ByrnaSound, int UnlessWeapon)
	{
// D0 - item to add to inventory when used
// D1 - item to remove from inventory when used
// D2 - Makes a sound if there are no byrna weapons when it's used
// D3 - Will not add or remove items if lweapon D3 is onscreen.

		if (UnlessWeapon == 0 || NumLWeaponsOf(UnlessWeapon) == 0)
		{
			if (AddItem > 0) Link->Item[AddItem] = true;
			if (RemoveItem > 0) Link->Item[RemoveItem] = false;
		}
		if (ByrnaSound > 0)
		{
			if (NumLWeaponsOf(LW_CANEOFBYRNA) == 0) Game->PlaySound(ByrnaSound);
		}
	}
}
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// Add or Remove Item item script (end)
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------



// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// Rope Item script (Start)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// NOTE: Actual climbing capabilities of the rope are in the Global script, not this item script.


item script RopeItem
{
	void run(int Length, int SP_ROPEVERTICAL, int SP_ROPEHORIZONTAL, int SP_ROPEUPLONG, int SP_ROPEDOWNLONG, int SP_ROPELEFTLONG, int SP_ROPERIGHTLONG, int PoofingRope)
	{

	// D0: Length of rope. 0-1 for 1 tile, 2 or greater for 2 tiles.
	// D1: Weapon Sprite ID for 1x1 rope (vertical).
	// D2: Weapon Sprite ID for 1x1 rope (horizontal).
	// D3: Weapon Sprite ID for two-tile rope (facing up).
	// D4: Weapon Sprite ID for two-tile rope (facing down).
	// D5: Weapon Sprite ID for two-tile rope (facing left).
	// D6: Weapon Sprite ID for two-tile rope (facing right).
	// D7: if > 0, Weapon will poof in and out of existence. If D7 == 22, wepaon will only poof in and out of existence if Link does not have item I_ITEMSGFX (alternate item graphics mode).

		if (Link->Action != LA_SWIMMING && Link->Action != LA_HOLD1WATER && Link->Action != LA_HOLD2WATER) Link->Action = LA_ATTACKING;

		lweapon NewRope;
		NewRope = LoadLWeaponOf(LW_ROPE);

//----------- Remove an old rope
		if (NewRope->isValid())
		{
			if (Screen->ComboS[ComboAt(Link->X+7,Link->Y+8)] == 0 || !LinkCollision(NewRope))
			{
				if (Length < 2 || NewRope->TileWidth > 1 || NewRope->TileHeight > 1)
				{
					if (PoofingRope > 0)
					{
						if (PoofingRope != 22 || !Link->Item[I_ITEMSGFX])
						{
							lweapon	RopePoof = CreateLWeaponAt(LW_SPARKLE,NewRope->X+((NewRope->TileWidth-1)*8),NewRope->Y+((NewRope->TileHeight-1)*8));
							RopePoof->UseSprite(SP_MISC_DEATH);
							Game->PlaySound(SFX_ROPE);
						}
					}
					Remove(NewRope);
				}

//----------- Extend-o-rope
				if (Length >= 2 && NewRope->TileWidth == 1 && NewRope->TileHeight == 1)
				{
					NewRope->Extend = 3;
					if (PoofingRope > 0) Game->PlaySound(SFX_CHARGE1);
					if (NewRope->Dir == DIR_LEFT || NewRope->Dir == DIR_RIGHT)
					{
						NewRope->TileWidth = 2;
						NewRope->HitWidth = 32;
						if (NewRope->Dir == DIR_LEFT) NewRope->X = NewRope->X - 16;
					}
					else
					{
						NewRope->TileHeight = 2;
						NewRope->HitHeight = 32;
						if (NewRope->Dir == DIR_UP) NewRope->Y = NewRope->Y - 16;
					}
					//if (!IsSideview()) NewRope->X = ComboX(ComboAt(NewRope->X+7,NewRope->Y+8));
					//if (!IsSideview()) NewRope->Y = ComboY(ComboAt(NewRope->X+7,NewRope->Y+8));
					NewRope->Flip = FLIP_NONE;
					if (NewRope->Dir == DIR_UP) NewRope->UseSprite(SP_ROPEUPLONG);
					if (NewRope->Dir == DIR_DOWN) NewRope->UseSprite(SP_ROPEDOWNLONG);
					if (NewRope->Dir == DIR_LEFT) NewRope->UseSprite(SP_ROPELEFTLONG);
					if (NewRope->Dir == DIR_RIGHT) NewRope->UseSprite(SP_ROPERIGHTLONG);
				}
			}
		}


//----------- Create a new rope

		else
		{
			NewRope = NextToLink(LW_ROPE,0);
			NewRope->CollDetection = false;

			NewRope->Dir = Link->Dir;
			if (NewRope->Dir == DIR_UP || NewRope->Dir == DIR_DOWN) NewRope->UseSprite(SP_ROPEVERTICAL);
			//if (NewRope->Dir == DIR_DOWN) NewRope->Flip = FLIP_VERTICAL;
			if (NewRope->Dir == DIR_LEFT || NewRope->Dir == DIR_RIGHT) NewRope->UseSprite(SP_ROPEHORIZONTAL);
			if (NewRope->Dir == DIR_LEFT) NewRope->Flip = FLIP_HORIZONTAL;
			if (!IsSideview()) NewRope->X = ComboX(ComboAt(NewRope->X+7,NewRope->Y+8));
			if (!IsSideview()) NewRope->Y = ComboY(ComboAt(NewRope->X+7,NewRope->Y+8));
			NewRope->HitHeight = 16;
			NewRope->HitWidth = 16;
			if (PoofingRope > 0)
			{
				if (PoofingRope != 22 || !Link->Item[I_ITEMSGFX])
				{
					lweapon	RopePoof = CreateLWeaponAt(LW_SPARKLE,NewRope->X,NewRope->Y);
					RopePoof->UseSprite(SP_SPAWN);
					Game->PlaySound(SFX_ROPE);
				}
			}
		}
	}
}
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// Rope Item script (End)
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------




// ---------------------------------------------- Section 6: FFC scripts

// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// "Press Start to Warp" script (start)
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// Puts Link on the top side of the screen, to use a side warp placed there.

ffc script StartWarp
{
	void run(int IgnoreInputStart)
	{
//D0 - Set to != 0 to prevent holding down the start button from triggering the warp, only allowing pressing.

		while(true)
		{
			Waitframe();
			if (Link->PressStart || Link->InputStart && IgnoreInputStart == 0) Link->Y = -16;
		}
	}
}
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// "Press Start to Warp" script (end)
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------

// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// "Play Sound" script (start)
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// "Play SFX on screen entry" only plays when scrolling onto a screen. (I think that's intentional ZC behavior?)

ffc script PlaySound
{
	void run(int SoundToMake, int UponCollision, int DevRoomMusic)
	{
		if (DevRoomMusic > 0)
		{
			int LOTWMusic[20] = "LegacyofWizard.nsf";
			Game->PlayEnhancedMusic(LOTWMusic,13);
		}
		if (UponCollision == 0) Game->PlaySound(SoundToMake);
		else
		{
			while(true)
			{
				Waitframe();
				if (LinkCollision(this))
				{
					Game->PlaySound(SoundToMake);
					Quit();
				}
			}
		}
	}
}
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// "Play Sound" script (end)
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------

// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// "Fill Counter Touch" script (start)
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
ffc script FillCounter
{
	void run(int WhatCounter, int CounterMinimum)
	{
		while(true)
		{
			Waitframe();
			if (LinkCollision(this))
			{
				if (Game->Counter[WhatCounter] >= CounterMinimum && Game->Counter[WhatCounter] < Game->MCounter[WhatCounter]) Game->DCounter[WhatCounter] = Game->MCounter[WhatCounter];
			}
		}
	}
}
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// "Play Sound" script (end)
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Crazy Patras (start)
// Original by Mitsukara but heavily improved upon by Dimi with new patterns (pattern 4 and up, such as circular and multiple rings) and pattern-changing
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
ffc script CrazyPatra
{
	void run(int WhatID, int WhatEyeD, int NumEyes, int WhichPattern, int PatternSize, int EyeStrength, int EyeLag, int EyeSpeed)
	{
//D0 - ID of main Patra Core.
//D1 - ID of Patra eyes to spawn
//D2 - How many eyes to spawn
//D3 - Choose a pattern:
		//0 - Square
		//1 - Diamond
		//2 - Triangle
		//3 - Upside down Triangle
		//4 - Circle + Diamond
		//5 - Circle + Diamond + Square
		//6 - Triangle + Circle
		//7 - Reverse + Triangle + Circle
//D4 - Pattern shrink/grow size.
//D5 - Patra HP behavior:
	// If 0, all eyes spawn at start. Once eyes are defeated, the core will become vulnerable to Sword, Beams, Wand, Hammer, Cane of Byrna, and Script Weapons (with the assumption that the enenmy editor enemy was invincible to those weapons before, though that isn't required). 
	// If 1, all eyes spawn at start. Eyes and center will always have identical HP (so killing any part destroys them all). This can also be used for requiring you to defeat the core, with invincible eyes.
	// If 2, same as 0 except that the core will also have it's weapon set to EW_FIREBALL2 once eyes are defeated.
//D6 - Patra eye segment lag
//D7 - Speed of eyes
	

		Waitframes(4);

		npc PatraCore;
		PatraCore = LoadNPCOf(WhatID);
		if (!PatraCore->isValid()) Quit();
		npc PatraEye[255];
		int FFCForTimer;
		int SpeedForTimer;
		int PatternFlex;
		bool FlexUp;
		int WaitToFlex;
		int AimX[32];
		int AimY[32];
		int CenterPosition[3];
		int PatraAngle; //For pattern 4 and up
		CenterPosition[1] = PatraCore->X;
		CenterPosition[2] = PatraCore->Y;

		for(FFCForTimer = NumEyes; FFCForTimer > 0; --FFCForTimer)
		{
			PatraEye[FFCForTimer] = CreateNPCAt(WhatEyeD,PatraCore->X,PatraCore->Y);
			PatraEye[FFCForTimer]->Misc[MISC_SEGMENTLAG] = EyeLag;
			PatraEye[FFCForTimer]->HitHeight = 8;
			PatraEye[FFCForTimer]->HitYOffset = 4;
			PatraEye[FFCForTimer]->HitWidth = 12;
			PatraEye[FFCForTimer]->HitXOffset = 2;
		}
		if (WhichPattern >= 4)
		{
			for(FFCForTimer = NumEyes*2; FFCForTimer > NumEyes; --FFCForTimer)
			{
				PatraEye[FFCForTimer] = CreateNPCAt(WhatEyeD,PatraCore->X,PatraCore->Y);
				PatraEye[FFCForTimer]->Misc[MISC_SEGMENTLAG] = EyeLag;
				PatraEye[FFCForTimer]->HitHeight = 8;
				PatraEye[FFCForTimer]->HitYOffset = 4;
				PatraEye[FFCForTimer]->HitWidth = 12;
				PatraEye[FFCForTimer]->HitXOffset = 2;
			}
			if (WhichPattern == 5)
			{
				for(FFCForTimer = NumEyes*3; FFCForTimer > NumEyes*2; --FFCForTimer)
				{
					PatraEye[FFCForTimer] = CreateNPCAt(WhatEyeD,PatraCore->X,PatraCore->Y);
					PatraEye[FFCForTimer]->Misc[MISC_SEGMENTLAG] = (EyeLag/5)*2;
					PatraEye[FFCForTimer]->HitHeight = 8;
					PatraEye[FFCForTimer]->HitYOffset = 4;
					PatraEye[FFCForTimer]->HitWidth = 12;
					PatraEye[FFCForTimer]->HitXOffset = 2;
				}
			}
		}
		PatraCore->Stun = NumEyes * EyeLag;

		// Patterns:
		if (WhichPattern == 0)
		{
			AimX[1] = -16;
			AimY[1] = -16;
			AimX[2] = 16;
			AimY[2] = -16;
			AimX[3] = 16;
			AimY[3] = 16;
			AimX[4] = -16;
			AimY[4] = 16;
		}
		else if (WhichPattern == 1 || WhichPattern == 4 || WhichPattern == 5)
		{
			AimX[1] = 0;
			AimY[1] = -40;
			AimX[2] = 40;
			AimY[2] = 0;
			AimX[3] = 0;
			AimY[3] = 40;
			AimX[4] = -40;
			AimY[4] = 0;
			if (WhichPattern == 5)
			{
				AimX[5] = -16;
				AimY[5] = -16;
				AimX[6] = -16;
				AimY[6] = 16;
				AimX[7] = 16;
				AimY[7] = 16;
				AimX[8] = 16;
				AimY[8] = -16;
			}
		}
		else if (WhichPattern == 2 || WhichPattern == 6)
		{
			AimX[1] = 0;
			AimY[1] = -24;
			AimX[2] = 40;
			AimY[2] = 16;
			AimX[3] = -40;
			AimY[3] = 16;
		}
		else if (WhichPattern == 3 || WhichPattern == 7)
		{
			AimX[1] = 0;
			AimY[1] = 24;
			AimX[2] = 40;
			AimY[2] = -16;
			AimX[3] = -40;
			AimY[3] = -16;
		}


		while(true)
		{
			Waitframe();
			{

				if (!PatraCore->isValid()) Quit();
				else
				{

					// Eyes move with center as it moves:
					if (CenterPosition[1] != PatraCore->X || CenterPosition[2] != PatraCore->Y)
					{
						for(FFCForTimer = NumEyes; FFCForTimer > 0; --FFCForTimer)
						{
							if (PatraEye[FFCForTimer]->isValid())
							{
								PatraEye[FFCForTimer]->X = (PatraEye[FFCForTimer]->X + ((PatraCore->X) - CenterPosition[1]));
								PatraEye[FFCForTimer]->Y = (PatraEye[FFCForTimer]->Y + ((PatraCore->Y) - CenterPosition[2]));
							}
						}
						if (WhichPattern == 5)
						{
							for(FFCForTimer = NumEyes*3; FFCForTimer > NumEyes*2; --FFCForTimer)
							{
								if (PatraEye[FFCForTimer]->isValid())
								{
									PatraEye[FFCForTimer]->X = (PatraEye[FFCForTimer]->X + ((PatraCore->X) - CenterPosition[1]));
									PatraEye[FFCForTimer]->Y = (PatraEye[FFCForTimer]->Y + ((PatraCore->Y) - CenterPosition[2]));
								}
							}
						}
						CenterPosition[1] = PatraCore->X;
						CenterPosition[2] = PatraCore->Y;
					}


					// --- Eyes movement:

					// Pattern size flexing:
					if (WaitToFlex > 0) --WaitToFlex;
					else if (PatternSize > 0)
					{
						if (PatraCore->Stun == 0)
						{
							if (FlexUp)
							{
								if (PatternFlex < PatternSize) ++PatternFlex;
								else FlexUp = false;
							}
							else
							{
								if (PatternFlex > 0) --PatternFlex;
								else if (!FlexUp)
								{
									FlexUp = true;
									WaitToFlex = EyeLag * 8;
								}
							}
							if (WhichPattern == 0)
							{
								AimX[1] = -(16+PatternFlex);
								AimY[1] = -(16+PatternFlex);
								AimX[2] = (16+PatternFlex);
								AimY[2] = -(16+PatternFlex);
								AimX[3] = (16+PatternFlex);
								AimY[3] = (16+PatternFlex);
								AimX[4] = -(16+PatternFlex);
								AimY[4] = (16+PatternFlex);
							}
							else if (WhichPattern == 1 || WhichPattern >= 4)
							{
								AimX[1] = (0+PatternFlex);
								AimY[1] = -(40+PatternFlex);
								AimX[2] = (40+PatternFlex);
								AimY[2] = (0+PatternFlex);
								AimX[3] = (0+PatternFlex);
								AimY[3] = (40+PatternFlex);
								AimX[4] = -(40+PatternFlex);
								AimY[4] = (0+PatternFlex);
								if (WhichPattern == 5)
								{
									AimX[1] = -(16+PatternFlex);
									AimY[1] = -(16+PatternFlex);
									AimX[2] = -(16+PatternFlex);
									AimY[2] = (16+PatternFlex);
									AimX[3] = (16+PatternFlex);
									AimY[3] = (16+PatternFlex);
									AimX[4] = (16+PatternFlex);
									AimY[4] = -(16+PatternFlex);
								}
							}
							else if (WhichPattern == 2)
							{
								AimX[1] = (0+PatternFlex);
								AimY[1] = -(24+PatternFlex);
								AimX[2] = (40+PatternFlex);
								AimY[2] = (16+PatternFlex);
								AimX[3] = -(40+PatternFlex);
								AimY[3] = (16+PatternFlex);
							}
							else if (WhichPattern == 3)
							{
								AimX[1] = (0+PatternFlex);
								AimY[1] = (24+PatternFlex);
								AimX[2] = (40+PatternFlex);
								AimY[2] = -(16+PatternFlex);
								AimX[3] = -(40+PatternFlex);
								AimY[3] = -(16+PatternFlex);
							}
						}
					}

					for(FFCForTimer = NumEyes; FFCForTimer > 0; --FFCForTimer)
					{
						if (PatraEye[FFCForTimer]->isValid())
						{
							// Segment Lag:
							if (PatraEye[FFCForTimer]->Misc[MISC_SEGMENTLAG] > 0)
							{
								if (FFCForTimer <= 1) --PatraEye[FFCForTimer]->Misc[MISC_SEGMENTLAG];
								else if (PatraEye[FFCForTimer-1]->isValid())
								{
									if (PatraEye[FFCForTimer-1]->Misc[MISC_SEGMENTLAG] == 0) --PatraEye[FFCForTimer]->Misc[MISC_SEGMENTLAG];
								}
							}
							else
							{
								if (PatraEye[FFCForTimer]->HP > 0)
								{
									// Move to X position:
									for (SpeedForTimer = EyeSpeed; SpeedForTimer > 0; --SpeedForTimer)
									{
										if (PatraEye[FFCForTimer]->X > PatraCore->X + AimX[PatraEye[FFCForTimer]->Misc[MISC_NPCTURNWAIT]])
										{
											--PatraEye[FFCForTimer]->X;
											PatraEye[FFCForTimer]->Dir = DIR_LEFT;
										}
										else if (PatraEye[FFCForTimer]->X < PatraCore->X + AimX[PatraEye[FFCForTimer]->Misc[MISC_NPCTURNWAIT]]) 
										{
											++PatraEye[FFCForTimer]->X;
											PatraEye[FFCForTimer]->Dir = DIR_RIGHT;
										}
									}
									// Move to Y position:
									for (SpeedForTimer = EyeSpeed; SpeedForTimer > 0; --SpeedForTimer)
									{
										if (PatraEye[FFCForTimer]->Y > PatraCore->Y + AimY[PatraEye[FFCForTimer]->Misc[MISC_NPCTURNWAIT]])
										{
											--PatraEye[FFCForTimer]->Y;
											PatraEye[FFCForTimer]->Dir = DIR_UP;
										}
										else if (PatraEye[FFCForTimer]->Y < PatraCore->Y + AimY[PatraEye[FFCForTimer]->Misc[MISC_NPCTURNWAIT]])
										{
											++PatraEye[FFCForTimer]->Y;
											PatraEye[FFCForTimer]->Dir = DIR_DOWN;
										}
									}
		
									// Set next X and Y positions to move to:
									if (PatraEye[FFCForTimer]->X == PatraCore->X + AimX[PatraEye[FFCForTimer]->Misc[MISC_NPCTURNWAIT]] && PatraEye[FFCForTimer]->Y == PatraCore->Y + AimY[PatraEye[FFCForTimer]->Misc[MISC_NPCTURNWAIT]]) ++PatraEye[FFCForTimer]->Misc[MISC_NPCTURNWAIT];
	
									// Roll over to first X and Y position at end of pattern:
									if ((WhichPattern <= 1 || WhichPattern == 4 || WhichPattern == 5) && PatraEye[FFCForTimer]->Misc[MISC_NPCTURNWAIT] == 5 || WhichPattern >= 2 && (WhichPattern < 4 || WhichPattern > 5) && PatraEye[FFCForTimer]->Misc[MISC_NPCTURNWAIT] == 4) PatraEye[FFCForTimer]->Misc[MISC_NPCTURNWAIT] = 1;
								}
							}
						}
					}
					if (WhichPattern >= 4)
					{
						for(FFCForTimer = NumEyes*2; FFCForTimer > NumEyes; --FFCForTimer)
						{
							if (PatraEye[FFCForTimer]->isValid())
							{
								// Segment Lag:
								if (PatraEye[FFCForTimer]->Misc[MISC_SEGMENTLAG] > 0)
								{
									if (FFCForTimer <= NumEyes+1) --PatraEye[FFCForTimer]->Misc[MISC_SEGMENTLAG];
									else if (PatraEye[FFCForTimer-1]->isValid())
									{
										if (PatraEye[FFCForTimer-1]->Misc[MISC_SEGMENTLAG] == 0) --PatraEye[FFCForTimer]->Misc[MISC_SEGMENTLAG];
									}
								}
								else
								{
									if (PatraEye[FFCForTimer]->HP > 0)
									{
										PatraEye[FFCForTimer]->X = PatraCore->X + VectorX(40+PatternFlex, (((360 / NumEyes) * FFCForTimer) + PatraAngle) % 360);
										PatraEye[FFCForTimer]->Y = PatraCore->Y + VectorY(40+PatternFlex, (((360 / NumEyes) * FFCForTimer) + PatraAngle) % 360);
			
									}
								}
							}
						}
						if (WhichPattern == 7) PatraAngle+=EyeSpeed;
						else PatraAngle-=EyeSpeed;
						PatraAngle%=360;
						if (WhichPattern == 5)
						{
							for(FFCForTimer = NumEyes*3; FFCForTimer > NumEyes*2; --FFCForTimer)
							{
								if (PatraEye[FFCForTimer]->isValid())
								{
									// Segment Lag:
									if (PatraEye[FFCForTimer]->Misc[MISC_SEGMENTLAG] > 0)
									{
										if (FFCForTimer <= (NumEyes*2)+1) --PatraEye[FFCForTimer]->Misc[MISC_SEGMENTLAG];
										else if (PatraEye[FFCForTimer-1]->isValid())
										{
											if (PatraEye[FFCForTimer-1]->Misc[MISC_SEGMENTLAG] == 0) --PatraEye[FFCForTimer]->Misc[MISC_SEGMENTLAG];
										}
									}
									else
									{
										if (PatraEye[FFCForTimer]->Misc[MISC_NPCTURNWAIT] < 5) PatraEye[FFCForTimer]->Misc[MISC_NPCTURNWAIT] = 5;
										if (PatraEye[FFCForTimer]->HP > 0)
										{
											// Move to X position:
											for (SpeedForTimer = EyeSpeed*2; SpeedForTimer > 0; --SpeedForTimer)
											{
												if (PatraEye[FFCForTimer]->X > PatraCore->X + AimX[PatraEye[FFCForTimer]->Misc[MISC_NPCTURNWAIT]])
												{
													--PatraEye[FFCForTimer]->X;
													PatraEye[FFCForTimer]->Dir = DIR_LEFT;
												}
												else if (PatraEye[FFCForTimer]->X < PatraCore->X + AimX[PatraEye[FFCForTimer]->Misc[MISC_NPCTURNWAIT]]) 
												{
													++PatraEye[FFCForTimer]->X;
													PatraEye[FFCForTimer]->Dir = DIR_RIGHT;
												}
											}
											// Move to Y position:
											for (SpeedForTimer = EyeSpeed*2; SpeedForTimer > 0; --SpeedForTimer)
											{
												if (PatraEye[FFCForTimer]->Y > PatraCore->Y + AimY[PatraEye[FFCForTimer]->Misc[MISC_NPCTURNWAIT]])
												{
													--PatraEye[FFCForTimer]->Y;
													PatraEye[FFCForTimer]->Dir = DIR_UP;
												}
												else if (PatraEye[FFCForTimer]->Y < PatraCore->Y + AimY[PatraEye[FFCForTimer]->Misc[MISC_NPCTURNWAIT]])
												{
													++PatraEye[FFCForTimer]->Y;
													PatraEye[FFCForTimer]->Dir = DIR_DOWN;
												}
											}
				
											// Set next X and Y positions to move to:
											if (PatraEye[FFCForTimer]->X == PatraCore->X + AimX[PatraEye[FFCForTimer]->Misc[MISC_NPCTURNWAIT]] && PatraEye[FFCForTimer]->Y == PatraCore->Y + AimY[PatraEye[FFCForTimer]->Misc[MISC_NPCTURNWAIT]]) ++PatraEye[FFCForTimer]->Misc[MISC_NPCTURNWAIT];
			
											// Roll over to first X and Y position at end of pattern:
											if (PatraEye[FFCForTimer]->Misc[MISC_NPCTURNWAIT] == 9) PatraEye[FFCForTimer]->Misc[MISC_NPCTURNWAIT] = 5;
										}
									}
								}
							}
						}
					}
					
					if (EyeStrength == 0 || EyeStrength == 2)
					{
						if (PatraCore->Defense[NPCD_SWORD] != NPCDT_NONE)
						{
							if (NumNPCsOf(WhatEyeD) == 0)
							{
								if (EyeStrength == 2) PatraCore->Weapon = EW_FIREBALL2;
								PatraCore->Defense[NPCD_SWORD] = NPCDT_NONE;
								PatraCore->Defense[NPCD_BEAM] = NPCDT_NONE;
								PatraCore->Defense[NPCD_WAND] = NPCDT_NONE;
								PatraCore->Defense[NPCD_HAMMER] = NPCDT_NONE;
								PatraCore->Defense[NPCD_BYRNA] = NPCDT_NONE;
								PatraCore->Defense[NPCD_SCRIPT] = NPCDT_NONE;
							}
						}
					}
					else if (EyeStrength == 1)
					{
						for(FFCForTimer = NumEyes; FFCForTimer > 0; --FFCForTimer)
						{
							if (PatraCore->HP < PatraEye[FFCForTimer]->HP) PatraEye[FFCForTimer]->HP = PatraCore->HP;
							else if (PatraEye[FFCForTimer]->HP < PatraCore->HP) PatraCore->HP = PatraEye[FFCForTimer]->HP;
						}
						if (WhichPattern >= 4)
						{
							for(FFCForTimer = NumEyes*2; FFCForTimer > NumEyes; --FFCForTimer)
							{
								if (PatraCore->HP < PatraEye[FFCForTimer]->HP) PatraEye[FFCForTimer]->HP = PatraCore->HP;
								else if (PatraEye[FFCForTimer]->HP < PatraCore->HP) PatraCore->HP = PatraEye[FFCForTimer]->HP;
							}
						}
					}
				}
			}
		}
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Crazy Patras (end)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// FFC script: Enemy Combo Weakness (start)
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
ffc script EnemySpikeWeakness
{
	void run(int WhatID, int WhatCombo, int WhatWeapon, int WhatDamage)
	{
		npc randoNPC;
		int FFCForTimer;
		int SpawnWeapon;
		lweapon SpikeDamage;
		lweapon FirstBait;

		while(true)
		{
			Waitframe();
			{
				for(FFCForTimer = Screen->NumNPCs(); FFCForTimer > 0; --FFCForTimer)
				{
					randoNPC = Screen->LoadNPC(FFCForTimer);
					if (!randoNPC->isValid()) continue;
					{
						if (randoNPC->ID == WhatID)
						{
							if (Screen->ComboD[ComboAt(randoNPC->X+7,randoNPC->Y+8)] == WhatCombo)
							{
								if (SpawnWeapon == 0) 
								{
									SpikeDamage = CreateLWeaponAt(WhatWeapon,randoNPC->X,randoNPC->Y);
									if (SpikeDamage->isValid())
									{ 
										SpikeDamage->Damage = WhatDamage;
										SpikeDamage->DrawYOffset = 255;
									}
									SpawnWeapon = 16;
								}
							}
						}
					}
				}	
				if (SpawnWeapon == 0)
				{
					if (SpikeDamage->isValid()) Remove(SpikeDamage);
				}
				else -- SpawnWeapon;
			}
		}
	}
}
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// FFC script: Enemy Combo Weakness (end)
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------

// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// FFC script: Limit EWeapons (start)
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------

ffc script LimitEWeapons
{
	void run(int WhatWeapon, int MaxWeapons)
	{

	npc Gleeick;
	int FFCForTimer;

		while(true)
		{
			Waitframe();
			{
				for(FFCForTimer = Screen->NumNPCs(); FFCForTimer > 0; --FFCForTimer)
				{
					Gleeick = Screen->LoadNPC(FFCForTimer);
					if (!Gleeick->isValid()) continue;
					{	
						if (NumEWeaponsOf(WhatWeapon) >= MaxWeapons)
						{
							Gleeick->Weapon = 0;
						}
						else if (Gleeick->Weapon == 0) Gleeick->Weapon = WhatWeapon;
					}
				}
			}
		}
	}
}
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// FFC script: Limit Eweapons (end)
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------

// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// FFC script: Once Only Shop (start)
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// NOTE: This script is intended for the "More Arrows" room type. This is mostly just to simulate a Z1 "Bet you'd like to have more bombs" room for other purposes.
// Thanks to Avaro for the concept.

ffc script OnceOnlyShop
{
	void run(int WhatItem, int WhatCounter, int WhatCounterAmount)
	{
// D0 - If != 0, gives Link item D0 instead of an arrow upgrade. Link will hold up the item.
// D1 - If != 0, increases the maximum of Link's counter D1 by the amount of D2.
// D2 - See D1.

		int StartingMArrow = Game->MCounter[CR_ARROWS];
		int StartingArrow = Game->Counter[CR_ARROWS];

		Waitframes(4);
		if (Screen->NumNPCs() < 3) Quit();

		while(true)
		{
			Waitframe();
			{
				if (Game->MCounter[CR_ARROWS] > StartingMArrow)
				{
					Game->MCounter[CR_ARROWS] = StartingMArrow;
					Game->Counter[CR_ARROWS] = StartingArrow;
					if (!IsRandomizer() || !RememberStuff[REMEMBER_RANDO_OPTIONS+6])
					{
						if (WhatItem > 0)
						{
							//item Huzzah = CreateItemAt(WhatItem,Link->X,Link->Y);
							//Huzzah->Z = Link->Z;
							//Huzzah->Pickup = IP_HOLDUP;
							if (WhatItem == I_WALLET500)
							{
								Game->MCounter[CR_RUPEES] = 500;
							}
							if (WhatItem == I_WALLET999)
							{
								Game->MCounter[CR_RUPEES] = 999;
							}
							if (WhatItem == I_MAGICMAP)
							{
								for ( int q = 0; q < __classic_zh_MAX_ITEMS; ++q )
								{
									Game->LItems[q] |= LI_MAP;
								}
							}
							if (WhatItem == I_MAGICCOMPASS)
							{
								for ( int q = 0; q < __classic_zh_MAX_ITEMS; ++q )
								{
									Game->LItems[q] |= LI_COMPASS;
								}
							}
							Link->Item[WhatItem] = true;
						}
						if (WhatCounter > 0)
						{
							Game->MCounter[WhatCounter] = Game->MCounter[WhatCounter] + WhatCounterAmount;
							Game->Counter[WhatCounter] = Game->Counter[WhatCounter] + WhatCounterAmount;
						}
					}
					else
					{
						//for (int i = 0; i < 60; ++i) WaitNoAction();
						int location = 0;
						if (RememberStuff[REMEMBER_SCREEN] == 0x03) location = 7;
						if (RememberStuff[REMEMBER_SCREEN] == 0x56) location = 23;
						if (RememberStuff[REMEMBER_SCREEN] == 0x76) location = 25;
						if (RememberStuff[REMEMBER_SCREEN] == 0x5E) location = 34;
						if (RememberStuff[REMEMBER_SCREEN] == 0x1F) location = 39;
						
						if (RememberStuff[REMEMBER_SCREEN] == 0x49) location = 3;
						if (RememberStuff[REMEMBER_SCREEN] == 0x15) location = 5;
						if (RememberStuff[REMEMBER_SCREEN] == 0x73) location = 19;
						
						if (RememberStuff[REMEMBER_SCREEN] == 0x7A) location = 30;
						
						int WhatItem2 = Randomizer_GetItemReplacement(location);
						Link->Action = LA_HOLD2LAND;
						Link->HeldItem = WhatItem2;
						Game->PlaySound(20);
						if (WhatItem2 == I_WALLET500)
						{
							Game->MCounter[CR_RUPEES] = 500;
						}
						if (WhatItem2 == I_WALLET999)
						{
							Game->MCounter[CR_RUPEES] = 999;
						}
						if (WhatItem2 == I_MAGICMAP)
						{
							for ( int q = 0; q < __classic_zh_MAX_ITEMS; ++q )
							{
								Game->LItems[q] |= LI_MAP;
							}
						}
						if (WhatItem2 == I_MAGICCOMPASS)
						{
							for ( int q = 0; q < __classic_zh_MAX_ITEMS; ++q )
							{
								Game->LItems[q] |= LI_COMPASS;
							}
						}
						if (WhatItem2 == 247)
						{
							for (int i = 1; i <= 8; ++i)
							{
								if (Game->LItems[i] & LI_TRIFORCE) continue;
								Game->LItems[i] |= LI_TRIFORCE;
								break;
							}
						}
						if (WhatItem2 == 199)
						{
							Link->MaxHP += 8;
							Link->HP += 8;
						}
						if (WhatItem2 == 28)
						{
							Link->MaxHP += 16;
							Link->HP += 16;
						}
						if (WhatItem2 == 187)
						{
							Game->MCounter[CR_ACORNS] += 16;
							Game->Counter[CR_ACORNS] += 16;
						}
						if (WhatItem2 == 9)
						{
							++Game->Counter[CR_KEYS];
						}
						if (WhatItem2 == 0 || WhatItem2 == 202 || WhatItem2 == 1 || WhatItem2 == 86 ||
						WhatItem2 == 38 || WhatItem2 == 192 || WhatItem2 == 39 || WhatItem2 == 87 ||
						WhatItem2 == 40)
						{
							if (WhatItem2 == 0) ++Game->DCounter[CR_RUPEES];
							if (WhatItem2 == 202) Game->DCounter[CR_RUPEES]+=2;
							if (WhatItem2 == 1) Game->DCounter[CR_RUPEES]+=5;
							if (WhatItem2 == 86) Game->DCounter[CR_RUPEES]+=10;
							if (WhatItem2 == 38) Game->DCounter[CR_RUPEES]+=20;
							if (WhatItem2 == 192) Game->DCounter[CR_RUPEES]+=30;
							if (WhatItem2 == 39) Game->DCounter[CR_RUPEES]+=50;
							if (WhatItem2 == 87) Game->DCounter[CR_RUPEES]+=100;
							if (WhatItem2 == 40) Game->DCounter[CR_RUPEES]+=255;
						}
						if (WhatItem == 27) Link->Item[227] = true;
						Link->Item[WhatItem2] = true;
					}
					Quit();
				}
			}
		}
	}
}
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// FFC script: Once Only Shop (end)
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------

// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// FFC script: Growing Digdogger (start)
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// Kills one enemy with LW_WHISTLE and spawns an arbitrary number of another enemy to replace them.

ffc script GrowingDigDogger
{
	void run(int WhistleNPC, int SpawnNPC, int HowManySpawn)
	{
		npc Dogdigger;
		lweapon WhistleWeapon;
		int FFCForTimer;

		while(true)
		{
			Waitframe();
			{
				if (NumLWeaponsOf(LW_WHISTLE) > 0)
				{
					if (NumNPCsOf(SpawnNPC) < 64)
					{
						for(FFCForTimer = Screen->NumNPCs(); FFCForTimer > 0; --FFCForTimer)
						{
							Dogdigger = Screen->LoadNPC(FFCForTimer);
							if (!Dogdigger->isValid()) continue;
							{
								if (SpawnNPC > 0 && HowManySpawn > 0)
								{
									for(int ForSpawn = HowManySpawn; ForSpawn > 0; --ForSpawn) npc DogSpawn = CreateNPCAt(SpawnNPC,Dogdigger->X,Dogdigger->Y);
								}
								Remove(Dogdigger);
							}
						}
						lweapon KillWhistle = LoadLWeaponOf(LW_WHISTLE);
						if (KillWhistle->isValid()) Remove(KillWhistle);
					}
					else
					{
						for(FFCForTimer = Screen->NumNPCs(); FFCForTimer > 0; --FFCForTimer)
						{
							Dogdigger = Screen->LoadNPC(FFCForTimer);
							if (!Dogdigger->isValid()) continue;
							{
								Dogdigger->HP = 0;
							}
						}
						lweapon KillWhistle = LoadLWeaponOf(LW_WHISTLE);
						if (KillWhistle->isValid()) Remove(KillWhistle);
					}
				}
			}
		}
	}
}
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// FFC script: Growing Digdogger (end)
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------

// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// FFC script: ChangeTwoNPCSizes (start)
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// Shrinks one enemy to 16x16 and sets it's originaltile, and grows one enemy and sets it's originaltile.

ffc script ChangeTwoNPCSizes
{
	void run(int ShrinkNPC, int ShrinkTile, int GrowNPC, int GrowTile)
	{
		npc randoNPC;
		int FFCForTimer;

		while(true)
		{
			Waitframe();
			{
				for(FFCForTimer = Screen->NumNPCs(); FFCForTimer > 0; --FFCForTimer)
				{
					randoNPC = Screen->LoadNPC(FFCForTimer);
					if (!randoNPC->isValid()) continue;
					{
						if (randoNPC->ID == ShrinkNPC)
						{
							if (randoNPC->OriginalTile != ShrinkTile)
							{
								randoNPC->OriginalTile = ShrinkTile;
								randoNPC->TileWidth = 1;
								randoNPC->TileHeight = 1;
								randoNPC->HitHeight = 16;
								randoNPC->HitWidth = 16;
							}
						}
						else if (randoNPC->ID == GrowNPC)
						{
							if (randoNPC->OriginalTile != GrowTile)
							{
								randoNPC->OriginalTile = GrowTile;
								randoNPC->TileWidth = 2;
								randoNPC->TileHeight = 2;
								randoNPC->HitHeight = 32;
								randoNPC->HitWidth = 32;
								randoNPC->DrawXOffset = -8;
								randoNPC->HitXOffset = -8;
								randoNPC->DrawYOffset = -8;
								randoNPC->HitYOffset = -8;
							}
						}
					}
				}
			}
		}
	}
}
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// FFC script: ChangeTwoNPCSizes (end)
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: New Gannon (start)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
const int SP_GANN_SWORD = 144;		//Sprite for "item" to hold up when Gannon fires swordbeams
const int SP_GANN_BRANG = 145;		//Sprite for "item" to hold up when Gannon throws a boomerang
const int SP_GANN_BOMB = 146;		//Sprite for "item" to hold up when Gannon drops a bomb
const int SP_GANN_ARROW = 147;		//Sprite for "item" to hold up when Gannon shoots an arrow
const int SP_GANN_FIRE = 148;		//Sprite for "item" to hold up when Gannon shoots fire
const int SP_GANN_MAGIC = 149;		//Sprite for "item" to hold up when Gannon shoots magic
const int SP_GANN_WIND = 150;		//Sprite for "item" to hold up when Gannon shoots wind
const int SP_GANN_BAIT = 151;		//Sprite for "item" to hold up when Gannon lays bait
const int SP_GANN_POTION1 = 152;	//Sprite for "item" to hold up when Gannon uses up his first potion
const int SP_GANN_POTION2 = 153;	//Sprite for "item" to hold up when Gannon uses up his second potion
const int SP_GANN_DEATH1 = 154;		//Sprite for vertical beam shards upon Gannon's death.
const int SP_GANN_DEATH2 = 155;		//Sprite for diagonal beam shards upon Gannon's death.
const int SP_GANN_DEATH3 = 156;		//Sprite for horizontal beam shards upon Gannon's death.
const int SP_GANN_DEATH4 = 157;		//Sprite for flashing Gannon upon Gannon's death (2x2).
const int I_DUSTPILENEW = 220;		//Dust pile item Gannon will spawn when dying (as a dummy item).

// Indices for GannWeapon[]
const int GANN_SWORD = 1;
const int GANN_BRANG = 2;
const int GANN_BOMB = 3;
const int GANN_ARROW = 4;
const int GANN_FIRE = 5;
const int GANN_MAGIC = 6;
const int GANN_WIND = 7;
const int GANN_BAIT = 8;
const int GANN_POTION = 9;
const int GANN_CHOOSE = 10;

const int I_FAKETRIFORCE = 226;		// Dummy holdup item ID for when the player enters the room and confronts Gannon. Is actually given to the player, so non-gameplay item is recommended, but you could also turn it into a sword or whatever you want.

// Array indices for StartData[]:
const int NEWGAN_ORIGDATA = 1;		// This FFC's original combo data ID
const int NEWGAN_FREEZETIMER = 2;	// Timer for this FFC to count down before going back to it's original combo data ID


ffc script NewGannon
{
	void run(int WhatID, int FireballOnly, int RequireSword)
	{
//D0 - ID of Gannon
//D1 - If 0, Gannon shoots EW_FIREBALL2. If >0, Gannon uses Link's items.	
//D2 - If 0, does nothing. If >0, Link possessing I_SWORD1, I_SWORD2, I_SWORD3, or I_SWORD4 will set Gannon's sword defense to None, and Link possessing I_ARROW2 will set Gannon's arrow defense to None.

		this->Flags[FFCF_ETHEREAL] = true;	
		Waitframes(5); // waits an extra frame so that Tough Enemies Mode can work on Gannon.
		npc Gannon;
		Gannon = LoadNPCOf(WhatID);
		if (!Gannon->isValid()) Quit();
		int StartData[3];
		StartData[1] = this->Data;

		// Hold up triforce intro
		if (Link->Y > 48)
		{
			Gannon->Stun = 60;
			Game->PlaySound(SFX_GANON);
			item HoldTriforce = CreateItemAt(I_FAKETRIFORCE,Link->X,Link->Y);
			HoldTriforce->Pickup = IP_HOLDUP;
			HoldTriforce->Z = Link->Z;
			//Link->Action = LA_HOLD2LAND;
			//Link->HeldItem = I_TRIFORCE;
		}

		int GannStartHP = Gannon->HP;
		int GannAttack;
		int TeleportTimer;
		int Teleporting;
		int WhatWeapon;
		int GannHitYOffset = Gannon->HitYOffset;
		int GannTile = Gannon->OriginalTile;
		if (Gannon->Stun == 0) Gannon->OriginalTile = GannTile + 40;
		lweapon DarkBait;
//		lweapon FirstBeetle;
		item TakeTheArrow;
		int GannonDeathTimer;
		int GannWeapon[64];
		GannWeapon[GANN_SWORD] = 1;
		GannWeapon[GANN_BRANG] = 1;
		GannWeapon[GANN_BOMB] = 1;
		GannWeapon[GANN_ARROW] = 1;
		GannWeapon[GANN_FIRE] = 1;
		GannWeapon[GANN_MAGIC] = 1;
		GannWeapon[GANN_WIND] = 1;
		GannWeapon[GANN_BAIT] = 1;
		GannWeapon[GANN_POTION] = 2;
		int FifthMusic[13] = "5thMusic.nsf";
		Game->SetDMapEnhancedMusic(Game->GetCurDMap(),FifthMusic,10);
		Game->PlayEnhancedMusic(FifthMusic,10);
		bool CreatedArrow = false;

		while(true)
		{
			Waitframe();
			{

				if (StartData[NEWGAN_FREEZETIMER] > 0) --StartData[2];
				else if (this->Data == COMBO_SCREENFREEZE1) this->Data = StartData[NEWGAN_ORIGDATA];

				if (GannonDeathTimer == 0)
				{
					if (Gannon->isValid())
					{	
						// Having one of the regular swords makes Gannon vulnerable to swords
						if (RequireSword > 0)
						{
							if (Gannon->Defense[NPCD_SWORD] != NPCDT_NONE) 
							{
								if (Gannon->Stun == 0)
								{
									if (Link->Item[I_SWORD1] || Link->Item[I_SWORD2] || Link->Item[I_SWORD3] || Link->Item[I_SWORD4]) Gannon->Defense[NPCD_SWORD] = NPCDT_NONE;
								}
							}
						}
		
						// Gannon's HP management
						if (Gannon->HP <= 0)
						{
							if (GannWeapon[GANN_POTION] == 2)
							{
								GannWeapon[GANN_POTION] = 1;
								if (NumLWeaponsOf(LW_SPARKLE) > 0)
								{
									lweapon RemoveSparkle = LoadLWeaponOf(LW_SPARKLE);
									if (RemoveSparkle->isValid()) Remove(RemoveSparkle);
								}
								lweapon DarkItem = CreateLWeaponAt(LW_SPARKLE,Gannon->X,Gannon->Y);
								DarkItem->UseSprite(SP_GANN_POTION1);
								DarkItem->DrawYOffset = -24;
								Gannon->HP = GannStartHP;
								Game->PlaySound(SFX_SCALE);
								Gannon->OriginalTile = GannTile;
								this->Data = COMBO_SCREENFREEZE1;
								StartData[2] = 120;
								TeleportTimer = 96;
							}
							else if (GannWeapon[GANN_POTION] == 1)
							{
								GannWeapon[GANN_POTION] = 0;
								if (NumLWeaponsOf(LW_SPARKLE) > 0)
								{
									lweapon RemoveSparkle = LoadLWeaponOf(LW_SPARKLE);
									if (RemoveSparkle->isValid()) Remove(RemoveSparkle);
								}
								lweapon DarkItem = CreateLWeaponAt(LW_SPARKLE,Gannon->X,Gannon->Y);
								DarkItem->UseSprite(SP_GANN_POTION2);
								DarkItem->DrawYOffset = -24;
								Gannon->HP = GannStartHP;
								Game->PlaySound(SFX_SCALE);
								Gannon->OriginalTile = GannTile;
								this->Data = COMBO_SCREENFREEZE1;
								StartData[2] = 120;
								TeleportTimer = 96;
							}
							else
							{
								Gannon->CSet = 10;
								Gannon->OriginalTile = GannTile;
								GannAttack = 0;
								Gannon->Stun = 255;
								if (RequireSword > 0)
								{ 
									if (NumLWeaponsOf(LW_ARROW) == 0 || !Link->Item[I_ARROW2]) Gannon->HP = 1;
									Gannon->Defense[NPCD_SWORD] = NPCDT_IGNORE;
									if (!IsRandomizer())
									{
										if (Link->Item[I_ARROW2])
										{
											if (Gannon->Defense[NPCD_ARROW] != NPCDT_NONE)
											{
												Gannon->Defense[NPCD_ARROW] = NPCDT_NONE;
												//Gannon->Defense[NPCD_SBOMB] = NPCDT_NONE; // This would allow Bow-Wow to eat Gannon if enabled. Considered it, but decided it was too likely to come up by mistake without the player realizing what happened. Skips Gannon's death animations.
											}
										}
										else if (!TakeTheArrow->isValid())
										{
											TakeTheArrow = CreateItemAt(I_ARROW2,Gannon->X,Gannon->Y);							
											TakeTheArrow->Pickup = IP_HOLDUP;
										}
									}
									else
									{
										if (Link->Item[I_ARROW2])
										{
											if (Gannon->Defense[NPCD_ARROW] != NPCDT_NONE)
											{
												Gannon->Defense[NPCD_ARROW] = NPCDT_NONE;
												//Gannon->Defense[NPCD_SBOMB] = NPCDT_NONE; // This would allow Bow-Wow to eat Gannon if enabled. Considered it, but decided it was too likely to come up by mistake without the player realizing what happened. Skips Gannon's death animations.
											}
										}
										if (!TakeTheArrow->isValid() && !RememberStuff[REMEMBER_GANN_ARROW])
										{
											TakeTheArrow = CreateItemAt(Randomizer_GetItemReplacement(69),Gannon->X,Gannon->Y);							
											TakeTheArrow->Pickup = IP_HOLDUP;
											CreatedArrow = true;
										}
									}
								}
							}					
						}
						if (TakeTheArrow->isValid())
						{
							if (TakeTheArrow->X != Gannon->X || TakeTheArrow->Y != Gannon->Y)
							{	
								TakeTheArrow->Pickup = IP_DUMMY;
								TakeTheArrow->Y = Gannon->Y;
								TakeTheArrow->X = Gannon->X;
							}
							else if (TakeTheArrow->Pickup == IP_DUMMY)
							{
								if (!LinkCollision(TakeTheArrow)) TakeTheArrow->Pickup = IP_HOLDUP;
							}
						}
						else if (CreatedArrow)
						{
							RememberStuff[REMEMBER_GANN_ARROW] = 1;
						}
						if (Gannon->Stun == 0)
						{
							if (Gannon->CSet == 10) Gannon->CSet = 11;
							if (TakeTheArrow->isValid()) 
							{
								Remove(TakeTheArrow);
								CreatedArrow = false;
							}
							if (Gannon->Defense[NPCD_ARROW] != NPCDT_IGNORE)
							{
								Gannon->Defense[NPCD_ARROW] = NPCDT_IGNORE;
								//Gannon->Defense[NPCD_SBOMB] = NPCDT_IGNORE;
							}
						}
						else if (RequireSword > 0)
						{
							if (Link->Item[I_ARROW2])
							{
								if (Gannon->Defense[NPCD_ARROW] != NPCDT_NONE) Gannon->Defense[NPCD_ARROW] = NPCDT_NONE;
							}
						}
		
						if (Gannon->HP <= 0) // Checking again after all that stuff for actual death, because of the special silver arrow weakness.
						{
							lweapon GannDead1 = CreateLWeaponAt(LW_SPARKLE,Gannon->X-8,Gannon->Y-8);
							GannDead1->UseSprite(SP_GANN_DEATH4);
							GannDead1->Extend = 3;
							GannDead1->TileWidth = 2;
							GannDead1->TileHeight = 2;
							this->X = Gannon->X;
							this->Y = Gannon->Y;
							Remove(Gannon);
							GannonDeathTimer = 1;
						}
		
						// Gannon destroys Somaria blocks:
						if (NumLWeaponsOf(LW_SOMARIA) > 0)
						{
							lweapon FirstSomaria = LoadLWeaponOf(LW_SOMARIA);
							if (FirstSomaria->isValid())
							{
								lweapon Somaridead = CreateLWeaponAt(LW_SPARKLE,FirstSomaria->X,FirstSomaria->Y);
								Somaridead->UseSprite(SP_MISC_DEATH);
								Remove(FirstSomaria);
								Game->PlaySound(SFX_EDEAD);
							}
						}
		
						// Gannon faces Link:
						if (Link->Y < Gannon->Y - 8) Gannon->Dir = DIR_UP;
						else if (Link->Y > Gannon->Y +16) Gannon->Dir = DIR_DOWN;
						else if (Link->X < Gannon->X) Gannon->Dir = DIR_LEFT;
						else Gannon->Dir = DIR_RIGHT;
		
						// Gannon's bait attracts Link:
						if (DarkBait->isValid())
						{
							Screen->FastTile(2,DarkBait->X,DarkBait->Y,DarkBait->Tile,DarkBait->CSet,128);
							if (Link->Y > DarkBait->Y)
							{
								if (CanWalk(Link->X,Link->Y,DIR_UP,1,false)) --Link->Y;
							}
							else if (Link->Y < DarkBait->Y)
							{
								if (CanWalk(Link->X,Link->Y,DIR_DOWN,1,false)) ++Link->Y;
							}
							if (Link->X > DarkBait->X)
							{
								if (CanWalk(Link->X,Link->Y,DIR_LEFT,1,false)) --Link->X;
							}
							else if (Link->X < DarkBait->X)
							{
								if (CanWalk(Link->X,Link->Y,DIR_RIGHT,1,false)) ++Link->X;
							}
							if (LinkCollision(DarkBait)) Remove(DarkBait);
						}
		
						// Need LW_BEETLE to obtain the arrow (unused; item was going to have dummy status when created)
						// Had problems grabbing other stuff gannon was shooting or holding up, and felt a little too cryptic.
						//if (!FirstBeetle->isValid())
						//{
						//	FirstBeetle = LoadLWeaponOf(LW_BEETLE);	
						//}
						//if (TakeTheArrow->isValid())
						//{
						//	if (TakeTheArrow->Pickup == IP_DUMMY)
						//	{
						//		if (FirstBeetle->isValid())
						//		{
						//			if (Collision(FirstBeetle,TakeTheArrow)) TakeTheArrow->Pickup = 0;
						//		}
						//	}
						//}		
		
						// Gannon teleports away
						if (TeleportTimer == 0)
							{
							if (Gannon->Stun == 0)
							{
								GannWeapon[GANN_CHOOSE] = 0;
								Gannon->OriginalTile = GannTile + 40;
								Gannon->DrawZOffset = 255;
								Gannon->HitYOffset = 255;
								Teleporting = 128;
								TeleportTimer = 128;
							}	
						}
		
						// Gannon mid-teleportation
						else
						{
							if (Teleporting > 0)
							{
								--Teleporting;
								// Gannon's teleport animation
								if (Teleporting%2)
								{
									//Screen->DrawTile(
									//3,
									//Gannon->X+Gannon->DrawXOffset,		//start X
									//Gannon->Y+Gannon->DrawYOffset,		//start y
									//Gannon->Tile,				//tile ID
									//2,					//tile width
									//2,					//tile width
									//Gannon->CSet,				//tile cset
									//-1,-1,-1,-1,0,0,1,128);
									Gannon->DrawZOffset = 0;
								}
								else Gannon->DrawZOffset = 255;
								// Gannon is moved by teleporting
								if (Teleporting == 64)
								{
									Gannon->X = Link->X;
									Gannon->Y = Link->Y-8;
			
									//ComboX version - unused, but works:
									//Gannon->X = ComboX(ComboAt(Link->X+8,Link->Y+8));
									//Gannon->Y = ComboY(ComboAt(Link->X+8,Link->Y+8));
		
									//Random Teleportation- unused, but works:
									//Gannon->X = 32+(Rand(0,10)*16);
									//if (!IsSideview()) Gannon->Y = 32+(Rand(0,5)*16);
								}
							}
							else
							// After teleporting:
							{
								if (Gannon->HitYOffset != GannHitYOffset)
								{
									Gannon->HitYOffset = GannHitYOffset;
									Gannon->DrawZOffset = 0;
									GannAttack = 40;
								}
		
								if (GannAttack > 0) 
								{
									//Delay before attacking
									if (this->Data != COMBO_SCREENFREEZE1) --GannAttack;
									if (GannAttack < 12)
									//Attack begins:
									{
										if (GannWeapon[GANN_CHOOSE] == 0)
										{
											// if Gannon has used every weapon once, reset them.
											if (GannWeapon[GANN_SWORD] == 0 && GannWeapon[GANN_BRANG] == 0 && GannWeapon[GANN_BOMB] == 0 && GannWeapon[GANN_ARROW] == 0 && GannWeapon[GANN_FIRE] == 0 && GannWeapon[GANN_MAGIC] == 0 && GannWeapon[GANN_WIND] == 0 && GannWeapon[GANN_BAIT] == 0)
											{
												GannWeapon[GANN_SWORD] = 1;
												GannWeapon[GANN_BRANG] = 1;
												GannWeapon[GANN_BOMB] = 1;
												GannWeapon[GANN_ARROW] = 1;
												GannWeapon[GANN_FIRE] = 1;
												GannWeapon[GANN_MAGIC] = 1;
												GannWeapon[GANN_WIND] = 1;
												GannWeapon[GANN_BAIT] = 1;
											}
											// Gannon selects a weapon to use:
											GannWeapon[GANN_CHOOSE] = Rand(1,8);
										}
										else
										{
											// if Gannon tries to use a weapon he's already used once, pick a different weapon:
											if (GannWeapon[GannWeapon[GANN_CHOOSE]] == 0) GannWeapon[GANN_CHOOSE] = Rand(1,8);
											else
											// Gannon uses his weapon:
											{
	
												//Remember that the chosen weapon has been used once:
												if (Gannon->Stun == 0)
												{
													--GannWeapon[GannWeapon[GANN_CHOOSE]];
													
													if (FireballOnly == 0) GannWeapon[GANN_CHOOSE] = 0;
													if (GannWeapon[GANN_CHOOSE] == GANN_BAIT)
													{
														if (DarkBait->isValid()) Remove(DarkBait);
														DarkBait = CreateLWeaponAt(LW_BAIT,Gannon->X,Gannon->Y);
														DarkBait->Dir = Gannon->Dir;
														DarkBait->CSet = Gannon->CSet;
														DarkBait->DrawYOffset = 255;
														lweapon DarkItem = CreateLWeaponAt(LW_SPARKLE,Gannon->X,Gannon->Y);
														DarkItem->UseSprite(SP_GANN_BAIT);
														DarkItem->DrawYOffset = -24;
														GannAttack = 0;
														Gannon->OriginalTile = GannTile + 80;
													}
													else if (GannWeapon[GANN_CHOOSE] == GANN_ARROW)
													{
														eweapon DarkArrow = CreateEWeaponAt(EW_ARROW,Gannon->X,Gannon->Y);
														DarkArrow->Dir = Gannon->Dir;
														if (DarkArrow->Dir == DIR_DOWN) DarkArrow->Flip = FLIP_VERTICAL;
														else if (DarkArrow->Dir == DIR_LEFT) DarkArrow->Flip = ROT_CW_FLIP;
														else if (DarkArrow->Dir == DIR_RIGHT) DarkArrow->Flip = ROT_CCW_FLIP;
														DarkArrow->Angular = true;
														DarkArrow->Angle = RadianAngle(Gannon->X,Gannon->Y,Link->X,Link->Y);
														DarkArrow->Step = 255;
														DarkArrow->Damage = Gannon->WeaponDamage;
														DarkArrow->CSet = Gannon->CSet;
														Game->PlaySound(SFX_ARROW);
														lweapon DarkItem = CreateLWeaponAt(LW_SPARKLE,Gannon->X,Gannon->Y);
														DarkItem->UseSprite(SP_GANN_ARROW);
														DarkItem->DrawYOffset = -24;
														GannAttack = 0;
														Gannon->OriginalTile = GannTile + 80;
													}
													else if (GannWeapon[GANN_CHOOSE] == GANN_BOMB)
													{
														eweapon DarkBomb = CreateEWeaponAt(EW_STATIONARYBOMB,Gannon->X,Gannon->Y-24);
														DarkBomb->Damage = Gannon->WeaponDamage;
														DarkBomb->CSet = Gannon->CSet;
														DarkBomb = CreateEWeaponAt(EW_STATIONARYBOMB,Gannon->X-16,Gannon->Y-16);
														DarkBomb->Damage = Gannon->WeaponDamage;
														DarkBomb->CSet = Gannon->CSet;
														DarkBomb = CreateEWeaponAt(EW_STATIONARYBOMB,Gannon->X-24,Gannon->Y);
														DarkBomb->Damage = Gannon->WeaponDamage;
														DarkBomb->CSet = Gannon->CSet;
														DarkBomb = CreateEWeaponAt(EW_STATIONARYBOMB,Gannon->X-16,Gannon->Y+16);
														DarkBomb->Damage = Gannon->WeaponDamage;
														DarkBomb->CSet = Gannon->CSet;
														DarkBomb = CreateEWeaponAt(EW_STATIONARYBOMB,Gannon->X,Gannon->Y+24);
														DarkBomb->Damage = Gannon->WeaponDamage;
														DarkBomb->CSet = Gannon->CSet;
														DarkBomb = CreateEWeaponAt(EW_STATIONARYBOMB,Gannon->X+16,Gannon->Y+16);
														DarkBomb->Damage = Gannon->WeaponDamage;
														DarkBomb->CSet = Gannon->CSet;
														DarkBomb = CreateEWeaponAt(EW_STATIONARYBOMB,Gannon->X+24,Gannon->Y);
														DarkBomb->Damage = Gannon->WeaponDamage;
														DarkBomb->CSet = Gannon->CSet;
														DarkBomb = CreateEWeaponAt(EW_STATIONARYBOMB,Gannon->X+16,Gannon->Y-16);
														DarkBomb->Damage = Gannon->WeaponDamage;
														DarkBomb->CSet = Gannon->CSet;
														Game->PlaySound(SFX_PLACE);
														GannAttack = 0;
														Gannon->OriginalTile = GannTile + 80;
													}
													else if (GannWeapon[GANN_CHOOSE] == GANN_MAGIC)
													{
														eweapon DarkMagic = CreateEWeaponAt(EW_MAGIC,Gannon->X,Gannon->Y);
														DarkMagic->Dir = Gannon->Dir;
														if (DarkMagic->Dir == DIR_DOWN) DarkMagic->Flip = FLIP_VERTICAL;
														else if (DarkMagic->Dir == DIR_LEFT) DarkMagic->Flip = ROT_CW_FLIP;
														else if (DarkMagic->Dir == DIR_RIGHT) DarkMagic->Flip = ROT_CCW_FLIP;
														DarkMagic->Angular = true;
														DarkMagic->Angle = RadianAngle(Gannon->X,Gannon->Y,Link->X,Link->Y);
														DarkMagic->Damage = Gannon->WeaponDamage;
														Game->PlaySound(SFX_WAND);
														lweapon DarkItem = CreateLWeaponAt(LW_SPARKLE,Gannon->X,Gannon->Y);
														DarkItem->UseSprite(SP_GANN_MAGIC);
														DarkItem->DrawYOffset = -24;
														GannAttack = 0;
														Gannon->OriginalTile = GannTile + 80;
														}
													else if (GannWeapon[GANN_CHOOSE] == GANN_WIND)
													{
														eweapon DarkWind = CreateEWeaponAt(EW_WIND,32,Link->Y);
														DarkWind->DrawXOffset = -32;
														DarkWind->HitXOffset = -32;
														DarkWind->Dir = DIR_RIGHT;
														DarkWind->Step = 0;
														DarkWind->Damage = Gannon->WeaponDamage;
														Game->PlaySound(SFX_WHISTLE);
														lweapon DarkItem = CreateLWeaponAt(LW_SPARKLE,Gannon->X,Gannon->Y);
														DarkItem->UseSprite(SP_GANN_WIND);
														DarkItem->DrawYOffset = -24;
														GannAttack = 0;
														Gannon->OriginalTile = GannTile + 80;
														this->Data = COMBO_SCREENFREEZE1;
														StartData[2] = 120;
													}
													else if (GannWeapon[GANN_CHOOSE] == GANN_BRANG)
													{
														eweapon DarkBrang = CreateEWeaponAt(EW_BRANG,Gannon->X,Gannon->Y);
														//DarkBrang->Dir = Gannon->Dir;
														DarkBrang->Damage = 0;
														DarkBrang->Angular = true;
														DarkBrang->Angle = RadianAngle(Gannon->X,Gannon->Y,Link->X,Link->Y);
														//DarkBrang->Step = 30;
														Game->PlaySound(SFX_BRANG);
														lweapon DarkItem = CreateLWeaponAt(LW_SPARKLE,Gannon->X,Gannon->Y);
														DarkItem->UseSprite(SP_GANN_BRANG);
														DarkItem->DrawYOffset = -24;
														GannAttack = 0;
														Gannon->OriginalTile = GannTile + 80;
													}
													else if (GannWeapon[GANN_CHOOSE] == GANN_FIRE)
													{
														eweapon DarkFire = CreateEWeaponAt(EW_FIRE,Gannon->X,Gannon->Y);
														DarkFire->Dir = Gannon->Dir;
														DarkFire->Angular = true;
														DarkFire->Angle = RadianAngle(Gannon->X,Gannon->Y,Link->X,Link->Y);
														DarkFire->Step = 255;
														DarkFire->Damage = Gannon->WeaponDamage;
														Game->PlaySound(SFX_FIRE);
														lweapon DarkItem = CreateLWeaponAt(LW_SPARKLE,Gannon->X,Gannon->Y);
														DarkItem->UseSprite(SP_GANN_FIRE);
														DarkItem->DrawYOffset = -24;
														GannAttack = 0;
														Gannon->OriginalTile = GannTile + 80;
													}
													else if (GannWeapon[GANN_CHOOSE] == GANN_SWORD)
													{
														//Sword 1
														eweapon DarkSword = CreateEWeaponAt(EW_BEAM,Gannon->X,Gannon->Y+8);
														DarkSword->Dir = DIR_UP;
														DarkSword->Damage = Gannon->WeaponDamage;
														//Sword 2
														DarkSword = CreateEWeaponAt(EW_BEAM,Gannon->X,Gannon->Y+8);
														DarkSword->Dir = DIR_DOWN;
														DarkSword->Damage = Gannon->WeaponDamage;
														DarkSword->Flip = FLIP_VERTICAL;
														//Sword 3
														DarkSword = CreateEWeaponAt(EW_BEAM,Gannon->X,Gannon->Y+8);
														DarkSword->Dir = DIR_LEFT;
														DarkSword->Damage = Gannon->WeaponDamage;
														DarkSword->Flip = ROT_CW_FLIP;
														//Sword 4
														DarkSword = CreateEWeaponAt(EW_BEAM,Gannon->X,Gannon->Y+8);
														DarkSword->Dir = DIR_RIGHT;
														DarkSword->Damage = Gannon->WeaponDamage;												
														DarkSword->Flip = ROT_CCW_FLIP;
														Game->PlaySound(SFX_BEAM);
														lweapon DarkItem = CreateLWeaponAt(LW_SPARKLE,Gannon->X,Gannon->Y);
														DarkItem->UseSprite(SP_GANN_SWORD);
														DarkItem->DrawYOffset = -24;
														GannAttack = 0;
														Gannon->OriginalTile = GannTile + 80;
													}
													else if (GannWeapon[GANN_CHOOSE] == 0)
													{
														eweapon DarkFireball = CreateEWeaponAt(EW_FIREBALL2,Gannon->X,Gannon->Y);
														DarkFireball->Dir = Gannon->Dir;
														DarkFireball->Angular = true;
														DarkFireball->Angle = RadianAngle(Gannon->X,Gannon->Y,Link->X,Link->Y);
													}
												}
											}	
										}		
									}
								}
								if (this->Data != COMBO_SCREENFREEZE1) --TeleportTimer;
							}
						}
					}
					else if (this->Data == COMBO_SCREENFREEZE1) this->Data = StartData[NEWGAN_ORIGDATA];
				}
				else
				{
					++GannonDeathTimer;
					if (GannonDeathTimer == 58)
					{
						Game->PlaySound(SFX_GANON);
						item DustPile = CreateItemAt(I_DUSTPILENEW,this->X,this->Y);
						DustPile->Pickup = IP_DUMMY;
						DustPile->HitYOffset = 255;
						item BigTriforce = CreateItemAt(I_TRIFORCEBIG,this->X,this->Y);
		
						lweapon GannDead = CreateLWeaponAt(LW_SPARKLE,this->X,this->Y);
						GannDead->UseSprite(SP_GANN_DEATH1);
						GannDead->Dir = DIR_UP;
						GannDead->Step = 60;
		
						GannDead = CreateLWeaponAt(LW_SPARKLE,this->X,this->Y);
						GannDead->UseSprite(SP_GANN_DEATH2);
						GannDead->Dir = DIR_LEFTUP;
						GannDead->Step = 45;
	
						GannDead = CreateLWeaponAt(LW_SPARKLE,this->X,this->Y);
						GannDead->UseSprite(SP_GANN_DEATH3);
						GannDead->Dir = DIR_LEFT;
						GannDead->Step = 60;
	
						GannDead = CreateLWeaponAt(LW_SPARKLE,this->X,this->Y);
						GannDead->UseSprite(SP_GANN_DEATH2);
						GannDead->Dir = DIR_LEFTDOWN;
						GannDead->Flip = FLIP_VERTICAL;
						GannDead->Step = 45;
	
						GannDead = CreateLWeaponAt(LW_SPARKLE,this->X,this->Y);
						GannDead->UseSprite(SP_GANN_DEATH1);
						GannDead->Dir = DIR_DOWN;
						GannDead->Flip = FLIP_VERTICAL;
						GannDead->Step = 60;

						GannDead = CreateLWeaponAt(LW_SPARKLE,this->X,this->Y);
						GannDead->UseSprite(SP_GANN_DEATH2);
						GannDead->Dir = DIR_RIGHTDOWN;
						GannDead->Flip = FLIP_BOTH;
						GannDead->Step = 45;

						GannDead = CreateLWeaponAt(LW_SPARKLE,this->X,this->Y);
						GannDead->UseSprite(SP_GANN_DEATH3);
						GannDead->Dir = DIR_RIGHT;
						GannDead->Flip = FLIP_HORIZONTAL;
						GannDead->Step = 60;

						GannDead = CreateLWeaponAt(LW_SPARKLE,this->X,this->Y);
						GannDead->UseSprite(SP_GANN_DEATH2);
						GannDead->Dir = DIR_RIGHTUP;
						GannDead->Flip = FLIP_HORIZONTAL;
						GannDead->Step = 45;

						Game->SetDMapEnhancedMusic(Game->GetCurDMap(),1,0);
						Game->PlayEnhancedMusic(1,0);
						Game->DMapMIDI[Game->GetCurDMap()] = 0;
						Game->PlayMIDI(0);

						this->Data = StartData[NEWGAN_ORIGDATA];
						Quit();
					}					
				}
			}
		}
	}
}

//Script over, Return of Gannon
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: New Gannon (end)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Pouncing Gohma (start)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
ffc script PouncingGohma
{
	void run(int WhatID, int GohmaWeakness, int SpecialWeapon)
	{
//D0 - ID of monster to operate.
//D1 - LWeapon ID Gohma is weak to; used for toggling a specific script weapon defense.
//D2 - If -1, no weapon will be used. If 0, weapon will be EW_FIREBALL2 (boss fireball). Otherwise, D2 weapon will be used.
	

		npc ItsaGohma;
		int GohmaWait = 60;
		int FireballWait = 32;
		eweapon GohmaFire;
		lweapon FFCrandoLW;
		int FFCForTimer;

		while(true)
		{
			Waitframe();
			{
	
				if (!ItsaGohma->isValid()) ItsaGohma = LoadNPCOf(WhatID);
				else
				{
					if (ItsaGohma->Extend < 3)
					{
						ItsaGohma->Y = -72;
						ItsaGohma->TileWidth = 3;
						ItsaGohma->HitWidth = 48;
						ItsaGohma->DrawXOffset = -16;
						ItsaGohma->HitXOffset = -16;
						ItsaGohma->Extend = 3;
					}
					else if (ItsaGohma->HP > 0)
					{
				// Gohma moves
						if ((Game->Counter[CR_WEATHER] == 0 || Game->Counter[CR_WEATHER] > 5) && !Link->Item[I_CURSEDPICTOBOX]) Screen->Line(
								7,			//layer
								ItsaGohma->X+8,	//X1
								ItsaGohma->Y,	//Y2
								ItsaGohma->X+8,	//X2
								-58,		//Y2
								1,		//Color		
								1,		//Scale
								0,		//rx
								0,		//ry
								0,		//rangle
								128);		//opacity
						
						if (GohmaWait == 0)
						{
							if (ItsaGohma->Y == -72) ItsaGohma->X = Choose(48,96,144,192);
							if (ItsaGohma->Y < 128) ItsaGohma->Y = ItsaGohma->Y + 2;
							else GohmaWait = 60;
						}
						else
						{
							if (ItsaGohma->Y > -72) --ItsaGohma->Y;
							else --GohmaWait;
						}

				// Gohma attacks
						if (ItsaGohma->Y > 32)
						{
							if (FireballWait > 0) --FireballWait;
							else
							{
								if (SpecialWeapon != -1)
								{
									if (SpecialWeapon == 0) GohmaFire = CreateEWeaponAt(EW_FIREBALL2,ItsaGohma->X,ItsaGohma->Y);
									else GohmaFire = CreateEWeaponAt(SpecialWeapon,ItsaGohma->X,ItsaGohma->Y);

									if (GohmaFire->X < Link->X) GohmaFire->Dir = DIR_RIGHT;
									else GohmaFire->Dir = DIR_LEFT;
									GohmaFire->Damage = ItsaGohma->WeaponDamage;
									if (GohmaFire->ID > EW_SCRIPT10)
									{
										if (GohmaFire->Angular == false)
										{
											GohmaFire->Angular = true;
											GohmaFire->Angle = RadianAngle(ItsaGohma->X,ItsaGohma->Y,Link->X,Link->Y);
										}
									}
									FireballWait = 32;
								}
							}
						}

				// Special Gohma defenses
						for(FFCForTimer = Screen->NumLWeapons(); FFCForTimer > 0; --FFCForTimer)
						{
							FFCrandoLW = Screen->LoadLWeapon(FFCForTimer);
							if(!FFCrandoLW->isValid()) continue;
							if (FFCrandoLW->ID != LW_CANEOFBYRNA && FFCrandoLW->ID != LW_BAIT)
							{
								if (FFCrandoLW->ID == GohmaWeakness)
								{
									// Vulnerability to specific script weapon types
									if (GohmaWeakness >= LW_SCRIPT1)
									{
										if (ItsaGohma->Defense[NPCD_SCRIPT] != NPCDT_IGNORE1) ItsaGohma->Defense[NPCD_SCRIPT] = NPCDT_IGNORE1;
									}
								}
								if (FFCrandoLW->X > ItsaGohma->X - 35 && FFCrandoLW->X < ItsaGohma->X + 35 && FFCrandoLW->Y > ItsaGohma->Y - 19 && FFCrandoLW->Y < ItsaGohma->Y+19)
								{
									if(FFCrandoLW->X > ItsaGohma->X+14 || FFCrandoLW->X < ItsaGohma->X-14 || FFCrandoLW->Y < ItsaGohma->Y-4)
									{
										Remove(FFCrandoLW);
										Game->PlaySound(SFX_CLINK);
									}
								}
							}
						}
						if (ItsaGohma->Defense[NPCD_SCRIPT] == NPCDT_IGNORE1)
						{
							if (NumLWeaponsOf(GohmaWeakness) == 0) ItsaGohma->Defense[NPCD_SCRIPT] = NPCDT_BLOCK;
						}
	
					}
				}
			}
		}
	}
}

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Pouncing Gohma (end)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Wraparound Aquamentus (start)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
ffc script WraparoundAquamentus
{
	void run(int AquamentusID, int AquamentusTile, int UpShots, int DownShots, int DoesNotReturn, int AquamentusWeapon, int WeaponSpace, int RiderID)
	{

//D0 - NPC ID to spawn to be a wraparound Aquamentus.
//D1 - Original tile of Aquamentus enemy. Is designed for two-frame animation with 2x2 tiles, two left and two right, then a second row for the firing animation.
//D2 - How many fireballs to shoot upwards. (The center fireball is always fired regarldess of these numbers.)
//D3 - How many fireballs to shoot downwards.
//D4 - If 1, defeating this Aquamentus will set Screen->State[ST_ENEMYNORETURN] to true, to prevent the Aquamentus from spawning.
	//However, if this screen is the Dungeon Boss,  the Aquamentus won't return anyway.
//D5 - Set for a custom weapon. If 0, shoots EW_FIREBALL2. If -1, no shots are fired.
//D6 - Increases gap between weapons when firing.
//D7 - Sticks the first NPC of D7 ID to the back of this Aquamentus, and makes it face the same way as the Aquamentus (riding it).


		this->Flags[FFCF_ETHEREAL] = true;
		npc WrapAqua;
		bool MakeAqua = true;
		if (Screen->State[ST_ENEMYNORETURN] || (Game->LItems[Game->GetCurLevel()] & LI_BOSS) != 0 && ScreenEFlag(SEF_LIST1, 3) > 0) MakeAqua = false;
		if (MakeAqua) WrapAqua = CreateNPCAt(AquamentusID,this->X,this->Y);
		else Quit();
		WrapAqua->Extend = 3;
		WrapAqua->TileHeight = 2;
		WrapAqua->TileWidth = 2;
		WrapAqua->HitXOffset = 8;
		WrapAqua->X = -48;

		int AquaWeapon;
		if (AquamentusWeapon > 0) AquaWeapon = AquamentusWeapon;
		else 
		{
			if (AquamentusWeapon == -1) AquaWeapon = 0;
			else AquaWeapon = EW_FIREBALL2;
		}

		eweapon Fireball1;
		eweapon Fireball2;
		eweapon Fireball3;
		int AquaTimer = 120;
		int ForTimer;
		int AquaWait;
		npc AquaRider;

		while(true)
		{
			Waitframe();
			{
				if (!WrapAqua->isValid()) Quit();

				// Aquamentus-riding NPC
				if (RiderID > 0)
				{
					if (!AquaRider->isValid()) AquaRider = LoadNPCOf(RiderID);
					else
					{
						AquaRider->HP = WrapAqua->HP;
						AquaRider->Y = WrapAqua->Y;
						if (WrapAqua->Dir == DIR_RIGHT)
						{
							AquaRider->Dir = DIR_RIGHT;
							if (WrapAqua->X > -16) AquaRider->X = WrapAqua->X;
						}
						else
						{
							AquaRider->Dir = DIR_LEFT;
							if (WrapAqua->X < 256) AquaRider->X = WrapAqua->X+16;	
						}	
					}
				}


				// Aquamentus
				if (WrapAqua->X  < 112)
				{
					if (WrapAqua->Dir != DIR_RIGHT)
					{
						WrapAqua->Dir = DIR_RIGHT;
						if (WrapAqua->X < 0) WrapAqua->OriginalTile = AquamentusTile+4;
					}
				}
				else
				{
					if (WrapAqua->Dir != DIR_LEFT)
					{
						WrapAqua->Dir = DIR_LEFT;
						if (WrapAqua->X > 255) WrapAqua->OriginalTile = AquamentusTile;
					}
				}

				if (AquaTimer > 0)
				{
					if (WrapAqua->X  < -32 || WrapAqua->X >  256)
					{ 
						WrapAqua->Y = Choose(32,64,80,96);
						WrapAqua->X = Choose(-48,272);
						--AquaTimer;
					}
					else
					{
						if (WrapAqua->X < 112 && AquaWait < 4 && WrapAqua->HP >0) --WrapAqua->X;
						else if (AquaWait < 4 && WrapAqua->HP > 0) ++WrapAqua->X;
					}
				}
				else
				{
					if (WrapAqua->X < 56 && WrapAqua->HP > 0) ++WrapAqua->X;
					else if (WrapAqua->X > 184 && WrapAqua->HP > 0) --WrapAqua->X;
					else
					{
						if (WrapAqua->X == 56)
						{
							if (AquaWait == 0)
							{
								WrapAqua->OriginalTile = AquamentusTile + 44;
								Game->PlaySound(SFX_ROAR);

								if (AquaWeapon > 0)
								{
	
									eweapon Aquaball = CreateEWeaponAt(AquaWeapon,WrapAqua->X+8,WrapAqua->Y);
									Aquaball->Dir = DIR_RIGHT;
									Aquaball->Damage = WrapAqua->WeaponDamage;
									Aquaball->Angular = true;
									Aquaball->Angle = RadianAngle(WrapAqua->X+16,WrapAqua->Y,Link->X,Link->Y);
		
									for(ForTimer = UpShots; ForTimer > 0; --ForTimer)
									{
										eweapon UpBall = CreateEWeaponAt(AquaWeapon,WrapAqua->X+8,WrapAqua->Y - (WeaponSpace+6)*ForTimer);
										UpBall->Damage = WrapAqua->WeaponDamage;
										UpBall->Dir = DIR_RIGHT;
										UpBall->Angular = true;
										UpBall->Angle = RadianAngle(UpBall->X,UpBall->Y,Link->X,Link->Y-32*ForTimer);	
									}
									for(ForTimer = DownShots; ForTimer > 0; --ForTimer)
									{
										eweapon UpBall = CreateEWeaponAt(AquaWeapon,WrapAqua->X+8,WrapAqua->Y + (WeaponSpace+6)*ForTimer);
										UpBall->Damage = WrapAqua->WeaponDamage;
										UpBall->Dir = DIR_RIGHT;
										UpBall->Angular = true;
										UpBall->Angle = RadianAngle(UpBall->X,UpBall->Y,Link->X,Link->Y+32*ForTimer);	
									}
								}
	
								AquaTimer = Rand(16,80);
								AquaWait = 64;
							}
						}
						if (WrapAqua->X == 184)
						{
							if (AquaWait == 0)
							{
								WrapAqua->OriginalTile = AquamentusTile + 40;
								Game->PlaySound(SFX_ROAR);

								if (AquaWeapon > 0)
								{
	
									eweapon Aquaball = CreateEWeaponAt(AquaWeapon,WrapAqua->X+8,WrapAqua->Y);
									Aquaball->Dir = DIR_LEFT;
									Aquaball->Angular = true;
									Aquaball->Angle = RadianAngle(WrapAqua->X+8,WrapAqua->Y,Link->X+8,Link->Y);

									for(ForTimer = UpShots; ForTimer > 0; --ForTimer)
									{
										eweapon UpBall = CreateEWeaponAt(AquaWeapon,WrapAqua->X+8,WrapAqua->Y - (WeaponSpace+6)*ForTimer);
										UpBall->Damage = WrapAqua->WeaponDamage;
										UpBall->Dir = DIR_LEFT;
										UpBall->Angular = true;
										UpBall->Angle = RadianAngle(UpBall->X,UpBall->Y,Link->X,Link->Y-32*ForTimer);	
									}
									for(ForTimer = DownShots; ForTimer > 0; --ForTimer)
									{
										eweapon UpBall = CreateEWeaponAt(AquaWeapon,WrapAqua->X+8,WrapAqua->Y + (WeaponSpace+6)*ForTimer);
										UpBall->Damage = WrapAqua->WeaponDamage;
										UpBall->Dir = DIR_LEFT;
										UpBall->Angular = true;
										UpBall->Angle = RadianAngle(UpBall->X,UpBall->Y,Link->X,Link->Y+32*ForTimer);	
									}
								}
	
								AquaTimer = Rand(16,80);
								AquaWait = 64;
							}
						}
					}
				}
				if (AquaWait > 0) --AquaWait;
				if (AquaWait == 16)
				{
					if (WrapAqua->Dir == DIR_LEFT) WrapAqua->OriginalTile = AquamentusTile;
					else WrapAqua->OriginalTile = AquamentusTile+4;
				}

				if (WrapAqua->HP <= 0)
				{
					if (DoesNotReturn != 0 && !Screen->State[ST_ENEMYNORETURN]) Screen->State[ST_ENEMYNORETURN] = true; 
				}
			}		
		}			
	}
}

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Wraparound Aquamentus (end)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Growing Manhandla (start)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
ffc script GrowingManhandla
{
	void run(int Manhandla_Core_ID, int Manhandla_Heads_ID, int Head_Starting_Tile, int NoGrow, int StepMultiplier, int NoHeadOffset)
	{

//See the global script for a list of the constants used in array ManOffset[].

//D0 - ID of the core NPC. This NPC should determine the movement type (I used an NPCT_PATRA enemy because their ->Step can be adjusted).
//D1 - ID of the heads. Spawned by this script.
//D2 - Upper left starting Tile of block of head tiles. 
	//Appropriate head/neck tiles are then offset according to a set of variables in the array "ManOffset[]".
	//It's currently set up for the following tile layout:
	//
	//U1 U2 L1 L2 HN HN R1 HN HN R2 
	//VN VN L1 HN L2 HN HN R1 HN R2
	//VN VN L1 HN HN L2 HN HN R1 R2
	//D1 D2
	//
	//U  = Up head;
	//D  = Down head;
	//L  = Left head;
	//R  = Right head;
	// 1 = Open mouth;
	// 2 = Closed mouth;
	//CN = Center;
	//VN = Vertical Neck;
	//HN = Horizontal Neck
//D3 -	Changes growth:
	//If 0, Manhandla grows as it takes damage.
	//If 1, Manhandla is normal size and never grows. 
	//If 2, Manhandla starts at two tile length and will not grow.
	//If 3, Mahandla starts at three tile length and will not grow.
//D4 - Amount by which the Manhandla core's step will be multiplied when heads are lost. Set to 1 for no increase; 0 will default to 1.5.
//D5 - Set to non-0 to prevent any animation changes to the first form of the heads.

		this->Flags[FFCF_ETHEREAL] = true;

		int ManOffset[10];
		ManOffset[HEAD_LEFT_A] = Head_Starting_Tile +	 2;
		ManOffset[HEAD_RIGHT_C] = Head_Starting_Tile +	 4;
		ManOffset[HEAD_DOWN_C] = Head_Starting_Tile +	 20;
		ManOffset[HEAD_LEFT_B] = Head_Starting_Tile +	 22;
		ManOffset[HEAD_RIGHT_B] = Head_Starting_Tile +	 26;
		ManOffset[HEAD_DOWN_B] = Head_Starting_Tile +	 40;
		ManOffset[HEAD_LEFT_C] = Head_Starting_Tile +	 42;
		ManOffset[HEAD_RIGHT_A] = Head_Starting_Tile +	 48;
		ManOffset[HEAD_DOWN_A] = Head_Starting_Tile +	 60;
	
		Waitframes(4);
	
		npc HeadUp;
		npc HeadDown;
		npc HeadLeft;
		npc HeadRight;	
	
		npc ManCore = LoadNPCOf(Manhandla_Core_ID); 
		if (ManCore->isValid())
		{
			HeadUp = CreateNPCAt(Manhandla_Heads_ID,ManCore->X,ManCore->Y); 
			HeadDown = CreateNPCAt(Manhandla_Heads_ID,ManCore->X,ManCore->Y);
			HeadLeft = CreateNPCAt(Manhandla_Heads_ID,ManCore->X,ManCore->Y);
			HeadRight = CreateNPCAt(Manhandla_Heads_ID,ManCore->X,ManCore->Y);	
			ManCore->CollDetection = 0;
		}
		else Quit();

		int ManStartHP = HeadUp->HP;
		int ManCoreStartStep = ManCore->Step;
		int ManBoostStep[6];
		ManBoostStep[1] = 1;
		ManBoostStep[2] = 1;
		ManBoostStep[3] = 1;
		ManBoostStep[4] = 1;
	
		if (NoHeadOffset == 0)
		{
			HeadDown->OriginalTile = ManOffset[HEAD_DOWN_A];
			HeadLeft->OriginalTile = ManOffset[HEAD_LEFT_A];
			HeadRight->OriginalTile = ManOffset[HEAD_RIGHT_A];	
		}
		ManCore->DrawYOffset = 255;


// Start at 2 tiles
		if (NoGrow == 2)
		{
			// Head Up
			if (HeadUp->isValid())
			{
				HeadUp->Extend = 3;
				HeadUp->DrawYOffset = -16;
				HeadUp->HitYOffset = -16;
				HeadUp->HitHeight = 32;
				HeadUp->TileHeight = 2;
			}
			// Head Down
			if (HeadDown->isValid())
			{
				HeadDown->Extend = 3;
				HeadDown->HitHeight = 32;
				HeadDown->OriginalTile = ManOffset[HEAD_DOWN_B];
				HeadDown->TileHeight = 2;
			}
			// Head Left
			if (HeadRight->isValid())
			{
				HeadLeft->Extend = 3;
				HeadLeft->HitXOffset = -16;
				HeadLeft->DrawXOffset = -16;
				HeadLeft->HitWidth = 32;
				HeadLeft->OriginalTile = ManOffset[HEAD_LEFT_B];
				HeadLeft->TileWidth = 2;
			}
			// Head Right
			if (HeadRight->isValid())
			{
				HeadRight->Extend = 3;
				HeadRight->HitWidth = 32;
				HeadRight->OriginalTile = ManOffset[HEAD_RIGHT_B];
				HeadRight->TileWidth = 2;
			}
		}

// Start at 3 tiles
		if (NoGrow == 3)
		{
			// Head Up
			if (HeadUp->isValid())
			{
				HeadUp->Extend = 3;
				HeadUp->DrawYOffset = -32;	
				HeadUp->HitYOffset = -32;
				HeadUp->HitHeight = 48;
				HeadUp->TileHeight = 3;
			}
			// Head Down
			if (HeadDown->isValid())
			{
				HeadDown->Extend = 3;
				HeadDown->HitHeight = 48;
				HeadDown->OriginalTile = ManOffset[HEAD_DOWN_C];
				HeadDown->TileHeight = 3;
			}
			// Head Left
			if (HeadRight->isValid())
			{
				HeadLeft->Extend = 3;
				HeadLeft->HitXOffset = -32;
				HeadLeft->DrawXOffset = -32;
				HeadLeft->HitWidth = 48;
				HeadLeft->OriginalTile = ManOffset[HEAD_LEFT_C];
				HeadLeft->TileWidth = 3;
			}
			// Head Right
			if (HeadRight->isValid())
			{
				HeadRight->Extend = 3;
				HeadRight->HitWidth = 48;
				HeadRight->OriginalTile = ManOffset[HEAD_RIGHT_C];
				HeadRight->TileWidth = 3;
			}
		}

		while(true)
		{
			Waitframe();
			{
				if (ManCore->isValid())
				{

// Draws core to prevent graphical misalignment
					if (ManCore->DrawYOffset > 0) Screen->FastTile(3,ManCore->X,ManCore->Y-2,ManCore->Tile,ManCore->CSet,128);

// Speeds up when heads are lost
					if (ManCore->Step < ManCoreStartStep * ManBoostStep[1] * ManBoostStep[2]  * ManBoostStep[3]  * ManBoostStep[4])		ManCore->Step = ManCoreStartStep * ManBoostStep[1] * ManBoostStep[2]  * ManBoostStep[3]  * ManBoostStep[4];


// Head Up
					if (HeadUp->isValid())
					{
						HeadUp->X = ManCore->X;
						HeadUp->Y = ManCore->Y-16;
						HeadUp->Dir = DIR_UP;

						if (NoGrow == 0)
						{
							if (HeadUp->TileHeight < 2)
							{
								if (HeadUp->HP < (ManStartHP / 3) * 2)
								{
									ManCore->Stun = 32;
									HeadUp->Stun = 96;
									HeadUp->Extend = 3;
									HeadUp->DrawYOffset = -16;
									HeadUp->HitYOffset = -16;
									HeadUp->HitHeight = 32;
									HeadUp->TileHeight = 2;
								}
							}
		 					if (HeadUp->TileHeight < 3)
							{
								if (HeadUp->HP < (ManStartHP / 3))
								{
									ManCore->Stun = 32;
									HeadUp->Stun = 96;
									HeadUp->DrawYOffset = -32;	
									HeadUp->HitYOffset = -32;
									HeadUp->HitHeight = 48;
									HeadUp->TileHeight = 3;
								}
							}
						} 
					}
					else if (ManBoostStep[1] != StepMultiplier)
					{
						if (StepMultiplier != 0) ManBoostStep[1] = StepMultiplier;
						else ManBoostStep[1] = 1.5;
					}


// Head Down
					if (HeadDown->isValid())
					{
						HeadDown->X = ManCore->X;
						HeadDown->Y = ManCore->Y+16;
						HeadDown->Dir = DIR_DOWN;

						if (NoGrow == 0)
						{
							if (HeadDown->TileHeight < 2)
							{
								if (HeadDown->HP < (ManStartHP / 3) * 2)
								{
									ManCore->Stun = 32;
									HeadDown->Stun = 96;
									HeadDown->Extend = 3;
									HeadDown->HitHeight = 32;
									HeadDown->OriginalTile = ManOffset[HEAD_DOWN_B];
									HeadDown->TileHeight = 2;
								}
							} 
							if (HeadDown->TileHeight < 3)
							{
								if (HeadDown->HP < (ManStartHP / 3))
								{
									ManCore->Stun = 32;
									HeadDown->Stun = 96;
									HeadDown->HitHeight = 48;
									HeadDown->OriginalTile = ManOffset[HEAD_DOWN_C];
									HeadDown->TileHeight = 3;
								}
							} 
						}
					}
					else if (ManBoostStep[2] != StepMultiplier)
					{
						if (StepMultiplier != 0) ManBoostStep[2] = StepMultiplier;
						else ManBoostStep[2] = 1.5;
					}

// Head Left
					if (HeadLeft->isValid())
					{
						HeadLeft->X = ManCore->X-16;
						HeadLeft->Y = ManCore->Y;
						HeadLeft->Dir = DIR_LEFT;

						if (NoGrow == 0)
						{
							if (HeadLeft->TileWidth < 2)
							{
								if (HeadLeft->HP < (ManStartHP / 3) * 2)
								{
									ManCore->Stun = 32;
									HeadLeft->Stun = 96;
									HeadLeft->Extend = 3;
									HeadLeft->HitXOffset = -16;
									HeadLeft->DrawXOffset = -16;
									HeadLeft->HitWidth = 32;
									HeadLeft->OriginalTile = ManOffset[HEAD_LEFT_B];
									HeadLeft->TileWidth = 2;
								}
							} 
							if (HeadLeft->TileWidth < 3)
							{
								if (HeadLeft->HP < (ManStartHP / 3))
								{
									ManCore->Stun = 32;
									HeadLeft->Stun = 96;
									HeadLeft->HitXOffset = -32;
									HeadLeft->DrawXOffset = -32;
									HeadLeft->HitWidth = 48;
									HeadLeft->OriginalTile = ManOffset[HEAD_LEFT_C];
									HeadLeft->TileWidth = 3;
								}
							}
						}
					} 
					else if (ManBoostStep[3] != StepMultiplier)
					{
						if (StepMultiplier != 0) ManBoostStep[3] = StepMultiplier;
						else ManBoostStep[1] = 1.5;
					}


// Head Right
					if (HeadRight->isValid())
					{

						HeadRight->X = ManCore->X+16;
						HeadRight->Y = ManCore->Y;
						HeadRight->Dir = DIR_RIGHT;

						if (NoGrow == 0)
						{
							if (HeadRight->TileWidth < 2)
							{
								if (HeadRight->HP < (ManStartHP / 3) * 2)
								{
									ManCore->Stun = 32;
									HeadRight->Stun = 96;
									HeadRight->Extend = 3;
									HeadRight->HitWidth = 32;
									HeadRight->OriginalTile = ManOffset[HEAD_RIGHT_B];
									HeadRight->TileWidth = 2;
								}
							} 
							if (HeadRight->TileWidth < 3)
							{
								if (HeadRight->HP < (ManStartHP / 3))
								{
									ManCore->Stun = 32;
									HeadRight->Stun = 96;
									HeadRight->HitWidth = 48;
									HeadRight->OriginalTile = ManOffset[HEAD_RIGHT_C];
									HeadRight->TileWidth = 3;
								}	
							}
						} 
					}
					else if (ManBoostStep[4] != StepMultiplier)
					{
						if (StepMultiplier != 0) ManBoostStep[4] = StepMultiplier;
						else ManBoostStep[1] = 1.5;
					}

// All heads defeated
					if (!HeadUp->isValid() && !HeadDown->isValid() && !HeadLeft->isValid() && !HeadRight->isValid())
					{
						if (ManCore->DrawYOffset > 0) ManCore->DrawYOffset = 0;
						ManCore->HP = 0;
						Quit();
					}
				}
			}
		}
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Growing Manhandla (start)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Moldorm behavior / Lanmola behavior (start)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

ffc script MoldormBehavior
{
	void run(int HeadID, int SegmentID, int SegmentsToMake, int SegmentLag, int InvincibleHead, int UnmoveableTile, int UnmoveableCSet)
	{

//NOTE: This script has a problem where if there are other NPCs on the screen besides the head, the segments will lag by the amount of those NPCs as though they were in the queue. Not sure how to solve that.

//D0 - ID of NPC to use as the head
//D1 - ID of NPC to use as the segment
//D2 - Number of segments to create
//D3 - Segment lag
//D4 - if 0, Head cannot be killed until segments are killed. If 1, Segments will die when head dies. If 3, head dies when segments are killed. If 2 or any other value, all segments remain after head dies.
//D5 - If anything other than 0, an NPC with this tile cannot be moved as a segment.
//D6 - If anything other than 0, an NPC with this CSet cannot be moved as a segment either.


		this->Flags[FFCF_ETHEREAL] = true;

		int ForTimer;
		int ArrayX[1024];
		int ArrayY[1024];
		npc Segment;

		Waitframes(4);

		npc Head = LoadNPCOf(HeadID);	
		if (!Head->isValid()) Quit();
		int HeadStartHP = Head->HP;

		for(ForTimer = SegmentsToMake; ForTimer > 0; --ForTimer)
		{
			npc NewSegment = CreateNPCAt(SegmentID,Head->X,Head->Y);
		}

		for(ForTimer = 1023; ForTimer > 0; --ForTimer)
		{
			ArrayX[ForTimer] = Head->X;
			ArrayY[ForTimer] = Head->Y;
		}

		while(true)
		{
			Waitframe();
			{
				if (!Head->isValid()) Quit();

	// --- Head can't be killed until segments are killed

				if (InvincibleHead == 0)
				{
					if (Head->HP < HeadStartHP)
					{
						if (NumNPCsOf(SegmentID) > 0) Head->HP = HeadStartHP;
					}
				}

	// --- Or, segments all die if head dies
				else if (InvincibleHead == 1)
				{
					if (Head->HP <= 0)
					{
						for(ForTimer = Screen->NumNPCs(); ForTimer > 0; --ForTimer)
						{
							Segment = Screen->LoadNPC(ForTimer);
							if(!Segment->isValid()) continue;
							{
								if (Segment->ID == SegmentID)
								{
									Segment->HP = 0;
								}
							}
						}

					}
				}

	// --- Or, head dies when all segments die
				else if (InvincibleHead == 3)
				{
					if (NumNPCsOf(SegmentID) == 0)
					{
						Remove(Head);
						Quit();
					}
				}

	// --- Moldorm movement
				if (Head->HP > 0)
				{
					ArrayX[0] = Head->X;
					ArrayY[0] = Head->Y;

					if (Head->Stun == 0)
					{
						for(ForTimer = Screen->NumNPCs(); ForTimer > 0; --ForTimer)
						{
							Segment = Screen->LoadNPC(ForTimer);
							if (!Segment->isValid()) continue;
							if (Segment->ID != SegmentID) continue;
							{
								if (Segment->ID == SegmentID)
								{	
									if (Segment->Misc[MISC_NPCTURNWAIT] == 0)
									{
										if (UnmoveableTile == 0 || Segment->Tile != UnmoveableTile)
										{
											if (UnmoveableCSet == 0 || Segment->CSet != UnmoveableCSet)
											{
												if (Segment->Y > ArrayY[(ForTimer-1)*SegmentLag]) Segment->Dir = DIR_UP;
												if (Segment->Y < ArrayY[(ForTimer-1)*SegmentLag]) Segment->Dir = DIR_DOWN;
												if (Segment->X > ArrayX[(ForTimer-1)*SegmentLag]) Segment->Dir = DIR_LEFT;
												if (Segment->X < ArrayX[(ForTimer-1)*SegmentLag]) Segment->Dir = DIR_RIGHT;
												if (Segment->Type != NPCT_WALK)
												{
													if (Segment->Y > ArrayY[(ForTimer-1)*SegmentLag] && Segment->X < ArrayX[(ForTimer-1)*SegmentLag]) Segment->Dir = DIR_RIGHTUP;
													if (Segment->Y > ArrayY[(ForTimer-1)*SegmentLag] && Segment->X > ArrayX[(ForTimer-1)*SegmentLag]) Segment->Dir = DIR_LEFTUP;
													if (Segment->Y < ArrayY[(ForTimer-1)*SegmentLag] && Segment->X < ArrayX[(ForTimer-1)*SegmentLag]) Segment->Dir = DIR_RIGHTDOWN;
													if (Segment->Y < ArrayY[(ForTimer-1)*SegmentLag] && Segment->X > ArrayX[(ForTimer-1)*SegmentLag]) Segment->Dir = DIR_LEFTDOWN;
												}
											}
										}
										if (Head->Type == NPCT_KEESE) Segment->Misc[MISC_NPCTURNWAIT] = 5;
										else Segment->Misc[MISC_NPCTURNWAIT] = 1;
									}
									else --Segment->Misc[MISC_NPCTURNWAIT];
									if (UnmoveableCSet == 0 || Segment->CSet != UnmoveableCSet)
									{
										if (Segment->HP > 0)
										{
											if (ArrayY[(ForTimer-1)*SegmentLag] > 0) Segment->Y = ArrayY[(ForTimer-1)*SegmentLag];
											if (ArrayX[(ForTimer-1)*SegmentLag] > 0) Segment->X = ArrayX[(ForTimer-1)*SegmentLag];
											if (Head->ID == NPC_MOBY1 || Head->ID == NPC_MOBY2 || Head->ID == NPC_MOBY3)
											{
												Segment->Dir = Head->Dir;
												Segment->ASpeed = Head->ASpeed;
												if (Segment->X < 5 && Head->X < 0) Segment->X = Head->X + ForTimer*SegmentLag;
												if (Head->Y < 0)
												{
													Segment->Y = -72;
													Segment->X = Head->X;
												}
											}
										}
									}
								}
							}
						}
						for(ForTimer = 1023; ForTimer > 0; --ForTimer)
						{
							if (ForTimer > 0)
							{
								ArrayX[ForTimer] = ArrayX[ForTimer-1];
								ArrayY[ForTimer] = ArrayY[ForTimer-1];
							}
						}
					}
				}
			}
		}
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Moldorm behavior / Lanmola behavior (end)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Moldorm Growing / Lanmola Growing (start)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

ffc script MoldormGrowing
{
	void run(int HeadID, int SegmentID, int SegmentRate, int SegmentLag)
	{

//D0 - ID of NPC to use as the head
//D1 - ID of NPC to use as the segment
//D2 - How many HP must be lost to grow a new segment. 
	// This enemy is balanced better with fairly high HP because the segments tend to get spammed with damage by Link easily.
	// Therefore, it's important to set a SegmentRate that makes enough segments to be fair for the intended context.
//D3 - Segment lag

		this->Flags[FFCF_ETHEREAL] = true;

		int ForTimer;
		int ArrayX[1024];
		int ArrayY[1024];
		int HPSyncWait;
		npc Segment;
		npc NewSegment;

		Waitframes(4);

		npc Head = LoadNPCOf(HeadID);	
		if (!Head->isValid()) Quit();
		int HeadStartHP = Head->HP;

		for(ForTimer = 510; ForTimer > 0; --ForTimer)
		{
			ArrayX[ForTimer] = Head->X;
			ArrayY[ForTimer] = Head->Y;
		}

		while(true)
		{
			Waitframe();
			{			

				if (Head->isValid())
				{
					if (Head->HP > 0)
					{
						if (NumNPCsOf(SegmentID) < (HeadStartHP - Head->HP)/SegmentRate)
						{
							NewSegment = CreateNPCAt(SegmentID,Head->X,Head->Y);
							NewSegment->HP = Head->HP;
							NewSegment->CollDetection = 0;
							NewSegment->Stun = 120;
						}

						ArrayX[0] = Head->X;
						ArrayY[0] = Head->Y;	
					}
	
					for(ForTimer = 255; ForTimer > 0; --ForTimer)
					{
						if (ForTimer > 0) ArrayX[ForTimer] = ArrayX[ForTimer-1];
						if (ForTimer > 0) ArrayY[ForTimer] = ArrayY[ForTimer-1];
					}

					if (HPSyncWait > 0) --HPSyncWait;


					for(ForTimer = Screen->NumNPCs(); ForTimer > 0; --ForTimer)
					{
						Segment = Screen->LoadNPC(ForTimer);
						if(!Segment->isValid()) continue;
						{
							if (Segment->ID == SegmentID)
							{
								if (Segment->Y > ArrayY[(ForTimer-1)*SegmentLag]) Segment->Dir = DIR_UP;
								if (Segment->Y < ArrayY[(ForTimer-1)*SegmentLag]) Segment->Dir = DIR_DOWN;
								if (Segment->X > ArrayX[(ForTimer-1)*SegmentLag]) Segment->Dir = DIR_LEFT;
								if (Segment->X < ArrayX[(ForTimer-1)*SegmentLag]) Segment->Dir = DIR_RIGHT;

								if (ArrayX[(ForTimer-1)*SegmentLag] > 0) Segment->X = ArrayX[(ForTimer-1)*SegmentLag];
								if (ArrayY[(ForTimer-1)*SegmentLag] > 0) Segment->Y = ArrayY[(ForTimer-1)*SegmentLag];

								if (Segment->Stun == 0 && Segment->CollDetection == 0) Segment->CollDetection = 1;

								if (Head->HP > Segment->HP) Head->HP = Segment->HP;
								if (Segment->HP > Head->HP) Segment->HP = Head->HP;

							}
						}
					}
				}
				else Quit();
			}
		}
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Growing Moldorm / Growing Lanmola (end)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Growing Gleeok (start)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

ffc script GrowingGleeok
{
	void run(int WhatID, int HeadSpawnRate, int MaxGleeoks, int SpawnHeads)
	{
// This script will always treat the first enemy onscreen as the main "Gleeok" (npc Gleeok1), so be careful how it's used.
// This script is also set up to expect a 1 headed gleeok enemy in terms of the calculation it does to spawn extra gleeoks, because a 1 headed gleeok counts as two NPCs (and each head adds one to the NPC count). So it may not work correctly with other NPCs.

//D0 - What ID of NPC to spawn.
//D1 - How many HP the first NPC has to lose before spawning another head.
//D2 - Maximum number of NPCs that can be made, up to a maximum of 10. Set above 1 to make any new NPCs, because this si the total number, counting the original.
//D3 - Set to non-0 to create three heads of D3 NPC ID, which will be destroyed as this gleeok grows heads.

		this->Flags[FFCF_ETHEREAL] = true;

		Waitframes(4);
		npc Gleeok1;
		if(Screen->NumNPCs() > 0) Gleeok1 = Screen->LoadNPC(1);
		else Quit();
		if (!Gleeok1->isValid()) Quit();
		int Gleeok1StartHP = Gleeok1->HP;
		int Gleeok1DamageTaken;
		npc ExtraGleeok[256];
		int HeadSpawnRateIncrement = HeadSpawnRate;
		npc FlyingHeads[10];
		if (SpawnHeads != 0)
		{
			FlyingHeads[1] = CreateNPCAt(SpawnHeads,Gleeok1->X,Gleeok1->Y); 
			FlyingHeads[2] = CreateNPCAt(SpawnHeads,Gleeok1->X,Gleeok1->Y); 
			FlyingHeads[3] = CreateNPCAt(SpawnHeads,Gleeok1->X,Gleeok1->Y); 
		}

		while(true)
		{
			Waitframe();

			if (!Gleeok1->isValid()) Quit();
			Gleeok1DamageTaken = Gleeok1StartHP - Gleeok1->HP;

			if (Gleeok1DamageTaken >= HeadSpawnRateIncrement)
			{
				if (Gleeok1->ID != WhatID && NumNPCsOf(WhatID) <= MaxGleeoks || Gleeok1->ID == WhatID && NumNPCsOf(WhatID) <= MaxGleeoks+1)
				{
					if (!ExtraGleeok[1]->isValid() && MaxGleeoks >= 2) ExtraGleeok[1] = CreateNPCAt(WhatID,Gleeok1->X,Gleeok1->Y);
					else if (!ExtraGleeok[2]->isValid() && MaxGleeoks >= 3) ExtraGleeok[2] = CreateNPCAt(WhatID,Gleeok1->X,Gleeok1->Y);
					else if (!ExtraGleeok[3]->isValid() && MaxGleeoks >= 4) ExtraGleeok[3] = CreateNPCAt(WhatID,Gleeok1->X,Gleeok1->Y);
					else if (!ExtraGleeok[4]->isValid() && MaxGleeoks >= 5) ExtraGleeok[4] = CreateNPCAt(WhatID,Gleeok1->X,Gleeok1->Y);
					else if (!ExtraGleeok[5]->isValid() && MaxGleeoks >= 6) ExtraGleeok[5] = CreateNPCAt(WhatID,Gleeok1->X,Gleeok1->Y);
					else if (!ExtraGleeok[6]->isValid() && MaxGleeoks >= 7) ExtraGleeok[6] = CreateNPCAt(WhatID,Gleeok1->X,Gleeok1->Y);
					else if (!ExtraGleeok[7]->isValid() && MaxGleeoks >= 8) ExtraGleeok[7] = CreateNPCAt(WhatID,Gleeok1->X,Gleeok1->Y);
					else if (!ExtraGleeok[8]->isValid() && MaxGleeoks >= 9) ExtraGleeok[8] = CreateNPCAt(WhatID,Gleeok1->X,Gleeok1->Y);
					else if (!ExtraGleeok[9]->isValid() && MaxGleeoks >= 10) ExtraGleeok[9] = CreateNPCAt(WhatID,Gleeok1->X,Gleeok1->Y);
					HeadSpawnRateIncrement = HeadSpawnRateIncrement+HeadSpawnRate;
					if (FlyingHeads[3]->isValid()) FlyingHeads[3]->HP = 0;
					else if (FlyingHeads[2]->isValid()) FlyingHeads[2]->HP = 0;
					else if (FlyingHeads[1]->isValid()) FlyingHeads[1]->HP = 0;
				}
			}

			if (ExtraGleeok[1]->isValid())
			{
				if (ExtraGleeok[1]->HP > Gleeok1->HP) ExtraGleeok[1]->HP = Gleeok1->HP;
				else if (Gleeok1->HP > ExtraGleeok[1]->HP) Gleeok1->HP = ExtraGleeok[1]->HP; 
				ExtraGleeok[1]->Dir = Gleeok1->Dir;
				ExtraGleeok[1]->X = Gleeok1->X;
				if (ExtraGleeok[1]->Weapon != 0) ExtraGleeok[1]->Weapon = 0;
			}
			if (ExtraGleeok[2]->isValid())
			{
				if (ExtraGleeok[2]->HP > Gleeok1->HP) ExtraGleeok[2]->HP = Gleeok1->HP;
				else if (Gleeok1->HP > ExtraGleeok[2]->HP) Gleeok1->HP = ExtraGleeok[2]->HP; 
				ExtraGleeok[2]->Dir = Gleeok1->Dir;
				ExtraGleeok[2]->X = Gleeok1->X;
			}
			if (ExtraGleeok[3]->isValid())
			{
				if (ExtraGleeok[3]->HP > Gleeok1->HP) ExtraGleeok[3]->HP = Gleeok1->HP;
				else if (Gleeok1->HP > ExtraGleeok[3]->HP) Gleeok1->HP = ExtraGleeok[3]->HP; 
				ExtraGleeok[3]->Dir = Gleeok1->Dir;
				if (ExtraGleeok[3]->Weapon != 0) ExtraGleeok[3]->Weapon = 0;
				ExtraGleeok[3]->X = Gleeok1->X;
			}
			if (ExtraGleeok[4]->isValid())
			{
				if (ExtraGleeok[4]->HP > Gleeok1->HP) ExtraGleeok[4]->HP = Gleeok1->HP;
				else if (Gleeok1->HP > ExtraGleeok[4]->HP) Gleeok1->HP = ExtraGleeok[4]->HP; 
				ExtraGleeok[4]->Dir = Gleeok1->Dir;
				ExtraGleeok[4]->X = Gleeok1->X;
			}
			if (ExtraGleeok[5]->isValid())
			{
				if (ExtraGleeok[5]->HP > Gleeok1->HP) ExtraGleeok[5]->HP = Gleeok1->HP;
				else if (Gleeok1->HP > ExtraGleeok[5]->HP) Gleeok1->HP = ExtraGleeok[5]->HP; 
				ExtraGleeok[5]->Dir = Gleeok1->Dir;
				if (ExtraGleeok[5]->Weapon != 0) ExtraGleeok[5]->Weapon = 0;
				ExtraGleeok[5]->X = Gleeok1->X;
			}
			if (ExtraGleeok[6]->isValid())
			{
				if (ExtraGleeok[6]->HP > Gleeok1->HP) ExtraGleeok[6]->HP = Gleeok1->HP;
				else if (Gleeok1->HP > ExtraGleeok[6]->HP) Gleeok1->HP = ExtraGleeok[6]->HP; 
				ExtraGleeok[6]->Dir = Gleeok1->Dir;
				ExtraGleeok[6]->X = Gleeok1->X;
			}
			if (ExtraGleeok[7]->isValid())
			{
				if (ExtraGleeok[7]->HP > Gleeok1->HP) ExtraGleeok[7]->HP = Gleeok1->HP;
				else if (Gleeok1->HP > ExtraGleeok[7]->HP) Gleeok1->HP = ExtraGleeok[7]->HP; 
				ExtraGleeok[7]->Dir = Gleeok1->Dir;
				if (ExtraGleeok[7]->Weapon != 0) ExtraGleeok[7]->Weapon = 0;
			}
			if (ExtraGleeok[8]->isValid())
			{
				if (ExtraGleeok[8]->HP > Gleeok1->HP) ExtraGleeok[8]->HP = Gleeok1->HP;
				else if (Gleeok1->HP > ExtraGleeok[8]->HP) Gleeok1->HP = ExtraGleeok[8]->HP; 
				ExtraGleeok[8]->Dir = Gleeok1->Dir;
				ExtraGleeok[8]->X = Gleeok1->X;
			}
			if (ExtraGleeok[9]->isValid())
			{
				if (ExtraGleeok[9]->Weapon != 0) ExtraGleeok[9]->Weapon = 0;
				if (ExtraGleeok[9]->HP > Gleeok1->HP) ExtraGleeok[9]->HP = Gleeok1->HP;
				else if (Gleeok1->HP > ExtraGleeok[9]->HP) Gleeok1->HP = ExtraGleeok[9]->HP; 
				ExtraGleeok[9]->Dir = Gleeok1->Dir;
				ExtraGleeok[9]->X = Gleeok1->X;
			}						
		}
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Growing Gleeok (end)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Kill Gannon Automatically (start)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// This script kills Gannon automatically when his HP reach 0.

ffc script KillGannon
{
	void run()
	{

		Waitframes(4);

		npc Gannon;
		bool AlreadyHasSilverArrow;
		if (Link->Item[I_ARROW2]) AlreadyHasSilverArrow = true;
		int GanHP;

		if (NumNPCsOf(NPC_GANON) > 0)
		{
			Gannon = LoadNPCOf(NPC_GANON);
			if (Gannon->isValid())
			{
				GanHP = Gannon->HP;
				--Gannon->HP;
			}
		}

		while(true)
		{
			Waitframe();

			if (!Gannon->isValid())
			{
				if (NumNPCsOf(NPC_GANON) > 0)
				{
					Gannon = LoadNPCOf(NPC_GANON);
				}
			}
			else
			{
				if (Gannon->HP == GanHP)
				{
					Link->Item[I_ARROW2] = true;
					lweapon SilvArrow = CreateLWeaponAt(LW_ARROW,Gannon->X,Gannon->Y);
					SilvArrow->DrawYOffset = 255;
				}
			}
			if (!AlreadyHasSilverArrow)
			{
				if (Link->Item[I_ARROW2])
				{
					if (Screen->NumNPCs() == 0)
					{
						Link->Item[I_ARROW2] = false;
						Quit();
					}
				}
			}
			else if (Screen->NumNPCs() == 0) Quit();
		}
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Kill Gannon Automatically (end) 
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Ineffective LWeapon (start)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

ffc script IneffectiveLWeapon
{
	void run(int WhatLWeapon)
	{

//D0 - LWeapon type to affect.

		int FFCForTimer;
		lweapon CheckLW;

		while(true)
		{
			Waitframe();

			for(FFCForTimer = Screen->NumLWeapons(); FFCForTimer > 0; --FFCForTimer)
			{
				CheckLW = Screen->LoadLWeapon(FFCForTimer);
				if (CheckLW->ID == WhatLWeapon)
				{
					CheckLW->CollDetection = false;
					CheckLW->Damage = 0;
					CheckLW->HitYOffset = 255;
				}
			}
		}
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Ineffective LWeapon (end) 
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// Extra Lock (start)
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
ffc script ExtraLock
{
	void run(int WhichD, int NoMagicKey, int OtherCombo)
	{
// Make sure that the combo under this FFC is your "lock" (but don't use Lock Block combo types), and that the next combo in the combo table is what you want for when it's unlocked.
// D0 - Which Screen->D[] register to store this lock's state (locked or unlocked) in.
// D1 - If 0, the Magic Key can open this; otherwise, it cannot.
// D2 - If != 0, the combo at position D2 will also be set to the next combo when this lock is opened.

		this->Flags[FFCF_ETHEREAL] = true;

		while(true)
		{
			Waitframe();
			
			if (Screen->D[WhichD] == 0 && (!IsRandomizer() || RememberStuff[REMEMBER_RANDO_OPTIONS+4]))
			{
				if (Game->Counter[CR_KEYS] > 0 || Link->Item[I_MAGICKEY] && NoMagicKey == 0)
				{
					if (LinkCollision(this))
					{
						if (Link->Y < this->Y + 10)
						{
							Screen->D[WhichD] = 1;
							Game->PlaySound(9);
							if (!Link->Item[I_MAGICKEY] || NoMagicKey != 0) -- Game->Counter[CR_KEYS];
							++ Screen->ComboD[ComboAt(this->X+7,this->Y+8)];
							if (OtherCombo > 0) ++ Screen->ComboD[OtherCombo]; 
							Quit();
						}
					}
				}
			}
			else
			{
				++ Screen->ComboD[ComboAt(this->X+7,this->Y+8)];
				if (OtherCombo > 0) ++ Screen->ComboD[OtherCombo];
				Quit();				
			}				
		}
	}
}
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// Extra Lock (end)
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Byrna attachment point (start)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// NOTE: This uses the global scale bool "ByrnaAttached" in order to prevent Link from grabbing onto multiple byrna attachment points at once. It sets it to false at init every time, though, and nothing else uses that bool.

ffc script ByrnaAttachPoint
{
	void run(int Movement)
	{
//D0 - Move this attachment point. All movement turns around 64 pixels from screen edges.
	//0 - No movement
	//1 - Move vertically bottom to top.
	//2 - Move vertically top to bottom.
	//3 - Move horizontally right to left.
	//4 - Move horizontally left to right.
	//5 - Move diagonally upper-left to lower-right
	//6 - Move diagonally lower-right to upper-left
	//7 - Move diagonally upper-right to lower-left
	//8 - Move diagonally lower-left to upper-right

		ByrnaAttached = false;
		bool ByrnaAttachToThis = false;
		lweapon FirstByrna;
		bool ForwardBack;
		int CountDrown = 399;
		lweapon randoLW;
		int FFCForTimer;
		int HowManyByrnas;		//How many Nimons have you seen today?		

		while(true)
		{
			Waitframe();

			// Byrna attachment:			
			if (NumLWeaponsOf(LW_CANEOFBYRNA) > 0)
			{
				if (FirstByrna->isValid())
				{
					if (!ByrnaAttached)
					{
						//if (Collision(this,FirstByrna))
						if (FirstByrna->X > this->X - 8 && FirstByrna->X < this->X + 8 && FirstByrna->Y > this->Y - 8 && FirstByrna->Y < this->Y+8)
						{
							if (Link->Action != LA_DROWNING)
							{
								ByrnaAttached = true;
								ByrnaAttachToThis = true;
								Game->PlaySound(SFX_MSG);
							}
						}
					}
					else if (ByrnaAttachToThis)
					{
						Link->X = this->X - (FirstByrna->X-Link->X);
						Link->Y = this->Y - (FirstByrna->Y-Link->Y);
						if (IsSideview()) Link->Jump = 0;
					}
				}
				else 
				{
					if (NumLWeaponsOf(LW_CANEOFBYRNA) > 1)
					{
						for(FFCForTimer = Screen->NumLWeapons(); FFCForTimer > 0; --FFCForTimer)
						{
							randoLW = Screen->LoadLWeapon(FFCForTimer);
							if(!randoLW->isValid()) continue;
							{
								if (randoLW->ID == LW_CANEOFBYRNA)
								{
									if (HowManyByrnas == 0) ++HowManyByrnas;
									else FirstByrna = Screen->LoadLWeapon(FFCForTimer);
								}
							}
						}
					}
					else FirstByrna = LoadLWeaponOf(LW_CANEOFBYRNA);
					if (HowManyByrnas > 0) HowManyByrnas = 0;
				}
			}
			else if (ByrnaAttachToThis || ByrnaAttached)
			{
				ByrnaAttached = false;
				ByrnaAttachToThis = false;
				if (IsSideview()) Link->Jump = 3;
			}
			if (ByrnaAttached)
			{
				if (Screen->ComboS[ComboAt(Link->X+7,Link->Y+8)] != 0 && Screen->ComboT[ComboAt(Link->X+7,Link->Y+8)] != CT_WATER)
				{
					if (GetEquipmentB() == I_CBYRNA || GetEquipmentB() == I_CBYRNA2 || GetEquipmentB() == I_CBYRNA3)
					{
						if (Link->PressB) Game->PlaySound(SFX_CLINK);
						Link->PressB = false;
						Link->InputB = false;
					}
					if (GetEquipmentA() == I_CBYRNA || GetEquipmentA() == I_CBYRNA2 || GetEquipmentA() == I_CBYRNA3)
					{
						if (Link->PressA) Game->PlaySound(SFX_CLINK);
						Link->PressA = false;
						Link->InputA = false;
					}
				}
				if (CountDrown < 399) CountDrown = 399;
			}
			else
			{
				if (Screen->ComboT[ComboAt(Link->X+7,Link->Y+8)] == CT_WATER)
				{
					if (Link->Action != LA_DROWNING && !Link->Item[I_FLIPPERS])
					{
						if (CountDrown > 0)
						{
							if (NumLWeaponsOf(LW_CANEOFBYRNA) == 0) Screen->FastTile(3,Link->X,Link->Y-12,TILE_PATRA+(Choose(0,1)),8,128);
							--CountDrown;
							Screen->DrawInteger(
								2,					//int layer, 
								Link->X+4,				//int x, 
								Link->Y - 16,				//int y, 
								FONT_Z1,				//int font, 
								1,					//int color, 
								-1,					//int background_color, 
								-1,					//int width, 
								-1,					//int height, 
								CountDrown / 100,			//int number, 
								0, 					//int number_decimal_places, 
								128);					 //int opacity
						}
						else
						{
							Link->Action = LA_DROWNING;
							Game->PlaySound(SFX_OUCH);
							Game->PlaySound(SFX_PLAYERFALL);
							CountDrown = 399;
						}
					}
					else if (CountDrown < 399) CountDrown = 399;
				}
			}

			// Movement of this FFC:
			if (Movement == 1)
			{
				if (ForwardBack)
				{
					if (this->Y < 96) ++this->Y;
					else ForwardBack = false;
				}
				else
				{
					if (this->Y > 64) --this->Y;
					else ForwardBack = true;
				}
			}
			else if (Movement == 2)
			{
				if (!ForwardBack)
				{
					if (this->Y < 96) ++this->Y;
					else ForwardBack = true;
				}
				else
				{
					if (this->Y > 64) --this->Y;
					else ForwardBack = false;
				}
			}
			else if (Movement == 3)
			{
				if (ForwardBack)
				{
					if (this->X < 176) ++this->X;
					else ForwardBack = false;
				}
				else
				{
					if (this->X > 64) --this->X;
					else ForwardBack = true;
				}
			}
			else if (Movement == 4)
			{
				if (!ForwardBack)
				{
					if (this->X < 176) ++this->X;
					else ForwardBack = true;
				}
				else
				{
					if (this->X > 64) --this->X;
					else ForwardBack = false;
				}
			}
			else if (Movement == 5)
			{
				if (ForwardBack)
				{
					if (this->Y < 96 && this->X < 176)
					{
						++this->Y;
						++this->X;
					}
					else ForwardBack = false;
				}
				else
				{
					if (this->Y > 64 && this->X > 64)
					{
						--this->Y;
						--this->X;
					}
					else ForwardBack = true;
				}
			}
			else if (Movement == 6)
			{
				if (!ForwardBack)
				{
					if (this->Y < 96 && this->X < 176) 
					{
						++this->Y;
						++this->X;
					}
					else ForwardBack = true;
				}
				else
				{
					if (this->Y > 64 && this->X > 64)
					{
						--this->Y;
						--this->X;
					}
					else ForwardBack = false;
				}
			}
			else if (Movement == 7)
			{
				if (ForwardBack)
				{
					if (this->Y < 96 && this->X > 64)
					{
						++this->Y;
						--this->X;
					}
					else ForwardBack = false;
				}
				else
				{
					if (this->Y > 64 && this->X < 176)
					{
						--this->Y;
						++this->X;
					}
					else ForwardBack = true;
				}
			}
			else if (Movement == 8)
			{
				if (!ForwardBack)
				{
					if (this->Y < 96 && this->X > 64)
					{
						++this->Y;
						--this->X;
					}
					else ForwardBack = true;
				}
				else
				{
					if (this->Y > 64 && this->X < 176)
					{
						--this->Y;
						++this->X;
					}
					else ForwardBack = false;
				}
			}
		}
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Byrna attachment point (end) 
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Specific Script Defense (start)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// This is a workaround to there only being one Script Weapon defense in the editor in pre-2.55 versions.
// There's probably better ways to do this, even until then, but I figured it works for now.

ffc script SpecificLWDefense
{
	void run(int WhatEnemyID, int WhatLWeapon, int IgnoreWeapon)
	{

//D0 - NPC ID to affect
//D1 - Weapon ID. A 0 damage weapon still won't work.
//D2 - If 0, NPC will block wrong script weapons. Otherwise, NPC will ignore wrong script weapons.

		npc FFCrandoNPC;
		lweapon FFCrandoLW;
		int FFCForTimer;
		int FFCForTimerTwo;

		while(true)
		{
			Waitframe();
			
			for(FFCForTimer = Screen->NumNPCs(); FFCForTimer > 0; --FFCForTimer)
			{
				FFCrandoNPC = Screen->LoadNPC(FFCForTimer);
				if(!FFCrandoNPC->isValid()) continue;
				{
					if (FFCrandoNPC->ID == WhatEnemyID)
					{
						if (FFCrandoNPC->Defense[NPCD_SCRIPT] != NPCDT_IGNORE1)
						{
							for(FFCForTimerTwo = Screen->NumLWeapons(); FFCForTimerTwo > 0; --FFCForTimerTwo)
							{
								FFCrandoLW = Screen->LoadLWeapon(FFCForTimerTwo);
								if(!FFCrandoLW->isValid()) continue;
								{
									if (Collision(FFCrandoNPC,FFCrandoLW))
									{
										if (FFCrandoLW->ID == WhatLWeapon)
										{
											FFCrandoNPC->Defense[NPCD_SCRIPT] = NPCDT_IGNORE1;
											FFCrandoLW->DeadState = WDS_ALIVE;
										}
										else
										{
											if (FFCrandoLW->ID != LW_ROPE)
											{
												Remove(FFCrandoLW);
												Game->PlaySound(SFX_CLINK);
												FFCrandoNPC->Defense[NPCD_SCRIPT] = NPCDT_BLOCK;
											}
										}
									}
								}
							}
						}
						else if (NumLWeaponsOf(WhatLWeapon) == 0)
						{
								if (IgnoreWeapon == 0) FFCrandoNPC->Defense[NPCD_SCRIPT] = NPCDT_BLOCK;
								else FFCrandoNPC->Defense[NPCD_SCRIPT] = NPCDT_IGNORE;
						}
					}
				}
			}
		}
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Specific Script Defense (end) 
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Catch Minigame / Dodgy Game (start)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
ffc script BonusCatchGame
{
	void run(int leveltwo)
	{
		Waitframes(5);
		int FFCForTimer;
		item randoFFCitem;
		bool PlayMiniGame;
		if (Screen->NumNPCs() < 3) Quit();
		npc GameMaster = Screen->LoadNPC(3);
		if (!GameMaster->isValid()) Quit();
		int PlayerPos;
		int MasterWait;
		bool StartGame;
		int LegendOfLinkmusic[32] = "LegendOfLink.nsf";
		
		while(true)
		{
			Waitframe();

			for(FFCForTimer = Screen->NumItems(); FFCForTimer > 0; --FFCForTimer)
			{
				randoFFCitem = Screen->LoadItem(FFCForTimer);
				if(!randoFFCitem->isValid()) continue;
				{
					if (StartGame) randoFFCitem->Y = randoFFCitem->Y + 2;
					else
					{
						if (randoFFCitem->ID == I_CATCHGAME)
						{
							if (randoFFCitem->Pickup != 0) randoFFCitem->Pickup = 0;
							if (Link->X > randoFFCitem->X - 12 && Link->X < randoFFCitem->X + 12 && Link->Y < randoFFCitem->Y + 12 && Link->Y > randoFFCitem->Y -12)
							{
								randoFFCitem->X = Link->X;
								randoFFCitem->Y = Link->Y;
								NoAction();
								Game->PlaySound(SFX_CLEARED);
								StartGame = true;
								MasterWait = 80;
								Game->PlayEnhancedMusic(LegendOfLinkmusic,47);
							}
						}
					}
				}
			}

			if (StartGame)
			{
				if (GameMaster->Y > 40) 
				{
					if (Screen->NumItems() == 0)
					{
						--GameMaster->Y;
						if (Link->Y < 112) ++Link->Y;
						if (Link->X < 120) ++Link->X;
						if (Link->X > 120)-- Link->X;
						Link->Dir = DIR_UP;
						NoAction();
					}
				}	
				else if (Link->Y < 129)
				{
					if (PlayerPos == 0) 
					{
						Link->X = 120;
						if (Link->PressLeft) PlayerPos = 1;
						else if (Link->PressRight) PlayerPos = 2;
					}
					else if (PlayerPos == 1) 
					{
						Link->X = 88;
						if (Link->PressRight) PlayerPos = 0;
					}
					else if (PlayerPos == 2) 
					{
						Link->X = 152;
						if (Link->PressLeft) PlayerPos = 0;
					}
					Link->InputLeft = false;
					Link->PressLeft = false;
					Link->InputRight = false;
					Link->PressRight = false;
					if (Link->Y <= 112)
					{
						if (MasterWait == 0)
						{
							GameMaster->X = Choose(88,120,152);
							MasterWait = Rand(24,80);
							Game->PlaySound(SFX_MSG);
							if (!leveltwo)
							{
								if (!IsRandomizer())
								{
									item Goody = CreateItemAt(
									Choose
									(
										I_RUPOOR,
										I_RUPOOR,
										I_NEGAHEART, 
										Choose					
										(
											I_RUPOOR,
											I_HEART,
											I_HEART,
											I_HEARTTWO,
											I_NEGAHEART,
											I_NEGAHEART
										), 
										Choose
										(
											I_RUPEE1,
											I_RUPEE1,
											I_RUPOOR,
											I_RUPEE5,
											Choose
											(
												I_NEGAHEART,
												I_RUPEE1,
												I_RUPOOR,
												I_RUPOOR,
												I_RUPOOR,
												I_RUPEE10
											)
										)
									),GameMaster->X,GameMaster->Y);
								}
								else 
								{
									item Goody = CreateItemAt(
									Choose
									(
										I_RUPOOR,
										I_NEGAHEART, 
										Choose
										(
											Choose(I_RUPEE5,I_HEART),
											I_RUPEE10,
											I_RUPEE20,
											I_RUPOORTEN,
											Choose
											(
												I_HEARTTWO,
												I_RUPOORTEN,
												I_RUPOORTEN,
												I_RUPEE10,
												I_RUPEE20,
												I_RUPEE50
											)
										)
									),GameMaster->X,GameMaster->Y);
								}
							}
							else
							{
								item Goody = CreateItemAt(
								Choose
								(
									I_RUPOORTEN,
									I_RUPOORTEN,
									I_NEGAFAIRY, 
									Choose					
									(
										I_RUPOORTEN,
										I_HEARTTWO,
										I_HEARTTWO,
										I_FAIRY,
										I_NEGAFAIRY,
										I_NEGAFAIRY
									), 
									Choose
									(
										I_RUPEE10,
										I_RUPEE10,
										I_RUPOORTEN,
										I_RUPEE50,
										Choose
										(
											I_NEGAFAIRY,
											I_RUPEE10,
											I_RUPOORTEN,
											I_RUPOORTEN,
											I_RUPOORTEN,
											I_RUPEE100
										)
									)
								),GameMaster->X,GameMaster->Y);
							}
						}
						else --MasterWait;
						Link->Dir = DIR_UP;
						Link->InputUp = false;
						Link->PressUp = false;
					}
				}
			}
		}
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Catch Minigame (end)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: New Triforce Guy (start)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
ffc script TriforceGuy
{
	void run(int OnesWhoDoesNot, int DontReturnD, int HowManyHP, int WrongEntrance)
	{
// D0 - String to say if Link does not have all triforce pieces.
// D1 - D which is set to prevent the boss from returning after defeat.
// D2 - Number of hits required to defeat him.
// D3 - String to say if Link enters this room with all the triforce pieces, but from an entrance too high on the screen (not the bottom).
		Waitframes(4);
		if (Screen->D[DontReturnD] > 0)
		{
			Screen->Door[DOOR_UP] = D_OPEN;
			Game->PlaySound(SFX_SHUTTER);
			Quit();
		}
		npc TriforceMaster = CreateNPCAt(NPC_ABEI,120,64);
		npc TriFire1 = CreateNPCAt(NPC_FIRE,72,64);
		npc TriFire2 = CreateNPCAt(NPC_FIRE,168,64);
		if (NumTriforcePieces() < 8)
		{
			Screen->TriggerSecrets();
			Screen->Message(OnesWhoDoesNot);
			Quit();
		}
		if (Link->Y < 96)
		{
			Screen->TriggerSecrets();
			Screen->Message(WrongEntrance);
			Quit();
		}
		int PlayerPos;
		int TriGuyHP = HowManyHP;
		int TriGuyFlash;
		int MasterWait = 60;
		lweapon SomariaBlock;
		item randoFFCitem;
		int FFCForTimer;
		
		while(true)
		{
			Waitframe();
			if (TriforceMaster->Y > 40) 
			{
				--TriforceMaster->Y;
				if (Link->Y > 112) --Link->Y;
				if (Link->Y < 112) ++Link->Y;
				if (Link->X < 120) ++Link->X;
				if (Link->X > 120) --Link->X;
				Link->Dir = DIR_UP;
				NoAction();
			}	
			else if (Link->Y < 128)
			{
				if (Link->Y > 112) --Link->Y;
				else if (Link->Y < 112) ++Link->Y;
				if (PlayerPos == 0) 
				{
					Link->X = 120;
					if (Link->PressLeft) PlayerPos = 1;
					else if (Link->PressRight) PlayerPos = 2;
				}
				else if (PlayerPos == 1) 
				{
					Link->X = 88;
					if (Link->PressRight) PlayerPos = 0;
				}
				else if (PlayerPos == 2) 
				{
					Link->X = 152;
					if (Link->PressLeft) PlayerPos = 0;
				}
				Link->InputLeft = false;
				Link->PressLeft = false;
				Link->InputRight = false;
				Link->PressRight = false;
				if (Link->Y <= 112)
				{
					if (MasterWait == 0)
					{
						if (TriforceMaster->TileWidth < 2)
						{
							TriforceMaster->X = Choose(88,120,152);
							MasterWait = Rand(24,80);
							Game->PlaySound(SFX_WAND);
							item Baddy = CreateItemAt(I_NEGAHEART,TriforceMaster->X,TriforceMaster->Y);
						}
						else TriforceMaster->X = 112;
					}
					else --MasterWait;
					Link->Dir = DIR_UP;
					Link->InputUp = false;
					Link->PressUp = false;
					Link->InputDown = false;
					Link->PressDown = false;
					Link->InputB = false;
					Link->PressB = false;
					Link->InputEx1 = false;
					Link->PressEx1 = false;
				}
				for(FFCForTimer = Screen->NumItems(); FFCForTimer > 0; --FFCForTimer)
				{
					randoFFCitem = Screen->LoadItem(FFCForTimer);
					if(!randoFFCitem->isValid()) continue;
					{
						randoFFCitem->Y = randoFFCitem->Y + 2;
					}
				}
				SomariaBlock = LoadLWeaponOf(LW_SOMARIA);
				if (SomariaBlock->isValid())
				{
					--SomariaBlock->Y;
					if (Collision(SomariaBlock,TriforceMaster))
					{
						Remove(SomariaBlock);
						Game->PlaySound(SFX_GASP);
						if (TriGuyHP > 0) --TriGuyHP;
						TriGuyFlash = 40;
					}
				}
				if (TriGuyFlash > 0)
				{
					TriforceMaster->CSet = Choose(6,7,8,9);
					--TriGuyFlash;
					if (TriGuyFlash <= 1) TriforceMaster->CSet = 8;
				}
				if (TriGuyHP <= 0)
				{
					if (TriforceMaster->TileWidth == 1)
					{
						TriforceMaster->CSet = 11;
						TriforceMaster->OriginalTile = 260;
						Game->PlayMIDI(0);
						Game->PlaySound(SFX_GANON);
						TriforceMaster->Extend = 3;
						TriforceMaster->TileWidth = 2;
						TriforceMaster->TileHeight = 2;
						TriforceMaster->X = TriforceMaster->X - 8;
						TriforceMaster->Y = TriforceMaster->Y - 8;
						TriGuyFlash = 120;
					}
					else
					if (TriGuyFlash == 0)
					{
						if (TriforceMaster->CSet != 11) TriforceMaster->CSet = 11;
						--TriforceMaster->Y;
					}
				}
			}
			if (TriforceMaster->Y < -88)
			{
				Remove(TriforceMaster);
				Game->PlaySound(SFX_SHUTTER);
				Screen->State[ST_SPECIALITEM] = true;
				Screen->D[DontReturnD] = 1;
				Screen->Door[DOOR_UP] = D_OPEN;
				Quit();
			}
		}
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: New Triforce Guy (end)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Falling Pushblock (start)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
ffc script FallingPushblocks
{
	void run()
	{

	int FFCForTimer;
	int FFCForTimerTwo;
	lweapon SmashyFally;
	npc SquishySmushedface;

	this->Flags[FFCF_ETHEREAL] = true;

		while(true)
		{
			Waitframe();

			if (SmashyFally->isValid()) Remove(SmashyFally);

			for (FFCForTimer = 175; FFCForTimer > 0; --FFCForTimer)
			{
				if (Screen->ComboF[FFCForTimer] >= CF_PUSHUPDOWN && Screen->ComboF[FFCForTimer] <= CF_PUSH4WAY || Screen->ComboF[FFCForTimer] >= CF_PUSHLR && Screen->ComboF[FFCForTimer] <= CF_PUSHRIGHTINS)
				{
					if (ComboY(FFCForTimer) < 160)
						{
						if (Screen->ComboI[FFCForTimer + 16] != CF_NOBLOCKS)
						{
							if (Screen->ComboF[FFCForTimer] + 16 != CF_NOBLOCKS)
							{
								if (Screen->ComboS[FFCForTimer + 16] == 0) 
								{
									Screen->ComboD[FFCForTimer + 16] = Screen->ComboD[FFCForTimer];
									Screen->ComboF[FFCForTimer + 16] = Screen->ComboF[FFCForTimer];
									Screen->ComboD[FFCForTimer] = Screen->UnderCombo;
									Screen->ComboF[FFCForTimer] = CF_NONE;
									this->X = ComboX(FFCForTimer+16);
									this->Y = ComboY(FFCForTimer+16);
									for (FFCForTimerTwo = Screen->NumNPCs(); FFCForTimerTwo > 0; --FFCForTimerTwo)
									{
										SquishySmushedface = Screen->LoadNPC(FFCForTimerTwo);
										if (!SquishySmushedface->isValid()) continue;
										{
											if (Collision(this,SquishySmushedface) && SquishySmushedface->Y > this->Y+8) SquishySmushedface->HP = 0;
										}
									}
									if (LinkCollision(this))
									{
										if (Link->Y > this->Y+8)
										{ 	
											if (Link->X > this->X-8 && Link->X < this->X + 8)
											{
												if (Link->HP > 16) Link->HP = 16;
												else Link->HP = 0;
												Link->Action = LA_GOTHURTLAND;
												Game->PlaySound(SFX_OUCH);
											}
										}
									}
									Game->PlaySound(SFX_SHUTTER);
								}
							}
						}
					}
					else
					{
						Screen->ComboD[FFCForTimer] = Screen->UnderCombo;
						Screen->ComboF[FFCForTimer] = 0;
						Game->PlaySound(SFX_SHUTTER);
					}
				}
			}
		}
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Falling Pushblock (end)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: ZII Falling Blocks (start)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
const int COMBO_EARLYBLANK = 3;

ffc script ZIIDropBlocks
{
	void run(int FallType, int FallHurt, int FallSpeed)
	{

		this->Flags[FFCF_LENSVIS] = false;
		bool Fall;
		lweapon randoLW;
		int FFCForTimer;
		int HitAgain = 0;
		int StartData = this->Data;
		this->Data = COMBO_EARLYBLANK;
		if (this->CSet == 0) this->CSet = 9;
	
		while(true)
		{
			Waitframe();
			
			if (HitAgain > 0) --HitAgain;
	
			if (Fall == false)
			{
				this->Y = 0;
				this->X = (Rand(16))*16;
				if (Screen->ComboS[ComboAt(this->X+7,this->Y+17)] != 0 && this->Y < 8) this->X = (Rand(16))*16;
				else if (Screen->ComboT[ComboAt(this->X+7,this->Y+17)] != CT_SIDECLIMB)
				{
					if (!LinkCollision(this))
					{
						this->Vy = 4 + FallSpeed;
						this->Data = StartData;
					}
					Fall = true;
					Game->PlaySound(SFX_CRUMBLE);
				}
			}	
			else
			{
				if (Screen->ComboS[ComboAt(this->X+7,this->Y+17)] != 0 && this->Y > 15)
				{
					Screen->ComboD[ComboAt(this->X+7,this->Y+8)] = this->Data;
					Screen->ComboC[ComboAt(this->X+7,this->Y+8)] = this->CSet;
					Fall = false;
					this->Data = COMBO_EARLYBLANK;
					this->Vy = 0;
				}
				if (Link->Action != LA_GOTHURTLAND)
				{
					if (this->X > Link->X - 8 && this->X < Link->X + 8 && this->Y > Link->Y - 16 && this->Y < Link->Y + 8)
					{
						Fall = false;
						this->Data = COMBO_EARLYBLANK;
						this->Vy = 0;
						if (HitAgain == 0 && Link->Action != LA_DROWNING)
						{
							Link->HP = Link->HP - (8+FallHurt);
							Link->Action = LA_GOTHURTLAND;
							Game->PlaySound(SFX_OUCH);
							HitAgain = 32;
						}
						lweapon Smash = CreateLWeaponAt(LW_SPARKLE,this->X,this->Y);
						if (Smash->isValid())
						{
							Smash->UseSprite(SP_SPAWN);
							Smash->CSet = this->CSet;
						}
					}
				}
				for(FFCForTimer = Screen->NumLWeapons(); FFCForTimer > 0; --FFCForTimer)
				{
					randoLW = Screen->LoadLWeapon(FFCForTimer);
					if(!randoLW->isValid()) continue;
					{
						if (randoLW->ID != LW_SPARKLE && randoLW->ID != LW_ROPE)
						{
							if (randoLW->X > this->X - 8)
							{
								if (randoLW->X < this->X + 8)
								{
									if (Collision(this,randoLW))
									{
										if (randoLW->ID != LW_CANEOFBYRNA)
										{
											randoLW->DeadState = WDS_DEAD;
											if (randoLW->ID == LW_ARMOS)
											{
												lweapon	ArmosPoof = CreateLWeaponAt(LW_SPARKLE,randoLW->X,randoLW->Y);
												ArmosPoof->UseSprite(SP_MISC_DEATH);
												Remove(randoLW);
											}
										}
										Fall = false;
										this->Data = COMBO_EARLYBLANK;
										this->Vy = 0;
										lweapon Smash = CreateLWeaponAt(LW_SPARKLE,this->X,this->Y);
										if (Smash->isValid())
										{
											Smash->UseSprite(SP_SPAWN);
											Smash->CSet = 9;
										}
									Game->PlaySound(SFX_SHATTERING);
									}
								}
							}
						}
					}
				}
			}
			if (this->Y >= 176)
			{
				Fall = false;
				this->Data = COMBO_EARLYBLANK;
			}
// end 
		}
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: ZII Falling Blocks (end)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Big Armos (start)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
//This FFC must be placed in the upper-left corner of a 2x2 space which it will uncover.

ffc script BigArmos
{
	void run(int ArmosSecrets, int NoItemRequired)
	{
//D0 - If 0, Screen->Undercombo will be left under this FFC. Otherwise, touching this armos will trigger temporary secrets.
//D1 - if 0, will require the item I_ARMOS to be in Link's inventory. Otherwise, no item is needed.

	this->Flags[FFCF_ETHEREAL] = true;
	this->TileWidth = 2;
	this->TileHeight = 2;
	int WaitToClear = 0;

		while(true)
		{
			Waitframe();
			
			if (Link->Item[I_ARMOS] || NoItemRequired != 0)
			{
				if (WaitToClear == 0)
				{
					if (LinkCollision(this))
					{
						Game->PlaySound(SFX_SHUTTER);
						WaitToClear = 200;
					}
				}
			}
			if (WaitToClear > 0)
			{
				--WaitToClear;
				if (WaitToClear > 60)
				{
					if(!(WaitToClear%2)) Screen->DrawTile(
							3,
							this->X,	//start X
							this->Y,	//start y
							BIGARMOS_TILE,	//tile ID
							2,		//tile width
							2,		//tile width
							7,		//tile cset
							-1,-1,-1,-1,0,0,1,128);
				}
				else if (WaitToClear == 60)
				{
					Game->PlaySound(SFX_ROAR);
					npc BigArmos = CreateNPCAt(NPC_BIGARMOS,this->X+8,this->Y+8);
				}
				else if (WaitToClear == 1)
				{
					if (ArmosSecrets == 1)
					{
						Screen->TriggerSecrets();
						Game->PlaySound(SFX_SECRET);
					}
					else
					{
						Screen->ComboD[ComboAt(this->X+8,this->Y+8)] = Screen->UnderCombo; 
						Screen->ComboD[ComboAt(this->X+24,this->Y+8)] = Screen->UnderCombo;
						Screen->ComboD[ComboAt(this->X+8,this->Y+24)] = Screen->UnderCombo;
						Screen->ComboD[ComboAt(this->X+24,this->Y+24)] = Screen->UnderCombo;
					}
					Quit();
				}
			}
		}		
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Big Armos (end)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Fishing (start)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
ffc script Fishing
{
	void run(int Warp, int MeterTile, int BonusPrize1, int BonusPrize2, int SplashSprite, int SetLocation, int CheckForDock, int Raft)
	{

// D0: Fishing pier - If set to something other than 0, if Link has the fishing rod, this FFC will set it's combo data to D0 (as soon as it isn't touching Link), and not run the rest of the script.
// D1: Tile to use for drawing the cast-charging meter. 0 for no meter.
// D2: Bonus prize that has a chance of appearing after the screen item is obtained. Use this only for good.
	// Set D2 to a negative number to prevent any bonus prizes appearing after the screen item.
// D3: A second bonus prize like the first that has a slightly smaller chance of appearing. Seriously, don't use this for evil purposes or I will 1 star your quest on PureZC if I find out.
// D4: Weapon sprite to use for splash animation when hook hits the water (0 for no effect)
// D5: If greater than 0, bonus prizes will appear at Combo[D5]. If 0, bonus prizes will spawn at random non-solid locations.
// D6: If greater than 0, D0 will not activate until D6 combo is at this position.
// D7: If greater than 0 and Link has the raft item, Link will raft to the left edge if he presses left.

		int RodCharge;
		int RodChargeWait;
		bool RodIsCast;
		bool ItemIsHooked;
		bool NoRepeatA;
		bool HasSplashed;
		bool PositionSet;
		int StopPrizes = Rand(2,16);
		int FirstItemX;
		int FirstItemY;

		item FFCRandoItem;
		item HookedItem;
		item BonusRupy;
		npc FFCRandoNPC;
		eweapon FFCRandoEW;
		int FFCForTimer;
		if (!Link->Item[I_FISHINGROD]) this->Flags[FFCF_ETHEREAL] = true;

		if (Warp > 0)
		{
			if (CheckForDock > 0)
			{
				while (Screen->ComboD[ComboAt(this->X+7,this->Y+8)] != CheckForDock) Waitframe();
				if (Screen->ComboD[ComboAt(this->X+7,this->Y+8)] == CheckForDock)
				{
					while(Link->Action == LA_RAFTING)	Waitframe();
					while(LinkCollision(this))	Waitframe();
					if (Link->Item[I_FISHINGROD]) 
					{
						this->Data = Warp;
						this->Flags[FFCF_ETHEREAL] = false;
					}
				}
			}
			else
			{
				while(Link->Action == LA_RAFTING)	Waitframe();
				while(LinkCollision(this))	Waitframe();
				if (Link->Item[I_FISHINGROD]) 
				{
					this->Data = Warp;
					this->Flags[FFCF_ETHEREAL] = false;
				}
			}
		}
		else
		{
			DoDraw = false;
			this->X = Link->X-8;
			this->Y = Link->Y+8;
			while(!Raft || !Link->Item[26] || RodIsCast || !Link->PressLeft || Link->InputA)
			{	

// ------------ Meter
				if (RodCharge > 5 && MeterTile != 0)
				{
					for(FFCForTimer = RodCharge-6; FFCForTimer > 0; --FFCForTimer)
					{
						Screen->FastTile(6,64+(FFCForTimer-1)*8,-8,MeterTile,this->CSet,128);		
					}
				}

				Waitframe();
				Link->Jump = 0;
				Link->X = 224;
				Link->Y = 16;
				Link->Dir = DIR_LEFT;

// ------------ Leave the screen
				if (Link->PressStart)
				{
					Link->X = 256;
					DoDraw = true;
				}

// ------------ Link animations during fishing
				if (Link->Action != LA_HOLD1LAND && Link->Action != LA_HOLD2LAND)
				{

					if (RodIsCast)
					{ 
						Link->Action = LA_NONE;
						Link->Action = LA_ATTACKING;
					}
				}
				else
				{
					this->X = Link->X-8;
					this->Y = Link->Y+8;
					RodIsCast = false;
				}

// ------------ Fishing hook triggers secrets
				if (Screen->ComboF[ComboAt(this->X+7,this->Y+8)] == CF_STRIKE && !Screen->State[ST_SECRET])
				{
					Screen->State[ST_SECRET] = true;
					Game->PlaySound(27);
					Screen->TriggerSecrets();
				}

// ------------ Fishing hook destroys dirt / fake walls
				if (Screen->ComboT[ComboAt(this->X+7,this->Y+8)] == CT_SCRIPT1)
				{
					Screen->ComboD[ComboAt(this->X+7,this->Y+8)] = Screen->UnderCombo;
					lweapon DirtPoof = CreateLWeaponAt(LW_SPARKLE,this->X,this->Y);
					DirtPoof->UseSprite(SP_SPAWN);
					Game->PlaySound(SFX_MSG);					
				}

// ------------ Controlling the fishing hook
				if (Link->PressA && !RodIsCast) NoRepeatA = true;

// ------------ Preparing to cast the hook
				if (Link->InputA)
				{
					if (LinkCollision(this) && !RodIsCast)
					{
						if (NoRepeatA)
						{
							if (Link->PressA) Game->PlaySound(SFX_ARROW);
							if (RodCharge == 0) RodCharge = 5;
							if (RodChargeWait == 0)
							{
								++RodCharge;
								RodChargeWait = 4;
							}
							else if (RodCharge < 22) --RodChargeWait;
							Screen->FastTile(4,Link->X-10,Link->Y-2,FISHINGROD_TILE+2,this->CSet,128);
						}
					}
					else
					{
// ------------ Reeling in the hook
						if (this->Y < Link->Y+8) ++this->Y;
						if (this->Y > Link->Y+8)
						{
							if (Screen->ComboS[ComboAt(this->X+7,this->Y-1)] == 0 || this-> Y < Link->Y+32 && this->X > Link->X - 16) --this->Y;
						}

						if (this->X > Link->X-8) --this->X;
						if (this->X < Link->X-8)
						{
							if (Screen->ComboS[ComboAt(this->X+12,this->Y+8)] != 1111b || this-> Y < Link->Y+32 && this->X > Link->X - 32) ++this->X;
						}
						if (LinkCollision(this))
						{
							this->X = Link->X-8;
							this->Y = Link->Y+8;
							RodIsCast = false;
						}
						Screen->FastTile(4,Link->X-10,Link->Y-2,FISHINGROD_TILE+1,this->CSet,128);
					}
				}
				else
				{
// ------------ Casting the fishing hook
					if (RodCharge > 0)
					{
						Game->PlaySound(SFX_BRANG);
						this->Vx = this->Vx - RodCharge;
						this->Vy = (RodCharge/2 - RodCharge);
						RodCharge = 0;
						RodIsCast = true;
					}
					Screen->FastTile(4,Link->X-10,Link->Y-2,FISHINGROD_TILE,this->CSet,128);
// ------------ The hook sinks
					if (!LinkCollision(this) && Screen->ComboS[ComboAt(this->X+7,this->Y+17)] != 1111b) ++this->Y;
				}

				if (!Link->PressA && !Link->InputA && NoRepeatA) NoRepeatA = false; 

// ------------ Casting momentum slows
				if (this->Vx != 0)
				{
//					if (Screen->ComboS[ComboAt(this->X+7,this->Y-2)] == 0 && this->Y > -8) this->Y = this->Y - 4; 
					if (this->Vx < 0) ++this->Vx;
					if (this->X <= 0 || this->Vx > 0) this->Vx = 0;
				}
				if (this->Vy != 0)
				{
					if (this->Vy < 0) ++this->Vy;
					if (this->Y <= -8 || this->Vy > 0) this->Vy = 0;
				}

// ------------ splash effect
				if (!HasSplashed)
				{
					if (RodIsCast)
					{
						if (Screen->ComboT[ComboAt(this->X+7,this->Y+14)] == CT_WATER)
						{
							if (this->X < Link->X - 40)
							{
								Game->PlaySound(SFX_SPLASH);
								HasSplashed = true;
								if (SplashSprite != 0)
								{
									lweapon Sploooosh = CreateLWeaponAt(LW_SPARKLE,this->X,this->Y+8);
									Sploooosh->UseSprite(SplashSprite);
								}
							}
						}
					}
				}
				else if (HasSplashed)
				{
					if (!RodIsCast) HasSplashed = false; 
				}

// ------------ Catching items
				for(FFCForTimer = Screen->NumItems(); FFCForTimer > 0; --FFCForTimer)
				{
					FFCRandoItem = Screen->LoadItem(FFCForTimer);
					if(!FFCRandoItem->isValid()) continue;
					{
						if (Collision(this,FFCRandoItem))
						{
							if (!ItemIsHooked)
							{
								if (this->X > FFCRandoItem->X-4 && this->X < FFCRandoItem->X+4 && this->Y > FFCRandoItem->Y - 8 && this->Y < FFCRandoItem->Y + 8)
								{
									if (FirstItemX == 0) FirstItemX = FFCRandoItem->X;
									if (FirstItemY == 0) FirstItemY = FFCRandoItem->Y;
									Game->PlaySound(SFX_MSG);
									HookedItem = Screen->LoadItem(FFCForTimer);
									ItemIsHooked = true;
								}
							}
						}
						if (!ItemIsHooked)
						{
							if (CanWalk(FFCRandoItem->X,FFCRandoItem->Y,DIR_DOWN,1,false) || FFCRandoItem->Y >= 160) ++FFCRandoItem->Y;
						}
					}
				}
				if (HookedItem->isValid())
				{
					if (Collision(this,HookedItem) && ItemIsHooked)
					{
						HookedItem->X = this->X;
						HookedItem->Y = this->Y;
					}
				}
				else if (ItemIsHooked) ItemIsHooked = false;

// ------------ Bonus items
				if (StopPrizes > 0)
				{
					if (Screen->State[ST_ITEM] && BonusPrize1 >= 0)
					{
						if (Screen->NumItems() == 0)
						{
							PositionSet = false;
							BonusRupy = CreateItemAt(Choose(I_RUPEE1,I_RUPEE1,I_RUPEE5,I_HEART,Choose(I_RUPEE1,I_RUPEE5,I_RUPEE5,BonusPrize1,BonusPrize1,BonusPrize2)),Rand(12)*16,Rand(2,8)*16);
							--StopPrizes;
						}
						if (BonusRupy->isValid())
						{
							if (SetLocation >0 && !PositionSet)
							{
								BonusRupy->X = ComboX(SetLocation);
								BonusRupy->Y = ComboY(SetLocation);
								PositionSet = true;
							}
							if (Screen->ComboS[ComboAt(BonusRupy->X+7,BonusRupy->Y+12)] != 0)
							{
								if (!Collision(this,BonusRupy))
								{
									//PositionSet = false;
									BonusRupy->X = Rand(12)*16;
									BonusRupy->Y = Rand(2,8)*16;
								}
							}
						}
					}
				}
			
// ------------ Enemies break the line

				for(FFCForTimer = Screen->NumNPCs(); FFCForTimer > 0; --FFCForTimer)
				{
					FFCRandoNPC = Screen->LoadNPC(FFCForTimer);
					if(!FFCRandoNPC->isValid()) continue;
					{
						if (Collision(this,FFCRandoNPC) && FFCRandoNPC->Stun == 0)
						{
							FFCRandoNPC->Stun = 511;
							Game->PlaySound(SFX_EHIT);
							this->X = Link->X-8;
							this->Y = Link->Y+8;
							RodIsCast = false;
							ItemIsHooked = false;
						}
					}
				}

// ------------ EWeapons break the line

				for(FFCForTimer = Screen->NumEWeapons(); FFCForTimer > 0; --FFCForTimer)
				{
					FFCRandoEW = Screen->LoadEWeapon(FFCForTimer);
					if(!FFCRandoEW->isValid()) continue;
					{
						if (Collision(this,FFCRandoEW))
						{
							if (FFCRandoEW->ID == EW_ARROW) FFCRandoEW->DeadState = WDS_ARROW;
							else FFCRandoEW->DeadState = WDS_DEAD;
							Game->PlaySound(SFX_CLINK);
							this->X = Link->X-8;
							this->Y = Link->Y+8;
							RodIsCast = false;
							ItemIsHooked = false;
						}
					}
				}

// ------------ Hook falling offscreen breaks the line, and B cancels hook
				if (this->Y > 170 || Link->PressB)
				{
					Game->PlaySound(SFX_MSG);
					this->X = Link->X-8;
					this->Y = Link->Y+8;
					RodIsCast = false;
					ItemIsHooked = false;
				}

// ------------ Item that falls ofscreen respawns where it started
				if (!ItemIsHooked)
				{
					if (FirstItemX > 0 && FirstItemY > 0)
					{
						if (FFCRandoItem->isValid())
						{
							if (FFCRandoItem->Y > 176)
							{
								FFCRandoItem->X = FirstItemX;
								FFCRandoItem->Y = FirstItemY;
							}
						}
					}
				}

// ------------ Link animations that had to be at the end
				if (NoRepeatA) Link->InputLeft = true;
				else if (Link->InputLeft) Link->InputLeft = false;
				Link->InputRight = false;
				Link->InputUp = false;
				Link->InputDown = false;
				Link->PressB = false;
				Link->InputB = false;
				Link->PressA = false;
				Link->InputA = false;
			}
			if (Link->Item[26] && Link->PressLeft && Raft)
			{
				this->Data = COMBO_RAFT;
				this->CSet = 6;
				this->X = Link->X;
				this->Y = Link->Y+5;
				int savey = Link->Y;
				Game->PlaySound(SFX_SECRET);
				while(Link->X >= 0)
				{
					NoAction();
					this->X = Link->X;
					this->Y = Link->Y+5;
					--Link->X;
					Link->Jump = 0;
					Link->Z = 0;
					Link->Y = savey;
					Waitframe();
				}
			}
		}
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Fishing (end)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// "Change NPC Original Tile" script (start)
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// This is a primitive script meant only for changing the room guy. 
// It only runs once at the beginning of the screen, after the NPCs normally spawn.
// It could in theory be used to change enemy graphics during the screen loading, too, though.

ffc script ChangeNPCOrigTile
{
	void run(int GuyID, int WhatTile, int WhatCSet)
	{
//D0 - NPC ID to change
//D1 - Original Tile to change to. If 0, will not change.
//D2 - CSet to change to. If 0, will not change. Set to -1 to use CSet 0.

		Waitframes(4);
		npc NPCGuy = LoadNPCOf(GuyID);
		if (NPCGuy->isValid()) 
		{
			if (WhatTile > 0) NPCGuy->OriginalTile = WhatTile;
			if (WhatCSet == -1) NPCGuy->CSet = 0;
			else if (WhatCSet > 0) NPCGuy->CSet = WhatCSet;
		}
		Quit();
	}
}
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// "Change NPC Original Tile" script (end)
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Message on contact (start)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
const int MSG_FRAGMENT = 55; 		// Message to display if the player has not picked up a Tablet Fragment on the current dmap.

ffc script MessageTouch
{
	void run(int WhatMessage, int RequireFragment, int ParticularFragment)
	{
// D0 - Message to display
// D1 - If != 0, a Tablet Fragment item must be picked up before the normal message will display.
	// Note that if a tablet fragment is required, the message will display automatically without touching it.
	// Also, if the player has the required fragment, this FFC's combo data will increase by 1.
// D2 - If 0, D1 will require the current dmap's tablet fragment. Otherwise, D1 will require dmap D2's tablet fragment.

		while(true)
		{
			Waitframe();

			if (RequireFragment == 0)
			{
				if (LinkCollision(this))
				{
					Screen->Message(WhatMessage);
					Quit();
				}
			}
			else
			{
				if (ParticularFragment == 0)
				{
					if (TabletFragments[Game->GetCurDMap()] == 1)
					{
						if (LinkCollision(this))
						{
							Screen->Message(WhatMessage);
							++this->Data;
							Game->PlaySound(SFX_SCALE);
							Quit();
						}
					}
					else
					{
						Screen->Message(MSG_FRAGMENT);
						Quit();
					}
				}
				else
				{
					if (TabletFragments[ParticularFragment] == 1)
					{
						if (LinkCollision(this))
						{
							Screen->Message(WhatMessage);
							Game->PlaySound(SFX_SCALE);
							++this->Data;
							Quit();
						}
					}
					else 
					{
						Screen->Message(MSG_FRAGMENT);
						Quit();
					}
				}
			}
		}
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Message on contact (end)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Special Sword Spawn (start)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
ffc script SpecialSwordSpawn
{
	void run(int RemoveSword)
	{
// D0 - if 0, this will spawn swords based on Link's canes of somaria. Otherwise, it will take away Link's swords.

		if (RemoveSword != 0)
		{
			Link->Item[I_SWORD1] = false;
			Link->Item[I_SWORD2] = false;
			Link->Item[I_SWORD3] = false;
			Link->Item[I_PERILSCROLL] = false;
			Quit();
		}
		Waitframes(4);
		this->Flags[FFCF_ETHEREAL] = true;
		if (!Link->Item[I_SWORD3] && !Link->Item[I_SWORD2] && !Link->Item[I_SWORD1])
		{
			if (Link->Item[I_CANE3]) item MagicSword = CreateItemAt(I_SWORD3,this->X,this->Y);
			else if (Link->Item[I_CANE2]) item WhiteSword = CreateItemAt(I_SWORD2,this->X,this->Y);
			else if (Link->Item[I_CANE1]) item Sword = CreateItemAt(I_SWORD1,this->X,this->Y);
		}
		if (Link->Item[I_SOMARIAPERIL])
		{
			while(true)
			{
				Waitframe();
				if (!Link->Item[I_PERILSCROLL])
				{
					if (Link->Item[I_SWORD1] || Link->Item[I_SWORD2] || Link->Item[I_SWORD3]) Link->Item[I_PERILSCROLL] = true;
				}
				else Quit();
			}
		}
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Special Sword Spawn (end)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Draw Items (start)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
ffc script DrawItems
{
	void run()
	{

	int FFCForTimer;
	item FFCRandoItem;

		while(true)
		{
			Waitframe();
			if (Game->Counter[CR_WEATHER] != ENV_SKEW)
			{
				for(FFCForTimer = Screen->NumItems(); FFCForTimer > 0; --FFCForTimer)
				{
					FFCRandoItem = Screen->LoadItem(FFCForTimer);
					if(!FFCRandoItem->isValid()) continue;
					{
						if (Link->Item[I_CURSEDPICTOBOX]) Screen->FastTile(7,FFCRandoItem->X + (120 - Link->X),FFCRandoItem->Y + (80 - Link->Y),FFCRandoItem->Tile,FFCRandoItem->CSet,128);
						else Screen->FastTile(7,FFCRandoItem->X,FFCRandoItem->Y,FFCRandoItem->Tile,FFCRandoItem->CSet,128);
					}
				}
			}
		}
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Draw Items (end)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: LWeapon Trigger (start)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
ffc script LWeaponTrigger
{
	void run(int WhatWeapon, int WhatSecrets, int WhatDoor, int WhatData)
	{
//D0 - What LWeapon to react to.
//D1 - If 0, opens D2 door. If 1, triggers temporary secrets. If 2, triggers permanent secrets. If 3, no secrets or doors are changed in any way, but this FFC still reacts (such as making a noise and using the D3 argument to change this FFC's combo data)
//D2 - If D1 is 0, D2 determines which door to open (0 = DOOR_UP, etc).
//D3 - If 0, nothing happens. Otherwise, this FFC will set itself to D3 combo data once triggered.

	lweapon randoLW;
	int FFCForTimer;

		while(true)
		{
			Waitframe();
			
			for(FFCForTimer = Screen->NumLWeapons(); FFCForTimer > 0; --FFCForTimer)
			{
				randoLW = Screen->LoadLWeapon(FFCForTimer);
				if (!randoLW->isValid()) continue;
				{
					if (randoLW->ID == WhatWeapon)
					{
						if (Collision(this,randoLW))
						{
							Game->PlaySound(SFX_SECRET);
							Remove(randoLW);
							if (WhatData > 0) this->Data = WhatData;

							if (WhatSecrets == 0)
							{
								Screen->Door[WhatDoor] = D_OPEN;
								Game->PlaySound(SFX_SHUTTER);
							}
							else
							{
								if (WhatSecrets == 1) Screen->TriggerSecrets();
								else if (WhatSecrets == 2)
								{
									Screen->TriggerSecrets();
									Screen->State[ST_SECRET] = true;
								}
							}
						}
					}
				}
			}
		}
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: LWeapon Trigger (end)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Pressure Trigger (start)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
const int PRESS_PLAYER = 1;
const int PRESS_SOMARIA = 2;
const int PRESS_ARMOS = 3;
const int PRESS_PARTNER = 4;
const int PRESS_DONE = 5;
const int UNPRESS_DONE = 6;

ffc script PressureTrigger
{
	void run(int PressureSecrets, int DoorNum, int PressureComboPos, int PressureComboData, int HiddenSwitch, int SetD, int CheckDA, int CheckDB)
	{


// D0 -	If 0, secrets aren't triggered, and D1 doors open as long as this switch is held.
//	If 1, secrets aren't triggered, and D1 doors open until the player leaves the screen. 
//	If 2, triggers temporary secrets, but doesn't open D1 doors. 
//	If 3, triggers permanent secrets, but doesn't open D1 doors (also, permanent secrets don't work in NES Dungeon screens).
//	If 4, changes D2 combo temporarily.
//	If 5, un-hides item (Screen->RoomData) if the screen item has not been obtained, and hides it until pressed.
//	if 6, kills all enemies.
//	If 7, opens D1 doors permanently (uses D5)
// D1 - "One-way" Shutter Door to control
// 	0 == North, 1 == South, 2 == West, 3 == East
// D2 - Combo at this position will be changed, if D0 is set to 4.
// D3 - Combo at position D2 will be changed to this combo ID, if D0 is set to 4.
// D4 - if > 0, combo a this position must be D4 before the switch will appear and function.
// D5 - If D5 > 0, it sets Screen->D[D5] to 1 while held, and 0 while not.
// D6 - If > 0, checks Screen->D[D6] to see if it is 1.
// D7 - If > 0 and D6 > 0, checks Screen->D[D7] to see if it is 1.
// if D5 and D6 > 0, both Screen->Ds must be set to 1 before this switch will trigger anything.
// if D5, D6, and D7 are all > 0, all three Screen->Ds must be set to 1 before this switch will trigger anything.

if (SetD > 0 && PressureSecrets != 7) Screen->D[SetD] = 0;

int Pressed[8];
Pressed[UNPRESS_DONE] = 1;
lweapon SomariaBlock;
lweapon ArmosFriend;
int OrigCombo;
int FFCForTimer;
item HiddenItem;

if (PressureSecrets == 5)
{
	Waitframes(4);
	
	if (Screen->NumItems() > 0) HiddenItem = Screen->LoadItem(1);
	if (HiddenItem->isValid())
	{
		HiddenItem->DrawYOffset = 255;
		HiddenItem->HitYOffset = 255;
		HiddenItem->Z = 0;
	}
	if (Screen->State[ST_ITEM])
	{
		++this->Data;
		Quit();
	}
}
if (PressureSecrets == 3 && Screen->State[ST_SECRET] == true)
{
	++this->Data;
	Quit();
}

if (PressureSecrets == 7 && Screen->D[SetD] != 0)
{
	Screen->Door[DoorNum] = D_OPEN;
	++this->Data;
	Quit();
}

		while(true)
			{
			Waitframe();

			if (NumLWeaponsOf(LW_LEEVER) > 0)
			{
				for (FFCForTimer = Screen->NumLWeapons(); FFCForTimer > 0; --FFCForTimer)
				{
					lweapon NoLeevers = Screen->LoadLWeapon(FFCForTimer);
					if (NoLeevers->isValid())
					{
						if (NoLeevers->ID == LW_LEEVER)
						{
							if (Collision(this,NoLeevers)) Remove(NoLeevers);
						}
					}
				}
			}

			if (HiddenSwitch == 0 || Screen->ComboD[ComboAt(this->X+7,this->Y+8)] == HiddenSwitch)
			{
				if (HiddenSwitch > 0)
				{
					if (this->Flags[FFCF_LENSVIS]) this->Flags[FFCF_LENSVIS] = false;
				}

				if (NumLWeaponsOf(LW_SOMARIA) > 0) SomariaBlock = LoadLWeaponOf(LW_SOMARIA);
				if (NumLWeaponsOf(LW_ARMOS) > 0) ArmosFriend = LoadLWeaponOf(LW_ARMOS);
				

				if (Link->X > this->X-12 && Link->X < this->X+12 && Link->Y > this->Y-12 && Link->Y < this->Y+12 && Link->Z == 0) Pressed[PRESS_PLAYER] = 1;
				else Pressed[PRESS_PLAYER] = 0;

				if (!SomariaBlock->isValid()) Pressed[PRESS_SOMARIA] = 0;
				else if (SomariaBlock->X > this->X-12 && SomariaBlock->X < this->X+12 && SomariaBlock->Y > this->Y-12 && SomariaBlock->Y < this->Y+12) Pressed[PRESS_SOMARIA] = 1;
				else Pressed[PRESS_SOMARIA] = 0;

				if (!ArmosFriend->isValid()) Pressed[PRESS_ARMOS] = 0;
				else if (ArmosFriend->X > this->X-12 && ArmosFriend->X < this->X+12 && ArmosFriend->Y > this->Y-12 && ArmosFriend->Y < this->Y+12) Pressed[PRESS_ARMOS] = 1;
				else Pressed[PRESS_ARMOS] = 0;

				if (!Link->Item[I_PARTNER]) Pressed[PRESS_PARTNER] = 0;
				else 
				{
					if (Partner[FOLLOW_STATE] > 0 && Game->GetCurMap() != Partner[FOLLOW_MAP]) Pressed[PRESS_PARTNER] = 0;
					if (Partner[FOLLOW_STATE] > 0 && Game->GetCurScreen() != Partner[FOLLOW_SCREEN]) Pressed[PRESS_PARTNER] = 0;
					if (Partner[FOLLOW_X] > this->X-12 && Partner[FOLLOW_X] < this->X+12 && Partner[FOLLOW_Y] > this->Y-12 && Partner[FOLLOW_Y] < this->Y+12) Pressed[PRESS_PARTNER] = 1;
					else Pressed[PRESS_PARTNER] = 0;
				}

				if (Pressed[PRESS_DONE] == 0)
				{
					if (Pressed[PRESS_PLAYER] == 1 || Pressed[PRESS_SOMARIA] == 1 || Pressed[PRESS_ARMOS] == 1 || Pressed[PRESS_PARTNER] == 1)
					{
						++this->Data;
						Pressed[PRESS_DONE] = 1;
						Pressed[UNPRESS_DONE] = 0;
						if (SetD > 0)
						{
							Game->PlaySound(SFX_PLACE);
							Screen->D[SetD] = 1;
						}

						if (CheckDA == 0 || Screen->D[SetD] == 1 && Screen->D[CheckDA] == 1 && CheckDB == 0 || Screen->D[SetD] == 1 && Screen->D[CheckDA] == 1 && Screen->D[CheckDB] == 1)
						{
							if (SetD > 0 && Screen->D[SetD] == 1 && Screen->D[CheckDA] == 1) Game->PlaySound(SFX_SECRET);

							if (PressureSecrets < 2 || PressureSecrets == 7)
							{
								Screen->Door[DoorNum] = D_OPEN;
								Game->PlaySound(SFX_SHUTTER);
								if (PressureSecrets == 7)
								{
									Screen->D[SetD] = 1;
									Quit();
								}
								if (PressureSecrets == 1) Quit();
							}
							else if (PressureSecrets == 2)
							{
								Screen->TriggerSecrets();
								Game->PlaySound(SFX_SECRET);
								Quit();
							}
							else if (PressureSecrets == 3)
							{
								if (!Screen->State[ST_SECRET])
								{
									Screen->TriggerSecrets();
									Screen->State[ST_SECRET] = true;
									Game->PlaySound(SFX_SECRET);
									Quit();
								}
							}
							else if (PressureSecrets == 4)
							{
								OrigCombo = Screen->ComboD[PressureComboPos];
								Screen->ComboD[PressureComboPos] = PressureComboData;
								Game->PlaySound(SFX_SHUTTER);
							}
							else if (PressureSecrets == 5)
							{
								if (HiddenItem->isValid())
								{
									if (HiddenItem->DrawYOffset != 0)
									{	
										HiddenItem->DrawYOffset = 0;
										HiddenItem->HitYOffset = 0;
										Game->PlaySound(SFX_SECRET);
										Quit();
									}
								}
							}
							else if (PressureSecrets == 6)
							{
								for (FFCForTimer = Screen->NumNPCs(); FFCForTimer > 0; --FFCForTimer)
								{
									npc KillNPC = Screen->LoadNPC(FFCForTimer);
									if (KillNPC->isValid()) KillNPC->HP = 0;
								}
								Quit();
							}
						}
					}
				}
				if (Pressed[UNPRESS_DONE] == 0)
				{	
					if (Pressed[PRESS_PLAYER] == 0 && Pressed[PRESS_SOMARIA] == 0 && Pressed[PRESS_ARMOS] == 0 && Pressed[PRESS_PARTNER] == 0)
					{
						Pressed[PRESS_DONE] = 0;
						Pressed[UNPRESS_DONE] = 1;
						if (PressureSecrets == 1)
						{
							if (Screen->D[SetD] == 1 && Screen->D[CheckDA] == 1 && CheckDB == 0 || Screen->D[SetD] == 1 && Screen->D[CheckDA] == 1 && Screen->D[CheckDB] == 1)
							Quit();
						}
						--this->Data;
						if (SetD == 0 || Screen->D[SetD] == 1 && Screen->D[CheckDA] == 1 && CheckDB == 0 || Screen->D[SetD] == 1 && Screen->D[CheckDA] == 1 && Screen->D[CheckDB] == 1)
						{
							if (PressureSecrets == 0)
							{
								Game->PlaySound(SFX_SHUTTER);
								Screen->Door[DoorNum] = D_1WAYSHUTTER;
							}
							else if (PressureSecrets == 4)
							{
								Game->PlaySound(SFX_SHUTTER);
								Screen->ComboD[PressureComboPos] = OrigCombo;
							}
						}
						if (SetD > 0)
						{
							Screen->D[SetD] = 0;
							Game->PlaySound(SFX_PLACE);
						}
					}
				}
			}
		}
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Pressure Trigger (end)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Set Enemy HP (start)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
ffc script SetEnemyHP
{
	void run(int SetHP, int SpecificID, int KillBelow)
	{
//D0 - Amount to set the enemy NPC's HP to.
//D1 - Enter a value to specify one NPC ID to affect. Otherwise, it will affect all NPCs onscreen.
//D2 - Kills enemies with HP below D2.
//This script only happens at the beginning of the screen, and won't affect later NPC spawns.

		int FFCForTimer;
		npc EveryNPC;
		Waitframes(4);

		if (KillBelow == 0)
		{
			for(FFCForTimer = Screen->NumNPCs(); FFCForTimer > 0; --FFCForTimer)
			EveryNPC = Screen->LoadNPC(FFCForTimer);
			if (EveryNPC->isValid())
			{
				if (EveryNPC->ID == SpecificID || SpecificID == 0) EveryNPC->HP = SetHP;
			}
		}
		else
		{
			while(true)
			{
				Waitframe();

				for(FFCForTimer = Screen->NumNPCs(); FFCForTimer > 0; --FFCForTimer)
				{
					EveryNPC = Screen->LoadNPC(FFCForTimer);
					if(!EveryNPC->isValid()) continue;
					{
						if (EveryNPC->ID == SpecificID || SpecificID == 0)
						{
							if (EveryNPC->Misc[MISC_HP_REDUCE] == 0) EveryNPC->Misc[MISC_HP_REDUCE] = KillBelow;
							if (EveryNPC->HP < KillBelow && EveryNPC->HP > 0)
							{
								EveryNPC->HP = 0;
							}
						}						
					}
				}			
			}
		}		
	}
}
// Full disclosure: this script was made as a crude fix for the fact that Patra Inner Eyes have a hardcoded HP of 12.
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Set Enemy HP (end)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Absolute kill all enemies (start)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
ffc script AbsoluteKillAllEnemies
{
	void run(int OpenSecrets, int OpenDoor)
	{
// D0 - If 0, opens a NES dungeon door. If 1, sets temporary secrets. If 2, sets permanent secrets. If 3, hides an item until all enemies are gone.
// D1 - If D0 is set to 0, opens the following NES dungeon door:
	// 0 - DOOR_UP
	// 1 - DOOR_DOWN
	// 2 - DOWN_LEFT
	// 3 - DOOR_RIGHT

		this->Flags[FFCF_ETHEREAL] = true;
		Waitframes(4);
		item HiddenItem;
		if (OpenSecrets == 3)
		{
			if (Screen->NumItems() > 0) HiddenItem = Screen->LoadItem(1);
			if (HiddenItem->isValid())
			{
				HiddenItem->DrawYOffset = 255;
				HiddenItem->HitYOffset = 255;
				HiddenItem->Z = 0;
			}
			if (Screen->State[ST_ITEM])
			{
				Quit();
			}
		}

		while(true)
		{
			Waitframe();
			{		
				if (Screen->NumNPCs() == 0 || NumNPCsOf(NPC_FRIENDLYOCTO) == Screen->NumNPCs())
				{
					if (OpenSecrets == 3)
					{
						if (HiddenItem->isValid())
						{
							if (HiddenItem->DrawYOffset != 0)
							{
								HiddenItem->DrawYOffset = 0;
								HiddenItem->HitYOffset = 0;
								Game->PlaySound(SFX_CLEARED);
								Quit();
							}
						}
					}
					else if (OpenSecrets > 0)
					{
						Screen->TriggerSecrets();
						if (OpenSecrets == 2) Screen->State[ST_SECRET] = true;
						Game->PlaySound(SFX_SECRET);
						Quit();
					}
					else
					{
						Screen->Door[OpenDoor] = D_OPEN;
						Game->PlaySound(SFX_SHUTTER);
						Quit();
					}
				}
			}
		}
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Absolute kill all enemies (end)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: NES Dungeon Door Set (start)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
ffc script NESDungeonDoorSet
{
	void run(int UpDoor, int DownDoor, int LeftDoor, int RightDoor, int NoWalk)
	{
// D0 - DOOR_UP
// D1 - DOOR_DOWN
// D2 - DOOR_LEFT
// D3 - DOOR_RIGHT
// D4 - If > 0, Link will not automatically walk in from the edges.

// Set D0 through D3 to the following numbers:
//const int D_OPEN                = 1;
//const int D_LOCKED              = 2;
//const int D_UNLOCKED            = 3; // A locked door that has been opened
//const int D_SHUTTER             = 4; // Defeat enemies to unlock this door
//const int D_BOMB                = 6; // A door that changes when bombed
//const int D_BOMBED              = 7; // A door that has been bombed
//const int D_WALKTHRU            = 8; // Push against the wall to pass through
//const int D_BOSSLOCKED          = 10;
//const int D_BOSSUNLOCKED        = 11; // A boss door that has been opened
//const int D_OPENSHUTTER         = 12; // A shutter that has been opened
//const int D_1WAYSHUTTER         = 14; // A shutter that locks behind you and never opens
// If D0 through D3 are 0, then that side will not have any door setting changes (it won't put D_WALL there).

		int EnterScreen = 32;

		while(true)
		{
			Waitframe();
			{
				if (EnterScreen > 0)
				{
					--EnterScreen;
					NoAction();
					if (Link->Y < 32) Link->InputDown = true;
					else if (Link->Y > 128) Link->InputUp = true;
					else if (Link->X < 32) Link->InputRight = true;
					else if (Link->X > 224) Link->InputLeft = true;
					else EnterScreen = 0;
				}
				else
				{
					if (UpDoor > 0) Screen->Door[DOOR_UP] = UpDoor;
					if (DownDoor > 0) Screen->Door[DOOR_DOWN] = DownDoor;
					if (LeftDoor > 0) Screen->Door[DOOR_LEFT] = LeftDoor;
					if (RightDoor > 0) Screen->Door[DOOR_RIGHT] = RightDoor;
					Game->PlaySound(SFX_SHUTTER);
					Quit();
				}
			}
		}
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: NES Dungeon Door Set (end)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Wall Crush (start)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
const int SCREEN_LEFTWALL = 108;		//The screen used to draw the left wall
const int SCREEN_RIGHTWALL = 107;		//The screen used to draw the right wall
const int MAP_WALLS = 4;			//The map the above two screens are drawn from
const int SCRIPT_WALLCRUSH = 43;		//The slot this script occupies
const int SCRIPT_NEWGANNON = 38;		//Script slot used by the NewGannon FFC script, to check when the screen is frozen.

ffc script WallCrush
{
	void run(int CrushSpeed, int StopWhenNoEnemies, int Sword1Crush, int Sword2Crush, int Sword3Crush)
	{
//D0 - How many frames it takes before the walls enclose by one pixel. If D0 is set, D2-D4 are ignored.
//D1 - if 0, the walls will close no matter what. Otherwise, the walls will stop closing when all enemies are defeated.
//D2 - How many frames it takes before the walls enclose by one pixel if Link's strongest Sword or Cane of Somaria is level 1 or less, if D0 is 0. (uses specific item ID constants)
//D3 - How many frames it takes before the walls enclose by one pixel if Link's strongest Sword or Cane of Somaria is level 2 or less, if D0 is 0. (uses specific item ID constants)
//D4 - How many frames it takes before the walls enclose by one pixel if Link's strongest Sword or Cane of Somaria is level 3 or less, if D0 is 0. (uses specific item ID constants)

		this->Flags[FFCF_ETHEREAL] = true;
		int ClosingIn = 32;
		int WaitToClose = CrushSpeed;
		ffc ScreenFreezer;
		for(int ForTimer = 32; ForTimer > 0; --ForTimer)
		{
			ScreenFreezer = Screen->LoadFFC(ForTimer);
			if (ScreenFreezer->Script == SCRIPT_NEWGANNON) break;
		}

		while(true)
		{
			Waitframe();
			{	

				this->X = ClosingIn;

				// Draw walls under normal circumstances
				if (Game->Counter[CR_WEATHER] == 0 || Game->Counter[CR_WEATHER] > ENV_BLOCKY && Game->Counter[CR_WEATHER] < ENV_WAVY1)
				{
					Screen->Rectangle(
						3,		//layer
						-256+ClosingIn,	//start X
						0,		//start y
						ClosingIn-1,	//end x
						176,		//end y
						0,1,0,0,0,true,128);	
					Screen->Rectangle(
						3,		//layer
						256-ClosingIn,	//start X
						0,		//start y
						256,		//end x
						176,		//end y
						0,1,0,0,0,true,128);	
					
					Screen->DrawScreen(2,MAP_WALLS,SCREEN_LEFTWALL,-256+ClosingIn,0,0);
					Screen->DrawScreen(2,MAP_WALLS,SCREEN_RIGHTWALL,256-ClosingIn,0,0);
					// Extra draw because layer 3 disappear when opening the subscreen
					Screen->DrawScreen(3,MAP_WALLS,SCREEN_LEFTWALL,-256+ClosingIn,0,0);
					Screen->DrawScreen(3,MAP_WALLS,SCREEN_RIGHTWALL,256-ClosingIn,0,0);
				}
	
				if (WaitToClose > 0) 
				{
					-- WaitToClose;
					//if ((Link->Item[I_CANE2] || Link->Item[I_SWORD2]) || (Link->Item[I_CANE3] || Link->Item[I_SWORD3])) -- WaitToClose;
					//if (Link->Item[I_CANE3] || Link->Item[I_SWORD3]) -- WaitToClose;
					//150
					//75
					//37.5					
				}
				else
				{
					if (Link->Action != LA_HOLD1LAND && Link->Action != LA_HOLD2LAND)
					{
						if (ScreenFreezer->Data != COMBO_SCREENFREEZE1)
						{
							if (StopWhenNoEnemies == 0 || Screen->NumNPCs() > 0)
							{
								if (ClosingIn < 128) ++ ClosingIn;
								if (CrushSpeed > 0) WaitToClose = CrushSpeed;
								else if (Link->Item[I_SWORD3] || Link->Item[I_CANE3]) WaitToClose = Sword3Crush;
								else if (Link->Item[I_SWORD2] || Link->Item[I_CANE2]) WaitToClose = Sword2Crush;
								else WaitToClose = Sword1Crush;
							}
						}
					}
				}
				if (ClosingIn == 128)
				{
					Game->PlaySound(SFX_OUCH);
					Link->Action = LA_GOTHURTLAND;
					-- Link->HP;
					NoAction();
					Link->Y = 64;
					Screen->DrawScreen(3,MAP_WALLS,SCREEN_LEFTWALL,-256+ClosingIn,0,0);
					Screen->DrawScreen(3,MAP_WALLS,SCREEN_RIGHTWALL,256-ClosingIn,0,0);
				}

				// Left wall "Solidity"
				if (Link->X < ClosingIn)
				{
					if (Link->PressUp) Link->Dir = DIR_UP;
					else if (Link->PressDown) Link->Dir = DIR_DOWN;
					// The direction setting is to make it cooperate nicer with FourWayCurse()
					Link->X = Link->X + 2;

					// This section prevents pegasus boots from clipping into wall
					if (Link->X < ClosingIn - 3)
					{
						Link->PressRight = true;
						PegasusBonk();
					}
				}

				// Right wall "Solidity"
				if (Link->X > (240-ClosingIn)) 
				{
					if (Link->PressUp) Link->Dir = DIR_UP;
					else if (Link->PressDown) Link->Dir = DIR_DOWN;
					// The direction setting is to make it cooperate nicer with FourWayCurse()
					Link->X = Link->X - 2;

					// This section prevents pegasus boots from clipping into wall
					if (Link->X > (244-ClosingIn))
					{
						Link->PressLeft = true;
						PegasusBonk();
					}
				}
			}
		}
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Wall Crush (end)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Enter from sides (start)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
ffc script EnterFromSides
{
	void run(int HowFar, int MoveLink)
	{
//D0 - If 0, Link will walk in for approximately 32 pixels. Otherwise, Link will walk in by approximately D0 pixels. "Approximately" because, unless D1 is set to 2, Link's controls are pressed so that he walks, and he doesn't walk at a completely even rate.
//D1 - If 0, Link will try to walk normally. If 1, Link will also be manually moved D0 pixels by the script. If 2 or higher, Link will only be moved manually by the script, and not walk.

		int EnterScreen = 32;
		if (HowFar > 0) EnterScreen = HowFar;
		int StopTrying = EnterScreen;

		while(true)
		{
			Waitframe();
			{	
				if (StopTrying > 0) --StopTrying;
				else Quit();

				if (Link->Y > EnterScreen && Link->Y < (160 - EnterScreen) && Link->X > EnterScreen && Link->X < (240 - EnterScreen)) Quit();
				else 
				{
					NoAction();
					if (MoveLink > 0)
					{
						if (Link->Y < EnterScreen) ++Link->Y;
						else if (Link->Y > (176 - EnterScreen)) --Link->Y;
						else if (Link->X < EnterScreen) ++Link->X;
						else if (Link->X > (256 - EnterScreen)) --Link->X;
					}
					if (MoveLink < 2)
					{
						if (Link->Y < EnterScreen) Link->InputDown = true;
						else if (Link->Y > (160 - EnterScreen)) Link->InputUp = true;
						if (Link->X < EnterScreen) Link->InputRight = true;
						else if (Link->X > (240 - EnterScreen)) Link->InputLeft = true;
					}									
				}
			}
		}
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Enter from sides (end)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: NES Dungeon Holes (start)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
ffc script NESDungeonHoles
{
	void run()
	{
		while(true)
		{
			Waitframe();
			{		
				if (Link->Y <= 32)
				{
					if (Link->X < 112 || Link->X > 128)
					{
						if (Link->InputUp)
							//if (CanWalk(Link->X,Link->Y,DIR_UP,1,false) || Link->Y == 0) --Link->Y;
							if (Screen->ComboS[ComboAt(Link->X+7,Link->Y-1)] == 0000b) --Link->Y;
						if (Link->InputDown)
						{
							//if (Link->InputDown && CanWalk(Link->X,Link->Y,DIR_DOWN,1,false)) ++Link->Y;
							if (Screen->ComboS[ComboAt(Link->X+7,Link->Y+17)] == 0000b) ++Link->Y;
						}
					}
				}
			}
		}
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: NES Dungeon Holes (end)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: BlueMeat (start)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
ffc script BlueMeat
{
	void run()
	{
		this->Flags[FFCF_ETHEREAL] = true;
		lweapon BlueMeat = CreateLWeaponAt(LW_BAIT,this->X,this->Y);
		BlueMeat->CSet = 7;
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: BlueMeat (end)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: CollisionComboChange (start)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
ffc script CollisionComboChange
{
	void run(int ChangeTo, int NoNPCsClears, int ExceptForNPC)
	{
//D0 - Combo to change combo(s) beneath to.
//D1 - If != 0, having no NPCs onscreen will change these combos into Screen->UnderCombo.
//D2 - If 0, has no effect. If > 0, enemies of D2 type will not be counter for the purposes of activating D1.

//If the FFC's width and ehight are 2, it will change a 2x2 block. Otherwise it will change a 1x1.

		int ChangeFrom = Screen->ComboD[ComboAt(this->X+7,this->Y+8)];
		this->Flags[FFCF_ETHEREAL] = true;
		if (NoNPCsClears != 0) Waitframes(4);

		while(true)
		{
			Waitframe();
			{
				if (LinkCollision(this))
				{
					Screen->ComboD[ComboAt(this->X+7,this->Y+8)] = ChangeTo;
					if (this->TileWidth == 2 && this->TileHeight == 2)
					{
						Screen->ComboD[ComboAt(this->X+23,this->Y+8)] = ChangeTo;
						Screen->ComboD[ComboAt(this->X+7,this->Y+24)] = ChangeTo;
						Screen->ComboD[ComboAt(this->X+23,this->Y+24)] = ChangeTo;
					}
				}	
				else if (Screen->ComboD[ComboAt(this->X+7,this->Y+8)] == ChangeTo)
				{
					Screen->ComboD[ComboAt(this->X+7,this->Y+8)] = ChangeFrom;
					if (this->TileWidth == 2 && this->TileHeight == 2)
					{
						Screen->ComboD[ComboAt(this->X+23,this->Y+8)] = ChangeFrom;
						Screen->ComboD[ComboAt(this->X+7,this->Y+24)] = ChangeFrom;
						Screen->ComboD[ComboAt(this->X+23,this->Y+24)] = ChangeFrom;
					}
				}
				if (NoNPCsClears != 0)
				{
					if (Screen->NumNPCs() == 0 || ExceptForNPC > 0 && Screen->NumNPCs()-NumNPCsOf(ExceptForNPC) == 0)
					{
						Screen->ComboD[ComboAt(this->X+7,this->Y+8)] = Screen->UnderCombo;
						if (this->TileWidth == 2 && this->TileHeight == 2)
						{
							Screen->ComboD[ComboAt(this->X+23,this->Y+8)] = Screen->UnderCombo;
							Screen->ComboD[ComboAt(this->X+7,this->Y+24)] = Screen->UnderCombo;
							Screen->ComboD[ComboAt(this->X+23,this->Y+24)] = Screen->UnderCombo;
						}
						Game->PlaySound(SFX_SECRET);
						Quit();
					}
				}	
			}
		}
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: CollisionChangeCombo (end)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Faux Passageway (start)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
ffc script FauxPassageway
{
	void run(int ChangeWarp, int DontWalk)
	{

//D0 - If > 0, exiting to the north on the right side of the room will instead use the Sidewarp (D0) destination, and exiting on the left will use the original Sidewarp Up destination.
	//SIDEWARP_A		= 0;
	//SIDEWARP_B		= 1;
	//SIDEWARP_C		= 2;
	//SIDEWARP_D		= 3;
//D1 - If > 0, Link won't be forced to walk down upon entry of this screen.

		this->Flags[FFCF_ETHEREAL] = true;


		int WalkDown = 24;
		int UpDMap = Screen->GetSideWarpDMap(0);
		int UpScreen = Screen->GetSideWarpScreen(0);
		int FFCMusicBuffer[256];
		bool LeftRight;
		if (DontWalk > 0) WalkDown = 0;

		while(true)
		{
			Waitframe();
			{		
				if (WalkDown > 0)
				{
					if (Link->Y > 32) WalkDown = 0;
					else
					{
						Link->InputDown = true;
						--WalkDown;
					}
				}
				if (ChangeWarp > 0)
				{
					if (LeftRight)
					{
						if (Link->X < 120)
						{
							LeftRight = false;
							Screen->SetSideWarp(SIDEWARP_A,UpScreen,UpDMap,-1);
						}
					}
					else
					{
						if (Link->X > 119)
						{
							LeftRight = true;
							Screen->SetSideWarp(SIDEWARP_A,Screen->GetSideWarpScreen(ChangeWarp),Screen->GetSideWarpDMap(ChangeWarp),-1);
						}
					}
				}
			}
		}
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Faux Passageway (End)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Intro Screen Story & Credits (Start)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Intro Screen
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
ffc script IntroScreen
{
	void run(int WhatTile, int CreditsMap, int CreditsScreen, int WhatPaper)
	{
// D0 - Starting tile of 14 x 13 tile block frame to draw around / behind text.
// D1 - Map from, which to Drawscreen a background for the credits
// D2 - Screen from, which to Drawscreen a background for the credits
// D3 - 3x4 section of tiles to draw at the end, for Link holding up the "please look up the manual for details" paper


		int Intro001[32] = "  THE LEGEND OF ZELDA   ";
		int Intro002[32] = "NOT LONG AGO HERO  LINK ";
		int Intro003[32] = "SAVED PRINCESS ZELDA AND";
		int Intro004[32] = "TRIFORCE WITH WISDOM AND";
		int Intro005[32] = "POWER FROM EVIL GANNON .";
		int Intro006[32] = "BUT THEN MIRROR  GANNON ";
		int Intro007[32] = "APPEARED AND DIVIDED THE";
		int Intro008[32] = "TRIFORCE WITH POWER INTO";
		int Intro009[32] = "  8  BIG UNITS, AND HERO";
		int Intro010[32] = " LINK  WAS CAPTURED.    ";

		int Intro011[32] = "  GO FIND THE   8  UNITS";
		int Intro012[32] = "    ZELDA  TO SAVE HIM. ";

 		int Altro002[32] = "                   LINK ";
		int Altro003[32] = "               ZELDA    ";
		int Altro004[32] = "TRIFORCE                ";
		int Altro005[32] = "                GANNON  ";
		int Altro006[32] = "                 GANNON ";
		//int Altro007[32] = "                        ";
		int Altro008[32] = "TRIFORCE                ";
		int Altro009[32] = "  8                     ";
		int Altro010[32] = " LINK                   ";
		int Altro011[32] = "                8       ";
		int Altro012[32] = "    ZELDA               ";
	
		int IntroGap[32] = "                        ";


		int IntroStrings[256] = {
						IntroGap,
						Intro002,
						Intro003,
						Intro004,
						Intro005,
						Intro006,
						Intro007,
						Intro008,
						Intro009, 
						Intro010
					};

		int RedStrings[256] = 	{
						IntroGap, 
						IntroGap, 
						Altro003, 
						IntroGap, 
						Altro005, 
						Altro006, 
						IntroGap, 
						IntroGap, 
						IntroGap, 
						IntroGap, 
						Intro011, 
						Intro012
					};
		int BlueStrings[256] = 	{
						IntroGap, 
						IntroGap, 
						IntroGap, 
						Altro004, 
						IntroGap, 
						IntroGap, 
						IntroGap, 
						Altro008, 
						Altro009
					};
		int GreenStrings[256] = {
						IntroGap, 
						Altro002, 
						IntroGap, 
						IntroGap, 
						IntroGap, 
						IntroGap, 
						IntroGap, 
						IntroGap, 
						IntroGap, 
						Altro010
					};

		int CreditsCredits[32] = 		" STAFF ";

		int CreditsCreator[32] = 		"QUEST CREATOR...........";
		int CreditsCreatorMitsukara[32] = 	"MITSUKARA";

		int CreditsLastboss[32] = 		"REDESIGN,ENDBOSS REWRITE"; 
		int CreditsLasterboss[32] = 		"SCROLLING MODES, & RANDO";
		int CreditsLastbossDimi[32] = 		"DIMI";

		int CreditsTesters[32] = 		"TESTERS.................";
		int CreditsTesterDimi[32] = 		"DIMI";
		int CreditsTesterMoosh[32] =		"MOOSH";
		int CreditsTesterRuss[32] = 		"RUSS";
		int CreditsTesterGreatGlass[32] = 	"GREAT GLASS";
		int CreditsTesterHeroOfFire[32] = 	"HEROOFFIRE";
		int CreditsTesterZaxarone[32] = 	"ZAXARONE";
		int CreditsTesterShane[32] = 		"SHANE";
		int CreditsTesterAvaro[32] = 		"AVARO";
		int CreditsTesterAnthus[32] = 		"ANTHUS";
		int CreditsTesterywkls[32] = 		"YWKLS";
		//int CreditsTesterX[32] = 		"AND YOU AS MEGA MAN X";

		int CreditsFWC[32] = 			"4-WAY WALK SCRIPT.......";
		int CreditsFWCMoosh[32] = 		"MOOSH";
		int CreditsMagic[32] = 			"MAGIC MAP/COMPASS.......";
		int CreditsMagicZoria[32] = 		"ZORIARPG";
		int CreditsAllcaps[32] = 		"ALL-CAPS FUNCTION.......";
		int CreditsAllcapsRob[32] = 		"VENROB";
		int CreditsFFCShoot[32] = 		"FFC SHOOTER SCRIPT......";
		int CreditsFFCLTM[32] = 		"LINKTHEMASTER";

		int CreditsZeldagfx[32] = 		"ZELDA SPRITES...........";
		int CreditsZeldagfxExplod[32] =		"EXPLODING RABBIT";
		int CreditsDarknaga[32] = 		"DARKNAGA SPRITES........";
		int CreditsDarknagaPTux[32] = 		"P-TUX";

		int CreditsMusic[32] =			"MUSIC...................";
		int CreditsMusicInfidelity[32] = 	"INFIDELITY";
		int CreditsMusicIsabelle[32] = 		"ISABELLECHIMING";
		int CreditsMusicKlopp[32] = 		"KLOPP422 & BROTHER";
		int CreditsMusicBigjoe[32] = 		"BIGJOE";
		int CreditsMusicAndTheRest[32]= 	"...AND MANY MORE.";

		// Credits0111 through Credits 0132 are unused due to long-windedness. If I could find a way to show these on the music file selector that'd be great, but given how the music files are selected by loading from whatever file a dmap is set to use, I'm not sure how that would work. Maybe some convoluted thing with loading the dmap name into a string?
		//int Credits0111[32] = "KOJI KONDO";
		//int Credits0112[32] = "AKITO NAKATSUKA";
		//int Credits0113[32] = "MIEKO ISHIKAWA";
		//int Credits0114[32] = "YUZO KOSHIRO";
		//int Credits0115[32] = "HIDEYA NAGATA";
		//int Credits0116[32] = "OSAMU KASAI";
		//int Credits0117[32] = "MASAAKI HARADA";
		//int Credits0118[32] = "SHINJI NAKAYAMA";
		//int Credits0119[32] = "HIDENO MAEZAWA";
		//int Credits0120[32] = "SHINYA SAKAMOTO";
		//int Credits0121[32] = "ATSUSHI FUJIO";
		//int Credits0122[32] = "KIYOHIRIO SADA";
		//int Credits0123[32] = "KINUYA YAMASHITA";
		//int Credits0124[32] = "HIDEKI KANAZASHI";
		//int Credits0125[32] = "MICHIHARU HASUYA";
		//int Credits0126[32] = "HIRO TANAKA";
		//int Credits0127[32] = "PHD RTC";
		//int Credits0128[32] = "KOICHI SUGIYAMA";
		//int Credits0129[32] = "SATOE TERASHIMA";
		//int Credits0130[32] = "KUNYO YAMASHITA";
		//int Credits0131[32] = "KENICHI MATSUBARA";
		//int Credits0132[32] = "KOUJI MURATA";

		int CreditsDev[32] = 		"ZC DEVELOPERS...........";
		int CreditsDevPM[32] = 		"PHANTOM MENACE";
		int CreditsDevWL[32] = 		"WAR LORD";
		int CreditsDevDN[32] = 		"DARKNATION";
		int CreditsDevDD[32] = 		"DARKDRAGON";
		int CreditsDevGleeok[32] = 	"GLEEOK";
		int CreditsDevGrayswandir[32] =	"GRAYSWANDIR";
		int CreditsDevJMan[32] = 	"JMAN2050";
		int CreditsDevJoe[32] = 	"JOE123";
		int CreditsDevKoopa[32] = 	"KOOPA";
		int CreditsDevL[32] = 		"_L_";
		int CreditsDevPKMNfrk[32] = 	"PKMNFRK";
		int CreditsDevSaffith[32] = 	"SAFFITH";
		int CreditsDevSean[32] = 	"SEAN";
		int CreditsDevTakuya[32] = 	"TAKUYA";
		int CreditsDevWolfman2000[32] =	"WOLFMAN2000";
		int CreditsDevRob[32] = 	"VENROB";
		int CreditsDevZoria[32] = 	"ZORIARPG";

		int CreditsThanks[32] = 	"SPECIAL THANKS..........";
		int CreditsThanksMelee[32] = 	"MELEEWIZARD";
		int CreditsThanksRuss[32] = 	"DIMI, MOOSH, & RUSS";
		int CreditsThanksHOF[32] = 	"HEROOFFIRE";
		int CreditsThanksAevin[32] = 	"AEVIN";

		int CreditsStrings[256] ={
						IntroGap,

						CreditsCreator,
						CreditsCreatorMitsukara,

						IntroGap,

						CreditsLastboss,
						CreditsLasterboss,
						CreditsLastbossDimi,

						IntroGap,

						CreditsTesters,
						CreditsTesterDimi,
						CreditsTesterMoosh,
						CreditsTesterRuss,
						CreditsTesterGreatGlass,
						CreditsTesterHeroOfFire,
						CreditsTesterZaxarone,
						CreditsTesterShane,
						CreditsTesterAvaro,
						CreditsTesterAnthus,
						CreditsTesterywkls,

						IntroGap,

						CreditsFWC,
						CreditsFWCMoosh,

						IntroGap,

						CreditsMagic,
						CreditsMagicZoria,

						IntroGap,

						CreditsAllcaps,
						CreditsAllcapsRob,

						IntroGap,

						CreditsFFCShoot,
						CreditsFFCLTM,

						IntroGap,

						CreditsZeldagfx,
						CreditsZeldagfxExplod,

						IntroGap,

						CreditsDarknaga,
						CreditsDarknagaPTux,

						IntroGap,

						CreditsMusic,
						CreditsMusicInfidelity,
						CreditsMusicIsabelle,
						CreditsMusicKlopp,
						CreditsMusicBigjoe,
						CreditsMusicAndTheRest,

						IntroGap,

						CreditsDev,
						CreditsDevPM,
						CreditsDevWL,
						CreditsDevDN,
						CreditsDevDD,
						CreditsDevGleeok,
						CreditsDevGrayswandir,
						CreditsDevJMan,
						CreditsDevJoe,
						CreditsDevKoopa,
						CreditsDevL,
						CreditsDevPKMNfrk,
						CreditsDevSaffith,
						CreditsDevSean,
						CreditsDevTakuya,
						CreditsDevWolfman2000,
						CreditsDevRob,
						CreditsDevZoria,

						IntroGap,

						CreditsThanks,
						CreditsThanksMelee,
						CreditsThanksHOF,
						CreditsThanksRuss,
						CreditsThanksAevin
					};

		int CreditsRoles[256] ={
						IntroGap,		//0

						CreditsCreator,			//1 Blue
						IntroGap,		//2

						IntroGap,		//3

						CreditsLastboss,		//4 Green
						CreditsLasterboss,		//5 Green
						IntroGap,		//6

						IntroGap,		//7

						CreditsTesters,			//8 Red
						IntroGap,		//9
						IntroGap,		//10
						IntroGap,		//11
						IntroGap,		//12
						IntroGap,		//13
						IntroGap,		//14
						IntroGap,		//15
						IntroGap,		//16
						IntroGap,		//17
						IntroGap,		//18

						IntroGap,		//19

						CreditsFWC,			//20 Blue
						IntroGap,		//21

						IntroGap,		//22

						CreditsMagic,			//23 Green
						IntroGap,		//24

						IntroGap,		//25

						CreditsAllcaps,			//26 Red
						IntroGap,		//27

						IntroGap,		//28

						CreditsFFCShoot,		//29 Blue
						IntroGap,		//30

						IntroGap,		//31

						CreditsZeldagfx,		//32 Green
						IntroGap,		//33

						IntroGap,		//34

						CreditsDarknaga,		//35 Red
						IntroGap,		//36

						IntroGap,		//37

						CreditsMusic,			//38 Blue
						IntroGap,		//39
						IntroGap,		//40
						IntroGap,		//41
						IntroGap,		//42
						IntroGap,		//43

						IntroGap,		//44

						CreditsDev,			//45 Green
						IntroGap,		//46
						IntroGap,		//47
						IntroGap,		//48
						IntroGap,		//49
						IntroGap,		//50
						IntroGap,		//51
						IntroGap,		//52
						IntroGap,		//53
						IntroGap,		//54
						IntroGap,		//55
						IntroGap,		//56
						IntroGap,		//57
						IntroGap,		//58
						IntroGap,		//59
						IntroGap,		//60
						IntroGap,		//61
						IntroGap,		//62

						IntroGap,		//63

						CreditsThanks,			//64 Red
						IntroGap,		//65
						IntroGap,		//66
						IntroGap,		//67
						IntroGap		//68
					};

		int ScrollY = 176;

		Waitframe();
		DoDraw = false;
		int ScrollTimer;
		Game->PlayEnhancedMusic(1,0);
		int LegendOfLinkmusic[32] = "LegendOfLink.nsf";
		bool PlayingIntroMusic;
		
		RememberStuff[REMEMBER_TRACEHINTS] = 0;

		while(true)
		{
			Waitframe();

			// Black layer over screen:
			Screen->Rectangle(
				7,		//layer
				0,		//start X
				0,		//start y
				256,		//end x
				176,		//end y
				0,1,0,0,0,true,128);

			// Frame around intro story:
			Screen->DrawTile(
				7,
				16,			//start X
				(ScrollY-8),		//start y
				WhatTile,		//tile ID
				14,			//tile width
				13,			//tile width
				2,			//tile cset
				-1,-1,-1,-1,0,0,1,128);

			// Bricks frame around credits (brick screens):
			Screen->DrawScreen(7,CreditsMap,CreditsScreen, 0, ScrollY+220,0);
			Screen->DrawScreen(7,CreditsMap,CreditsScreen, 0, ScrollY+396,0);
			Screen->DrawScreen(7,CreditsMap,CreditsScreen, 0, ScrollY+572,0);
			Screen->DrawScreen(7,CreditsMap,CreditsScreen, 0, ScrollY+628,0);

			// Black rectangle over brick screens to make them into a frame:
			Screen->Rectangle(
				7,		//layer
				24,		//start X
				ScrollY+228,	//start y
				231,		//end x
				ScrollY+795,	//end y
				0,1,0,0,0,true,128);

			// "Credits" header
			Screen->DrawString(
				7,
				128,
				ScrollY+220, 
				FONT_Z1, 
				1, 
				0, 
				TF_CENTERED, 
				CreditsCredits, 
				OP_OPAQUE);


			// Draw various strongs of the intro and credits:
			for (int q = 255; q > 0; --q)
			{
				if (IntroStrings[q])
				{
					Screen->DrawString(
						7,
						32,
						(ScrollY)+(q*16), 
						FONT_Z1, 
						1, 
						-1, 
						TF_NORMAL, 
						IntroStrings[q], 
						OP_OPAQUE);
				}
				if (RedStrings[q])
				{
					Screen->DrawString(
						7,
						32,
						(ScrollY)+(q*16), 
						FONT_Z1, 
						41, 
						-1, 
						TF_NORMAL, 
						RedStrings[q], 
						OP_OPAQUE);
				}
				if (BlueStrings[q])
				{
					Screen->DrawString(
						7,
						32,
						(ScrollY)+(q*16), 
						FONT_Z1, 
						37, 
						-1, 
						TF_NORMAL, 
						BlueStrings[q], 
						OP_OPAQUE);
				}
				if (GreenStrings[q])
				{
					Screen->DrawString(
						7,
						32,
						(ScrollY)+(q*16), 
						FONT_Z1, 
						45, 
						-1, 
						TF_NORMAL, 
						GreenStrings[q], 
						OP_OPAQUE);
				}
				if (CreditsStrings[q])
				{
					Screen->DrawString(
						7,
						224,
						(ScrollY)+232+(q*8), 
						FONT_Z1, 
						1, 
						-1, 
						TF_RIGHT, 
						CreditsStrings[q], 
						OP_OPAQUE);
				}
				if (CreditsRoles[q])
				{
					//Red roles:
					Screen->DrawString(
						7,
						32,
						(ScrollY)+232+(q*8), 
						FONT_Z1, 
						148, 
						-1, 
						TF_NORMAL, 
						CreditsRoles[q], 
						OP_OPAQUE);

					// Blue roles:
					if (q == 1 || q == 20 || q == 29 || q == 38) Screen->DrawString(
						7,
						32,
						(ScrollY)+232+(q*8), 
						FONT_Z1, 
						149, 
						-1, 
						TF_NORMAL, 
						CreditsRoles[q], 
						OP_OPAQUE);

					// Green roles:
					if (q == 4 || q == 5 || q == 23 || q == 32 || q == 45) Screen->DrawString(
						7,
						32,
						(ScrollY)+232+(q*8), 
						FONT_Z1, 
						150, 
						-1, 
						TF_NORMAL, 
						CreditsRoles[q], 
						OP_OPAQUE);
				}
			}
			// Zelda holding up the paper at the end:
			Screen->DrawTile(
				7,
				104,			//start X
				ScrollY+884,		//start y
				WhatPaper,		//tile ID
				3,			//tile width
				4,			//tile width
				3,			//tile cset
				-1,-1,-1,-1,0,0,1,128);

			if (Link->InputUp || Link->InputStart)
			{
				if (ScrollY < 168) --ScrollY;
			}
			if (Link->InputDown)
			{
				if (ScrollY < 0) ++ScrollY;
			}

			if (!PlayingIntroMusic)
			{
				if (ScrollY > 164)
				{
					Game->PlayEnhancedMusic(LegendOfLinkmusic,3);
					PlayingIntroMusic = true;
				}
			} 

			if (ScrollY > -40)
			{
				if (ScrollTimer == 0)
				{
					--ScrollY;
					ScrollTimer = 1;
				}
				else --ScrollTimer;
				if (Link->PressStart) ScrollY = -40;
			}
			else if (ScrollY == -40)
			{
				if (ScrollTimer == 0) ScrollTimer = 400;
				else --ScrollTimer;
				if (Link->PressStart) 
				{
					if (Link->InputEx2 && Link->InputR)
					{
						int scr[] = "RandoMenu";
						int sid = Game->GetFFCScript(scr);
						ffc f;
						for ( int q = 1; q <= 32; ++q )
						{
							f = Screen->LoadFFC(q);
							if ( f->Script ) continue;
							if ( f->Data ) continue;
							if ( q )
							{
								f->Data = 1;
								f->Script = Game->GetFFCScript(scr);
								break;
							}
						}
						NoAction();
						Link->PressStart = false;
						Link->InputStart = false;
						this->Data = 0;
						this->Script = 0;
						Quit();
					}
					else --ScrollY;
				}
				else if (ScrollTimer == 1) --ScrollY;
			}
			else if (ScrollY < -40)
			{
				if (Link->PressStart && ScrollY < -48 || Link->InputStart && ScrollY < -48)
				{
					if (Link->InputEx2 && Link->InputR)
					{
						int scr[] = "RandoMenu";
						int sid = Game->GetFFCScript(scr);
						ffc f;
						for ( int q = 1; q <= 32; ++q )
						{
							f = Screen->LoadFFC(q);
							if ( f->Script ) continue;
							if ( f->Data ) continue;
							if ( q )
							{
								f->Data = 1;
								f->Script = Game->GetFFCScript(scr);
								break;
							}
						}
						NoAction();
						Link->PressStart = false;
						Link->InputStart = false;
						this->Data = 0;
						this->Script = 0;
						Quit();
					}
					else
					{
						DoDraw = true;
						Link->Y = -16;
					}					
				}
				if (ScrollY > -862)
				{
					if (ScrollTimer == 0)
					{
						--ScrollY;
						ScrollTimer = 2;
					}
					else --ScrollTimer;
				}
				else
				{
					if (ScrollTimer == 0) ScrollTimer = 47;
					else --ScrollTimer;
					if (ScrollTimer == 3)
					{
						DoDraw = true;
						Link->Y = -16;	
					}
				}	
			}

			NoAction();
			Link->PressStart = false;
			Link->InputStart = false;

			// Debug display:
			//Screen->DrawInteger(
			//	7,					//int layer, 
			//	0,					//int x, 
			//	06,					//int y, 
			//	FONT_Z1,				//int font, 
			//	1,					//int color, 
			//	-1,					//int background_color, 
			//	-1,					//int width, 
			//	-1,					//int height, 
			//	ScrollY,			//int number, 
			//	0, 					//int number_decimal_places, 
			//	128);					 //int opacity

		}
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Title Screen / Menu Screen (End)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Intro Screen Story & Credits (End)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Set visited screen state (start)
// By Mitsukara
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// As of Beta 31 of ZC 2.53.1 and presumably earlier versions, screens don't set ST_VISITED to true unless they have the dmap flag checked to view the map by pressing the map button.
// That's why this script exists.

ffc script SetVisitedState
{
	void run(int MustCollide)
	{
		if (MustCollide == 1)
		{
			while(true)
			{
				Waitframe();
				if (LinkCollision(this))
				{
					Screen->State[ST_VISITED] = true;
					Quit();
				}
			}
		}
		else Screen->State[ST_VISITED] = true;
	
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Set visited screen state (End)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Continue from Saved Place (start)
// By Mitsukara
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
const int CONTINUESCREEN_LEVEL1DMAP = 3;
const int CONTINUESCREEN_LEVEL2DMAP = 4;
const int CONTINUESCREEN_LEVEL3DMAP = 5;
const int CONTINUESCREEN_LEVEL4DMAP = 6;
const int CONTINUESCREEN_LEVEL5DMAP = 7;
const int CONTINUESCREEN_LEVEL6DMAP = 8;
const int CONTINUESCREEN_LEVEL7DMAP = 9;
const int CONTINUESCREEN_LEVEL8DMAP = 10;
const int CONTINUESCREEN_LEVEL9DMAP = 11;
const int CONTINUESCREEN_LEVEL1MAP = 2;
const int CONTINUESCREEN_LEVEL2MAP = 2;
const int CONTINUESCREEN_LEVEL3MAP = 2;
const int CONTINUESCREEN_LEVEL4MAP = 2;
const int CONTINUESCREEN_LEVEL5MAP = 2;
const int CONTINUESCREEN_LEVEL6MAP = 2;
const int CONTINUESCREEN_LEVEL7MAP = 3;
const int CONTINUESCREEN_LEVEL8MAP = 3;
const int CONTINUESCREEN_LEVEL9MAP = 3;
const int CONTINUESCREEN_CHECK1 = 12;
const int CONTINUESCREEN_CHECK2 = 114;
const int CONTINUESCREEN_CHECK3 = 3;
const int CONTINUESCREEN_CHECK4 = 29;
const int CONTINUESCREEN_CHECK5 = 8;
const int CONTINUESCREEN_CHECK6 = 67;
const int CONTINUESCREEN_CHECK7 = 77;
const int CONTINUESCREEN_CHECK8 = 40;
const int CONTINUESCREEN_CHECK9 = 87;
const int CONTINUESCREEN_LEVEL1 = 5;
const int CONTINUESCREEN_LEVEL2 = 117;
const int CONTINUESCREEN_LEVEL3 = 3;
const int CONTINUESCREEN_LEVEL4 = 20;
const int CONTINUESCREEN_LEVEL5 = 3;
const int CONTINUESCREEN_LEVEL6 = 67;
const int CONTINUESCREEN_LEVEL7 = 69;
const int CONTINUESCREEN_LEVEL8 = 35;
const int CONTINUESCREEN_LEVEL9 = 88;

ffc script ContinueScreen
{
	void run(int SelectorTile, int SelectorCSet)
	{
		if (LinkCollision(this))
		{
			// --- Startup trace hints
			++ RememberStuff[REMEMBER_TRACEHINTS];
			if (RememberStuff[REMEMBER_TRACEHINTS] > 11) RememberStuff[REMEMBER_TRACEHINTS] = 1;

			if (RememberStuff[REMEMBER_TRACEHINTS] == 1)
			{
				if (Link->Item[I_STRONGBEETLE])
				{
					int Hint[3000] = "\n\n This is Impa indeed. I've heard\n that a strong Keese, or strong Beetle,\n can not only move things far away, but\n can also lift something that might've\n been too cumbersome before. I wonder\n what it could be?\n\n";
					printf(Hint);
				}
				else if (Link->Item[I_BEETLE])
				{
					int Hint[3000] = "\n\n It is I, Impa. I've heard the Keese\n (or the 'Beetle' in something called...\n 'Confusing Item Graphics mode'?) can\n move many of your other items, and all\n sorts of monster's weapon shots, too.\n Try it on many things!\n\n";
					printf(Hint);
				}
				else
				{
					int Hint[3000] = "\n\n It is I, Impa. I can speak to you\n telepathically thorugh this\n mysterious 'Console' tile, to help\n guide your journey.\n\n In Mirror Hyrule, they say there\n is a cave located near many bushes\n on the coast of a lake...\n\n";
					printf(Hint);
				} 
			}
			else if (RememberStuff[REMEMBER_TRACEHINTS] == 2)
			{
				if (Link->Item[I_SHOVEL2])
				{
					int Hint[3000] = "\n\n It is I, Sahasrahla. What? You don't\n know who I am? Well, I'm a friend of\n Impa's. Anyway, I heard that the Super\n Shovel's magical Leevers can also be\n moved with a special trick. \n\n Remember to keep looking for strange\n patches on the ground to find buried\n secrets, too.\n\n Last of all, there is an ancient trick\n from my time you should know: they say\n you can use another item while you are\n dashing to quickly find rupees...\n\n";
					printf(Hint);
				}
				else if (Link->Item[I_SHOVEL1])
				{
					int Hint[3000] = "\n\n It is I, Impa, once again. The shovel\n can find many buried secrets. Look for\n strange patches on the ground, or\n suspicious areas of dungeons.\n\n They also say a woman in the northeast\n mountains knows an interesting secret...\n\n";
					printf(Hint);
				}
				else
				{
					int Hint[3000] = "\n\n It is I, Impa. In some caves there are\n merchants who sell shovels. They can be\n a great way to earn extra rupys, and\n find all sorts of secrets!\n\n";
					printf(Hint);
				}
			}
			else if (RememberStuff[REMEMBER_TRACEHINTS] == 3)
			{
				if (NumTriforcePieces() == 8)
				{
					int Hint[3000] = "\n\n It's-a-me, Impa! There's a hidden\n key somewhere in Level D, if you\n can find it early on.\n\n If all else fails, you can buy a\n key in a cave near the start of\n your quest, but that shouldn't be\n neccessary at all.\n\n";
					printf(Hint);					
				}
				else if (Link->Item[I_PEGASUS])
				{
					int Hint[3000] = "\n\n It is I, Impa. You can use something\n called an 'EX1 Button' to dash with\n the Pegasus Boots, or so I've heard.\n\n";
					printf(Hint);
				}
				else if (Link->Item[I_FISHINGROD])
				{
					int Hint[3000] = "\n\n It is I, Impa. There are many piers in\n Mirror Hyrule where you can fish for\n interesting things. \n\n Sometimes, the sand underwater will\n collapse if something bumps into it!\n\n";
					printf(Hint);
				}
				else
				{
					int Hint[3000] = "\n\n It is I, Impa. In some caves there\n are merchants who sell a Fishing Rod\n for just 60 rupys. What a bargain!\n\n";
					printf(Hint);
				}
			}
			else if (RememberStuff[REMEMBER_TRACEHINTS] == 4)
			{
				if (NumTriforcePieces() == 8)
				{
					int Hint[3000] = "\n\n It's just me, Impa. It seems\n Level D has many breakable walls,\n especially in 'the jaw'.\n\n Don't forget to beware of\n walk-through walls, too. \n\n";
					printf(Hint);
				}
				else
				{
					int Hint[3000] = "\n\n It is I, Impa. Some dungeons have walls\n you can walk through if you press\n against them for a moment. Consider how\n the nearby rooms are shaped in order to\n find them.\n\n There are also many breakable walls in\n dungeons, if you can find a way to\n knock them down!\n\n";
					printf(Hint);
				}
			}
			else if (RememberStuff[REMEMBER_TRACEHINTS] == 5)
			{
				if (Link->Item[I_ROPE4])
				{
					int Hint[3000] = "\n\n I, Impa, must tell you the\n secret of 'The Shaft'. In that\n dimented drop, you must combine\n the powers of many items, but I'm\n certain you have the wisdom to\n find the way up. Good Luck!\n\n";
					printf(Hint);
				}
				else if (Link->Item[I_ROPE3])
				{
					int Hint[3000] = "\n\n It is I, Impa. The Rope (or a\n 'Blue Ladder'?) can let you\n climb across many things.\n\n";
					printf(Hint);
				}
				else
				{
					int Hint[3000] = "\n\n It is I, Impa. I know a kindly\n old man, who hides near a dock.\n He knows the secret of Level B's\n entrances. \n\n";
					printf(Hint);
				}
			}
			else if (RememberStuff[REMEMBER_TRACEHINTS] == 6)
			{
				if (!Link->Item[I_OCTOROK1])
				{
					int Hint[3000] = "\n\n It is I, Impa. Somewhere is a\n cave with many octoroks, but\n they say some octoroks don't\n get along with others... \n\n";
					printf(Hint);
				}
				else if (!Link->Item[I_BOLA1])
				{
					int Hint[3000] = "\n\n 'Tis I, Impa. A cave by the\n shore sells something very\n powerful that can be used to\n fight all sorts of enemies,\n even ones you might think were\n unbeatable.\n\n They say that's also true of\n an Octorok's rocks... \n\n";
					printf(Hint);
				}
				else if (!Link->Item[I_OCTOROK2])
				{
					int Hint[3000] = "\n\n It's me, Impa! If you find\n an exit on the top of the\n mountain, remember to check\n the Armos Statues nearby...\n\n";
					printf(Hint);
				}
				else if (!Link->Item[I_BOOTS])
				{
					int Hint[3000] = "\n\n This is Impa. Have you found\n the special item inside the\n mountain dungeon? \n\n";
					printf(Hint);
				}
				else if (!Link->Item[I_BOOTSTWO])
				{
					int Hint[3000] = "\n\n Impa here. The Iron Boots let\n you walk through the wind in many\n places, such as the mountains and\n caves, as well as walking safely\n on spikes- but walk across the\n spikes quickly, because they will\n steal your rupys.\n\n However, rumor has it that a pair\n of Golden Boots which can protect\n rupys is very well hidden,\n somewhere in Mirror Hyrule... \n\n";
					printf(Hint);
				}
				else
				{
					int Hint[3000] = "\n\n Yo Zelda! It is I, Impa. Wow!\n You found the legendary Golden\n Boots!\n\n You know, they say that an evil\n witch once forced the people to\n battle the Dastardly Stairmaster\n Darknut in Level C, but many wise\n people convinced her to change\n her ways, and she became a good\n witch, and used those Golden Boots\n within that cave to seal away the\n Dastardly Darknut Stairmaster.\n\n Thus is the legend of the heroic\n Testers Of Beta, and their tale of\n reconciliation with the hiding\n Turtle-witch. \n\n";
					printf(Hint);
				}
			}
			else if (RememberStuff[REMEMBER_TRACEHINTS] == 7)
			{
				if (!Link->Item[I_CBYRNA])
				{
					int Hint[3000] = "\n\n It is I, Impa. I heard that\n some dungeons may have more\n than one secret item inside. \n\n Also, they say a buried tree\n root at a dead-end hides an\n entrance to Level A.\n\n";
					printf(Hint);
				}
				else if (!Link->Item[I_ARMOS])
				{
					int Hint[3000] = "\n\n It is I, Impa. Did you meet\n my friend near a dock, who\n knew a secret about the\n entrances of Level B?\n\n";
					printf(Hint);
				}
				else
				{
					int Hint[3000] = "\n\n It is verily I, Impa. I've\n heard that the Armos Statue will\n always remember where you left it,\n unless you summon it in a new\n place. Without fail it stands\n steadfastly, and can even\n withstand the test of time.\n\n Also, I heard it can do a neat\n trick where it pushes a block\n around, but I think that\n maneuver is just for fun. \n\n";
					printf(Hint);
				}
			}
			else if (RememberStuff[REMEMBER_TRACEHINTS] == 8)
			{
				if (!Link->Item[I_PEGASUS])
				{
					int Hint[3000] = "\n\n It is I, Impa. The Forest\n of Maze leads the way to a\n grove where I heard that\n fairies don't live. I bet\n something is hidden there...\n\n";
					printf(Hint);
				}
				else if (!Link->Item[I_SUPERPEGASUS])
				{
					int Hint[3000] = "\n\n It is I, Impa. Many things\n are hidden beneath rocks in\n Mirror Hyrule, and even in\n some of the trees. \n\n";
					printf(Hint);
				}
				else if (!Link->Item[I_ARMOS])
				{
					int Hint[3000] = "\n\n It is I, Impa. If you wish\n to challenge Level C, you\n should first complete Level B.\n\n";
					printf(Hint);
				}
				else if (!Link->Item[I_CBYRNA2])
				{
					int Hint[3000] = "\n\n It is again I, Impa. If you're\n having trouble with a Clockpun\n in the woods, they say you can\n beat it by moving very quickly\n and precisely, or by getting a\n helper to defeat it. \n\n";
					printf(Hint);
				}
				else
				{
					int Hint[3000] = "\n\n 'Tis indeed I, Impa. Remember,\n your Patras can help carry you\n when you fall! This can be very\n helpful, but it is not the only\n way to travel a greater distance\n when falling. \n\n";
					printf(Hint);
				}
			}
			else if (RememberStuff[REMEMBER_TRACEHINTS] == 9)
			{
				if (Link->Item[I_BOWWOW])
				{
					int Hint[3000] = "\n\n 'Tis but I, Impa. I see you've\n found a friendly Gleeok (or is\n that Bow-Wow? I can't see too\n well through this telepathic\n vision.) You can use the shovel\n to call him or send him away.\n\n He looks pretty hungry, so I\n bet all sorts of monsters are\n afraid of him. Also, he's good\n at finding buried secrets, if\n you pay very close attention to\n when he stops to focus on\n something and knocks a little\n bit of dirt aside.\n\n";
					printf(Hint);
				}
				else if (Link->Item[I_STRONGBEETLE])
				{
					int Hint[3000] = "\n\n It is I, Impa. They say the way\n to the south in 'The Lion' lies in the\n eastmost tip, and that you must\n contend with the evil trickery of\n the Stairmaster Darknut.\n\n But once bested, that wicked brute\n should be gone for good.\n\n After that, I heard that the\n westmost peninsula is the secret...\n\n";
					printf(Hint);
				}
				else
				{
					int Hint[3000] = "\n\n It is I, Impa. Many items will\n be needed to get into the entrances\n of Level C, but once you have come\n far enough in your journey, I'm\n sure you can find a way.\n\n";
					printf(Hint);
				}
			}
			else if (RememberStuff[REMEMBER_TRACEHINTS] == 10)
			{
				if (NumTriforcePieces() == 8 && !Link->Item[I_ROPE4])
				{
					int Hint[3000] = "\n\n This is Impa with an important\n message! Did you remember to\n find everything in Level C's\n 'Lion' dungeon, after you fought\n the Armored Gleeok?\n\n";
					printf(Hint);
				}
				else if (Link->Item[I_ROPE4] && !Link->Item[I_BOOTSTWO])
				{
					int Hint[3000] = "\n\n It's me again, ol' Impa. There is\n a cave a short distance east of\n the start. I wonder what could\n be inside...? \n";
					printf(Hint);
				}
				else if (Link->Item[I_ROPE4] && Link->Item[I_BOOTSTWO])
				{
					int Hint[3000] = "\n\n You expected a blue winged bear\n to make this joke, but it was me,\n Impa! Make sure to choose\n carefully when you try to\n rescue Link...\n\n";
					printf(Hint);
				}
				else
				{
					int Hint[3000] = "\n\n It is I, Impa. If you drop a\n Superbomb, you can pick it up\n again by stepping away and\n touching it.\n\n You can even get it back if you've\n left the 'screen' area, if you\n return quickly enough!\n\n But when it goes off, stay away\n from it's huge explosion. It's\n very dangerous!\n\n";
					printf(Hint);
				}
			}
			else if (RememberStuff[REMEMBER_TRACEHINTS] == 11)
			{
				if (Link->Item[I_ZAPPER])
				{
					int Hint[3000] = "\n\n It is I, Impa. Have you ever\n tried 'Clay Shooting'?\n With two ducks it might be\n possible...\n\n";
					printf(Hint);
				}
				else
				{
					int Hint[3000] = "\n\n It is I, Impa. Legend says that\n if you use something called the\n 'ZQuest Creator Editor', you\n can open the 'Quest File' to\n change the 'Scrolling Speed'\n in the 'Quest Rules'. Some\n legends make no sense.\n\n That reminds me of the Legend\n that the password for 'Cheats'\n is '4'. But I'm just an old\n woman, so I don't know what\n that means.\n\n One other strange one simply\n says, 'Press the Map Button\n 'to Open the Mode Menu'.\n I don't get it.\n\n";
					printf(Hint);
				}
			}
			else RememberStuff[REMEMBER_TRACEHINTS] = 1;
			if (	
			RememberStuff[REMEMBER_SAVEDMAP] != 0 
			|| RememberStuff[REMEMBER_SAVEDSCREEN] != 0 
			|| RememberStuff[REMEMBER_SAVEDX] != 0  
			|| RememberStuff[REMEMBER_SAVEDY] != 0 
			//|| Game->GetScreenState(CONTINUESCREEN_LEVEL1MAP, CONTINUESCREEN_CHECK1, ST_VISITED) //These lines are dummied out because I don't want the selector to display unless the player has used the save option on the mode menu before, but if they were un-commented, this menu would work to allow the level-warp system to be accessed without that. It would, however, also need to add a check regarding whether to warp the player to the "saved place" when a saved place has not been set in the RememberStuff[] global array.
			//|| Game->GetScreenState(CONTINUESCREEN_LEVEL2MAP, CONTINUESCREEN_CHECK2, ST_VISITED) 
			//|| Game->GetScreenState(CONTINUESCREEN_LEVEL3MAP, CONTINUESCREEN_CHECK3, ST_VISITED) 
			//|| Game->GetScreenState(CONTINUESCREEN_LEVEL4MAP, CONTINUESCREEN_CHECK4, ST_VISITED) 
			//|| Game->GetScreenState(CONTINUESCREEN_LEVEL5MAP, CONTINUESCREEN_CHECK5, ST_VISITED) 
			//|| Game->GetScreenState(CONTINUESCREEN_LEVEL6MAP, CONTINUESCREEN_CHECK6, ST_VISITED) 
			//|| Game->GetScreenState(CONTINUESCREEN_LEVEL7MAP, CONTINUESCREEN_CHECK7, ST_VISITED) 
			//|| Game->GetScreenState(CONTINUESCREEN_LEVEL8MAP, CONTINUESCREEN_CHECK8, ST_VISITED) 
			//|| Game->GetScreenState(CONTINUESCREEN_LEVEL9MAP, CONTINUESCREEN_CHECK9, ST_VISITED)
			)
			{
				int ContHere[14] = "CONTINUE HERE";
				int ContSaved[26] = "CONTINUE FROM SAVED PLACE";
				int ContSavedB[4] = "AT:";
				int ContSavedC[255] = " ";
				Game->GetDMapTitle(RememberStuff[REMEMBER_SAVEDMAP], ContSavedC);
				int ContLevel[27] = "CONTINUE FROM LEVEL.....";
				int ContSelector;
				int WarpDelay;
				int ContLevelSelector = 0;
		
				while(true)
				{
					Waitframe();


					// Draw continue options:
					if (WarpDelay == 0)
					{
						Screen->Rectangle(
							7,		//layer
							16,		//start X
							48,		//start y
							239,		//end x
							111,		//end y
							0,1,0,0,0,true,128);
		
						Screen->DrawString(
							7,
							32,
							56, 
							FONT_Z1, 
							1, 
							0, 
							TF_NORMAL, 
							ContHere, 
							OP_OPAQUE);
			
						Screen->DrawString(
							7,
							32,
							72, 
							FONT_Z1, 
							1, 
							0, 
							TF_NORMAL, 
							ContSaved, 
							OP_OPAQUE);
						Screen->DrawString(
							7,
							32,
							80, 
							FONT_Z1, 
							1, 
							0, 
							TF_NORMAL, 
							ContSavedB, 
							OP_OPAQUE);
						Screen->DrawString(
							7,
							64,
							80, 
							FONT_Z1, 
							1, 
							0, 
							TF_NORMAL, 
							ContSavedC, 
							OP_OPAQUE);
	
		
						if (ContLevelSelector != 0)
						{
							if (ContLevelSelector != 10)
							{
								Screen->DrawString(
									7,
									32,
									96, 
									FONT_Z1, 
									1, 
									0, 
									TF_NORMAL, 
									ContLevel, 
									OP_OPAQUE);
								Screen->DrawInteger(
									7,					//int layer, 
									224,					//int x, 
									96,					//int y, 
									FONT_Z1,				//int font, 
									1,					//int color, 
									-1,					//int background_color, 
									-1,					//int width, 
									-1,					//int height, 
									ContLevelSelector,			//int number, 
									0, 					//int number_decimal_places, 
									128);					//int opacity
							}
						}
						else ContLevelSelector = 1;
	
						// Skips past levels the player has not yet visited the entrance screen for:
						if (Link->InputLeft)
						{
							if (ContLevelSelector == 9)
							{
								if (!Game->GetScreenState(CONTINUESCREEN_LEVEL9MAP, CONTINUESCREEN_CHECK9, ST_VISITED))
								{
									-- ContLevelSelector;
								}
							}
							if (ContLevelSelector == 8)
							{
								if (!Game->GetScreenState(CONTINUESCREEN_LEVEL8MAP, CONTINUESCREEN_CHECK8, ST_VISITED))
								{
									-- ContLevelSelector ;
								}
							}
							if (ContLevelSelector == 7)
							{
								if (!Game->GetScreenState(CONTINUESCREEN_LEVEL7MAP, CONTINUESCREEN_CHECK7, ST_VISITED))
								{
									-- ContLevelSelector ;
								}
							}
							if (ContLevelSelector == 6)
							{
								if (!Game->GetScreenState(CONTINUESCREEN_LEVEL6MAP, CONTINUESCREEN_CHECK6, ST_VISITED))
								{
									-- ContLevelSelector;
								}
							}
							if (ContLevelSelector == 5)
							{
								if (!Game->GetScreenState(CONTINUESCREEN_LEVEL5MAP, CONTINUESCREEN_CHECK5, ST_VISITED))
								{
									-- ContLevelSelector;
								}
							}
							if (ContLevelSelector == 4)
							{	
								if (!Game->GetScreenState(CONTINUESCREEN_LEVEL4MAP, CONTINUESCREEN_CHECK4, ST_VISITED))
								{
									-- ContLevelSelector;
								}	
							}	
							if (ContLevelSelector == 3)
							{
								if (!Game->GetScreenState(CONTINUESCREEN_LEVEL3MAP, CONTINUESCREEN_CHECK3, ST_VISITED))
								{
									-- ContLevelSelector;
								}
							}
							if (ContLevelSelector == 2)
							{
								if (!Game->GetScreenState(CONTINUESCREEN_LEVEL2MAP, CONTINUESCREEN_CHECK2, ST_VISITED))
								{
									-- ContLevelSelector;
								}
							}
							if (ContLevelSelector == 1)
							{
								if (!Game->GetScreenState(CONTINUESCREEN_LEVEL1MAP, CONTINUESCREEN_CHECK1, ST_VISITED))
								{
									if (
										   Game->GetScreenState(CONTINUESCREEN_LEVEL9MAP, CONTINUESCREEN_CHECK9, ST_VISITED) 
										|| Game->GetScreenState(CONTINUESCREEN_LEVEL8MAP, CONTINUESCREEN_CHECK8, ST_VISITED) 
										|| Game->GetScreenState(CONTINUESCREEN_LEVEL7MAP, CONTINUESCREEN_CHECK7, ST_VISITED) 
										|| Game->GetScreenState(CONTINUESCREEN_LEVEL6MAP, CONTINUESCREEN_CHECK6, ST_VISITED) 
										|| Game->GetScreenState(CONTINUESCREEN_LEVEL5MAP, CONTINUESCREEN_CHECK5, ST_VISITED) 
										|| Game->GetScreenState(CONTINUESCREEN_LEVEL4MAP, CONTINUESCREEN_CHECK4, ST_VISITED) 
										|| Game->GetScreenState(CONTINUESCREEN_LEVEL3MAP, CONTINUESCREEN_CHECK3, ST_VISITED) 
										|| Game->GetScreenState(CONTINUESCREEN_LEVEL2MAP, CONTINUESCREEN_CHECK2, ST_VISITED) 
										|| Game->GetScreenState(CONTINUESCREEN_LEVEL1MAP, CONTINUESCREEN_CHECK1, ST_VISITED)
									) ContLevelSelector = 9;
									else ContLevelSelector = 10;
								}
							}
						}
						else
						{
							if (ContLevelSelector == 1)
							{
								if (!Game->GetScreenState(CONTINUESCREEN_LEVEL1MAP, CONTINUESCREEN_CHECK1, ST_VISITED))
								{
									++ ContLevelSelector;
								}
							}
							if (ContLevelSelector == 2)
							{
								if (!Game->GetScreenState(CONTINUESCREEN_LEVEL2MAP, CONTINUESCREEN_CHECK2, ST_VISITED))
								{
									++ ContLevelSelector;
								}
							}
							if (ContLevelSelector == 3)
							{
								if (!Game->GetScreenState(CONTINUESCREEN_LEVEL3MAP, CONTINUESCREEN_CHECK3, ST_VISITED))
								{
									++ ContLevelSelector;
								}
							}
							if (ContLevelSelector == 4)
							{	
								if (!Game->GetScreenState(CONTINUESCREEN_LEVEL4MAP, CONTINUESCREEN_CHECK4, ST_VISITED))
								{
									++ ContLevelSelector;
								}	
							}	
							if (ContLevelSelector == 5)
							{
								if (!Game->GetScreenState(CONTINUESCREEN_LEVEL5MAP, CONTINUESCREEN_CHECK5, ST_VISITED))
								{
									++ ContLevelSelector;
								}
							}
							if (ContLevelSelector == 6)
							{
								if (!Game->GetScreenState(CONTINUESCREEN_LEVEL6MAP, CONTINUESCREEN_CHECK6, ST_VISITED))
								{
									++ ContLevelSelector;
								}
							}
							if (ContLevelSelector == 7)
							{
								if (!Game->GetScreenState(CONTINUESCREEN_LEVEL7MAP, CONTINUESCREEN_CHECK7, ST_VISITED))
								{
									++ ContLevelSelector;
								}
							}
							if (ContLevelSelector == 8)
							{
								if (!Game->GetScreenState(CONTINUESCREEN_LEVEL8MAP, CONTINUESCREEN_CHECK8, ST_VISITED))
								{
									++ ContLevelSelector;
								}
							}
							if (ContLevelSelector == 9)
							{
								if (!Game->GetScreenState(CONTINUESCREEN_LEVEL9MAP, CONTINUESCREEN_CHECK9, ST_VISITED))
								{
									ContLevelSelector = 10;
								}
							}
						}	
					}

					// Selection of continue options:
					if (ContSelector == 0)
					{
						if (WarpDelay == 0)
						{
							Screen->FastTile(7,24,56,SelectorTile,SelectorCSet,128);
							if (Link->PressDown)
							{
								ContSelector = 1;
								Game->PlaySound(SFX_CURSOR);
							}
							else if (Link->PressA || Link->PressStart)
							{
								NoAction();
								Link->PressStart = false;
								Link->InputStart = false;
								WarpDelay = 1;
							}
						}
					}	
					else if (ContSelector == 1)
					{
						if (WarpDelay == 0)
						{
							Screen->FastTile(7,24,72,SelectorTile,SelectorCSet,128);
							if (Link->PressUp)
							{
								ContSelector = 0;
								Game->PlaySound(SFX_CURSOR);
							}
							if (Link->PressDown)
							{
								if (ContLevelSelector != 0 && ContLevelSelector != 10)
								{
									ContSelector = 2;
									Game->PlaySound(SFX_CURSOR);
								}
							}
							else if (Link->PressA || Link->PressStart)
							{
								NoAction();
								Link->PressStart = false;
								Link->InputStart = false;
								WarpDelay = 1;
							}
						}
					}
					else if (ContSelector == 2)
					{
						if (ContLevelSelector == 10) ContLevelSelector = 1;
						if (WarpDelay == 0)
						{
							Screen->FastTile(7,24,96,SelectorTile,SelectorCSet,128);
							if (Link->PressLeft)
							{
								if (ContLevelSelector <= 1) ContLevelSelector = 9;
								else --ContLevelSelector;
								Game->PlaySound(SFX_MSG);
							}
							else if (Link->PressRight)
							{
								if (ContLevelSelector >= 9) ContLevelSelector = 1;
								else ++ContLevelSelector;
								Game->PlaySound(SFX_MSG);
							}
							else if (Link->PressUp)
							{
								if (RememberStuff[REMEMBER_SAVEDMAP] != 0 || RememberStuff[REMEMBER_SAVEDSCREEN] != 0 || RememberStuff[REMEMBER_SAVEDX] != 0 || RememberStuff[REMEMBER_SAVEDY] != 0)
								{
									ContSelector = 1;
									Game->PlaySound(SFX_CURSOR);
								}	
								else
								{
									ContSelector = 0;
									Game->PlaySound(SFX_CURSOR);
								}
							}
							else if (Link->PressA || Link->PressStart)
							{
								NoAction();
								Link->PressStart = false;
								Link->InputStart = false;
								WarpDelay = 1;
							}
						}
					}

					// Activate selected continue option:
					if (WarpDelay > 0)
					{
						++WarpDelay;
						if (ContSelector == 0)
						{
							if (WarpDelay >= 4 && !Link->PressA && !Link->InputA  && !Link->PressStart && !Link->InputStart) Quit(); 
						}
						else
						{
							Screen->Rectangle(
								7,			//layer
								0,			//start X
								0,			//start y
								256,			//end x
								176,			//end y
								0,1,0,0,0,true,128);
							Game->PlayMIDI(0);
							if (WarpDelay >= 20)
							{
								if (ContSelector == 1)
								{
									Link->X = RememberStuff[REMEMBER_SAVEDX];
									Link->Y = RememberStuff[REMEMBER_SAVEDY];
									Link->PitWarp(RememberStuff[REMEMBER_SAVEDMAP],RememberStuff[REMEMBER_SAVEDSCREEN]);
								}
								else if (ContSelector == 2)
								{
									if (ContLevelSelector == 1) Link->Warp(CONTINUESCREEN_LEVEL1DMAP,CONTINUESCREEN_LEVEL1-1);
									else if (ContLevelSelector == 2) Link->Warp(CONTINUESCREEN_LEVEL2DMAP,CONTINUESCREEN_LEVEL2-1);
									else if (ContLevelSelector == 3) Link->Warp(CONTINUESCREEN_LEVEL3DMAP,CONTINUESCREEN_LEVEL3-1);
									else if (ContLevelSelector == 4) Link->Warp(CONTINUESCREEN_LEVEL4DMAP,CONTINUESCREEN_LEVEL4-1);
									else if (ContLevelSelector == 5) Link->Warp(CONTINUESCREEN_LEVEL5DMAP,CONTINUESCREEN_LEVEL5-1);
									else if (ContLevelSelector == 6) Link->Warp(CONTINUESCREEN_LEVEL6DMAP,CONTINUESCREEN_LEVEL6-1);
									else if (ContLevelSelector == 7) Link->Warp(CONTINUESCREEN_LEVEL7DMAP,CONTINUESCREEN_LEVEL7-1);
									else if (ContLevelSelector == 8) Link->Warp(CONTINUESCREEN_LEVEL8DMAP,CONTINUESCREEN_LEVEL8-1);
									else if (ContLevelSelector == 9) Link->Warp(CONTINUESCREEN_LEVEL9DMAP,CONTINUESCREEN_LEVEL9-1);
								}
							}
						}
					}
					Link->PressStart = false;
					Link->InputStart = false;
					Link->PressMap = false;
					Link->InputMap = false;
					NoAction();
				}
			}
			else Quit();
		}
		else Quit();
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Continue from Saved Place (End)
// By Mitsukara
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: OpenModeMenu (start)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// NOTE: This script is not utilized by the mode menu under normal circumstances. It is just a script to cause the mode menu to be opened during a certian cutscene.
// It only happens if the player has one of the relevant modes turned on already.

ffc script OpenModeMenu
{
	void run()
	{
		if (Link->Item[I_PROGRESSIVEGEAR] || Link->Item[I_SHIELD1] || Link->Item[I_PERILRING2] || Link->Item[I_HEROCHARM] || Link->Item[I_HEARTRING1] || Link->Item[I_NOHEARTS] || Link->Item[I_TOUGHMONSTERS] || Link->Item[I_EXTRAENEMY] || Link->Item[I_ZAPPER] || Link->Item[I_ZAPPERTWO] || Link->Item[I_PARTNER]) Link->PressMap = true;
		Quit();
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: OpenModeMenu (end)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Mirror Link (Start)
// By Dimi
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
const int ML_LASTX = 1;			//Boss Last X
const int ML_LASTY = 2;			//Boss Last Y
const int ML_STATE = 3; 		//Boss State
const int ML_ODATA = 4; 		//Boss OrigData
const int ML_PHASE = 5; 		//Boss Phase
const int ML_ATTACK = 6;		//Clone Controller
const int ML_TIMER = 6; 		//Boss Heart Ring
const int SP_LINK_POWAH = 165;
const int SP_LINK_TRIFORCE = 168;
const int EW_LINKSHADOW = 38;
const int EW_LINKWEAPONS = 39;
const int SP_WHISTLE = 170;

ffc script MirrorLink
{
	void run(int enemyid)
	{
		npc ghost = Screen->CreateNPC(enemyid);
		int i; int k; int m; int n;
		ghost->X = this->X;
		ghost->Y = this->Y;
		this->X = ghost->X;
		this->Y = ghost->Y;
		this->InitD[ML_LASTX] = ghost->X;
		this->InitD[ML_LASTY] = ghost->Y-1;
		this->InitD[ML_STATE] = 0;
		this->InitD[ML_ODATA] = ghost->OriginalTile;
		this->InitD[ML_PHASE] = 0;
		ffc MirrorPartner;
		int eggz[] = "MirrorLinkPartner";
		int sid = Game->GetFFCScript(eggz);
		for ( int q = 1; q <= 32; ++q )
		{
			MirrorPartner = Screen->LoadFFC(q);
			if ( MirrorPartner->Script ) continue;
			if ( MirrorPartner->Data ) continue;
			if ( q )
			{
				MirrorPartner->Data = 1;
				MirrorPartner->Script = Game->GetFFCScript(eggz);
				MirrorPartner->X = this->X;
				MirrorPartner->Y = this->Y;
				break;
			}
		}
		MirrorPartner->InitD[ML_ODATA] = 30940;
		Link_Transform(this, ghost, 0);
		int timer = Rand(180, 240);
		int XLoc;
		int YLoc;
		int Attack[7];
		Attack[1] = -1;
		while(this->InitD[ML_PHASE] <= 0)
		{
			if (Attack[6] == 0)
			{
				if (Link->Item[I_PARTNER])
				{
					while (MirrorPartner->InitD[ML_ATTACK] >= 0 && Attack[1] >= 0)
					{
						Link_Transform(this, ghost, 1);
						Link_Waitframe(ghost, this, 1);
					}
				}
				do
				{
					Attack[0] = Rand(3);
				}
				while(Attack[0] == Attack[1]);
				if (Attack[1] == -1) Attack[0] = 0;
				if (Attack[0] == 0)
				{
					MirrorPartner->InitD[ML_ATTACK] = 0;
					Link_Transform(this, ghost, 1);
					if (!Link->Item[I_TOUGHMONSTERS]) for (i = 0; i < 20; ++i) Link_Waitframe(ghost, this, 2);
					if (Link->Item[I_WEAKMONSTERS]) for (i = 0; i < 20; ++i) Link_Waitframe(ghost, this, 2);
					Link_Transform(this, ghost, 0);
					if (!Link->Item[I_TOUGHMONSTERS])
					{
						for (i = 0; i < 40; ++i) 
						{
							if (!Link->Item[I_WEAKMONSTERS]) ++i;
							int angle = Angle(Link->X, Link->Y, this->X, this->Y);
							if (!Link->Item[I_PROGRESSIVEGEAR]) angle = Dir4Angle(AngleDirFixed4(angle));
							Link_MoveAtAngle(this, angle, 0.7);
							Link_Waitframe(ghost, this, 2);
						}
					}
					for (k = 0; k < 6; ++k)
					{
						int angle = Angle(this->X, this->Y, Link->X, Link->Y);
						if (!Link->Item[I_PROGRESSIVEGEAR]) angle = Dir4Angle(AngleDirFixed4(angle));
						if (!Link->Item[I_TOUGHMONSTERS]) ++k;
						if (Link->Item[I_WEAKMONSTERS]) ++k;
						Link_Transform(this, ghost, 4);
						int j;
						if (k % 2 == 0) j = 45;
						else j = -45;
						for (i = 0; i < 10; ++i) Link_Waitframe(ghost, this, 5);
						Game->PlaySound(SFX_SWORD);
						for (i = 0; i < 20; ++i) 
						{
							if (k % 2 == 0) 
							{
								if (j > -45) j -= 5;
							}
							else 
							{
								if (j < 45) j+= 5;
							}
							Link_MoveAtAngle(this, angle, 2);
							int X = this->X + 8 + VectorX(14, (angle - j) % 360);
							int Y = this->Y + 8 + VectorY(14, (angle - j) % 360);
							int anglo = (angle - j) % 360;
							if (!Link->Item[I_PROGRESSIVEGEAR])
							{
								anglo = angle;
								X = this->X + 8 + VectorX(14, angle);
								Y = this->Y + 8 + VectorY(14, angle);
							}
							//DrawComboAyy(3, X, Y, 5737, 1, 1, 6, 16, 16, X, Y, anglo, -1, 0, true, 128);
							if (Link->Item[I_PROGRESSIVEGEAR]) DamageArea(ghost->WeaponDamage*2, X-8, Y-8, 1189 + AngleDirFixed8(anglo), 6);
							else  DamageArea(ghost->WeaponDamage*2, X-8, Y-8, 1189 + AngleDirFixed4(angle), 6);
							ghost->Dir = AngleDirFixed4(angle);
							Link_Waitframe(ghost, this, 5);
						}
					}
				}
				if (Attack[0] == 1)
				{
					Link_Transform(this, ghost, 0);
					do{
						int spawnpoint = FindSpawnPoint(true, false, false, false);
						XLoc = ComboX(spawnpoint);
						YLoc = ComboY(spawnpoint);
					}
					while(Distance(Link->X, Link->Y, GridX(XLoc), GridY(YLoc)) < 64);
					int angle = Angle(this->X, this->Y, XLoc, YLoc);
					while(Distance(this->X, this->Y, XLoc, YLoc) > 4){
						if (Link->Item[I_WEAKMONSTERS])
						{
							if (Link->Item[I_PROGRESSIVEGEAR]) Link_MoveAtAngle(this, angle, 1, true);
							else Link_MoveAt4Way(this, 2, XLoc, YLoc);
						}
						else if (!Link->Item[I_TOUGHMONSTERS])
						{
							if (Link->Item[I_PROGRESSIVEGEAR]) Link_MoveAtAngle(this, angle, 2, true);
							else Link_MoveAt4Way(this, 2, XLoc, YLoc);
						}
						else
						{
							if (Link->Item[I_PROGRESSIVEGEAR]) Link_MoveAtAngle(this, angle, 3, true);
							else Link_MoveAt4Way(this, 3, XLoc, YLoc);
						}
						angle = Angle(this->X, this->Y, XLoc, YLoc);
						Link_Waitframe(ghost, this, 1);
					}
					MirrorPartner->InitD[ML_ATTACK] = 1;
					Link_Transform(this, ghost, 5);
					lweapon DarkItem = CreateLWeaponAt(LW_SPARKLE,this->X,this->Y);
					DarkItem->UseSprite(SP_WHISTLE);
					DarkItem->DrawYOffset = -16;
					Game->PlaySound(SFX_WHISTLE);
					for (i = 0; i < 64; ++i) 
					{
						Link_Waitframe(ghost, this, 4);
					}
					for (i = 0; i < 16; ++i) 
					{
						//DrawComboAyy(3, this->X + 7, this->Y + 7, 5738, 1, 1, 7, i+1, i+1, 0, 0, 0, -1, 0, true, 128);
						DamageArea(ghost->WeaponDamage*2, ghost->X, ghost->Y, 1056+((i/4)%2), 7);
						if (MirrorPartner->InitD[ML_ATTACK] < 0) ++i;
						Link_Waitframe(ghost, this, 4);
					}
					for (i = 0; i < 16; ++i) 
					{
						DamageArea(ghost->WeaponDamage*2, ghost->X, ghost->Y, 1052+((i/4)%2), 7);
						if (MirrorPartner->InitD[ML_ATTACK] < 0) ++i;
						Link_Waitframe(ghost, this, 4);
					}
					for (i = 0; i < 16; ++i) 
					{
						DamageArea(ghost->WeaponDamage*2, ghost->X-8, ghost->Y-8, 1072+((i/4)%2), 7);
						DamageArea(ghost->WeaponDamage*2, ghost->X-8, ghost->Y+8, 1092+((i/4)%2), 7);
						DamageArea(ghost->WeaponDamage*2, ghost->X+8, ghost->Y-8, 1074+((i/4)%2), 7);
						DamageArea(ghost->WeaponDamage*2, ghost->X+8, ghost->Y+8, 1094+((i/4)%2), 7);
						if (MirrorPartner->InitD[ML_ATTACK] < 0) ++i;
						Link_Waitframe(ghost, this, 4);
					}
					for (i = 0; i < 16; ++i) 
					{
						DamageArea(ghost->WeaponDamage*2, ghost->X-8, ghost->Y-8, 1112+((i/4)%2), 7);
						DamageArea(ghost->WeaponDamage*2, ghost->X-8, ghost->Y+8, 1132+((i/4)%2), 7);
						DamageArea(ghost->WeaponDamage*2, ghost->X+8, ghost->Y-8, 1114+((i/4)%2), 7);
						DamageArea(ghost->WeaponDamage*2, ghost->X+8, ghost->Y+8, 1134+((i/4)%2), 7);
						if (MirrorPartner->InitD[ML_ATTACK] < 0) ++i;
						Link_Waitframe(ghost, this, 4);
					}
					for (i = 0; i < 392; ++i) 
					{
						if (Link->Item[I_WEAKMONSTERS] && i < 360) ++i;
						if (i % 120 == 0 || (i % 60 == 0 && Link->Item[I_TOUGHMONSTERS])) 
						{
							Game->PlaySound(SFX_WHIRLWIND);
							int eggz[] = "whirlwhat";
							int sid = Game->GetFFCScript(eggz);
							ffc f;
							for ( int q = 1; q <= 32; ++q )
							{
								f = Screen->LoadFFC(q);
								if ( f->Script ) continue;
								if ( f->Data ) continue;
								if ( q )
								{
									f->Data = 1;
									f->Script = Game->GetFFCScript(eggz);
									f->X = this->X;
									f->Y = this->Y;
									break;
								}
							}
						}
						if (Link->Item[I_WEAKMONSTERS])
						{
							if (Link->Item[I_PROGRESSIVEGEAR]) Link_MoveTowardsLink(this, 0.5);
							else 
							{
								//Link_MoveAt4Way(this, 1, Link->X, Link->Y);
								int angle = Angle(this->X, this->Y, Link->X, Link->Y);
								angle = Dir4Angle(AngleDirFixed4(angle));
								Link_MoveAtAngle(this, angle, 0.55);
							}
						}
						else if (!Link->Item[I_TOUGHMONSTERS])
						{
							if (Link->Item[I_PROGRESSIVEGEAR]) Link_MoveTowardsLink(this, 0.7);
							else 
							{
								//Link_MoveAt4Way(this, 1, Link->X, Link->Y);
								int angle = Angle(this->X, this->Y, Link->X, Link->Y);
								angle = Dir4Angle(AngleDirFixed4(angle));
								Link_MoveAtAngle(this, angle, 0.7);
							}
						}
						else
						{
							if (Link->Item[I_PROGRESSIVEGEAR]) Link_MoveTowardsLink(this, 0.9);
							else 
							{
								//Link_MoveAt4Way(this, 1, Link->X, Link->Y);
								int angle = Angle(this->X, this->Y, Link->X, Link->Y);
								angle = Dir4Angle(AngleDirFixed4(angle));
								Link_MoveAtAngle(this, angle, 0.85);
							}
						}
						//DrawComboAyy(3, this->X + 7, this->Y + 7, 5738, 1, 1, 7, 32, 32, 0, 0, 0, -1, 0, true, 128);
						DamageArea(ghost->WeaponDamage*2, ghost->X-8, ghost->Y-8, 1112+((i/4)%2), 7);
						DamageArea(ghost->WeaponDamage*2, ghost->X-8, ghost->Y+8, 1132+((i/4)%2), 7);
						DamageArea(ghost->WeaponDamage*2, ghost->X+8, ghost->Y-8, 1114+((i/4)%2), 7);
						DamageArea(ghost->WeaponDamage*2, ghost->X+8, ghost->Y+8, 1134+((i/4)%2), 7);
						if (MirrorPartner->InitD[ML_ATTACK] < 0) ++i;
						Link_Waitframe(ghost, this, 4);
					}
					for (i = 0; i < 16; ++i) 
					{
						DamageArea(ghost->WeaponDamage*2, ghost->X-8, ghost->Y-8, 1112+((i/4)%2), 7);
						DamageArea(ghost->WeaponDamage*2, ghost->X-8, ghost->Y+8, 1132+((i/4)%2), 7);
						DamageArea(ghost->WeaponDamage*2, ghost->X+8, ghost->Y-8, 1114+((i/4)%2), 7);
						DamageArea(ghost->WeaponDamage*2, ghost->X+8, ghost->Y+8, 1134+((i/4)%2), 7);
						if (MirrorPartner->InitD[ML_ATTACK] < 0) ++i;
						Link_Waitframe(ghost, this, 4);
					}
					for (i = 0; i < 16; ++i) 
					{
						DamageArea(ghost->WeaponDamage*2, ghost->X-8, ghost->Y-8, 1072+((i/4)%2), 7);
						DamageArea(ghost->WeaponDamage*2, ghost->X-8, ghost->Y+8, 1092+((i/4)%2), 7);
						DamageArea(ghost->WeaponDamage*2, ghost->X+8, ghost->Y-8, 1074+((i/4)%2), 7);
						DamageArea(ghost->WeaponDamage*2, ghost->X+8, ghost->Y+8, 1094+((i/4)%2), 7);
						if (MirrorPartner->InitD[ML_ATTACK] < 0) ++i;
						Link_Waitframe(ghost, this, 4);
					}
					for (i = 0; i < 16; ++i) 
					{
						DamageArea(ghost->WeaponDamage*2, ghost->X, ghost->Y, 1052+((i/4)%2), 7);
						if (MirrorPartner->InitD[ML_ATTACK] < 0) ++i;
						Link_Waitframe(ghost, this, 4);
					}
					for (i = 0; i < 16; ++i) 
					{
						//DrawComboAyy(3, this->X + 7, this->Y + 7, 5738, 1, 1, 7, i+1, i+1, 0, 0, 0, -1, 0, true, 128);
						DamageArea(ghost->WeaponDamage*2, ghost->X, ghost->Y, 1056+((i/4)%2), 7);
						if (MirrorPartner->InitD[ML_ATTACK] < 0) ++i;
						Link_Waitframe(ghost, this, 4);
					}
				}
				if (Attack[0] == 2)
				{
					MirrorPartner->InitD[ML_ATTACK] = 2;
					Link_Transform(this, ghost, 0);
					for (i = 0; i < 30; ++i) Link_Waitframe(ghost, this, 2);
					Link_Transform(this, ghost, 1);
					ffc f;
					for ( int q = 1; q <= 32; ++q )
					{
						f = Screen->LoadFFC(q);
						if ( f->Script ) continue;
						if ( f->Data ) continue;
						if ( q )
						{
							f->Data = 5781;
							f->CSet = 6;
							f->X = this->X;
							f->Y = this->Y+2;
							break;
						}
					}
					int angle = Angle(this->X, this->Y, Link->X, Link->Y);
					if (!Link->Item[I_PROGRESSIVEGEAR]) angle = Dir4Angle(AngleDirFixed4(angle));
					for (k = 0; k < 8; ++k)
					{
						Game->PlaySound(SFX_ARROW);
						Link_Transform(this, ghost, 4);
						if (Link->Item[I_WEAKMONSTERS]) ++k;
						FireAimedEWeapon(EW_ARROW, this->X, this->Y, 0, 200, ghost->WeaponDamage, -1, -1, EWF_ROTATE);
						if (k == 3) 
						{
							angle = Angle(this->X, this->Y, Link->X, Link->Y);
							if (!Link->Item[I_PROGRESSIVEGEAR]) angle = Dir4Angle(AngleDirFixed4(angle));
						}
						for (i = 0; i < 20; ++i) 
						{
							if (!Link->Item[I_WEAKMONSTERS]) ++i;
							if (Link->Item[I_WEAKMONSTERS]) Link_MoveAtAngle(this, angle, 0.5);
							else Link_MoveAtAngle(this, angle, 1);
							f->X = this->X;
							f->Y = this->Y+2;
							f->Data = 5781;
							f->CSet = 6;
							//DrawComboAyy(1, this->X+7, this->Y+7, 5739, 1, 1, 6, 16, 16, 0, 0, 0, -1, 0, true, 128);
							//DamageArea(ghost->WeaponDamage*2, ghost->X, ghost->Y + 4, 22924, 6);
							Link_Waitframe(ghost, this, 3);
						}
						Link_Transform(this, ghost, 1);
						for (i = 0; i < 20; ++i) 
						{
							if (!Link->Item[I_WEAKMONSTERS]) ++i;
							if (Link->Item[I_WEAKMONSTERS]) Link_MoveAtAngle(this, angle, 0.5);
							else Link_MoveAtAngle(this, angle, 1);
							f->X = this->X;
							f->Y = this->Y+2;
							f->Data = 5781;
							f->CSet = 6;
							//DrawComboAyy(1, this->X+7, this->Y+7, 5739, 1, 1, 6, 16, 16, 0, 0, 0, -1, 0, true, 128);
							//DamageArea(ghost->WeaponDamage*2, ghost->X, ghost->Y + 4, 22924, 6);
							Link_Waitframe(ghost, this, 1);
						}
					}
					if (Link->Item[I_TOUGHMONSTERS])
					{
						angle = Angle(this->X, this->Y, Link->X, Link->Y);
						if (!Link->Item[I_PROGRESSIVEGEAR]) angle = DirAngle(AngleDirFixed8(angle));
						for (k = 0; k < 8; ++k)
						{
							Game->PlaySound(SFX_ARROW);
							Link_Transform(this, ghost, 4);
							FireAimedEWeapon(EW_ARROW, this->X, this->Y, 0, 200, ghost->WeaponDamage, -1, -1, EWF_ROTATE);
							if (k == 3) 
							{
								angle = Angle(this->X, this->Y, Link->X, Link->Y);
								if (!Link->Item[I_PROGRESSIVEGEAR]) angle = Dir4Angle(AngleDirFixed4(angle));
							}
							for (i = 0; i < 5; ++i) 
							{
								Link_MoveAtAngle(this, angle, 1.5);
								f->X = this->X;
								f->Y = this->Y+2;
								f->Data = 5781;
								f->CSet = 6;
								//DrawComboAyy(1, this->X+7, this->Y+7, 5739, 1, 1, 6, 16, 16, 0, 0, 0, -1, 0, true, 128);
								//DamageArea(ghost->WeaponDamage*2, ghost->X, ghost->Y + 4, 22924, 6);
								Link_Waitframe(ghost, this, 3);
							}
							Link_Transform(this, ghost, 1);
							for (i = 0; i < 5; ++i) 
							{
								Link_MoveAtAngle(this, angle, 2);
								f->X = this->X;
								f->Y = this->Y+2;
								f->Data = 5781;
								f->CSet = 6;
								//DrawComboAyy(1, this->X+7, this->Y+7, 5739, 1, 1, 6, 16, 16, 0, 0, 0, -1, 0, true, 128);
								//DamageArea(ghost->WeaponDamage*2, ghost->X, ghost->Y + 4, 22924, 6);
								Link_Waitframe(ghost, this, 1);
							}
						}
					}
					f->Data = 0;
				}
				if (!Link->Item[I_TOUGHMONSTERS])for (i = 0; i < 20; ++i) Link_Waitframe(ghost, this, 4);
				Attack[1] = Attack[0];
			}
			if (Attack[6] == 1)
			{
				do
				{
					Attack[2] = Rand(3);
				}
				while(Attack[2] == Attack[3]);
				if (Rand(2) == 0)
				{
					MirrorPartner->InitD[ML_ATTACK] = 9;
					Link_Transform(this, ghost, 0);
					do{
						int spawnpoint = FindSpawnPoint(true, false, false, false);
						XLoc = ComboX(spawnpoint);
						YLoc = ComboY(spawnpoint);
					}
					while(Distance(Link->X, Link->Y, GridX(XLoc), GridY(YLoc)) < 64);
					int angle = Angle(this->X, this->Y, XLoc, YLoc);
					while(Distance(this->X, this->Y, XLoc, YLoc) > 4){
						if (Link->Item[I_WEAKMONSTERS])
						{
							if (Link->Item[I_PROGRESSIVEGEAR]) Link_MoveAtAngle(this, angle, 1, true);
							else Link_MoveAt4Way(this, 2, XLoc, YLoc);
						}
						else if (!Link->Item[I_TOUGHMONSTERS])
						{
							if (Link->Item[I_PROGRESSIVEGEAR]) Link_MoveAtAngle(this, angle, 2, true);
							else Link_MoveAt4Way(this, 2, XLoc, YLoc);
						}
						else
						{
							if (Link->Item[I_PROGRESSIVEGEAR]) Link_MoveAtAngle(this, angle, 3, true);
							else Link_MoveAt4Way(this, 3, XLoc, YLoc);
						}
						angle = Angle(this->X, this->Y, XLoc, YLoc);
						Link_Waitframe(ghost, this, 1);
					}
					if (Link->Item[I_PARTNER])
					{
						while (MirrorPartner->InitD[ML_ATTACK] == 9)
						{
							Link_Transform(this, ghost, 1);
							Link_Waitframe(ghost, this, 1);
						}
					}
				}
				if (Attack[2] == 0)
				{
					MirrorPartner->InitD[ML_ATTACK] = 3;
					bool homing = false;
					if (Rand(2) == 0 || !Link->Item[I_PROGRESSIVEGEAR]) homing = true;
					for (k = 0; k < 6; ++k)
					{
						int angle = Angle(this->X, this->Y, Link->X, Link->Y);
						if (!Link->Item[I_PROGRESSIVEGEAR]) angle = Dir4Angle(AngleDirFixed4(angle));
						ghost->Dir = AngleDirFixed4(angle)+8;
						Link_Transform(this, ghost, 4);
						for (i = 0; i < 40; ++i) 
						{
							int X = this->X + 8 + VectorX(14, angle);
							int Y = this->Y + 8 + VectorY(14, angle);
							//DrawComboAyy(3, X, Y, 5740, 1, 1, 6, 16, 16, X, Y, angle, -1, 0, true, 128);
							if (Link->Item[I_PROGRESSIVEGEAR]) DamageArea(ghost->WeaponDamage*2, X-8, Y-8, 1209 + AngleDirFixed8(angle), 7);
							else DamageArea(ghost->WeaponDamage*2, X-8, Y-8, 1209 + AngleDirFixed4(angle), 7);
							if (!homing)
							{
								++i;
								if (Link->Item[I_WEAKMONSTERS]) ++i;
							}
							if (Link->Item[I_TOUGHMONSTERS]) ++i;
							if (!Link->Item[I_WEAKMONSTERS]) i+=2;
							Link_Waitframe(ghost, this, 0);
						}
						eweapon e;
						if (!Link->Item[I_TOUGHMONSTERS] || k % 2 == 0) e = FireEWeapon(EW_MAGIC, this->X, this->Y, DegtoRad(angle), 200, ghost->WeaponDamage, -1, -1, EWF_ROTATE);
						else e = FireEWeapon(EW_MAGIC, this->X, this->Y, DegtoRad(angle) + 0.6, 200, ghost->WeaponDamage, -1, -1, EWF_ROTATE);
						if (homing)
						{
							SetEWeaponLifespan(e, EWL_TIMER, 20);
							SetEWeaponDeathEffect(e, EWD_AIM_AT_LINK, 30);
						}
						else
						{
							SetEWeaponMovement(e, EWM_SINE_WAVE, 4, 8);
						}
						if (Link->Item[I_TOUGHMONSTERS] && k % 2 == 1)
						{
							eweapon e2 = FireEWeapon(EW_MAGIC, this->X, this->Y, DegtoRad(angle) - 0.6, 200, ghost->WeaponDamage, -1, -1, EWF_ROTATE);
							if (homing)
							{
								SetEWeaponLifespan(e2, EWL_TIMER, 20);
								SetEWeaponDeathEffect(e2, EWD_AIM_AT_LINK, 30);
							}
							else
							{
								SetEWeaponMovement(e2, EWM_SINE_WAVE, 4, 8);
							}
						}
						if (!Link->Item[I_TOUGHMONSTERS]) ++k;
						if (Link->Item[I_WEAKMONSTERS]) ++k;
						Game->PlaySound(SFX_WAND);
						for (i = 0; i < 40; ++i) 
						{
							int X = this->X + 8 + VectorX(14, angle);
							int Y = this->Y + 8 + VectorY(14, angle);
							//DrawComboAyy(3, X, Y, 5740, 1, 1, 6, 16, 16, X, Y, angle, -1, 0, true, 128);
							if (Link->Item[I_PROGRESSIVEGEAR]) DamageArea(ghost->WeaponDamage*2, X-8, Y-8, 1209 + AngleDirFixed8(angle), 7);
							else DamageArea(ghost->WeaponDamage*2, X-8, Y-8, 1209 + AngleDirFixed4(angle), 7);
							if (!homing)
							{
								++i;
								if (!Link->Item[I_WEAKMONSTERS]) ++i;
							}
							if (Link->Item[I_TOUGHMONSTERS]) ++i;
							if (!Link->Item[I_WEAKMONSTERS]) i+=2;
							Link_Waitframe(ghost, this, 0);
						}
					}
					if (Rand(2) == 0)
					{
						homing = false;
						if (Rand(2) == 0) homing = true;
						MirrorPartner->InitD[ML_ATTACK] = 9;
						Link_Transform(this, ghost, 0);
						do{
							int spawnpoint = FindSpawnPoint(true, false, false, false);
							XLoc = ComboX(spawnpoint);
							YLoc = ComboY(spawnpoint);
						}
						while(Distance(Link->X, Link->Y, GridX(XLoc), GridY(YLoc)) < 64);
						int angle = Angle(this->X, this->Y, XLoc, YLoc);
						while(Distance(this->X, this->Y, XLoc, YLoc) > 4){
							if (Link->Item[I_WEAKMONSTERS])
							{
								if (Link->Item[I_PROGRESSIVEGEAR]) Link_MoveAtAngle(this, angle, 1, true);
								else Link_MoveAt4Way(this, 2, XLoc, YLoc);
							}
							else if (!Link->Item[I_TOUGHMONSTERS])
							{
								if (Link->Item[I_PROGRESSIVEGEAR]) Link_MoveAtAngle(this, angle, 2, true);
								else Link_MoveAt4Way(this, 2, XLoc, YLoc);
							}
							else
							{
								if (Link->Item[I_PROGRESSIVEGEAR]) Link_MoveAtAngle(this, angle, 3, true);
								else Link_MoveAt4Way(this, 3, XLoc, YLoc);
							}
							angle = Angle(this->X, this->Y, XLoc, YLoc);
							Link_Waitframe(ghost, this, 1);
						}
						if (Link->Item[I_PARTNER])
						{
							while (MirrorPartner->InitD[ML_ATTACK] == 9)
							{
								Link_Transform(this, ghost, 1);
								Link_Waitframe(ghost, this, 1);
							}
						}
						MirrorPartner->InitD[ML_ATTACK] = 3;
						for (k = 0; k < 6; ++k)
						{
							int angle = Angle(this->X, this->Y, Link->X, Link->Y);
							if (!Link->Item[I_PROGRESSIVEGEAR]) angle = Dir4Angle(AngleDirFixed4(angle));
							ghost->Dir = AngleDirFixed4(angle)+8;
							Link_Transform(this, ghost, 4);
							for (i = 0; i < 40; ++i) 
							{
								int X = this->X + 8 + VectorX(14, angle);
								int Y = this->Y + 8 + VectorY(14, angle);
								//DrawComboAyy(3, X, Y, 5740, 1, 1, 6, 16, 16, X, Y, angle, -1, 0, true, 128);
								DamageArea(ghost->WeaponDamage*2, X-8, Y-8, 1209 + AngleDirFixed8(angle), 7);
								if (!homing)
								{
									++i;
									if (!Link->Item[I_WEAKMONSTERS]) ++i;
								}
								if (Link->Item[I_TOUGHMONSTERS]) ++i;
								if (!Link->Item[I_WEAKMONSTERS]) i+=2;
								Link_Waitframe(ghost, this, 0);
							}
							eweapon e;
							if (!Link->Item[I_TOUGHMONSTERS] || k % 2 == 0) e = FireEWeapon(EW_MAGIC, this->X, this->Y, DegtoRad(angle), 200, ghost->WeaponDamage, -1, -1, EWF_ROTATE);
							else e = FireEWeapon(EW_MAGIC, this->X, this->Y, DegtoRad(angle) + 0.6, 200, ghost->WeaponDamage, -1, -1, EWF_ROTATE);
							if (homing)
							{
								SetEWeaponLifespan(e, EWL_TIMER, 20);
								SetEWeaponDeathEffect(e, EWD_AIM_AT_LINK, 30);
							}
							else
							{
								SetEWeaponMovement(e, EWM_SINE_WAVE, 4, 8);
							}
							if (Link->Item[I_TOUGHMONSTERS] && k % 2 == 1)
							{
								eweapon e2 = FireEWeapon(EW_MAGIC, this->X, this->Y, DegtoRad(angle) - 0.6, 200, ghost->WeaponDamage, -1, -1, EWF_ROTATE);
								if (homing)
								{
									SetEWeaponLifespan(e2, EWL_TIMER, 20);
									SetEWeaponDeathEffect(e2, EWD_AIM_AT_LINK, 30);
								}
								else
								{
									SetEWeaponMovement(e2, EWM_SINE_WAVE, 4, 8);
								}
							}
							if (!Link->Item[I_TOUGHMONSTERS]) ++k;
							if (Link->Item[I_WEAKMONSTERS]) ++k;
							Game->PlaySound(SFX_WAND);
							for (i = 0; i < 40; ++i) 
							{
								int X = this->X + 8 + VectorX(14, angle);
								int Y = this->Y + 8 + VectorY(14, angle);
								//DrawComboAyy(3, X, Y, 5740, 1, 1, 6, 16, 16, X, Y, angle, -1, 0, true, 128);
								if (Link->Item[I_PROGRESSIVEGEAR]) DamageArea(ghost->WeaponDamage*2, X-8, Y-8, 1209 + AngleDirFixed8(angle), 7);
								else DamageArea(ghost->WeaponDamage*2, X-8, Y-8, 1209 + AngleDirFixed4(angle), 7);
								if (!homing)
								{
									++i;
									if (!Link->Item[I_WEAKMONSTERS]) ++i;
								}
								if (Link->Item[I_TOUGHMONSTERS]) ++i;
								if (!Link->Item[I_WEAKMONSTERS]) i+=2;
								Link_Waitframe(ghost, this, 0);
							}
						}
					}
				}
				if (Attack[2] == 1)
				{
					MirrorPartner->InitD[ML_ATTACK] = 4;
					for (k = 0; k < 16; ++k)
					{
						if (!Link->Item[I_TOUGHMONSTERS]) ++k;
						if (Link->Item[I_WEAKMONSTERS]) ++k;
						Link_Transform(this, ghost, 4);
						if (!Link->Item[I_TOUGHMONSTERS]) for (i = 0; i < 8; ++i) Link_Waitframe(ghost, this, 4);
						else for (i = 0; i < 6; ++i) Link_Waitframe(ghost, this, 4);
						if (Link->Item[I_WEAKMONSTERS]) for (i = 0; i < 8; ++i) Link_Waitframe(ghost, this, 4);
						int angle = Angle(this->X, this->Y, Link->X, Link->Y);
						if (!Link->Item[I_PROGRESSIVEGEAR]) angle = DirAngle(AngleDirFixed8(angle));
						eweapon e = FireEWeapon(EW_STATIONARYBOMB, this->X, this->Y, DegtoRad(angle), 300, ghost->WeaponDamage, 7, 21, EWF_NO_COLLISION);
						if (Link->Item[I_TOUGHMONSTERS] && Rand(5) <= 1) 
						{
							SetEWeaponMovement(e, EWM_THROW, 3, EWMF_DIE);
							SetEWeaponDeathEffect(e, EWD_EXPLODE, 16);
						}
						else if (!Link->Item[I_TOUGHMONSTERS]) SetEWeaponLifespan(e, EWL_SLOW_TO_HALT, Rand(3, 10));
						else SetEWeaponLifespan(e, EWL_SLOW_TO_HALT, Rand(2, 5));
						e->UseSprite(SP_EWSTATIONARYBOMB);
						e->CollDetection = 0;
						if (!Link->Item[I_TOUGHMONSTERS]) e->Misc[MISC_STATIONARYFUSE] = 210;
						else e->Misc[MISC_STATIONARYFUSE] = 210 + Rand(-30, 60);
						if (!Link->Item[I_TOUGHMONSTERS]) for (i = 0; i < 8; ++i) Link_Waitframe(ghost, this, 4);
						else for (i = 0; i < 6; ++i) Link_Waitframe(ghost, this, 4);
						if (Link->Item[I_WEAKMONSTERS]) for (i = 0; i < 8; ++i) Link_Waitframe(ghost, this, 4);
						if (Rand(2) == 0 && (k % 2 == 0 || k % 3 == 0))
						{
							MirrorPartner->InitD[ML_ATTACK] = 9;
							Link_Transform(this, ghost, 0);
							do{
								int spawnpoint = FindSpawnPoint(true, false, false, false);
								XLoc = ComboX(spawnpoint);
								YLoc = ComboY(spawnpoint);
							}
							while(Distance(Link->X, Link->Y, GridX(XLoc), GridY(YLoc)) < 64);
							int angle = Angle(this->X, this->Y, XLoc, YLoc);
							while(Distance(this->X, this->Y, XLoc, YLoc) > 4){
								if (Link->Item[I_WEAKMONSTERS])
								{
									if (Link->Item[I_PROGRESSIVEGEAR]) Link_MoveAtAngle(this, angle, 1, true);
									else Link_MoveAt4Way(this, 2, XLoc, YLoc);
								}
								else if (!Link->Item[I_TOUGHMONSTERS])
								{
									if (Link->Item[I_PROGRESSIVEGEAR]) Link_MoveAtAngle(this, angle, 2, true);
									else Link_MoveAt4Way(this, 2, XLoc, YLoc);
								}
								else
								{
									if (Link->Item[I_PROGRESSIVEGEAR]) Link_MoveAtAngle(this, angle, 3, true);
									else Link_MoveAt4Way(this, 3, XLoc, YLoc);
								}
								angle = Angle(this->X, this->Y, XLoc, YLoc);
								Link_Waitframe(ghost, this, 1);
							}
							if (Link->Item[I_PARTNER])
							{
								while (MirrorPartner->InitD[ML_ATTACK] == 9)
								{
									Link_Transform(this, ghost, 1);
									Link_Waitframe(ghost, this, 1);
								}
							}
							//else MirrorPartner->Data = 0;
						}
					}
				}
				if (Attack[2] == 2)
				{
					MirrorPartner->InitD[ML_ATTACK] = 5;
					Link_Transform(this, ghost, 1);
					if (!Link->Item[I_TOUGHMONSTERS]) for (i = 0; i < 30; ++i) Link_Waitframe(ghost, this, 2);
					if (Link->Item[I_WEAKMONSTERS]) for (i = 0; i < 20; ++i) Link_Waitframe(ghost, this, 2);
					Link_Transform(this, ghost, 4);
					int angle = Angle(this->X, this->Y, Link->X, Link->Y);
					if (!Link->Item[I_PROGRESSIVEGEAR]) angle = DirAngle(AngleDirFixed8(angle));
					Game->PlaySound(SFX_BRANG);
					int eggz[] = "bummerang";
					int sid = Game->GetFFCScript(eggz);
					ffc f;
					for ( int q = 1; q <= 32; ++q )
					{
						f = Screen->LoadFFC(q);
						if ( f->Script ) continue;
						if ( f->Data ) continue;
						if ( q )
						{
							f->Data = 1;
							f->Script = Game->GetFFCScript(eggz);
							f->X = this->X;
							f->Y = this->Y;
							f->Vx = VectorX(3, angle);
							f->Vy = VectorY(3, angle);
							break;
						}
					}
					for (i = 0; i < 10; ++i) Link_Waitframe(ghost, this, 4);
					if (Link->Item[I_TOUGHMONSTERS])
					{
						for (int m = 0; m < 2; ++m)
						{
							ffc f;
							for ( int q = 1; q <= 32; ++q )
							{
								f = Screen->LoadFFC(q);
								if ( f->Script ) continue;
								if ( f->Data ) continue;
								if ( q )
								{
									f->Data = 1;
									f->Script = Game->GetFFCScript(eggz);
									f->X = this->X;
									f->Y = this->Y;
									f->Vx = VectorX(3, angle);
									f->Vy = VectorY(3, angle);
									break;
								}
							}
							for (i = 0; i < 10; ++i) Link_Waitframe(ghost, this, 4);
						}
					}
					Link_Transform(this, ghost, 1);
					for (i = 0; i < 45; ++i) Link_Waitframe(ghost, this, 2);
				}
				Link_Transform(this, ghost, 1);
				if (!Link->Item[I_TOUGHMONSTERS])for (i = 0; i < 20; ++i) Link_Waitframe(ghost, this, 2);
				if (!Link->Item[I_WEAKMONSTERS])for (i = 0; i < 20; ++i) Link_Waitframe(ghost, this, 2);
				Attack[3] = Attack[2];
			}
			if (Attack[6] == 2)
			{
				do
				{
					Attack[4] = Rand(3);
				}
				while(Attack[4] == Attack[5]);
				if (Attack[4] == 0)
				{
					MirrorPartner->InitD[ML_ATTACK] = 6;
					for (i = 0; i < 10; ++i) Link_Waitframe(ghost, this, 2);
					int angle = Angle(this->X, this->Y, Link->X, Link->Y);
					if (!Link->Item[I_PROGRESSIVEGEAR]) angle = DirAngle(AngleDirFixed8(angle));
					ghost->Dir = AngleDirFixed4(angle)+8;
					Link_Transform(this, ghost, 4);
					for (i = 0; i < 400; i+=5)
					{
						if (i % 120 == 0 || (!Link->Item[I_WEAKMONSTERS] && i % 60 == 0) || (Link->Item[I_TOUGHMONSTERS] && i % 20 == 0)) 
						{
							if (Link->Item[I_WEAKMONSTERS]) FireBigEWeapon(EW_FIRE, this->X-8, this->Y-8, DegtoRad(angle), 50 + i, ghost->WeaponDamage, 166, -1, EWF_UNBLOCKABLE, 2, 2);
							else if (!Link->Item[I_TOUGHMONSTERS]) FireBigEWeapon(EW_FIRE, this->X-8, this->Y-8, DegtoRad(angle + Rand(-20, 20)), 50 + i, ghost->WeaponDamage, 166, -1, EWF_UNBLOCKABLE, 2, 2);
							else FireBigEWeapon(EW_FIRE, this->X-8, this->Y-8, DegtoRad(angle + Rand(-22, 22)), 50 + i, ghost->WeaponDamage, 166, -1, EWF_UNBLOCKABLE, 2, 2);
						}
						if (Link->Item[I_TOUGHMONSTERS]) i+=5;
						if (i > 300 && !Link->Item[I_TOUGHMONSTERS]) break;
						Link_Waitframe(ghost, this, 0);
					}
				}
				if (Attack[4] == 1)
				{
					MirrorPartner->InitD[ML_ATTACK] = 7;
					Link_Transform(this, ghost, 4);
					if (!Link->Item[I_TOUGHMONSTERS]) for (i = 0; i < 15; ++i) Link_Waitframe(ghost, this, 4);
					if (Link->Item[I_WEAKMONSTERS]) for (i = 0; i < 15; ++i) Link_Waitframe(ghost, this, 4);
					int angle = Angle(this->X, this->Y, Link->X, Link->Y);
					if (!Link->Item[I_PROGRESSIVEGEAR]) angle = Dir4Angle(AngleDirFixed4(angle));
					eweapon e = FireEWeapon(EW_MAGIC, this->X, this->Y, DegtoRad(angle), 300, ghost->WeaponDamage, 14, 21, EWF_NO_COLLISION);
					SetEWeaponLifespan(e, EWL_SLOW_TO_HALT, Rand(6, 10));
					SetEWeaponDeathEffect(e, EWD_RUN_SCRIPT, 57);
					for (i = 0; i < 15; ++i) Link_Waitframe(ghost, this, 4);
					Link_Transform(this, ghost, 1);
				}
				if (Attack[4] == 2)
				{
					MirrorPartner->InitD[ML_ATTACK] = 8;
					Link_Transform(this, ghost, 5);
					lweapon DarkItem = CreateLWeaponAt(LW_SPARKLE,this->X,this->Y);
					DarkItem->UseSprite(SP_LINK_POWAH);
					DarkItem->DrawYOffset = -16;
					for (i = 0; i < 60; ++i) 
					{
						Link_Waitframe(ghost, this, 4);
					}
					Link_Transform(this, ghost, 10);
					for (i = 0; i < 10; ++i) Link_Waitframe(ghost, this, 4);
					Link_Transform(this, ghost, 9);
					
					int eggz[] = "rocksfall";
					int sid = Game->GetFFCScript(eggz);
					ffc f;
					for ( int q = 1; q <= 32; ++q )
					{
						f = Screen->LoadFFC(q);
						if ( f->Script ) continue;
						if ( f->Data ) continue;
						if ( q )
						{
							f->Data = 1;
							f->Script = Game->GetFFCScript(eggz);
							f->X = this->X;
							f->Y = this->Y;
							break;
						}
					}
					
					if (Link->Item[I_WEAKMONSTERS]) for (i = 0; i < 90; ++i) Link_Waitframe(ghost, this, 4);
					else if (!Link->Item[I_TOUGHMONSTERS]) for (i = 0; i < 60; ++i) Link_Waitframe(ghost, this, 4);
					else for (i = 0; i < 30; ++i) Link_Waitframe(ghost, this, 4);
				}
				if (Link->Item[I_EXTRAENEMY])
				{
					Link_Transform(this, ghost, 4);
					for (i = 0; i < 15; ++i) Link_Waitframe(ghost, this, 4);
					Game->PlaySound(SFX_SUMMON);
					if (!Link->Item[I_WEAKMONSTERS]) CreateNPCAt(Choose(NPC_DARKNUT2, NPC_LYNEL2, NPC_WIZZROBE2), this->X, this->Y);
					else CreateNPCAt(Choose(NPC_DARKNUT1, NPC_LYNEL1, NPC_OCTOROCK2S), this->X, this->Y);
					if (Link->Item[I_TOUGHMONSTERS]) CreateNPCAt(Choose(NPC_DARKNUT2, NPC_LYNEL2, NPC_WIZZROBE2), this->X, this->Y);
					for (i = 0; i < 15; ++i) Link_Waitframe(ghost, this, 4);
				}
				Link_Transform(this, ghost, 3);
				if (!Link->Item[I_TOUGHMONSTERS]) for (i = 0; i < 60; ++i) Link_Waitframe(ghost, this, 4);
				if (Link->Item[I_WEAKMONSTERS]) for (i = 0; i < 30; ++i) Link_Waitframe(ghost, this, 4);
				Attack[5] = Attack[4];
			}
			if (Link->Item[I_NOHEARTS]) CreateItemAt(I_NEGAHEART, this->X, this->Y);
			++Attack[6];
			Attack[6]%=3;
			Link_Waitframe(ghost, this, 1);
		}
		MirrorPartner->InitD[ML_PHASE] = 1;
		Link_Transform(this, ghost, 7);
		ghost->CollDetection = false;
		ghost->BreakShield();
		Game->PlaySound(SFX_LINKHURT);
		for (i = 0; i < 60; ++i) Link_Waitframe(ghost, this, 0);
		Link_Transform(this, ghost, 5);
		lweapon DarkItem = CreateLWeaponAt(LW_SPARKLE,this->X,this->Y);
		DarkItem->UseSprite(SP_LINK_TRIFORCE);
		DarkItem->DrawYOffset = -16;
		for (i = 0; i < 60; ++i) Link_Waitframe(ghost, this, 0);
		int saveyoffset = ghost->DrawYOffset;
		for (i = 0; i < 60; ++i) 
		{
			if ((i % 4) < 2) ghost->DrawYOffset = -1000;
			else ghost->DrawYOffset = saveyoffset;
			Link_Waitframe(ghost, this, 0);
		}
		ghost->DrawYOffset = -1000;
		ghost->CollDetection = true;
		Attack[0] = 300;
		Attack[1] = Rand(360);
		Attack[2] = 45;
		Attack[3] = 0;
		Attack[4] = 0;
		Attack[5] = -1;
		int LinkCurHP = ghost->HP;
		Link_Transform(this, ghost, 6);
		int defense[18];
		Ghost_StoreDefenses(ghost, defense);
		//Ghost_SetDefenses(ghost, defense);
		Ghost_SetAllDefenses(ghost, NPCDT_IGNORE);
		ghost->Defense[NPCD_SWORD] = NPCDT_NONE;
		while(true)
		{
			if (Attack[0] > 0)
			{
				if (Link->Item[I_TOUGHMONSTERS] && Rand(2) == 0) --Attack[0];
				if (Attack[0] % 30 == 0) 
				{
					if (!Link->Item[I_TOUGHMONSTERS]) Attack[2]-=3;
				}
				if(((Attack[0] % Attack[2]) < 4 && !Link->Item[I_TOUGHMONSTERS]) || (Attack[0] % Attack[2]) < 2)
				{
					ghost->DrawYOffset = saveyoffset;
				}
				else 
				{
					ghost->Dir = Rand(4);
					ghost->DrawYOffset = -1000;
					if (Attack[3] == 0)
					{
						this->X = 120 + VectorX(80, Attack[1]);
						this->Y = 80 + VectorY(40, Attack[1]*2);
						Attack[1] += 2;
					}
					else
					{
						int Vx = VectorX(2, Attack[1]);
						int Vy = VectorY(2, Attack[1]);
						bool anglechanged = false;
						if ((Vx < 0 && !CanWalk(this->X, this->Y, DIR_LEFT, 2, false)) || (Vx > 0 && !CanWalk(this->X, this->Y, DIR_RIGHT, 2, false))) {Vx = -Vx; anglechanged = true;}
						if ((Vy < 0 && !CanWalk(this->X, this->Y, DIR_UP, 2, false)) || (Vy > 0 && !CanWalk(this->X, this->Y, DIR_DOWN, 2, false))) {Vy = -Vy; anglechanged = true;}
						if (anglechanged) Attack[1] = Angle(0, 0, Vx, Vy);
						Link_MoveAtAngle(this, Attack[1], 1.5);
					}
				}
			}
			else
			{
				Ghost_SetDefenses(ghost, defense);
				ghost->DrawYOffset = saveyoffset;
				Link_Transform(this, ghost, 3);
				for (i = 0; i < 30; ++i) Link_Waitframe(ghost, this, 2);
				Link_Transform(this, ghost, 4);
				int angle = Angle(this->X, this->Y, Link->X, Link->Y);
				if (!Link->Item[I_PROGRESSIVEGEAR]) angle = DirAngle(AngleDirFixed8(angle));
				eweapon e = FireEWeapon(EW_LINKSHADOW, this->X, this->Y, DegtoRad(angle), 150, ghost->WeaponDamage, 167, 40, EWF_NO_COLLISION);
				SetEWeaponLifespan(e, EWL_TIMER, 300);
				SetEWeaponDeathEffect(e, EWD_4_FIREBALLS_HV, 17);
				if (!Link->Item[I_WEAKMONSTERS])
				{
					eweapon e2 = FireEWeapon(EW_LINKSHADOW, this->X, this->Y, DegtoRad(angle)+0.8, 150, ghost->WeaponDamage, 167, 40, EWF_NO_COLLISION);
					SetEWeaponLifespan(e2, EWL_TIMER, 300);
					SetEWeaponDeathEffect(e2, EWD_4_FIREBALLS_HV, 17);
					eweapon e3 = FireEWeapon(EW_LINKSHADOW, this->X, this->Y, DegtoRad(angle)-0.8, 150, ghost->WeaponDamage, 167, 40, EWF_NO_COLLISION);
					SetEWeaponLifespan(e3, EWL_TIMER, 300);
					SetEWeaponDeathEffect(e3, EWD_4_FIREBALLS_HV, 17);
					if (Link->Item[I_TOUGHMONSTERS])
					{
						e->Step = 250;
						e2->Step = 250;
						e3->Step = 250;
					}
				}
				for (i = 0; i < 60; ++i) 
				{
					Link_Waitframe(ghost, this, 0);
					if (Link->Item[I_TOUGHMONSTERS]) ++i;
					if (!Link->Item[I_WEAKMONSTERS]) ++i;
				}
				if (Link->Item[I_EXTRAENEMY])
				{
					Link_Transform(this, ghost, 4);
					for (i = 0; i < 15; ++i) Link_Waitframe(ghost, this, 4);
					Game->PlaySound(SFX_SUMMON);
					if (!Link->Item[I_WEAKMONSTERS]) CreateNPCAt(Choose(NPC_DARKNUT2, NPC_LYNEL2, NPC_WIZZROBE2), this->X, this->Y);
					else CreateNPCAt(Choose(NPC_DARKNUT1, NPC_LYNEL1, NPC_OCTOROCK2S), this->X, this->Y);
					if (Link->Item[I_TOUGHMONSTERS]) CreateNPCAt(Choose(NPC_DARKNUT2, NPC_LYNEL2, NPC_WIZZROBE2), this->X, this->Y);
					for (i = 0; i < 15; ++i) Link_Waitframe(ghost, this, 4);
				}
				Link_Transform(this, ghost, 3);
				for (i = 0; i < 90; ++i) 
				{
					if ((i % 4) < 2) ghost->DrawYOffset = -1000;
					else ghost->DrawYOffset = saveyoffset;
					if (Link->Item[I_TOUGHMONSTERS] && i > 30) break;
					if (!Link->Item[I_WEAKMONSTERS] && i > 60) break;
					Link_Waitframe(ghost, this, 0);
				}
				if (Link->Item[I_NOHEARTS]) CreateItemAt(I_NEGAHEART, this->X, this->Y);
				Attack[0] = 300;
				Attack[1] = (Rand(4) * 90) + 45;
				Attack[2] = 60;
				Attack[3] = Rand(2);
				do
				{
					Attack[4] = Rand(1, 3);
				}while(Attack[4] == Attack[5]);
				int spawnpoint = FindSpawnPoint(true, false, false, false);
				this->X = ComboX(spawnpoint);
				this->Y = ComboY(spawnpoint);
				LinkCurHP = ghost->HP;
				Ghost_SetAllDefenses(ghost, NPCDT_IGNORE);
				ghost->Defense[NPCD_SWORD] = NPCDT_NONE;
			}
			--Attack[0];
			if (LinkCurHP > ghost->HP)
			{
				Ghost_SetDefenses(ghost, defense);
				Link_Transform(this, ghost, 7);
				ghost->DrawYOffset = saveyoffset;
				for (i = 0; i < 30; ++i) Link_Waitframe(ghost, this, 0);
				Link_Transform(this, ghost, 6);
				ghost->DrawYOffset = -1000;
				Attack[0] = 300;
				Attack[1] = (Rand(4) * 90) + 45;
				Attack[2] = 60;
				Attack[3] = Rand(2);
				do
				{
					Attack[4] = Rand(1, 3);
				}while(Attack[4] == Attack[5]);
				int spawnpoint = FindSpawnPoint(true, false, false, false);
				this->X = ComboX(spawnpoint);
				this->Y = ComboY(spawnpoint);
				Ghost_SetAllDefenses(ghost, NPCDT_IGNORE);
				ghost->Defense[NPCD_SWORD] = NPCDT_NONE;
			}
			if (Attack[4] > 0)
			{
				Ghost_SetDefenses(ghost, defense);
				Link_Transform(this, ghost, 3);
				for (i = 0; i < 90; ++i) 
				{
					if (Link->Item[I_TOUGHMONSTERS] && i > 30) break;
					if (!Link->Item[I_WEAKMONSTERS] && i > 60) break;
					if ((i % 4) < 2) ghost->DrawYOffset = -1000;
					else ghost->DrawYOffset = saveyoffset;
					Link_Waitframe(ghost, this, 2);
				}
				ghost->DrawYOffset = saveyoffset;
				if (Attack[4] == 1)
				{
					int angle = Angle(this->X, this->Y, Link->X, Link->Y);
					if (!Link->Item[I_PROGRESSIVEGEAR]) angle = DirAngle(AngleDirFixed8(angle));
					ghost->Dir = AngleDirFixed4(angle);
					Link_Transform(this, ghost, 4);
					for (i = 0; i < 400; i+=5)
					{
						if (i % 120 == 0 || (!Link->Item[I_WEAKMONSTERS] && i % 60 == 0) || (Link->Item[I_TOUGHMONSTERS] && i % 20 == 0)) 
						{
							if (Link->Item[I_WEAKMONSTERS]) FireBigEWeapon(EW_FIRE, this->X-8, this->Y-8, DegtoRad(angle), 50 + i, ghost->WeaponDamage, 166, -1, EWF_UNBLOCKABLE, 2, 2);
							else if (!Link->Item[I_TOUGHMONSTERS]) FireBigEWeapon(EW_FIRE, this->X-8, this->Y-8, DegtoRad(angle + Rand(-20, 20)), 50 + i, ghost->WeaponDamage, 166, -1, EWF_UNBLOCKABLE, 2, 2);
							else FireBigEWeapon(EW_FIRE, this->X-8, this->Y-8, DegtoRad(angle + Rand(-22, 22)), 50 + i, ghost->WeaponDamage, 166, -1, EWF_UNBLOCKABLE, 2, 2);
						}
						if (Link->Item[I_TOUGHMONSTERS]) i+=5;
						if (i > 300 && !Link->Item[I_TOUGHMONSTERS]) break;
						Link_Waitframe(ghost, this, 0);
					}
				}
				if (Attack[4] == 2)
				{
					for (k = 0; k < 16; ++k)
					{
						if (!Link->Item[I_TOUGHMONSTERS]) ++k;
						if (Link->Item[I_WEAKMONSTERS]) k+=2;
						Link_Transform(this, ghost, 4);
						if (!Link->Item[I_TOUGHMONSTERS]) for (i = 0; i < 8; ++i) Link_Waitframe(ghost, this, 4);
						else for (i = 0; i < 6; ++i) Link_Waitframe(ghost, this, 4);
						if (Link->Item[I_WEAKMONSTERS]) for (i = 0; i < 8; ++i) Link_Waitframe(ghost, this, 4);
						int angle = Angle(this->X, this->Y, Link->X, Link->Y);
						if (!Link->Item[I_PROGRESSIVEGEAR]) angle = DirAngle(AngleDirFixed8(angle));
						eweapon e = FireEWeapon(EW_STATIONARYBOMB, this->X, this->Y, DegtoRad(angle), 300, ghost->WeaponDamage, 7, 21, EWF_NO_COLLISION);
						if (Link->Item[I_TOUGHMONSTERS] && Rand(5) <= 1) 
						{
							SetEWeaponMovement(e, EWM_THROW, 3, EWMF_DIE);
							SetEWeaponDeathEffect(e, EWD_EXPLODE, 16);
						}
						else if (!Link->Item[I_TOUGHMONSTERS]) SetEWeaponLifespan(e, EWL_SLOW_TO_HALT, Rand(3, 10));
						else SetEWeaponLifespan(e, EWL_SLOW_TO_HALT, Rand(2, 5));
						e->UseSprite(SP_EWSTATIONARYBOMB);
						e->CollDetection = 0;
						if (!Link->Item[I_TOUGHMONSTERS]) e->Misc[MISC_STATIONARYFUSE] = 210;
						else e->Misc[MISC_STATIONARYFUSE] = 210 + Rand(-30, 60);
						if (!Link->Item[I_TOUGHMONSTERS]) for (i = 0; i < 8; ++i) Link_Waitframe(ghost, this, 4);
						else for (i = 0; i < 6; ++i) Link_Waitframe(ghost, this, 4);
						if (Link->Item[I_WEAKMONSTERS]) for (i = 0; i < 8; ++i) Link_Waitframe(ghost, this, 4);
					}
				}
				if (Attack[4] == 3)
				{
					bool homing = false;
					if (Rand(2) == 0) homing = true;
					for (k = 0; k < 6; ++k)
					{
						int angle = Angle(this->X, this->Y, Link->X, Link->Y);
						if (!Link->Item[I_PROGRESSIVEGEAR]) angle = Dir4Angle(AngleDirFixed4(angle));
						ghost->Dir = AngleDirFixed4(angle)+8;
						Link_Transform(this, ghost, 4);
						for (i = 0; i < 40; ++i) 
						{
							int X = this->X + 8 + VectorX(14, angle);
							int Y = this->Y + 8 + VectorY(14, angle);
							//DrawComboAyy(3, X, Y, 5740, 1, 1, 6, 16, 16, X, Y, angle, -1, 0, true, 128);
							if (Link->Item[I_PROGRESSIVEGEAR]) DamageArea(ghost->WeaponDamage*2, X-8, Y-8, 1209 + AngleDirFixed8(angle), 7);
							else DamageArea(ghost->WeaponDamage*2, X-8, Y-8, 1209 + AngleDirFixed4(angle), 7);
							if (!homing) ++i;
							if (Link->Item[I_WEAKMONSTERS] && !homing) ++i;
							if (!Link->Item[I_WEAKMONSTERS]) i+=2;
							if (Link->Item[I_TOUGHMONSTERS]) ++i;
							Link_Waitframe(ghost, this, 0);
						}
						eweapon e;
						if (!Link->Item[I_TOUGHMONSTERS] || k % 2 == 0) e = FireEWeapon(EW_MAGIC, this->X, this->Y, DegtoRad(angle), 200, ghost->WeaponDamage, -1, -1, EWF_ROTATE);
						else e = FireEWeapon(EW_MAGIC, this->X, this->Y, DegtoRad(angle) + 0.6, 200, ghost->WeaponDamage, -1, -1, EWF_ROTATE);
						if (homing)
						{
							SetEWeaponLifespan(e, EWL_TIMER, 20);
							SetEWeaponDeathEffect(e, EWD_AIM_AT_LINK, 30);
						}
						else
						{
							SetEWeaponMovement(e, EWM_SINE_WAVE, 4, 8);
						}
						if (Link->Item[I_TOUGHMONSTERS] && k % 2 == 1)
						{
							eweapon e2 = FireEWeapon(EW_MAGIC, this->X, this->Y, DegtoRad(angle) - 0.6, 200, ghost->WeaponDamage, -1, -1, EWF_ROTATE);
							if (homing)
							{
								SetEWeaponLifespan(e2, EWL_TIMER, 20);
								SetEWeaponDeathEffect(e2, EWD_AIM_AT_LINK, 30);
							}
							else
							{
								SetEWeaponMovement(e2, EWM_SINE_WAVE, 4, 8);
							}
						}
						if (!Link->Item[I_TOUGHMONSTERS]) ++k;
						if (Link->Item[I_WEAKMONSTERS]) ++k;
						Game->PlaySound(SFX_WAND);
						for (i = 0; i < 40; ++i) 
						{
							int X = this->X + 8 + VectorX(14, angle);
							int Y = this->Y + 8 + VectorY(14, angle);
							//DrawComboAyy(3, X, Y, 5740, 1, 1, 6, 16, 16, X, Y, angle, -1, 0, true, 128);
							if (Link->Item[I_PROGRESSIVEGEAR]) DamageArea(ghost->WeaponDamage*2, X-8, Y-8, 1209 + AngleDirFixed8(angle), 7);
							else DamageArea(ghost->WeaponDamage*2, X-8, Y-8, 1209 + AngleDirFixed4(angle), 7);
							if (!homing) ++i;
							if (Link->Item[I_WEAKMONSTERS] && !homing) ++i;
							if (!Link->Item[I_WEAKMONSTERS]) i+=2;
							if (Link->Item[I_TOUGHMONSTERS]) ++i;
							Link_Waitframe(ghost, this, 0);
						}
					}
				}
				if (Link->Item[I_EXTRAENEMY])
				{
					Link_Transform(this, ghost, 4);
					for (i = 0; i < 15; ++i) Link_Waitframe(ghost, this, 4);
					Game->PlaySound(SFX_SUMMON);
					if (!Link->Item[I_WEAKMONSTERS]) CreateNPCAt(Choose(NPC_DARKNUT2, NPC_LYNEL2, NPC_WIZZROBE2), this->X, this->Y);
					else CreateNPCAt(Choose(NPC_DARKNUT1, NPC_LYNEL1, NPC_OCTOROCK2S), this->X, this->Y);
					if (Link->Item[I_TOUGHMONSTERS]) CreateNPCAt(Choose(NPC_DARKNUT2, NPC_LYNEL2, NPC_WIZZROBE2), this->X, this->Y);
					for (i = 0; i < 15; ++i) Link_Waitframe(ghost, this, 4);
				}
				Link_Transform(this, ghost, 3);
				for (i = 0; i < 90; ++i) 
				{
					if (Link->Item[I_TOUGHMONSTERS] && i > 30) break;
					if (!Link->Item[I_WEAKMONSTERS] && i > 60) break;
					if ((i % 4) < 2) ghost->DrawYOffset = -1000;
					else ghost->DrawYOffset = saveyoffset;
					Link_Waitframe(ghost, this, 0);
				}
				if (Link->Item[I_NOHEARTS]) CreateItemAt(I_NEGAHEART, this->X, this->Y);
				ghost->DrawYOffset = -1000;
				Attack[4] = 0;
				Ghost_SetAllDefenses(ghost, NPCDT_IGNORE);
				ghost->Defense[NPCD_SWORD] = NPCDT_NONE;
				Attack[5] = Attack[4];
			}
			LinkCurHP = ghost->HP;
			ghost->Stun = 8;
			Link_Waitframe(ghost, this, 0);
		}
		
	}
	bool Link_Waitframe(npc ghost, ffc this, int Autoface)
	{
		if (ghost->isValid() && ghost->HP > 0)
		{
			if (Link->Item[I_TOUGHMONSTERS] && ghost->Misc[MISC_TOUGHENEMY] < 1)
			{
				ghost->Damage = ghost->Damage + 4;
				ghost->WeaponDamage = ghost->WeaponDamage + 2;
				ghost->Misc[MISC_TOUGHENEMY] = 1;
			}
			if (!Link->Item[I_TOUGHMONSTERS] && ghost->Misc[MISC_TOUGHENEMY] == 1)
			{
				ghost->Damage = ghost->Damage - 4;
				ghost->WeaponDamage = ghost->WeaponDamage - 2;
				ghost->Misc[MISC_TOUGHENEMY] = 0;
			}
			if (!Link->Item[I_WEAKMONSTERS] && ghost->Misc[MISC_TOUGHENEMY] == 2)
			{
				ghost->Damage = ghost->Damage + 4;
				ghost->WeaponDamage = ghost->WeaponDamage + 2;
				ghost->HP *= 2;
				ghost->Misc[MISC_TOUGHENEMY] = 0;
			}
			ghost->X = Round(this->X);
			ghost->Y = Round(this->Y);
			if (Autoface == 1) ghost->Dir = AngleDirFixed4(Angle(this->InitD[ML_LASTX], this->InitD[ML_LASTY], this->X, this->Y));
			if (Autoface == 2) ghost->Dir = AngleDirFixed4(Angle(ghost->X, ghost->Y, Link->X, Link->Y)); //Face Zelda
			if (Autoface == 3) ghost->Dir = AngleDirFixed4(Angle(this->InitD[ML_LASTX], this->InitD[ML_LASTY], this->X, this->Y)) + 8;
			if (Autoface == 4) ghost->Dir = AngleDirFixed4(Angle(ghost->X, ghost->Y, Link->X, Link->Y)) + 8; //Face Zelda No Shield
			if (Autoface == 5) ghost->Dir = (ghost->Dir % 4) + 8; //No Shield
			this->InitD[ML_LASTX] = this->X;
			this->InitD[ML_LASTY] = this->Y;
			if (Link->Item[I_HEARTRING1])
			{
				++this->InitD[ML_TIMER];
				this->InitD[ML_TIMER]%=728;
				if (Link->Item[I_TOUGHMONSTERS]) this->InitD[ML_TIMER]%=364;
				if (this->InitD[ML_TIMER] == 0) 
				{
					ghost->HP += 4;
					if (Link->Item[I_TOUGHMONSTERS]) ghost->HP += 4;
				}
			}
			if (ghost->HP > 256) ghost->HP = 256;
			if ((ghost->HP <= 128 && !Link->Item[I_WEAKMONSTERS]) || ghost->HP <= 64) this->InitD[ML_PHASE] = 1;
			if (this->InitD[ML_PHASE] <= 0) ghost->Stun = 0;
			if (Link->Item[I_SHIELD1] && ghost->CollDetection == true && ghost->DrawYOffset >= -4 && this->InitD[ML_STATE] <= 4)
			{
				lweapon sword = LoadLWeaponOf(LW_SWORD);
				if (sword->isValid())
				{
					if (sword->Dir != (ghost->Dir % 4)) 
					{
						ghost->Defense[NPCD_SWORD] = NPCDT_BLOCK8;
						ghost->Defense[NPCD_SCRIPT] = NPCDT_BLOCK;
					}
				}
				else if (ghost->Defense[NPCD_SWORD] == NPCDT_BLOCK8) 
				{
					ghost->Defense[NPCD_SWORD] = NPCDT_NONE;
					ghost->Defense[NPCD_SCRIPT] = NPCDT_NONE;
				}
				for(int i = Screen->NumLWeapons(); i > 0; --i)
				{
					lweapon FFCrandoLW = Screen->LoadLWeapon(i);
					if(!FFCrandoLW->isValid()) continue;
					if (FFCrandoLW->ID != LW_CANEOFBYRNA && FFCrandoLW->ID != LW_BAIT)
					{
						if (FFCrandoLW->X > this->X - 14 && FFCrandoLW->X < this->X + 14 && FFCrandoLW->Y > this->Y - 14 && FFCrandoLW->Y < this->Y+14 && FFCrandoLW->CollDetection == true)
						{
							if(FFCrandoLW->Dir != (ghost->Dir % 4))
							{
								Remove(FFCrandoLW);
								Game->PlaySound(SFX_CLINK);
							}
						}
					}
				}
				for (int i = 0; i < 4; ++i) 
				{
					if (i != OppositeDir(ghost->Dir % 4)) 
					{
						if (i != (ghost->Dir % 4) || this->InitD[ML_STATE] >= 2) DrawArea(this->X, this->Y, 1270 + i*2, 6);
					}
				}
			}
			if (Link->Item[I_PERILRING2])
			{
				for (int i = 0; i < 18; ++i)
				{
					if (i != NPCD_SBOMB && ghost->Defense[i] == NPCDT_NONE) ghost->Defense[i] = NPCDT_HALFDAMAGE;
				}
			}
			else
			{
				for (int i = 0; i < 18; ++i)
				{
					if (i != NPCD_SBOMB && ghost->Defense[i] == NPCDT_HALFDAMAGE) ghost->Defense[i] = NPCDT_NONE;
				}
			}
			ghost->OriginalTile = this->InitD[ML_ODATA] + (this->InitD[ML_STATE]*20) + (ghost->Dir % 4)*2;
			ghost->Tile = this->InitD[ML_ODATA] + (this->InitD[ML_STATE]*20) + (ghost->Tile % 2) + (ghost->Dir % 4)*2;
			Waitframe();
			return true;
		}
		else if (ghost->isValid())
		{
			ghost->DrawYOffset = 0;
			ghost->HP = 1;
			Link_Transform(this, ghost, 11);
			int timer = 120;
			Ghost_SetAllDefenses(ghost, NPCDT_IGNORE);
			ghost->Defense[NPCD_BRANG] = NPCDT_NONE;
			while (ghost->HP > 0 && timer > 0)
			{
				ghost->Dir = DIR_DOWN;
				ghost->X = Round(this->X);
				ghost->Y = Round(this->Y);
				this->InitD[ML_LASTX] = this->X;
				this->InitD[ML_LASTY] = this->Y;
				--timer;
				ghost->Stun = 8;
				Waitframe();
			}
			if (timer > 0)
			{
				ghost->HP = 1;
				Link_Transform(this, ghost, 12);
				Ghost_SetAllDefenses(ghost, NPCDT_IGNORE);
				Game->PlayMIDI(0);
				for(int i = 0; i < 90; ++i)
				{
					ghost->Dir = DIR_DOWN;
					ghost->OriginalTile = this->InitD[ML_ODATA] + (this->InitD[ML_STATE]*20) + (ghost->Dir % 4)*2;
					ghost->Tile = this->InitD[ML_ODATA] + (this->InitD[ML_STATE]*20) + (ghost->Tile % 2) + (ghost->Dir % 4)*2;
					ghost->X = Round(this->X);
					ghost->Y = Round(this->Y);
					this->InitD[ML_LASTX] = this->X;
					this->InitD[ML_LASTY] = this->Y;
					ghost->Stun = 8;
					ghost->HP = 1;
					Waitframe();
				}
				Link_Transform(this, ghost, 3);
				Game->PlaySound(SFX_SPIRAL);
				for(int i = 0; i < 120; ++i)
				{
					ghost->Dir = Floor(i/4)%4;
					ghost->OriginalTile = this->InitD[ML_ODATA] + (this->InitD[ML_STATE]*20) + (ghost->Dir % 4)*2;
					ghost->Tile = this->InitD[ML_ODATA] + (this->InitD[ML_STATE]*20) + (ghost->Tile % 2) + (ghost->Dir % 4)*2;
					ghost->X = Round(this->X);
					ghost->Y = Round(this->Y);
					this->InitD[ML_LASTX] = this->X;
					this->InitD[ML_LASTY] = this->Y;
					ghost->Stun = 8;
					ghost->HP = 1;
					Waitframe();
				}
				for(int i = 0; i < 45; ++i)
				{
					ghost->Dir = DIR_DOWN;
					ghost->OriginalTile = this->InitD[ML_ODATA] + (this->InitD[ML_STATE]*20) + (ghost->Dir % 4)*2;
					ghost->Tile = this->InitD[ML_ODATA] + (this->InitD[ML_STATE]*20) + (ghost->Tile % 2) + (ghost->Dir % 4)*2;
					ghost->X = Round(this->X);
					ghost->Y = Round(this->Y);
					this->InitD[ML_LASTX] = this->X;
					this->InitD[ML_LASTY] = this->Y;
					ghost->Stun = 8;
					ghost->HP = 1;
					Waitframe();
				}
				Game->PlaySound(SFX_MSG);
				lweapon death = CreateLWeaponAt(LW_SPARKLE,ghost->X,ghost->Y);
				death->UseSprite(SP_MISC_DEATH);
				ghost->HP = 0;
				for (int i = Screen->NumNPCs(); i > 0; --i)
				{
					npc n = Screen->LoadNPC(i);
					if (n->isValid()) n->HP = 0;
				}
				Quit();
				
			}
			else
			{
				ghost->HP = 48;
				Link_Transform(this, ghost, 11);
			}
		}
		else
		{
			Quit();
		}
	}
	void Link_MoveAtAngle(ffc this, int angle, int step)
	{
		if ((VectorX(step, angle) < 0 && CanWalk(this->X, this->Y, DIR_LEFT, step, false)) || (VectorX(step, angle) > 0 && CanWalk(this->X, this->Y, DIR_RIGHT, step, false)))
		{
			this->X += VectorX(step, angle);
		}
		if ((VectorY(step, angle) < 0 && CanWalk(this->X, this->Y, DIR_UP, step, false)) || (VectorY(step, angle) > 0 && CanWalk(this->X, this->Y, DIR_DOWN, step, false)))
		{
			this->Y += VectorY(step, angle);
		}
	}
	void Link_MoveAtAngle(ffc this, int angle, int step, bool ignoresolids)
	{
		if (!ignoresolids)
		{
			if ((VectorX(step, angle) < 0 && CanWalk(this->X, this->Y, DIR_LEFT, step, false)) || (VectorX(step, angle) > 0 && CanWalk(this->X, this->Y, DIR_RIGHT, step, false)))
			{
				this->X += VectorX(step, angle);
			}
			if ((VectorY(step, angle) < 0 && CanWalk(this->X, this->Y, DIR_UP, step, false)) || (VectorY(step, angle) > 0 && CanWalk(this->X, this->Y, DIR_DOWN, step, false)))
			{
				this->Y += VectorY(step, angle);
			}
		}
		else
		{
			this->X += VectorX(step, angle);
			this->Y += VectorY(step, angle);
		}
	}
	void Link_MoveAt4Way(ffc this, int step, int X, int Y)
	{
		if (this->X != X && (this->Y == Y || Abs(this->X - X) < Abs(this->Y - Y))) 
		{
			if (Abs(this->X - X) < step) this->X = X;
			else
			{
				if (this->X < X) this->X += step;
				if (this->X > X) this->X -= step;
			}
		}
		if (this->Y != Y && (this->X == X || Abs(this->Y - Y) < Abs(this->X - X))) 
		{
			if (Abs(this->Y - Y) < step) this->Y = Y;
			else
			{
				if (this->Y < Y) this->Y += step;
				if (this->Y > Y) this->Y -= step;
			}
		}
	}
	void Link_MoveTowardsLink(ffc this, int step)
	{
		int angle = Angle(this->X, this->Y, Link->X, Link->Y);
		Link_MoveAtAngle(this, angle, step);
	}
	void Link_Transform(ffc this, npc ghost, int state)
	{
		ghost->OriginalTile = this->InitD[ML_ODATA] + (state*20) + (ghost->Dir % 4)*2;
		ghost->Tile = this->InitD[ML_ODATA] + (state*20) + (ghost->Tile % 2) + (ghost->Dir % 4)*2;
		this->InitD[ML_STATE] = state;
	}
	void DamageArea(int damage, int x, int y)
	{
		eweapon e = FireEWeapon(EW_LINKWEAPONS, x, y, 0, 0, damage, -1, -1, EWF_UNBLOCKABLE);
		e->Dir = Link->Dir;
		e->DrawYOffset = -1000;
		SetEWeaponLifespan(e, EWL_TIMER, 1);
		SetEWeaponDeathEffect(e, EWD_VANISH, 0);
	}
	void DamageArea(int damage, int x, int y, int tile, int cset)
	{
		eweapon e = FireEWeapon(EW_LINKWEAPONS, x, y, 0, 0, damage, -1, -1, EWF_UNBLOCKABLE);
		e->Dir = Link->Dir;
		//e->DrawYOffset = -1000;
		e->Tile = tile;
		e->OriginalTile = tile;
		e->CSet = cset;
		SetEWeaponLifespan(e, EWL_TIMER, 1);
		SetEWeaponDeathEffect(e, EWD_VANISH, 0);
	}
	void DrawArea(int x, int y, int tile, int cset)
	{
		eweapon e = FireEWeapon(EW_LINKWEAPONS, x, y, 0, 0, 0, -1, -1, EWF_NO_COLLISION);
		e->Dir = Link->Dir;
		//e->DrawYOffset = -1000;
		e->Tile = tile;
		e->OriginalTile = tile;
		e->CSet = cset;
		SetEWeaponLifespan(e, EWL_TIMER, 1);
		SetEWeaponDeathEffect(e, EWD_VANISH, 0);
	}
	void DrawComboAyy(int layer, int cx, int cy, int tile, int blockw, int blockh, int cset, int xscale, int yscale, int rx, int ry, int rangle, int frame, int flip, bool transparency, int opacity){
		int w = xscale;
		if(xscale==-1)
			w = blockw*16;
		int h = yscale;
		if(yscale==-1)
			h = blockh*16;
		Screen->DrawCombo(layer, cx-w/2, cy-h/2, tile, blockw, blockh, cset, xscale, yscale, rx-w/2, ry-h/2, rangle, frame, flip, transparency, opacity);
	}
}

int AngleDirFixed4(float angle) 
{
	while(angle > 180) angle-=360;
	while(angle < -180) angle+=360;
	if (angle <= 135 && angle > 45)
		return DIR_DOWN;
	else if (angle <= 45 && angle > -45)
		return DIR_RIGHT;
	else if (angle <= -45 && angle > -135)
		return DIR_UP;
	else
		return DIR_LEFT;
}

int AngleDirFixed8(float angle) 
{
	while(angle > 180) angle-=360;
	while(angle < -180) angle+=360;
	if (angle <= 157.5 && angle > 112.5)
		return DIR_LEFTDOWN;
	else if (angle <= 112.5 && angle > 67.5)
		return DIR_DOWN;
	else if (angle <= 67.5 && angle > 22.5)
		return DIR_RIGHTDOWN;
	else if (angle <= 22.5 && angle > -22.5)
		return DIR_RIGHT;
	else if (angle <= -22.5 && angle > -67.5)
		return DIR_RIGHTUP;
	else if (angle <= -67.5 && angle > -112.5)
		return DIR_UP;
	else if (angle <= -112.5 && angle > -157.5)
		return DIR_LEFTUP;
	else
		return DIR_LEFT;
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Mirror Link (End)
// By Dimi
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Mirror Link's whirlwind attack "Whirlwhat" (Start)
// By Dimi
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
ffc script whirlwhat
{
	void run()
	{
		int leafangle = 0;
		int i;
		eweapon leaves[2];
		for (i = 0; i < 2; ++i)
		{
			leaves[i] = Screen->CreateEWeapon(EW_MAGIC);
			leaves[i]->Damage = 16;
			leaves[i]->X = this->X;
			leaves[i]->Y = this->Y;
			leaves[i]->DrawXOffset = VectorX(0, (leafangle - (180 * i)) % 360);
			leaves[i]->DrawYOffset = VectorY(0, (leafangle - (180 * i)) % 360);
			leaves[i]->HitXOffset = VectorX(0, (leafangle - (180 * i)) % 360);
			leaves[i]->HitYOffset = VectorY(0, (leafangle - (180 * i)) % 360);
			leaves[i]->UseSprite(SP_WHIRL);
			leaves[i]->Dir = 8;
		}
		for (i = 0; i < 256; ++i)
		{
			leafangle += 2;
			leafangle %= 360;
			for (int k = 0; k < 2; ++k)
			{
				if (leaves[k]->isValid())
				{
					if (!Link->Item[I_PROGRESSIVEGEAR])
					{
						leaves[k]->X = this->X;
						leaves[k]->Y = this->Y;
						leaves[k]->DrawXOffset = VectorX(i-(i%8), ((leafangle - (leafangle%16)) - (180 * k)) % 360);
						leaves[k]->DrawYOffset = VectorY(i-(i%8), ((leafangle - (leafangle%16)) - (180 * k)) % 360);
						leaves[k]->HitXOffset = VectorX(i-(i%8), ((leafangle - (leafangle%16)) - (180 * k)) % 360);
						leaves[k]->HitYOffset = VectorY(i-(i%8), ((leafangle - (leafangle%16)) - (180 * k)) % 360);
					}
					else
					{
						leaves[k]->X = this->X;
						leaves[k]->Y = this->Y;
						leaves[k]->DrawXOffset = VectorX(i, (leafangle - (180 * k)) % 360);
						leaves[k]->DrawYOffset = VectorY(i, (leafangle - (180 * k)) % 360);
						leaves[k]->HitXOffset = VectorX(i, (leafangle - (180 * k)) % 360);
						leaves[k]->HitYOffset = VectorY(i, (leafangle - (180 * k)) % 360);
					}
				}
			}
			Waitframe();
		}
		for (int k = 0; k < 2; ++k)
		{
			if (leaves[k]->isValid())
			{
				Remove(leaves[k]);
			}
		}
		this->Data = 0;
		this->Script = 0;
		Quit();
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Mirror Link's whirlwind attack "Whirlwhat" (end)
// By Dimi
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Mirror Link's bait attack "Darkbait" (Start)
// By Dimi, repurposed from Mitsukara's NewGannon DarkBait
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
ffc script darkbait
{
	void run()
	{
		eweapon e = GetAssociatedEWeapon(this->InitD[0]);
		if (e->isValid()) Remove(e);
		bool DarkBait = true;
		this->Data = 5741;
		this->CSet = 8;
		int timer = 240;
		while (DarkBait)
		{
			if (Link->Y > this->Y)
			{
				if (CanWalk(Link->X,Link->Y,DIR_UP,1,false)) --Link->Y;
			}
			else if (Link->Y < this->Y)
			{
				if (CanWalk(Link->X,Link->Y,DIR_DOWN,1,false)) ++Link->Y;
			}
			if (Link->X > this->X)
			{
				if (CanWalk(Link->X,Link->Y,DIR_LEFT,1,false)) --Link->X;
			}
			else if (Link->X < this->X)
			{
				if (CanWalk(Link->X,Link->Y,DIR_RIGHT,1,false)) ++Link->X;
			}
			if (timer > 0) --timer;
			if (LinkCollision(this) && timer > 0) timer-=2;
			if ((LinkCollision(this) && !Link->Item[I_TOUGHMONSTERS]) || timer <= 0) DarkBait = false;
			Waitframe();
		}
		this->Data = 0;
		this->Script = 0;
		Quit();
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Mirror Link's bait attack "Darkbait" (end)
// By Dimi & Mitsukara
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Mirror Link's bracelet attack "Rocksfall" (Start)
// By Dimi
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
ffc script rocksfall
{
	void run()
	{
		for (int i = 0; i < 150; ++i)
		{
			if (i % 64 == 0 || (!Link->Item[I_WEAKMONSTERS] && i % 32 == 0) || (Link->Item[I_TOUGHMONSTERS] && i % 8 == 0)) 
			{
				eweapon e = FireEWeapon(EW_MAGIC, Link->X, Link->Y, DegtoRad(Rand(360)), Rand(15, 50), 16, 164, 50, EWF_UNBLOCKABLE);
				SetEWeaponMovement(e, EWM_FALL, 100, EWMF_DIE);
				SetEWeaponDeathEffect(e, EWD_EXPLODE, 16);
			}
			Waitframe();
		}
		this->Data = 0;
		this->Script = 0;
		Quit();
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Mirror Link's bracelet attack "Rocksfall" (End)
// By Dimi
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Mirror Link's "weapon bouncing" script (Start)
// By Dimi
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
const int SP_SHADOWLINK = 167;			// Sprite used for Shadow Links. Should be two frames and set to the upper-left tile of walking animation on a player character sheet.
const int SP_SHADOWLINK_HOLDUP = 175;		// Sprite used for Shadow Link holdup animation played before exploding, if Tougher Monsters mode is off. Can be any length of animation, but plays only briefly.

ffc script weaponbouncing
{
	void run()
	{
		while(true)
		{
			for (int i = Screen->NumEWeapons(); i > 0; --i)
			{
				eweapon e = Screen->LoadEWeapon(i);
				if (e->ID != EW_STATIONARYBOMB && e->ID != EW_LINKSHADOW) continue;
				int angle = RadtoDeg(e->Angle);
				int Vx = VectorX(e->Step / 100, angle);
				int Vy = VectorY(e->Step / 100, angle);
				bool changeangle = false;
				if ((Vx < 0 && !CanWalk(e->X, e->Y, DIR_LEFT, Abs(Vx), true)) || (Vx > 0 && !CanWalk(e->X, e->Y, DIR_RIGHT, Abs(Vx), true))) 
				{
					Vx = -Vx;
					changeangle = true;
				}
				if ((Vy < 0 && !CanWalk(e->X, e->Y, DIR_UP, Abs(Vy), true)) || (Vy > 0 && !CanWalk(e->X, e->Y, DIR_DOWN, Abs(Vy), true))) 
				{
					Vy = -Vy;
					changeangle = true;
				}
				if (changeangle) 
				{
					angle = Angle(0, 0, Vx, Vy);
					e->Angle = DegtoRad(angle);
				}
				if (e->ID == EW_LINKSHADOW) 
				{
					if (e->Misc[__EWI_LIFESPAN_ARG] > 30)
					{
						//e->OriginalTile = 43700 + (AngleDirFixed4(angle) * 20);
						e->UseSprite(SP_SHADOWLINK);
						e->OriginalTile = e->OriginalTile + (AngleDirFixed4(angle) * 20);
					}
					else
					{
						if (!Link->Item[I_TOUGHMONSTERS])
						{
							//e->OriginalTile = 43890;
							e->UseSprite(SP_SHADOWLINK_HOLDUP);
							e->Step = 0;
						}
					}
				}
			}
			Waitframe();
		}
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Mirror Link's "weapon bouncing" script (End)
// By Dimi
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Mirror Link's boomerang attack "bummerang" script (Start)
// By Dimi
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
const int NPC_MIRRORLINK = 377;

ffc script bummerang
{
	void run()
	{
		int bummercounter = 20;
		int bummerangle = Angle(0, 0, this->Vx, this->Vy);
		int bummerstep = Distance(0, 0, this->Vx, this->Vy);
		int oldstep = bummerstep;
		this->Vx = VectorX(bummerstep, bummerangle);
		this->Vy = VectorY(bummerstep, bummerangle);
		npc LinkGhost = LoadNPCOf(NPC_MIRRORLINK);
		while(true)
		{
			if (RectCollision(this->X+3, this->Y+3, this->X + 12, this->Y + 12, Link->X + 3, Link->Y + 3, Link->X + 12, Link->Y + 12))
			{
				DamageArea(8, this->X, this->Y, Game->ComboTile(5740), 6, true);
				Game->Counter[CR_LINKSTUN] = 192;
			}
			else DamageArea(8, this->X, this->Y, Game->ComboTile(5740), 6, false);
			if (bummercounter > 45 && bummercounter < 225)
			{
				bummerstep = Abs(VectorX(oldstep, bummercounter-45));
				bummercounter+=9;
			}
			else if (bummercounter <= 45)
			{
				bummerstep = oldstep;
				++bummercounter;
			}
			if (bummercounter >= 135) 
			{
				if (LinkGhost->isValid()) 
				{
					bummerangle = Angle(this->X, this->Y, LinkGhost->X, LinkGhost->Y);
					if (Collision(LinkGhost, this)) break;
				}
				else break;
			}
			this->Vx = VectorX(bummerstep, bummerangle);
			this->Vy = VectorY(bummerstep, bummerangle);
			Waitframe();
		}
		this->Data = 0;
		this->Script = 0;
		this->Vx = 0;
		this->Vy = 0;
		Quit();
	}
	void DamageArea(int damage, int x, int y, int tile, int cset, bool collision)
	{
		eweapon e = FireEWeapon(EW_LINKWEAPONS, x, y, 0, 0, damage, -1, -1, EWF_UNBLOCKABLE);
		e->CollDetection = collision;
		e->Dir = Link->Dir;
		//e->DrawYOffset = -1000;
		e->Tile = tile;
		e->OriginalTile = tile;
		e->CSet = cset;
		SetEWeaponLifespan(e, EWL_TIMER, 1);
		SetEWeaponDeathEffect(e, EWD_VANISH, 0);
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Mirror Link's boomerang attack "bummerang" script (End)
// By Dimi
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Gannon Follower script (Start)
// By Dimi, based on Mitsukara partner mode script
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
const int PARTNERGANNON_COMBO = 5744;
const int I_TRIDENT = 233;
const int SP_TRIDENT = 169;
const int GANNON_VICTORY_COMBO = 5802;

ffc script GannonFollow
{
	void run(int WhatNPC)
	{
//D0 - If there are no NPCs of ID D0 after 60 frames, this NPC will set it's data to GANNON_VICTORY_COMBO and stop running it's script.

		int GannPartner[512];
		int CountDownToVictory = 60;
		Link->Item[I_TRIDENT] = true;
		Link->Item[172] = true;
		Link->Item[173] = true;
		Link->Item[29] = true;
		Link->Item[30] = true;
		while(true)
		{
			//if (Link->Action != LA_HOLD1LAND && Link->Action != LA_HOLD2LAND && Link->Action != LA_HOLD1WATER && Link->Action != LA_HOLD2WATER && Screen->ComboS[ComboAt(Link->X+7,Link->Y+8)] != 1111b)
			if (Link->Action != LA_HOLD1LAND && Link->Action != LA_HOLD2LAND && Link->Action != LA_HOLD1WATER && Link->Action != LA_HOLD2WATER)
			{
				if (GannPartner[FOLLOW_ATIMER] > 0) --GannPartner[FOLLOW_ATIMER];
				else if (GannPartner[FOLLOW_ACTION] != 0) GannPartner[FOLLOW_ACTION] = 0;

				if (Link->PressA)
				{
					if (GannPartner[FOLLOW_ATIMER] == 0 || GannPartner[FOLLOW_ACTION] == FA_WALKING)
					{
						GannPartner[FOLLOW_ACTION] = FA_ATTACKING;
						GannPartner[FOLLOW_ATIMER] = 40;
						GannPartner[FOLLOW_DIR] = Link->Dir;
						lweapon PartnerShot = CreateLWeaponAt(LW_BRANG,GannPartner[FOLLOW_X],GannPartner[FOLLOW_Y]);
						PartnerShot->Dir = GannPartner[FOLLOW_DIR];
						if (Link->Item[I_SWORD4]) PartnerShot->Damage = 8;
						else if (Link->Item[I_SWORD3] || Link->Item[I_CANE3]) PartnerShot->Damage = 4;
						else if (Link->Item[I_SWORD2] || Link->Item[I_CANE2]) PartnerShot->Damage = 2;
						else if (Link->Item[I_SWORD1] || Link->Item[I_CANE1]) PartnerShot->Damage = 1;
						PartnerShot->UseSprite(SP_TRIDENT);
						Game->PlaySound(SFX_BEAM);
					}
				}

				int followdist = 16;
				if (Link->Item[I_PARTNER] && Partner[FOLLOW_STATE] == 0) followdist = 33;

				if (GannPartner[FOLLOW_X] > Link->X + (followdist+16) || GannPartner[FOLLOW_X] < Link->X - (followdist+16) || GannPartner[FOLLOW_Y] > Link->Y + (followdist+16) || GannPartner[FOLLOW_Y] < Link->Y - (followdist+16) || Link->Action == LA_SCROLLING)
				{
					GannPartner[FOLLOW_X] = Link->X;
					GannPartner[FOLLOW_Y] = Link->Y;
				}
				else
				{
					if (Link->InputUp)
					{
						if (GannPartner[FOLLOW_ACTION] == 0) GannPartner[FOLLOW_ACTION] = FA_WALKING;
						else if (GannPartner[FOLLOW_ACTION] == FA_WALKING) GannPartner[FOLLOW_ATIMER] = 12;

						if (GannPartner[FOLLOW_X] > Link->X && CanWalk(GannPartner[FOLLOW_X],GannPartner[FOLLOW_Y],DIR_LEFT,1,false))
						{
							--GannPartner[FOLLOW_X];
							//if (PegasusTimer >= 48) --GannPartner[FOLLOW_X]; 
							if (Link->Action < LA_ATTACKING) GannPartner[FOLLOW_DIR] = DIR_LEFT;
						}
						if (GannPartner[FOLLOW_X] < Link->X && CanWalk(GannPartner[FOLLOW_X],GannPartner[FOLLOW_Y],DIR_RIGHT,1,false)) 
						{
							++GannPartner[FOLLOW_X];
							//if (PegasusTimer >= 48) ++GannPartner[FOLLOW_X];
							if (Link->Action < LA_ATTACKING) GannPartner[FOLLOW_DIR] = DIR_RIGHT;
						}
						if (GannPartner[FOLLOW_Y] > Link->Y+followdist && CanWalk(GannPartner[FOLLOW_X],GannPartner[FOLLOW_Y],DIR_UP,1,false)) 
						{
							--GannPartner[FOLLOW_Y];
							//if (PegasusTimer >= 48) --GannPartner[FOLLOW_Y];
							if (Link->Action < LA_ATTACKING) GannPartner[FOLLOW_DIR] = DIR_UP;
						}
						if (GannPartner[FOLLOW_Y] < Link->Y+followdist && CanWalk(GannPartner[FOLLOW_X],GannPartner[FOLLOW_Y],DIR_DOWN,1,false)) 
						{
							++GannPartner[FOLLOW_Y];
							//if (PegasusTimer >= 48) ++GannPartner[FOLLOW_Y];
							//if (Link->Action < LA_ATTACKING) GannPartner[FOLLOW_DIR] = DIR_DOWN;
						}
					}
					if (IsSideview())
					{
						if (CanWalk(GannPartner[FOLLOW_X],GannPartner[FOLLOW_Y],DIR_DOWN,1,false))
						{
							if (Screen->ComboT[ComboAt(GannPartner[FOLLOW_X]+7,GannPartner[FOLLOW_Y]+8)] != CT_SIDECLIMB) ++GannPartner[FOLLOW_Y];
						}
						if (GannPartner[FOLLOW_STATE] == 0)
						{
							if (Screen->ComboS[ComboAt(GannPartner[FOLLOW_X]+7,GannPartner[FOLLOW_Y]+15)] != 0) --GannPartner[FOLLOW_Y];
						}
					}
					if (Link->InputDown)
					{
						if (GannPartner[FOLLOW_ACTION] == 0) GannPartner[FOLLOW_ACTION] = FA_WALKING;
						else if (GannPartner[FOLLOW_ACTION] == FA_WALKING) GannPartner[FOLLOW_ATIMER] = 12;

						if (GannPartner[FOLLOW_X] > Link->X && CanWalk(GannPartner[FOLLOW_X],GannPartner[FOLLOW_Y],DIR_LEFT,1,false)) 
						{
							--GannPartner[FOLLOW_X];
							//if (PegasusTimer >= 48) --GannPartner[FOLLOW_X]; 
							if (Link->Action < LA_ATTACKING) GannPartner[FOLLOW_DIR] = DIR_LEFT;
						}
						if (GannPartner[FOLLOW_X] < Link->X && CanWalk(GannPartner[FOLLOW_X],GannPartner[FOLLOW_Y],DIR_RIGHT,1,false)) 
						{
							++GannPartner[FOLLOW_X];
							//if (PegasusTimer >= 48) ++GannPartner[FOLLOW_X];
							if (Link->Action < LA_ATTACKING) GannPartner[FOLLOW_DIR] = DIR_RIGHT;
						}
						if (GannPartner[FOLLOW_Y] > Link->Y-followdist && CanWalk(GannPartner[FOLLOW_X],GannPartner[FOLLOW_Y],DIR_UP,1,false)) 
						{
							if (!IsSideview() || Screen->ComboT[ComboAt(Link->X+7,Link->Y+8)] == CT_SIDECLIMB) --GannPartner[FOLLOW_Y];
							//if (PegasusTimer >= 48) --GannPartner[FOLLOW_Y];
							//if (Link->Action < LA_ATTACKING) GannPartner[FOLLOW_DIR] = DIR_UP;
						}
						if (GannPartner[FOLLOW_Y] < Link->Y-followdist && CanWalk(GannPartner[FOLLOW_X],GannPartner[FOLLOW_Y],DIR_DOWN,1,false)) 
						{
							++GannPartner[FOLLOW_Y];
							//if (PegasusTimer >= 48) ++GannPartner[FOLLOW_Y];
							if (Link->Action < LA_ATTACKING) GannPartner[FOLLOW_DIR] = DIR_DOWN;
						}
					}
					if (Link->InputLeft)
					{
						if (GannPartner[FOLLOW_ACTION] == 0) GannPartner[FOLLOW_ACTION] = FA_WALKING;
						else if (GannPartner[FOLLOW_ACTION] == FA_WALKING) GannPartner[FOLLOW_ATIMER] = 12;

						if (GannPartner[FOLLOW_X] > Link->X+followdist && CanWalk(GannPartner[FOLLOW_X],GannPartner[FOLLOW_Y],DIR_LEFT,1,false)) 
						{
							--GannPartner[FOLLOW_X];
							//if (PegasusTimer >= 48) --GannPartner[FOLLOW_X]; 
							if (Link->Action < LA_ATTACKING) GannPartner[FOLLOW_DIR] = DIR_LEFT;
						}
						if (GannPartner[FOLLOW_X] < Link->X+followdist && CanWalk(GannPartner[FOLLOW_X],GannPartner[FOLLOW_Y],DIR_RIGHT,1,false)) 
						{
							++GannPartner[FOLLOW_X];
							//if (PegasusTimer >= 48) ++GannPartner[FOLLOW_X];
							//if (Link->Action < LA_ATTACKING) GannPartner[FOLLOW_DIR] = DIR_RIGHT;
						}
						if (GannPartner[FOLLOW_Y] > Link->Y && CanWalk(GannPartner[FOLLOW_X],GannPartner[FOLLOW_Y],DIR_UP,1,false)) 
						{
							--GannPartner[FOLLOW_Y];
							//if (PegasusTimer >= 48) --GannPartner[FOLLOW_Y];
							if (Link->Action < LA_ATTACKING) GannPartner[FOLLOW_DIR] = DIR_UP;
						}
						if (GannPartner[FOLLOW_Y] < Link->Y && CanWalk(GannPartner[FOLLOW_X],GannPartner[FOLLOW_Y],DIR_DOWN,1,false)) 
						{
							++GannPartner[FOLLOW_Y];
							//if (PegasusTimer >= 48) ++GannPartner[FOLLOW_Y];
							if (Link->Action < LA_ATTACKING) GannPartner[FOLLOW_DIR] = DIR_DOWN;
						}

					}
					if (Link->InputRight)
					{
						if (GannPartner[FOLLOW_ACTION] == 0) GannPartner[FOLLOW_ACTION] = FA_WALKING;
						else if (GannPartner[FOLLOW_ACTION] == FA_WALKING) GannPartner[FOLLOW_ATIMER] = 12;

						if (GannPartner[FOLLOW_X] > Link->X-followdist && CanWalk(GannPartner[FOLLOW_X],GannPartner[FOLLOW_Y],DIR_LEFT,1,false)) 
						{
							--GannPartner[FOLLOW_X];
							//if (PegasusTimer >= 48) --GannPartner[FOLLOW_X]; 
							//if (Link->Action < LA_ATTACKING) GannPartner[FOLLOW_DIR] = DIR_LEFT;
						}
						if (GannPartner[FOLLOW_X] < Link->X-followdist && CanWalk(GannPartner[FOLLOW_X],GannPartner[FOLLOW_Y],DIR_RIGHT,1,false)) 
						{
							++GannPartner[FOLLOW_X];
							//if (PegasusTimer >= 48) ++GannPartner[FOLLOW_X];
							if (Link->Action < LA_ATTACKING) GannPartner[FOLLOW_DIR] = DIR_RIGHT;
						}
						if (GannPartner[FOLLOW_Y] > Link->Y && CanWalk(GannPartner[FOLLOW_X],GannPartner[FOLLOW_Y],DIR_UP,1,false)) 
						{
							--GannPartner[FOLLOW_Y];
							//if (PegasusTimer >= 48) --GannPartner[FOLLOW_Y];
							if (Link->Action < LA_ATTACKING) GannPartner[FOLLOW_DIR] = DIR_UP;
						}
						if (GannPartner[FOLLOW_Y] < Link->Y && CanWalk(GannPartner[FOLLOW_X],GannPartner[FOLLOW_Y],DIR_DOWN,1,false))
						{ 
							++GannPartner[FOLLOW_Y];
							//if (PegasusTimer >= 48) ++GannPartner[FOLLOW_Y];
							if (Link->Action < LA_ATTACKING) GannPartner[FOLLOW_DIR] = DIR_DOWN;
						}
					}
					//if (PegasusTimer >= 48) GannPartner[FOLLOW_DIR] = Link->Dir;
					if (Link->X > GannPartner[FOLLOW_X] + followdist) ++GannPartner[FOLLOW_X];
					else if (Link->X < GannPartner[FOLLOW_X] - followdist) --GannPartner[FOLLOW_X];
					if (Link->Y > GannPartner[FOLLOW_Y] + followdist) ++GannPartner[FOLLOW_Y];
					else if (Link->Y < GannPartner[FOLLOW_Y] - followdist) --GannPartner[FOLLOW_Y];

					if (Link->X > GannPartner[FOLLOW_X] + (followdist+8)) 
					{
						++GannPartner[FOLLOW_X];
						GannPartner[FOLLOW_DIR] = Link->Dir;
					}
					else if (Link->X < GannPartner[FOLLOW_X] - (followdist+8)) 
					{
						--GannPartner[FOLLOW_X];
						GannPartner[FOLLOW_DIR] = Link->Dir;
					}
					if (Link->Y > GannPartner[FOLLOW_Y] + (followdist+8)) 
					{
						++GannPartner[FOLLOW_Y];
						GannPartner[FOLLOW_DIR] = Link->Dir;
					}
					else if (Link->Y < GannPartner[FOLLOW_Y] - (followdist+8)) 
					{
						--GannPartner[FOLLOW_Y];
						GannPartner[FOLLOW_DIR] = Link->Dir;
					}
				}
				if (Link->Action != LA_SCROLLING)
				{
					if (Link->Action != LA_HOLD1LAND && Link->Action != LA_HOLD2LAND && Link->Action != LA_HOLD1WATER && Link->Action != LA_HOLD2WATER)
					{
						if (Game->Counter[CR_WEATHER] == ENV_BLOCKY)
						{
							Screen->FastTile(2,GannPartner[FOLLOW_X],GannPartner[FOLLOW_Y],TILE_SOLID_DARK,6,128);
						}
						else
						{
							this->Data = PARTNERGANNON_COMBO+GannPartner[FOLLOW_ACTION]+GannPartner[FOLLOW_DIR];
							this->X = GannPartner[FOLLOW_X];
							this->Y = GannPartner[FOLLOW_Y];
						}
					}
				}
			}
			if (CountDownToVictory > 0) -- CountDownToVictory;
			else if (NumNPCsOf(WhatNPC) == 0)
			{
				this->Data = GANNON_VICTORY_COMBO;
				Screen->TriggerSecrets();
				Game->PlaySound(SFX_SHUTTER);
				Quit();
			}

			Waitframe();
		}
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Gannon Follower script (end)
// By Dimi, based on Mitsukara partner mode script
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Link Cutscene (start)
// By Dimi
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
ffc script LinkCutscene
{
	void run()
	{
		while(true)
		{
			Game->Counter[CR_SHELLMET] = 0;
			Link->Dir = DIR_UP;
			WaitNoAction();
		}
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Link Cutscene (end)
// By Dimi
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: PlaySound10 (start)
// By Dimi
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
ffc script PlaySound10
{
	void run(int sound)
	{
		int i = 0;
		while(true)
		{
			++i;
			if (i < 160 && i%10==0) Game->PlaySound(sound);
			WaitNoAction();
		}
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: PlaySound10 (end)
// By Dimi
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------


// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: PlayString (start)
// By Dimi
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
ffc script PlayString
{
	void run(int string)
	{
		Screen->Message(string);
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: PlayString (End)
// By Dimi
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Link Prompt (start)
// By Dimi, modified by Mitsukara
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
const int I_LINKPROMPT = 234; 		//Quest doesn't use "messages freeze action"; workaround to figure out when the last string is played.
const int SP_BBLASTCUT = 171; 		//Puff for stairs to appear
const int LINKPROMPT_YES = 16228;	// Menu displayed for choosing "yes"
const int LINKPROMPT_NO = 16234; 	// Menu displayed for choosing "no"
const int EVIL_LINK_WIN = 1298;		// Tile to copy over the default "Zelda" ending holdup (tile 36) if the player chooses yes
const int ZELDA_LOSE = 1299;		// Tile to copy over the default "Link" ending holdup (tile 29) if the player chooses yes

ffc script LinkPrompt
{
	void run(int SayMessage, int Blast1X, int Blast1Y, int AreYouSureMessage)
	{
		int CHOICE_YES[4]="YES";
		int CHOICE_NO[8]="NOT YET";
		bool AreYouSure;
		Link->Item[I_LINKPROMPT] = false;
		RememberStuff[REMEMBER_LINKPROMPT] = 0;
		if ((Game->LItems[Game->GetCurLevel()] & LI_BOSS) != 0)
		{
			Screen->TriggerSecrets();
			lweapon spark1 = CreateLWeaponAt(LW_SPARKLE,Blast1X,Blast1Y);
			spark1->UseSprite(SP_BBLASTCUT);
			lweapon spark2 = CreateLWeaponAt(LW_SPARKLE,Blast1X+16,Blast1Y);
			spark2->UseSprite(SP_BBLASTCUT);
			lweapon spark3 = CreateLWeaponAt(LW_SPARKLE,Blast1X,Blast1Y+16);
			spark3->UseSprite(SP_BBLASTCUT);
			lweapon spark4 = CreateLWeaponAt(LW_SPARKLE,Blast1X+16,Blast1Y+16);
			spark4->UseSprite(SP_BBLASTCUT);
			lweapon spark5 = CreateLWeaponAt(LW_SPARKLE,Blast1X+8,Blast1Y+8);
			spark5->UseSprite(SP_BBLASTCUT);
			Game->PlaySound(SFX_BOMB);
			int Hint[3000] = "\n\n Zelda! Can you hear me? It's\n me, Link! Somebody trapped me down th...\n\n";
			printf(Hint);
		}


		Waitframes(4);
		for (int q = Screen->NumNPCs(); q > 0; --q)
		{
			npc ZeldaFire = Screen->LoadNPC(q);
			if (!ZeldaFire->isValid()) continue;
			{
				if (ZeldaFire->ID == NPC_ENEMYFIRE) Remove(ZeldaFire);
			}
		}
		
		while(true)
		{
			while (!LinkCollision(this)) Waitframe();
			if (!AreYouSure)
			{
				for (int i = 0; i < 128; i+=8)
				{
					for (int q = 0; q < 8; ++q)
					{
						RememberStuff[REMEMBER_LINKPROMPT] = i;
						Screen->Rectangle(2, 0, 0, i, 176 ,0,1,0,0,0,true,128);
						Screen->Rectangle(2, 255-i, 0, 255, 176 ,0,1,0,0,0,true,128);
						WaitNoAction();
					}
				}
				RememberStuff[REMEMBER_LINKPROMPT] = 128;
				Screen->Message(SayMessage);
			}
			while (!Link->Item[I_LINKPROMPT]) 
			{
				Link->InputDown = false;
				Link->InputLeft = false;
				Link->InputRight = false;
				Link->InputUp = false;
				Link->InputB = false;
				Link->InputStart = false;
				Link->InputMap = false;
				Link->PressDown = false;
				Link->PressLeft = false;
				Link->PressRight = false;
				Link->PressUp = false;
				Link->PressB = false;
				Link->PressStart = false;
				Link->PressMap = false;
				Link->SwordJinx = 8;
				//Screen->Rectangle(2, 32, 32, 223, 63,0,1,0,0,0,true,128);
				Screen->Rectangle(2, 0, 0, 255, 176 ,0,1,0,0,0,true,128);
				Screen->Rectangle(6, 0, 124, 255, 176 ,0,1,0,0,0,true,128);
				Waitframe();
			}
			bool SelectedYes = false;
			int PressCooldown = 5;
			while (!Link->PressA || PressCooldown > 0)
			{
				Link->InputStart = false;
				Link->PressStart = false;
				Link->InputMap = false;
				Link->PressMap = false;
				Link->InputB = false;
				Link->PressB = false;
				//Screen->Rectangle(7, 112, 76, 140, 108,0,1,0,0,0,true,128);
				//Screen->Rectangle(2, 32, 32, 223, 63,0,1,0,0,0,true,128);
				Screen->Rectangle(2, 0, 0, 255, 176 ,0,1,0,0,0,true,128);
				Screen->Rectangle(6, 0, 124, 255, 176 ,0,1,0,0,0,true,128);
				//Screen->DrawString(7, 116, 112, FONT_Z1, 1, 0, TF_NORMAL, CHOICE_YES, OP_OPAQUE);
				//Screen->DrawString(7, 116, 128, FONT_Z1, 1, 0, TF_NORMAL, CHOICE_NO, OP_OPAQUE);
				Link->SwordJinx = 8;
				if (SelectedYes) 
				{
					//Screen->FastTile (7, 112, 76, 16280, 7, OP_OPAQUE);
					//Screen->FastTile (7, 128, 76, 16281, 7, OP_OPAQUE);
					Screen->DrawTile(
						7,
						80,			//start X
						112,			//start y
						LINKPROMPT_YES,		//tile ID
						6,			//tile width
						4,			//tile width
						1,			//tile cset
						-1,-1,-1,-1,0,0,1,128);
					if (Link->PressDown)
					{
						SelectedYes = false;
						Game->PlaySound(SFX_CURSOR);
					}
				}
				else
				{
					//Screen->FastTile (7, 112, 92, 16280, 7, OP_OPAQUE);
					//Screen->FastTile (7, 128, 92, 16281, 7, OP_OPAQUE);
					Screen->DrawTile(
						7,
						80,			//start X
						112,			//start y
						LINKPROMPT_NO,		//tile ID
						6,			//tile width
						4,			//tile width
						0,			//tile cset
						-1,-1,-1,-1,0,0,1,128);
					if (Link->PressUp)
					{
						SelectedYes = true;
						Game->PlaySound(SFX_CURSOR);
					}
				}
				if (PressCooldown > 0) --PressCooldown;
				WaitNoAction();
			}
			Link->Item[I_LINKPROMPT] = false;
			Screen->Message(0);
			Link->SwordJinx = 0;
			if (!SelectedYes)
			{
				AreYouSure = false;
				for (int i = 128; i > 0; i-=8)
				{
					for (int q = 0; q < 8; q+=2)
					{
						RememberStuff[REMEMBER_LINKPROMPT] = i;
						Screen->Rectangle(2, 0, 0, i, 176 ,0,1,0,0,0,true,128);
						Screen->Rectangle(2, 255-i, 0, 255, 176 ,0,1,0,0,0,true,128);
						Screen->Rectangle(6, 0, 124, i, 176 ,0,1,0,0,0,true,128);
						Screen->Rectangle(6, 255-i, 124, 255, 176 ,0,1,0,0,0,true,128);
						WaitNoAction();
					}
				}
				RememberStuff[REMEMBER_LINKPROMPT] = 0;
				for (int i = 0; i < 8; ++i) 
				{
					Link->InputDown = true;
					Link->InputLeft = false;
					Link->InputRight = false;
					Link->InputUp = false;
					Link->InputA = false;
					Link->InputB = false;
					Link->InputStart = false;
					Link->InputMap = false;
					Link->PressDown = false;
					Link->PressLeft = false;
					Link->PressRight = false;
					Link->PressUp = false;
					Link->PressB = false;
					Link->PressStart = false;
					Link->PressMap = false;
					Waitframe();
				}
			}
			//else break;
			else
			{
				if (!AreYouSure)
				{
					AreYouSure = true;
					PressCooldown = 60;
					Link->Item[I_LINKPROMPT] = true;
					Screen->Message(AreYouSureMessage);
				}
				else
				{
					CopyTile(EVIL_LINK_WIN,36);
					CopyTile(ZELDA_LOSE,29);
					int HintTwo[3000] = "\n\n But was this the true ending...?\n Remember, the cheat code is 4\n if you decide to try again...\n\n And if you haven't gone back to\n the save menu yet, you can also\n go to Game -> Reset on the menu\n to try again, if it's not too late!\n\n If you don't, Hyrule may fall pray\n to the nightmare of Adjean,\n or be sunken beneath the ocean\n for centuries... or Link may fail. \n\n You might also be eaten by a Gleeok, \n or be beset by a Great many Wizzrobes\n from long ago.\n\n";
					int HintThree[3000] = "\n\n\n To try a randomized quest:\n Hold R and EX2 during intro story\n at the start of this quest,\n and press start! \n\n Pegasus Bonk Count:\n";
					printf(HintTwo);
					printf(HintThree);
					Trace(RememberStuff[REMEMBER_BONKS]);
					Link->X = -16;
					Quit();
	
					//Link->Item[I_BLUEMEDICINE] = false;
					//Link->Item[I_REDMEDICINE] = false;
					//Link->HP = 0;

					//Link->Y = Link->Y+16;				
					//eweapon Kablooie = CreateEWeaponAt(EW_SBOMBBLAST,Link->X,Link->Y);
					//Kablooie->Damage = 4;
				}
			}
		}
		this->Data = 0;
		this->Script = 0;
		Quit();
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Link Prompt (end)
// By Dimi
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Hold Input Dir (start)
// By Mitsukara
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
ffc script HoldInputDir
{
	void run(int WhatInputDir, int WhatRemoveNPC)
	{
		if (WhatRemoveNPC > 0)
		{
			npc KillNPC;
			Waitframes(4);
			while(true)
			{
				Waitframe();
				for(int q = Screen->NumNPCs(); q > 0; --q)
				{
					KillNPC = Screen->LoadNPC(q);
					if (KillNPC->isValid())
					{
						if (KillNPC->ID == WhatRemoveNPC) Remove(KillNPC);
					}
				}
				if (NumNPCsOf(WhatRemoveNPC) == 0)
				{
					if (WhatInputDir == DIR_UP) Link->InputUp = true;
					else if (WhatInputDir == DIR_DOWN) Link->InputDown = true;
					else if (WhatInputDir == DIR_LEFT) Link->InputLeft = true;
					else if (WhatInputDir == DIR_RIGHT) Link->InputRight = true;
				}
			}
		}
		else
		{
			Waitframes(60);
			while(true)
			{
				Waitframe();
				if (WhatInputDir == DIR_UP) Link->InputUp = true;
				else if (WhatInputDir == DIR_DOWN) Link->InputDown = true;
				else if (WhatInputDir == DIR_LEFT) Link->InputLeft = true;
				else if (WhatInputDir == DIR_RIGHT) Link->InputRight = true;
			}
		}
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Hold Input Dir (End)
// By Mitsukara
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Toggle DoDraw (start)
// By Mitsukara
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
ffc script ToggleDoDraw
{
	void run(int OffOrOn, int DisableEnvironmentStuff)
	{
		if (OffOrOn == 1) DoDraw = true;
		else if (OffOrOn == 2) DoDraw = false;
		if (DisableEnvironmentStuff == 1)
		{
			Link->Item[I_CURSEDPICTOBOX] = false;
			Link->Item[I_RECURSEDPICTOBOX] = false;
			Game->Counter[CR_WEATHER] = 0;
		}
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Toggle DoDraw (End)
// By Mitsukara
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Puff if Item (start)
// By Mitsukara
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
ffc script PuffIfItem
{
	void run(int WhatItem)
	{
		Game->PlaySound(SFX_MSG);
		if (Link->Item[WhatItem])
		{
			lweapon Kapoof = CreateLWeaponAt(LW_SPARKLE,this->X,this->Y);
			if (Kapoof->isValid()) Kapoof->UseSprite(SP_SPAWN);
		}
		Quit();
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Puff If Item (End)
// By Mitsukara
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Ending Trace Stuff (start)
// By Mitsukara
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
ffc script EndingTraces
{
	void run()
	{

		if (Game->Counter[CR_COSTUME] == COSTUME_BLACKMAGE)
		{
			int ThanksMelee[3000] = "\n\n And so the day has been saved\n from the forces of evil.\n\n One day, a new evil will make\n itself known, and when that day comes,\n MeleeWizard will be there.\n\n";
			printf(ThanksMelee);
		}
		else if (Game->Counter[CR_COSTUME] == COSTUME_MONIKA)
		{
			int HeyMonika[3000] = "\n\n Monika: \n Hi! It's me, Monika. Um, \n I really appreciate you choosing \n my costume, and stuff. You know, \n I've been learning to use ZScript, and \n I'm like, really, REALLY bad at it. \n Plus I don't think ZScript can change the \n real Ending String, so the cutscene \n is gonna call me 'Zelda'. But you \n know the truth, right? \n Thank you... \n\n";
			printf(HeyMonika);
		}
		int ThanksForPlaying[3000] = "\n\n You are great.\n\n You have an amazing Wisdom and Power. \n\n End of ''The Legend of Zelda 1\n\n Through The Inverse Glass''. \n\n To try a randomized quest:\n Hold R and EX2 during intro story\n at the start of this quest,\n and press start. \n\n Pegasus Bonk Count:\n";
		printf(ThanksForPlaying);
		Trace(RememberStuff[REMEMBER_BONKS]);
		Quit();
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Ending Trace stuff (End)
// By Mitsukara
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Gannon Undeath (start)
// By Mitsukara
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
ffc script GannonUndeath
{
	void run(int WhatData, int WhatCSet)
	{
		{
		
			lweapon GannDead = CreateLWeaponAt(LW_SPARKLE,this->X,this->Y+64);
			GannDead->UseSprite(SP_GANN_DEATH1);
			GannDead->Dir = DIR_UP;
			GannDead->Step = 60;
		
			GannDead = CreateLWeaponAt(LW_SPARKLE,this->X+48,this->Y+48);
			GannDead->UseSprite(SP_GANN_DEATH2);
			GannDead->Dir = DIR_LEFTUP;
			GannDead->Step = 45;
	
			GannDead = CreateLWeaponAt(LW_SPARKLE,this->X+64,this->Y);
			GannDead->UseSprite(SP_GANN_DEATH3);
			GannDead->Dir = DIR_LEFT;
			GannDead->Step = 60;
	
			GannDead = CreateLWeaponAt(LW_SPARKLE,this->X+48,this->Y-48);
			GannDead->UseSprite(SP_GANN_DEATH2);
			GannDead->Dir = DIR_LEFTDOWN;
			GannDead->Flip = FLIP_VERTICAL;
			GannDead->Step = 45;
	
			GannDead = CreateLWeaponAt(LW_SPARKLE,this->X,this->Y-64);
			GannDead->UseSprite(SP_GANN_DEATH1);
			GannDead->Dir = DIR_DOWN;
			GannDead->Flip = FLIP_VERTICAL;
			GannDead->Step = 60;

			GannDead = CreateLWeaponAt(LW_SPARKLE,this->X-48,this->Y-48);
			GannDead->UseSprite(SP_GANN_DEATH2);
			GannDead->Dir = DIR_RIGHTDOWN;
			GannDead->Flip = FLIP_BOTH;
			GannDead->Step = 45;

			GannDead = CreateLWeaponAt(LW_SPARKLE,this->X-64,this->Y);
			GannDead->UseSprite(SP_GANN_DEATH3);
			GannDead->Dir = DIR_RIGHT;
			GannDead->Flip = FLIP_HORIZONTAL;
			GannDead->Step = 60;

			GannDead = CreateLWeaponAt(LW_SPARKLE,this->X-48,this->Y+48);
			GannDead->UseSprite(SP_GANN_DEATH2);
			GannDead->Dir = DIR_RIGHTUP;
			GannDead->Flip = FLIP_HORIZONTAL;
			GannDead->Step = 45;

			Waitframe();	
			while(true)
			{
				Waitframe();
				if (NumLWeaponsOf(LW_SPARKLE) == 0)
				{
					Game->PlaySound(SFX_GANON);
					lweapon Kapoof = CreateLWeaponAt(LW_SPARKLE,this->X,this->Y);
					Kapoof->UseSprite(SP_SPAWN);
					this->Data = WhatData;
					this->CSet = WhatCSet;
					Quit();
				}
			}
		}
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Gannon Undeath (End)
// By Mitsukara
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Patra Friend (start)
// By Dimi
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

ffc script PatraFriend
{
	void run(int enemyid, int count, int radius, int speed)
	{
		if (count > 8) count = 8;
		npc patrafriend = Screen->CreateNPC(enemyid);
		patrafriend->X = this->X;
		patrafriend->Y = this->Y;
		patrafriend->CollDetection = false;
		ffc Friends[8];
		ffc f;
		int q;
		int i;
		for (i = 0; i < count; ++i)
		{
			
			for (q = 1; q <= 32; ++q )
			{
				f = Screen->LoadFFC(q);
				if ( f->Script ) continue;
				if ( f->Data ) continue;
				if ( q )
				{
					f->Data = 5828;
					f->CSet = 9;
					f->Script = 37;
					f->X = this->X;
					f->Y = this->Y;
					Friends[i] = f;
					break;
				}
				if (q == 32) count = i;
			}
		}
		for (i = 0; i < count; ++i)
		{
			Friends[i]->X = this->X + VectorX(radius, (360 / count) * i);
			Friends[i]->Y = this->Y + VectorY(radius, (360 / count) * i);
		}
		int angle = 0;
		while(patrafriend->isValid())
		{
			this->X = patrafriend->X;
			this->Y = patrafriend->Y;
			for (i = 0; i < count; ++i)
			{
				Friends[i]->X = this->X + VectorX(radius, (((360 / count) * i) + angle) % 360);
				Friends[i]->Y = this->Y + VectorY(radius, (((360 / count) * i) + angle) % 360);
			}
			angle += speed;
			patrafriend->CollDetection = false;
			Waitframe();
		}
	}
}

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Patra Friend (end)
// By Dimi
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Donkey Kong (start)
// By Dimi
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
const int EW_GRAVITY = 37;

ffc script DonkeyKong
{
	void run()
	{
		while(true)
		{
			for (int i = Screen->NumEWeapons(); i > 0; --i)
			{
				eweapon e = Screen->LoadEWeapon(i);
				if (e->ID != EW_GRAVITY) continue;
				if (CanWalk(e->X, e->Y, DIR_DOWN, 1, false) && Screen->ComboT[ComboAt(e->X + 7, e->Y + 17)] != CT_SIDECLIMB)
				{
					e->Step = 0;
					e->Y+=4;
				}
				else 
				{
					e->Step = 0;
					if ((e->Dir%4) == DIR_LEFT) --e->X;
					if ((e->Dir%4) == DIR_RIGHT) ++e->X;
				}
				if (!CanWalk(e->X, e->Y, e->Dir%4, 1, false)) 
				{
					Game->PlaySound(SFX_SHATTERING);
					lweapon spark = CreateLWeaponAt(LW_SPARKLE,e->X,e->Y);
					spark->UseSprite(SP_MISC_DEATH);
					Remove(e);
				}
			}
			Waitframe();
		}
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Donkey Kong (end)
// By Dimi
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: FFC Shooter (start)
// By LinkTheMaster, used by Dimi
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

ffc script ffcShooter
{
	void run(int weaponID, int dir, int frequency, int speed, int damage, int soundeffect, int sprite, int flags)
	{
		
		// d0 = The weapon ID to fire.  Can use EW_ constants or... (DEFAULT: fireball)
			// 0 = Fireball
			// 1 = Boss fireball
			// 2 = Rock
			// 3 = Fire (short distance)
			// 4 = Fire (long distance)
			// 5 = Wind
			// 6 = Bomb
		// d1 = Direction to fire in.  For DIR_ constants, add 1 to them (DEFAULT: at link)
			// 0 = At Link
			// 1 = Up
			// 2 = Down
			// 3 = Left
			// 4 = Right
			// 5 = Left Up
			// 6 = Right Up
			// 7 = Left Down
			// 8 = Right Down
		// d2 = Frequency (60 is about 1 second) (DEFAULT: 120)
		// d3 = Speed (100 = 60 pixels a second) (DEFAULT: 100)
		// d4 = Damage (DEFAULT: 1)
		// d5 = Sound effect (DEFAULT: SFX_FIREBALL)
		// d6 = Sprite
		// d7 = Flags
			// 1 = Unblockable
			// 2 = Stops when the FFC's combo changes
			// 3 = Unblockable and stops when the FFC's combo changes

		// Create defaults for weapon IDs
		if(weaponID == 0)
			weaponID = EW_FIREBALL;
		else if(weaponID == 1)
			weaponID = EW_FIREBALL2;
		else if(weaponID == 2)
			weaponID = EW_ROCK;
		else if(weaponID == 3)
			weaponID = EW_FIRE;
		else if(weaponID == 4)
			weaponID = EW_FIRE2;
		else if(weaponID == 5)
			weaponID = EW_WIND;
		else if(weaponID == 6)
			weaponID = EW_BOMB;
			
		// Create defaults for other values
		if(frequency == 0)
			frequency = 120;
		if(speed == 0)
			speed = 100;
		if(damage == 0)
			damage = 1;
		if(soundeffect == 0)
			soundeffect = SFX_FIREBALL;
			
		int counter = 0;
		int startingCombo = this->Data;
			
		// Delay for the initial amount of time
		
		// Continue forever if it's not set to end when the combo change... or end if the combo changed
		while(flags <= 1 || this->Data == startingCombo)
		{
		
			if(counter == 0)
			{
			
				// Play the sound effect
				if(soundeffect > 0)
					Game->PlaySound(soundeffect);
				
				// Here we go ahead and create the weapon
				eweapon weapon = Screen->CreateEWeapon(weaponID);
				weapon->X = this->X + this->EffectWidth/2 - 8;
				weapon->Y = this->Y + this->EffectHeight/2 - 8;
				weapon->Damage = damage;
				weapon->Step = speed;
				weapon->UseSprite(sprite);
				weapon->DrawYOffset = 0;
				weapon->DrawXOffset = 0;
				
				// If no proper direction was set, have it fire at Link
				if(dir < 0 || dir >= 8)
				{
					weapon->Angular = true;
					weapon->Angle = RadianAngle(this->X + this->EffectWidth/2 - 8, this->Y + this->EffectHeight/2 - 8, Link->X+8, Link->Y+8);
					weapon->Dir = RadianAngleDir8(weapon->Angle);
				}
				// Else a proper direction was set, so set it to that
				else
					weapon->Dir = dir;
				
				// Up the weapon's dir if it was set as unblockable
				if(flags == 1 || flags == 3)
				{
					weapon->Dir += 8;
				}
			}
			
			
			counter = (counter+1)%frequency;	
			Waitframe();
		}
	}
} 
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: FFC Shooter (end)
// By LinkTheMaster
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Winged meat (start)
// By Dimi
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
const int SP_WINGEDMEAT = 173;

ffc script WingedMeat
{
	void run()
	{
		this->Flags[FFCF_ETHEREAL] = true;
		while(true)
		{
			lweapon BlueMeat = CreateLWeaponAt(LW_BAIT,this->X,this->Y);
			BlueMeat->UseSprite(SP_WINGEDMEAT);
			BlueMeat->CSet = 7;
			while (BlueMeat->isValid())
			{
				BlueMeat->Jump = 0;
				Waitframe();
			}
			Waitframe();
		}
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Winged meat (end)
// By Dimi
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: ForcedJump (start)
// By Dimi (modified by Mitsukara to also press B)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
ffc script ForcedJump
{
	void run(int jump, int UsePatra)
	{
		Link->Jump = jump;
		Waitframe();
		Link->Jump = jump;
		Waitframe();
		Link->Jump = jump;
		if (UsePatra == 1)
		{
			if (GetEquipmentB() == I_CBYRNA || GetEquipmentB() == I_CBYRNA2 || GetEquipmentB() == I_CBYRNA3) Link->PressB = true;
			else if (GetEquipmentA() == I_CBYRNA || GetEquipmentA() == I_CBYRNA2 || GetEquipmentA() == I_CBYRNA3) Link->PressA = true;
		}
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: ForcedJump (end)
// By Dimi
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: NESWind (start)
// By Dimi
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
ffc script NESWind
{	//Never Eat Shredded Wheat!
	void run()
	{
		while(true)
		{
			bool docheck = true;
			for(int i = 32; i > 0; --i)
			{
				ffc f = Screen->LoadFFC(i);
				if (f->Data != COMBO_SCREENFREEZE1) continue;
				else docheck = false;
			}
			if (docheck)
			{
				if (NumEWeaponsOf(EW_WIND) > 0)
				{
					eweapon e = LoadEWeaponOf(EW_WIND);
					if (e->DrawXOffset < 0)
					{
						++e->DrawXOffset;
						e->HitXOffset = e->DrawXOffset;
					}
					else e->Step = 128;
					Screen->DrawTile(
						4,
						e->X+e->DrawXOffset,	//start X
						e->Y+e->DrawYOffset-e->Z,	//start y
						e->Tile,				//tile ID
						e->TileWidth,			//tile width
						e->TileHeight,			//tile width
						e->CSet,				//tile cset
						-1,-1,-1,-1,0,e->Flip,1,128);
				}
			}
			Waitframe();
		}
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: NESWind (end)
// By Dimi
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Evil Ducks (start)
// By Dimi
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
const int COMBO_EVILDUCK1 = 5846;
const int COMBO_EVILDUCK2 = 5852;

ffc script EvilDucks
{
	void run()
	{
		int TopEvilDuck[7];
		TopEvilDuck[DUCKSHOT_X] = Rand(33,243);
		int DuckDelay = 0;
		int DuckTargetX = Link->X;
		int DuckTargetY = Link->Y;
		while(true)
		{
			if (Link->Item[I_ZAPPERTWO])
			{
				if (NumLWeaponsOf(LW_BOMBBLAST) > 0)
				{
					lweapon l = LoadLWeaponOf(LW_BOMBBLAST);
					if (TopEvilDuck[DUCKSHOT_BULLET] > 0)
					{
						if (TopEvilDuck[DUCKSHOT_BULLET] >= l->Y && TopEvilDuck[DUCKSHOT_BULLET] <= l->Y+32 && TopEvilDuck[DUCKSHOT_X] >= l->X-24 && TopEvilDuck[DUCKSHOT_X] <= l->X + 8)
						{
							TopEvilDuck[DUCKSHOT_TARGET] = TopEvilDuck[DUCKSHOT_BULLET] - 16;
							Game->PlaySound(SFX_DUCKHIT);
							item DuckPrize = CreateItemAt(I_RUPOOR,Link->X,Link->Y);
							if (IsSideview()) DuckPrize->Y = 0;
							else DuckPrize->Z = Link->Y+32; 
						}
					}
				}
				// Duck drops bullets
				if (TopEvilDuck[DUCKSHOT_BULLET] == 0)
				{
					if (TopEvilDuck[DUCKSHOT_FIRE] == 0) TopEvilDuck[DUCKSHOT_FIRE] = Rand(64,511);
					else 
					{
						if (Link->Action != LA_SCROLLING)
						{
							--TopEvilDuck[DUCKSHOT_FIRE];
							if (Link->Item[I_TOUGHMONSTERS])
							{
								--TopEvilDuck[DUCKSHOT_FIRE];
								--TopEvilDuck[DUCKSHOT_FIRE];
							}
							if (TopEvilDuck[DUCKSHOT_FIRE] == 1)
							{
								TopEvilDuck[DUCKSHOT_TARGET] = Rand(32,144);
								TopEvilDuck[DUCKSHOT_BULLET] = 1;	
								Game->PlaySound(SFX_DUCKSHOT);
								TopEvilDuck[DUCKSHOT_FIRE] = 0;
							}
						}
					}
				}
				else
				{
					Screen->FastCombo(7,TopEvilDuck[DUCKSHOT_X]+8,TopEvilDuck[DUCKSHOT_BULLET] - 16,COMBO_BULLET,0,128);
					if (TopEvilDuck[DUCKSHOT_BULLET] < TopEvilDuck[DUCKSHOT_TARGET] + 16) ++TopEvilDuck[DUCKSHOT_BULLET];
					else
					{
 						eweapon BlamBlam = CreateEWeaponAt(EW_BOMBBLAST,TopEvilDuck[DUCKSHOT_X]+8,TopEvilDuck[DUCKSHOT_TARGET]);
						BlamBlam->Damage = 16;
						if (Link->Item[I_NOHEARTS]) CreateItemAt(I_NEGAHEART, TopEvilDuck[DUCKSHOT_X]+8, TopEvilDuck[DUCKSHOT_TARGET]);
						TopEvilDuck[DUCKSHOT_BULLET] = 0;
					}
				}


				// Duck moves across top of the screen
				if (TopEvilDuck[DUCKSHOT_DIR] == DIR_LEFT)
				{
					if (TopEvilDuck[DUCKSHOT_X] == 0) TopEvilDuck[DUCKSHOT_DIR] = DIR_RIGHT;
					else if (TopEvilDuck[DUCKSHOT_STEP] == 0) 
					{
						if (TopEvilDuck[DUCKSHOT_BULLET] == 0 && Link->Action != LA_SCROLLING)
						{
							TopEvilDuck[DUCKSHOT_STEP] = 2;
							--TopEvilDuck[DUCKSHOT_X];
						}
					}
					else --TopEvilDuck[DUCKSHOT_STEP];

					Screen->FastCombo(7,TopEvilDuck[DUCKSHOT_X],-32,COMBO_EVILDUCK2,6,128);
					Screen->FastCombo(7,TopEvilDuck[DUCKSHOT_X]+16,-32,COMBO_EVILDUCK2+1,6,128);
					Screen->FastCombo(7,TopEvilDuck[DUCKSHOT_X],-16,COMBO_EVILDUCK2+4,6,128);
					Screen->FastCombo(7,TopEvilDuck[DUCKSHOT_X]+16,-16,COMBO_EVILDUCK2+5,6,128);	

				}
				else if (TopEvilDuck[DUCKSHOT_DIR] == DIR_RIGHT)
				{
					if (TopEvilDuck[DUCKSHOT_X] == 224) TopEvilDuck[DUCKSHOT_DIR] = DIR_LEFT;
					else if (TopEvilDuck[DUCKSHOT_STEP] == 0) 
					{
						if (TopEvilDuck[DUCKSHOT_BULLET] == 0 && Link->Action != LA_SCROLLING)
						{
							TopEvilDuck[DUCKSHOT_STEP] = 2;
							++TopEvilDuck[DUCKSHOT_X];
						}
					}
					else --TopEvilDuck[DUCKSHOT_STEP];

					Screen->FastCombo(7,TopEvilDuck[DUCKSHOT_X],-32,COMBO_EVILDUCK2+2,6,128);
					Screen->FastCombo(7,TopEvilDuck[DUCKSHOT_X]+16,-32,COMBO_EVILDUCK2+3,6,128);
					Screen->FastCombo(7,TopEvilDuck[DUCKSHOT_X],-16,COMBO_EVILDUCK2+6,6,128);
					Screen->FastCombo(7,TopEvilDuck[DUCKSHOT_X]+16,-16,COMBO_EVILDUCK2+7,6,128);
				}
				else TopEvilDuck[DUCKSHOT_DIR] = Choose(DIR_LEFT,DIR_RIGHT);
				
			}


			// First duck:
			if (Link->Item[I_ZAPPER])
			{
				Screen->FastCombo(7,this->X,this->Y,COMBO_EVILDUCK1,6,128);
				Screen->FastCombo(7,this->X+16,this->Y,COMBO_EVILDUCK1+1,6,128);
				Screen->FastCombo(7,this->X,this->Y+16,COMBO_EVILDUCK1+4,6,128);
				Screen->FastCombo(7,this->X+16,this->Y+16,COMBO_EVILDUCK1+5,6,128);		

				if (DuckDelay > 0 && DuckDelay != 32) --DuckDelay;
				else if (DuckDelay == 32)
				{
					if (this->X < DuckTargetX) ++this->X;
					if (this->X > DuckTargetX) --this->X;
					if (this->Y < DuckTargetY) ++this->Y;
					if (this->Y > DuckTargetY) --this->Y;
					if (Abs(this->X - DuckTargetX) < 2 && Abs(this->Y - DuckTargetY) < 2) --DuckDelay;
				}
				else
				{
					if (Link->Item[I_TOUGHMONSTERS]) DuckDelay = 92;
					else if (!Link->Item[I_WEAKMONSTERS]) DuckDelay = 272;
					else DuckDelay = 456;
				}
				if (DuckDelay == 33)
				{
					DuckTargetX = Link->X;
					DuckTargetY = Link->Y;
				}
				if (DuckDelay > 24 && DuckDelay < 32)
				{
						Screen->Rectangle(
						7,	//layer
						0,	//start X
						-56,	//start y
						256,	//end x
						176,	//end y
						0,1,0,0,0,true,128);
						Screen->Rectangle(
						7,	//layer
						this->X-8,	//start X
						this->Y-8,	//start y
						this->X+24,	//end x
						this->Y+24,	//end y
						1,1,0,0,0,true,128);
				}
				if (DuckDelay == 24)
				{
 					eweapon BlamBlam = CreateEWeaponAt(EW_BOMBBLAST,this->X,this->Y);
					BlamBlam->Damage = 16;
					if (Link->Item[I_NOHEARTS]) CreateItemAt(I_NEGAHEART, this->X, this->Y);
					if (TopEvilDuck[DUCKSHOT_BULLET] > 0)
					{
						if (TopEvilDuck[DUCKSHOT_BULLET] >= this->Y && TopEvilDuck[DUCKSHOT_BULLET] <= this->Y+32 && TopEvilDuck[DUCKSHOT_X] >= this->X-24 && TopEvilDuck[DUCKSHOT_X] <= this->X + 8)
						{
							TopEvilDuck[DUCKSHOT_TARGET] = TopEvilDuck[DUCKSHOT_BULLET] - 16;
							Game->PlaySound(SFX_DUCKHIT);
							item DuckPrize = CreateItemAt(I_RUPOOR,Link->X,Link->Y);
							if (IsSideview()) DuckPrize->Y = 0;
							else DuckPrize->Z = Link->Y+32; 
						}
					}
				}
			}
			npc LinkGhost = LoadNPCOf(377);
			if (!LinkGhost->isValid())
			{
				this->Data = 0;
				this->Script = 0;
				Quit();
			}
			Waitframe();
		}
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Evil Ducks (end)
// By Dimi
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Mirror Link Partner (start)
// By Dimi
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
ffc script MirrorLinkPartner
{
	void run()
	{
		int i; int k; int m; int n;
		this->InitD[ML_LASTX] = this->X;
		this->InitD[ML_LASTY] = this->Y-1;
		this->InitD[ML_STATE] = 0;
		this->InitD[ML_PHASE] = 0;
		Link_Transform(this, 0);
		int timer = Rand(180, 240);
		int XLoc;
		int YLoc;
		this->X = 128;
		this->Y = 64;
		while(this->InitD[ML_PHASE] <= 0)
		{
			if (Link->Item[I_PARTNER])
			{
				if (this->InitD[ML_ATTACK] == 0)
				{
					Link_Transform(this, 1);
					if (!Link->Item[I_TOUGHMONSTERS]) for (i = 0; i < 20; ++i) Link_Waitframe2(this, 2);
					if (Link->Item[I_WEAKMONSTERS]) for (i = 0; i < 20; ++i) Link_Waitframe2(this, 2);
					Link_Transform(this, 0);
					if (!Link->Item[I_TOUGHMONSTERS])
					{
						for (i = 0; i < 40; ++i) 
						{
							int angle = Angle(Link->X, Link->Y, this->X, this->Y);
							if (!Link->Item[I_PROGRESSIVEGEAR]) angle = Dir4Angle(AngleDirFixed4(angle));
							if (!Link->Item[I_WEAKMONSTERS]) ++i;
							Link_MoveAtAngle(this, angle, 0.7);
							Link_Waitframe2(this, 2);
						}
					}
					Link_Transform(this, 1);
					for (i = 0; i < 15; ++i) Link_Waitframe2(this, 2);
					for (k = 0; k < 6; ++k)
					{
						int angle = Angle(this->X, this->Y, Link->X, Link->Y);
						if (!Link->Item[I_PROGRESSIVEGEAR]) angle = Dir4Angle(AngleDirFixed4(angle));
						if (!Link->Item[I_TOUGHMONSTERS]) ++k;
						if (Link->Item[I_WEAKMONSTERS]) ++k;
						Link_Transform(this, 4);
						int j;
						if (k % 2 == 0) j = 45;
						else j = -45;
						for (i = 0; i < 10; ++i) Link_Waitframe2(this, 0);
						Game->PlaySound(SFX_SWORD);
						for (i = 0; i < 20; ++i) 
						{
							if (k % 2 == 0) 
							{
								if (j > -45) j -= 5;
							}
							else 
							{
								if (j < 45) j+= 5;
							}
							Link_MoveAtAngle(this, angle, 2);
							int X = this->X + 8 + VectorX(14, (angle - j) % 360);
							int Y = this->Y + 8 + VectorY(14, (angle - j) % 360);
							int anglo = (angle - j) % 360;
							if (!Link->Item[I_PROGRESSIVEGEAR])
							{
								anglo = angle;
								X = this->X + 8 + VectorX(14, angle);
								Y = this->Y + 8 + VectorY(14, angle);
							}
							//DrawComboAyy(3, X, Y, 5737, 1, 1, 6, 16, 16, X, Y, anglo, -1, 0, true, 128);
							if (Link->Item[I_PROGRESSIVEGEAR]) DamageArea(16, X-8, Y-8, 1189 + AngleDirFixed8(anglo), 6);
							else  DamageArea(16, X-8, Y-8, 1189 + AngleDirFixed4(angle), 6);
							this->InitD[0] = AngleDirFixed4(angle);
							Link_Waitframe2(this, 0);
						}
					}
				}
				if (this->InitD[ML_ATTACK] == 1)
				{
					Link_Transform(this, 5);
					lweapon DarkItem = CreateLWeaponAt(LW_SPARKLE,this->X,this->Y);
					DarkItem->UseSprite(SP_GANN_WIND);
					DarkItem->DrawYOffset = -16;
					Game->PlaySound(SFX_WHISTLE);
					for (i = 0; i < 128; ++i) 
					{
						//DrawComboAyy(3, this->X + 7, this->Y + 7, 5738, 1, 1, 7, i+1, i+1, 0, 0, 0, -1, 0, true, 128);
						DamageArea(16, i*2, this->Y, 1052+((i/4)%2), 7);
						if ((i*2) > this->X && (i*2) <= 248) 
						{
							this->X = (i*2);
							Link_Waitframe2(this, 5);
							if (DarkItem->isValid()) Remove(DarkItem);
						}
						else Link_Waitframe2(this, 4);
					}
					for (i = 0; i < 360; ++i) 
					{
						DamageArea(16, this->X, this->Y, 1052+((i/4)%2), 7);
						if (Link->Item[I_WEAKMONSTERS]) ++i;
						this->X += 2;
						if (this->X > 240)
						{
							this->X = 0;
							this->Y = Link->Y;
						}
						Link_Waitframe2(this, 5);
					}
					int savex = this->X;
					if (savex < 208)
					{
						this->X = Rand(savex, 208);
						this->X -= (this->X % 16);
						for (i = 0; i < 128; ++i) 
						{
							DamageArea(16, savex + i*2, this->Y, 1052+((i/4)%2), 7);
							if ((i*2) > this->X) Link_Waitframe2(this, 4);
							else Link_Waitframe2(this, 5);
						}
					}
					else
					{
						int savex2 = Ceiling(savex/2);
						this->X = Rand(32, 208);
						this->X -= (this->X % 16);
						for (i = 0; i < (128-savex2); ++i) 
						{
							//DrawComboAyy(3, this->X + 7, this->Y + 7, 5738, 1, 1, 7, i+1, i+1, 0, 0, 0, -1, 0, true, 128);
							DamageArea(16, savex + i*2, this->Y, 1052+((i/4)%2), 7);
							Link_Waitframe2(this, 5);
						}
						this->Y = Link->Y;
						for (i = 0; i < savex2; ++i) 
						{
							//DrawComboAyy(3, this->X + 7, this->Y + 7, 5738, 1, 1, 7, i+1, i+1, 0, 0, 0, -1, 0, true, 128);
							DamageArea(16, i*(256 / savex2), this->Y, 1052+((i/4)%2), 7);
							if (i*(256 / savex2) > this->X) 
							{
								Link_Waitframe2(this, 4);
							}
							else Link_Waitframe2(this, 5);
						}
					}
				}
				if (this->InitD[ML_ATTACK] == 2)
				{
					Link_Transform(this, 0);
					for (i = 0; i < 30; ++i) Link_Waitframe2(this, 2);
					Link_Transform(this, 1);
					ffc f;
					for ( int q = 1; q <= 32; ++q )
					{
						f = Screen->LoadFFC(q);
						if ( f->Script ) continue;
						if ( f->Data ) continue;
						if ( q )	break;
					}
					int angle = Angle(this->X, this->Y, Link->X, Link->Y);
					angle = Dir4Angle(AngleDirFixed4(angle));
					for (k = 0; k < 4; ++k)
					{
						if (Link->Item[I_WEAKMONSTERS]) ++k;
						Game->PlaySound(SFX_ARROW);
						Link_Transform(this, 4);
						FireAimedEWeapon(EW_ARROW, this->X, this->Y, 0, 200, 8, -1, -1, EWF_ROTATE);
						angle = Angle(this->X, this->Y, Link->X, Link->Y);
						angle = Dir4Angle(AngleDirFixed4(angle));
						f->Data = 5840 + AngleDirFixed4(angle);
						f->CSet = 6;
						f->X = this->X + VectorX(16, angle);
						f->Y = this->Y + VectorY(16, angle);
						for (i = 0; i < 40; ++i) 
						{
							if (!Link->Item[I_WEAKMONSTERS])
							{
								Link_MoveAtAngle(this, angle, 0.8);
								++i;
							}
							else Link_MoveAtAngle(this, angle, 0.4);
							Link_Waitframe2(this, 3);
						}
						Link_Transform(this, 0);
						for (i = 0; i < 40; ++i) 
						{
							if (!Link->Item[I_WEAKMONSTERS])
							{
								Link_MoveAtAngle(this, angle, 0.8);
								++i;
							}
							else Link_MoveAtAngle(this, angle, 0.4);
							Link_Waitframe2(this, 1);
						}
					}
					if (Link->Item[I_TOUGHMONSTERS])
					{
						angle = Angle(this->X, this->Y, Link->X, Link->Y);
						angle = Dir4Angle(AngleDirFixed4(angle));
						for (k = 0; k < 4; ++k)
						{
							Game->PlaySound(SFX_ARROW);
							Link_Transform(this, 4);
							FireAimedEWeapon(EW_ARROW, this->X, this->Y, 0, 200, 8, -1, -1, EWF_ROTATE);
							angle = Angle(this->X, this->Y, Link->X, Link->Y);
							angle = Dir4Angle(AngleDirFixed4(angle));
							f->Data = 5840 + AngleDirFixed4(angle);
							f->CSet = 6;
							f->X = this->X + VectorX(16, angle);
							f->Y = this->Y + VectorY(16, angle);
							for (i = 0; i < 10; ++i) 
							{
								Link_MoveAtAngle(this, angle, 1.6);
								Link_Waitframe2(this, 3);
							}
							Link_Transform(this, 0);
							for (i = 0; i < 10; ++i) 
							{
								Link_MoveAtAngle(this, angle, 1.6);
								Link_Waitframe2(this, 1);
							}
						}
					}
					f->Data = 0;
				}
				if (this->InitD[ML_ATTACK] == 3)
				{
					bool homing = false;
					if (Rand(2) == 0 || !Link->Item[I_PROGRESSIVEGEAR]) homing = true;
					for (k = 0; k < 6; ++k)
					{
						int angle = Angle(this->X, this->Y, Link->X, Link->Y);
						if (!Link->Item[I_PROGRESSIVEGEAR]) angle = Dir4Angle(AngleDirFixed4(angle));
						this->InitD[0] = AngleDirFixed4(angle)+8;
						Link_Transform(this, 4);
						for (i = 0; i < 40; ++i) 
						{
							if (!Link->Item[I_WEAKMONSTERS]) ++i;
							int X = this->X + 8 + VectorX(14, angle);
							int Y = this->Y + 8 + VectorY(14, angle);
							//DrawComboAyy(3, X, Y, 5740, 1, 1, 6, 16, 16, X, Y, angle, -1, 0, true, 128);
							if (Link->Item[I_PROGRESSIVEGEAR]) DamageArea(16, X-8, Y-8, 1209 + AngleDirFixed8(angle), 7);
							else DamageArea(16, X-8, Y-8, 1209 + AngleDirFixed4(angle), 7);
							if (!homing) ++i;
							if (Link->Item[I_TOUGHMONSTERS]) ++i;
							Link_Waitframe2(this, 0);
						}
						eweapon e;
						if (!Link->Item[I_TOUGHMONSTERS] || k % 2 == 0) FireEWeapon(EW_MAGIC, this->X, this->Y, DegtoRad(angle), 200, 8, -1, -1, EWF_ROTATE);
						else FireEWeapon(EW_MAGIC, this->X, this->Y, DegtoRad(angle) + 0.6, 200, 8, -1, -1, EWF_ROTATE);
						if (Link->Item[I_TOUGHMONSTERS] && k % 2 == 1) FireEWeapon(EW_MAGIC, this->X, this->Y, DegtoRad(angle) - 0.6, 200, 8, -1, -1, EWF_ROTATE);
						if (!Link->Item[I_TOUGHMONSTERS]) ++k;
						if (Link->Item[I_WEAKMONSTERS]) ++k;
						Game->PlaySound(SFX_WAND);
						for (i = 0; i < 40; ++i) 
						{
							if (!Link->Item[I_WEAKMONSTERS]) ++i;
							int X = this->X + 8 + VectorX(14, angle);
							int Y = this->Y + 8 + VectorY(14, angle);
							//DrawComboAyy(3, X, Y, 5740, 1, 1, 6, 16, 16, X, Y, angle, -1, 0, true, 128);
							if (Link->Item[I_PROGRESSIVEGEAR]) DamageArea(16, X-8, Y-8, 1209 + AngleDirFixed8(angle), 7);
							else DamageArea(16, X-8, Y-8, 1209 + AngleDirFixed4(angle), 7);
							if (!homing) ++i;
							if (Link->Item[I_TOUGHMONSTERS]) ++i;
							Link_Waitframe2(this, 0);
						}
					}
				}
				if (this->InitD[ML_ATTACK] == 4)
				{
					for (k = 0; k < 8; ++k)
					{
						if (this->InitD[ML_ATTACK] == 9)
						{
							Link_Transform(this, 0);
							do{
								int spawnpoint = FindSpawnPoint(true, false, false, false);
								XLoc = ComboX(spawnpoint);
								YLoc = ComboY(spawnpoint);
							}
							while(Distance(Link->X, Link->Y, GridX(XLoc), GridY(YLoc)) < 64);
							int angle = Angle(this->X, this->Y, XLoc, YLoc);
							while(Distance(this->X, this->Y, XLoc, YLoc) > 4){
								if (Link->Item[I_WEAKMONSTERS])
								{
									if (Link->Item[I_PROGRESSIVEGEAR]) Link_MoveAtAngle(this, angle, 1, true);
									else Link_MoveAt4Way(this, 1, XLoc, YLoc);
								}
								else if (!Link->Item[I_TOUGHMONSTERS])
								{
									if (Link->Item[I_PROGRESSIVEGEAR]) Link_MoveAtAngle(this, angle, 2, true);
									else Link_MoveAt4Way(this, 2, XLoc, YLoc);
								}
								else
								{
									if (Link->Item[I_PROGRESSIVEGEAR]) Link_MoveAtAngle(this, angle, 3, true);
									else Link_MoveAt4Way(this, 3, XLoc, YLoc);
								}
								angle = Angle(this->X, this->Y, XLoc, YLoc);
								Link_Waitframe2(this, 1);
							}
							this->InitD[ML_ATTACK] = 10;
						}
						if (!Link->Item[I_TOUGHMONSTERS]) ++k;
						if (Link->Item[I_WEAKMONSTERS]) k+=2;
						Link_Transform(this, 4);
						if (Link->Item[I_WEAKMONSTERS]) for (i = 0; i < 16; ++i) Link_Waitframe2(this, 4);
						if (!Link->Item[I_TOUGHMONSTERS]) for (i = 0; i < 16; ++i) Link_Waitframe2(this, 4);
						else for (i = 0; i < 12; ++i) Link_Waitframe2(this, 4);
						int angle = Angle(this->X, this->Y, Link->X, Link->Y);
						if (!Link->Item[I_PROGRESSIVEGEAR]) angle = DirAngle(AngleDirFixed8(angle));
						eweapon e = FireEWeapon(EW_STATIONARYBOMB, this->X, this->Y, DegtoRad(angle), 300, 8, 7, 21, EWF_NO_COLLISION);
						if (Link->Item[I_TOUGHMONSTERS] && Rand(5) <= 1) 
						{
							SetEWeaponMovement(e, EWM_THROW, 3, EWMF_DIE);
							SetEWeaponDeathEffect(e, EWD_EXPLODE, 16);
						}
						else if (!Link->Item[I_TOUGHMONSTERS]) SetEWeaponLifespan(e, EWL_SLOW_TO_HALT, Rand(3, 10));
						else SetEWeaponLifespan(e, EWL_SLOW_TO_HALT, Rand(2, 5));
						e->UseSprite(SP_EWSTATIONARYBOMB);
						e->CollDetection = 0;
						if (!Link->Item[I_TOUGHMONSTERS]) e->Misc[MISC_STATIONARYFUSE] = 210;
						else e->Misc[MISC_STATIONARYFUSE] = 210 + Rand(-30, 60);
						if (Link->Item[I_WEAKMONSTERS]) for (i = 0; i < 16; ++i) Link_Waitframe2(this, 4);
						if (!Link->Item[I_TOUGHMONSTERS]) for (i = 0; i < 16; ++i) Link_Waitframe2(this, 4);
						else for (i = 0; i < 12; ++i) Link_Waitframe2(this, 4);
					}
				}
				if (this->InitD[ML_ATTACK] == 5)
				{
					Link_Transform(this, 1);
					if (!Link->Item[I_TOUGHMONSTERS]) for (i = 0; i < 30; ++i) Link_Waitframe2(this, 2);
					if (Link->Item[I_WEAKMONSTERS]) for (i = 0; i < 45; ++i) Link_Waitframe2(this, 2);
					Link_Transform(this, 4);
					int angle = Angle(this->X, this->Y, Link->X, Link->Y);
					if (!Link->Item[I_PROGRESSIVEGEAR]) angle = DirAngle(AngleDirFixed8(angle));
					Game->PlaySound(SFX_BRANG);
					int eggz[] = "bummerang";
					int sid = Game->GetFFCScript(eggz);
					ffc f;
					for ( int q = 1; q <= 32; ++q )
					{
						f = Screen->LoadFFC(q);
						if ( f->Script ) continue;
						if ( f->Data ) continue;
						if ( q )
						{
							f->Data = 1;
							f->Script = Game->GetFFCScript(eggz);
							f->X = this->X;
							f->Y = this->Y;
							f->Vx = VectorX(3, angle);
							f->Vy = VectorY(3, angle);
							break;
						}
					}
					for (i = 0; i < 10; ++i) Link_Waitframe2(this, 4);
					if (Link->Item[I_TOUGHMONSTERS])
					{
						for (int m = 0; m < 2; ++m)
						{
							ffc f;
							for ( int q = 1; q <= 32; ++q )
							{
								f = Screen->LoadFFC(q);
								if ( f->Script ) continue;
								if ( f->Data ) continue;
								if ( q )
								{
									f->Data = 1;
									f->Script = Game->GetFFCScript(eggz);
									f->X = this->X;
									f->Y = this->Y;
									f->Vx = VectorX(3, angle);
									f->Vy = VectorY(3, angle);
									break;
								}
							}
							for (i = 0; i < 10; ++i) Link_Waitframe2(this, 4);
						}
					}
					Link_Transform(this, 1);
					for (i = 0; i < 45; ++i) Link_Waitframe2(this, 2);
				}
				if (this->InitD[ML_ATTACK] == 6)
				{
					for (i = 0; i < 10; ++i) Link_Waitframe2(this, 2);
					int angle = Angle(this->X, this->Y, Link->X, Link->Y);
					if (!Link->Item[I_PROGRESSIVEGEAR]) angle = DirAngle(AngleDirFixed8(angle));
					this->InitD[0] = AngleDirFixed4(angle)+8;
					Link_Transform(this, 4);
					for (i = 0; i <= 400; i+=2.5)
					{
						if (i % 200 == 0) 
						{
							for (int k = 0; k < 8; ++k) FireEWeapon(EW_FIRE, this->X, this->Y, DegtoRad(k*45), 50 + (i/8), 8, -1, -1, EWF_UNBLOCKABLE);
						}
						if (!Link->Item[I_WEAKMONSTERS]) i+=2.5;
						if (Link->Item[I_TOUGHMONSTERS]) i+=5;
						if (i > 300 && !Link->Item[I_TOUGHMONSTERS]) break;
						if (i > 150 && Link->Item[I_WEAKMONSTERS]) break;
						Link_Waitframe2(this, 0);
					}
				}
				if (this->InitD[ML_ATTACK] == 7)
				{
					Link_Transform(this, 4);
					if (!Link->Item[I_TOUGHMONSTERS]) for (i = 0; i < 15; ++i) Link_Waitframe2(this, 4);
					if (Link->Item[I_WEAKMONSTERS]) for (i = 0; i < 15; ++i) Link_Waitframe2(this, 4);
					int angle = Angle(this->X, this->Y, Link->X, Link->Y);
					if (!Link->Item[I_PROGRESSIVEGEAR]) angle = Dir4Angle(AngleDirFixed4(angle));
					eweapon e = FireEWeapon(EW_MAGIC, this->X, this->Y, DegtoRad(angle), 300, 8, 14, 21, EWF_NO_COLLISION);
					SetEWeaponLifespan(e, EWL_SLOW_TO_HALT, Rand(6, 10));
					SetEWeaponDeathEffect(e, EWD_RUN_SCRIPT, 57);
					for (i = 0; i < 15; ++i) Link_Waitframe2(this, 4);
					if (Link->Item[I_WEAKMONSTERS]) for (i = 0; i < 15; ++i) Link_Waitframe2(this, 4);
					Link_Transform(this, 1);
				}
				if (this->InitD[ML_ATTACK] == 8)
				{
					Link_Transform(this, 5);
					for (i = 0; i < 60; ++i) 
					{
						Link_Waitframe2(this, 4);
					}
					Link_Transform(this, 10);
					for (i = 0; i < 10; ++i) Link_Waitframe2(this, 4);
					Link_Transform(this, 9);
					if (Link->Item[I_WEAKMONSTERS]) for (i = 0; i < 30; ++i) Link_Waitframe2(this, 4);
					if (!Link->Item[I_TOUGHMONSTERS]) for (i = 0; i < 60; ++i) Link_Waitframe2(this, 4);
					else for (i = 0; i < 30; ++i) Link_Waitframe2(this, 4);
				}
				if (this->InitD[ML_ATTACK] == 9)
				{
					Link_Transform(this, 0);
					do{
						int spawnpoint = FindSpawnPoint(true, false, false, false);
						XLoc = ComboX(spawnpoint);
						YLoc = ComboY(spawnpoint);
					}
					while(Distance(Link->X, Link->Y, GridX(XLoc), GridY(YLoc)) < 64);
					int angle = Angle(this->X, this->Y, XLoc, YLoc);
					while(Distance(this->X, this->Y, XLoc, YLoc) > 4){
						if (Link->Item[I_WEAKMONSTERS])
						{
							if (Link->Item[I_PROGRESSIVEGEAR]) Link_MoveAtAngle(this, angle, 1, true);
							else Link_MoveAt4Way(this, 1, XLoc, YLoc);
						}
						else if (!Link->Item[I_TOUGHMONSTERS])
						{
							if (Link->Item[I_PROGRESSIVEGEAR]) Link_MoveAtAngle(this, angle, 2, true);
							else Link_MoveAt4Way(this, 2, XLoc, YLoc);
						}
						else
						{
							if (Link->Item[I_PROGRESSIVEGEAR]) Link_MoveAtAngle(this, angle, 3, true);
							else Link_MoveAt4Way(this, 3, XLoc, YLoc);
						}
						angle = Angle(this->X, this->Y, XLoc, YLoc);
						Link_Waitframe2(this, 1);
					}
					this->InitD[ML_ATTACK] = 10;
				}
			}
			if (this->InitD[ML_ATTACK] >= 0 && Link->Item[I_NOHEARTS] && Link->Item[I_PARTNER]) CreateItemAt(I_NEGAHEART, this->X, this->Y);
			this->InitD[ML_ATTACK] = -1;
			Link_Transform(this, 1);
			if (Link->Item[I_PARTNER]) Link_Waitframe2(this, 2);
			else Link_Waitframe2(this, 5);
		}
		if (Link->Item[I_PARTNER])
		{
			Link_Transform(this, 7);
			Game->PlaySound(SFX_LINKHURT);
			for (i = 0; i < 60; ++i) Link_Waitframe2(this, 0);
			Link_Transform(this, 5);
			lweapon DarkItem = CreateLWeaponAt(LW_SPARKLE,this->X,this->Y);
			DarkItem->UseSprite(SP_LINK_TRIFORCE);
			DarkItem->DrawYOffset = -16;
			for (i = 0; i < 60; ++i) Link_Waitframe2(this, 0);
			for (i = 0; i < 60; ++i) 
			{
				if ((i % 4) < 2) Link_Waitframe2(this, 5);
				else Link_Waitframe2(this, 6);
			}
		}
		int Attack[2];
		Attack[0] = Rand(360);
		Attack[1] = 0;
		Link_Transform(this, 6);
		while(true)
		{
			if (Link->Item[I_PARTNER])
			{
				++Attack[1];
				Attack[1]%=30;
				if((Attack[1] % 30) < 4)
				{
					Link_Waitframe2(this, 6);
				}
				else 
				{
					this->InitD[0] = Rand(4);
					int Vx = VectorX(2, Attack[0]);
					int Vy = VectorY(2, Attack[0]);
					bool anglechanged = false;
					if ((Vx < 0 && !CanWalk(this->X, this->Y, DIR_LEFT, 2, false)) || (Vx > 0 && !CanWalk(this->X, this->Y, DIR_RIGHT, 2, false))) {Vx = -Vx; anglechanged = true;}
					if ((Vy < 0 && !CanWalk(this->X, this->Y, DIR_UP, 2, false)) || (Vy > 0 && !CanWalk(this->X, this->Y, DIR_DOWN, 2, false))) {Vy = -Vy; anglechanged = true;}
					if (anglechanged) Attack[0] = Angle(0, 0, Vx, Vy);
					Link_MoveAtAngle(this, Attack[0], 1.5);
					Link_Waitframe2(this, 5);
				}
			}
			else Link_Waitframe2(this, 5);
		}
		
	}
	bool Link_Waitframe2(ffc this, int Autoface)
	{
		if (Autoface == 1 || Autoface == 3) this->InitD[0] = (this->InitD[0] - (this->InitD[0] % 4)) + AngleDirFixed4(Angle(this->InitD[ML_LASTX], this->InitD[ML_LASTY], this->X, this->Y));
		if (Autoface == 2 || Autoface == 4) this->InitD[0] = (this->InitD[0] - (this->InitD[0] % 4)) + AngleDirFixed4(Angle(this->X, this->Y, Link->X, Link->Y)); //Face Zelda
		this->InitD[0]+=4;
		this->InitD[0]%=80;
		this->InitD[ML_LASTX] = this->X;
		this->InitD[ML_LASTY] = this->Y;
		if (Autoface < 5) 
		{
			DamageArea(8, this->X, this->Y, this->InitD[ML_ODATA] + Floor(this->InitD[0] / 40) + (this->InitD[ML_STATE]*20) + (this->InitD[0] % 4)*2, 6);
			if (Link->Item[I_SHIELD1] && this->InitD[ML_STATE] <= 4)
			{
				for(int i = Screen->NumLWeapons(); i > 0; --i)
				{
					lweapon FFCrandoLW = Screen->LoadLWeapon(i);
					if(!FFCrandoLW->isValid()) continue;
					if (FFCrandoLW->ID != LW_CANEOFBYRNA && FFCrandoLW->ID != LW_BAIT)
					{
						if (FFCrandoLW->X > this->X - 14 && FFCrandoLW->X < this->X + 14 && FFCrandoLW->Y > this->Y - 14 && FFCrandoLW->Y < this->Y+14 && FFCrandoLW->CollDetection == true)
						{
							if(FFCrandoLW->Dir != (this->InitD[0] % 4))
							{
								Remove(FFCrandoLW);
								Game->PlaySound(SFX_CLINK);
							}
						}
					}
				}
				for (int i = 0; i < 4; ++i) 
				{
					if (i != OppositeDir(this->InitD[0] % 4)) 
					{
						if (i != (this->InitD[0] % 4) || this->InitD[ML_STATE] >= 2) DrawArea(this->X, this->Y, 1270 + i*2, 6);
					}
				}
			}
		}
		else if (Autoface == 6) DrawArea(this->X, this->Y, this->InitD[ML_ODATA] + Floor(this->InitD[0] / 40) + (this->InitD[ML_STATE]*20) + (this->InitD[0] % 4)*2, 6);
		Waitframe();
		npc LinkGhost = LoadNPCOf(377);
		if (!LinkGhost->isValid())
		{
			this->Data = 0;
			this->Script = 0;
			Quit();
		}
		return true;
	}
	void Link_MoveAtAngle(ffc this, int angle, int step)
	{
		if ((VectorX(step, angle) < 0 && CanWalk(this->X, this->Y, DIR_LEFT, step, false)) || (VectorX(step, angle) > 0 && CanWalk(this->X, this->Y, DIR_RIGHT, step, false)))
		{
			this->X += VectorX(step, angle);
		}
		if ((VectorY(step, angle) < 0 && CanWalk(this->X, this->Y, DIR_UP, step, false)) || (VectorY(step, angle) > 0 && CanWalk(this->X, this->Y, DIR_DOWN, step, false)))
		{
			this->Y += VectorY(step, angle);
		}
	}
	void Link_MoveAtAngle(ffc this, int angle, int step, bool ignoresolids)
	{
		if (!ignoresolids)
		{
			if ((VectorX(step, angle) < 0 && CanWalk(this->X, this->Y, DIR_LEFT, step, false)) || (VectorX(step, angle) > 0 && CanWalk(this->X, this->Y, DIR_RIGHT, step, false)))
			{
				this->X += VectorX(step, angle);
			}
			if ((VectorY(step, angle) < 0 && CanWalk(this->X, this->Y, DIR_UP, step, false)) || (VectorY(step, angle) > 0 && CanWalk(this->X, this->Y, DIR_DOWN, step, false)))
			{
				this->Y += VectorY(step, angle);
			}
		}
		else
		{
			this->X += VectorX(step, angle);
			this->Y += VectorY(step, angle);
		}
	}
	void Link_MoveAt4Way(ffc this, int step, int X, int Y)
	{
		if (this->X != X && (this->Y == Y || Abs(this->X - X) < Abs(this->Y - Y))) 
		{
			if (Abs(this->X - X) < step) this->X = X;
			else
			{
				if (this->X < X) this->X += step;
				if (this->X > X) this->X -= step;
			}
		}
		if (this->Y != Y && (this->X == X || Abs(this->Y - Y) < Abs(this->X - X))) 
		{
			if (Abs(this->Y - Y) < step) this->Y = Y;
			else
			{
				if (this->Y < Y) this->Y += step;
				if (this->Y > Y) this->Y -= step;
			}
		}
	}
	void Link_MoveTowardsLink(ffc this, int step)
	{
		int angle = Angle(this->X, this->Y, Link->X, Link->Y);
		Link_MoveAtAngle(this, angle, step);
	}
	void Link_Transform(ffc this, int state)
	{
		this->InitD[ML_STATE] = state;
	}
	void DamageArea(int damage, int x, int y)
	{
		eweapon e = FireEWeapon(EW_LINKWEAPONS, x, y, 0, 0, damage, -1, -1, EWF_UNBLOCKABLE);
		e->Dir = Link->Dir;
		e->DrawYOffset = -1000;
		SetEWeaponLifespan(e, EWL_TIMER, 1);
		SetEWeaponDeathEffect(e, EWD_VANISH, 0);
	}
	void DamageArea(int damage, int x, int y, int tile, int cset)
	{
		eweapon e = FireEWeapon(EW_LINKWEAPONS, x, y, 0, 0, damage, -1, -1, EWF_UNBLOCKABLE);
		e->Dir = Link->Dir;
		//e->DrawYOffset = -1000;
		e->Tile = tile;
		e->OriginalTile = tile;
		e->CSet = cset;
		SetEWeaponLifespan(e, EWL_TIMER, 1);
		SetEWeaponDeathEffect(e, EWD_VANISH, 0);
	}
	void DrawArea(int x, int y, int tile, int cset)
	{
		eweapon e = FireEWeapon(EW_LINKWEAPONS, x, y, 0, 0, 0, -1, -1, EWF_NO_COLLISION);
		e->Dir = Link->Dir;
		//e->DrawYOffset = -1000;
		e->Tile = tile;
		e->OriginalTile = tile;
		e->CSet = cset;
		SetEWeaponLifespan(e, EWL_TIMER, 1);
		SetEWeaponDeathEffect(e, EWD_VANISH, 0);
	}
	void DrawComboAyy(int layer, int cx, int cy, int tile, int blockw, int blockh, int cset, int xscale, int yscale, int rx, int ry, int rangle, int frame, int flip, bool transparency, int opacity){
		int w = xscale;
		if(xscale==-1)
			w = blockw*16;
		int h = yscale;
		if(yscale==-1)
			h = blockh*16;
		Screen->DrawCombo(layer, cx-w/2, cy-h/2, tile, blockw, blockh, cset, xscale, yscale, rx-w/2, ry-h/2, rangle, frame, flip, transparency, opacity);
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Mirror Link Partner (end)
// By Dimi
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Environment Helper (Start)
// By Dimi
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
ffc script EnvironmentHelper
{
	void run(int weather, int weather2, int titlestring)
	{
		while(true)
		{
			Waitframe();
		}
	}
}
// This script is deliberately blank. The Global checks it's FFC arguments while it's running the EnvironmentHelper script.
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Environment Helper (Start)
// By Dimi
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Trigger secrets if no item (start)
// By Mitsukara
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// Used in a few places to make a "no cane" playthrough of most of the game more viable, similar to the no-sword Z1 challenge.
ffc script TriggerSecretsIfNoItem
{
	void run(int WhatItemA, int WhatItemB, int WhatItemC)

// If D1 is 0, only D0 will be checked.
// If D2 is 0 but D1 is set above 0, only D0 and D1 will be checked. If D2 is set above 0, all three are checked.
// If Link has any of the items that are being checked, secrets will not be triggered by this script.
// Don't use negative numbers or numbers above the highest-numbered item in the item editor (255 in version 2.53.1), since those aren't valid item IDs.

	{
		if (!Link->Item[WhatItemA])
		{
			if (WhatItemB == 0 || !Link->Item[WhatItemB])
			{
				if (WhatItemC == 0 || !Link->Item[WhatItemC])
				{
					Screen->TriggerSecrets();
				}
			}
		}
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Trigger secrets if no item (end)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Fake No Scroll (start)
// By Dimi
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
void FakeNoScroll1()
{
	if (Link->Action != LA_SCROLLING)
	{
		if (RememberStuff[REMEMBER_SCROLLING] <= 0)
		{
			if (Link->Y <= 1 && Link->InputUp || Link->Y >= 159 && Link->InputDown || Link->X <= 1 && Link->InputLeft || Link->X >= 239 && Link->InputRight)
			{
				if (Link->Y <= 1) RememberStuff[REMEMBER_SCROLLDIR] = DIR_UP;
				else if (Link->Y >= 159) RememberStuff[REMEMBER_SCROLLDIR] = DIR_DOWN;
				else if (Link->X <= 1) RememberStuff[REMEMBER_SCROLLDIR] = DIR_LEFT;
				else if (Link->X >= 239) RememberStuff[REMEMBER_SCROLLDIR] = DIR_RIGHT;
				
				RememberStuff[REMEMBER_SCROLLING] = 16;
				if (RememberStuff[REMEMBER_SCROLLDIR] == DIR_UP && Game->GetCurScreen() > 16 || 
					RememberStuff[REMEMBER_SCROLLDIR] == DIR_DOWN && Game->GetCurScreen() < 112 || 
					RememberStuff[REMEMBER_SCROLLDIR] == DIR_LEFT && (Game->GetCurScreen() % 16 != 0 || Game->GetCurScreen() == 32) || 
					RememberStuff[REMEMBER_SCROLLDIR] == DIR_RIGHT && (Game->GetCurScreen() % 16 != 15 || Game->GetCurScreen() == 47))
					
				{
					if (Game->GetCurScreen() != 20 && Game->GetCurScreen() != 110 
					&& (RememberStuff[REMEMBER_SCROLLDIR] != DIR_DOWN || (Game->GetCurScreen() != 32 && Game->GetCurScreen() != 74)))
					{
						int warpdmap = Game->GetCurDMap();
						int warpscreen = Game->GetCurDMapScreen();
						if (RememberStuff[REMEMBER_SCROLLDIR] == DIR_UP)
						{
							warpscreen-=16;
							Link->Y = 158;
							Link->DrawYOffset = 17;
						}
						if (RememberStuff[REMEMBER_SCROLLDIR] == DIR_DOWN)
						{
							warpscreen+=16;
							Link->Y = 2;
							Link->DrawYOffset = -17;
						}
						if (RememberStuff[REMEMBER_SCROLLDIR] == DIR_LEFT)
						{
							--warpscreen;
							Link->X = 238;
							Link->DrawXOffset = 17;
						}
						if (RememberStuff[REMEMBER_SCROLLDIR] == DIR_RIGHT)
						{
							++warpscreen;
							Link->X = 2;
							Link->DrawXOffset = -17;
						}
						
						if (Game->GetCurScreen() == 47 && RememberStuff[REMEMBER_SCROLLDIR] == DIR_RIGHT) warpscreen = 32;
						else if (Game->GetCurScreen() == 32 && RememberStuff[REMEMBER_SCROLLDIR] == DIR_LEFT) warpscreen = 47;
						RememberStuff[REMEMBER_SCROLL_X] = Link->X;
						RememberStuff[REMEMBER_SCROLL_Y] = Link->Y;
						NoAction();
						Link->PitWarp(warpdmap, warpscreen);
					}
					else
					{
						RememberStuff[REMEMBER_SCROLLDIR] = -1;
						RememberStuff[REMEMBER_SCROLLING] = 0;
					}
				}
				else
				{
					RememberStuff[REMEMBER_SCROLLDIR] = -1;
					RememberStuff[REMEMBER_SCROLLING] = 0;
				}
			}
		}
		else
		{
			if (Link->DrawXOffset > 0) --Link->DrawXOffset;
			if (Link->DrawXOffset < 0) ++Link->DrawXOffset;
			if (Link->DrawYOffset > 0) --Link->DrawYOffset;
			if (Link->DrawYOffset < 0) ++Link->DrawYOffset;
			
			--RememberStuff[REMEMBER_SCROLLING];
			if (RememberStuff[REMEMBER_SCROLLING] <= 0)
			{
				if (RememberStuff[REMEMBER_SCROLLDIR] == DIR_UP)
				{
					Link->Y = 160;
				}
				if (RememberStuff[REMEMBER_SCROLLDIR] == DIR_DOWN)
				{
					Link->Y = 0;
				}
				if (RememberStuff[REMEMBER_SCROLLDIR] == DIR_LEFT)
				{
					Link->X = 240;
				}
				if (RememberStuff[REMEMBER_SCROLLDIR] == DIR_RIGHT)
				{
					Link->X = 0;
				}
				RememberStuff[REMEMBER_SCROLL_X] = 0;
				RememberStuff[REMEMBER_SCROLL_Y] = 0;
			}
			NoAction();
			if (RememberStuff[REMEMBER_SCROLLDIR] == DIR_UP)
			{
				Link->InputUp = true;
			}
			if (RememberStuff[REMEMBER_SCROLLDIR] == DIR_DOWN)
			{
				Link->InputDown = true;
			}
			if (RememberStuff[REMEMBER_SCROLLDIR] == DIR_LEFT)
			{
				Link->InputLeft = true;
			}
			if (RememberStuff[REMEMBER_SCROLLDIR] == DIR_RIGHT)
			{
				Link->InputRight = true;
			}
		}
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Fake No Scroll (end)
// By Dimi
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Fake No Scroll 2 (start)
// By Dimi
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
void FakeNoScroll2()
{
	if (Link->Action != LA_SCROLLING)
	{
		if (RememberStuff[REMEMBER_SCROLLING] > 0)
		{
			Link->X = RememberStuff[REMEMBER_SCROLL_X];
			Link->Y = RememberStuff[REMEMBER_SCROLL_Y];
			NoAction();
		}
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Fake No Scroll 2 (end)
// By Dimi
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------


// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Enemy Loop / For Loop of NPCs (Start)
// Original NPC behaviors and loop functionality by Mitsukara, 
// Ported to an FFC from the global by Dimi due to ZASM limits
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

ffc script EnemyLoopYesSeriouslyZCWhy
{
	void run()
	{
		int ForTimer;
		int ForTimerTwo;
		npc randoNPC;
		lweapon randoLW;
		eweapon randoEW;
		int EverySix = 0;
		lweapon SomariaBlock;
		lweapon BowWow;
		while(true)
		{
			if (NumLWeaponsOf(LW_SOMARIA) > 0 && !SomariaBlock->isValid()) SomariaBlock = LoadLWeaponOf(LW_SOMARIA);
			if (NumLWeaponsOf(LW_BOWWOW) > 0 && !BowWow->isValid()) BowWow = LoadLWeaponOf(LW_BOWWOW);
			--EverySix; EverySix%=6;
			for(ForTimer = Screen->NumNPCs(); ForTimer > 0; --ForTimer)
			{
				randoNPC = Screen->LoadNPC(ForTimer);
				if(!randoNPC->isValid()) continue;
				{


		// --- Dodongo dislikes LTTP Partner Superbombs
					if (randoNPC->Type == NPCT_DODONGO)
					{
						if (Link->Item[I_LTTPSBOMB])
						{
							if (randoNPC->Dir != DIR_RIGHT)
							{
								if(Partner[FOLLOW_X] > randoNPC->X - 8 && Partner[FOLLOW_X] < randoNPC->X + 8 && Partner[FOLLOW_Y] > randoNPC->Y - 8 && Partner[FOLLOW_Y] < randoNPC->Y + 8)
								{
									Link->Item[I_LTTPSBOMB] = false;
									randoNPC->HP = 0;
									//lweapon KaBEWM = CreateLWeaponAt(LW_SBOMBBLAST,randoNPC->X,randoNPC->Y);
									//if (KaBEWM->isValid()) KaBEWM->Damage = 32;
									//eweapon KerBEWM = CreateEWeaponAt(EW_SBOMBBLAST,randoNPC->X,randoNPC->Y);
									//if (KerBEWM->isValid()) KerBEWM->Damage = 64;
								}
							}
							else
							{
								if(Partner[FOLLOW_X] > randoNPC->X + 8 && Partner[FOLLOW_X] < randoNPC->X + 24 && Partner[FOLLOW_Y] > randoNPC->Y - 8 && Partner[FOLLOW_Y] < randoNPC->Y + 8)
								{
									Link->Item[I_LTTPSBOMB] = false;
									randoNPC->HP = 0;
									//lweapon KaBEWM = CreateLWeaponAt(LW_SBOMBBLAST,randoNPC->X,randoNPC->Y);
									//if (KaBEWM->isValid()) KaBEWM->Damage = 32;
									//eweapon KerBEWM = CreateEWeaponAt(EW_SBOMBBLAST,randoNPC->X,randoNPC->Y);
									//if (KerBEWM->isValid()) KerBEWM->Damage = 6;
								}
							}
						}
						if (NumLWeaponsOf(LW_SBOMBBLAST) > 2)
						{
							lweapon Kablammo = LoadLWeaponOf(LW_SBOMBBLAST);
							if (Kablammo->isValid())
							{
								if (Kablammo->Damage >= 64)
								{
									if (Collision(randoNPC,Kablammo)) randoNPC->HP = 0;
								}
							}
						} 
					}
		// --- NPCs appear above subscreen
					if (randoNPC->Y < 0 && !Link->Item[I_CURSEDPICTOBOX])
					{
						if (randoNPC->Type != NPCT_ROCK)
						{
							if (Game->Counter[CR_WEATHER] == 0 || Game->Counter[CR_WEATHER] > ENV_BLOCKY && Game->Counter[CR_WEATHER] < ENV_WAVY1) 
								Screen->DrawTile(
								7,
								randoNPC->X+randoNPC->DrawXOffset,		//start X
								randoNPC->Y-randoNPC->Z+randoNPC->DrawYOffset,	//start y
								randoNPC->Tile,					//tile ID
								randoNPC->TileWidth,				//tile width
								randoNPC->TileHeight,				//tile width	
								randoNPC->CSet,					//tile cset	
								-1,-1,-1,-1,0,0,1,128);					
						}
					}

		// --- Big enemies 
					// 2x2:
					if (randoNPC->ItemSet == IS_BIGENEMY)
					{
						if (randoNPC->Extend < 3)
						{
							randoNPC->Extend = 3;
							randoNPC->TileWidth = 2;
							randoNPC->TileHeight = 2;
							randoNPC->HitHeight = 32;
							randoNPC->HitWidth = 32;
							randoNPC->HitXOffset = -8;
							randoNPC->DrawXOffset = -8;
							if (IsSideview())
							{
								randoNPC->HitYOffset = -16;
								randoNPC->DrawYOffset = -16;
							}
							else
							{
								randoNPC->HitYOffset = -8;
								randoNPC->DrawYOffset = -8;
							}
						}
					}
					// 1x4:
					else if (randoNPC->ItemSet == IS_FOURTALL)
					{
						if (randoNPC->Extend < 3)
						{
							randoNPC->Extend = 3;
							randoNPC->TileHeight = 4;
							randoNPC->HitHeight = 64;
							randoNPC->DrawYOffset = -48;
							randoNPC->HitYOffset = -48;
						}
					}

					// 1x3:
					else if (randoNPC->ItemSet == IS_THREETALL)
					{
						if (randoNPC->Extend < 3)
						{
							randoNPC->Extend = 3;
							randoNPC->TileHeight = 3;
							randoNPC->HitHeight = 48;
							randoNPC->DrawYOffset = -32;
							randoNPC->HitYOffset = -32;
						}
					}
					// 1x2:
					else if (randoNPC->ItemSet == IS_TWOTALL)
					{
						if (randoNPC->Extend < 3)
						{
							randoNPC->Extend = 3;
							randoNPC->TileHeight = 2;
							randoNPC->HitHeight = 32;
							randoNPC->DrawYOffset = -16;
							randoNPC->HitYOffset = -16;
						}
					}
					// 4x1:
					else if (randoNPC->ItemSet == IS_FOURWIDE)
					{
						if (randoNPC->Extend < 3)
						{
							randoNPC->Extend = 3;
							randoNPC->TileWidth = 4;
							randoNPC->HitWidth = 64;
							randoNPC->DrawXOffset = -32;
							randoNPC->HitXOffset = -32;
						}
					}

		// --- Slow big traps
					if (randoNPC->Type == NPCT_TRAP)	//It's a trap!
					{
						if (randoNPC->Step > 120)
						{
							if (randoNPC->TileWidth > 1 || randoNPC->TileHeight > 1) randoNPC->Step = 120;
						} 
					}

		// --- Ally NPCs fire lweapons (Good Octorok)
					if (randoNPC->Misc[MISC_NPCLWEAPON] > 0)
					{
						if (randoNPC->Misc[MISC_NPCLWEAPONTIMER] > 0) --randoNPC->Misc[MISC_NPCLWEAPONTIMER];
						else
						{
							lweapon NPCLWeap = CreateLWeaponAt(randoNPC->Misc[MISC_NPCLWEAPON],randoNPC->X,randoNPC->Y);
							NPCLWeap->UseSprite(randoNPC->Misc[MISC_NPCLWEAPONSPRITE]);
							NPCLWeap->Damage = randoNPC->WeaponDamage;
							NPCLWeap->Dir = randoNPC->Dir;
							NPCLWeap->Step = 255;
							randoNPC->Misc[MISC_NPCLWEAPONTIMER] = Rand(32,128);
						}
					}

		// --- NPCs' weapon type is switched to a Script weapon based on using special Item Drop Sets
		// Sorry for this workaround, but I wanted a handy way to set their weapons to EW_SCRIPT weapons from the editor.

					if (randoNPC->ItemSet == IS_BOLA)
					{
						if (randoNPC->Weapon != EW_BOLA) randoNPC->Weapon = EW_BOLA;
					}
					else if (randoNPC->ItemSet == IS_STATIONARYBOMB)
					{
						if (randoNPC->Weapon != EW_STATIONARYBOMB) randoNPC->Weapon = EW_STATIONARYBOMB;
					}
					else if (randoNPC->ItemSet == IS_MACE)
					{
						if (randoNPC->Weapon != EW_MACE) randoNPC->Weapon = EW_MACE;
					}
					else if (randoNPC->ItemSet == IS_SOMARIA)
					{
						if (randoNPC->Weapon != EW_SOMARIA) randoNPC->Weapon = EW_SOMARIA;
					}
					else if (randoNPC->ItemSet == IS_SPIKES)
					{
						if (randoNPC->Weapon != EW_SPIKES) randoNPC->Weapon = EW_SPIKES;
					}
					else if (randoNPC->ItemSet == IS_CONVEYOR)
					{
						if (randoNPC->Weapon != EW_CONVEYOR) randoNPC->Weapon = EW_CONVEYOR;
					}

		// --- Tougher / Weaker Monsters effect

					if (Link->Item[I_TOUGHMONSTERS])
					{	
						if (randoNPC->Misc[MISC_TOUGHENEMY] == 0 && randoNPC->ID != NPC_MIRRORLINK)
						{
							if (randoNPC->ID != NPC_BUBBLEITEMP && randoNPC->ID != NPC_BUBBLEITEMR && randoNPC->ID != NPC_BUBBLEITEMT
							&& randoNPC->ID != NPC_BUBBLESWORDP && randoNPC->ID != NPC_BUBBLESWORDR && randoNPC->ID != NPC_BUBBLESWORDT
							&& randoNPC->ID != NPC_BUBBLE_WHISP_A && randoNPC->ID != NPC_BUBBLE_WHISP_B)
							{
								if (NumTriforcePieces() < 4)
								{
									randoNPC->Damage = randoNPC->Damage + 2;
									randoNPC->WeaponDamage = randoNPC->WeaponDamage + 1;
									if (randoNPC->Type != NPCT_ROCK) randoNPC->HP = randoNPC->HP*1.5;
									else randoNPC->HP = 10;
								}
								else
								{
									if (randoNPC->ID == NPCT_WALK && randoNPC->Step > 0) randoNPC->Step = randoNPC->Step + 20;
									randoNPC->Damage = randoNPC->Damage + 4;
									if (randoNPC->Type != NPCT_DODONGO) randoNPC->WeaponDamage = randoNPC->WeaponDamage + 2;
									else randoNPC->WeaponDamage = randoNPC->WeaponDamage + 4;
									if (randoNPC->Type != NPCT_ROCK)
									{
										if (randoNPC->ID == NPC_MIRRORGANNON)
										{
											if (randoNPC->HP < 80) randoNPC->HP = 80;
											else randoNPC->HP = randoNPC->HP*1.5;
										}
										else if (randoNPC->Type == NPCT_DODONGO) randoNPC->HP = randoNPC->HP*1.5;
										else randoNPC->HP = randoNPC->HP *2;
									}
									else randoNPC->HP = 10;
								}				
								if (randoNPC->Type != NPCT_GUY )
								{
									if (randoNPC->Type != NPCT_GANON)
									{
										if (randoNPC->ID != NPC_FRIENDLYOCTO)
										{
											if (randoNPC->CSet == 8) randoNPC->CSet = 7;
											else if (randoNPC->CSet == 7) randoNPC->CSet = 5;
											else if (randoNPC->CSet == 9) randoNPC->CSet = 10;
											else if (randoNPC->CSet >= 12) randoNPC->CSet = 11;
										}
									}
								}
							}
							randoNPC->Misc[MISC_TOUGHENEMY] = 1;
						}
					}
					else if (Link->Item[I_WEAKMONSTERS])
					{	
						if (randoNPC->Misc[MISC_TOUGHENEMY] == 0)
						{
							{
								if (randoNPC->ID != NPC_FRIENDLYOCTO)
								{
									if (randoNPC->ID == NPCT_WALK && randoNPC->Step > 20) randoNPC->Step = randoNPC->Step - 20;
									if (randoNPC->Damage > 4) randoNPC->Damage = randoNPC->Damage - 4;
									else if (randoNPC->Damage > 2) randoNPC->Damage = randoNPC->Damage - 2;
									else if (randoNPC->Damage > 0) randoNPC->Damage = 1;
									if (randoNPC->Type != NPCT_DODONGO && randoNPC->WeaponDamage > 2) randoNPC->WeaponDamage = randoNPC->WeaponDamage - 2;
									if (randoNPC->Type != NPCT_ROCK)
									{
										if (randoNPC->Attributes[NPCA_WALK_DEATHTYPE] != NPCA_WALK_DEATH_SPLITHIT)
										{
											if (
												randoNPC->ID != NPC_MOLDORM_GROW_HEAD1 
												&& randoNPC->ID != NPC_MOLDORM_GROW_HEAD2 
												&& randoNPC->ID != NPC_MOLDORM_GROW_TAIL1 
												&& randoNPC->ID != NPC_MOLDORM_GROW_TAIL2 
												&& randoNPC->ID != NPC_LANMOLA_GROW_HEAD1
												&& randoNPC->ID != NPC_LANMOLA_GROW_HEAD2
												&& randoNPC->ID != NPC_LANMOLA_GROW_TAIL1
												&& randoNPC->ID != NPC_LANMOLA_GROW_TAIL2
												&& randoNPC->ID != NPC_MANHANDLA_GROW_CORE
												&& randoNPC->ID != NPC_MANHANDLA_GROW_HEAD
												&& randoNPC->ID != NPC_MIRRORGANNON 
												&& randoNPC->HP > 1
											) randoNPC->HP = randoNPC->HP / 2;
										}
									}
									else randoNPC->HP = 1;
								}
								randoNPC->Misc[MISC_TOUGHENEMY] = 2;
							}
						}
					}

		

		// --- Leevers are killed by the shovel
					if (RememberStuff[REMEMBER_DIGDELAY] > 0)
					{
						if (randoNPC->Type == NPCT_LEEVER)
						{
							if (LinkCollision(randoNPC)) randoNPC->HP = 0;

						}
					}

		// --- Bow-wow eats random enemies
		// See also: Item: Bow-wow
				if (BowWow->isValid())
				{
					if (RememberStuff[REMEMBER_BOWWOW_EATDELAY] == 0)
					{
						if (Collision(BowWow,randoNPC))
						{
							if (randoNPC->Defense[NPCD_SBOMB] == NPCDT_NONE)
							{
								if (randoNPC->Type < NPCT_AQUAMENTUS && randoNPC->Type != NPCT_GUY || randoNPC->Type >= NPCT_OTHERFLOAT)
								{
									randoNPC->HP = Choose(randoNPC->HP,randoNPC->HP,randoNPC->HP,randoNPC->HP,randoNPC->HP,0);
									if (randoNPC->HP == 0)
									{
										RememberStuff[REMEMBER_BOWWOW_EATDELAY] = 255;
										if (Link->Item[I_ITEMSGFX]) Game->PlaySound(SFX_BOWWOW);
										else Game->PlaySound(SFX_FDSGLEEOK);
										Game->PlaySound(SFX_EDEAD);
									}
									else RememberStuff[REMEMBER_BOWWOW_EATDELAY] = 48;
								}
							}
							else if (randoNPC->Defense[NPCD_SBOMB] == NPCDT_IGNORE1)
							{
								randoNPC->HP = 0;
								RememberStuff[REMEMBER_BOWWOW_EATDELAY] = 255;
								if (Link->Item[I_ITEMSGFX]) Game->PlaySound(SFX_BOWWOW);
								else Game->PlaySound(SFX_FDSGLEEOK);
								Game->PlaySound(SFX_EDEAD);
							}
						}
					}
				}

		// --- Enemies shoot eweapons that normally can't
		// Applies to Tektites, Leevers, Peahats, Rocks, Ghini, Keese, Traps, Wallmasters, Dodongos, Other, and Other(Floating)

						if (Game->Counter[CR_CLOCK] == 0)
						{
							if (randoNPC->Weapon != 0)
							{
								if (randoNPC->Stun == 0)
								{
									if (randoNPC->HP > 0)
									{
										if (randoNPC->Misc[MISC_NPCSHOOT] == 0) randoNPC->Misc[MISC_NPCSHOOT] = Rand(96,160); 
										else --randoNPC->Misc[MISC_NPCSHOOT];
										if (randoNPC->Misc[MISC_NPCSHOOT] == 1)
										{
											//Trace(ForTimer); //debug feature for FFC port
											if (randoNPC->Type >= NPCT_TEKTITE && randoNPC->Type <= NPCT_WALLMASTER && randoNPC->Type != NPCT_ZORA || randoNPC->Type >= NPCT_OTHERFLOAT && randoNPC->Type <= NPCT_OTHER || randoNPC->Type == NPCT_DODONGO || randoNPC->Type == NPCT_WALK && randoNPC->Step == 0)
											{
												if (randoNPC->Attributes[10] == 0 && randoNPC->Attributes[11] == 0 || randoNPC->Type < NPCT_OTHERFLOAT || randoNPC->Type > NPCT_OTHER)
												{
													eweapon randoShoot;
													if (randoNPC->Type != NPCT_LEEVER || randoNPC->Tile != LEEVER_TILE && randoNPC->Tile != LEEVER_TILE + 1)
													{
														randoShoot = CreateEWeaponAt(randoNPC->Weapon, randoNPC->X + ((randoNPC->TileWidth-1)*8), randoNPC->Y + ((randoNPC->TileHeight-1)*8) );
														randoShoot->Dir = randoNPC->Dir;
														if (randoNPC->Type == NPCT_TEKTITE)
														{
															randoShoot->Angular = true;
															randoShoot->Angle = RadianAngle(randoNPC->X,randoNPC->Y,Link->X,Link->Y);
														}
														randoShoot->Damage = randoNPC->WeaponDamage;
														if (randoNPC->Weapon == EW_MAGIC)
														{
															Game->PlaySound(SFX_WAND);
															if (randoShoot->Dir == DIR_DOWN || randoShoot->Dir == DIR_LEFTDOWN || randoShoot->Dir == DIR_RIGHTDOWN) randoShoot->UseSprite(SP_MAGICDOWN);
															else if (randoShoot->Dir == DIR_LEFT) randoShoot->UseSprite(SP_MAGICLEFT);
															else if (randoShoot->Dir == DIR_RIGHT) randoShoot->UseSprite(SP_MAGICRIGHT);
														}
														else if (randoNPC->Weapon == EW_FIRE || randoNPC->Weapon == EW_FIRE2 || randoNPC->Weapon == EW_FIRETRAIL) Game->PlaySound(SFX_FIRE);	
														if (randoNPC->Type == NPCT_DODONGO)
														{
															if (randoNPC->Dir == DIR_RIGHT) randoShoot->X = randoNPC->X+16;
														} 
														if (randoShoot->ID == EW_FIRE)
														{
															if (randoNPC->Step > 60 && !randoShoot->Angular) randoShoot->Step = randoNPC->Step * 2;
														}
													}
													randoNPC->Misc[MISC_NPCSHOOT] = Rand(96,160);
												}
											}
										}
									}
								}
							}
						}

		// --- Rocks can be killed by bolas and octorok
					if (randoNPC->Type == NPCT_ROCK)
					{
						if (randoNPC->Stun == 0)
						{
							if (NumLWeaponsOf(LW_BOLA) > 0)
							{
								randoLW = LoadLWeaponOf(LW_BOLA);
								if (Collision(randoNPC,randoLW) && randoNPC->HP > 0)
								{
									if (randoNPC->HitWidth > 20)
									{
										if (randoNPC->HP == 1) randoNPC->HP = 6;
										else
										{
											randoNPC->Stun = 64;
											Game->PlaySound(SFX_GASP);
											Remove(randoLW);
											--randoNPC->HP;
											if (randoNPC->HP == 2) randoNPC->HP = 0;
										}
									}
									else randoNPC->HP = 0;
								}
							}
							if (NumLWeaponsOf(LW_REFROCK) > 0)
							{
								randoLW = LoadLWeaponOf(LW_REFROCK);
								if (Collision(randoNPC,randoLW) && randoNPC->HP > 0)
								{
									if (randoNPC->HitWidth > 20)
									{
										if (randoNPC->HP == 1) randoNPC->HP = 6;
										else
										{
											randoNPC->Stun = 64;
											Game->PlaySound(SFX_GASP);
											Remove(randoLW);
											--randoNPC->HP;
											if (randoNPC->HP == 2) randoNPC->HP = 0;
										}
									}
									else randoNPC->HP = 0;
								}
							}
						}
						else if (randoNPC->Stun > 1) randoNPC->CSet = Choose(6,7,8,9);
						else if (randoNPC->Stun == 1)
						{
							if (randoNPC->ID == NPC_FIREBOULDER)
							{
								if (Link->Item[I_TOUGHMONSTERS]) randoNPC->CSet = 10;
								else randoNPC->CSet = 9;
							}
							else
							{
								if (Link->Item[I_TOUGHMONSTERS]) randoNPC->CSet = 7;
								else randoNPC->CSet = 8;
							}
						}
					}

		// --- Traps change direction when they hit a Somaria Block
					if (randoNPC->Type == NPCT_TRAP)
					{
						if (SomariaBlock->isValid())
						{
							if (Collision(randoNPC,SomariaBlock))
							{
								if (randoNPC->Dir == DIR_RIGHT && randoNPC->X < SomariaBlock->X-12) randoNPC->X = SomariaBlock->X-16;
								else if (randoNPC->Dir == DIR_LEFT && randoNPC->X > SomariaBlock->X+12) randoNPC->X = SomariaBlock->X+16;
								else if (randoNPC->Dir == DIR_DOWN && randoNPC->Y < SomariaBlock->Y-12) randoNPC->Y = SomariaBlock->Y-16;
								else if (randoNPC->Dir == DIR_UP && randoNPC->Y > SomariaBlock->Y+12) randoNPC->Y = SomariaBlock->Y+16;
								randoNPC->Stun = 64;
							//	if (randoNPC->Dir == DIR_RIGHT) randoNPC->Dir = DIR_LEFT;
							//	else if (randoNPC->Dir == DIR_LEFT) randoNPC->Dir = DIR_RIGHT;
							//	else if (randoNPC->Dir == DIR_UP) randoNPC->Dir = DIR_DOWN;
							//	else if (randoNPC->Dir == DIR_DOWN) randoNPC->Dir = DIR_UP;
							}
						}
					}

		// --- Various Custom NPCs:

			// --- Wizzmaster (Wallmaster Wizzrobe)
						if (randoNPC->ID == NPC_WIZZMASTER)
						{
							if (randoNPC->CollDetection != 0)
							{
								if (Link->Y > randoNPC->Y - 20)
								{
									if (Link->X > randoNPC->X - 20)
									{
										if (Link->Y < randoNPC->Y + 20)
										{
											if (Link->X < randoNPC->X + 20)
											{
												randoNPC->CollDetection = 0;
											}
										}
									}
								}
							}
							else
							{
								if (Link->Y < randoNPC->Y - 20 || Link->Y > randoNPC->Y + 20 || Link->X < randoNPC->X - 20 || Link->X > randoNPC->X + 20)
								{
									randoNPC->CollDetection = 1;
								}
							}
						}

			// --- Moving Gleeoks
						if (randoNPC->Type == NPCT_GLEEOK)
						{
							//Uses ->Attributes[9], which is listed as "Misc. Attr. 10" in the enemy editor
	
							if (randoNPC->Stun == 0 && randoNPC->CSet != 8 && randoNPC->HP > 0 && Game->Counter[CR_CLOCK] == 0)
							{
								if (randoNPC->Attributes[NPCA_WALK_WALK_ATTRIB] == 1)
								{
									if (randoNPC->X > 32)
									{
										--randoNPC->X;
										randoNPC->Stun = 2;
									}
									else
									{ 
										randoNPC->Attributes[NPCA_WALK_WALK_ATTRIB] = 2;
										randoNPC->Stun = 16;
									}
								}
								if (randoNPC->Attributes[NPCA_WALK_WALK_ATTRIB] == 2)
								{
									if (randoNPC->X <208)
									{
										++randoNPC->X;
										randoNPC->Stun = 2;
									}
									else
									{
										randoNPC->Attributes[NPCA_WALK_WALK_ATTRIB] = 1;
										randoNPC->Stun = 16;
									}
								}
							}
						}
			// --- Girubokku
						if (randoNPC->ID == NPC_GIRUBOKKU)
						{
							if (IsSideview() && randoNPC->Stun == 0) randoNPC->Jump = 0;
							if (EverySix%2)
							{
								if (Game->Counter[CR_CLOCK] == 0)
								{
									if (randoNPC->Step > 0)
									{
										-- randoNPC->Step;
										if (randoNPC->Dir == DIR_UP)
										{
											if (randoNPC->Y > 0) --randoNPC->Y;
											else randoNPC->Dir = DIR_DOWN;
										}
										else if (randoNPC->Dir == DIR_DOWN)
										{
											if (randoNPC->Y < 160) ++randoNPC->Y;
											else randoNPC->Dir = DIR_UP;
										}
										else if (randoNPC->Dir == DIR_LEFT)
										{
											if (randoNPC->X > 0) --randoNPC->X;
											else randoNPC->Dir = DIR_RIGHT;
										}
										else if (randoNPC->Dir == DIR_RIGHT)
										{
											if (randoNPC->X < 240) ++randoNPC->X;
											else randoNPC->Dir = DIR_LEFT;
										}
										else if (randoNPC->Dir == DIR_LEFTUP)
										{
											if (randoNPC->X > 0 && randoNPC->Y > 0)
											{
												-- randoNPC-> X;
												-- randoNPC-> Y;
											}
											else randoNPC->Dir = DIR_RIGHTDOWN;
										}	
										else if (randoNPC->Dir == DIR_RIGHTUP)
										{	
											if (randoNPC->X < 240 && randoNPC->Y > 0)
											{
												++ randoNPC-> X;
												-- randoNPC-> Y;
											}
											else randoNPC->Dir = DIR_LEFTDOWN;
										}
										else if (randoNPC->Dir == DIR_LEFTDOWN)
										{
											if (randoNPC->X > 0 && randoNPC->Y < 160)
											{
												-- randoNPC-> X;
												++ randoNPC-> Y;
											}
											else randoNPC->Dir = DIR_RIGHTUP;
										}
										else if (randoNPC->Dir == DIR_RIGHTDOWN)
										{
											if (randoNPC->X < 240 && randoNPC->Y < 160)
											{
												++ randoNPC-> X;
												++ randoNPC-> Y;
											}
											else randoNPC->Dir = DIR_LEFTUP;
										}
									}
									else
									{
										if (randoNPC->Misc[MISC_NPCTURNWAIT] == 0)
										{
											randoNPC->OriginalTile = randoNPC->OriginalTile+20;
											randoNPC->Misc[MISC_NPCTURNWAIT] = 30;
											randoNPC->Defense[NPCD_SCRIPT] = NPCDT_NONE;
											randoNPC->Defense[NPCD_SWORD] = NPCDT_NONE;
											randoNPC->Defense[NPCD_ARROW] = NPCDT_NONE;
											randoNPC->Weapon = EW_FIREBALL;
										}
										else
										{
											-- randoNPC->Misc[MISC_NPCTURNWAIT];
											if (randoNPC->Misc[MISC_NPCTURNWAIT] == 1)
											{
												randoNPC->Step = 60;
												randoNPC->OriginalTile = randoNPC->OriginalTile - 20;
												randoNPC->Dir = Rand(DIR_UP,DIR_RIGHTDOWN);
												randoNPC->Defense[NPCD_SCRIPT] = NPCDT_BLOCK;
												randoNPC->Defense[NPCD_SWORD] = NPCDT_BLOCK;
												randoNPC->Defense[NPCD_ARROW] = NPCDT_BLOCK;
												randoNPC->Weapon = 0;
											}
										}
									}
								}
							}
						}

			// --- Deeler
						if (randoNPC->ID == NPC_DEELER1 || randoNPC->ID == NPC_DEELER2)
						{
							if (Game->Counter[CR_CLOCK] == 0)
							{
								if (randoNPC->Misc[MISC_NPCTURNWAIT] == 0)
								{
									randoNPC->Y = -52;
									randoNPC->Dir = DIR_DOWN;
									randoNPC->Misc[MISC_NPCTURNWAIT] = 1;
									randoNPC->Stun = 60;
								}
								if (randoNPC->ID == NPC_DEELER2 && randoNPC->HP <= 0)
								{
									npc DeelerChange = CreateNPCAt(NPC_DEELER2A,randoNPC->X,randoNPC->Y);
									DeelerChange->Stun = 60;
									Remove(randoNPC);
								}
								else if (randoNPC->Stun == 0 && randoNPC->HP > 0)
								{
									randoNPC->Jump = 0;
									if (randoNPC->Dir == DIR_UP)
									{
										if (randoNPC->Y > -52)
										{
											randoNPC->Y = randoNPC->Y - Rand(1,2);
											if (Game->Counter[CR_WEATHER] == 0 || Game->Counter[CR_WEATHER] > 5) 
											{
												if (Link->Item[I_CURSEDPICTOBOX]) Screen->Line(7,randoNPC->X+8+(120-Link->X), randoNPC->Y+(80-Link->Y), randoNPC->X+8+(120-Link->X), -56, 1, 1,0,0,0,128);
												else Screen->Line(7,randoNPC->X+8, randoNPC->Y, randoNPC->X+8, -56, 1, 1,0,0,0,128);
											}
										}
										else randoNPC->Dir = Choose(DIR_LEFT,DIR_RIGHT);
									}
									else if (randoNPC->Dir == DIR_DOWN)
									{
										if (Game->Counter[CR_WEATHER] == 0 || Game->Counter[CR_WEATHER] > 5) 
										{
											if (Link->Item[I_CURSEDPICTOBOX]) Screen->Line(7,randoNPC->X+8+(120-Link->X), randoNPC->Y+(80-Link->Y), randoNPC->X+8+(120-Link->X), -56, 1, 1,0,0,0,128);
											else Screen->Line(7,randoNPC->X+8, randoNPC->Y, randoNPC->X+8, -56, 1, 1,0,0,0,128);
										}
										if (randoNPC->Y < Link->Y) randoNPC->Y = randoNPC->Y + 3;
										else randoNPC->Dir = DIR_UP;
									}
									else
									{
										if (randoNPC->Y > -52)
										{
											randoNPC->Stun = 32;
											randoNPC->Dir = DIR_UP;
											randoNPC->Y = -48;
											if (randoNPC->X > Link->X - 20 && randoNPC->X < Link->X+20)
											{
												if (Link->X > 120) randoNPC->X = 16;
												else randoNPC->X = 224; 
											}
										}
										if (randoNPC->Dir == DIR_LEFT)
										{
											randoNPC->Dir = Choose(DIR_LEFT,DIR_LEFT,DIR_LEFT,DIR_LEFT,DIR_LEFT,Choose(DIR_LEFT,DIR_LEFT,DIR_LEFT,DIR_LEFT,DIR_LEFT,DIR_RIGHT));
											if (randoNPC->X > 0) --randoNPC->X;
											else randoNPC->Dir = DIR_RIGHT;
										}
										if (randoNPC->Dir == DIR_RIGHT)
										{
											randoNPC->Dir = Choose(DIR_RIGHT,DIR_RIGHT,DIR_RIGHT,DIR_RIGHT,DIR_RIGHT,Choose(DIR_RIGHT,DIR_RIGHT,DIR_RIGHT,DIR_RIGHT,DIR_RIGHT,DIR_LEFT));
											if (randoNPC->X < 240) ++randoNPC->X;
											else randoNPC->Dir = DIR_LEFT;
										}
										if (randoNPC->X >= Link->X -4 && randoNPC->X <= Link->X + 4) randoNPC->Dir = DIR_DOWN;
									}
								}
							}
						}
	
			// --- Moby
						if (randoNPC->ID == NPC_MOBY1 || randoNPC->ID == NPC_MOBY2 || randoNPC->ID == NPC_MOBY3)
						{	
							//always start at top of screen
							if (randoNPC->Misc[MISC_NPCTURNWAIT] == 0)
							{
								randoNPC->Y = Choose(-64,-80,-96);
								randoNPC->Misc[MISC_NPCTURNWAIT] = 1;
							}
	
							//brief stun when hit by Somaria Block
							if (SomariaBlock->isValid())
							{
								if (SomariaBlock->DeadState != WDS_ALIVE)
								{
									if (Collision(randoNPC,SomariaBlock))
									{
										if (randoNPC->Stun == 0) randoNPC->Stun = 16;
									}
								}
							}
							//brief stun when hit by Sword
							if (NumLWeaponsOf(LW_SWORD) > 0)
							{
								if (randoNPC->Stun == 0)
								{
									randoLW = LoadLWeaponOf(LW_SWORD);
									if (Collision(randoNPC,randoLW)) randoNPC->Stun = 16;
								}
							}
							if (randoNPC->Stun == 0 && randoNPC->HP > 0 && Game->Counter[CR_CLOCK] == 0)
							{
								randoNPC->Jump = 0;
								if (randoNPC->ASpeed > 6)
								{
									if (Link->X < randoNPC->X) randoNPC->Dir = DIR_LEFT;
									else randoNPC->Dir = DIR_RIGHT;
									if (randoNPC->Y < 180) ++randoNPC->Y;
									else
									{
										randoNPC->Y = -64;
										randoNPC->X = 16*Rand(0,15);
									}
									if (Link->Y >= randoNPC->Y-1 && Link->Y <= randoNPC->Y + 1)
									{
										randoNPC->ASpeed = 6;	
									}
								}
								else if (randoNPC->Dir == DIR_LEFT)
								{
									if (randoNPC->X > -24 || randoNPC->ID == NPC_MOBY3 && randoNPC->X > -104) randoNPC->X = randoNPC->X - 2;
									else
									{
										randoNPC->Y = -64;
										randoNPC->X = 16*Rand(0,15);
										randoNPC->ASpeed = 16;
									}
								}
								else if (randoNPC->Dir == DIR_RIGHT)
								{
									if (randoNPC->X < 280  || randoNPC->ID == NPC_MOBY3 && randoNPC->X < 360) randoNPC->X = randoNPC->X + 2;
									else
									{
										randoNPC->Y = -64;
										randoNPC->X = 16*Rand(0,15);
										randoNPC->ASpeed = 16;
									}
								}
							}
						}
	
			// --- Gibo	
						if (randoNPC->ID == NPC_GIBO1 || randoNPC->ID == NPC_GIBO2)
						{	
							if (randoNPC->HP == 0)
							{
								if (NumLWeaponsOf(LW_SPARKLE) < 2)
								{
									lweapon GiboByeBye = CreateLWeaponAt(LW_SPARKLE,randoNPC->Misc[MISC_GIBOX],randoNPC->Misc[MISC_GIBOY]);
									if (GiboByeBye->isValid()) GiboByeBye->UseSprite(SP_MISC_DEATH);
								}
							}
	
							// Link gets hurt by touching the Gibo's Cloud:
							if (randoNPC->HP > 0 && Link->X > randoNPC->Misc[MISC_GIBOX] -16 && Link->X < randoNPC->Misc[MISC_GIBOX] +16 && Link->Y > randoNPC->Misc[MISC_GIBOY] -16 && Link->Y < randoNPC->Misc[MISC_GIBOY] +16)
							{	
								if (Link->Action != LA_GOTHURTLAND && Link->Action != LA_GOTHURTWATER)
								{
									if (Screen->NumEWeapons() < 64)
									{
										eweapon HitLink = CreateEWeaponAt(EW_FIRE,Link->X,Link->Y);
										HitLink->Damage = randoNPC->WeaponDamage;
										HitLink->DrawYOffset = 299;
										HitLink->Dir = Link->Dir;
									}
								}
							}
	
							// Sets Big Gibo's position to Little Gibo's initial position:
							if (randoNPC->Misc[MISC_GIBOX] == 0)
							{
								if (randoNPC->X == 0) randoNPC->X = 8;
								randoNPC->Misc[MISC_GIBOX] = randoNPC->X;
								randoNPC->Misc[MISC_GIBOY] = randoNPC->Y;
							}
	
							// Draws the Big Gibo:
							else
							{	
								// Controls the Big Gibo's animation speed:
								if (randoNPC->Rate < 36) ++randoNPC->Rate;
								else randoNPC->Rate = 12;
	
								if (randoNPC->X > randoNPC->Misc[MISC_GIBOX]-1)
								{
	
									if (randoNPC->Rate < 24) Screen->DrawTile(
									2,
									randoNPC->Misc[MISC_GIBOX]-8,	//start X
									randoNPC->Misc[MISC_GIBOY]-8,	//start y
									randoNPC->OriginalTile + 20,	//tile ID
									2,				//tile width
									2,				//tile width
									randoNPC->CSet,			//tile cset
									-1,-1,-1,-1,0,FLIP_NONE,1,128);
	
									else Screen->DrawTile(
									2,
									randoNPC->Misc[MISC_GIBOX]-8,	//start X
									randoNPC->Misc[MISC_GIBOY]-8,	//start y
									randoNPC->OriginalTile + 22,	//tile ID
									2,				//tile width
									2,				//tile width
									randoNPC->CSet,			//tile cset
									-1,-1,-1,-1,0,FLIP_NONE,1,128);
								}
								else
								{
									if (randoNPC->Rate < 24) Screen->DrawTile(
									2,
									randoNPC->Misc[MISC_GIBOX]-8,	//start X
									randoNPC->Misc[MISC_GIBOY]-8,	//start y
									randoNPC->OriginalTile + 60,	//tile ID
									2,				//tile width
									2,				//tile width
									randoNPC->CSet,			//tile cset
									-1,-1,-1,-1,0,FLIP_NONE,1,128);
	
									else Screen->DrawTile(
									2,
									randoNPC->Misc[MISC_GIBOX]-8,	//start X
									randoNPC->Misc[MISC_GIBOY]-8,	//start y
									randoNPC->OriginalTile + 62,	//tile ID
									2,				//tile width
									2,				//tile width
									randoNPC->CSet,			//tile cset
									-1,-1,-1,-1,0,FLIP_NONE,1,128);
								}
							}
	
							// The Little Gibo gets ready to move:
							if (randoNPC->Step == 0)
							{
								if (Game->Counter[CR_CLOCK] == 0)
								{
									randoNPC->Dir = Choose(Choose(DIR_UP,DIR_DOWN,DIR_LEFT,DIR_RIGHT),Choose(DIR_LEFTUP,DIR_LEFTDOWN,DIR_RIGHTUP,DIR_RIGHTDOWN));
									randoNPC->Step = Rand(64,180);
								}	
							}
	 
							else if (randoNPC->Stun == 0 && Game->Counter[CR_CLOCK] == 0)
							{
								if (randoNPC->HitYOffset == 0)
								{
									// Timer for the Little Gibo to stop moving:
									--randoNPC->Step;
	
									if (randoNPC->Step == 0)
									{
										// The Little Gibo stops moving and becomes (sorta) invincible:
										randoNPC->HitYOffset = 1;
										randoNPC->Defense[NPCD_ARROW] = NPCDT_BLOCK;
										randoNPC->Defense[NPCD_BEAM] = NPCDT_BLOCK;
										randoNPC->Defense[NPCD_BOMB] = NPCDT_IGNORE;
										randoNPC->Defense[NPCD_BYRNA] = NPCDT_IGNORE;
										randoNPC->Defense[NPCD_FIRE] = NPCDT_IGNORE;
										randoNPC->Defense[NPCD_HAMMER] = NPCDT_BLOCK;
										randoNPC->Defense[NPCD_MAGIC] = NPCDT_BLOCK;
										randoNPC->Defense[NPCD_SBOMB] = NPCDT_IGNORE;
										randoNPC->Defense[NPCD_SCRIPT] = NPCDT_BLOCK;
										randoNPC->Defense[NPCD_STOMP] = NPCDT_BLOCK;
										randoNPC->Defense[NPCD_SWORD] = NPCDT_BLOCK;
										randoNPC->Defense[NPCD_WAND] = NPCDT_BLOCK;
									}
	
	
									// The Little Gibo becomes vulnerable.
									if (randoNPC->Defense[NPCD_STOMP] != NPCDT_NONE && randoNPC->Stun == 0 && randoNPC->HitYOffset == 0)
									{
										randoNPC->Defense[NPCD_ARROW] = NPCDT_NONE;
										randoNPC->Defense[NPCD_BEAM] = NPCDT_NONE;
										randoNPC->Defense[NPCD_BOMB] = NPCDT_NONE;
										randoNPC->Defense[NPCD_BYRNA] = NPCDT_NONE;
										randoNPC->Defense[NPCD_FIRE] = NPCDT_NONE;
										randoNPC->Defense[NPCD_HAMMER] = NPCDT_NONE;
										randoNPC->Defense[NPCD_MAGIC] = NPCDT_NONE;
										randoNPC->Defense[NPCD_SBOMB] = NPCDT_NONE;
										randoNPC->Defense[NPCD_SCRIPT] = NPCDT_NONE;
										randoNPC->Defense[NPCD_STOMP] = NPCDT_NONE;
										randoNPC->Defense[NPCD_SWORD] = NPCDT_NONE;
										randoNPC->Defense[NPCD_WAND] = NPCDT_NONE;
									}
	
									// The Little Gibo moves:
									if (randoNPC->Dir == DIR_LEFTUP)
									{
										if (randoNPC->Y > 8 && randoNPC->X > 8)
										{
											if (Screen->ComboS[ComboAt(randoNPC->X-1,randoNPC->Y-1)] != 1111b)
											{
												--randoNPC->X;
												--randoNPC->Y;
											}
											else randoNPC->Dir = DIR_RIGHTDOWN;
										} 
										else randoNPC->Dir = DIR_RIGHTDOWN;
									}
									else if (randoNPC->Dir == DIR_LEFTDOWN)
									{
										if (randoNPC->Y < 152 && randoNPC->X > 8)
										{
											if (Screen->ComboS[ComboAt(randoNPC->X-1,randoNPC->Y+17)] != 1111b)
											{
												--randoNPC->X;
												++randoNPC->Y;
											}
											else randoNPC->Dir = DIR_RIGHTUP;
										} 
										else randoNPC->Dir = DIR_RIGHTUP;
									}
									else if (randoNPC->Dir == DIR_RIGHTUP)
									{
										if (randoNPC->Y > 8 && randoNPC->X < 232)
										{
											if (Screen->ComboS[ComboAt(randoNPC->X+17,randoNPC->Y-1)] != 1111b)
											{
												++randoNPC->X;
												--randoNPC->Y;
											}
											else randoNPC->Dir = DIR_LEFTDOWN;
										} 
										else randoNPC->Dir = DIR_LEFTDOWN;
									}
									else if (randoNPC->Dir == DIR_RIGHTDOWN)
									{
										if (randoNPC->Y < 152 && randoNPC->X < 232)
										{
											if (Screen->ComboS[ComboAt(randoNPC->X+17,randoNPC->Y+17)] != 1111b)
											{
												++randoNPC->X;
												++randoNPC->Y;
											}
											else randoNPC->Dir = DIR_LEFTUP;
										} 
										else randoNPC->Dir = DIR_LEFTUP;
									}
									else if (randoNPC->Dir == DIR_UP)
									{
										if (randoNPC->Y > 8)
										{
											if (Screen->ComboS[ComboAt(randoNPC->X+7,randoNPC->Y-1)] != 1111b) --randoNPC->Y;
											else randoNPC->Dir = DIR_DOWN;
										} 
										else randoNPC->Dir = DIR_DOWN;
									}
									else if (randoNPC->Dir == DIR_DOWN)
									{
										if (randoNPC->Y < 152)
										{
											if (Screen->ComboS[ComboAt(randoNPC->X+7,randoNPC->Y+17)] != 1111b) ++randoNPC->Y;
											else randoNPC->Dir = DIR_UP;
										} 
										else randoNPC->Dir = DIR_UP;
									}
									else if (randoNPC->Dir == DIR_LEFT)
									{
										if (randoNPC->X > 8)
										{
											if (Screen->ComboS[ComboAt(randoNPC->X-1,randoNPC->Y+8)] != 1111b) --randoNPC->X;
											else randoNPC->Dir = DIR_RIGHT;
										} 
										else randoNPC->Dir = DIR_RIGHT;
									}
									else if (randoNPC->Dir == DIR_RIGHT)
									{
										if (randoNPC->X < 232)
										{
											if (Screen->ComboS[ComboAt(randoNPC->X+17,randoNPC->Y+8)] != 1111b) ++randoNPC->X;
											else randoNPC->Dir = DIR_LEFT;
										} 
										else randoNPC->Dir = DIR_LEFT;
									}
								}
								if (randoNPC->HitYOffset == 1)
								// The Big Gibo moves to where the Little Gibo is:
								{
									if (randoNPC->Misc[MISC_GIBOX] < randoNPC->X) ++randoNPC->Misc[MISC_GIBOX];
									else if (randoNPC->Misc[MISC_GIBOX] > randoNPC->X) --randoNPC->Misc[MISC_GIBOX];
									if (randoNPC->Misc[MISC_GIBOY] < randoNPC->Y) ++randoNPC->Misc[MISC_GIBOY];
									else if (randoNPC->Misc[MISC_GIBOY] > randoNPC->Y) --randoNPC->Misc[MISC_GIBOY];
									if (randoNPC->Misc[MISC_GIBOX] == randoNPC->X && randoNPC->Misc[MISC_GIBOY] == randoNPC->Y && randoNPC->Stun == 0)
									{
										randoNPC->Stun = 80;
										randoNPC->HitYOffset = 0;
									}
								}
	
								// The Little Gibo delays moving until a certain amount of time after the Big Gibo has aligned with it:  
								//if (randoNPC->Stun > 0 && randoNPC->Stun < 160)
								//{
								//	if (randoNPC->Misc[MISC_GIBOX] != randoNPC->X || randoNPC->Misc[MISC_GIBOY] != randoNPC->Y) randoNPC->Stun = 160;
								//}	
							}
						}
			// --- Clockpun
						if (randoNPC->ID == NPC_CLOCKPUN1 || randoNPC->ID == NPC_CLOCKPUN2)
						{
							if (Link->Action == LA_GOTHURTLAND || Link->Action == LA_GOTHURTWATER)
							{
								if (LinkCollision(randoNPC) && Game->Counter[CR_LINKSTUN] == 0)
								{
									if (randoNPC->ID == NPC_CLOCKPUN1) Game->Counter[CR_LINKSTUN] = 120;
									else Game->Counter[CR_LINKSTUN] = 255;
									Game->PlaySound(SFX_BRANG);
								}
							}
						}
	
			// --- Guma hops
						if (randoNPC->ID == NPC_GUMA1 || randoNPC->ID == NPC_GUMA2)
						{
							if (Game->Counter[CR_CLOCK] == 0)
							{
								if (randoNPC->Misc[MISC_NPCTURNWAIT] == 0)
								{
									if (!IsSideview())
									{
										if (randoNPC->Jump == 0)
										{
											if (randoNPC->Z == 0)
											{
												if (randoNPC->X == ComboX(ComboAt(randoNPC->X+7,randoNPC->Y+8)))
												{
													if (randoNPC->Y == ComboY(ComboAt(randoNPC->X+7,randoNPC->Y+8))) 
													{
														randoNPC->Jump = 2;
														randoNPC->Misc[MISC_NPCTURNWAIT] = Rand(255);
													}
												}
											}
										}
									}
								}
								else --randoNPC->Misc[MISC_NPCTURNWAIT];
							}
						}
	
			// --- Whistle Master makes LW_WHISTLE weapon
						if (randoNPC->ID == NPC_WHISTLE)
						{
							if (randoNPC->HP <= 0 && randoNPC->HP > HP_SILENT)
							{
								if (NumLWeaponsOf(LW_WHISTLE) == 0)
								{
									lweapon SecretToot = CreateLWeaponAt(LW_WHISTLE,0,0);
									eweapon TootWind[5];
									TootWind[1] = CreateEWeaponAt(EW_WIND,randoNPC->X,randoNPC->Y);
									TootWind[1]->Dir = DIR_UP;
									TootWind[1]->Step = 120;
									TootWind[2] = CreateEWeaponAt(EW_WIND,randoNPC->X,randoNPC->Y);
									TootWind[2]->Dir = DIR_DOWN;
									TootWind[2]->Step = 120;
									TootWind[3] = CreateEWeaponAt(EW_WIND,randoNPC->X,randoNPC->Y);
									TootWind[3]->Dir = DIR_LEFT;
									TootWind[3]->Step = 120;
									TootWind[4] = CreateEWeaponAt(EW_WIND,randoNPC->X,randoNPC->Y);
									TootWind[4]->Dir = DIR_RIGHT;
									TootWind[4]->Step = 120;
									Game->PlaySound(SFX_WHISTLE);
									randoNPC->HP = HP_SILENT;
								}
							}
						}
	
			// --- Shield Like Like faces Link on contact
						if (randoNPC->ID == NPC_LIKELIKESHIELDS)
						{
							if (LinkCollision(randoNPC))
							{
								if (Link->Dir == DIR_UP) randoNPC->Dir = DIR_DOWN;
								else if (Link->Dir == DIR_DOWN) randoNPC->Dir = DIR_UP;
								else if (Link->Dir == DIR_LEFT) randoNPC->Dir = DIR_RIGHT;
								else if (Link->Dir == DIR_RIGHT) randoNPC->Dir = DIR_LEFT;
							}
						}
			// --- Yomo Medusa
						if (randoNPC->ID == NPC_YOMOMEDUSA1 || randoNPC->ID == NPC_YOMOMEDUSA2)
						{
							if (Game->Counter[CR_CLOCK] == 0)
							{
								if (Screen->NumLWeapons() > 0 && Screen->NumLWeapons() > NumLWeaponsOf(LW_ARMOS) + NumLWeaponsOf(LW_BOWWOW) || randoNPC->ID == NPC_YOMOMEDUSA2)
								{
									if (NumEWeaponsOf(EW_FIREBALL) == 0)
									{
										if (randoNPC->ID == NPC_YOMOMEDUSA1 || Link->X > randoNPC->X - 32 && Link->X <  randoNPC->X + 32 || Link->Y > randoNPC->Y - 32 && Link->Y < randoNPC->Y + 32)
										{
											eweapon Yomoball1 = CreateEWeaponAt(EW_FIREBALL,randoNPC->X,randoNPC->Y);
											Yomoball1->Step = 255;
											Yomoball1->Dir = DIR_UP;
											Yomoball1->Damage = randoNPC->WeaponDamage;
											eweapon Yomoball2 = CreateEWeaponAt(EW_FIREBALL,randoNPC->X,randoNPC->Y);
											Yomoball2->Step = 255;
											Yomoball2->Dir = DIR_DOWN;
											Yomoball2->Damage = randoNPC->WeaponDamage;
											eweapon Yomoball3 = CreateEWeaponAt(EW_FIREBALL,randoNPC->X,randoNPC->Y);
											Yomoball3->Step = 255;
											Yomoball3->Damage = randoNPC->WeaponDamage;
											Yomoball3->Dir = DIR_LEFT;
											eweapon Yomoball4 = CreateEWeaponAt(EW_FIREBALL,randoNPC->X,randoNPC->Y);
											Yomoball4->Step = 255;
											Yomoball4->Dir = DIR_RIGHT;
											Yomoball4->Damage = randoNPC->WeaponDamage;
										}
									}
								}
							}
						}
			// --- Laser Eye
						if (Game->Counter[CR_CLOCK] == 0)
						{
							if (randoNPC->ID == NPC_LASEREYE_UP)
							{
								randoNPC->Dir = DIR_UP;
								if (Link->X > randoNPC->X - 24 && Link->X < randoNPC->X + 24  && Link->Y < randoNPC->Y)
								{
									if (Link->Dir != DIR_UP)
									{
										if (NumEWeaponsOf(EW_BEAM) < 8)
										{
											if (EverySix%2)
											{
												Game->PlaySound(SFX_BEAM);
												eweapon Eyelaser = CreateEWeaponAt(EW_BEAM,randoNPC->X,randoNPC->Y);
												Eyelaser->Step = 400;
												Eyelaser->UseSprite (SP_FIREBALL);
												Eyelaser->Dir = randoNPC->Dir;
												Eyelaser->Damage = randoNPC->WeaponDamage;
											}
										}
									}
								}
							}
							else if (randoNPC->ID == NPC_LASEREYE_DOWN)
							{
								randoNPC->Dir = DIR_DOWN;
								if (Link->X > randoNPC->X - 24 && Link->X < randoNPC->X + 24 && Link->Y > randoNPC->Y)
								{
									if (Link->Dir != DIR_DOWN)
									{
										if (NumEWeaponsOf(EW_BEAM) < 8)
										{
											if (EverySix%2)
											{
												Game->PlaySound(SFX_BEAM);
												eweapon Eyelaser = CreateEWeaponAt(EW_BEAM,randoNPC->X,randoNPC->Y);
												Eyelaser->Step = 400;
												Eyelaser->UseSprite (SP_FIREBALL);
												Eyelaser->Dir = randoNPC->Dir;
												Eyelaser->Damage = randoNPC->WeaponDamage;
											}
										}
									}
								}
							}	
							else if (randoNPC->ID == NPC_LASEREYE_LEFT)
							{
								randoNPC->Dir = DIR_LEFT;
								if (Link->Y > randoNPC->Y - 24 && Link->Y < randoNPC->Y + 24 && Link->X < randoNPC->X)
								{
									if (Link->Dir != DIR_LEFT)
									{
										if (NumEWeaponsOf(EW_BEAM) < 8)
										{
											if (EverySix%2)
											{
												Game->PlaySound(SFX_BEAM);
												eweapon Eyelaser = CreateEWeaponAt(EW_BEAM,randoNPC->X,randoNPC->Y);
												Eyelaser->Step = 400;
												Eyelaser->UseSprite (SP_FIREBALL);
												Eyelaser->Dir = randoNPC->Dir;
												Eyelaser->Damage = randoNPC->WeaponDamage;
											}
										}
									}
								}
							}
							else if (randoNPC->ID == NPC_LASEREYE_RIGHT)
							{
								randoNPC->Dir = DIR_RIGHT;
								if (Link->Y > randoNPC->Y - 24 && Link->Y < randoNPC->Y + 24 && Link->X > randoNPC->X)
								{
									if (Link->Dir != DIR_RIGHT)
									{
										if (NumEWeaponsOf(EW_BEAM) < 8)
										{
											if (EverySix%2)
											{
												Game->PlaySound(SFX_BEAM);
												eweapon Eyelaser = CreateEWeaponAt(EW_BEAM,randoNPC->X,randoNPC->Y);
												Eyelaser->Step = 400;
												Eyelaser->UseSprite (SP_FIREBALL);
												Eyelaser->Dir = randoNPC->Dir;
												Eyelaser->Damage = randoNPC->WeaponDamage;
											}
										}
									}
								}
							}
							else if (randoNPC->ID == NPC_LASEREYE_RAND)
							{
								if (Link->Y > randoNPC->Y - 24 && Link->Y < randoNPC->Y + 24 || Link->X > randoNPC->X - 24 && Link->X < randoNPC->X + 24)
								{
									if (Link->Dir != DIR_RIGHT)
									{
										if (NumEWeaponsOf(EW_BEAM) < 8)
										{
											if (EverySix%2)
											{
												Game->PlaySound(SFX_BEAM);
												eweapon Eyelaser = CreateEWeaponAt(EW_BEAM,randoNPC->X,randoNPC->Y);
												Eyelaser->Step = 400;
												Eyelaser->UseSprite (SP_FIREBALL);
												Eyelaser->Dir = randoNPC->Dir;
												Eyelaser->Damage = randoNPC->WeaponDamage;
											}
										}
									}
								}
							}
						}

	
			// --- Rope Destroyer
						if (randoNPC->ID == NPC_ROPEDESTROYER)
						{
							if (randoNPC->CollDetection != 0) randoNPC->CollDetection = 0;
							if (NumLWeaponsOf(LW_ROPE) > 0)
							{
								randoLW = LoadLWeaponOf(LW_ROPE);
								if (randoLW->isValid())
								{
									lweapon RopeDie = CreateLWeaponAt(LW_SPARKLE,randoLW->X,randoLW->Y);
									if (RopeDie->isValid()) RopeDie->UseSprite(SP_MISC_DEATH); 
									Remove(randoLW);
									Game->PlaySound(SFX_EDEAD);
								}
							}
						}
			// --- Whisp Bubble Teleportation
			// See also: RememberStuff[REMEMBER_WHISPWAIT] Countdown, below
						if (RememberStuff[REMEMBER_WHISPWAIT] == 0)
						{
							if (randoNPC->ID == NPC_BUBBLE_WHISP_A)
							{
								if (randoNPC->Stun == 0)
								{
									if (LinkCollision(randoNPC))
									{
										randoNPC->CollDetection = false;
										if (Link->Item[I_WHISPRING1])
										{
											randoNPC->Stun = 255;
											npc OtherBubble = LoadNPCOf(NPC_BUBBLE_WHISP_B);
											if (OtherBubble->isValid())
											{
												if (Screen->ComboF[ComboAt(OtherBubble->X+7,OtherBubble->Y+7)] != CF_NOWHISP || Screen->ComboF[ComboAt(Link->X+7,Link->Y+7)] == CF_NOWHISP)
												{
													if (Screen->ComboI[ComboAt(OtherBubble->X+7,OtherBubble->Y+7)] != CF_NOWHISP || Screen->ComboI[ComboAt(Link->X+7,Link->Y+7)] == CF_NOWHISP)
													{
														OtherBubble->CollDetection = false;
														OtherBubble->Stun = 255;
														RememberStuff[REMEMBER_WHISPWAIT] = 120;
														Game->PlaySound(SFX_CHARGE2);
														Link->X = OtherBubble->X;
														Link->Y = OtherBubble->Y;
													}
												}
											}
										}
									}
								}							
							}
							if (randoNPC->ID == NPC_BUBBLE_WHISP_B)
							{
								if (randoNPC->Stun == 0)
								{
									if (LinkCollision(randoNPC))
									{
										randoNPC->CollDetection = false;
										if (Link->Item[I_WHISPRING1])
										{
											npc OtherBubble = LoadNPCOf(NPC_BUBBLE_WHISP_A);
											if (OtherBubble->isValid())
											{
												if (Screen->ComboF[ComboAt(OtherBubble->X+7,OtherBubble->Y+7)] != CF_NOWHISP || Screen->ComboF[ComboAt(Link->X+7,Link->Y+7)] == CF_NOWHISP)
												{
													if (Screen->ComboI[ComboAt(OtherBubble->X+7,OtherBubble->Y+7)] != CF_NOWHISP || Screen->ComboI[ComboAt(Link->X+7,Link->Y+7)] == CF_NOWHISP)
													{
														randoNPC->Stun = 255;
														OtherBubble->CollDetection = false;
														OtherBubble->Stun = 255;
														RememberStuff[REMEMBER_WHISPWAIT] = 120;
														Game->PlaySound(SFX_CHARGE2);
														Link->X = OtherBubble->X;
														Link->Y = OtherBubble->Y;
													}
												}
											}
										}
									}
								}							
							}
						}
	
			// --- Darknut 4x1 fourmation
						if (randoNPC->ID == NPC_DARKNUT_FOURMATION)
						{
							if (randoNPC->Dir == DIR_UP)
							{
								if (randoNPC->OriginalTile != FOURMATION_ORIGTILE) randoNPC->OriginalTile = FOURMATION_ORIGTILE;
							}
							else if (randoNPC->Dir == DIR_DOWN)
							{
								if (randoNPC->OriginalTile != FOURMATION_ORIGTILE+8) randoNPC->OriginalTile = FOURMATION_ORIGTILE+8;
							}
							else if (randoNPC->Dir == DIR_LEFT)
							{
								if (randoNPC->OriginalTile != FOURMATION_ORIGTILE+20) randoNPC->OriginalTile = FOURMATION_ORIGTILE+20;
							}
							else if (randoNPC->Dir == DIR_RIGHT)
							{
								if (randoNPC->OriginalTile != FOURMATION_ORIGTILE+28) randoNPC->OriginalTile = FOURMATION_ORIGTILE+28;
							}
							if (randoNPC->HP <= 0)
							{
								npc DarkSplit1 = CreateNPCAt(NPC_DARKNUT_FOURSPLIT,randoNPC->X-32,randoNPC->Y);
								npc DarkSplit2 = CreateNPCAt(NPC_DARKNUT_FOURSPLIT,randoNPC->X-16,randoNPC->Y);
								npc DarkSplit3 = CreateNPCAt(NPC_DARKNUT_FOURSPLIT,randoNPC->X,randoNPC->Y);
								npc DarkSplit4 = CreateNPCAt(NPC_DARKNUT_FOURSPLIT,randoNPC->X+16,randoNPC->Y);							
								DarkSplit1->Dir = randoNPC->Dir;
								DarkSplit2->Dir = randoNPC->Dir;
								DarkSplit3->Dir = randoNPC->Dir;
								DarkSplit4->Dir = randoNPC->Dir;
								if (Screen->ComboF[ComboAt(DarkSplit1->X,DarkSplit1->Y)] == CF_NOGROUNDENEMY) Screen->ComboF[ComboAt(DarkSplit1->X,DarkSplit1->Y)] = 0;
								if (Screen->ComboF[ComboAt(DarkSplit2->X,DarkSplit2->Y)] == CF_NOGROUNDENEMY) Screen->ComboF[ComboAt(DarkSplit2->X,DarkSplit2->Y)] = 0;
								if (Screen->ComboF[ComboAt(DarkSplit3->X,DarkSplit3->Y)] == CF_NOGROUNDENEMY) Screen->ComboF[ComboAt(DarkSplit3->X,DarkSplit3->Y)] = 0;
								if (Screen->ComboF[ComboAt(DarkSplit4->X,DarkSplit4->Y)] == CF_NOGROUNDENEMY) Screen->ComboF[ComboAt(DarkSplit4->X,DarkSplit4->Y)] = 0;
								DarkSplit1->Stun = 60;
								DarkSplit2->Stun = 60;
								DarkSplit3->Stun = 60;
								DarkSplit4->Stun = 60;
								Remove(randoNPC);
							}
						}
			// --- Blue bubbles don't reduce acorn counter
						if (randoNPC->ID == NPC_BUBBLEITEMR || randoNPC->ID == NPC_BUBBLESWORDR)
						{
							if (LinkCollision(randoNPC)) RememberStuff[REMEMBER_BEINGHURT] = 1;
						}
		// --- end
				}
			}

			if (RememberStuff[REMEMBER_WHISPWAIT] > 0)
			{
				Screen->FastTile(3,Link->X,Link->Y,Link->Tile,Choose(6,9),128);
				--RememberStuff[REMEMBER_WHISPWAIT];
			}

			Waitframe();
		}
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Enemy Loop / For Loop of NPCs (end)
// Original NPC behaviors and loop functionality by Mitsukara, 
// Ported to an FFC from the global by Dimi due to ZASM limits
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Change sidewarp if raft (Start)
// By Dimi
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
ffc script ChangeSidewarpIfRaft
{
	void run()
	{
		DoDraw = true;
		while(!Link->Item[26]) Waitframe();
		Screen->SetSideWarp(2, -1, 0, WT_SCROLLING);
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Change sidewarp if raft (End)
// By Dimi
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Play enhanced music if item (start)
// By Mitsukara
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
ffc script PlayEnhMusicIfItem
{
	void run(int WhatItem, int WhatTrack, int WhatWait, int StopIfNoNPCs, int WhatFile)
	{
//D0 - What item to play music for.
//D1 - What track of the nsf to play. (Redefine filename below if you want to use a different file)
//D2 - Number of frames to wait before beginning to play
//D3 - If > 0, stops music if there are no NPCs (enemies) after 4 frames.
//D4 - If 0, uses MusicFileName. If 1, uses MusicFileNameB.

		int MusicFileName[13]="Klopp422.nsf";
		int MusicFileNameB[20]="z1remade.nsf";

		if (WhatWait > 0) Waitframes(WhatWait);

		if (Link->Item[WhatItem])
		{
			if (StopIfNoNPCs > 0)
			{
				Waitframes(4);
				if (Screen->NumNPCs() > 0)
				{
					if (WhatFile == 0) Game->PlayEnhancedMusic(MusicFileName,WhatTrack);
					else if (WhatFile == 1) Game->PlayEnhancedMusic(MusicFileNameB,WhatTrack);
					while(true)
					{
						if (Screen->NumNPCs() == 0)
						{
							Game->PlayMIDI(0);
							Quit();
						}
						Waitframe();
					}
				}
				else Quit();
			}
			else 
			{
				if (WhatFile == 0) Game->PlayEnhancedMusic(MusicFileName,WhatTrack);
				else if (WhatFile == 1) Game->PlayEnhancedMusic(MusicFileNameB,WhatTrack);
				Quit();
			}
		}
		else Quit();
	}
}

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Play enhanced music if item (end)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Open Rando menu (start)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
ffc script OpenRandoMenu
{
	void run(int WhatScreen, int WhatDMap)
	{
// D0 - if 0, this screen will open the Rando Menu. Otherwise, Link will be warped to D0 screen of D1 dmap upon pressing the button combo.

		if (WhatScreen == 0)
		{
			int scr[] = "RandoMenu";
			int sid = Game->GetFFCScript(scr);
			ffc f;
			for ( int q = 1; q <= 32; ++q )
			{
				f = Screen->LoadFFC(q);
				if ( f->Script ) continue;
				if ( f->Data ) continue;
				if ( q )
				{
					f->Data = 1;
					f->Script = Game->GetFFCScript(scr);
					break;
				}
			}
			NoAction();
			Link->PressStart = false;
			Link->InputStart = false;
			this->Data = 0;
			this->Script = 0;
			Quit();
		}
		else if (Link->InputEx2 && Link->InputR)
		{
			if (Link->InputStart) 
			{	
				Link->Warp(WhatDMap, WhatScreen);
			}
		}
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Open Rando menu (end)
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------



