// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: NES Take Only One Room (start)
// By Moosh
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------


int Randomizer_GetItemReplacement(int map, int scrn){
	
}

ffc script NESChooseItem{
	void run(int item1, int item2, int guy, int msg, int location){
		this->Flags[FFCF_IGNOREHOLDUP] = true;
		if (location < 0)
		{
			if (RememberStuff[REMEMBER_SCREEN] == 0) location = 11;
			if (RememberStuff[REMEMBER_SCREEN] == 15) location = 40;
			
			if (Game->GetCurMap() != 1)
			{
				if (RememberStuff[REMEMBER_SCREEN] == 126) location = 103;
				if (RememberStuff[REMEMBER_SCREEN] == 107) location = 104;
				if (RememberStuff[REMEMBER_SCREEN] == 50) location = 105;
				
				if (RememberStuff[REMEMBER_SCREEN] == 66) location = 106;
				if (RememberStuff[REMEMBER_SCREEN] == 19) location = 107;
				if (RememberStuff[REMEMBER_SCREEN] == 105) location = 108;
				
				
				if (RememberStuff[REMEMBER_SCREEN] == 91) location = 109;
				if (RememberStuff[REMEMBER_SCREEN] == 39) location = 110;
				if (RememberStuff[REMEMBER_SCREEN] == 84) location = 111;
				
				if (RememberStuff[REMEMBER_SCREEN] == 87) location = 131;
				if (RememberStuff[REMEMBER_SCREEN] == 124) location = 132;
			}
		}
		if (location > 0)
		{
			int i; int j;
			
			WaitNoAction(8);
			item shopItems[2];
			npc roomGuys[3];
			
			roomGuys[0] = CreateNPCAt(5, 64, 64);
			roomGuys[2] = CreateNPCAt(5, 176, 64);
			if(Screen->State[ST_SPECIALITEM] && (Game->GetCurScreen() != 0x4F || Game->GetCurDMap() != DMAP_CAVES))
				Quit();
			if (Game->GetScreenState(1, RememberStuff[REMEMBER_SCREEN], ST_SPECIALITEM) &&
			(Game->GetCurMap() == 1 || Game->GetCurScreen() == 0x4F))
				Quit();
			
			
			roomGuys[1] = CreateNPCAt(guy, 120, 64);
			
			WaitNoAction(16);
			
			if(IsRandomizer() && Randomizer_GetItemReplacement(location)){
				if(Randomizer_GetItemReplacement(location))
					item1 = Randomizer_GetItemReplacement(location);
				
				if (RememberStuff[REMEMBER_RANDO_OPTIONS+9])
				{
					if (item1 == 199) item1 = 28;
				}
				//msg = 208;
				shopItems[0] = CreateItemAt(item1, 120, 88);
				if (Game->GetCurScreen() != 0x4F || Game->GetCurDMap() != DMAP_CAVES) shopItems[0]->Pickup = IP_HOLDUP|IP_ST_SPECIALITEM;
				else shopItems[0]->Pickup = IP_HOLDUP;
				
				WaitNoAction();
				
				Screen->Message(msg);
				int freezeLink = 1;
				while(shopItems[0]->isValid()){
					if(freezeLink){
						--freezeLink;
						NoAction();
					}
					
					Waitframe();
				}
				if (Game->GetCurMap() == 1 || Game->GetCurScreen() == 0x4F) Game->SetScreenState(1, RememberStuff[REMEMBER_SCREEN], ST_SPECIALITEM, true);
				for(j=0; j<64; ++j){
					if(j%2==0)
						roomGuys[1]->Y = -32;
					else
						roomGuys[1]->Y = 64;
					if(j%2==0)
						shopItems[0]->DrawYOffset = -1000;
					else
						shopItems[0]->DrawYOffset = 0;
				
					Waitframe();
				}
				roomGuys[1]->Y -= 1000;
				shopItems[0]->Y -= 1000;
			}
			else{
				shopItems[0] = CreateItemAt(item1, 88, 88);
				if (Game->GetCurScreen() != 0x4F || Game->GetCurDMap() != DMAP_CAVES) shopItems[0]->Pickup = IP_HOLDUP|IP_ST_SPECIALITEM;
				else shopItems[0]->Pickup = IP_HOLDUP;
				shopItems[1] = CreateItemAt(item2, 152, 88);
				if (Game->GetCurScreen() != 0x4F || Game->GetCurDMap() != DMAP_CAVES) shopItems[1]->Pickup = IP_HOLDUP|IP_ST_SPECIALITEM;
				else shopItems[1]->Pickup = IP_HOLDUP;
				
				WaitNoAction();
				
				Screen->Message(msg);
				int freezeLink = 1;
				while(shopItems[0]->isValid()&&shopItems[1]->isValid()){
					if(freezeLink){
						--freezeLink;
						NoAction();
					}
					
					Waitframe();
				}
				if (Game->GetCurMap() == 1 || Game->GetCurScreen() == 0x4F) Game->SetScreenState(1, RememberStuff[REMEMBER_SCREEN], ST_SPECIALITEM, true);
				for(j=0; j<64; ++j){
					if(j%2==0)
						roomGuys[1]->Y = -32;
					else
						roomGuys[1]->Y = 64;
					for(i=0; i<2; ++i){
						if(shopItems[i]->isValid()){
							if(j%2==0)
								shopItems[i]->DrawYOffset = -1000;
							else
								shopItems[i]->DrawYOffset = 0;
							shopItems[i]->Pickup = IP_DUMMY;
						}
					}
				
					Waitframe();
				}
				roomGuys[1]->Y -= 1000;
				for(i=0; i<2; ++i){
					if(shopItems[i]->isValid()){
						shopItems[i]->Y -= 1000;
					}
				}
			}
		}
	}
}

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: NES Take Only One Room (end)
// By Moosh
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: NES Shop(start)
// By Moosh
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

ffc script NESShop{
	void run(int item1, int price1, int item2, int price2, int item3, int price3, int guy, int msg){
		this->Flags[FFCF_IGNOREHOLDUP] = true;
		
		int i; int j;
		
		WaitNoAction(8);
		item shopItems[3];
		int shopPrices[3];
		bool specialItem[3];
		bool itemWasValid[3];
		npc roomGuys[3];
		item rupeeIcon;
		
		roomGuys[0] = CreateNPCAt(5, 64, 64);
		roomGuys[1] = CreateNPCAt(guy, 120, 64);
		roomGuys[2] = CreateNPCAt(5, 176, 64);
		
		if (item1 == -9 && !Link->Item[12]) Quit();
		int saveitem1 = item1;
		
		if(item1==-1){ //Boomerang
		
			if(IsRandomizer() && RememberStuff[REMEMBER_RANDO_OPTIONS+6]){
				if(Randomizer_GetItemReplacement(75))
					item1 = Randomizer_GetItemReplacement(75);
			
				//msg = 208;
				shopItems[0] = CreateItemAt(item1, 120, 88);
				shopItems[0]->Pickup = IP_HOLDUP|IP_ST_SPECIALITEM;
				
				WaitNoAction();
				
				Screen->Message(msg);
				int freezeLink = 1;
				while(shopItems[0]->isValid()){
					if(freezeLink){
						--freezeLink;
						NoAction();
					}
					
					Waitframe();
				}
				for(j=0; j<64; ++j){
					if(j%2==0)
						roomGuys[1]->Y = -32;
					else
						roomGuys[1]->Y = 64;
					if(j%2==0)
						shopItems[0]->DrawYOffset = -1000;
					else
						shopItems[0]->DrawYOffset = 0;
				
					Waitframe();
				}
				roomGuys[1]->Y -= 1000;
				shopItems[0]->Y -= 1000;
				Quit();
			}
			else
			{
				item1 = I_BRANG1;
				price1 = 0;
				
				item3 = I_BRANG2;
				price3 = 0;
			}
		}
		else if(item1==-2){
			item1 = 175;
			price1 = 160;
			
			item2 = 174;
			price2 = 16;
			if (RememberStuff[REMEMBER_RANDO_OPTIONS+11])
			{
				item2 = 172;
				price2 = 40;
			}
			
			item3 = 203;
			price3 = 40;
			if(IsRandomizer() && RememberStuff[REMEMBER_RANDO_OPTIONS+0]){
				item1 = Randomizer_GetItemReplacement(80+0);
				item3 = Randomizer_GetItemReplacement(99);
				if(RememberStuff[REMEMBER_RANDO_SHOPSAVE+0])
					item1 = 0;
				else
					specialItem[0] = true;
				
				if(RememberStuff[REMEMBER_RANDO_SHOPSAVE+9])
					item3 = 0;
				else
					specialItem[2] = true;
			}
		}
		else if(item1==-3){ 
			item1 = 203;
			price1 = 40;
			
			item2 = I_KEY;
			price2 = 40;
			
			item3 = 174;
			price3 = 40;
			if(IsRandomizer() && RememberStuff[REMEMBER_RANDO_OPTIONS+0]){
				item1 = Randomizer_GetItemReplacement(80+1);
				if(RememberStuff[REMEMBER_RANDO_SHOPSAVE+1])
					item1 = 0;
				else
					specialItem[0] = true;
			}
		}
		else if(item1==-4){ //cheap shovel
			item1 = 161;
			price1 = 90;
			
			item2 = 174;
			price2 = 16;
			
			item3 = 155;
			price3 = 60;
			if(IsRandomizer() && RememberStuff[REMEMBER_RANDO_OPTIONS+0]){
				item1 = Randomizer_GetItemReplacement(80+2);
				item3 = Randomizer_GetItemReplacement(80+3);
				if(RememberStuff[REMEMBER_RANDO_SHOPSAVE+2])
					item1 = 0;
				else
					specialItem[0] = true;
				
				if(RememberStuff[REMEMBER_RANDO_SHOPSAVE+3])
					item3 = 0;
				else
					specialItem[2] = true;
			}
		}
		else if(item1==-5){ //cheap fishing
			item1 = 161;
			price1 = 60;
			
			item2 = 174;
			price2 = 16;
			
			item3 = 155;
			price3 = 90;
			if(IsRandomizer() && RememberStuff[REMEMBER_RANDO_OPTIONS+0]){
				item1 = Randomizer_GetItemReplacement(100);
				item3 = Randomizer_GetItemReplacement(101);
				if(RememberStuff[REMEMBER_RANDO_SHOPSAVE+7])
					item1 = 0;
				else
					specialItem[0] = true;
				
				if(RememberStuff[REMEMBER_RANDO_SHOPSAVE+10])
					item3 = 0;
				else
					specialItem[2] = true;
			}
		}
		else if(item1==-6){ //bola
			item1 = 159;
			price1 = 100;
			
			item2 = 186;
			price2 = 10;
			
			item3 = 174;
			price3 = 16;
			if(IsRandomizer() && RememberStuff[REMEMBER_RANDO_OPTIONS+0]){
				item1 = Randomizer_GetItemReplacement(80+4);
				if(RememberStuff[REMEMBER_RANDO_SHOPSAVE+4])
					item1 = 0;
				else
					specialItem[0] = true;
			}
		}
		else if(item1==-7){ //bombs
			item1 = 3;
			price1 = 20;
			
			item2 = 203;
			price2 = 40;
			
			item3 = 174;
			price3 = 30;
			if(IsRandomizer() && RememberStuff[REMEMBER_RANDO_OPTIONS+0]){
				item1 = Randomizer_GetItemReplacement(80+5);
				item2 = Randomizer_GetItemReplacement(102);
				if(RememberStuff[REMEMBER_RANDO_SHOPSAVE+5])
					item1 = 0;
				else
					specialItem[0] = true;
				
				if(RememberStuff[REMEMBER_RANDO_SHOPSAVE+8])
					item2 = 0;
				else
					specialItem[1] = true;
			}
		}
		else if(item1==-8){ //shield
			item1 = 0;
			price1 = 0;
			
			item2 = 8;
			price2 = 160;
			
			item3 = 0;
			price3 = 0;
			if(IsRandomizer() && RememberStuff[REMEMBER_RANDO_OPTIONS+0]){
				item2 = Randomizer_GetItemReplacement(80+6);
				if(RememberStuff[REMEMBER_RANDO_SHOPSAVE+6])
					item2 = 0;
				else
					specialItem[1] = true;
				
			}
		}
		else if(item1==-9){ //potion
			item1 = 172;
			price1 = 68;
			
			item2 = 0;
			price2 = 0;
			
			item3 = 173;
			price3 = 90;
			if(IsRandomizer() && RememberStuff[REMEMBER_RANDO_OPTIONS+11]){
				item1 = Randomizer_GetItemReplacement(129);
				if(RememberStuff[REMEMBER_RANDO_SHOPSAVE+11])
					item1 = 0;
				else
					specialItem[0] = true;
				item3 = Randomizer_GetItemReplacement(130);
				if(RememberStuff[REMEMBER_RANDO_SHOPSAVE+12])
					item3 = 0;
				else
					specialItem[2] = true;
				
			}
		}
		
		WaitNoAction(16);
		
		rupeeIcon = CreateItemAt(I_RUPEE1, 48, 107);
		rupeeIcon->Pickup = IP_DUMMY;
		
		if(item1>0)
			shopItems[0] = CreateItemAt(item1, 88, 88);
		shopPrices[0] = price1;

		if(item2>0)
			shopItems[1] = CreateItemAt(item2, 120, 88);
		shopPrices[1] = price2;
		
		if(item3>0)
			shopItems[2] = CreateItemAt(item3, 152, 88);
		shopPrices[2] = price3;
		Screen->DrawCharacter(6, 64, 112, FONT_Z1, 0x01, -1, -1, -1, 'X', 128);
		WaitNoAction();
		
		int maxItemCount;
		for(i=0; i<3; ++i){
			if(shopItems[i]->isValid()){
				itemWasValid[i] = true;
				++maxItemCount;
			}
		}
		
		int itemCount = maxItemCount;
		int itemBought;
		Screen->Message(msg);
		int freezeLink = 1;
		while(itemCount==maxItemCount){
			if(freezeLink){
				--freezeLink;
				NoAction();
			}
			Screen->DrawCharacter(6, 64, 112, FONT_Z1, 0x01, -1, -1, -1, 'X', 128);
		
			itemCount = 0;
			for(i=0; i<3; ++i){
				if(shopItems[i]->isValid()){
					if(Game->Counter[CR_RUPEES]+Game->DCounter[CR_RUPEES]>=shopPrices[i]){
						if(shopItems[i]->ID==I_BOMB)
							shopItems[i]->Pickup = 0;
						else
							shopItems[i]->Pickup = IP_HOLDUP;
					}
					else
						shopItems[i]->Pickup = IP_DUMMY;
					
					if(shopPrices[i]>0){
						j = 0;
						if(shopPrices[i]>99)
							j = -16;
						else if(shopPrices[i]>9)
							j = -8;
						Screen->DrawInteger(2, shopItems[i]->X+8+j, shopItems[i]->Y+24, FONT_Z1, 0x01, -1, -1, -1, shopPrices[i], 0, 128);
					}
						
					++itemCount;
				}
				else{
					if(itemWasValid[i])
						itemBought = i;
				}
			}
		
			Waitframe();
		}
		rupeeIcon->Y -= 1000;
		Game->DCounter[CR_RUPEES] -= shopPrices[itemBought];
		if(specialItem[itemBought])
		{
			if (itemBought == 0)
			{
				if(saveitem1==-2) RememberStuff[REMEMBER_RANDO_SHOPSAVE+0] = 1;
				if(saveitem1==-3) RememberStuff[REMEMBER_RANDO_SHOPSAVE+1] = 1;
				if(saveitem1==-4) RememberStuff[REMEMBER_RANDO_SHOPSAVE+2] = 1;
				if(saveitem1==-5) RememberStuff[REMEMBER_RANDO_SHOPSAVE+7] = 1;
				if(saveitem1==-6) RememberStuff[REMEMBER_RANDO_SHOPSAVE+4] = 1;
				if(saveitem1==-7) RememberStuff[REMEMBER_RANDO_SHOPSAVE+5] = 1;
				if(saveitem1==-9) RememberStuff[REMEMBER_RANDO_SHOPSAVE+11] = 1;
			}
			if (itemBought == 1)
			{
				if(saveitem1==-7) RememberStuff[REMEMBER_RANDO_SHOPSAVE+8] = 1;
				if(saveitem1==-8) RememberStuff[REMEMBER_RANDO_SHOPSAVE+6] = 1;
			}
			if (itemBought == 2)
			{
				if(saveitem1==-2) RememberStuff[REMEMBER_RANDO_SHOPSAVE+9] = 1;
				if(saveitem1==-4) RememberStuff[REMEMBER_RANDO_SHOPSAVE+3] = 1;
				if(saveitem1==-5) RememberStuff[REMEMBER_RANDO_SHOPSAVE+10] = 1;
				if(saveitem1==-9) RememberStuff[REMEMBER_RANDO_SHOPSAVE+12] = 1;
			}
		}
		for(j=0; j<64; ++j){
			itemCount = 0;
			if(j%2==0)
				roomGuys[1]->Y = -32;
			else
				roomGuys[1]->Y = 64;
			for(i=0; i<3; ++i){
				if(shopItems[i]->isValid()){
					if(j%2==0)
						shopItems[i]->DrawYOffset = -1000;
					else
						shopItems[i]->DrawYOffset = 0;
					shopItems[i]->Pickup = IP_DUMMY;
				}
			}
		
			Waitframe();
		}
		roomGuys[1]->Y -= 1000;
		for(i=0; i<3; ++i){
			if(shopItems[i]->isValid()){
				shopItems[i]->Y -= 1000;
			}
		}
	}
}

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: NES Shop(end)
// By Moosh
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------



// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Moosh Shop Launcher(start)
// By Dimi
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

ffc script DimiStealsMooshScriptsForFun //script that launches stolen Moosh scripts depending on last-screen entered.
{
	void run()
	{
		if (RememberStuff[REMEMBER_ROOMTYPE2] == RT_SHOP || RememberStuff[REMEMBER_ROOMTYPE2] == RT_POTIONSHOP)
		{
			int str[] = "NESShop";
			int scr = Game->GetFFCScript(str);
			ffc f;
			for ( int q = 1; q <= 32; ++q )
			{
				f = Screen->LoadFFC(q);
				if ( f->Script ) continue;
				if ( f->Data ) continue;
				if ( q )
				{
					f->Script = scr;
					f->Data = 1;
					if (RememberStuff[REMEMBER_ROOMTYPE2] == RT_POTIONSHOP || RememberStuff[REMEMBER_SCREEN] == 101 || RememberStuff[REMEMBER_SCREEN] == 119)
					{
						f->InitD[0] = -9;
						f->InitD[7] = 4;
						f->InitD[6] = 2;
					}
					else
					{
						f->InitD[7] = 2;
						if (RememberStuff[REMEMBER_ROOMDATA2]== 7 || RememberStuff[REMEMBER_ROOMDATA2]== 11)
						{
							f->InitD[0] = -3;
							f->InitD[7] = 9;
						}
						else if (RememberStuff[REMEMBER_ROOMDATA2]== 14)
						{
							f->InitD[0] = -2;
						}
						else if (RememberStuff[REMEMBER_ROOMDATA2]== 12)
						{
							f->InitD[0] = -4;
						}
						else if (RememberStuff[REMEMBER_ROOMDATA2]== 13)
						{
							f->InitD[0] = -5;
						}
						f->InitD[6] = 3;
					}
					break;
				}
			}
		}
		else
		{
			int str[] = "NESChooseItem";
			int scr = Game->GetFFCScript(str);
			ffc f;
			for ( int q = 1; q <= 32; ++q )
			{
				f = Screen->LoadFFC(q);
				if ( f->Script ) continue;
				if ( f->Data ) continue;
				if ( q )
				{
					f->Script = scr;
					f->Data = 1;
					f->InitD[0] = 172;
					f->InitD[1] = 39;
					f->InitD[2] = 4;
					f->InitD[3] = 7;
					f->InitD[4] = -1;
					break;
				}
			}
		}	
		Screen->SetSideWarp(0, RememberStuff[REMEMBER_SCREEN], -1, -1);
	}
}
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// FFC script: Moosh Shop Launcher(end)
// By Dimi
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

void XORShift_SetSeed(int x, int y) {
	 RememberStuff[REMEMBER_XORSHIFT_X] = x & 0xFFFF;
	 RememberStuff[REMEMBER_XORSHIFT_Y] = y & 0xFFFF;
}

int XORShift_Next() {
	 int t = RememberStuff[REMEMBER_XORSHIFT_X] ^ ((RememberStuff[REMEMBER_XORSHIFT_X] << 5) & 0xFFFF);
	 RememberStuff[REMEMBER_XORSHIFT_X] = RememberStuff[REMEMBER_XORSHIFT_Y];
	 RememberStuff[REMEMBER_XORSHIFT_Y] = (RememberStuff[REMEMBER_XORSHIFT_Y] ^ (RememberStuff[REMEMBER_XORSHIFT_Y] >> 1));
	 RememberStuff[REMEMBER_XORSHIFT_Y] ^= t ^ (t >> 3);
	 return RememberStuff[REMEMBER_XORSHIFT_Y];
}

int srand(int max){
	if(RememberStuff[REMEMBER_XORSHIFT_X]==-1)
		return Rand(max);
	else
	{
		if (max > 0) return XORShift_Next()%max;
		else return 0;
	}
}

int srand(int min, int max){
	if(RememberStuff[REMEMBER_XORSHIFT_X]==-1)
		return Rand(min, max);
	else
	{
		if ((max-min+1) > 0) return min+(XORShift_Next()%(max-min+1));
		else return 0;
	}
}

void AddItem(int Item, int Location, int ItemPool, int LocationPool, int MaxPool)
{
	//for (int i = 0; i < MaxPool[0]; ++i)
	//{
	//	if (LocationPool[i] == Location)
	//	{
	//		int tr[] = "Hey, duplicate location here!:";
	//		printf(tr);
	//		Trace(Location);
	//		int tr2[] = "Item attempted to be placed here was:";
	//		printf(tr2);
	//		Trace(Item);
	//	}
	//}
	ItemPool[MaxPool[0]] = Item;
	LocationPool[MaxPool[0]] = Location;
	if (Item == 157) MaxPool[6] = MaxPool[0];
	if (Item == 161) MaxPool[7] = MaxPool[0];
	if (Item == 155) MaxPool[8] = MaxPool[0];
	++MaxPool[0];
	if (Item == I_CANE1 || Item == I_CANE2 || Item == I_CANE3 ||
	Item == 3 || Item == 11 || Item == 25 || Item == 188 ||
	Item == 162 || Item == 163 || Item == 88 || Item == 164 || Item == 54) ++MaxPool[3];
	if (Item != 199) ++MaxPool[4];
}

void AddItems(int MaxPool, int ItemPool, int LocationPool)
{
	//Add Sword Cave items
	AddItem(I_CANE1, 1, ItemPool, LocationPool, MaxPool);
	AddItem(I_CANE2, 10, ItemPool, LocationPool, MaxPool);
	AddItem(I_CANE3, 12, ItemPool, LocationPool, MaxPool);
	AddItem(188, 49, ItemPool, LocationPool, MaxPool);
	AddItem(162, 20, ItemPool, LocationPool, MaxPool);
	AddItem(88,  43, ItemPool, LocationPool, MaxPool);
	AddItem(164, 50, ItemPool, LocationPool, MaxPool);
	AddItem(11, 65, ItemPool, LocationPool, MaxPool);
	AddItem(25, 66, ItemPool, LocationPool, MaxPool);
	AddItem(163, 47, ItemPool, LocationPool, MaxPool);
	if (RememberStuff[REMEMBER_RANDO_OPTIONS+0]) AddItem(3, 85, ItemPool, LocationPool, MaxPool);
	if (RememberStuff[REMEMBER_RANDO_OPTIONS+1]) AddItem(54, 36, ItemPool, LocationPool, MaxPool);
	//Add Overworld Items
	AddItem(156, 17, ItemPool, LocationPool, MaxPool);
	AddItem(170, 29, ItemPool, LocationPool, MaxPool);
	AddItem(158, 32, ItemPool, LocationPool, MaxPool);
	AddItem(160, 38, ItemPool, LocationPool, MaxPool);
	AddItem(12, 103, ItemPool, LocationPool, MaxPool);
	
	//Add Dungeon Items
	AddItem(153, 41, ItemPool, LocationPool, MaxPool);
	AddItem(169, 42, ItemPool, LocationPool, MaxPool);
	AddItem(157, 44, ItemPool, LocationPool, MaxPool);
	AddItem(171, 45, ItemPool, LocationPool, MaxPool);
	AddItem(176, 46, ItemPool, LocationPool, MaxPool);
	AddItem(55,  48, ItemPool, LocationPool, MaxPool);
	AddItem(99,  51, ItemPool, LocationPool, MaxPool);
	AddItem(154, 52, ItemPool, LocationPool, MaxPool);
	AddItem(190, 53, ItemPool, LocationPool, MaxPool);
	AddItem(221, 54, ItemPool, LocationPool, MaxPool);
	AddItem(177, 55, ItemPool, LocationPool, MaxPool);
	//Add lvl 9 Items
	AddItem(198, 56, ItemPool, LocationPool, MaxPool);
	AddItem(13, 59, ItemPool, LocationPool, MaxPool);
	AddItem(31, 60, ItemPool, LocationPool, MaxPool);
	AddItem(16, 61, ItemPool, LocationPool, MaxPool);
	AddItem(27, 62, ItemPool, LocationPool, MaxPool);
	AddItem(15, 63, ItemPool, LocationPool, MaxPool);
	AddItem(19, 64, ItemPool, LocationPool, MaxPool);
	AddItem(32, 67, ItemPool, LocationPool, MaxPool);
	AddItem(14, 69, ItemPool, LocationPool, MaxPool);
	AddItem(33, 70, ItemPool, LocationPool, MaxPool);
	AddItem(26, 74, ItemPool, LocationPool, MaxPool);
	int keypool = MaxPool[4];
	//SHOPS
	if (RememberStuff[REMEMBER_RANDO_OPTIONS+0]) 
	{
		AddItem(175, 80, ItemPool, LocationPool, MaxPool);
		AddItem(245, 81, ItemPool, LocationPool, MaxPool);
		AddItem(161, 82, ItemPool, LocationPool, MaxPool);
		AddItem(155, 83, ItemPool, LocationPool, MaxPool);
		AddItem(159, 84, ItemPool, LocationPool, MaxPool);
		//AddItem(3, 85, ItemPool, LocationPool, MaxPool);
		AddItem(246, 86, ItemPool, LocationPool, MaxPool);
		keypool = MaxPool[4];
		AddItem(I_KEY, 99, ItemPool, LocationPool, MaxPool);
		AddItem(I_KEY, 100, ItemPool, LocationPool, MaxPool);
		AddItem(I_KEY, 101, ItemPool, LocationPool, MaxPool);
		AddItem(I_KEY, 102, ItemPool, LocationPool, MaxPool);
	}
	
	if (RememberStuff[REMEMBER_RANDO_OPTIONS+10]) //Secret Money
	{
		AddItem(39, 106, ItemPool, LocationPool, MaxPool);
		AddItem(39, 107, ItemPool, LocationPool, MaxPool);
		AddItem(39, 108, ItemPool, LocationPool, MaxPool);
		
		
		AddItem(39, 109, ItemPool, LocationPool, MaxPool);
		AddItem(39, 110, ItemPool, LocationPool, MaxPool);
		AddItem(39, 111, ItemPool, LocationPool, MaxPool);
		
		AddItem(192, 131, ItemPool, LocationPool, MaxPool);
		AddItem(39, 132, ItemPool, LocationPool, MaxPool);
	}
	if (RememberStuff[REMEMBER_RANDO_OPTIONS+9])
	{
		//Add Heart Containers
		AddItem(28, 6, ItemPool, LocationPool, MaxPool);
		AddItem(28, 9, ItemPool, LocationPool, MaxPool);
		AddItem(28, 16, ItemPool, LocationPool, MaxPool);
		AddItem(28, 21, ItemPool, LocationPool, MaxPool);
		AddItem(28, 22, ItemPool, LocationPool, MaxPool);
		AddItem(28, 24, ItemPool, LocationPool, MaxPool);
		
		//Dungeon boss Heart Containers
		AddItem(28, 76, ItemPool, LocationPool, MaxPool);
		AddItem(28, 77, ItemPool, LocationPool, MaxPool);
		AddItem(28, 78, ItemPool, LocationPool, MaxPool);
		AddItem(28, 79, ItemPool, LocationPool, MaxPool);
		
		AddItem(39, 87, ItemPool, LocationPool, MaxPool);
		AddItem(39, 88, ItemPool, LocationPool, MaxPool);
		AddItem(39, 89, ItemPool, LocationPool, MaxPool);
		AddItem(39, 90, ItemPool, LocationPool, MaxPool);
		
		AddItem(39, 26, ItemPool, LocationPool, MaxPool);
		AddItem(39, 28, ItemPool, LocationPool, MaxPool);
		AddItem(39, 31, ItemPool, LocationPool, MaxPool);
		AddItem(39, 33, ItemPool, LocationPool, MaxPool);
		AddItem(39, 35, ItemPool, LocationPool, MaxPool);
		AddItem(39, 37, ItemPool, LocationPool, MaxPool);
	}
	else
	{
		//Add Heart Containers
		AddItem(199, 6, ItemPool, LocationPool, MaxPool);
		AddItem(199, 9, ItemPool, LocationPool, MaxPool);
		AddItem(199, 16, ItemPool, LocationPool, MaxPool);
		AddItem(199, 21, ItemPool, LocationPool, MaxPool);
		AddItem(199, 22, ItemPool, LocationPool, MaxPool);
		AddItem(199, 24, ItemPool, LocationPool, MaxPool);
		AddItem(199, 26, ItemPool, LocationPool, MaxPool);
		AddItem(199, 28, ItemPool, LocationPool, MaxPool);
		AddItem(199, 31, ItemPool, LocationPool, MaxPool);
		AddItem(199, 33, ItemPool, LocationPool, MaxPool);
		AddItem(199, 35, ItemPool, LocationPool, MaxPool);
		AddItem(199, 37, ItemPool, LocationPool, MaxPool);
		
		//Dungeon boss Heart Containers
		AddItem(199, 76, ItemPool, LocationPool, MaxPool);
		AddItem(199, 77, ItemPool, LocationPool, MaxPool);
		AddItem(199, 78, ItemPool, LocationPool, MaxPool);
		AddItem(199, 79, ItemPool, LocationPool, MaxPool);
		AddItem(199, 87, ItemPool, LocationPool, MaxPool);
		AddItem(199, 88, ItemPool, LocationPool, MaxPool);
		AddItem(199, 89, ItemPool, LocationPool, MaxPool);
		AddItem(199, 90, ItemPool, LocationPool, MaxPool);
	}
	//TRIFORCE PIECES
	if (RememberStuff[REMEMBER_RANDO_OPTIONS+3])
	{
		AddItem(247, 91, ItemPool, LocationPool, MaxPool);
		AddItem(247, 92, ItemPool, LocationPool, MaxPool);
		AddItem(247, 93, ItemPool, LocationPool, MaxPool);
		AddItem(247, 94, ItemPool, LocationPool, MaxPool);
		AddItem(247, 95, ItemPool, LocationPool, MaxPool);
		AddItem(247, 96, ItemPool, LocationPool, MaxPool);
		AddItem(247, 97, ItemPool, LocationPool, MaxPool);
		AddItem(247, 98, ItemPool, LocationPool, MaxPool);
	}
	//TAKE ONLY ONE: 4, 8, 11, 13, 18, 40
	if (RememberStuff[REMEMBER_RANDO_OPTIONS+6])
	{
		if (RememberStuff[REMEMBER_RANDO_OPTIONS+9])
		{
			AddItem(28, 4, ItemPool, LocationPool, MaxPool);
			AddItem(28, 8, ItemPool, LocationPool, MaxPool);
			AddItem(28, 11, ItemPool, LocationPool, MaxPool);
			AddItem(39, 13, ItemPool, LocationPool, MaxPool);
			AddItem(39, 18, ItemPool, LocationPool, MaxPool);
			AddItem(39, 40, ItemPool, LocationPool, MaxPool);
		}
		else
		{
			AddItem(199, 4, ItemPool, LocationPool, MaxPool);
			AddItem(199, 8, ItemPool, LocationPool, MaxPool);
			AddItem(199, 11, ItemPool, LocationPool, MaxPool);
			AddItem(199, 13, ItemPool, LocationPool, MaxPool);
			AddItem(199, 18, ItemPool, LocationPool, MaxPool);
			AddItem(199, 40, ItemPool, LocationPool, MaxPool);
		}
		if (srand(2)) 
		{
			RememberStuff[REMEMBER_BRANG] = 0;
			AddItem(23, 75, ItemPool, LocationPool, MaxPool);
		}
		else 
		{
			RememberStuff[REMEMBER_BRANG] = 1;
			AddItem(24, 75, ItemPool, LocationPool, MaxPool);
		}
	}
	//FAKE BOMB UPGRADES
	if (RememberStuff[REMEMBER_RANDO_OPTIONS+5])
	{
		AddItem(187, 7, ItemPool, LocationPool, MaxPool);
		AddItem(187, 23, ItemPool, LocationPool, MaxPool);
		AddItem(187, 25, ItemPool, LocationPool, MaxPool);
		AddItem(187, 34, ItemPool, LocationPool, MaxPool);
		AddItem(187, 39, ItemPool, LocationPool, MaxPool);
		
		AddItem(42, 3, ItemPool, LocationPool, MaxPool);
		AddItem(147, 5, ItemPool, LocationPool, MaxPool);
		AddItem(148, 19, ItemPool, LocationPool, MaxPool);
		
		AddItem(237, 30, ItemPool, LocationPool, MaxPool);
	}
	//JUNK
	if (true)
	{
		if (!RememberStuff[REMEMBER_RANDO_OPTIONS+1])
		{
			AddItem(192, 14, ItemPool, LocationPool, MaxPool);
			AddItem(39, 15, ItemPool, LocationPool, MaxPool);
			AddItem(39, 2, ItemPool, LocationPool, MaxPool);
			AddItem(1, 27, ItemPool, LocationPool, MaxPool);
			AddItem(87, 36, ItemPool, LocationPool, MaxPool);
			
			AddItem(1, 68, ItemPool, LocationPool, MaxPool);
			AddItem(1, 57, ItemPool, LocationPool, MaxPool);
			AddItem(1, 71, ItemPool, LocationPool, MaxPool);
			AddItem(87, 58, ItemPool, LocationPool, MaxPool);
			AddItem(192, 104, ItemPool, LocationPool, MaxPool);
			AddItem(39, 105, ItemPool, LocationPool, MaxPool);
		}
		else
		{
			AddItem(244, 14, ItemPool, LocationPool, MaxPool);
			AddItem(64, 15, ItemPool, LocationPool, MaxPool);
			AddItem(248, 2, ItemPool, LocationPool, MaxPool);
			AddItem(35, 27, ItemPool, LocationPool, MaxPool);
			//AddItem(54, 36, ItemPool, LocationPool, MaxPool);
			
			AddItem(52, 68, ItemPool, LocationPool, MaxPool);
			AddItem(89, 57, ItemPool, LocationPool, MaxPool);
			AddItem(53, 71, ItemPool, LocationPool, MaxPool);
			AddItem(91, 58, ItemPool, LocationPool, MaxPool);
			AddItem(189, 104, ItemPool, LocationPool, MaxPool);
			AddItem(208, 105, ItemPool, LocationPool, MaxPool);
		}
	}
	
	if (RememberStuff[REMEMBER_RANDO_OPTIONS+8] == 3)
	{
		AddItem(192, 72, ItemPool, LocationPool, MaxPool);
		AddItem(39, 73, ItemPool, LocationPool, MaxPool);
		
		AddItem(192, 112, ItemPool, LocationPool, MaxPool);
		AddItem(192, 113, ItemPool, LocationPool, MaxPool);
		AddItem(192, 114, ItemPool, LocationPool, MaxPool);
		AddItem(1, 115, ItemPool, LocationPool, MaxPool);
		AddItem(1, 116, ItemPool, LocationPool, MaxPool);
		AddItem(1, 117, ItemPool, LocationPool, MaxPool);
		AddItem(1, 118, ItemPool, LocationPool, MaxPool);
		AddItem(192, 119, ItemPool, LocationPool, MaxPool);
		AddItem(192, 120, ItemPool, LocationPool, MaxPool);
		AddItem(192, 121, ItemPool, LocationPool, MaxPool);
		AddItem(192, 122, ItemPool, LocationPool, MaxPool);
		AddItem(192, 123, ItemPool, LocationPool, MaxPool);
		AddItem(192, 124, ItemPool, LocationPool, MaxPool);
		AddItem(192, 125, ItemPool, LocationPool, MaxPool);
		AddItem(192, 126, ItemPool, LocationPool, MaxPool);
		AddItem(192, 127, ItemPool, LocationPool, MaxPool);
		AddItem(192, 128, ItemPool, LocationPool, MaxPool);
	}
	if (RememberStuff[REMEMBER_RANDO_OPTIONS+11])
	{
		AddItem(173, 129, ItemPool, LocationPool, MaxPool);
		AddItem(173, 130, ItemPool, LocationPool, MaxPool);
	}
	MaxPool[4] = keypool;
}

const int RANDMAP = 6;
const int RANDSCREEN = 64;

//AccessFlags 1
const int RNGF_WEAPON = 	0000000000000001b;
const int RNGF_SOMARIA =	0000000000000010b;
const int RNGF_PARTNER =	0000000000000100b;
const int RNGF_ARMOS = 		0000000000001000b;
const int RNGF_BOMBS = 		0000000000010000b;
const int RNGF_PEGASUS =	0000000000100000b;
const int RNGF_LADDER = 	0000000001000000b;
const int RNGF_ROPE = 		0000000010000000b;
const int RNGF_GLOVE = 		0000000100000000b;
const int RNGF_SHOVEL = 	0000001000000000b;
const int RNGF_BEETLE = 	0000010000000000b;
const int RNGF_ROPE2 = 		0000100000000000b;
const int RNGF_BOLA = 		0001000000000000b;
const int RNGF_OCTO = 		0010000000000000b;
const int RNGF_ARROW = 		0100000000000000b;
const int RNGF_ARROW2 = 	1000000000000000b;

//AccessFlags 2
const int RNGF2_RAFT = 		0000000000000001b;
const int RNGF2_PATRA = 	0000000000000010b;
const int RNGF2_PATRA2 = 	0000000000000100b;
const int RNGF2_BOOTS = 	0000000000001000b;
const int RNGF2_FISHING =	0000000000010000b;
const int RNGF2_SBOMBS = 	0000000000100000b;
const int RNGF2_LANTERN = 	0000000001000000b;
const int RNGF2_GLEEOK = 	0000000010000000b;
const int RNGF2_GLEEOK2 = 	0000000100000000b;
const int RNGF2_BOW = 		0000001000000000b;
const int RNGF2_BEETLE2 = 	0000010000000000b;
const int RNGF2_WAND = 		0000100000000000b;
const int RNGF2_WHISP = 	0001000000000000b;
const int RNGF2_CANDLE = 	0010000000000000b;
const int RNGF2_WHISTLE = 	0100000000000000b;
const int RNGF2_BAIT = 		1000000000000000b;

const int RNGF3_LVL1 = 		0000000000000001b;
const int RNGF3_LVL2 = 		0000000000000010b;
const int RNGF3_LVL3 = 		0000000000000100b;
const int RNGF3_LVL4 = 		0000000000001000b;
const int RNGF3_LVL5 = 		0000000000010000b;
const int RNGF3_LVL6 = 		0000000000100000b;
const int RNGF3_LVL7 = 		0000000001000000b;
const int RNGF3_LVL8 = 		0000000010000000b;
const int RNGF3_LVL9 = 		0000000100000000b;
const int RNGF3_LVL9KEY = 	0000001000000000b;
const int RNGF3_TRUEBOMB = 	0000010000000000b;
const int RNGF3_MAGICKEY = 	0000100000000000b;
const int RNGF3_FEATHER = 	0001000000000000b;
const int RNGF3_BOOMERANG = 	0010000000000000b;
const int RNGF3_LETTER = 	0100000000000000b;

ffc script DoRandStuff
{
	void run()
	{
		RememberStuff[REMEMBER_ISRANDO] = 1;
		int STR_WAIT[] = "LOADING...";
		int Maxpool[11];
		Maxpool[0] = 0;
		int LocationPoolAll[176];
		int LocationPool[176];
		int ItemPool[176];
		int Flags = 0;
		int Flags2 = 0;
		int Flags3 = 0;
		int HeartsPlaced = 0;
		int TriforcePlaced = 0;
		int waitcounter = 0;
		int k;
		bool Debug = false;
		bool wasturned = false;
		do
		{
			
			Maxpool[0] = 0;
			Maxpool[3] = 0;
			Maxpool[4] = 0;
			Maxpool[9] = 2;
			if (RememberStuff[REMEMBER_RANDO_OPTIONS+8] == 2) Maxpool[9] = 0;
			if (RememberStuff[REMEMBER_RANDO_OPTIONS+8] == 1) Maxpool[9] = 1;
			AddItems(Maxpool, ItemPool, LocationPoolAll);
			if (!RememberStuff[REMEMBER_RANDO_OPTIONS+7]) Maxpool[3] = 1;
			Maxpool[2] = Maxpool[0];
			Maxpool[5] = Maxpool[0];
			Maxpool[1] = -1;
			Flags = 0;
			Flags2 = 0;
			Flags3 = 0;
			wasturned = false;
			TriforcePlaced = 0;
			HeartsPlaced = 0;
			do
			{
				Screen->DrawString(6, 96, 48 + 1, FONT_Z1, 6, 0, TF_NORMAL, STR_WAIT, OP_OPAQUE);
				if (Maxpool[1] >= 0)
				{
					int i;
					if ((Flags & RNGF_WEAPON) && RememberStuff[REMEMBER_RANDO_OPTIONS+0] && Maxpool[9] > 0) 
					{
						int m;
						do 
						{
							m = srand(3);
						} while (m == Maxpool[10])
						Maxpool[10] = m;
						i = Maxpool[6+m];
						--Maxpool[9];
					}
					else if ((HeartsPlaced > 4 && (Maxpool[0] > (Maxpool[5] / 2))) || HeartsPlaced > 18) i = srand(Maxpool[4]);
					else if (Flags & RNGF_WEAPON) i = srand(Maxpool[0]);
					else i = srand(Maxpool[3]);
					--Maxpool[0];
					if (Maxpool[4] > Maxpool[0]) Maxpool[4] = Maxpool[0];
					//Game->SetComboData(RANDMAP, RANDSCREEN, LocationPool[Maxpool[1]], ItemPool[i]);
					RememberStuff[REMEMBER_RANDOSTART + LocationPool[Maxpool[1]]] = ItemPool[i];
					if (Debug)
					{
						int tr[] = "Placed location:";
						printf(tr);
						Trace(LocationPool[Maxpool[1]]);
						int tr4[] = "Maxpool[0] is:";
						printf(tr4);
						Trace(Maxpool[0]);
						int tr2[] = "Maxpool[1] is:";
						printf(tr2);
						Trace(Maxpool[1]);
						int tr3[] = "Maxpool[2] is:";
						printf(tr3);
						Trace(Maxpool[2]);
					}
					if (ItemPool[i] == 199) ++HeartsPlaced;
					if (ItemPool[i] == 28) HeartsPlaced+=2;
					if (ItemPool[i] == 247) ++TriforcePlaced;
					
					if (ItemPool[i] == I_CANE1 || ItemPool[i] == I_CANE2 || ItemPool[i] == I_CANE3 ||
						ItemPool[i] == 3 || ItemPool[i] == 11 || ItemPool[i] == 25 || ItemPool[i] == 188 ||
						ItemPool[i] == 162 || ItemPool[i] == 163 || ItemPool[i] == 88 || ItemPool[i] == 164) Flags |= RNGF_WEAPON;
						
					if (ItemPool[i] == I_CANE1 || ItemPool[i] == I_CANE2 || ItemPool[i] == I_CANE3) Flags |= RNGF_SOMARIA;
					if (ItemPool[i] == 161 || ItemPool[i] == 162 || ItemPool[i] == 159 || ItemPool[i] == 160) Flags |= RNGF_BOLA;
					if (ItemPool[i] == 161 || ItemPool[i] == 162) Flags |= RNGF_OCTO;
					if (ItemPool[i] == 188)
					{
						Flags |= RNGF_PARTNER;
						Flags |= RNGF_ARMOS;
					}
					if (ItemPool[i] == 3 || ItemPool[i] == 157 || ItemPool[i] == 158)
					{
						Flags |= RNGF_BOMBS;
					}
					if (ItemPool[i] == 23 || ItemPool[i] == 24 || ItemPool[i] == 35) Flags3 |= RNGF3_BOOMERANG;
					if (ItemPool[i] == 3) Flags3 |= RNGF3_TRUEBOMB;
					if (ItemPool[i] == 12) Flags3 |= RNGF3_LETTER;
					if (ItemPool[i] == 33) Flags3 |= RNGF3_MAGICKEY;
					if (ItemPool[i] == 157 || (ItemPool[i] == 158 && RememberStuff[REMEMBER_RANDO_OPTIONS+2])) 
					{
						Flags |= RNGF_PEGASUS;
					}
					if (ItemPool[i] == 27) Flags |= RNGF_LADDER;
					if (ItemPool[i] == 176 || ItemPool[i] == 177) 
					{
						if (Flags & RNGF_ROPE) Flags |= RNGF_ROPE2;
						else Flags |= RNGF_ROPE;
					}
					if (ItemPool[i] == 169 || ItemPool[i] == 54) Flags |= RNGF_GLOVE;
					if (ItemPool[i] == 155 || ItemPool[i] == 156) Flags |= RNGF_SHOVEL;
					if (ItemPool[i] == 153 || ItemPool[i] == 154)
					{
						if (Flags & RNGF_BEETLE) Flags2 |= RNGF2_BEETLE2;
						else Flags |= RNGF_BEETLE;
					}
					if (ItemPool[i] == 13 || ItemPool[i] == 14) 
					{
						if (Flags & RNGF_ARROW) Flags |= RNGF_ARROW2;
						else Flags |= RNGF_ARROW;
					}
					
					if (ItemPool[i] == 26) Flags2 |= RNGF2_RAFT;
					if (ItemPool[i] == 88 || ItemPool[i] == 164) 
					{
						if (Flags2 & RNGF2_PATRA) Flags2 |= RNGF2_PATRA2;
						else Flags2 |= RNGF2_PATRA;
					}
					if (ItemPool[i] == 55 || ItemPool[i] == 170) Flags2 |= RNGF2_BOOTS;
					if (ItemPool[i] == 161) Flags2 |= RNGF2_FISHING;
					if (ItemPool[i] == 171) Flags2 |= RNGF2_LANTERN;
					if (ItemPool[i] == 190 || ItemPool[i] == 221) 
					{
						if (Flags2 & RNGF2_GLEEOK) Flags2 |= RNGF2_GLEEOK2;
						else Flags2 |= RNGF2_GLEEOK;
					}
					if (ItemPool[i] == 15) Flags2 |= RNGF2_BOW;
					if (ItemPool[i] == 25) Flags2 |= RNGF2_WAND;
					if (ItemPool[i] == 16) Flags2 |= RNGF2_BAIT;
					if (ItemPool[i] == 31) Flags2 |= RNGF2_WHISTLE;
					if (ItemPool[i] == 99) Flags2 |= RNGF2_WHISP;
					if (ItemPool[i] == 11) Flags2 |= RNGF2_CANDLE;
					if (ItemPool[i] == 91 || ItemPool[i] == 189 || ItemPool[i] == 208) Flags3 |= RNGF3_FEATHER;
					if (ItemPool[i] == 245) 
					{
						Flags |= RNGF_BOMBS;
						Flags2 |= RNGF2_SBOMBS;
						Flags3 |= RNGF3_TRUEBOMB;
					}
					ItemPool[i] = ItemPool[Maxpool[0]];
					--Maxpool[1];
				}
				
				
				if (RememberStuff[REMEMBER_RANDO_OPTIONS+8] >= 2)
				{
					if (Flags & RNGF_WEAPON) Flags3 |= RNGF3_LVL1;
					if ((Flags & RNGF_SHOVEL) && ((Flags & RNGF_PARTNER) || (Flags & RNGF_SOMARIA))  || ((Flags & RNGF_BOMBS) && (Flags3 & RNGF3_LVL4))) Flags3 |= RNGF3_LVL2;
					if ((Flags2 & RNGF2_FISHING) || (Flags2 & RNGF2_WHISTLE) || ((Flags & RNGF_BOMBS) && (Flags3 & RNGF3_LVL4) && ((Flags & RNGF_PARTNER) || (Flags & RNGF_SOMARIA)))) Flags3 |= RNGF3_LVL3;
					if ((Flags & RNGF_PEGASUS) && ((Flags & RNGF_GLOVE) || (Flags & RNGF_ROPE))) Flags3 |= RNGF3_LVL4;
					if ((Flags & RNGF_BOMBS) && ((Flags & RNGF_GLOVE) || (Flags & RNGF_BOLA))) Flags3 |= RNGF3_LVL5;
					if ((Flags & RNGF_BOMBS) || (Flags2 & RNGF2_RAFT)) Flags3 |= RNGF3_LVL6;
					if (((Flags & RNGF_PARTNER) || (Flags & RNGF_OCTO) || ((Flags & RNGF_ARROW) && (Flags2 & RNGF2_BOW)) || (Flags2 & RNGF2_WAND)) && (Flags & RNGF_GLOVE) && (Flags2 & RNGF2_PATRA) && (Flags & RNGF_ROPE)) Flags3 |= RNGF3_LVL7;
					if ((Flags & RNGF_BOMBS) && (Flags2 & RNGF2_BOOTS) && (Flags & RNGF_BEETLE) && (Flags & RNGF_ROPE) && (Flags & RNGF_OCTO) && ((Flags & RNGF_PARTNER) || (Flags & RNGF_SOMARIA))) Flags3 |= RNGF3_LVL8;
					if ((Flags & RNGF_BOMBS) && (Flags & RNGF_GLOVE) && (Flags & RNGF_ROPE2) && ((!RememberStuff[REMEMBER_RANDO_OPTIONS+4] || (Flags3 & RNGF3_MAGICKEY)) && (Flags2 & RNGF2_WHISP) || TriforcePlaced >= 8)) Flags3 |= RNGF3_LVL9;
					if ((Flags3 & RNGF3_LVL9) && (Flags2 & RNGF2_RAFT) && (Flags2 & RNGF2_CANDLE) && (Flags2 & RNGF2_WHISTLE) && (Flags2 & RNGF2_BOW) && (Flags & RNGF_ARROW) && (Flags2 & RNGF2_BAIT) && (Flags2 & RNGF2_WAND) && (Flags & RNGF_LADDER)) Flags3 |= RNGF3_LVL9KEY;
				}
				else if (RememberStuff[REMEMBER_RANDO_OPTIONS+8] == 1)
				{
					if (Flags & RNGF_WEAPON) Flags3 |= RNGF3_LVL1;
					if ((Flags & RNGF_SHOVEL) && ((Flags & RNGF_PARTNER) || (Flags & RNGF_SOMARIA))) Flags3 |= RNGF3_LVL2;
					if ((Flags2 & RNGF2_FISHING) || (Flags2 & RNGF2_WHISTLE)) Flags3 |= RNGF3_LVL3;
					if ((Flags & RNGF_PEGASUS) && ((Flags & RNGF_GLOVE) || (Flags & RNGF_ROPE))) Flags3 |= RNGF3_LVL4;
					if ((Flags & RNGF_PEGASUS) && (Flags & RNGF_GLOVE) && (Flags & RNGF_BOLA)) Flags3 |= RNGF3_LVL5;
					if ((Flags & RNGF_BOMBS) || (Flags2 & RNGF2_RAFT)) Flags3 |= RNGF3_LVL6;
					if (((Flags & RNGF_PARTNER) || ((Flags & RNGF_ARROW) && (Flags2 & RNGF2_BOW)) || (Flags2 & RNGF2_WAND)) && (Flags & RNGF_GLOVE) && (Flags2 & RNGF2_PATRA) && (Flags & RNGF_ROPE)) Flags3 |= RNGF3_LVL7;
					if ((Flags & RNGF_BOMBS) && (Flags2 & RNGF2_BOOTS) && (Flags & RNGF_BEETLE) && (Flags & RNGF_ROPE) && (Flags & RNGF_OCTO) && ((Flags & RNGF_PARTNER) || (Flags & RNGF_SOMARIA))) Flags3 |= RNGF3_LVL8;
					if ((Flags & RNGF_BOMBS) && ((Flags & RNGF_GLOVE) && (Flags & RNGF_ROPE2)) && TriforcePlaced >= 8) Flags3 |= RNGF3_LVL9;
					if ((Flags3 & RNGF3_LVL9) && (Flags2 & RNGF2_RAFT) && (Flags2 & RNGF2_CANDLE) && (Flags2 & RNGF2_WHISTLE) && (Flags2 & RNGF2_BOW) && (Flags & RNGF_ARROW) && (Flags2 & RNGF2_BAIT) && (Flags2 & RNGF2_WAND) && (Flags & RNGF_LADDER)) Flags3 |= RNGF3_LVL9KEY;
				}
				else
				{
					if ((Flags & RNGF_SOMARIA) && (Flags & RNGF_BEETLE)) Flags3 |= RNGF3_LVL1;
					if ((Flags & RNGF_SHOVEL) && (Flags & RNGF_SOMARIA) && (Flags & RNGF_GLOVE)) Flags3 |= RNGF3_LVL2;
					if ((Flags2 & RNGF2_FISHING) && (Flags & RNGF_PEGASUS)) Flags3 |= RNGF3_LVL3;
					if ((Flags & RNGF_PEGASUS) && (Flags & RNGF_GLOVE)) Flags3 |= RNGF3_LVL4;
					if ((Flags & RNGF_PEGASUS) && (Flags & RNGF_GLOVE) && (Flags & RNGF_BEETLE) && (Flags & RNGF_OCTO)) Flags3 |= RNGF3_LVL5;
					if (Flags & RNGF_BOMBS) Flags3 |= RNGF3_LVL6;
					if ((Flags & RNGF_ARMOS) && (Flags & RNGF_GLOVE) && (Flags2 & RNGF2_PATRA) && (Flags & RNGF_ROPE)) Flags3 |= RNGF3_LVL7;
					if ((Flags & RNGF_BOMBS) && (Flags2 & RNGF2_BOOTS) && (Flags & RNGF_BEETLE) && (Flags & RNGF_ROPE) && (Flags & RNGF_OCTO) && (Flags & RNGF_ARMOS) && (Flags & RNGF_SOMARIA)) Flags3 |= RNGF3_LVL8;
					if ((Flags & RNGF_BOMBS) && (Flags & RNGF_GLOVE) && (Flags & RNGF_ROPE2) && TriforcePlaced >= 8) Flags3 |= RNGF3_LVL9;
					if ((Flags3 & RNGF3_LVL9) && (Flags2 & RNGF2_RAFT) && (Flags2 & RNGF2_CANDLE) && (Flags2 & RNGF2_WHISTLE) && (Flags2 & RNGF2_BOW) && (Flags & RNGF_ARROW) && (Flags2 & RNGF2_BAIT) && (Flags2 & RNGF2_WAND) && (Flags & RNGF_LADDER) && (Flags3 & RNGF3_TRUEBOMB) && (Flags3 & RNGF3_BOOMERANG)) Flags3 |= RNGF3_LVL9KEY;
				}
				
				if (!RememberStuff[REMEMBER_RANDO_OPTIONS+0])
				{
					Flags2 |= RNGF2_FISHING;
					Flags |= RNGF_SHOVEL;
					Flags |= RNGF_BOLA;
					if (isValidLocation(85, Flags, Flags2, Flags3, HeartsPlaced))
					{
						Flags |= RNGF_BOMBS;
						Flags3 |= RNGF3_TRUEBOMB;
					}
					Flags2 |= RNGF2_SBOMBS;
				}
				if (!RememberStuff[REMEMBER_RANDO_OPTIONS+6])
				{
					if (isValidLocation(75, Flags, Flags2, Flags3, HeartsPlaced)) Flags3 |= RNGF3_BOOMERANG;
				}
				
				if (!RememberStuff[REMEMBER_RANDO_OPTIONS+3])
				{
					for (k = 0; k < 8; ++k)
					{
						if (!isValidLocation(91+k, Flags, Flags2, Flags3, HeartsPlaced)) break;
						if (k == 7) TriforcePlaced = 8;
					}
				}
				
				for (k = 0; k < Maxpool[2]; ++k) //Loop through total locations in pool.
				{
					if (isValidLocation(LocationPoolAll[k], Flags, Flags2, Flags3, HeartsPlaced))
					{
						if (Debug)
						{
							int tr[] = "Added location:";
							printf(tr);
							Trace(LocationPoolAll[k]);
						}
						++Maxpool[1];
						--Maxpool[2];
						LocationPool[Maxpool[1]] = LocationPoolAll[k];
						if (Maxpool[2] > 0) LocationPoolAll[k] = LocationPoolAll[Maxpool[2]];
						break;
					}
				}
			}while (Maxpool[1] >= 0)
			if (Maxpool[0] > 0) 
			{
				if (Debug || Maxpool[0] < 10)
				{
					int tr1[] = "Remaining flags:";
					printf(tr1);
					TraceToBase(Flags, 2, 16);
					TraceToBase(Flags2, 2, 16);
					TraceToBase(Flags3, 2, 16);
					int tr2[] = "Remaining locations:";
					printf(tr2);
					for (k = 0; k < Maxpool[2]; ++k) //Loop through total locations in pool.
					{
						Trace(LocationPoolAll[k]);
					}
					int tr3[] = "Invalid shuffle; trying again... \n";
					printf(tr3);
					if (Maxpool[0] < 10)
					{
						int tr4[] = "So close too... Maybe something broke? \n";
						printf(tr4);
					}
				}
			}
			if (waitcounter == 0) WaitNoAction();
			++waitcounter;
			waitcounter%=5;
			
		}while (Maxpool[0] > 0)
		DoDraw = true;
		if (RememberStuff[REMEMBER_RANDO_OPTIONS+0]) Game->DCounter[CR_RUPEES] = 100;
		if (!RememberStuff[REMEMBER_RANDO_OPTIONS+12]) RememberStuff[REMEMBER_EX3_SPOILERLOG] = 1; 
		Link->Y = -16;
	}
}

ffc script RandReplaceItem
{
	void run(int location)
	{
		if (IsRandomizer())
		{
			bool found = false;
			item FFCRandoItem;
			int ForTimer = 0;
			while(true)
			{
				for (ForTimer = Screen->NumItems(); ForTimer > 0; --ForTimer)
				{
					FFCRandoItem = Screen->LoadItem(ForTimer);
					if (FFCRandoItem->isValid())
					{
						if (GetItemPickup(FFCRandoItem, IP_ST_ITEM) || GetItemPickup(FFCRandoItem, IP_ST_SPECIALITEM))
						{
							found = true;
							break;
						}
					}
				}
				if (found) break;
				else Waitframe();
			}
			if (location < 0)
			{
				if (Game->GetCurDMap() == 0 && RememberStuff[REMEMBER_SCREEN] == 0x10) 
				{
					location = 10;
					if (Randomizer_GetItemReplacement(location) > 0)
					{
						item NewItem = CreateItemAt(Randomizer_GetItemReplacement(location), FFCRandoItem->X, FFCRandoItem->Y);
						NewItem->Pickup = FFCRandoItem->Pickup;
						if (Link->MaxHP < 80) NewItem->HitYOffset = -1000;
						Remove(FFCRandoItem);
					}
				}
				if (Game->GetCurDMap() == 0 && RememberStuff[REMEMBER_SCREEN] == 0x20) 
				{
					location = 12;
					if (Randomizer_GetItemReplacement(location) > 0)
					{
						item NewItem = CreateItemAt(Randomizer_GetItemReplacement(location), FFCRandoItem->X, FFCRandoItem->Y);
						NewItem->Pickup = FFCRandoItem->Pickup;
						if (Link->MaxHP < 192) NewItem->HitYOffset = -1000;
						Remove(FFCRandoItem);
					}
				}
				if (Game->GetCurMap() == 2 && RememberStuff[REMEMBER_SCREEN] == 0x42) 
				{
					location = 44;
					if (Randomizer_GetItemReplacement(location) > 0)
					{
						item NewItem = CreateItemAt(Randomizer_GetItemReplacement(location), FFCRandoItem->X, FFCRandoItem->Y);
						NewItem->Pickup = FFCRandoItem->Pickup;
						Remove(FFCRandoItem);
					}
				}
				if (Game->GetCurMap() == 2 && RememberStuff[REMEMBER_SCREEN] == 0x4B) 
				{
					location = 48;
					if (Randomizer_GetItemReplacement(location) > 0)
					{
						item NewItem = CreateItemAt(Randomizer_GetItemReplacement(location), FFCRandoItem->X, FFCRandoItem->Y);
						NewItem->Pickup = FFCRandoItem->Pickup;
						Remove(FFCRandoItem);
					}
				}
				if (Game->GetCurMap() == 3 && RememberStuff[REMEMBER_SCREEN] == 0x56) 
				{
					location = 67;
					if (Randomizer_GetItemReplacement(location) > 0)
					{
						item NewItem = CreateItemAt(Randomizer_GetItemReplacement(location), FFCRandoItem->X, FFCRandoItem->Y);
						NewItem->Pickup = FFCRandoItem->Pickup;
						Remove(FFCRandoItem);
					}
				}
			}
			else if (Randomizer_GetItemReplacement(location) > 0)
			{
				item NewItem = CreateItemAt(Randomizer_GetItemReplacement(location), FFCRandoItem->X, FFCRandoItem->Y);
				NewItem->Pickup = FFCRandoItem->Pickup;
				Remove(FFCRandoItem);
			}
		}
		else if (location < 0)
		{
			bool found = false;
			item FFCRandoItem;
			int ForTimer = 0;
			while(true)
			{
				for (ForTimer = Screen->NumItems(); ForTimer > 0; --ForTimer)
				{
					FFCRandoItem = Screen->LoadItem(ForTimer);
					if (FFCRandoItem->isValid())
					{
						if (GetItemPickup(FFCRandoItem, IP_ST_ITEM) || GetItemPickup(FFCRandoItem, IP_ST_SPECIALITEM))
						{
							found = true;
							break;
						}
					}
				}
				if (found) break;
				else Waitframe();
			}
			if (Game->GetCurDMap() == 0 && RememberStuff[REMEMBER_SCREEN] == 0x10) 
			{
				if (Link->MaxHP < 80) FFCRandoItem->HitYOffset = -1000;
			}
			if (Game->GetCurDMap() == 0 && RememberStuff[REMEMBER_SCREEN] == 0x20) 
			{
				if (Link->MaxHP < 192) FFCRandoItem->HitYOffset = -1000;
			}
		}
	}
}

//Functions originally by Moosh

bool IsRandomizer(){
	if (RememberStuff[REMEMBER_ISRANDO]) return true;
	else return false;
}

int Randomizer_GetItemReplacement(int location){
	
	int itemID = RememberStuff[REMEMBER_RANDOSTART + location];
	if (!RememberStuff[REMEMBER_RANDO_OPTIONS+2]) return itemID;
	if(itemID==I_CANE1||itemID==I_CANE2||itemID==I_CANE3){
		if(Link->Item[I_CANE2])
			return I_CANE3;
		else if(Link->Item[I_CANE1])
			return I_CANE2;
		return I_CANE1;
	}
	if(itemID==I_ARROW1||itemID==I_ARROW2){
		if(Link->Item[I_ARROW1])
			return I_ARROW2;
		return I_ARROW1;
	}
	if(itemID==162||itemID==163){ //Octorock
		if(Link->Item[162])
			return 163;
		return 162;
	}
	if(itemID==155||itemID==156){ //Shovel
		if(Link->Item[155] || !RememberStuff[REMEMBER_RANDO_OPTIONS+0])
			return 156;
		return 155;
	}
	if(itemID==159||itemID==160){ //Bola
		if(Link->Item[159] || !RememberStuff[REMEMBER_RANDO_OPTIONS+0])
			return 160;
		return 159;
	}
	if(itemID==157||itemID==158){ //Pegasus
		if(Link->Item[157])
			return 158;
		return 157;
	}
	if(itemID==176||itemID==177){ //Ropes
		if(Link->Item[176])
			return 177;
		return 176;
	}
	if(itemID==190||itemID==221){ //Gleeok
		if(Link->Item[190])
			return 221;
		return 190;
	}
	if(itemID==52||itemID==89){ //Hookshots
		if(Link->Item[52])
			return 89;
		return 52;
	}
	if(itemID==91||itemID==189||itemID==208){ //Feathers
		if(Link->Item[189])
			return 208;
		if(Link->Item[91])
			return 189;
		return 91;
	}
	if(itemID==88||itemID==164){ //Patras
		if(Link->Item[88])
			return 164;
		return 88;
	}
	if(itemID==23||itemID==24||itemID==35){ //boomerangs
		if(Link->Item[23]||Link->Item[24])
			return 35;
		if (RememberStuff[REMEMBER_BRANG] == 1) return 24;
		return 23;
	}
	if(itemID==25||itemID==32){ //Wand
		if(Link->Item[25])
			return 32;
		return 25;
	}
	if(itemID==153||itemID==154){ //Keese
		if(Link->Item[153])
			return 154;
		return 153;
	}
	if(itemID==55||itemID==170){ //Boots
		if(Link->Item[55])
			return 170;
		return 55;
	}
	
	
	return itemID;
}
//End of Moosh Functions

bool isValidLocation(int location, int Flags1, int Flags2, int Flags3, int Hearts)
{
	//return true;
	bool Debug = false;
	if (Debug)
	{
		int tr1[] = "Current flags:";
		printf(tr1);
		TraceToBase(Flags1, 2, 16);
		TraceToBase(Flags2, 2, 16);
		TraceToBase(Flags3, 2, 16);
	}
	if (location == 1) return true; //Nothing
	//Trace(location);
	if (Flags1 & RNGF_WEAPON)
	{
		int tr2[] = "Testing Part 1. \n";
		if (Debug) printf(tr2);
		if (location == 5 || location == 19 || location == 80 || location == 81 || location == 82 || location == 83 || location == 99 || location == 100 || location == 101 || location == 103 || location == 104 || location == 105 || location == 106 || location == 107) return true;
		if (Flags1 & RNGF_PEGASUS)
		{
			int tr[] = "Testing 1. \n";
			if (Debug) printf(tr);
			if (location == 2 || location == 22 || location == 32 || location == 34 || location == 73 || location == 109 || location == 110 || location == 111 || location == 114 || location == 131 || location == 132) return true; //Pegasus
			if ((Flags1 & RNGF_SHOVEL) && (Flags2 & RNGF2_SBOMBS) && (location == 39 || location == 40 || location == 123)) return true;
			if ((Flags1 & RNGF_ROPE) && location == 72) return true;
			if ((Flags1 & RNGF_BEETLE) && location == 112) return true;
		}
		if (Flags1 & RNGF_SHOVEL)
		{
			int tr[] = "Testing 2. \n";
			if (Debug) printf(tr);
			if (location == 3 || location == 17 || location == 20 || location == 23 || location == 26 || location == 84 || location == 113 || location == 124 || location == 125 || location == 127 || location == 128) return true;
		}
		if (Flags1 & RNGF_PARTNER)
		{
			int tr[] = "Testing 3. \n";
			if (Debug) printf(tr);
			if (((Flags1 & RNGF_LADDER) || (Flags1 & RNGF_ROPE)) && location == 4) return true;
		}
		if (Flags2 & RNGF2_FISHING)
		{
			int tr[] = "Testing 4. \n";
			if (Debug) printf(tr);
			if (location == 6 || location == 14 || location == 27 || location == 28 || location == 31) return true;
			if (((Flags1 & RNGF_LADDER) || (Flags1 & RNGF_ROPE)) && location == 15) return true;
		}
		if (Flags2 & RNGF2_LANTERN)
		{
			int tr[] = "Testing 5. \n";
			if (Debug) printf(tr);
			if (location == 7) return true;
			if (((Flags1 & RNGF_SHOVEL) || (Flags1 & RNGF_GLOVE)) && location == 21) return true;
		}
		if (Flags1 & RNGF_ARMOS)
		{
			int tr[] = "Testing 6. \n";
			if (Debug) printf(tr);
			if (location == 8) return true;
			if ((Flags1 & RNGF_ROPE2) && location == 30) return true;
		}
		if (Flags1 & RNGF_BEETLE)
		{
			int tr[] = "Testing 7. \n";
			if (Debug) printf(tr);
			if (location == 16 || location == 24) return true;
			if ((Flags1 & RNGF_ROPE) && location == 9) return true;
			if ((Flags1 & RNGF_ROPE2) && location == 24) return true;
			if (((Flags2 & RNGF2_BOOTS) || (Flags1 & RNGF_LADDER) || (Flags1 & RNGF_ROPE)) && location == 37) return true;
		}
		if (Hearts >= 4)
		{
			int tr[] = "Testing 8. \n";
			if (Debug) printf(tr);
			if (location == 10) return true;
		}
		if (Flags2 & RNGF2_BOOTS)
		{
			int tr[] = "Testing 9. \n";
			if (Debug) printf(tr);
			if (location == 11) return true;
		}
		if ((Flags1 & RNGF_BOMBS) || (Flags1 & RNGF_LADDER) || (Flags1 & RNGF_ROPE) || (Flags2 & RNGF2_RAFT))
		{
			int tr[] = "Testing 10. \n";
			if (Debug) printf(tr);
			if (Hearts >= 18 && location == 12) return true;
			if ((Flags1 & RNGF_SHOVEL) && (location == 35 || location == 120 || location == 121 || location == 122 || location == 126)) return true;
			if ((Flags1 & RNGF_ROPE) && location == 36) return true;
			if (location == 115 || location == 116 || location == 117 || location == 118 || location == 119) return true;
		}
		if (Flags3 & RNGF3_TRUEBOMB)
		{
			if (location == 108) return true;
		}
		if ((Flags1 & RNGF_LADDER) || (Flags1 & RNGF_ROPE))
		{
			int tr[] = "Testing 11. \n";
			if (Debug) printf(tr);
			if (location == 13 || location == 16) return true;
		}
		if (Flags2 & RNGF2_SBOMBS)
		{
			int tr[] = "Testing 12. \n";
			if (Debug) printf(tr);
			if (location == 18) return true;
		}
		if (Flags1 & RNGF_ROPE2)
		{
			int tr[] = "Testing 13. \n";
			if (Debug) printf(tr);
			if (location == 24 || location == 29) return true;
		}
		if (Flags1 & RNGF_ROPE)
		{
			int tr[] = "Testing 14. \n";
			if (Debug) printf(tr);
			if (location == 25) return true;
		}
		if (Flags1 & RNGF_GLOVE)
		{
			int tr[] = "Testing 15. \n";
			if (Debug) printf(tr);
			if (location == 33) return true;
		}
		if ((Flags1 & RNGF_BOLA) && (Flags2 & RNGF2_BOOTS))
		{
			int tr[] = "Testing 16. \n";
			if (Debug) printf(tr);
			if (location == 38) return true;
		}
		if (Flags3 & RNGF3_LETTER)
		{
			int tr[] = "Testing 17. \n";
			if (Debug) printf(tr);
			if (location == 129 || location == 130) return true;
		}
		int tr3[] = "Testing Part 2. \n";
		if (Debug) printf(tr3);
		//Dungeon items
		if (Flags3 & RNGF3_LVL1)
		{
			int tr[] = "Testing Lvl 1. \n";
			if (Debug) printf(tr);
			if (((Flags1 & RNGF_PEGASUS) || (Flags1 & RNGF_SOMARIA) || (Flags2 & RNGF2_PATRA) || (Flags1 & RNGF_LADDER) || (Flags1 & RNGF_ROPE) || (Flags3 & RNGF3_FEATHER)) && location == 41) return true;
			if ((Flags1 & RNGF_BEETLE) && location == 76) return true;
			if ((Flags1 & RNGF_BEETLE) && location == 91) return true;
		}
		if (Flags3 & RNGF3_LVL2)
		{
			int tr[] = "Testing Lvl 2. \n";
			if (Debug) printf(tr);
			if ((Flags1 & RNGF_WEAPON) && location == 42) return true;
			if ((Flags1 & RNGF_GLOVE) && location == 43) return true;
			if ((Flags1 & RNGF_GLOVE) && (Flags2 & RNGF2_PATRA) && location == 77) return true;
			if ((Flags1 & RNGF_GLOVE) && (Flags2 & RNGF2_PATRA) && location == 92) return true;
		}
		if (Flags3 & RNGF3_LVL3)
		{
			int tr[] = "Testing Lvl 3. \n";
			if (Debug) printf(tr);
			if (((Flags1 & RNGF_SOMARIA) || ((Flags1 & RNGF_PEGASUS) && (Flags1 & RNGF_PARTNER) && (Flags3 & RNGF3_LVL2) && (Flags3 & RNGF3_LVL6))) && location == 44) return true;
			if ((Flags1 & RNGF_PEGASUS) && location == 78) return true;
			if ((Flags1 & RNGF_PEGASUS) && location == 93) return true;
		}
		if (Flags3 & RNGF3_LVL4)
		{
			int tr[] = "Testing Lvl 4. \n";
			if (Debug) printf(tr);
			if (location == 45) return true;
			if ((Flags2 & RNGF2_LANTERN) && location == 46) return true;
			if ((Flags2 & RNGF2_LANTERN) && (Flags1 & RNGF_ROPE) && location == 79) return true;
			if ((Flags2 & RNGF2_LANTERN) && (Flags1 & RNGF_ROPE) && location == 94) return true;
		}
		if (Flags3 & RNGF3_LVL5)
		{
			int tr[] = "Testing Lvl 5. \n";
			if (Debug) printf(tr);
			if (location == 47) return true;
			if ((Flags1 & RNGF_OCTO) && location == 48) return true;
			if (location == 87) return true;
			if (location == 95) return true;
		}
		if (Flags3 & RNGF3_LVL6)
		{
			int tr[] = "Testing Lvl 6. \n";
			if (Debug) printf(tr);
			if (location == 49) return true;
			if ((Flags1 & RNGF_ARMOS) && (Flags1 & RNGF_BOMBS) && location == 88) return true;
			if ((Flags1 & RNGF_ARMOS) && (Flags1 & RNGF_BOMBS) && location == 96) return true;
		}
		if (Flags3 & RNGF3_LVL7)
		{
			int tr[] = "Testing Lvl 7. \n";
			if (Debug) printf(tr);
			if (location == 50) return true;
			if (((Flags1 & RNGF_ROPE2) || (Flags2 & RNGF2_PATRA2)) && ((Flags1 & RNGF_BEETLE) || (Flags2 & RNGF2_SBOMBS) || (Flags3 & RNGF3_TRUEBOMB)) && location == 51) return true;
			if ((Flags2 & RNGF2_BEETLE2) && location == 52) return true;
			if (((Flags1 & RNGF_ROPE2) || ((Flags2 & RNGF2_PATRA2) && (Flags1 & RNGF_BEETLE) && (Flags2 & RNGF2_WHISP))) && location == 89) return true;
			if (((Flags1 & RNGF_ROPE2) || ((Flags2 & RNGF2_PATRA2) && (Flags1 & RNGF_BEETLE) && (Flags2 & RNGF2_WHISP))) && location == 97) return true;
		}
		if (Flags3 & RNGF3_LVL8)
		{
			int tr[] = "Testing Lvl 8. \n";
			if (Debug) printf(tr);
			if (location == 52) return true;
			if (((Flags1 & RNGF_ROPE2) || (Flags2 & RNGF2_GLEEOK) || ((Flags2 & RNGF2_BEETLE2) && (Flags1 & RNGF_SOMARIA) && (Flags1 & RNGF_GLOVE) && ((Flags1 & RNGF_LADDER) || (Flags1 & RNGF_ROPE)))) && location == 53) return true;
			if (((((Flags1 & RNGF_ROPE2) || (Flags2 & RNGF2_GLEEOK)) && (Flags2 & RNGF2_BEETLE2) && (Flags1 & RNGF_SOMARIA) && (Flags1 & RNGF_GLOVE) && (Flags1 & RNGF_ROPE)) || Flags3 & RNGF3_LVL9) && location == 54) return true;
			if ((((Flags2 & RNGF2_GLEEOK) && (Flags2 & RNGF2_BEETLE2) && (Flags1 & RNGF_SOMARIA) && (Flags1 & RNGF_GLOVE) && (Flags1 & RNGF_ROPE) && (Flags2 & RNGF2_PATRA2)) || (Flags1 & RNGF_ROPE2)) && location == 55) return true;
			if ((Flags2 & RNGF2_GLEEOK2) && (((Flags1 & RNGF_ROPE) && (Flags2 & RNGF2_PATRA2)) || (Flags1 & RNGF_ROPE2)) && location == 90) return true;
			if ((Flags2 & RNGF2_GLEEOK2) && (Flags1 & RNGF_SHOVEL) && (((Flags1 & RNGF_ROPE) && (Flags2 & RNGF2_PATRA2)) || (Flags1 & RNGF_ROPE2)) && location == 98) return true;
		}
		if (Flags3 & RNGF3_LVL9)
		{
			int tr[] = "Testing Lvl 9. \n";
			if (Debug) printf(tr);
			if (location == 56 && (Flags1 & RNGF_SOMARIA) && (Flags1 & RNGF_PARTNER) && (Flags2 & RNGF2_PATRA2) && (Flags2 & RNGF2_FISHING) && (Flags2 & RNGF2_GLEEOK) && (Flags2 & RNGF2_WHISP)) return true;
			if (location == 57 && (Flags1 & RNGF_BOMBS)) return true;
			if (location == 58 && (Flags1 & RNGF_BOMBS)) return true;
			if (location == 71 && (Flags1 & RNGF_BOMBS)) return true;
			if (location == 86 && (Flags1 & RNGF_BOMBS)) return true;
			if (location == 85 && (Flags1 & RNGF_BOMBS)) return true;
			if (location == 102 && (Flags1 & RNGF_BOMBS)) return true;
			if (location == 75 && (Flags1 & RNGF_BOMBS)) return true;
			if (location == 59 && (Flags1 & RNGF_BOMBS) && ((Flags1 & RNGF_PARTNER || Flags1 & RNGF_SOMARIA)) && (Flags2 & RNGF2_WHISP) && ((Flags3 & RNGF3_MAGICKEY) || (Flags2 & RNGF2_PATRA) && (Flags2 & RNGF2_PATRA) && (Flags2 & RNGF2_WAND) && (Flags1 & RNGF_SOMARIA) && (Flags2 & RNGF2_SBOMBS)
			&& (Flags2 & RNGF2_CANDLE) && (Flags1 & RNGF_BOLA) && (Flags1 & RNGF_OCTO))) return true;
			if (location == 60 && (Flags1 & RNGF_PEGASUS) && ((Flags3 & RNGF3_MAGICKEY) || (Flags2 & RNGF2_PATRA) && (Flags2 & RNGF2_PATRA) && (Flags2 & RNGF2_WAND) && (Flags1 & RNGF_SOMARIA) && (Flags2 & RNGF2_SBOMBS)
			&& (Flags2 & RNGF2_CANDLE) && (Flags1 & RNGF_BOLA) && (Flags1 & RNGF_OCTO))) return true;
			
			if (location == 61 && (
			(Flags2 & RNGF2_PATRA) && (Flags2 & RNGF2_PATRA) && (Flags2 & RNGF2_WAND) && (Flags1 & RNGF_SOMARIA) && (Flags2 & RNGF2_SBOMBS)
			&& (Flags2 & RNGF2_CANDLE) && (Flags1 & RNGF_BOLA) && (Flags1 & RNGF_OCTO))) return true;
			
			if (location == 62 && (
			(Flags2 & RNGF2_PATRA) && (Flags2 & RNGF2_PATRA) && (Flags2 & RNGF2_WAND) && (Flags1 & RNGF_SOMARIA) && (Flags2 & RNGF2_SBOMBS)
			&& (Flags2 & RNGF2_CANDLE) && (Flags1 & RNGF_BOLA))) return true;
			
			if (location == 63 && (
			(Flags2 & RNGF2_PATRA) && (Flags2 & RNGF2_PATRA) && (Flags2 & RNGF2_WAND) && (Flags1 & RNGF_SOMARIA) && (Flags2 & RNGF2_SBOMBS)
			&& (Flags2 & RNGF2_CANDLE) && (Flags1 & RNGF_BOLA))) return true;
			
			if (location == 64 && (
			(Flags2 & RNGF2_PATRA) && (Flags2 & RNGF2_PATRA) && (Flags2 & RNGF2_WAND) && (Flags1 & RNGF_SOMARIA) && (Flags2 & RNGF2_SBOMBS)
			&& (Flags2 & RNGF2_CANDLE))) return true;
			
			if (location == 65 && (
			(Flags2 & RNGF2_PATRA) && (Flags2 & RNGF2_PATRA) && (Flags2 & RNGF2_WAND) && (Flags1 & RNGF_SOMARIA) && (Flags2 & RNGF2_SBOMBS)
			 && (Flags2 & RNGF2_BEETLE2))) return true;
			
			if (location == 66 && (
			(Flags2 & RNGF2_PATRA) && (Flags2 & RNGF2_PATRA) && (Flags2 & RNGF2_WAND) && (Flags1 & RNGF_SOMARIA) && (Flags2 & RNGF2_SBOMBS))) return true;
			
			if (location == 67 && (
			(Flags2 & RNGF2_PATRA) && (Flags2 & RNGF2_PATRA) && (Flags2 & RNGF2_WAND) && (Flags1 & RNGF_SOMARIA) && (Flags2 & RNGF2_SBOMBS))) return true;
			
			if (location == 68 && (
			(Flags2 & RNGF2_PATRA) && (Flags2 & RNGF2_PATRA) && (Flags2 & RNGF2_WAND) && (Flags1 & RNGF_SOMARIA) && (Flags2 & RNGF2_SBOMBS))) return true;
			
			if (location == 69 && (Flags3 & RNGF3_LVL9KEY) && (Flags1 & RNGF_SOMARIA) && (!RememberStuff[REMEMBER_RANDO_OPTIONS+4] || (Flags3 & RNGF3_MAGICKEY))) return true;
			
			if (location == 70 && (Flags1 & RNGF_SOMARIA) && (Flags1 & RNGF_PEGASUS) && ((Flags1 & RNGF_LADDER)||(Flags3 & RNGF3_FEATHER)) && (Flags2 & RNGF2_PATRA)) return true;
			if (location == 74 && (Flags2 & RNGF2_BOW) && (Flags1 & RNGF_ARROW) && (Flags2 & RNGF2_GLEEOK) && (Flags2 & RNGF2_FISHING) && (Flags1 & RNGF_OCTO) && (Flags2 & RNGF2_BEETLE2)) return true;
		}
		int tr[] = "Can't Place. \n";
		if (Debug) printf(tr);
	}
	return false;
}

ffc script RandoMenu
{
	void run()
	{
		int STR_SEED[] = "SEED:";
		int STR_ON[] = "ON";
		int STR_OFF[] = "OFF";
		int STR_EASY[] = "EASY";
		int STR_NORMAL[] = "NORMAL";
		int STR_HARD[] = "HARD";
		int STR_INSANE[] = "INSANE";
		int STR_SHOPS[] = "SHOPS:";
		int STR_RANDOMIZER[] = " WELCOME TO RANDOMIZER! ";
		int STR_JUNK[] = "EXTRA INVENTORY ITEMS:";
		int STR_PROG[] = "PROGRESSIVE ITEM POWER:";
		int STR_TRIF[] = "RANDOMIZE TRIFORCES:  ";
		int STR_KEYS[] = "LEVEL D LOCKS REQUIRED: ";
		int STR_BETU[] = "RANDOMIZE 'BET YOU'D LIKE':";
		int STR_TAKE[] = "RANDOMIZE 'TAKE ONLY ONE':";
		int STR_SWRD[] = "RANDOMIZE FIRST WEAPON: ";
		int STR_HRTS[] = "FULLSIZE HEART CONTAINERS:";
		int STR_RUPY[] = "RANDOMIZE RUPY CAVES:";
		int STR_POTS[] = "RANDOMIZE POTION SHOPS:";
		int STR_SPOILERLOG[] = "SPOILER LOG:";
		int STR_HIDDEN[] = "HIDDEN";
		int STR_EX3[] = "EX3 BUTTON";
		int STR_LOGIC[] = "LOGIC:";
		int digits[4];
		int selected = -1;
		int i;
		for (i = 0; i < 4; ++i) digits[i] = Rand(16);
		for (i = 0; i <= 11; ++i) RememberStuff[REMEMBER_RANDO_OPTIONS+i] = 1;
		while(Link->PressStart) 
		{
			Link->PressStart = false;
			WaitNoAction();
		}
		while(!Link->PressStart || selected >= 0)
		{
			if (Link->PressUp || Link->PressDown || Link->PressA
			|| (Link->PressLeft && (selected >= -1 || RememberStuff[REMEMBER_RANDO_OPTIONS+(Abs(selected)-3)] && selected != -2 && selected > -11)) 
			|| (Link->PressRight && (selected >= -1 || !RememberStuff[REMEMBER_RANDO_OPTIONS+(Abs(selected)-3)] && selected != -2 && selected > -11))
			|| (Link->PressLeft && (RememberStuff[REMEMBER_RANDO_OPTIONS+(Abs(selected)-2)] && selected <= -11)) 
			|| (Link->PressRight && (!RememberStuff[REMEMBER_RANDO_OPTIONS+(Abs(selected)-2)] && selected <= -11))) Game->PlaySound(65);
			if (selected >= 0)
			{
				if (Link->PressUp) ++digits[selected];
				if (Link->PressDown) --digits[selected];
				if (Link->PressL) digits[selected]-=4;
				if (Link->PressR) digits[selected]+=4;
				if (Link->PressRight && selected < 3) ++selected;
				if (Link->PressLeft) --selected;
				if (Link->PressA) selected = -1;
				if (Link->PressL || Link->PressR) Game->PlaySound(65);
				if (Link->PressStart)
				{
					Link->PressStart = false;
					selected = -1;
				}
			}
			else if (selected == -1)
			{
				if (Link->PressRight || Link->PressA) ++selected;
				if (Link->PressUp) selected = -14;
				else if (Link->PressDown) --selected;
			}
			else if (selected > -11)
			{
				if (selected != -2)
				{
					if (Link->PressRight) RememberStuff[REMEMBER_RANDO_OPTIONS+(Abs(selected)-3)] = 1;
					else if (Link->PressLeft) RememberStuff[REMEMBER_RANDO_OPTIONS+(Abs(selected)-3)] = 0;
					if (Link->PressB) RememberStuff[REMEMBER_RANDO_OPTIONS+(Abs(selected)-3)] = Rand(2);
				}
				else
				{
					if (Link->PressRight && RememberStuff[REMEMBER_RANDO_OPTIONS+8] < 3) 
					{
						++RememberStuff[REMEMBER_RANDO_OPTIONS+8];
						Game->PlaySound(65);
					}
					else if (Link->PressLeft && RememberStuff[REMEMBER_RANDO_OPTIONS+8] > 0) 
					{
						--RememberStuff[REMEMBER_RANDO_OPTIONS+8];
						Game->PlaySound(65);
					}
					if (Link->PressB) RememberStuff[REMEMBER_RANDO_OPTIONS+8] = Rand(4);
				}
				if (Link->PressUp) ++selected;
				else if (Link->PressDown || Link->PressA) --selected;
			}
			else
			{
				if (Link->PressRight) RememberStuff[REMEMBER_RANDO_OPTIONS+(Abs(selected)-2)] = 1;
				else if (Link->PressLeft) RememberStuff[REMEMBER_RANDO_OPTIONS+(Abs(selected)-2)] = 0;
				if (Link->PressB) RememberStuff[REMEMBER_RANDO_OPTIONS+(Abs(selected)-2)] = Rand(2);
				if (Link->PressUp) ++selected;
				else if (Link->PressDown || Link->PressA) --selected;
			}
			
			if (selected > 3) selected = -1;
			if (selected < -14) selected = -1;
			
			Screen->DrawString(6, 88 + 1, 32 + 1, FONT_Z1, 6, -1, TF_NORMAL, STR_SEED, OP_OPAQUE);
			if (selected == -1) Screen->DrawString(6, 88, 32, FONT_Z1, 1, -1, TF_NORMAL, STR_SEED, OP_OPAQUE);
			
			Screen->DrawString(6, 32, 16, FONT_Z1, 3, 0, TF_NORMAL, STR_RANDOMIZER, OP_OPAQUE);

			// Logic:
			Screen->DrawString(6, 8+1, 48 + 1, FONT_Z1, 2, 0, TF_NORMAL, STR_LOGIC, OP_OPAQUE);
			if (RememberStuff[REMEMBER_RANDO_OPTIONS+8] == 3) Screen->DrawString(6, 248+1, 48 + 1, FONT_Z1, Choose(6,3,11), 0, TF_RIGHT, STR_INSANE, OP_OPAQUE);
			else if (RememberStuff[REMEMBER_RANDO_OPTIONS+8] == 2) Screen->DrawString(6, 248+1, 48 + 1, FONT_Z1, 2, 0, TF_RIGHT, STR_HARD, OP_OPAQUE);
			else if (RememberStuff[REMEMBER_RANDO_OPTIONS+8] == 1) Screen->DrawString(6, 248+1, 48 + 1, FONT_Z1, 2, 0, TF_RIGHT, STR_NORMAL, OP_OPAQUE);
			else Screen->DrawString(6, 248+1, 48 + 1, FONT_Z1, 2, 0, TF_RIGHT, STR_EASY, OP_OPAQUE);
			if (selected == -2) 
			{
				Screen->DrawString(6, 8, 48, FONT_Z1, 1, -1, TF_NORMAL, STR_LOGIC, OP_OPAQUE);
				if (RememberStuff[REMEMBER_RANDO_OPTIONS+8] == 3) Screen->DrawString(6, 248, 48, FONT_Z1, Choose(1,4,12), 0, TF_RIGHT, STR_INSANE, OP_OPAQUE);
				else if (RememberStuff[REMEMBER_RANDO_OPTIONS+8] == 2) Screen->DrawString(6, 248, 48, FONT_Z1, 1, -1, TF_RIGHT, STR_HARD, OP_OPAQUE);
				else if (RememberStuff[REMEMBER_RANDO_OPTIONS+8] == 1) Screen->DrawString(6, 248, 48, FONT_Z1, 1, -1, TF_RIGHT, STR_NORMAL, OP_OPAQUE);
				else Screen->DrawString(6, 248, 48, FONT_Z1, 1, -1, TF_RIGHT, STR_EASY, OP_OPAQUE);
			}
			
			// Random Shops:
			Screen->DrawString(6, 8+1, 56 + 1, FONT_Z1, 2, 0, TF_NORMAL, STR_SHOPS, OP_OPAQUE);
			if (RememberStuff[REMEMBER_RANDO_OPTIONS+0]) Screen->DrawString(6, 248+1, 56 + 1, FONT_Z1, 2, 0, TF_RIGHT, STR_ON, OP_OPAQUE);
			else Screen->DrawString(6, 248+1, 56 + 1, FONT_Z1, 2, 0, TF_RIGHT, STR_OFF, OP_OPAQUE);
			if (selected == -3) 
			{
				Screen->DrawString(6, 8, 56, FONT_Z1, 1, -1, TF_NORMAL, STR_SHOPS, OP_OPAQUE);
				if (RememberStuff[REMEMBER_RANDO_OPTIONS+0]) Screen->DrawString(6, 248, 56, FONT_Z1, 1, -1, TF_RIGHT, STR_ON, OP_OPAQUE);
				else Screen->DrawString(6, 248, 56, FONT_Z1, 1, -1, TF_RIGHT, STR_OFF, OP_OPAQUE);
			}

			// Extra Inventory Items:			
			Screen->DrawString(6, 8+1, 64 + 1, FONT_Z1, 2, 0, TF_NORMAL, STR_JUNK, OP_OPAQUE);
			if (RememberStuff[REMEMBER_RANDO_OPTIONS+1]) Screen->DrawString(6, 248+1, 64 + 1, FONT_Z1, 2, 0, TF_RIGHT, STR_ON, OP_OPAQUE);
			else Screen->DrawString(6, 248+1, 64 + 1, FONT_Z1, 2, 0, TF_RIGHT, STR_OFF, OP_OPAQUE);
			if (selected == -4) 
			{
				Screen->DrawString(6, 8, 64, FONT_Z1, 1, -1, TF_NORMAL, STR_JUNK, OP_OPAQUE);
				if (RememberStuff[REMEMBER_RANDO_OPTIONS+1]) Screen->DrawString(6, 248, 64, FONT_Z1, 1, -1, TF_RIGHT, STR_ON, OP_OPAQUE);
				else Screen->DrawString(6, 248, 64, FONT_Z1, 1, -1, TF_RIGHT, STR_OFF, OP_OPAQUE);
			}
			
			// Progressive Items:
			Screen->DrawString(6, 8+1, 72 + 1, FONT_Z1, 2, 0, TF_NORMAL, STR_PROG, OP_OPAQUE);
			if (RememberStuff[REMEMBER_RANDO_OPTIONS+2]) Screen->DrawString(6, 248+1, 72 + 1, FONT_Z1, 2, 0, TF_RIGHT, STR_ON, OP_OPAQUE);
			else Screen->DrawString(6, 248+1, 72 + 1, FONT_Z1, 2, 0, TF_RIGHT, STR_OFF, OP_OPAQUE);
			if (selected == -5) 
			{
				Screen->DrawString(6, 8, 72, FONT_Z1, 1, -1, TF_NORMAL, STR_PROG, OP_OPAQUE);
				if (RememberStuff[REMEMBER_RANDO_OPTIONS+2]) Screen->DrawString(6, 248, 72, FONT_Z1, 1, -1, TF_RIGHT, STR_ON, OP_OPAQUE);
				else Screen->DrawString(6, 248, 72, FONT_Z1, 1, -1, TF_RIGHT, STR_OFF, OP_OPAQUE);
			}

			// Random Triforces:			
			Screen->DrawString(6, 8+1, 80 + 1, FONT_Z1, 2, 0, TF_NORMAL, STR_TRIF, OP_OPAQUE);
			if (RememberStuff[REMEMBER_RANDO_OPTIONS+3]) Screen->DrawString(6, 248+1, 80 + 1, FONT_Z1, 2, 0, TF_RIGHT, STR_ON, OP_OPAQUE);
			else Screen->DrawString(6, 248+1, 80 + 1, FONT_Z1, 2, 0, TF_RIGHT, STR_OFF, OP_OPAQUE);
			if (selected == -6) 
			{
				Screen->DrawString(6, 8, 80, FONT_Z1, 1, -1, TF_NORMAL, STR_TRIF, OP_OPAQUE);
				if (RememberStuff[REMEMBER_RANDO_OPTIONS+3]) Screen->DrawString(6, 248, 80, FONT_Z1, 1, -1, TF_RIGHT, STR_ON, OP_OPAQUE);
				else Screen->DrawString(6, 248, 80, FONT_Z1, 1, -1, TF_RIGHT, STR_OFF, OP_OPAQUE);
			}

			// Level D Locks Required:			
			Screen->DrawString(6, 8+1, 88 + 1, FONT_Z1, 2, 0, TF_NORMAL, STR_KEYS, OP_OPAQUE);
			if (RememberStuff[REMEMBER_RANDO_OPTIONS+4]) Screen->DrawString(6, 248+1, 88 + 1, FONT_Z1, 2, 0, TF_RIGHT, STR_ON, OP_OPAQUE);
			else Screen->DrawString(6, 248+1, 88 + 1, FONT_Z1, 2, 0, TF_RIGHT, STR_OFF, OP_OPAQUE);
			if (selected == -7) 
			{
				Screen->DrawString(6, 8, 88, FONT_Z1, 1, -1, TF_NORMAL, STR_KEYS, OP_OPAQUE);
				if (RememberStuff[REMEMBER_RANDO_OPTIONS+4]) Screen->DrawString(6, 248, 88, FONT_Z1, 1, -1, TF_RIGHT, STR_ON, OP_OPAQUE);
				else Screen->DrawString(6, 248, 88, FONT_Z1, 1, -1, TF_RIGHT, STR_OFF, OP_OPAQUE);
			}

			// Random 'Bet You'd Like'		
			Screen->DrawString(6, 8+1, 96 + 1, FONT_Z1, 2, 0, TF_NORMAL, STR_BETU, OP_OPAQUE);
			if (RememberStuff[REMEMBER_RANDO_OPTIONS+5]) Screen->DrawString(6, 248+1, 96 + 1, FONT_Z1, 2, 0, TF_RIGHT, STR_ON, OP_OPAQUE);
			else Screen->DrawString(6, 248+1, 96 + 1, FONT_Z1, 2, 0, TF_RIGHT, STR_OFF, OP_OPAQUE);
			if (selected == -8) 
			{
				Screen->DrawString(6, 8, 96, FONT_Z1, 1, -1, TF_NORMAL, STR_BETU, OP_OPAQUE);
				if (RememberStuff[REMEMBER_RANDO_OPTIONS+5]) Screen->DrawString(6, 248, 96, FONT_Z1, 1, -1, TF_RIGHT, STR_ON, OP_OPAQUE);
				else Screen->DrawString(6, 248, 96, FONT_Z1, 1, -1, TF_RIGHT, STR_OFF, OP_OPAQUE);
			}

			// Random 'Take Only One'			
			Screen->DrawString(6, 8+1, 104 + 1, FONT_Z1, 2, 0, TF_NORMAL, STR_TAKE, OP_OPAQUE);
			if (RememberStuff[REMEMBER_RANDO_OPTIONS+6]) Screen->DrawString(6, 248+1, 104 + 1, FONT_Z1, 2, 0, TF_RIGHT, STR_ON, OP_OPAQUE);
			else Screen->DrawString(6, 248+1, 104 + 1, FONT_Z1, 2, 0, TF_RIGHT, STR_OFF, OP_OPAQUE);
			if (selected == -9) 
			{
				Screen->DrawString(6, 8, 104, FONT_Z1, 1, -1, TF_NORMAL, STR_TAKE, OP_OPAQUE);
				if (RememberStuff[REMEMBER_RANDO_OPTIONS+6]) Screen->DrawString(6, 248, 104, FONT_Z1, 1, -1, TF_RIGHT, STR_ON, OP_OPAQUE);
				else Screen->DrawString(6, 248, 104, FONT_Z1, 1, -1, TF_RIGHT, STR_OFF, OP_OPAQUE);
			}
			
			// Random First Weapon
			Screen->DrawString(6, 8+1, 112 + 1, FONT_Z1, 2, 0, TF_NORMAL, STR_SWRD, OP_OPAQUE);
			if (RememberStuff[REMEMBER_RANDO_OPTIONS+7]) Screen->DrawString(6, 248+1, 112 + 1, FONT_Z1, 2, 0, TF_RIGHT, STR_ON, OP_OPAQUE);
			else Screen->DrawString(6, 248+1, 112 + 1, FONT_Z1, 2, 0, TF_RIGHT, STR_OFF, OP_OPAQUE);
			if (selected == -10) 
			{
				Screen->DrawString(6, 8, 112, FONT_Z1, 1, -1, TF_NORMAL, STR_SWRD, OP_OPAQUE);
				if (RememberStuff[REMEMBER_RANDO_OPTIONS+7]) Screen->DrawString(6, 248, 112, FONT_Z1, 1, -1, TF_RIGHT, STR_ON, OP_OPAQUE);
				else Screen->DrawString(6, 248, 112, FONT_Z1, 1, -1, TF_RIGHT, STR_OFF, OP_OPAQUE);
			}

			// Heart Container Size			
			Screen->DrawString(6, 8+1, 120 + 1, FONT_Z1, 2, 0, TF_NORMAL, STR_HRTS, OP_OPAQUE);
			if (RememberStuff[REMEMBER_RANDO_OPTIONS+9]) Screen->DrawString(6, 248+1, 120 + 1, FONT_Z1, 2, 0, TF_RIGHT, STR_ON, OP_OPAQUE);
			else Screen->DrawString(6, 248+1, 120 + 1, FONT_Z1, 2, 0, TF_RIGHT, STR_OFF, OP_OPAQUE);
			if (selected == -11) 
			{
				Screen->DrawString(6, 8, 120, FONT_Z1, 1, -1, TF_NORMAL, STR_HRTS, OP_OPAQUE);
				if (RememberStuff[REMEMBER_RANDO_OPTIONS+9]) Screen->DrawString(6, 248, 120, FONT_Z1, 1, -1, TF_RIGHT, STR_ON, OP_OPAQUE);
				else Screen->DrawString(6, 248, 120, FONT_Z1, 1, -1, TF_RIGHT, STR_OFF, OP_OPAQUE);
			}

			// Randomisze Rupy Caves		
			Screen->DrawString(6, 8+1, 128 + 1, FONT_Z1, 2, 0, TF_NORMAL, STR_RUPY, OP_OPAQUE);
			if (RememberStuff[REMEMBER_RANDO_OPTIONS+10]) Screen->DrawString(6, 248+1, 128 + 1, FONT_Z1, 2, 0, TF_RIGHT, STR_ON, OP_OPAQUE);
			else Screen->DrawString(6, 248+1, 128 + 1, FONT_Z1, 2, 0, TF_RIGHT, STR_OFF, OP_OPAQUE);
			if (selected == -12) 
			{
				Screen->DrawString(6, 8, 128, FONT_Z1, 1, -1, TF_NORMAL, STR_RUPY, OP_OPAQUE);
				if (RememberStuff[REMEMBER_RANDO_OPTIONS+10]) Screen->DrawString(6, 248, 128, FONT_Z1, 1, -1, TF_RIGHT, STR_ON, OP_OPAQUE);
				else Screen->DrawString(6, 248, 128, FONT_Z1, 1, -1, TF_RIGHT, STR_OFF, OP_OPAQUE);
			}

			// Random Potion Shops 			
			Screen->DrawString(6, 8+1, 136 + 1, FONT_Z1, 2, 0, TF_NORMAL, STR_POTS, OP_OPAQUE);
			if (RememberStuff[REMEMBER_RANDO_OPTIONS+11]) Screen->DrawString(6, 248+1, 136 + 1, FONT_Z1, 2, 0, TF_RIGHT, STR_ON, OP_OPAQUE);
			else Screen->DrawString(6, 248+1, 136 + 1, FONT_Z1, 2, 0, TF_RIGHT, STR_OFF, OP_OPAQUE);
			if (selected == -13) 
			{
				Screen->DrawString(6, 8, 136, FONT_Z1, 1, -1, TF_NORMAL, STR_POTS, OP_OPAQUE);
				if (RememberStuff[REMEMBER_RANDO_OPTIONS+11]) Screen->DrawString(6, 248, 136, FONT_Z1, 1, -1, TF_RIGHT, STR_ON, OP_OPAQUE);
				else Screen->DrawString(6, 248, 136, FONT_Z1, 1, -1, TF_RIGHT, STR_OFF, OP_OPAQUE);
			}

			// Spoiler Log
			Screen->DrawString(6, 8+1, 144 + 1, FONT_Z1, 2, 0, TF_NORMAL, STR_SPOILERLOG, OP_OPAQUE);
			if (!RememberStuff[REMEMBER_RANDO_OPTIONS+12]) Screen->DrawString(6, 248+1, 144 + 1, FONT_Z1, 2, 0, TF_RIGHT, STR_EX3, OP_OPAQUE);
			else Screen->DrawString(6, 248+1, 144 + 1, FONT_Z1, 2, 0, TF_RIGHT, STR_HIDDEN, OP_OPAQUE);
			if (selected == -14)
			{
				Screen->DrawString(6, 8, 144, FONT_Z1, 1, -1, TF_NORMAL, STR_SPOILERLOG, OP_OPAQUE);
				if (!RememberStuff[REMEMBER_RANDO_OPTIONS+12]) Screen->DrawString(6, 248, 144, FONT_Z1, 1, -1, TF_RIGHT, STR_EX3, OP_OPAQUE);
				else Screen->DrawString(6, 248, 144, FONT_Z1, 1, -1, TF_RIGHT, STR_HIDDEN, OP_OPAQUE);
			}
			for(i = 0; i < 4; ++i)
			{
				if (Link->PressB) 
				{
					if (selected >= 0) digits[i] = Rand(16);
				}
				while(digits[i] >= 16) digits[i]-=16;
				while(digits[i] < 0) digits[i]+=16;
				if(digits[i]<10)
					Screen->DrawCharacter(6, 136+8*i+1, 32+1, FONT_Z1, 0x06, 0x0F, -1, -1, '0'+digits[i], 128);
				else
					Screen->DrawCharacter(6, 136+8*i+1, 32+1, FONT_Z1, 0x06, 0x0F, -1, -1, 'A'+digits[i]-10, 128);
				if (i == selected || (selected == -1 && !Link->PressA))
				{
					if(digits[i]<10)
						Screen->DrawCharacter(6, 136+8*i, 32, FONT_Z1, 0x01, 0x0F, -1, -1, '0'+digits[i], 128);
					else
						Screen->DrawCharacter(6, 136+8*i, 32, FONT_Z1, 0x01, 0x0F, -1, -1, 'A'+digits[i]-10, 128);
				}
			}
			Link->PressStart = false;
			Link->InputStart = false;
			WaitNoAction();
		}
		for (i = 0; i < 4; ++i) RememberStuff[REMEMBER_SEED1+i] = digits[i];
		XORShift_SetSeed(digits[0] + (digits[1]*16), digits[2] + (digits[3]*16));
		int scr[] = "DoRandStuff";
		int sid = Game->GetFFCScript(scr);
		ffc f;
		for ( int q = 1; q <= 32; ++q )
		{
			f = Screen->LoadFFC(q);
			if ( f->Script ) continue;
			if ( f->Data ) continue;
			if ( q )
			{
				f->Data = 1;
				f->Script = Game->GetFFCScript(scr);
				break;
			}
		}
		while(true)
		{
			for(i = 0; i < 4; ++i)
			{
				if(digits[i]<10)
					Screen->DrawCharacter(6, 108+8*i+1, 32+1, FONT_Z1, 0x06, 0x0F, -1, -1, '0'+digits[i], 128);
				else
					Screen->DrawCharacter(6, 108+8*i+1, 32+1, FONT_Z1, 0x06, 0x0F, -1, -1, 'A'+digits[i]-10, 128);
			}
			Link->PressStart = false;
			Link->InputStart = false;
			WaitNoAction();
		}
	}
}

item script SuperbombSummon
{
	void run(int cost)
	{
		if (Game->Counter[CR_RUPEES] >= cost && !Link->Item[I_LTTPSBOMB])
		{
			Game->DCounter[CR_RUPEES] -= cost;
			Partner[FOLLOW_STATE] = 0;
			Link->Item[I_LTTPSBOMB] = true;
		}
	}
}

item script Clockspell
{
	void run(int cost)
	{
		if (Game->Counter[CR_RUPEES] >= cost)
		{
			Game->DCounter[CR_RUPEES] -= cost;
			item MakeClock = CreateItemAt(I_MEDICINECLOCK,Link->X,Link->Y);
			MakeClock->Z = Link->Z;
			MakeClock->HitWidth = 32;
			MakeClock->HitHeight = 32;
			MakeClock->HitXOffset = -8;
			MakeClock->HitYOffset = -8;
		}
	}
}

item script Shieldspell
{
	void run(int cost)
	{
		if (Game->Counter[CR_RUPEES] >= cost)
		{
			Game->DCounter[CR_RUPEES] -= cost;
			Game->DCounter[CR_ACORNS] += 16;
		}
	}
}

item script ProgressiveTriforce
{
	void run()
	{
		for (int i = 1; i <= 8; ++i)
		{
			if (Game->LItems[i] & LI_TRIFORCE) continue;
			Game->LItems[i] |= LI_TRIFORCE;
			int Z1Music[32] = "zelda.nsf";
			Game->PlayEnhancedMusic(Z1Music,6);
			Quit();
		}
	}
}

ffc script DebugMenu
{
	void run()
	{
		if (!IsRandomizer()) Quit();
		int itemsT[176];
		int itemsC[176];
		item randoItem;
		int timer = 0;
		int i;
		for (i = 1; i < 176; ++i)
		{
			if (RememberStuff[REMEMBER_RANDOSTART + i] > 0)
			{
				randoItem = Screen->CreateItem(RememberStuff[REMEMBER_RANDOSTART + i]);
				randoItem->HitYOffset = -1000;
				randoItem->DrawYOffset = -1000;
				itemsT[i] = randoItem->Tile;
				itemsC[i] = randoItem->CSet;
				Remove(randoItem);
			}
			else itemsT[i] = 0;
		}
		while(true)
		{
			if (LinkCollision(this)) 
			{
				if (timer < 100) ++timer;
			}
			else if (timer > 0) --timer;
			if (timer == 100)
			{
				for (i = 1; i < 176; ++i)
				{
					if (itemsT[i] > 0) Screen->FastTile(6, ComboX(i-1), ComboY(i-1), itemsT[i], itemsC[i], OP_OPAQUE);
				}
				for(i = 0; i < 4; ++i)
				{
					if(RememberStuff[REMEMBER_SEED1+i]<10)
						Screen->DrawCharacter(7, 222+8*i, -54, FONT_Z1, 0x06, 0x0F, -1, -1, '0'+RememberStuff[REMEMBER_SEED1+i], 128);
					else
						Screen->DrawCharacter(7, 222+8*i, -54, FONT_Z1, 0x06, 0x0F, -1, -1, 'A'+RememberStuff[REMEMBER_SEED1+i]-10, 128);
				}
			}
			else if (timer > 90)
			{
				for (i = 1; i < 176; ++i)
				{
					if (itemsT[i] > 0) Screen->FastTile(6, ComboX(i-1), ComboY(i-1), itemsT[i], itemsC[i], OP_TRANS);
				}
			}
			Waitframe();
		}
	}
}


ffc script SpoilerLogAnywhere
{
	void run()
	{
		Link->PressEx3 = false;
		Link->InputEx3 = false;
		if (!IsRandomizer()) Quit();
		int itemsT[176];
		int itemsC[176];
		item randoItem;
		int timer = 0;
		int i;
		int Explanation[33] = "See Mitsukarand.txt to decipher";
		int SaySeed[6] = "SEED:";

		for (i = 1; i < 176; ++i)
		{
			if (RememberStuff[REMEMBER_RANDOSTART + i] > 0)
			{
				randoItem = Screen->CreateItem(RememberStuff[REMEMBER_RANDOSTART + i]);
				randoItem->HitYOffset = -1000;
				randoItem->DrawYOffset = -1000;
				itemsT[i] = randoItem->Tile;
				itemsC[i] = randoItem->CSet;
				Remove(randoItem);
			}
			else itemsT[i] = 0;
		}
		while(true)
		{
			Screen->Rectangle(
				6,		//layer
				0,		//start X
				0,		//start y
				256,		//end x
				176,		//end y
				0,1,0,0,0,true,128);	

			Screen->DrawString(6, 8, 160, FONT_Z1, 1, 0, TF_NORMAL, Explanation, OP_OPAQUE);

			for (i = 1; i < 176; ++i)
			{
				if (itemsT[i] > 0) Screen->FastTile(6, ComboX(i-1), ComboY(i-1), itemsT[i], itemsC[i], OP_OPAQUE);
			}

			Screen->DrawString(7, 174, -54, FONT_Z1, 6, 0, TF_NORMAL, SaySeed, OP_OPAQUE);
			for(i = 0; i < 4; ++i)
			{
				if(RememberStuff[REMEMBER_SEED1+i]<10)
					Screen->DrawCharacter(7, 222+8*i, -54, FONT_Z1, 0x06, 0x0F, -1, -1, '0'+RememberStuff[REMEMBER_SEED1+i], 128);
				else
					Screen->DrawCharacter(7, 222+8*i, -54, FONT_Z1, 0x06, 0x0F, -1, -1, 'A'+RememberStuff[REMEMBER_SEED1+i]-10, 128);
			}
			Waitframe();
			if (Link->PressEx3)
			{
				Link->PressEx3 = false;
				Link->InputEx3 = false;
				RememberStuff[REMEMBER_EX3_SPOILERLOG] = 1;
				this->Data = 0;
				this->Script = 0;
				Quit();
			}
		}
	}
}